# import cv2
# import numpy as np
# import easyocr
# from typing import List, Dict, Any, Tuple
# import logging

# # Configure logging
# logging.basicConfig(level=logging.INFO)
# logger = logging.getLogger(__name__)

# class OCRProcessor:
#     def __init__(self, languages=["en", "ar"], gpu=False):
#         """
#         Initialize OCR processor with EasyOCR
        
#         Args:
#             languages: List of languages to support
#             gpu: Whether to use GPU acceleration
#         """
#         self.languages = languages
#         self.gpu = gpu
#         self.reader = None
#         # تحديد ما إذا كانت اللغة العربية (RTL) مدعومة
#         self.is_rtl = "ar" in languages
        
#     def initialize(self):
#         """
#         Initialize the OCR reader
#         """
#         try:
#             self.reader = easyocr.Reader(self.languages, gpu=self.gpu)
#             logger.info(f"OCR initialized with languages: {self.languages}, RTL mode: {self.is_rtl}")
#             return True
#         except Exception as e:
#             logger.error(f"Failed to initialize OCR: {e}")
#             return False
    
#     def preprocess_image(self, image: np.ndarray) -> np.ndarray:
#         """
#         Preprocess image for better OCR results
#         """
#         if len(image.shape) == 3:
#             gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
#         else:
#             gray = image.copy()
        
#         blurred = cv2.GaussianBlur(gray, (3, 3), 0)
#         thresh = cv2.adaptiveThreshold(
#             blurred, 255, cv2.ADAPTIVE_THRESH_GAUSSIAN_C, cv2.THRESH_BINARY, 11, 2
#         )
#         return thresh

#     def group_lines(self, detections: List[Dict[str, Any]], y_tolerance: int = 15, is_rtl: bool = False) -> List[str]:
#         """
#         Groups detected text boxes into lines and orders them correctly.

#         Args:
#             detections: List of detected text from EasyOCR.
#             y_tolerance: The maximum vertical distance to consider texts on the same line.
#             is_rtl: If True, sort text from right-to-left.

#         Returns:
#             A list of strings, where each string is a fully formed line.
#         """
#         if not detections:
#             return []

#         # حساب المركز الرأسي لكل مربع نص
#         for det in detections:
#             bbox = det['bbox']
#             det['y_center'] = (bbox['y1'] + bbox['y2']) / 2

#         # فرز الاكتشافات من الأعلى إلى الأسفل بناءً على المركز الرأسي
#         detections.sort(key=lambda d: d['y_center'])

#         lines = []
#         current_line = []
#         if detections:
#             current_line.append(detections[0])
#             for i in range(1, len(detections)):
#                 # التحقق مما إذا كان المربع الحالي ينتمي إلى نفس السطر
#                 y_diff = abs(detections[i]['y_center'] - current_line[-1]['y_center'])
#                 if y_diff < y_tolerance:
#                     current_line.append(detections[i])
#                 else:
#                     lines.append(current_line)
#                     current_line = [detections[i]]
#             lines.append(current_line) # إضافة السطر الأخير

#         # تجميع النصوص وترتيبها داخل كل سطر
#         grouped_lines = []
#         for line in lines:
#             # ترتيب الكلمات داخل السطر أفقيًا
#             # للغة العربية (RTL)، نرتب من اليمين إلى اليسار (تنازليًا حسب x)
#             # للغات الأخرى (LTR)، نرتب من اليسار إلى اليمين (تصاعديًا حسب x)
#             line.sort(key=lambda d: d['bbox']['x1'], reverse=is_rtl)
            
#             # تجميع نصوص السطر في جملة واحدة
#             full_line = " ".join([d['text'] for d in line])
#             grouped_lines.append(full_line)
            
#         return grouped_lines

#     def detect_text(self, image: np.ndarray, preprocess: bool = True) -> List[str]:
#         """
#         Detect text in image, group it into lines, and return the lines.
        
#         Args:
#             image: Input image
#             preprocess: Whether to preprocess the image
            
#         Returns:
#             List of detected lines (strings).
#         """
#         if self.reader is None:
#             if not self.initialize():
#                 return []
        
#         try:
#             processed_image = self.preprocess_image(image) if preprocess else image
            
#             # 1. الحصول على النتائج الأولية من EasyOCR
#             raw_results = self.reader.readtext(processed_image)
            
#             # 2. تنسيق النتائج الأولية
#             detections = []
#             for bbox, text, confidence in raw_results:
#                 x_coords = [point[0] for point in bbox]
#                 y_coords = [point[1] for point in bbox]
#                 x1, y1 = min(x_coords), min(y_coords)
#                 x2, y2 = max(x_coords), max(y_coords)
                
#                 detections.append({
#                     "text": text,
#                     "confidence": float(confidence),
#                     "bbox": {"x1": float(x1), "y1": float(y1), "x2": float(x2), "y2": float(y2)}
#                 })
            
#             # 3. تجميع النصوص في أسطر مع الترتيب الصحيح
#             grouped_lines = self.group_lines(detections, is_rtl=self.is_rtl)
            
#             return grouped_lines
            
#         except Exception as e:
#             logger.error(f"Error during text detection: {e}")
#             return []

# # --- دوال الواجهة العامة ---

# ocr_processor_instance = None

# def initialize_ocr_models(languages=["en", "ar"], gpu=False):
#     """
#     Initialize OCR models
#     """
#     global ocr_processor_instance
#     try:
#         ocr_processor_instance = OCRProcessor(languages=languages, gpu=gpu)
#         if ocr_processor_instance.initialize():
#             logger.info("OCR models initialized successfully")
#             return ocr_processor_instance
#         else:
#             logger.error("Failed to initialize OCR models")
#             return None
#     except Exception as e:
#         logger.error(f"Error initializing OCR models: {e}")
#         return None

# def process_image_for_ocr(image: np.ndarray, ocr_models=None) -> List[str]:
#     """
#     Process image for OCR detection and return grouped lines.
#     """
#     global ocr_processor_instance
    
#     if ocr_models is not None:
#         processor = ocr_models
#     elif ocr_processor_instance is not None:
#         processor = ocr_processor_instance
#     else:
#         processor = initialize_ocr_models()
#         if processor is None:
#             return []
    
#     # استدعاء الدالة الرئيسية التي تقوم بالكشف والتجميع
#     return processor.detect_text(image)








#test
# import cv2
# import numpy as np
# import easyocr
# from typing import List, Dict, Any
# import logging

# # Configure logging
# logging.basicConfig(level=logging.INFO)
# logger = logging.getLogger(__name__)

# class OCRProcessor:
#     def __init__(self, languages=["en", "ar"], gpu=False):
#         self.languages = languages
#         self.gpu = gpu
#         self.reader = None
#         self.is_rtl = "ar" in languages
        
#     def initialize(self):
#         try:
#             self.reader = easyocr.Reader(self.languages, gpu=self.gpu)
#             logger.info(f"OCR initialized with languages: {self.languages}, RTL mode: {self.is_rtl}")
#             return True
#         except Exception as e:
#             logger.error(f"Failed to initialize OCR: {e}")
#             return False
    
#     def preprocess_image(self, image: np.ndarray) -> np.ndarray:
#         gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) if len(image.shape) == 3 else image.copy()
#         blurred = cv2.GaussianBlur(gray, (3,3), 0)
#         thresh = cv2.adaptiveThreshold(blurred, 255, cv2.ADAPTIVE_THRESH_GAUSSIAN_C,
#                                        cv2.THRESH_BINARY, 11, 2)
#         return thresh
    
#     def group_lines(self, detections: List[Dict[str, Any]], y_tolerance: int = 15) -> List[Dict[str, Any]]:
#         if not detections:
#             return []

#         for det in detections:
#             bbox = det['bbox']
#             det['y_center'] = (bbox['y1'] + bbox['y2']) / 2

#         detections.sort(key=lambda d: d['y_center'])

#         lines = []
#         current_line = [detections[0]] if detections else []

#         for det in detections[1:]:
#             y_diff = abs(det['y_center'] - current_line[-1]['y_center'])
#             if y_diff < y_tolerance:
#                 current_line.append(det)
#             else:
#                 lines.append(current_line)
#                 current_line = [det]
#         if current_line:
#             lines.append(current_line)

#         grouped_lines = []
#         for line in lines:
#             is_rtl = any("ar" in det.get("language", "") for det in line)
#             line.sort(key=lambda d: d['bbox']['x1'], reverse=is_rtl)
#             full_line = " ".join([d['text'] for d in line])
#             grouped_lines.append({
#                 "text": full_line,
#                 "words": line  # كل كلمة مع bbox وconfidence
#             })
#         return grouped_lines

#     def detect_text_in_roi(self, roi_image: np.ndarray) -> List[Dict[str, Any]]:
#         if self.reader is None and not self.initialize():
#             return []

#         try:
#             processed_image = self.preprocess_image(roi_image)
#             raw_results = self.reader.readtext(processed_image)
#             detections = []
#             for bbox, text, confidence in raw_results:
#                 x_coords = [point[0] for point in bbox]
#                 y_coords = [point[1] for point in bbox]
#                 x1, y1 = min(x_coords), min(y_coords)
#                 x2, y2 = max(x_coords), max(y_coords)
#                 detections.append({
#                     "text": text,
#                     "confidence": float(confidence),
#                     "bbox": {"x1": float(x1), "y1": float(y1), "x2": float(x2), "y2": float(y2)}
#                 })
#             return detections
#         except Exception as e:
#             logger.error(f"Error during text detection in ROI: {e}")
#             return []

# # -------------------------------------------------
# # --- YOLO text detector integration ------------
# # -------------------------------------------------
# class YOLOTextDetector:
#     def __init__(self, model_path: str):
#         from ultralytics import YOLO
#         self.model = YOLO(model_path)

#     def detect_text_boxes(self, image: np.ndarray) -> List[Dict[str, Any]]:
#         results = self.model.predict(image)
#         boxes = []
#         for result in results:
#             for bbox in result.boxes.xyxy:
#                 x1, y1, x2, y2 = map(int, bbox)
#                 boxes.append({"bbox": {"x1": x1, "y1": y1, "x2": x2, "y2": y2}})
#         return boxes

# # -------------------------------------------------
# # --- Main combined function ---------------------
# # -------------------------------------------------
# ocr_processor_instance = None

# def initialize_ocr_models(languages=["en", "ar"], gpu=False):
#     global ocr_processor_instance
#     ocr_processor_instance = OCRProcessor(languages=languages, gpu=gpu)
#     if ocr_processor_instance.initialize():
#         return ocr_processor_instance
#     return None

# def process_image_with_yolo_then_ocr(image: np.ndarray,
#                                      yolo_text_detector: YOLOTextDetector,
#                                      ocr_processor: OCRProcessor) -> List[Dict[str, Any]]:
#     if yolo_text_detector is None or ocr_processor is None:
#         return []

#     text_boxes = yolo_text_detector.detect_text_boxes(image)
#     all_detections = []

#     for box in text_boxes:
#         bbox = box['bbox']
#         roi = image[bbox['y1']:bbox['y2'], bbox['x1']:bbox['x2']]
#         ocr_results = ocr_processor.detect_text_in_roi(roi)
#         # تحويل الاحداثيات الى الصورة الكاملة
#         for det in ocr_results:
#             det['bbox']['x1'] += bbox['x1']
#             det['bbox']['x2'] += bbox['x1']
#             det['bbox']['y1'] += bbox['y1']
#             det['bbox']['y2'] += bbox['y1']
#         all_detections.extend(ocr_results)

#     grouped_lines = ocr_processor.group_lines(all_detections)
#     return grouped_lines






# #test for yolov8 text detection
# import cv2
# import numpy as np
# import easyocr
# from ultralytics import YOLO  # <-- إضافة مكتبة YOLO
# from typing import List, Dict, Any
# import logging

# # Configure logging
# logging.basicConfig(level=logging.INFO)
# logger = logging.getLogger(__name__)


# YOLO_MODEL_PATH = 'C:/Users/HP/Desktop/Basiraty app/text_detection/best_textFinalTrain.pt'

# class OCRProcessor:
#     def __init__(self, yolo_model_path=YOLO_MODEL_PATH, languages=["en", "ar"], gpu=False):

#         self.yolo_model_path = yolo_model_path
#         self.languages = languages
#         self.gpu = gpu
#         self.yolo_model = None  
#         self.reader = None     
#         self.is_rtl = "ar" in languages
        
#     def initialize(self):

#         try:
#             # 1. تهيئة YOLOv8
#             self.yolo_model = YOLO(self.yolo_model_path)
#             logger.info(f"YOLOv8 model loaded successfully from: {self.yolo_model_path}")

#             # 2. تهيئة EasyOCR
#             self.reader = easyocr.Reader(self.languages, gpu=self.gpu)
#             logger.info(f"EasyOCR initialized with languages: {self.languages}, RTL mode: {self.is_rtl}")
#             return True
#         except Exception as e:
#             logger.error(f"Failed to initialize models: {e}")
#             return False
    
#     def detect_text_regions_yolo(self, image: np.ndarray) -> List[Dict[str, int]]:

#         if self.yolo_model is None:
#             logger.error("YOLOv8 model is not initialized.")
#             return []

#         results = self.yolo_model(image, conf=0.3) 
        
#         bboxes = []
#         for result in results:
#             for box in result.boxes:
#                 x1, y1, x2, y2 = map(int, box.xyxy[0])
#                 bboxes.append({'x1': x1, 'y1': y1, 'x2': x2, 'y2': y2})
        
#         logger.info(f"YOLOv8 detected {len(bboxes)} text regions.")
#         return bboxes

#     def recognize_text_in_regions(self, image: np.ndarray, bboxes: List[Dict[str, int]]) -> List[Dict[str, Any]]:

#         if self.reader is None:
#             logger.error("EasyOCR reader is not initialized.")
#             return []
            
#         detections = []
#         for bbox in bboxes:
#             x1, y1, x2, y2 = bbox['x1'], bbox['y1'], bbox['x2'], bbox['y2']
            
#             cropped_image = image[y1:y2, x1:x2]
            
#             if cropped_image.size == 0:
#                 continue

#             ocr_results = self.reader.readtext(cropped_image, detail=1)
            
#             if ocr_results:
               
#                 full_text = " ".join([res[1] for res in ocr_results])
                
               
#                 detections.append({
#                     "text": full_text,
#                     "confidence": np.mean([res[2] for res in ocr_results]),
#                     "bbox": {"x1": float(x1), "y1": float(y1), "x2": float(x2), "y2": float(y2)}
#                 })
        
#         logger.info(f"EasyOCR recognized text in {len(detections)} regions.")
#         return detections

#     def group_lines(self, detections: List[Dict[str, Any]], y_tolerance: int = 20, is_rtl: bool = False) -> List[str]:

#         if not detections:
#             return []

#         for det in detections:
#             bbox = det['bbox']
#             det['y_center'] = (bbox['y1'] + bbox['y2']) / 2

#         detections.sort(key=lambda d: d['y_center'])

#         lines = []
#         current_line = []
#         if detections:
#             current_line.append(detections[0])
#             for i in range(1, len(detections)):
#                 y_diff = abs(detections[i]['y_center'] - np.mean([d['y_center'] for d in current_line]))
#                 if y_diff < y_tolerance:
#                     current_line.append(detections[i])
#                 else:
#                     lines.append(current_line)
#                     current_line = [detections[i]]
#             lines.append(current_line)

#         # grouped_lines = []
#         # for line in lines:
#         #     line.sort(key=lambda d: d['bbox']['x1'], reverse=is_rtl)
#         #     full_line = " ".join([d['text'] for d in line])
#         #     grouped_lines.append(full_line)

#         grouped_lines = []
# # التعديل الرئيسي في دالة group_lines (السطر 121 وما يليه في الكود المعدل):
#         for line in lines:
#             # Determine if the line is RTL (Arabic) or LTR (English/other)
#             line_text = " ".join([d['text'] for d in line])
#             # Simple heuristic: if any Arabic character is present, treat as RTL for sorting
#             sort_rtl = any('\u0600' <= char <= '\u06FF' for char in line_text)
            
#             # Sort based on the determined direction
#             # RTL (Arabic) means sorting by x1 in descending order (reverse=True)
#             # LTR (English) means sorting by x1 in ascending order (reverse=False)
#             line.sort(key=lambda d: d['bbox']['x1'], reverse=sort_rtl)
            
#             full_line = " ".join([d['text'] for d in line])
#             grouped_lines.append(full_line)

            
#         return grouped_lines

#     def detect_and_read_text(self, image: np.ndarray) -> List[str]:

#         if self.reader is None or self.yolo_model is None:
#             if not self.initialize():
#                 return []
        
#         try:
           
#             text_regions = self.detect_text_regions_yolo(image)
            
            
#             detections = self.recognize_text_in_regions(image, text_regions)
            
            
#             grouped_lines = self.group_lines(detections, is_rtl=self.is_rtl)
            
#             return grouped_lines
            
#         except Exception as e:
#             logger.error(f"Error during the combined detection and recognition process: {e}")
#             return []



# ocr_processor_instance = None

# def initialize_ocr_models(yolo_model_path=YOLO_MODEL_PATH, languages=["en", "ar"], gpu=False):

#     global ocr_processor_instance
#     try:
#         ocr_processor_instance = OCRProcessor(yolo_model_path=yolo_model_path, languages=languages, gpu=gpu)
#         if ocr_processor_instance.initialize():
#             logger.info("OCR models initialized successfully")
#             return ocr_processor_instance
#         else:
#             logger.error("Failed to initialize OCR models")
#             return None
#     except Exception as e:
#         logger.error(f"Error initializing OCR models: {e}")
#         return None

# def process_image_for_ocr(image: np.ndarray, ocr_models=None) -> List[str]:
#     """
#     Process image for OCR detection and return grouped lines.
#     """
#     global ocr_processor_instance
    
#     if ocr_models is not None:
#         processor = ocr_models
#     elif ocr_processor_instance is not None:
#         processor = ocr_processor_instance
#     else:
#         processor = initialize_ocr_models()
#         if processor is None:
#             return []
    

#     return processor.detect_and_read_text(image)



# ocr_processor.py

import cv2
import numpy as np
import easyocr
from ultralytics import YOLO
from typing import List, Dict, Any
import logging

logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
logger = logging.getLogger(__name__)

YOLO_MODEL_PATH = 'best_textFinalTrain.pt'

class OCRProcessor:
    def __init__(self, yolo_model_path=YOLO_MODEL_PATH, gpu=False):
        self.yolo_model_path = yolo_model_path
        self.gpu = gpu
        self.yolo_model = None
        self.ar_reader = None
        self.en_reader = None
        
    def initialize(self):
        try:
            self.yolo_model = YOLO(self.yolo_model_path)
            logger.info("YOLOv8 model loaded.")
            self.ar_reader = easyocr.Reader(['ar'], gpu=self.gpu)
            logger.info("Arabic-only reader initialized.")
            self.en_reader = easyocr.Reader(['en'], gpu=self.gpu)
            logger.info("English-only reader initialized.")
            return True
        except Exception as e:
            logger.error(f"Failed to initialize models: {e}")
            return False

    # --- *** دالة المعالجة المسبقة المحسنة *** ---
    def preprocess_image(self, image: np.ndarray, scale_factor: float = 1.5) -> np.ndarray:
        # 1. التكبير
        width = int(image.shape[1] * scale_factor)
        height = int(image.shape[0] * scale_factor)
        resized_image = cv2.resize(image, (width, height), interpolation=cv2.INTER_CUBIC)
        
        # 2. التحويل إلى الرمادي
        gray = cv2.cvtColor(resized_image, cv2.COLOR_BGR2GRAY)
        
        # 3. تحسين التباين باستخدام CLAHE
        clahe = cv2.createCLAHE(clipLimit=2.0, tileGridSize=(8,8))
        contrast_enhanced = clahe.apply(gray)
        
        # 4. تطبيق تنعيم خفيف لإزالة الضوضاء
        blurred = cv2.GaussianBlur(contrast_enhanced, (3, 3), 0)
        
       
        return cv2.cvtColor(blurred, cv2.COLOR_GRAY2BGR) 
    
    def detect_text_regions_yolo(self, image: np.ndarray) -> List[Dict[str, int]]:
        if self.yolo_model is None: return []
        results = self.yolo_model(image, conf=0.3) 
        bboxes = []
        for result in results:
            for box in result.boxes:
                x1, y1, x2, y2 = map(int, box.xyxy[0])
                bboxes.append({'x1': x1, 'y1': y1, 'x2': x2, 'y2': y2})
        return bboxes

    def apply_nms(self, bboxes: List[Dict[str, int]], iou_threshold: float = 0.3) -> List[Dict[str, int]]:
        if not bboxes: return []
        boxes_coords = np.array([[b['x1'], b['y1'], b['x2'], b['y2']] for b in bboxes])
        area = (boxes_coords[:, 2] - boxes_coords[:, 0]) * (boxes_coords[:, 3] - boxes_coords[:, 1])
        idxs = np.argsort(boxes_coords[:, 3])
        pick = []
        while len(idxs) > 0:
            last = len(idxs) - 1
            i = idxs[last]
            pick.append(i)
            xx1 = np.maximum(boxes_coords[i, 0], boxes_coords[idxs[:last], 0])
            yy1 = np.maximum(boxes_coords[i, 1], boxes_coords[idxs[:last], 1])
            xx2 = np.minimum(boxes_coords[i, 2], boxes_coords[idxs[:last], 2])
            yy2 = np.minimum(boxes_coords[i, 3], boxes_coords[idxs[:last], 3])
            w = np.maximum(0, xx2 - xx1)
            h = np.maximum(0, yy2 - yy1)
            intersection = w * h
            union = area[i] + area[idxs[:last]] - intersection
            iou = intersection / union
            idxs = np.delete(idxs, np.concatenate(([last], np.where(iou > iou_threshold)[0])))
        return [bboxes[i] for i in pick]

    def detect_and_read_text(self, image: np.ndarray) -> List[str]:
        if not all([self.ar_reader, self.en_reader, self.yolo_model]):
            if not self.initialize(): return []

        try:
            processed_image = self.preprocess_image(image)
            all_bboxes_raw = self.detect_text_regions_yolo(processed_image)
            all_bboxes = self.apply_nms(all_bboxes_raw)
            logger.info(f"YOLO detected {len(all_bboxes_raw)} raw boxes, {len(all_bboxes)} kept after NMS.")

            if not all_bboxes: return []

            word_detections = []
            for bbox in all_bboxes:
                x1, y1, x2, y2 = bbox['x1'], bbox['y1'], bbox['x2'], bbox['y2']
                cropped_image = processed_image[y1:y2, x1:x2]
                if cropped_image.size == 0: continue
                
                ar_results = self.ar_reader.readtext(cropped_image, detail=1, paragraph=False)
                en_results = self.en_reader.readtext(cropped_image, detail=1, paragraph=False)
                
                ar_confidence = np.mean([res[2] for res in ar_results]) if ar_results else 0.0
                en_confidence = np.mean([res[2] for res in en_results]) if en_results else 0.0
                
                final_text, lang = "", ""
                
                # ---  إعطاء أفضلية للغة العربية  ---
                if ar_confidence * 1.25 > en_confidence:
                    final_text = " ".join([res[1] for res in ar_results])
                    lang = 'ar'
                elif en_results:
                    final_text = " ".join([res[1] for res in en_results])
                    lang = 'en'
                
                if final_text:
                    word_detections.append({
                        'text': final_text, 'lang': lang, 'x1': x1, 'y_center': (y1 + y2) / 2
                    })
            
            if not word_detections: return []

            word_detections.sort(key=lambda d: d['y_center'])
            
            lines_of_words, final_text_lines = [], []
            if word_detections:
                current_line = [word_detections[0]]
                y_tolerance = 25
                for i in range(1, len(word_detections)):
                    y_diff = abs(word_detections[i]['y_center'] - np.mean([w['y_center'] for w in current_line]))
                    if y_diff < y_tolerance:
                        current_line.append(word_detections[i])
                    else:
                        lines_of_words.append(current_line)
                        current_line = [word_detections[i]]
                lines_of_words.append(current_line)

            for line in lines_of_words:
                if not line: continue
                
                arabic_word_count = sum(1 for word in line if word['lang'] == 'ar')
                is_line_rtl = arabic_word_count > (len(line) / 2)
                
                if is_line_rtl:
                    line.sort(key=lambda w: w['x1'], reverse=True)
                else:
                    line.sort(key=lambda w: w['x1'], reverse=False)
                    
                full_line_text = " ".join([word['text'] for word in line])
                final_text_lines.append(full_line_text)
                logger.info(f"Final Line ({'RTL' if is_line_rtl else 'LTR'}): {full_line_text}")

            return final_text_lines

        except Exception as e:
            logger.error(f"Error in detect_and_read_text: {e}", exc_info=True)
            return []


ocr_processor_instance = None
def initialize_ocr_models(yolo_model_path=YOLO_MODEL_PATH, languages=["en", "ar"], gpu=False):
    global ocr_processor_instance
    try:
        ocr_processor_instance = OCRProcessor(yolo_model_path=yolo_model_path, gpu=gpu)
        if ocr_processor_instance.initialize():
            logger.info("All models initialized successfully.")
            return ocr_processor_instance
        else:
            logger.error("Failed to initialize models.")
            return None
    except Exception as e:
        logger.error(f"Error during model initialization: {e}")
        return None

def process_image_for_ocr(image: np.ndarray, ocr_models=None) -> List[str]:
    if ocr_models is None:
        return ["Error: OCR processor not available."]
    return ocr_models.detect_and_read_text(image)











