<?php

namespace App\Http\Controllers;

use App\Http\Requests\TicketRequest;
use App\Models\Comment;
use App\Models\Product;
use App\Models\Ticket;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TicketController extends Controller
{
    public function index()
    {
        $tickets = Ticket::filter()->get();
        return view('content.pages.tickets.index', compact('tickets'));
    }

    public function create()
    {
        $products = Product::all();
        return view('content.pages.tickets.create', compact('products'));
    }

    public function store(TicketRequest $request)
    {
        $validated =  $request->validated();
        if ($request->hasFile('file')) {
            $validated['file_path'] = $request->file('file')->store('tickets', 'public');
        }
        $validated = Auth::user()->ticketsSubmitted()->create($validated);

        return redirect()->route('tickets')->with('success', 'تم إنشاء التذكرة بنجاح.');
    }

    public function edit(Ticket $ticket)
    {
        $products = Product::all();
        return view('content.pages.tickets.edit', compact('ticket', 'products'));
    }

    public function update(TicketRequest $request, Ticket $ticket)
    {
       $validated = $request->validated();

        if ($request->hasFile('file')) {
            $validated['file_path'] = $request->file('file')->store('tickets', 'public');
        }

        $ticket->update($validated);

        return redirect()->route('tickets')->with('success', 'Ticket updated successfully.');
    }
    public function show(Ticket $ticket)
    {
        return view('content.pages.tickets.show', compact('ticket'));
    }

    public function destroy(Ticket $ticket)
    {
        $ticket->delete();

        return redirect()->route('tickets')->with('success', 'Ticket deleted successfully.');
    }
    public function addComment(Request $request, Ticket $ticket)
    {
        $request->validate([
            'comment' => 'required|string|max:1000',
        ]);
        Auth::user()->comments()->create([
            'ticket_id' => $ticket->id,
            'comment' => $request->comment,
        ]);

        return redirect()->route('tickets.show', $ticket->id)->with('success', 'Comment added successfully.');
    }

    public function updateStatus(Request $request, Ticket $ticket)
    {
        $request->validate([
            'status' => 'required|in:open,in progress,closed,escalated',
        ]);

        $ticket->update(['status' => $request->status]);

        return redirect()->route('tickets.show', $ticket->id)->with('success', 'Status updated successfully.');
    }
}
