<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'phone_number' => '0910000000',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'department' => 'IT'
        ]);

        User::create([
            'name' => 'Manager User',
            'email' => 'manager@example.com',
            'phone_number' => '0920000000',
            'password' => Hash::make('password'),
            'role' => 'manager',
            'department' => 'HR'
        ]);

        User::create([
            'name' => 'Employee User',
            'email' => 'employee@example.com',
            'phone_number' => '0910000001',
            'password' => Hash::make('password'),
            'role' => 'employee',
            'department' => 'Finance and Accounting'
        ]);
    }
}
