import {
  __commonJS
} from "./chunk-WGAPYIUP.js";

// node_modules/mapbox-gl/dist/mapbox-gl.js
var require_mapbox_gl = __commonJS({
  "node_modules/mapbox-gl/dist/mapbox-gl.js"(exports, module) {
    (function(global, factory) {
      typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global = typeof globalThis !== "undefined" ? globalThis : global || self, global.mapboxgl = factory());
    })(exports, function() {
      "use strict";
      var shared, worker, mapboxgl;
      function define2(_, chunk) {
        if (!shared) {
          shared = chunk;
        } else if (!worker) {
          worker = chunk;
        } else {
          var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;";
          var sharedChunk = {};
          shared(sharedChunk);
          mapboxgl = chunk(sharedChunk);
          if (typeof window !== "undefined" && window && window.URL && window.URL.createObjectURL) {
            mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: "text/javascript" }));
          }
        }
      }
      define2(["exports"], function(e) {
        "use strict";
        var t = "undefined" != typeof self ? self : {}, i = "3.0.1";
        let r;
        const n = { API_URL: "https://api.mapbox.com", get API_URL_REGEX() {
          if (null == r) {
            const e2 = /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;
            try {
              r = null != process.env.API_URL_REGEX ? new RegExp(process.env.API_URL_REGEX) : e2;
            } catch (t2) {
              r = e2;
            }
          }
          return r;
        }, get API_TILEJSON_REGEX() {
          return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i;
        }, get API_SPRITE_REGEX() {
          return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i;
        }, get API_FONTS_REGEX() {
          return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i;
        }, get API_STYLE_REGEX() {
          return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i;
        }, get API_CDN_URL_REGEX() {
          return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i;
        }, get EVENTS_URL() {
          if (!n.API_URL)
            return null;
          try {
            const e2 = new URL(n.API_URL);
            return "api.mapbox.cn" === e2.hostname ? "https://events.mapbox.cn/events/v2" : "api.mapbox.com" === e2.hostname ? "https://events.mapbox.com/events/v2" : null;
          } catch (e2) {
            return null;
          }
        }, SESSION_PATH: "/map-sessions/v1", FEEDBACK_URL: "https://apps.mapbox.com/feedback", TILE_URL_VERSION: "v4", RASTER_URL_PREFIX: "raster/v1", REQUIRE_ACCESS_TOKEN: true, ACCESS_TOKEN: null, DEFAULT_STYLE: "mapbox://styles/mapbox/standard", MAX_PARALLEL_IMAGE_REQUESTS: 16, DRACO_URL: "https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm", GLYPHS_URL: "mapbox://fonts/mapbox/{fontstack}/{range}.pbf" }, o = { supported: false, testSupport: function(e2) {
          !l && a && (c ? h(e2) : s = e2);
        } };
        let s, a, l = false, c = false;
        function h(e2) {
          const t2 = e2.createTexture();
          e2.bindTexture(e2.TEXTURE_2D, t2);
          try {
            if (e2.texImage2D(e2.TEXTURE_2D, 0, e2.RGBA, e2.RGBA, e2.UNSIGNED_BYTE, a), e2.isContextLost())
              return;
            o.supported = true;
          } catch (e3) {
          }
          e2.deleteTexture(t2), l = true;
        }
        t.document && (a = t.document.createElement("img"), a.onload = function() {
          s && h(s), s = null, c = true;
        }, a.onerror = function() {
          l = true, s = null;
        }, a.src = "data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");
        const u = "01";
        function d(e2) {
          return e2 && e2.__esModule && Object.prototype.hasOwnProperty.call(e2, "default") ? e2.default : e2;
        }
        var p = f;
        function f(e2, t2, i2, r2) {
          this.cx = 3 * e2, this.bx = 3 * (i2 - e2) - this.cx, this.ax = 1 - this.cx - this.bx, this.cy = 3 * t2, this.by = 3 * (r2 - t2) - this.cy, this.ay = 1 - this.cy - this.by, this.p1x = e2, this.p1y = t2, this.p2x = i2, this.p2y = r2;
        }
        f.prototype = { sampleCurveX: function(e2) {
          return ((this.ax * e2 + this.bx) * e2 + this.cx) * e2;
        }, sampleCurveY: function(e2) {
          return ((this.ay * e2 + this.by) * e2 + this.cy) * e2;
        }, sampleCurveDerivativeX: function(e2) {
          return (3 * this.ax * e2 + 2 * this.bx) * e2 + this.cx;
        }, solveCurveX: function(e2, t2) {
          if (void 0 === t2 && (t2 = 1e-6), e2 < 0)
            return 0;
          if (e2 > 1)
            return 1;
          for (var i2 = e2, r2 = 0; r2 < 8; r2++) {
            var n2 = this.sampleCurveX(i2) - e2;
            if (Math.abs(n2) < t2)
              return i2;
            var o2 = this.sampleCurveDerivativeX(i2);
            if (Math.abs(o2) < 1e-6)
              break;
            i2 -= n2 / o2;
          }
          var s2 = 0, a2 = 1;
          for (i2 = e2, r2 = 0; r2 < 20 && (n2 = this.sampleCurveX(i2), !(Math.abs(n2 - e2) < t2)); r2++)
            e2 > n2 ? s2 = i2 : a2 = i2, i2 = 0.5 * (a2 - s2) + s2;
          return i2;
        }, solve: function(e2, t2) {
          return this.sampleCurveY(this.solveCurveX(e2, t2));
        } };
        var m = d(p), _ = g;
        function g(e2, t2) {
          this.x = e2, this.y = t2;
        }
        g.prototype = { clone: function() {
          return new g(this.x, this.y);
        }, add: function(e2) {
          return this.clone()._add(e2);
        }, sub: function(e2) {
          return this.clone()._sub(e2);
        }, multByPoint: function(e2) {
          return this.clone()._multByPoint(e2);
        }, divByPoint: function(e2) {
          return this.clone()._divByPoint(e2);
        }, mult: function(e2) {
          return this.clone()._mult(e2);
        }, div: function(e2) {
          return this.clone()._div(e2);
        }, rotate: function(e2) {
          return this.clone()._rotate(e2);
        }, rotateAround: function(e2, t2) {
          return this.clone()._rotateAround(e2, t2);
        }, matMult: function(e2) {
          return this.clone()._matMult(e2);
        }, unit: function() {
          return this.clone()._unit();
        }, perp: function() {
          return this.clone()._perp();
        }, round: function() {
          return this.clone()._round();
        }, mag: function() {
          return Math.sqrt(this.x * this.x + this.y * this.y);
        }, equals: function(e2) {
          return this.x === e2.x && this.y === e2.y;
        }, dist: function(e2) {
          return Math.sqrt(this.distSqr(e2));
        }, distSqr: function(e2) {
          var t2 = e2.x - this.x, i2 = e2.y - this.y;
          return t2 * t2 + i2 * i2;
        }, angle: function() {
          return Math.atan2(this.y, this.x);
        }, angleTo: function(e2) {
          return Math.atan2(this.y - e2.y, this.x - e2.x);
        }, angleWith: function(e2) {
          return this.angleWithSep(e2.x, e2.y);
        }, angleWithSep: function(e2, t2) {
          return Math.atan2(this.x * t2 - this.y * e2, this.x * e2 + this.y * t2);
        }, _matMult: function(e2) {
          var t2 = e2[2] * this.x + e2[3] * this.y;
          return this.x = e2[0] * this.x + e2[1] * this.y, this.y = t2, this;
        }, _add: function(e2) {
          return this.x += e2.x, this.y += e2.y, this;
        }, _sub: function(e2) {
          return this.x -= e2.x, this.y -= e2.y, this;
        }, _mult: function(e2) {
          return this.x *= e2, this.y *= e2, this;
        }, _div: function(e2) {
          return this.x /= e2, this.y /= e2, this;
        }, _multByPoint: function(e2) {
          return this.x *= e2.x, this.y *= e2.y, this;
        }, _divByPoint: function(e2) {
          return this.x /= e2.x, this.y /= e2.y, this;
        }, _unit: function() {
          return this._div(this.mag()), this;
        }, _perp: function() {
          var e2 = this.y;
          return this.y = this.x, this.x = -e2, this;
        }, _rotate: function(e2) {
          var t2 = Math.cos(e2), i2 = Math.sin(e2), r2 = i2 * this.x + t2 * this.y;
          return this.x = t2 * this.x - i2 * this.y, this.y = r2, this;
        }, _rotateAround: function(e2, t2) {
          var i2 = Math.cos(e2), r2 = Math.sin(e2), n2 = t2.y + r2 * (this.x - t2.x) + i2 * (this.y - t2.y);
          return this.x = t2.x + i2 * (this.x - t2.x) - r2 * (this.y - t2.y), this.y = n2, this;
        }, _round: function() {
          return this.x = Math.round(this.x), this.y = Math.round(this.y), this;
        } }, g.convert = function(e2) {
          return e2 instanceof g ? e2 : Array.isArray(e2) ? new g(e2[0], e2[1]) : e2;
        };
        var y = d(_);
        function x(e2, t2) {
          if (Array.isArray(e2)) {
            if (!Array.isArray(t2) || e2.length !== t2.length)
              return false;
            for (let i2 = 0; i2 < e2.length; i2++)
              if (!x(e2[i2], t2[i2]))
                return false;
            return true;
          }
          if ("object" == typeof e2 && null !== e2 && null !== t2) {
            if ("object" != typeof t2)
              return false;
            if (Object.keys(e2).length !== Object.keys(t2).length)
              return false;
            for (const i2 in e2)
              if (!x(e2[i2], t2[i2]))
                return false;
            return true;
          }
          return e2 === t2;
        }
        const v = Math.PI / 180, b = 180 / Math.PI;
        function w(e2) {
          return e2 * v;
        }
        function T(e2) {
          return e2 * b;
        }
        const E = [[0, 0], [1, 0], [1, 1], [0, 1]];
        function M(e2) {
          if (e2 <= 0)
            return 0;
          if (e2 >= 1)
            return 1;
          const t2 = e2 * e2, i2 = t2 * e2;
          return 4 * (e2 < 0.5 ? i2 : 3 * (e2 - t2) + i2 - 0.75);
        }
        function A(e2) {
          let t2 = 1 / 0, i2 = 1 / 0, r2 = -1 / 0, n2 = -1 / 0;
          for (const o2 of e2)
            t2 = Math.min(t2, o2.x), i2 = Math.min(i2, o2.y), r2 = Math.max(r2, o2.x), n2 = Math.max(n2, o2.y);
          return { min: new y(t2, i2), max: new y(r2, n2) };
        }
        function S(e2, t2, i2 = 0, r2 = true) {
          const n2 = new y(i2, i2), o2 = e2.sub(n2), s2 = t2.add(n2), a2 = [o2, new y(s2.x, o2.y), s2, new y(o2.x, s2.y)];
          return r2 && a2.push(o2.clone()), a2;
        }
        function I(e2, t2, i2, r2) {
          const n2 = new m(e2, t2, i2, r2);
          return function(e3) {
            return n2.solve(e3);
          };
        }
        const C = I(0.25, 0.1, 0.25, 1);
        function z(e2, t2, i2) {
          return Math.min(i2, Math.max(t2, e2));
        }
        function D(e2, t2, i2) {
          return (i2 = z((i2 - e2) / (t2 - e2), 0, 1)) * i2 * (3 - 2 * i2);
        }
        function P(e2, t2, i2) {
          const r2 = i2 - t2, n2 = ((e2 - t2) % r2 + r2) % r2 + t2;
          return n2 === t2 ? i2 : n2;
        }
        function R(e2, t2, i2) {
          if (!e2.length)
            return i2(null, []);
          let r2 = e2.length;
          const n2 = new Array(e2.length);
          let o2 = null;
          e2.forEach((e3, s2) => {
            t2(e3, (e4, t3) => {
              e4 && (o2 = e4), n2[s2] = t3, 0 == --r2 && i2(o2, n2);
            });
          });
        }
        function L(e2) {
          const t2 = [];
          for (const i2 in e2)
            t2.push(e2[i2]);
          return t2;
        }
        function k(e2, ...t2) {
          for (const i2 of t2)
            for (const t3 in i2)
              e2[t3] = i2[t3];
          return e2;
        }
        function O(e2, t2) {
          const i2 = {};
          for (let r2 = 0; r2 < t2.length; r2++) {
            const n2 = t2[r2];
            n2 in e2 && (i2[n2] = e2[n2]);
          }
          return i2;
        }
        let B = 1;
        function F() {
          return B++;
        }
        function N() {
          return function e2(t2) {
            return t2 ? (t2 ^ Math.random() * (16 >> t2 / 4)).toString(16) : ([1e7] + -[1e3] + -4e3 + -8e3 + -1e11).replace(/[018]/g, e2);
          }();
        }
        function U(e2) {
          return e2 <= 1 ? 1 : Math.pow(2, Math.ceil(Math.log(e2) / Math.LN2));
        }
        function V(e2) {
          return !!e2 && /^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(e2);
        }
        function j(e2, t2) {
          e2.forEach((e3) => {
            t2[e3] && (t2[e3] = t2[e3].bind(t2));
          });
        }
        function G(e2, t2) {
          return -1 !== e2.indexOf(t2, e2.length - t2.length);
        }
        function q(e2, t2, i2) {
          const r2 = {};
          for (const n2 in e2)
            r2[n2] = t2.call(i2 || this, e2[n2], n2, e2);
          return r2;
        }
        function Z(e2, t2, i2) {
          const r2 = {};
          for (const n2 in e2)
            t2.call(i2 || this, e2[n2], n2, e2) && (r2[n2] = e2[n2]);
          return r2;
        }
        function $(e2) {
          return Array.isArray(e2) ? e2.map($) : "object" == typeof e2 && e2 ? q(e2, $) : e2;
        }
        const H = {};
        function W(e2) {
          H[e2] || ("undefined" != typeof console && console.warn(e2), H[e2] = true);
        }
        function X(e2, t2, i2) {
          return (i2.y - e2.y) * (t2.x - e2.x) > (t2.y - e2.y) * (i2.x - e2.x);
        }
        function Y(e2) {
          let t2 = 0;
          for (let i2, r2, n2 = 0, o2 = e2.length, s2 = o2 - 1; n2 < o2; s2 = n2++)
            i2 = e2[n2], r2 = e2[s2], t2 += (r2.x - i2.x) * (i2.y + r2.y);
          return t2;
        }
        function K([e2, t2, i2]) {
          const r2 = w(t2 + 90), n2 = w(i2);
          return { x: e2 * Math.cos(r2) * Math.sin(n2), y: e2 * Math.sin(r2) * Math.sin(n2), z: e2 * Math.cos(n2), azimuthal: t2, polar: i2 };
        }
        function J(e2, t2, i2) {
          const r2 = Math.sqrt(e2 * e2 + t2 * t2 + i2 * i2), n2 = r2 > 0 ? Math.acos(i2 / r2) * b : 0;
          let o2 = 0 !== e2 || 0 !== t2 ? Math.atan2(-t2, -e2) * b + 90 : 0;
          return o2 < 0 && (o2 += 360), [r2, o2, n2];
        }
        function Q() {
          return "undefined" != typeof WorkerGlobalScope && "undefined" != typeof self && self instanceof WorkerGlobalScope;
        }
        function ee(e2) {
          const t2 = {};
          if (e2.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g, (e3, i2, r2, n2) => {
            const o2 = r2 || n2;
            return t2[i2] = !o2 || o2.toLowerCase(), "";
          }), t2["max-age"]) {
            const e3 = parseInt(t2["max-age"], 10);
            isNaN(e3) ? delete t2["max-age"] : t2["max-age"] = e3;
          }
          return t2;
        }
        let te = null;
        function ie() {
          return !!t.document.fullscreenElement || !!t.document.webkitFullscreenElement;
        }
        function re(e2) {
          try {
            const i2 = t[e2];
            return i2.setItem("_mapbox_test_", 1), i2.removeItem("_mapbox_test_"), true;
          } catch (e3) {
            return false;
          }
        }
        function ne(e2, t2) {
          return [e2[4 * t2], e2[4 * t2 + 1], e2[4 * t2 + 2], e2[4 * t2 + 3]];
        }
        function oe(e2, t2, i2) {
          e2[4 * t2 + 0] = i2[0], e2[4 * t2 + 1] = i2[1], e2[4 * t2 + 2] = i2[2], e2[4 * t2 + 3] = i2[3];
        }
        function se(e2, t2) {
          return [Math.pow(e2[0], 2.2) * t2, Math.pow(e2[1], 2.2) * t2, Math.pow(e2[2], 2.2) * t2];
        }
        function ae(e2) {
          return [Math.pow(e2[0], 1 / 2.2), Math.pow(e2[1], 1 / 2.2), Math.pow(e2[2], 1 / 2.2)];
        }
        const le = "mapbox-tiles";
        let ce = 500, he = 50;
        let ue, de;
        function pe() {
          try {
            return t.caches;
          } catch (e2) {
          }
        }
        function fe() {
          pe() && !ue && (ue = t.caches.open(le));
        }
        function me(e2) {
          const t2 = e2.indexOf("?");
          if (t2 < 0)
            return e2;
          const i2 = function(e3) {
            const t3 = e3.indexOf("?");
            return t3 > 0 ? e3.slice(t3 + 1).split("&") : [];
          }(e2), r2 = i2.filter((e3) => {
            const t3 = e3.split("=");
            return "language" === t3[0] || "worldview" === t3[0];
          });
          return r2.length ? `${e2.slice(0, t2)}?${r2.join("&")}` : e2.slice(0, t2);
        }
        let _e = 1 / 0;
        function ge(e2) {
          _e++, _e > he && (e2.getActor().send("enforceCacheSizeLimit", ce), _e = 0);
        }
        const ye = { Unknown: "Unknown", Style: "Style", Source: "Source", Tile: "Tile", Glyphs: "Glyphs", SpriteImage: "SpriteImage", SpriteJSON: "SpriteJSON", Image: "Image", Model: "Model" };
        "function" == typeof Object.freeze && Object.freeze(ye);
        class xe extends Error {
          constructor(e2, t2, i2) {
            401 === t2 && Pe(i2) && (e2 += ": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"), super(e2), this.status = t2, this.url = i2;
          }
          toString() {
            return `${this.name}: ${this.message} (${this.status}): ${this.url}`;
          }
        }
        const ve = Q() ? () => self.worker && self.worker.referrer : () => ("blob:" === t.location.protocol ? t.parent : t).location.href;
        const be = function(e2, i2) {
          if (!(/^file:/.test(r2 = e2.url) || /^file:/.test(ve()) && !/^\w+:/.test(r2))) {
            if (t.fetch && t.Request && t.AbortController && t.Request.prototype.hasOwnProperty("signal"))
              return function(e3, i3) {
                const r3 = new t.AbortController(), n2 = new t.Request(e3.url, { method: e3.method || "GET", body: e3.body, credentials: e3.credentials, headers: e3.headers, referrer: ve(), referrerPolicy: e3.referrerPolicy, signal: r3.signal });
                let o2 = false, s2 = false;
                const a2 = (l2 = n2.url).indexOf("sku=") > 0 && Pe(l2);
                var l2;
                "json" === e3.type && n2.headers.set("Accept", "application/json");
                const c2 = (r4, o3, l3) => {
                  if (s2)
                    return;
                  if (r4 && "SecurityError" !== r4.message && W(r4.toString()), o3 && l3)
                    return h2(o3);
                  const c3 = Date.now();
                  t.fetch(n2).then((t2) => {
                    if (t2.ok) {
                      const e4 = a2 ? t2.clone() : null;
                      return h2(t2, e4, c3);
                    }
                    return i3(new xe(t2.statusText, t2.status, e3.url));
                  }).catch((t2) => {
                    "AbortError" !== t2.name && i3(new Error(`${t2.message} ${e3.url}`));
                  });
                }, h2 = (r4, a3, l3) => {
                  ("arrayBuffer" === e3.type ? r4.arrayBuffer() : "json" === e3.type ? r4.json() : r4.text()).then((e4) => {
                    s2 || (a3 && l3 && function(e5, i4, r5) {
                      if (fe(), !ue)
                        return;
                      const n3 = { status: i4.status, statusText: i4.statusText, headers: new t.Headers() };
                      i4.headers.forEach((e6, t2) => n3.headers.set(t2, e6));
                      const o3 = ee(i4.headers.get("Cache-Control") || "");
                      if (o3["no-store"])
                        return;
                      o3["max-age"] && n3.headers.set("Expires", new Date(r5 + 1e3 * o3["max-age"]).toUTCString());
                      const s3 = n3.headers.get("Expires");
                      s3 && (new Date(s3).getTime() - r5 < 42e4 || function(e6, t2) {
                        if (void 0 === de)
                          try {
                            new Response(new ReadableStream()), de = true;
                          } catch (e7) {
                            de = false;
                          }
                        de ? t2(e6.body) : e6.blob().then(t2);
                      }(i4, (i5) => {
                        const r6 = new t.Response(i5, n3);
                        fe(), ue && ue.then((t2) => t2.put(me(e5.url), r6)).catch((e6) => W(e6.message));
                      }));
                    }(n2, a3, l3), o2 = true, i3(null, e4, r4.headers.get("Cache-Control"), r4.headers.get("Expires")));
                  }).catch((e4) => {
                    s2 || i3(new Error(e4.message));
                  });
                };
                return a2 ? function(e4, t2) {
                  if (fe(), !ue)
                    return t2(null);
                  const i4 = me(e4.url);
                  ue.then((e5) => {
                    e5.match(i4).then((r4) => {
                      const n3 = function(e6) {
                        if (!e6)
                          return false;
                        const t3 = new Date(e6.headers.get("Expires") || 0), i5 = ee(e6.headers.get("Cache-Control") || "");
                        return t3 > Date.now() && !i5["no-cache"];
                      }(r4);
                      e5.delete(i4), n3 && e5.put(i4, r4.clone()), t2(null, r4, n3);
                    }).catch(t2);
                  }).catch(t2);
                }(n2, c2) : c2(null, null), { cancel: () => {
                  s2 = true, o2 || r3.abort();
                } };
              }(e2, i2);
            if (Q() && self.worker && self.worker.actor)
              return self.worker.actor.send("getResource", e2, i2, void 0, true);
          }
          var r2;
          return function(e3, i3) {
            const r3 = new t.XMLHttpRequest();
            r3.open(e3.method || "GET", e3.url, true), "arrayBuffer" === e3.type && (r3.responseType = "arraybuffer");
            for (const t2 in e3.headers)
              r3.setRequestHeader(t2, e3.headers[t2]);
            return "json" === e3.type && (r3.responseType = "text", r3.setRequestHeader("Accept", "application/json")), r3.withCredentials = "include" === e3.credentials, r3.onerror = () => {
              i3(new Error(r3.statusText));
            }, r3.onload = () => {
              if ((r3.status >= 200 && r3.status < 300 || 0 === r3.status) && null !== r3.response) {
                let t2 = r3.response;
                if ("json" === e3.type)
                  try {
                    t2 = JSON.parse(r3.response);
                  } catch (e4) {
                    return i3(e4);
                  }
                i3(null, t2, r3.getResponseHeader("Cache-Control"), r3.getResponseHeader("Expires"));
              } else
                i3(new xe(r3.statusText, r3.status, e3.url));
            }, r3.send(e3.body), { cancel: () => r3.abort() };
          }(e2, i2);
        }, we = function(e2, t2) {
          return be(k(e2, { type: "json" }), t2);
        }, Te = function(e2, t2) {
          return be(k(e2, { type: "arrayBuffer" }), t2);
        };
        function Ee(e2) {
          const i2 = t.document.createElement("a");
          return i2.href = e2, i2.protocol === t.document.location.protocol && i2.host === t.document.location.host;
        }
        const Me = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";
        let Ae, Se;
        Ae = [], Se = 0;
        const Ie = function(e2, i2) {
          if (o.supported && (e2.headers || (e2.headers = {}), e2.headers.accept = "image/webp,*/*"), Se >= n.MAX_PARALLEL_IMAGE_REQUESTS) {
            const t2 = { requestParameters: e2, callback: i2, cancelled: false, cancel() {
              this.cancelled = true;
            } };
            return Ae.push(t2), t2;
          }
          Se++;
          let r2 = false;
          const s2 = () => {
            if (!r2)
              for (r2 = true, Se--; Ae.length && Se < n.MAX_PARALLEL_IMAGE_REQUESTS; ) {
                const e3 = Ae.shift(), { requestParameters: t2, callback: i3, cancelled: r3 } = e3;
                r3 || (e3.cancel = Ie(t2, i3).cancel);
              }
          }, a2 = Te(e2, (e3, r3, n2, o2) => {
            s2(), e3 ? i2(e3) : r3 && (t.createImageBitmap ? function(e4, i3) {
              const r4 = new t.Blob([new Uint8Array(e4)], { type: "image/png" });
              t.createImageBitmap(r4).then((e5) => {
                i3(null, e5);
              }).catch((e5) => {
                i3(new Error(`Could not load image because of ${e5.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));
              });
            }(r3, (e4, t2) => i2(e4, t2, n2, o2)) : function(e4, i3) {
              const r4 = new t.Image(), n3 = t.URL;
              r4.onload = () => {
                i3(null, r4), n3.revokeObjectURL(r4.src), r4.onload = null, t.requestAnimationFrame(() => {
                  r4.src = Me;
                });
              }, r4.onerror = () => i3(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));
              const o3 = new t.Blob([new Uint8Array(e4)], { type: "image/png" });
              r4.src = e4.byteLength ? n3.createObjectURL(o3) : Me;
            }(r3, (e4, t2) => i2(e4, t2, n2, o2)));
          });
          return { cancel: () => {
            a2.cancel(), s2();
          } };
        }, Ce = "NO_ACCESS_TOKEN";
        class ze {
          constructor(e2, t2, i2) {
            this._transformRequestFn = e2, this._customAccessToken = t2, this._silenceAuthErrors = !!i2, this._createSkuToken();
          }
          _createSkuToken() {
            const e2 = function() {
              let e3 = "";
              for (let t2 = 0; t2 < 10; t2++)
                e3 += "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62 * Math.random())];
              return { token: ["1", u, e3].join(""), tokenExpiresAt: Date.now() + 432e5 };
            }();
            this._skuToken = e2.token, this._skuTokenExpiresAt = e2.tokenExpiresAt;
          }
          _isSkuTokenExpired() {
            return Date.now() > this._skuTokenExpiresAt;
          }
          transformRequest(e2, t2) {
            return this._transformRequestFn && this._transformRequestFn(e2, t2) || { url: e2 };
          }
          normalizeStyleURL(e2, t2) {
            if (!De(e2))
              return e2;
            const r2 = Be(e2);
            return r2.params.push(`sdk=js-${i}`), r2.path = `/styles/v1${r2.path}`, this._makeAPIURL(r2, this._customAccessToken || t2);
          }
          normalizeGlyphsURL(e2, t2) {
            if (!De(e2))
              return e2;
            const i2 = Be(e2);
            return i2.path = `/fonts/v1${i2.path}`, this._makeAPIURL(i2, this._customAccessToken || t2);
          }
          normalizeModelURL(e2, t2) {
            if (!De(e2))
              return e2;
            const i2 = Be(e2);
            return i2.path = `/models/v1${i2.path}`, this._makeAPIURL(i2, this._customAccessToken || t2);
          }
          normalizeSourceURL(e2, t2, i2, r2) {
            if (!De(e2))
              return e2;
            const n2 = Be(e2);
            return n2.path = `/v4/${n2.authority}.json`, n2.params.push("secure"), i2 && n2.params.push(`language=${i2}`), r2 && n2.params.push(`worldview=${r2}`), this._makeAPIURL(n2, this._customAccessToken || t2);
          }
          normalizeSpriteURL(e2, t2, i2, r2) {
            const n2 = Be(e2);
            return De(e2) ? (n2.path = `/styles/v1${n2.path}/sprite${t2}${i2}`, this._makeAPIURL(n2, this._customAccessToken || r2)) : (n2.path += `${t2}${i2}`, Fe(n2));
          }
          normalizeTileURL(e2, t2, i2) {
            if (this._isSkuTokenExpired() && this._createSkuToken(), e2 && !De(e2))
              return e2;
            const r2 = Be(e2);
            r2.path = r2.path.replace(/(\.(png|jpg)\d*)(?=$)/, `${t2 || i2 && "raster" !== r2.authority && 512 === i2 ? "@2x" : ""}${o.supported ? ".webp" : "$1"}`), "raster" === r2.authority ? r2.path = `/${n.RASTER_URL_PREFIX}${r2.path}` : (r2.path = r2.path.replace(/^.+\/v4\//, "/"), r2.path = `/${n.TILE_URL_VERSION}${r2.path}`);
            const s2 = this._customAccessToken || function(e3) {
              for (const t3 of e3) {
                const e4 = t3.match(/^access_token=(.*)$/);
                if (e4)
                  return e4[1];
              }
              return null;
            }(r2.params) || n.ACCESS_TOKEN;
            return n.REQUIRE_ACCESS_TOKEN && s2 && this._skuToken && r2.params.push(`sku=${this._skuToken}`), this._makeAPIURL(r2, s2);
          }
          canonicalizeTileURL(e2, t2) {
            const i2 = Be(e2);
            if (!i2.path.match(/^(\/v4\/|\/raster\/v1\/)/) || !i2.path.match(/\.[\w]+$/))
              return e2;
            let r2 = "mapbox://";
            i2.path.match(/^\/raster\/v1\//) ? r2 += `raster/${i2.path.replace(`/${n.RASTER_URL_PREFIX}/`, "")}` : r2 += `tiles/${i2.path.replace(`/${n.TILE_URL_VERSION}/`, "")}`;
            let o2 = i2.params;
            return t2 && (o2 = o2.filter((e3) => !e3.match(/^access_token=/))), o2.length && (r2 += `?${o2.join("&")}`), r2;
          }
          canonicalizeTileset(e2, t2) {
            const i2 = !!t2 && De(t2), r2 = [];
            for (const t3 of e2.tiles || [])
              Pe(t3) ? r2.push(this.canonicalizeTileURL(t3, i2)) : r2.push(t3);
            return r2;
          }
          _makeAPIURL(e2, t2) {
            const i2 = "See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes", r2 = Be(n.API_URL);
            if (e2.protocol = r2.protocol, e2.authority = r2.authority, "http" === e2.protocol) {
              const t3 = e2.params.indexOf("secure");
              t3 >= 0 && e2.params.splice(t3, 1);
            }
            if ("/" !== r2.path && (e2.path = `${r2.path}${e2.path}`), !n.REQUIRE_ACCESS_TOKEN)
              return Fe(e2);
            if (t2 = t2 || n.ACCESS_TOKEN, !this._silenceAuthErrors) {
              if (!t2)
                throw new Error(`An API access token is required to use Mapbox GL. ${i2}`);
              if ("s" === t2[0])
                throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${i2}`);
            }
            return e2.params = e2.params.filter((e3) => -1 === e3.indexOf("access_token")), e2.params.push(`access_token=${t2 || ""}`), Fe(e2);
          }
        }
        function De(e2) {
          return 0 === e2.indexOf("mapbox:");
        }
        function Pe(e2) {
          return n.API_URL_REGEX.test(e2);
        }
        function Re(e2) {
          return n.API_CDN_URL_REGEX.test(e2);
        }
        function Le(e2) {
          return n.API_STYLE_REGEX.test(e2) && !ke(e2);
        }
        function ke(e2) {
          return n.API_SPRITE_REGEX.test(e2);
        }
        const Oe = /^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;
        function Be(e2) {
          const t2 = e2.match(Oe);
          if (!t2)
            throw new Error("Unable to parse URL object");
          return { protocol: t2[1], authority: t2[2], path: t2[3] || "/", params: t2[4] ? t2[4].split("&") : [] };
        }
        function Fe(e2) {
          const t2 = e2.params.length ? `?${e2.params.join("&")}` : "";
          return `${e2.protocol}://${e2.authority}${e2.path}${t2}`;
        }
        const Ne = "mapbox.eventData";
        function Ue(e2) {
          if (!e2)
            return null;
          const i2 = e2.split(".");
          if (!i2 || 3 !== i2.length)
            return null;
          try {
            return JSON.parse(decodeURIComponent(t.atob(i2[1]).split("").map((e3) => "%" + ("00" + e3.charCodeAt(0).toString(16)).slice(-2)).join("")));
          } catch (e3) {
            return null;
          }
        }
        class Ve {
          constructor(e2) {
            this.type = e2, this.anonId = null, this.eventData = {}, this.queue = [], this.pendingRequest = null;
          }
          getStorageKey(e2) {
            const i2 = Ue(n.ACCESS_TOKEN);
            let r2 = "";
            return r2 = i2 && i2.u ? t.btoa(encodeURIComponent(i2.u).replace(/%([0-9A-F]{2})/g, (e3, t2) => String.fromCharCode(Number("0x" + t2)))) : n.ACCESS_TOKEN || "", e2 ? `${Ne}.${e2}:${r2}` : `${Ne}:${r2}`;
          }
          fetchEventData() {
            const e2 = re("localStorage"), i2 = this.getStorageKey(), r2 = this.getStorageKey("uuid");
            if (e2)
              try {
                const e3 = t.localStorage.getItem(i2);
                e3 && (this.eventData = JSON.parse(e3));
                const n2 = t.localStorage.getItem(r2);
                n2 && (this.anonId = n2);
              } catch (e3) {
                W("Unable to read from LocalStorage");
              }
          }
          saveEventData() {
            const e2 = re("localStorage"), i2 = this.getStorageKey(), r2 = this.getStorageKey("uuid");
            if (e2)
              try {
                t.localStorage.setItem(r2, this.anonId), Object.keys(this.eventData).length >= 1 && t.localStorage.setItem(i2, JSON.stringify(this.eventData));
              } catch (e3) {
                W("Unable to write to LocalStorage");
              }
          }
          processRequests(e2) {
          }
          postEvent(e2, t2, i2, r2) {
            if (!n.EVENTS_URL)
              return;
            const o2 = Be(n.EVENTS_URL);
            o2.params.push(`access_token=${r2 || n.ACCESS_TOKEN || ""}`);
            const s2 = { event: this.type, created: new Date(e2).toISOString() }, a2 = t2 ? k(s2, t2) : s2, l2 = { url: Fe(o2), headers: { "Content-Type": "text/plain" }, body: JSON.stringify([a2]) };
            this.pendingRequest = function(e3, t3) {
              return be(k(e3, { method: "POST" }), t3);
            }(l2, (e3) => {
              this.pendingRequest = null, i2(e3), this.saveEventData(), this.processRequests(r2);
            });
          }
          queueRequest(e2, t2) {
            this.queue.push(e2), this.processRequests(t2);
          }
        }
        const je = new class extends Ve {
          constructor(e2) {
            super("appUserTurnstile"), this._customAccessToken = e2;
          }
          postTurnstileEvent(e2, t2) {
            n.EVENTS_URL && n.ACCESS_TOKEN && Array.isArray(e2) && e2.some((e3) => De(e3) || Pe(e3)) && this.queueRequest(Date.now(), t2);
          }
          processRequests(e2) {
            if (this.pendingRequest || 0 === this.queue.length)
              return;
            this.anonId && this.eventData.lastSuccess && this.eventData.tokenU || this.fetchEventData();
            const t2 = Ue(n.ACCESS_TOKEN), r2 = t2 ? t2.u : n.ACCESS_TOKEN;
            let o2 = r2 !== this.eventData.tokenU;
            V(this.anonId) || (this.anonId = N(), o2 = true);
            const s2 = this.queue.shift();
            if (this.eventData.lastSuccess) {
              const e3 = new Date(this.eventData.lastSuccess), t3 = new Date(s2), i2 = (s2 - this.eventData.lastSuccess) / 864e5;
              o2 = o2 || i2 >= 1 || i2 < -1 || e3.getDate() !== t3.getDate();
            } else
              o2 = true;
            o2 ? this.postEvent(s2, { sdkIdentifier: "mapbox-gl-js", sdkVersion: i, skuId: u, "enabled.telemetry": false, userId: this.anonId }, (e3) => {
              e3 || (this.eventData.lastSuccess = s2, this.eventData.tokenU = r2);
            }, e2) : this.processRequests();
          }
        }(), Ge = je.postTurnstileEvent.bind(je), qe = new class extends Ve {
          constructor() {
            super("map.load"), this.success = {}, this.skuToken = "";
          }
          postMapLoadEvent(e2, t2, i2, r2) {
            this.skuToken = t2, this.errorCb = r2, n.EVENTS_URL && (i2 || n.ACCESS_TOKEN ? this.queueRequest({ id: e2, timestamp: Date.now() }, i2) : this.errorCb(new Error(Ce)));
          }
          processRequests(e2) {
            if (this.pendingRequest || 0 === this.queue.length)
              return;
            const { id: t2, timestamp: r2 } = this.queue.shift();
            t2 && this.success[t2] || (this.anonId || this.fetchEventData(), V(this.anonId) || (this.anonId = N()), this.postEvent(r2, { sdkIdentifier: "mapbox-gl-js", sdkVersion: i, skuId: u, skuToken: this.skuToken, userId: this.anonId }, (e3) => {
              e3 ? this.errorCb(e3) : t2 && (this.success[t2] = true);
            }, e2));
          }
        }(), Ze = qe.postMapLoadEvent.bind(qe), $e = new class extends Ve {
          constructor() {
            super("gljs.performance");
          }
          postPerformanceEvent(e2, t2) {
            n.EVENTS_URL && (e2 || n.ACCESS_TOKEN) && this.queueRequest({ timestamp: Date.now(), performanceData: t2 }, e2);
          }
          processRequests(e2) {
            if (this.pendingRequest || 0 === this.queue.length)
              return;
            const { timestamp: r2, performanceData: n2 } = this.queue.shift(), o2 = function(e3) {
              const r3 = t.performance.getEntriesByType("resource"), n3 = t.performance.getEntriesByType("mark"), o3 = function(e4) {
                const t2 = {};
                if (e4) {
                  for (const i2 in e4)
                    if ("other" !== i2)
                      for (const r4 of e4[i2]) {
                        const e5 = `${i2}ResolveRangeMin`, n4 = `${i2}ResolveRangeMax`, o4 = `${i2}RequestCount`, s3 = `${i2}RequestCachedCount`;
                        t2[e5] = Math.min(t2[e5] || 1 / 0, r4.startTime), t2[n4] = Math.max(t2[n4] || -1 / 0, r4.responseEnd);
                        const a3 = (e6) => {
                          void 0 === t2[e6] && (t2[e6] = 0), ++t2[e6];
                        };
                        void 0 !== r4.transferSize && 0 === r4.transferSize && a3(s3), a3(o4);
                      }
                }
                return t2;
              }(function(e4, t2) {
                const i2 = {};
                if (e4)
                  for (const r4 of e4) {
                    const e5 = t2(r4);
                    void 0 === i2[e5] && (i2[e5] = []), i2[e5].push(r4);
                  }
                return i2;
              }(r3, et)), s2 = t.devicePixelRatio, a2 = t.navigator.connection || t.navigator.mozConnection || t.navigator.webkitConnection, l2 = { counters: [], metadata: [], attributes: [] }, c2 = (e4, t2, i2) => {
                null != i2 && e4.push({ name: t2, value: i2.toString() });
              };
              for (const e4 in o3)
                c2(l2.counters, e4, o3[e4]);
              if (e3.interactionRange[0] !== 1 / 0 && e3.interactionRange[1] !== -1 / 0 && (c2(l2.counters, "interactionRangeMin", e3.interactionRange[0]), c2(l2.counters, "interactionRangeMax", e3.interactionRange[1])), n3)
                for (const e4 of Object.keys(Je)) {
                  const t2 = Je[e4], i2 = n3.find((e5) => e5.name === t2);
                  i2 && c2(l2.counters, t2, i2.startTime);
                }
              return c2(l2.counters, "visibilityHidden", e3.visibilityHidden), c2(l2.attributes, "style", function(e4) {
                if (e4)
                  for (const t2 of e4) {
                    const e5 = t2.name.split("?")[0];
                    if (Le(e5)) {
                      const t3 = e5.split("/").slice(-2);
                      if (2 === t3.length)
                        return `mapbox://styles/${t3[0]}/${t3[1]}`;
                    }
                  }
              }(r3)), c2(l2.attributes, "terrainEnabled", e3.terrainEnabled ? "true" : "false"), c2(l2.attributes, "fogEnabled", e3.fogEnabled ? "true" : "false"), c2(l2.attributes, "projection", e3.projection), c2(l2.attributes, "zoom", e3.zoom), c2(l2.metadata, "devicePixelRatio", s2), c2(l2.metadata, "connectionEffectiveType", a2 ? a2.effectiveType : void 0), c2(l2.metadata, "navigatorUserAgent", t.navigator.userAgent), c2(l2.metadata, "screenWidth", t.screen.width), c2(l2.metadata, "screenHeight", t.screen.height), c2(l2.metadata, "windowWidth", t.innerWidth), c2(l2.metadata, "windowHeight", t.innerHeight), c2(l2.metadata, "mapWidth", e3.width / s2), c2(l2.metadata, "mapHeight", e3.height / s2), c2(l2.metadata, "webglRenderer", e3.renderer), c2(l2.metadata, "webglVendor", e3.vendor), c2(l2.metadata, "sdkVersion", i), c2(l2.metadata, "sdkIdentifier", "mapbox-gl-js"), l2;
            }(n2);
            for (const e3 of o2.metadata)
              ;
            for (const e3 of o2.counters)
              ;
            for (const e3 of o2.attributes)
              ;
            this.postEvent(r2, o2, () => {
            }, e2);
          }
        }(), He = $e.postPerformanceEvent.bind($e), We = new class extends Ve {
          constructor() {
            super("map.auth"), this.success = {}, this.skuToken = "";
          }
          getSession(e2, t2, i2, r2) {
            if (!n.API_URL || !n.SESSION_PATH)
              return;
            const o2 = Be(n.API_URL + n.SESSION_PATH);
            o2.params.push(`sku=${t2 || ""}`), o2.params.push(`access_token=${r2 || n.ACCESS_TOKEN || ""}`);
            const s2 = { url: Fe(o2), headers: { "Content-Type": "text/plain" } };
            this.pendingRequest = function(e3, t3) {
              return be(k(e3, { method: "GET" }), t3);
            }(s2, (e3) => {
              this.pendingRequest = null, i2(e3), this.saveEventData(), this.processRequests(r2);
            });
          }
          getSessionAPI(e2, t2, i2, r2) {
            this.skuToken = t2, this.errorCb = r2, n.SESSION_PATH && n.API_URL && (i2 || n.ACCESS_TOKEN ? this.queueRequest({ id: e2, timestamp: Date.now() }, i2) : this.errorCb(new Error(Ce)));
          }
          processRequests(e2) {
            if (this.pendingRequest || 0 === this.queue.length)
              return;
            const { id: t2, timestamp: i2 } = this.queue.shift();
            t2 && this.success[t2] || this.getSession(i2, this.skuToken, (e3) => {
              e3 ? this.errorCb(e3) : t2 && (this.success[t2] = true);
            }, e2);
          }
        }(), Xe = We.getSessionAPI.bind(We), Ye = /* @__PURE__ */ new Set();
        function Ke(e2, t2) {
          t2 ? Ye.add(e2) : Ye.delete(e2);
        }
        const Je = { create: "create", load: "load", fullLoad: "fullLoad" }, Qe = { mark(e2) {
          t.performance.mark(e2);
        }, measure(e2, i2, r2) {
          t.performance.measure(e2, i2, r2);
        } };
        function et(e2) {
          const t2 = e2.name.split("?")[0];
          return Re(t2) && t2.includes("mapbox-gl.js") ? "javascript" : Re(t2) && t2.includes("mapbox-gl.css") ? "css" : function(e3) {
            return n.API_FONTS_REGEX.test(e3);
          }(t2) ? "fontRange" : ke(t2) ? "sprite" : Le(t2) ? "style" : function(e3) {
            return n.API_TILEJSON_REGEX.test(e3);
          }(t2) ? "tilejson" : "other";
        }
        const tt = t.performance;
        function it(e2) {
          const t2 = e2 ? e2.url.toString() : void 0;
          return tt.getEntriesByName(t2);
        }
        var rt = nt;
        function nt(e2) {
          return !function(e3) {
            return "undefined" == typeof window || "undefined" == typeof document ? "not a browser" : Array.prototype && Array.prototype.every && Array.prototype.filter && Array.prototype.forEach && Array.prototype.indexOf && Array.prototype.lastIndexOf && Array.prototype.map && Array.prototype.some && Array.prototype.reduce && Array.prototype.reduceRight && Array.isArray ? Function.prototype && Function.prototype.bind ? Object.keys && Object.create && Object.getPrototypeOf && Object.getOwnPropertyNames && Object.isSealed && Object.isFrozen && Object.isExtensible && Object.getOwnPropertyDescriptor && Object.defineProperty && Object.defineProperties && Object.seal && Object.freeze && Object.preventExtensions ? "JSON" in window && "parse" in JSON && "stringify" in JSON ? function() {
              if (!("Worker" in window && "Blob" in window && "URL" in window))
                return false;
              var e4, t3, i2 = new Blob([""], { type: "text/javascript" }), r2 = URL.createObjectURL(i2);
              try {
                t3 = new Worker(r2), e4 = true;
              } catch (t4) {
                e4 = false;
              }
              return t3 && t3.terminate(), URL.revokeObjectURL(r2), e4;
            }() ? "Uint8ClampedArray" in window ? ArrayBuffer.isView ? function() {
              var e4 = document.createElement("canvas");
              e4.width = e4.height = 1;
              var t3 = e4.getContext("2d");
              if (!t3)
                return false;
              var i2 = t3.getImageData(0, 0, 1, 1);
              return i2 && i2.width === e4.width;
            }() ? (void 0 === ot[t2 = e3 && e3.failIfMajorPerformanceCaveat] && (ot[t2] = function(e4) {
              var t3, i2 = function(e5) {
                var t4 = document.createElement("canvas"), i3 = Object.create(nt.webGLContextAttributes);
                return i3.failIfMajorPerformanceCaveat = e5, t4.getContext("webgl", i3) || t4.getContext("experimental-webgl", i3);
              }(e4);
              if (!i2)
                return false;
              try {
                t3 = i2.createShader(i2.VERTEX_SHADER);
              } catch (e5) {
                return false;
              }
              return !(!t3 || i2.isContextLost()) && (i2.shaderSource(t3, "void main() {}"), i2.compileShader(t3), true === i2.getShaderParameter(t3, i2.COMPILE_STATUS));
            }(t2)), ot[t2] ? document.documentMode ? "insufficient ECMAScript 6 support" : void 0 : "insufficient WebGL support") : "insufficient Canvas/getImageData support" : "insufficient ArrayBuffer support" : "insufficient Uint8ClampedArray support" : "insufficient worker support" : "insufficient JSON support" : "insufficient Object support" : "insufficient Function support" : "insufficent Array support";
            var t2;
          }(e2);
        }
        var ot = {};
        let st, at, lt, ct;
        nt.webGLContextAttributes = { antialias: false, alpha: true, stencil: true, depth: true };
        const ht = { now: () => void 0 !== lt ? lt : t.performance.now(), setNow(e2) {
          lt = e2;
        }, restoreNow() {
          lt = void 0;
        }, frame(e2) {
          const i2 = t.requestAnimationFrame(e2);
          return { cancel: () => t.cancelAnimationFrame(i2) };
        }, getImageData(e2, i2 = 0) {
          const { width: r2, height: n2 } = e2;
          ct || (ct = t.document.createElement("canvas"));
          const o2 = ct.getContext("2d", { willReadFrequently: true });
          if (!o2)
            throw new Error("failed to create canvas 2d context");
          return (r2 > ct.width || n2 > ct.height) && (ct.width = r2, ct.height = n2), o2.clearRect(-i2, -i2, r2 + 2 * i2, n2 + 2 * i2), o2.drawImage(e2, 0, 0, r2, n2), o2.getImageData(-i2, -i2, r2 + 2 * i2, n2 + 2 * i2);
        }, resolveURL: (e2) => (st || (st = t.document.createElement("a")), st.href = e2, st.href), get devicePixelRatio() {
          return t.devicePixelRatio;
        }, get prefersReducedMotion() {
          return !!t.matchMedia && (null == at && (at = t.matchMedia("(prefers-reduced-motion: reduce)")), at.matches);
        } };
        function ut(e2, i2, r2) {
          const n2 = t.document.createElement(e2);
          return void 0 !== i2 && (n2.className = i2), r2 && r2.appendChild(n2), n2;
        }
        function dt(e2, i2, r2) {
          const n2 = t.document.createElementNS("http://www.w3.org/2000/svg", e2);
          for (const e3 of Object.keys(i2))
            n2.setAttributeNS(null, e3, i2[e3]);
          return r2 && r2.appendChild(n2), n2;
        }
        const pt = t.document && t.document.documentElement.style, ft = pt && void 0 !== pt.userSelect ? "userSelect" : "WebkitUserSelect";
        let mt;
        function _t() {
          pt && ft && (mt = pt[ft], pt[ft] = "none");
        }
        function gt() {
          pt && ft && (pt[ft] = mt);
        }
        function yt(e2) {
          e2.preventDefault(), e2.stopPropagation(), t.removeEventListener("click", yt, true);
        }
        function xt() {
          t.addEventListener("click", yt, true), t.setTimeout(() => {
            t.removeEventListener("click", yt, true);
          }, 0);
        }
        function vt(e2, t2) {
          const i2 = e2.getBoundingClientRect();
          return Tt(e2, i2, t2);
        }
        function bt(e2, t2) {
          const i2 = e2.getBoundingClientRect(), r2 = [];
          for (let n2 = 0; n2 < t2.length; n2++)
            r2.push(Tt(e2, i2, t2[n2]));
          return r2;
        }
        function wt(e2) {
          return void 0 !== t.InstallTrigger && 2 === e2.button && e2.ctrlKey && t.navigator.platform.toUpperCase().indexOf("MAC") >= 0 ? 0 : e2.button;
        }
        function Tt(e2, t2, i2) {
          const r2 = e2.offsetWidth === t2.width ? 1 : e2.offsetWidth / t2.width;
          return new y((i2.clientX - t2.left) * r2, (i2.clientY - t2.top) * r2);
        }
        function Et(e2, t2, i2) {
          i2[e2] && -1 !== i2[e2].indexOf(t2) || (i2[e2] = i2[e2] || [], i2[e2].push(t2));
        }
        function Mt(e2, t2, i2) {
          if (i2 && i2[e2]) {
            const r2 = i2[e2].indexOf(t2);
            -1 !== r2 && i2[e2].splice(r2, 1);
          }
        }
        class At {
          constructor(e2, t2 = {}) {
            k(this, t2), this.type = e2;
          }
        }
        class St extends At {
          constructor(e2, t2 = {}) {
            super("error", k({ error: e2 }, t2));
          }
        }
        class It {
          on(e2, t2) {
            return this._listeners = this._listeners || {}, Et(e2, t2, this._listeners), this;
          }
          off(e2, t2) {
            return Mt(e2, t2, this._listeners), Mt(e2, t2, this._oneTimeListeners), this;
          }
          once(e2, t2) {
            return t2 ? (this._oneTimeListeners = this._oneTimeListeners || {}, Et(e2, t2, this._oneTimeListeners), this) : new Promise((t3) => this.once(e2, t3));
          }
          fire(e2, t2) {
            "string" == typeof e2 && (e2 = new At(e2, t2 || {}));
            const i2 = e2.type;
            if (this.listens(i2)) {
              e2.target = this;
              const t3 = this._listeners && this._listeners[i2] ? this._listeners[i2].slice() : [];
              for (const i3 of t3)
                i3.call(this, e2);
              const r2 = this._oneTimeListeners && this._oneTimeListeners[i2] ? this._oneTimeListeners[i2].slice() : [];
              for (const t4 of r2)
                Mt(i2, t4, this._oneTimeListeners), t4.call(this, e2);
              const n2 = this._eventedParent;
              n2 && (k(e2, "function" == typeof this._eventedParentData ? this._eventedParentData() : this._eventedParentData), n2.fire(e2));
            } else
              e2 instanceof St && console.error(e2.error);
            return this;
          }
          listens(e2) {
            return !!(this._listeners && this._listeners[e2] && this._listeners[e2].length > 0 || this._oneTimeListeners && this._oneTimeListeners[e2] && this._oneTimeListeners[e2].length > 0 || this._eventedParent && this._eventedParent.listens(e2));
          }
          setEventedParent(e2, t2) {
            return this._eventedParent = e2, this._eventedParentData = t2, this;
          }
        }
        var Ct = JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain"},"fog":{"type":"fog"},"camera":{"type":"camera"},"imports":{"type":"array","value":"import"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"expression":{},"property-type":"data-constant"},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"hillshade":{},"model":{},"background":{},"sky":{},"slot":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","default":[0,1],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');
        class zt {
          constructor(e2, t2, i2, r2) {
            this.message = (e2 ? `${e2}: ` : "") + i2, r2 && (this.identifier = r2), null != t2 && t2.__line__ && (this.line = t2.__line__);
          }
        }
        class Dt extends zt {
        }
        function Pt(e2, ...t2) {
          for (const i2 of t2)
            for (const t3 in i2)
              e2[t3] = i2[t3];
          return e2;
        }
        function Rt(e2) {
          return e2 instanceof Number || e2 instanceof String || e2 instanceof Boolean ? e2.valueOf() : e2;
        }
        function Lt(e2) {
          if (Array.isArray(e2))
            return e2.map(Lt);
          if (e2 instanceof Object && !(e2 instanceof Number || e2 instanceof String || e2 instanceof Boolean)) {
            const t2 = {};
            for (const i2 in e2)
              t2[i2] = Lt(e2[i2]);
            return t2;
          }
          return Rt(e2);
        }
        class kt extends Error {
          constructor(e2, t2) {
            super(t2), this.message = t2, this.key = e2;
          }
        }
        var Ot = kt;
        class Bt {
          constructor(e2, t2 = []) {
            this.parent = e2, this.bindings = {};
            for (const [e3, i2] of t2)
              this.bindings[e3] = i2;
          }
          concat(e2) {
            return new Bt(this, e2);
          }
          get(e2) {
            if (this.bindings[e2])
              return this.bindings[e2];
            if (this.parent)
              return this.parent.get(e2);
            throw new Error(`${e2} not found in scope.`);
          }
          has(e2) {
            return !!this.bindings[e2] || !!this.parent && this.parent.has(e2);
          }
        }
        var Ft = Bt;
        const Nt = { kind: "null" }, Ut = { kind: "number" }, Vt = { kind: "string" }, jt = { kind: "boolean" }, Gt = { kind: "color" }, qt = { kind: "object" }, Zt = { kind: "value" }, $t = { kind: "collator" }, Ht = { kind: "formatted" }, Wt = { kind: "resolvedImage" };
        function Xt(e2, t2) {
          return { kind: "array", itemType: e2, N: t2 };
        }
        function Yt(e2) {
          if ("array" === e2.kind) {
            const t2 = Yt(e2.itemType);
            return "number" == typeof e2.N ? `array<${t2}, ${e2.N}>` : "value" === e2.itemType.kind ? "array" : `array<${t2}>`;
          }
          return e2.kind;
        }
        const Kt = [Nt, Ut, Vt, jt, Gt, Ht, qt, Xt(Zt), Wt];
        function Jt(e2, t2) {
          if ("error" === t2.kind)
            return null;
          if ("array" === e2.kind) {
            if ("array" === t2.kind && (0 === t2.N && "value" === t2.itemType.kind || !Jt(e2.itemType, t2.itemType)) && ("number" != typeof e2.N || e2.N === t2.N))
              return null;
          } else {
            if (e2.kind === t2.kind)
              return null;
            if ("value" === e2.kind) {
              for (const e3 of Kt)
                if (!Jt(e3, t2))
                  return null;
            }
          }
          return `Expected ${Yt(e2)} but found ${Yt(t2)} instead.`;
        }
        function Qt(e2, t2) {
          return t2.some((t3) => t3.kind === e2.kind);
        }
        function ei(e2, t2) {
          return t2.some((t3) => "null" === t3 ? null === e2 : "array" === t3 ? Array.isArray(e2) : "object" === t3 ? e2 && !Array.isArray(e2) && "object" == typeof e2 : t3 === typeof e2);
        }
        var ti, ii = { transparent: [0, 0, 0, 0], aliceblue: [240, 248, 255, 1], antiquewhite: [250, 235, 215, 1], aqua: [0, 255, 255, 1], aquamarine: [127, 255, 212, 1], azure: [240, 255, 255, 1], beige: [245, 245, 220, 1], bisque: [255, 228, 196, 1], black: [0, 0, 0, 1], blanchedalmond: [255, 235, 205, 1], blue: [0, 0, 255, 1], blueviolet: [138, 43, 226, 1], brown: [165, 42, 42, 1], burlywood: [222, 184, 135, 1], cadetblue: [95, 158, 160, 1], chartreuse: [127, 255, 0, 1], chocolate: [210, 105, 30, 1], coral: [255, 127, 80, 1], cornflowerblue: [100, 149, 237, 1], cornsilk: [255, 248, 220, 1], crimson: [220, 20, 60, 1], cyan: [0, 255, 255, 1], darkblue: [0, 0, 139, 1], darkcyan: [0, 139, 139, 1], darkgoldenrod: [184, 134, 11, 1], darkgray: [169, 169, 169, 1], darkgreen: [0, 100, 0, 1], darkgrey: [169, 169, 169, 1], darkkhaki: [189, 183, 107, 1], darkmagenta: [139, 0, 139, 1], darkolivegreen: [85, 107, 47, 1], darkorange: [255, 140, 0, 1], darkorchid: [153, 50, 204, 1], darkred: [139, 0, 0, 1], darksalmon: [233, 150, 122, 1], darkseagreen: [143, 188, 143, 1], darkslateblue: [72, 61, 139, 1], darkslategray: [47, 79, 79, 1], darkslategrey: [47, 79, 79, 1], darkturquoise: [0, 206, 209, 1], darkviolet: [148, 0, 211, 1], deeppink: [255, 20, 147, 1], deepskyblue: [0, 191, 255, 1], dimgray: [105, 105, 105, 1], dimgrey: [105, 105, 105, 1], dodgerblue: [30, 144, 255, 1], firebrick: [178, 34, 34, 1], floralwhite: [255, 250, 240, 1], forestgreen: [34, 139, 34, 1], fuchsia: [255, 0, 255, 1], gainsboro: [220, 220, 220, 1], ghostwhite: [248, 248, 255, 1], gold: [255, 215, 0, 1], goldenrod: [218, 165, 32, 1], gray: [128, 128, 128, 1], green: [0, 128, 0, 1], greenyellow: [173, 255, 47, 1], grey: [128, 128, 128, 1], honeydew: [240, 255, 240, 1], hotpink: [255, 105, 180, 1], indianred: [205, 92, 92, 1], indigo: [75, 0, 130, 1], ivory: [255, 255, 240, 1], khaki: [240, 230, 140, 1], lavender: [230, 230, 250, 1], lavenderblush: [255, 240, 245, 1], lawngreen: [124, 252, 0, 1], lemonchiffon: [255, 250, 205, 1], lightblue: [173, 216, 230, 1], lightcoral: [240, 128, 128, 1], lightcyan: [224, 255, 255, 1], lightgoldenrodyellow: [250, 250, 210, 1], lightgray: [211, 211, 211, 1], lightgreen: [144, 238, 144, 1], lightgrey: [211, 211, 211, 1], lightpink: [255, 182, 193, 1], lightsalmon: [255, 160, 122, 1], lightseagreen: [32, 178, 170, 1], lightskyblue: [135, 206, 250, 1], lightslategray: [119, 136, 153, 1], lightslategrey: [119, 136, 153, 1], lightsteelblue: [176, 196, 222, 1], lightyellow: [255, 255, 224, 1], lime: [0, 255, 0, 1], limegreen: [50, 205, 50, 1], linen: [250, 240, 230, 1], magenta: [255, 0, 255, 1], maroon: [128, 0, 0, 1], mediumaquamarine: [102, 205, 170, 1], mediumblue: [0, 0, 205, 1], mediumorchid: [186, 85, 211, 1], mediumpurple: [147, 112, 219, 1], mediumseagreen: [60, 179, 113, 1], mediumslateblue: [123, 104, 238, 1], mediumspringgreen: [0, 250, 154, 1], mediumturquoise: [72, 209, 204, 1], mediumvioletred: [199, 21, 133, 1], midnightblue: [25, 25, 112, 1], mintcream: [245, 255, 250, 1], mistyrose: [255, 228, 225, 1], moccasin: [255, 228, 181, 1], navajowhite: [255, 222, 173, 1], navy: [0, 0, 128, 1], oldlace: [253, 245, 230, 1], olive: [128, 128, 0, 1], olivedrab: [107, 142, 35, 1], orange: [255, 165, 0, 1], orangered: [255, 69, 0, 1], orchid: [218, 112, 214, 1], palegoldenrod: [238, 232, 170, 1], palegreen: [152, 251, 152, 1], paleturquoise: [175, 238, 238, 1], palevioletred: [219, 112, 147, 1], papayawhip: [255, 239, 213, 1], peachpuff: [255, 218, 185, 1], peru: [205, 133, 63, 1], pink: [255, 192, 203, 1], plum: [221, 160, 221, 1], powderblue: [176, 224, 230, 1], purple: [128, 0, 128, 1], rebeccapurple: [102, 51, 153, 1], red: [255, 0, 0, 1], rosybrown: [188, 143, 143, 1], royalblue: [65, 105, 225, 1], saddlebrown: [139, 69, 19, 1], salmon: [250, 128, 114, 1], sandybrown: [244, 164, 96, 1], seagreen: [46, 139, 87, 1], seashell: [255, 245, 238, 1], sienna: [160, 82, 45, 1], silver: [192, 192, 192, 1], skyblue: [135, 206, 235, 1], slateblue: [106, 90, 205, 1], slategray: [112, 128, 144, 1], slategrey: [112, 128, 144, 1], snow: [255, 250, 250, 1], springgreen: [0, 255, 127, 1], steelblue: [70, 130, 180, 1], tan: [210, 180, 140, 1], teal: [0, 128, 128, 1], thistle: [216, 191, 216, 1], tomato: [255, 99, 71, 1], turquoise: [64, 224, 208, 1], violet: [238, 130, 238, 1], wheat: [245, 222, 179, 1], white: [255, 255, 255, 1], whitesmoke: [245, 245, 245, 1], yellow: [255, 255, 0, 1], yellowgreen: [154, 205, 50, 1] };
        function ri(e2) {
          return (e2 = Math.round(e2)) < 0 ? 0 : e2 > 255 ? 255 : e2;
        }
        function ni(e2) {
          return ri("%" === e2[e2.length - 1] ? parseFloat(e2) / 100 * 255 : parseInt(e2));
        }
        function oi(e2) {
          return (t2 = "%" === e2[e2.length - 1] ? parseFloat(e2) / 100 : parseFloat(e2)) < 0 ? 0 : t2 > 1 ? 1 : t2;
          var t2;
        }
        function si(e2, t2, i2) {
          return i2 < 0 ? i2 += 1 : i2 > 1 && (i2 -= 1), 6 * i2 < 1 ? e2 + (t2 - e2) * i2 * 6 : 2 * i2 < 1 ? t2 : 3 * i2 < 2 ? e2 + (t2 - e2) * (2 / 3 - i2) * 6 : e2;
        }
        try {
          ti = {}.parseCSSColor = function(e2) {
            var t2, i2 = e2.replace(/ /g, "").toLowerCase();
            if (i2 in ii)
              return ii[i2].slice();
            if ("#" === i2[0])
              return 4 === i2.length ? (t2 = parseInt(i2.substr(1), 16)) >= 0 && t2 <= 4095 ? [(3840 & t2) >> 4 | (3840 & t2) >> 8, 240 & t2 | (240 & t2) >> 4, 15 & t2 | (15 & t2) << 4, 1] : null : 7 === i2.length && (t2 = parseInt(i2.substr(1), 16)) >= 0 && t2 <= 16777215 ? [(16711680 & t2) >> 16, (65280 & t2) >> 8, 255 & t2, 1] : null;
            var r2 = i2.indexOf("("), n2 = i2.indexOf(")");
            if (-1 !== r2 && n2 + 1 === i2.length) {
              var o2 = i2.substr(0, r2), s2 = i2.substr(r2 + 1, n2 - (r2 + 1)).split(","), a2 = 1;
              switch (o2) {
                case "rgba":
                  if (4 !== s2.length)
                    return null;
                  a2 = oi(s2.pop());
                case "rgb":
                  return 3 !== s2.length ? null : [ni(s2[0]), ni(s2[1]), ni(s2[2]), a2];
                case "hsla":
                  if (4 !== s2.length)
                    return null;
                  a2 = oi(s2.pop());
                case "hsl":
                  if (3 !== s2.length)
                    return null;
                  var l2 = (parseFloat(s2[0]) % 360 + 360) % 360 / 360, c2 = oi(s2[1]), h2 = oi(s2[2]), u2 = h2 <= 0.5 ? h2 * (c2 + 1) : h2 + c2 - h2 * c2, d2 = 2 * h2 - u2;
                  return [ri(255 * si(d2, u2, l2 + 1 / 3)), ri(255 * si(d2, u2, l2)), ri(255 * si(d2, u2, l2 - 1 / 3)), a2];
                default:
                  return null;
              }
            }
            return null;
          };
        } catch (e2) {
        }
        class ai {
          constructor(e2, t2, i2, r2 = 1) {
            this.r = e2, this.g = t2, this.b = i2, this.a = r2;
          }
          static parse(e2) {
            if (!e2)
              return;
            if (e2 instanceof ai)
              return e2;
            if ("string" != typeof e2)
              return;
            const t2 = ti(e2);
            return t2 ? new ai(t2[0] / 255 * t2[3], t2[1] / 255 * t2[3], t2[2] / 255 * t2[3], t2[3]) : void 0;
          }
          toString() {
            const [e2, t2, i2, r2] = this.toArray();
            return `rgba(${Math.round(e2)},${Math.round(t2)},${Math.round(i2)},${r2})`;
          }
          toArray() {
            const { r: e2, g: t2, b: i2, a: r2 } = this;
            return 0 === r2 ? [0, 0, 0, 0] : [255 * e2 / r2, 255 * t2 / r2, 255 * i2 / r2, r2];
          }
          toArray01() {
            const { r: e2, g: t2, b: i2, a: r2 } = this;
            return 0 === r2 ? [0, 0, 0, 0] : [e2 / r2, t2 / r2, i2 / r2, r2];
          }
          toArray01Scaled(e2) {
            const { r: t2, g: i2, b: r2, a: n2 } = this;
            return 0 === n2 ? [0, 0, 0] : [t2 / n2 * e2, i2 / n2 * e2, r2 / n2 * e2];
          }
          toArray01PremultipliedAlpha() {
            const { r: e2, g: t2, b: i2, a: r2 } = this;
            return [e2, t2, i2, r2];
          }
          toArray01Linear() {
            const { r: e2, g: t2, b: i2, a: r2 } = this;
            return 0 === r2 ? [0, 0, 0, 0] : [Math.pow(e2 / r2, 2.2), Math.pow(t2 / r2, 2.2), Math.pow(i2 / r2, 2.2), r2];
          }
        }
        ai.black = new ai(0, 0, 0, 1), ai.white = new ai(1, 1, 1, 1), ai.transparent = new ai(0, 0, 0, 0), ai.red = new ai(1, 0, 0, 1), ai.blue = new ai(0, 0, 1, 1);
        var li = ai;
        class ci {
          constructor(e2, t2, i2) {
            this.sensitivity = e2 ? t2 ? "variant" : "case" : t2 ? "accent" : "base", this.locale = i2, this.collator = new Intl.Collator(this.locale ? this.locale : [], { sensitivity: this.sensitivity, usage: "search" });
          }
          compare(e2, t2) {
            return this.collator.compare(e2, t2);
          }
          resolvedLocale() {
            return new Intl.Collator(this.locale ? this.locale : []).resolvedOptions().locale;
          }
        }
        class hi {
          constructor(e2, t2, i2, r2, n2) {
            this.text = e2.normalize ? e2.normalize() : e2, this.image = t2, this.scale = i2, this.fontStack = r2, this.textColor = n2;
          }
        }
        class ui {
          constructor(e2) {
            this.sections = e2;
          }
          static fromString(e2) {
            return new ui([new hi(e2, null, null, null, null)]);
          }
          isEmpty() {
            return 0 === this.sections.length || !this.sections.some((e2) => 0 !== e2.text.length || e2.image && 0 !== e2.image.namePrimary.length);
          }
          static factory(e2) {
            return e2 instanceof ui ? e2 : ui.fromString(e2);
          }
          toString() {
            return 0 === this.sections.length ? "" : this.sections.map((e2) => e2.text).join("");
          }
          serialize() {
            const e2 = ["format"];
            for (const t2 of this.sections) {
              if (t2.image) {
                e2.push(["image", t2.image.namePrimary]);
                continue;
              }
              e2.push(t2.text);
              const i2 = {};
              t2.fontStack && (i2["text-font"] = ["literal", t2.fontStack.split(",")]), t2.scale && (i2["font-scale"] = t2.scale), t2.textColor && (i2["text-color"] = ["rgba"].concat(t2.textColor.toArray())), e2.push(i2);
            }
            return e2;
          }
        }
        class di {
          constructor(e2) {
            this.namePrimary = e2.namePrimary, e2.nameSecondary && (this.nameSecondary = e2.nameSecondary), this.available = e2.available;
          }
          toString() {
            return this.nameSecondary ? `[${this.namePrimary},${this.nameSecondary}]` : this.namePrimary;
          }
          static fromString(e2, t2) {
            return e2 ? new di({ namePrimary: e2, nameSecondary: t2, available: false }) : null;
          }
          serialize() {
            return this.nameSecondary ? ["image", this.namePrimary, this.nameSecondary] : ["image", this.namePrimary];
          }
        }
        function pi(e2, t2, i2, r2) {
          return "number" == typeof e2 && e2 >= 0 && e2 <= 255 && "number" == typeof t2 && t2 >= 0 && t2 <= 255 && "number" == typeof i2 && i2 >= 0 && i2 <= 255 ? void 0 === r2 || "number" == typeof r2 && r2 >= 0 && r2 <= 1 ? null : `Invalid rgba value [${[e2, t2, i2, r2].join(", ")}]: 'a' must be between 0 and 1.` : `Invalid rgba value [${("number" == typeof r2 ? [e2, t2, i2, r2] : [e2, t2, i2]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`;
        }
        function fi(e2) {
          if (null === e2)
            return true;
          if ("string" == typeof e2)
            return true;
          if ("boolean" == typeof e2)
            return true;
          if ("number" == typeof e2)
            return true;
          if (e2 instanceof li)
            return true;
          if (e2 instanceof ci)
            return true;
          if (e2 instanceof ui)
            return true;
          if (e2 instanceof di)
            return true;
          if (Array.isArray(e2)) {
            for (const t2 of e2)
              if (!fi(t2))
                return false;
            return true;
          }
          if ("object" == typeof e2) {
            for (const t2 in e2)
              if (!fi(e2[t2]))
                return false;
            return true;
          }
          return false;
        }
        function mi(e2) {
          if (null === e2)
            return Nt;
          if ("string" == typeof e2)
            return Vt;
          if ("boolean" == typeof e2)
            return jt;
          if ("number" == typeof e2)
            return Ut;
          if (e2 instanceof li)
            return Gt;
          if (e2 instanceof ci)
            return $t;
          if (e2 instanceof ui)
            return Ht;
          if (e2 instanceof di)
            return Wt;
          if (Array.isArray(e2)) {
            const t2 = e2.length;
            let i2;
            for (const t3 of e2) {
              const e3 = mi(t3);
              if (i2) {
                if (i2 === e3)
                  continue;
                i2 = Zt;
                break;
              }
              i2 = e3;
            }
            return Xt(i2 || Zt, t2);
          }
          return qt;
        }
        function _i(e2) {
          const t2 = typeof e2;
          return null === e2 ? "" : "string" === t2 || "number" === t2 || "boolean" === t2 ? String(e2) : e2 instanceof li || e2 instanceof ui || e2 instanceof di ? e2.toString() : JSON.stringify(e2);
        }
        class gi {
          constructor(e2, t2) {
            this.type = e2, this.value = t2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length)
              return t2.error(`'literal' expression requires exactly one argument, but found ${e2.length - 1} instead.`);
            if (!fi(e2[1]))
              return t2.error("invalid value");
            const i2 = e2[1];
            let r2 = mi(i2);
            const n2 = t2.expectedType;
            return "array" !== r2.kind || 0 !== r2.N || !n2 || "array" !== n2.kind || "number" == typeof n2.N && 0 !== n2.N || (r2 = n2), new gi(r2, i2);
          }
          evaluate() {
            return this.value;
          }
          eachChild() {
          }
          outputDefined() {
            return true;
          }
          serialize() {
            return "array" === this.type.kind || "object" === this.type.kind ? ["literal", this.value] : this.value instanceof li ? ["rgba"].concat(this.value.toArray()) : this.value instanceof ui ? this.value.serialize() : this.value;
          }
        }
        var yi = gi, xi = class {
          constructor(e2) {
            this.name = "ExpressionEvaluationError", this.message = e2;
          }
          toJSON() {
            return this.message;
          }
        };
        const vi = { string: Vt, number: Ut, boolean: jt, object: qt };
        class bi {
          constructor(e2, t2) {
            this.type = e2, this.args = t2;
          }
          static parse(e2, t2) {
            if (e2.length < 2)
              return t2.error("Expected at least one argument.");
            let i2, r2 = 1;
            const n2 = e2[0];
            if ("array" === n2) {
              let n3, o3;
              if (e2.length > 2) {
                const i3 = e2[1];
                if ("string" != typeof i3 || !(i3 in vi) || "object" === i3)
                  return t2.error('The item type argument of "array" must be one of string, number, boolean', 1);
                n3 = vi[i3], r2++;
              } else
                n3 = Zt;
              if (e2.length > 3) {
                if (null !== e2[2] && ("number" != typeof e2[2] || e2[2] < 0 || e2[2] !== Math.floor(e2[2])))
                  return t2.error('The length argument to "array" must be a positive integer literal', 2);
                o3 = e2[2], r2++;
              }
              i2 = Xt(n3, o3);
            } else
              i2 = vi[n2];
            const o2 = [];
            for (; r2 < e2.length; r2++) {
              const i3 = t2.parse(e2[r2], r2, Zt);
              if (!i3)
                return null;
              o2.push(i3);
            }
            return new bi(i2, o2);
          }
          evaluate(e2) {
            for (let t2 = 0; t2 < this.args.length; t2++) {
              const i2 = this.args[t2].evaluate(e2);
              if (!Jt(this.type, mi(i2)))
                return i2;
              if (t2 === this.args.length - 1)
                throw new xi(`Expected value to be of type ${Yt(this.type)}, but found ${Yt(mi(i2))} instead.`);
            }
            return null;
          }
          eachChild(e2) {
            this.args.forEach(e2);
          }
          outputDefined() {
            return this.args.every((e2) => e2.outputDefined());
          }
          serialize() {
            const e2 = this.type, t2 = [e2.kind];
            if ("array" === e2.kind) {
              const i2 = e2.itemType;
              if ("string" === i2.kind || "number" === i2.kind || "boolean" === i2.kind) {
                t2.push(i2.kind);
                const r2 = e2.N;
                ("number" == typeof r2 || this.args.length > 1) && t2.push(r2);
              }
            }
            return t2.concat(this.args.map((e3) => e3.serialize()));
          }
        }
        var wi = bi;
        class Ti {
          constructor(e2) {
            this.type = Ht, this.sections = e2;
          }
          static parse(e2, t2) {
            if (e2.length < 2)
              return t2.error("Expected at least one argument.");
            const i2 = e2[1];
            if (!Array.isArray(i2) && "object" == typeof i2)
              return t2.error("First argument must be an image or text section.");
            const r2 = [];
            let n2 = false;
            for (let i3 = 1; i3 <= e2.length - 1; ++i3) {
              const o2 = e2[i3];
              if (n2 && "object" == typeof o2 && !Array.isArray(o2)) {
                n2 = false;
                let e3 = null;
                if (o2["font-scale"] && (e3 = t2.parse(o2["font-scale"], 1, Ut), !e3))
                  return null;
                let i4 = null;
                if (o2["text-font"] && (i4 = t2.parse(o2["text-font"], 1, Xt(Vt)), !i4))
                  return null;
                let s2 = null;
                if (o2["text-color"] && (s2 = t2.parse(o2["text-color"], 1, Gt), !s2))
                  return null;
                const a2 = r2[r2.length - 1];
                a2.scale = e3, a2.font = i4, a2.textColor = s2;
              } else {
                const o3 = t2.parse(e2[i3], 1, Zt);
                if (!o3)
                  return null;
                const s2 = o3.type.kind;
                if ("string" !== s2 && "value" !== s2 && "null" !== s2 && "resolvedImage" !== s2)
                  return t2.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");
                n2 = true, r2.push({ content: o3, scale: null, font: null, textColor: null });
              }
            }
            return new Ti(r2);
          }
          evaluate(e2) {
            return new ui(this.sections.map((t2) => {
              const i2 = t2.content.evaluate(e2);
              return mi(i2) === Wt ? new hi("", i2, null, null, null) : new hi(_i(i2), null, t2.scale ? t2.scale.evaluate(e2) : null, t2.font ? t2.font.evaluate(e2).join(",") : null, t2.textColor ? t2.textColor.evaluate(e2) : null);
            }));
          }
          eachChild(e2) {
            for (const t2 of this.sections)
              e2(t2.content), t2.scale && e2(t2.scale), t2.font && e2(t2.font), t2.textColor && e2(t2.textColor);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            const e2 = ["format"];
            for (const t2 of this.sections) {
              e2.push(t2.content.serialize());
              const i2 = {};
              t2.scale && (i2["font-scale"] = t2.scale.serialize()), t2.font && (i2["text-font"] = t2.font.serialize()), t2.textColor && (i2["text-color"] = t2.textColor.serialize()), e2.push(i2);
            }
            return e2;
          }
        }
        class Ei {
          constructor(e2, t2) {
            this.type = Wt, this.inputPrimary = e2, this.inputSecondary = t2;
          }
          static parse(e2, t2) {
            if (e2.length < 2)
              return t2.error("Expected two or more arguments.");
            const i2 = t2.parse(e2[1], 1, Vt);
            if (!i2)
              return t2.error("No image name provided.");
            if (2 === e2.length)
              return new Ei(i2);
            const r2 = t2.parse(e2[2], 1, Vt);
            return r2 ? new Ei(i2, r2) : t2.error("Secondary image variant is not a string.");
          }
          evaluate(e2) {
            const t2 = di.fromString(this.inputPrimary.evaluate(e2), this.inputSecondary ? this.inputSecondary.evaluate(e2) : void 0);
            return t2 && e2.availableImages && (t2.available = e2.availableImages.indexOf(t2.namePrimary) > -1, t2.nameSecondary && t2.available && e2.availableImages && (t2.available = e2.availableImages.indexOf(t2.nameSecondary) > -1)), t2;
          }
          eachChild(e2) {
            e2(this.inputPrimary), this.inputSecondary && e2(this.inputSecondary);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            return this.inputSecondary ? ["image", this.inputPrimary.serialize(), this.inputSecondary.serialize()] : ["image", this.inputPrimary.serialize()];
          }
        }
        function Mi(e2) {
          return e2 instanceof Number ? "number" : e2 instanceof String ? "string" : e2 instanceof Boolean ? "boolean" : Array.isArray(e2) ? "array" : null === e2 ? "null" : typeof e2;
        }
        const Ai = { "to-boolean": jt, "to-color": Gt, "to-number": Ut, "to-string": Vt };
        class Si {
          constructor(e2, t2) {
            this.type = e2, this.args = t2;
          }
          static parse(e2, t2) {
            if (e2.length < 2)
              return t2.error("Expected at least one argument.");
            const i2 = e2[0], r2 = [];
            let n2 = Nt;
            if ("to-array" === i2) {
              if (!Array.isArray(e2[1]))
                return null;
              const i3 = e2[1].length;
              if (t2.expectedType) {
                if ("array" !== t2.expectedType.kind)
                  return t2.error(`Expected ${t2.expectedType.kind} but found array.`);
                n2 = Xt(t2.expectedType.itemType, i3);
              } else {
                if (!(i3 > 0 && fi(e2[1][0])))
                  return null;
                n2 = Xt(mi(e2[1][0]), i3);
              }
              for (let o2 = 0; o2 < i3; o2++) {
                const i4 = e2[1][o2];
                let s2;
                if ("array" === Mi(i4))
                  s2 = t2.parse(i4, void 0, n2.itemType);
                else {
                  const e3 = Mi(i4);
                  if (e3 !== n2.itemType.kind)
                    return t2.error(`Expected ${n2.itemType.kind} but found ${e3}.`);
                  s2 = t2.registry.literal.parse(["literal", void 0 === i4 ? null : i4], t2);
                }
                if (!s2)
                  return null;
                r2.push(s2);
              }
            } else {
              if (("to-boolean" === i2 || "to-string" === i2) && 2 !== e2.length)
                return t2.error("Expected one argument.");
              n2 = Ai[i2];
              for (let i3 = 1; i3 < e2.length; i3++) {
                const n3 = t2.parse(e2[i3], i3, Zt);
                if (!n3)
                  return null;
                r2.push(n3);
              }
            }
            return new Si(n2, r2);
          }
          evaluate(e2) {
            if ("boolean" === this.type.kind)
              return Boolean(this.args[0].evaluate(e2));
            if ("color" === this.type.kind) {
              let t2, i2;
              for (const r2 of this.args) {
                if (t2 = r2.evaluate(e2), i2 = null, t2 instanceof li)
                  return t2;
                if ("string" == typeof t2) {
                  const i3 = e2.parseColor(t2);
                  if (i3)
                    return i3;
                } else if (Array.isArray(t2) && (i2 = t2.length < 3 || t2.length > 4 ? `Invalid rbga value ${JSON.stringify(t2)}: expected an array containing either three or four numeric values.` : pi(t2[0], t2[1], t2[2], t2[3]), !i2))
                  return new li(t2[0] / 255, t2[1] / 255, t2[2] / 255, t2[3]);
              }
              throw new xi(i2 || `Could not parse color from value '${"string" == typeof t2 ? t2 : String(JSON.stringify(t2))}'`);
            }
            if ("number" === this.type.kind) {
              let t2 = null;
              for (const i2 of this.args) {
                if (t2 = i2.evaluate(e2), null === t2)
                  return 0;
                const r2 = Number(t2);
                if (!isNaN(r2))
                  return r2;
              }
              throw new xi(`Could not convert ${JSON.stringify(t2)} to number.`);
            }
            return "formatted" === this.type.kind ? ui.fromString(_i(this.args[0].evaluate(e2))) : "resolvedImage" === this.type.kind ? di.fromString(_i(this.args[0].evaluate(e2))) : "array" === this.type.kind ? this.args.map((t2) => t2.evaluate(e2)) : _i(this.args[0].evaluate(e2));
          }
          eachChild(e2) {
            this.args.forEach(e2);
          }
          outputDefined() {
            return this.args.every((e2) => e2.outputDefined());
          }
          serialize() {
            if ("formatted" === this.type.kind)
              return new Ti([{ content: this.args[0], scale: null, font: null, textColor: null }]).serialize();
            if ("resolvedImage" === this.type.kind)
              return new Ei(this.args[0]).serialize();
            const e2 = "array" === this.type.kind ? [] : [`to-${this.type.kind}`];
            return this.eachChild((t2) => {
              e2.push(t2.serialize());
            }), e2;
          }
        }
        var Ii = Si;
        const Ci = ["Unknown", "Point", "LineString", "Polygon"];
        var zi = class {
          constructor(e2) {
            this.globals = null, this.feature = null, this.featureState = null, this.formattedSection = null, this._parseColorCache = {}, this.availableImages = null, this.canonical = null, this.featureTileCoord = null, this.featureDistanceData = null, this.options = e2;
          }
          id() {
            return this.feature && void 0 !== this.feature.id ? this.feature.id : null;
          }
          geometryType() {
            return this.feature ? "number" == typeof this.feature.type ? Ci[this.feature.type] : this.feature.type : null;
          }
          geometry() {
            return this.feature && "geometry" in this.feature ? this.feature.geometry : null;
          }
          canonicalID() {
            return this.canonical;
          }
          properties() {
            return this.feature && this.feature.properties || {};
          }
          measureLight(e2) {
            return this.globals.brightness || 0;
          }
          distanceFromCenter() {
            if (this.featureTileCoord && this.featureDistanceData) {
              const e2 = this.featureDistanceData.center, t2 = this.featureDistanceData.scale, { x: i2, y: r2 } = this.featureTileCoord;
              return this.featureDistanceData.bearing[0] * (i2 * t2 - e2[0]) + this.featureDistanceData.bearing[1] * (r2 * t2 - e2[1]);
            }
            return 0;
          }
          parseColor(e2) {
            let t2 = this._parseColorCache[e2];
            return t2 || (t2 = this._parseColorCache[e2] = li.parse(e2)), t2;
          }
          getConfig(e2) {
            return this.options ? this.options.get(e2) : null;
          }
        };
        class Di {
          constructor(e2, t2, i2, r2) {
            this.name = e2, this.type = t2, this._evaluate = i2, this.args = r2;
          }
          evaluate(e2) {
            return this._evaluate(e2, this.args);
          }
          eachChild(e2) {
            this.args.forEach(e2);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            return [this.name].concat(this.args.map((e2) => e2.serialize()));
          }
          static parse(e2, t2) {
            const i2 = e2[0], r2 = Di.definitions[i2];
            if (!r2)
              return t2.error(`Unknown expression "${i2}". If you wanted a literal array, use ["literal", [...]].`, 0);
            const n2 = Array.isArray(r2) ? r2[0] : r2.type, o2 = Array.isArray(r2) ? [[r2[1], r2[2]]] : r2.overloads, s2 = o2.filter(([t3]) => !Array.isArray(t3) || t3.length === e2.length - 1);
            let a2 = null;
            for (const [r3, o3] of s2) {
              a2 = new Gr(t2.registry, t2.path, null, t2.scope, void 0, t2.options);
              const s3 = [];
              let l2 = false;
              for (let t3 = 1; t3 < e2.length; t3++) {
                const i3 = e2[t3], n3 = Array.isArray(r3) ? r3[t3 - 1] : r3.type, o4 = a2.parse(i3, 1 + s3.length, n3);
                if (!o4) {
                  l2 = true;
                  break;
                }
                s3.push(o4);
              }
              if (!l2)
                if (Array.isArray(r3) && r3.length !== s3.length)
                  a2.error(`Expected ${r3.length} arguments, but found ${s3.length} instead.`);
                else {
                  for (let e3 = 0; e3 < s3.length; e3++) {
                    const t3 = Array.isArray(r3) ? r3[e3] : r3.type, i3 = s3[e3];
                    a2.concat(e3 + 1).checkSubtype(t3, i3.type);
                  }
                  if (0 === a2.errors.length)
                    return new Di(i2, n2, o3, s3);
                }
            }
            if (1 === s2.length)
              t2.errors.push(...a2.errors);
            else {
              const i3 = (s2.length ? s2 : o2).map(([e3]) => {
                return t3 = e3, Array.isArray(t3) ? `(${t3.map(Yt).join(", ")})` : `(${Yt(t3.type)}...)`;
                var t3;
              }).join(" | "), r3 = [];
              for (let i4 = 1; i4 < e2.length; i4++) {
                const n3 = t2.parse(e2[i4], 1 + r3.length);
                if (!n3)
                  return null;
                r3.push(Yt(n3.type));
              }
              t2.error(`Expected arguments of type ${i3}, but found (${r3.join(", ")}) instead.`);
            }
            return null;
          }
          static register(e2, t2) {
            Di.definitions = t2;
            for (const i2 in t2)
              e2[i2] = Di;
          }
        }
        var Pi = Di;
        class Ri {
          constructor(e2, t2, i2) {
            this.type = $t, this.locale = i2, this.caseSensitive = e2, this.diacriticSensitive = t2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length)
              return t2.error("Expected one argument.");
            const i2 = e2[1];
            if ("object" != typeof i2 || Array.isArray(i2))
              return t2.error("Collator options argument must be an object.");
            const r2 = t2.parse(void 0 !== i2["case-sensitive"] && i2["case-sensitive"], 1, jt);
            if (!r2)
              return null;
            const n2 = t2.parse(void 0 !== i2["diacritic-sensitive"] && i2["diacritic-sensitive"], 1, jt);
            if (!n2)
              return null;
            let o2 = null;
            return i2.locale && (o2 = t2.parse(i2.locale, 1, Vt), !o2) ? null : new Ri(r2, n2, o2);
          }
          evaluate(e2) {
            return new ci(this.caseSensitive.evaluate(e2), this.diacriticSensitive.evaluate(e2), this.locale ? this.locale.evaluate(e2) : null);
          }
          eachChild(e2) {
            e2(this.caseSensitive), e2(this.diacriticSensitive), this.locale && e2(this.locale);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            const e2 = {};
            return e2["case-sensitive"] = this.caseSensitive.serialize(), e2["diacritic-sensitive"] = this.diacriticSensitive.serialize(), this.locale && (e2.locale = this.locale.serialize()), ["collator", e2];
          }
        }
        var Li = { exports: {} };
        Li.exports = /* @__PURE__ */ function() {
          function e2(i3, r2, n2, o2, s2) {
            for (; o2 > n2; ) {
              if (o2 - n2 > 600) {
                var a2 = o2 - n2 + 1, l2 = r2 - n2 + 1, c2 = Math.log(a2), h2 = 0.5 * Math.exp(2 * c2 / 3), u2 = 0.5 * Math.sqrt(c2 * h2 * (a2 - h2) / a2) * (l2 - a2 / 2 < 0 ? -1 : 1);
                e2(i3, r2, Math.max(n2, Math.floor(r2 - l2 * h2 / a2 + u2)), Math.min(o2, Math.floor(r2 + (a2 - l2) * h2 / a2 + u2)), s2);
              }
              var d2 = i3[r2], p2 = n2, f2 = o2;
              for (t2(i3, n2, r2), s2(i3[o2], d2) > 0 && t2(i3, n2, o2); p2 < f2; ) {
                for (t2(i3, p2, f2), p2++, f2--; s2(i3[p2], d2) < 0; )
                  p2++;
                for (; s2(i3[f2], d2) > 0; )
                  f2--;
              }
              0 === s2(i3[n2], d2) ? t2(i3, n2, f2) : t2(i3, ++f2, o2), f2 <= r2 && (n2 = f2 + 1), r2 <= f2 && (o2 = f2 - 1);
            }
          }
          function t2(e3, t3, i3) {
            var r2 = e3[t3];
            e3[t3] = e3[i3], e3[i3] = r2;
          }
          function i2(e3, t3) {
            return e3 < t3 ? -1 : e3 > t3 ? 1 : 0;
          }
          return function(t3, r2, n2, o2, s2) {
            e2(t3, r2, n2 || 0, o2 || t3.length - 1, s2 || i2);
          };
        }();
        var ki = d(Li.exports);
        function Oi(e2) {
          let t2 = 0;
          for (let i2, r2, n2 = 0, o2 = e2.length, s2 = o2 - 1; n2 < o2; s2 = n2++)
            i2 = e2[n2], r2 = e2[s2], t2 += (r2.x - i2.x) * (i2.y + r2.y);
          return t2;
        }
        function Bi(e2, t2) {
          e2[0] = Math.min(e2[0], t2[0]), e2[1] = Math.min(e2[1], t2[1]), e2[2] = Math.max(e2[2], t2[0]), e2[3] = Math.max(e2[3], t2[1]);
        }
        function Fi(e2, t2) {
          return !(e2[0] <= t2[0] || e2[2] >= t2[2] || e2[1] <= t2[1] || e2[3] >= t2[3]);
        }
        function Ni(e2, t2, i2) {
          const r2 = e2[0] - t2[0], n2 = e2[1] - t2[1], o2 = e2[0] - i2[0], s2 = e2[1] - i2[1];
          return r2 * s2 - o2 * n2 == 0 && r2 * o2 <= 0 && n2 * s2 <= 0;
        }
        function Ui(e2, t2, i2 = false) {
          let r2 = false;
          for (let a2 = 0, l2 = t2.length; a2 < l2; a2++) {
            const l3 = t2[a2];
            for (let t3 = 0, a3 = l3.length, c2 = a3 - 1; t3 < a3; c2 = t3++) {
              const a4 = l3[c2], h2 = l3[t3];
              if (Ni(e2, a4, h2))
                return i2;
              (o2 = a4)[1] > (n2 = e2)[1] != (s2 = h2)[1] > n2[1] && n2[0] < (s2[0] - o2[0]) * (n2[1] - o2[1]) / (s2[1] - o2[1]) + o2[0] && (r2 = !r2);
            }
          }
          var n2, o2, s2;
          return r2;
        }
        function Vi(e2, t2, i2, r2) {
          const n2 = r2[0] - i2[0], o2 = r2[1] - i2[1], s2 = (e2[0] - i2[0]) * o2 - n2 * (e2[1] - i2[1]), a2 = (t2[0] - i2[0]) * o2 - n2 * (t2[1] - i2[1]);
          return s2 > 0 && a2 < 0 || s2 < 0 && a2 > 0;
        }
        function ji(e2, t2, i2, r2) {
          return 0 != (n2 = [r2[0] - i2[0], r2[1] - i2[1]])[0] * (o2 = [t2[0] - e2[0], t2[1] - e2[1]])[1] - n2[1] * o2[0] && !(!Vi(e2, t2, i2, r2) || !Vi(i2, r2, e2, t2));
          var n2, o2;
        }
        const Gi = 8192;
        function qi(e2, t2) {
          const i2 = (180 + e2[0]) / 360, r2 = (180 - 180 / Math.PI * Math.log(Math.tan(Math.PI / 4 + e2[1] * Math.PI / 360))) / 360, n2 = Math.pow(2, t2.z);
          return [Math.round(i2 * n2 * Gi), Math.round(r2 * n2 * Gi)];
        }
        function Zi(e2, t2) {
          for (let i2 = 0; i2 < t2.length; i2++)
            if (Ui(e2, t2[i2]))
              return true;
          return false;
        }
        function $i(e2, t2, i2) {
          for (const r2 of i2)
            for (let i3 = 0, n2 = r2.length, o2 = n2 - 1; i3 < n2; o2 = i3++)
              if (ji(e2, t2, r2[o2], r2[i3]))
                return true;
          return false;
        }
        function Hi(e2, t2) {
          for (let i2 = 0; i2 < e2.length; ++i2)
            if (!Ui(e2[i2], t2))
              return false;
          for (let i2 = 0; i2 < e2.length - 1; ++i2)
            if ($i(e2[i2], e2[i2 + 1], t2))
              return false;
          return true;
        }
        function Wi(e2, t2) {
          for (let i2 = 0; i2 < t2.length; i2++)
            if (Hi(e2, t2[i2]))
              return true;
          return false;
        }
        function Xi(e2, t2, i2) {
          const r2 = [];
          for (let n2 = 0; n2 < e2.length; n2++) {
            const o2 = [];
            for (let r3 = 0; r3 < e2[n2].length; r3++) {
              const s2 = qi(e2[n2][r3], i2);
              Bi(t2, s2), o2.push(s2);
            }
            r2.push(o2);
          }
          return r2;
        }
        function Yi(e2, t2, i2) {
          const r2 = [];
          for (let n2 = 0; n2 < e2.length; n2++) {
            const o2 = Xi(e2[n2], t2, i2);
            r2.push(o2);
          }
          return r2;
        }
        function Ki(e2, t2, i2, r2) {
          if (e2[0] < i2[0] || e2[0] > i2[2]) {
            const t3 = 0.5 * r2;
            let n2 = e2[0] - i2[0] > t3 ? -r2 : i2[0] - e2[0] > t3 ? r2 : 0;
            0 === n2 && (n2 = e2[0] - i2[2] > t3 ? -r2 : i2[2] - e2[0] > t3 ? r2 : 0), e2[0] += n2;
          }
          Bi(t2, e2);
        }
        function Ji(e2, t2, i2, r2) {
          const n2 = Math.pow(2, r2.z) * Gi, o2 = [r2.x * Gi, r2.y * Gi], s2 = [];
          if (!e2)
            return s2;
          for (const r3 of e2)
            for (const e3 of r3) {
              const r4 = [e3.x + o2[0], e3.y + o2[1]];
              Ki(r4, t2, i2, n2), s2.push(r4);
            }
          return s2;
        }
        function Qi(e2, t2, i2, r2) {
          const n2 = Math.pow(2, r2.z) * Gi, o2 = [r2.x * Gi, r2.y * Gi], s2 = [];
          if (!e2)
            return s2;
          for (const i3 of e2) {
            const e3 = [];
            for (const r3 of i3) {
              const i4 = [r3.x + o2[0], r3.y + o2[1]];
              Bi(t2, i4), e3.push(i4);
            }
            s2.push(e3);
          }
          if (t2[2] - t2[0] <= n2 / 2) {
            (a2 = t2)[0] = a2[1] = 1 / 0, a2[2] = a2[3] = -1 / 0;
            for (const e3 of s2)
              for (const r3 of e3)
                Ki(r3, t2, i2, n2);
          }
          var a2;
          return s2;
        }
        class er {
          constructor(e2, t2) {
            this.type = jt, this.geojson = e2, this.geometries = t2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length)
              return t2.error(`'within' expression requires exactly one argument, but found ${e2.length - 1} instead.`);
            if (fi(e2[1])) {
              const t3 = e2[1];
              if ("FeatureCollection" === t3.type)
                for (let e3 = 0; e3 < t3.features.length; ++e3) {
                  const i2 = t3.features[e3].geometry.type;
                  if ("Polygon" === i2 || "MultiPolygon" === i2)
                    return new er(t3, t3.features[e3].geometry);
                }
              else if ("Feature" === t3.type) {
                const e3 = t3.geometry.type;
                if ("Polygon" === e3 || "MultiPolygon" === e3)
                  return new er(t3, t3.geometry);
              } else if ("Polygon" === t3.type || "MultiPolygon" === t3.type)
                return new er(t3, t3);
            }
            return t2.error("'within' expression requires valid geojson object that contains polygon geometry type.");
          }
          evaluate(e2) {
            if (null != e2.geometry() && null != e2.canonicalID()) {
              if ("Point" === e2.geometryType())
                return function(e3, t2) {
                  const i2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0], r2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0], n2 = e3.canonicalID();
                  if (!n2)
                    return false;
                  if ("Polygon" === t2.type) {
                    const o2 = Xi(t2.coordinates, r2, n2), s2 = Ji(e3.geometry(), i2, r2, n2);
                    if (!Fi(i2, r2))
                      return false;
                    for (const e4 of s2)
                      if (!Ui(e4, o2))
                        return false;
                  }
                  if ("MultiPolygon" === t2.type) {
                    const o2 = Yi(t2.coordinates, r2, n2), s2 = Ji(e3.geometry(), i2, r2, n2);
                    if (!Fi(i2, r2))
                      return false;
                    for (const e4 of s2)
                      if (!Zi(e4, o2))
                        return false;
                  }
                  return true;
                }(e2, this.geometries);
              if ("LineString" === e2.geometryType())
                return function(e3, t2) {
                  const i2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0], r2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0], n2 = e3.canonicalID();
                  if (!n2)
                    return false;
                  if ("Polygon" === t2.type) {
                    const o2 = Xi(t2.coordinates, r2, n2), s2 = Qi(e3.geometry(), i2, r2, n2);
                    if (!Fi(i2, r2))
                      return false;
                    for (const e4 of s2)
                      if (!Hi(e4, o2))
                        return false;
                  }
                  if ("MultiPolygon" === t2.type) {
                    const o2 = Yi(t2.coordinates, r2, n2), s2 = Qi(e3.geometry(), i2, r2, n2);
                    if (!Fi(i2, r2))
                      return false;
                    for (const e4 of s2)
                      if (!Wi(e4, o2))
                        return false;
                  }
                  return true;
                }(e2, this.geometries);
            }
            return false;
          }
          eachChild() {
          }
          outputDefined() {
            return true;
          }
          serialize() {
            return ["within", this.geojson];
          }
        }
        var tr = er, ir = { exports: {} };
        ir.exports = function() {
          var e2 = { kilometers: 1, miles: 1e3 / 1609.344, nauticalmiles: 1e3 / 1852, meters: 1e3, metres: 1e3, yards: 1e3 / 0.9144, feet: 1e3 / 0.3048, inches: 1e3 / 0.0254 }, t2 = 1 / 298.257223563, i2 = t2 * (2 - t2), r2 = Math.PI / 180, n2 = function(t3, n3) {
            if (void 0 === t3)
              throw new Error("No latitude given.");
            if (n3 && !e2[n3])
              throw new Error("Unknown unit " + n3 + ". Use one of: " + Object.keys(e2).join(", "));
            var o3 = 6378.137 * r2 * (n3 ? e2[n3] : 1), s3 = Math.cos(t3 * r2), a3 = 1 / (1 - i2 * (1 - s3 * s3)), l3 = Math.sqrt(a3);
            this.kx = o3 * l3 * s3, this.ky = o3 * l3 * a3 * (1 - i2);
          }, o2 = { units: { configurable: true } };
          function s2(e3, t3) {
            return e3[0] === t3[0] && e3[1] === t3[1];
          }
          function a2(e3, t3, i3) {
            var r3 = l2(t3[0] - e3[0]);
            return [e3[0] + r3 * i3, e3[1] + (t3[1] - e3[1]) * i3];
          }
          function l2(e3) {
            for (; e3 < -180; )
              e3 += 360;
            for (; e3 > 180; )
              e3 -= 360;
            return e3;
          }
          return n2.fromTile = function(e3, t3, i3) {
            var o3 = Math.PI * (1 - 2 * (e3 + 0.5) / Math.pow(2, t3)), s3 = Math.atan(0.5 * (Math.exp(o3) - Math.exp(-o3))) / r2;
            return new n2(s3, i3);
          }, o2.units.get = function() {
            return e2;
          }, n2.prototype.distance = function(e3, t3) {
            var i3 = l2(e3[0] - t3[0]) * this.kx, r3 = (e3[1] - t3[1]) * this.ky;
            return Math.sqrt(i3 * i3 + r3 * r3);
          }, n2.prototype.bearing = function(e3, t3) {
            var i3 = l2(t3[0] - e3[0]) * this.kx;
            return Math.atan2(i3, (t3[1] - e3[1]) * this.ky) / r2;
          }, n2.prototype.destination = function(e3, t3, i3) {
            var n3 = i3 * r2;
            return this.offset(e3, Math.sin(n3) * t3, Math.cos(n3) * t3);
          }, n2.prototype.offset = function(e3, t3, i3) {
            return [e3[0] + t3 / this.kx, e3[1] + i3 / this.ky];
          }, n2.prototype.lineDistance = function(e3) {
            for (var t3 = 0, i3 = 0; i3 < e3.length - 1; i3++)
              t3 += this.distance(e3[i3], e3[i3 + 1]);
            return t3;
          }, n2.prototype.area = function(e3) {
            for (var t3 = 0, i3 = 0; i3 < e3.length; i3++)
              for (var r3 = e3[i3], n3 = 0, o3 = r3.length, s3 = o3 - 1; n3 < o3; s3 = n3++)
                t3 += l2(r3[n3][0] - r3[s3][0]) * (r3[n3][1] + r3[s3][1]) * (i3 ? -1 : 1);
            return Math.abs(t3) / 2 * this.kx * this.ky;
          }, n2.prototype.along = function(e3, t3) {
            var i3 = 0;
            if (t3 <= 0)
              return e3[0];
            for (var r3 = 0; r3 < e3.length - 1; r3++) {
              var n3 = e3[r3], o3 = e3[r3 + 1], s3 = this.distance(n3, o3);
              if ((i3 += s3) > t3)
                return a2(n3, o3, (t3 - (i3 - s3)) / s3);
            }
            return e3[e3.length - 1];
          }, n2.prototype.pointToSegmentDistance = function(e3, t3, i3) {
            var r3 = t3[0], n3 = t3[1], o3 = l2(i3[0] - r3) * this.kx, s3 = (i3[1] - n3) * this.ky, a3 = 0;
            return 0 === o3 && 0 === s3 || ((a3 = (l2(e3[0] - r3) * this.kx * o3 + (e3[1] - n3) * this.ky * s3) / (o3 * o3 + s3 * s3)) > 1 ? (r3 = i3[0], n3 = i3[1]) : a3 > 0 && (r3 += o3 / this.kx * a3, n3 += s3 / this.ky * a3)), o3 = l2(e3[0] - r3) * this.kx, s3 = (e3[1] - n3) * this.ky, Math.sqrt(o3 * o3 + s3 * s3);
          }, n2.prototype.pointOnLine = function(e3, t3) {
            for (var i3, r3, n3, o3, s3 = 1 / 0, a3 = 0; a3 < e3.length - 1; a3++) {
              var c2 = e3[a3][0], h2 = e3[a3][1], u2 = l2(e3[a3 + 1][0] - c2) * this.kx, d2 = (e3[a3 + 1][1] - h2) * this.ky, p2 = 0;
              0 === u2 && 0 === d2 || ((p2 = (l2(t3[0] - c2) * this.kx * u2 + (t3[1] - h2) * this.ky * d2) / (u2 * u2 + d2 * d2)) > 1 ? (c2 = e3[a3 + 1][0], h2 = e3[a3 + 1][1]) : p2 > 0 && (c2 += u2 / this.kx * p2, h2 += d2 / this.ky * p2));
              var f2 = (u2 = l2(t3[0] - c2) * this.kx) * u2 + (d2 = (t3[1] - h2) * this.ky) * d2;
              f2 < s3 && (s3 = f2, i3 = c2, r3 = h2, n3 = a3, o3 = p2);
            }
            return { point: [i3, r3], index: n3, t: Math.max(0, Math.min(1, o3)) };
          }, n2.prototype.lineSlice = function(e3, t3, i3) {
            var r3 = this.pointOnLine(i3, e3), n3 = this.pointOnLine(i3, t3);
            if (r3.index > n3.index || r3.index === n3.index && r3.t > n3.t) {
              var o3 = r3;
              r3 = n3, n3 = o3;
            }
            var a3 = [r3.point], l3 = r3.index + 1, c2 = n3.index;
            !s2(i3[l3], a3[0]) && l3 <= c2 && a3.push(i3[l3]);
            for (var h2 = l3 + 1; h2 <= c2; h2++)
              a3.push(i3[h2]);
            return s2(i3[c2], n3.point) || a3.push(n3.point), a3;
          }, n2.prototype.lineSliceAlong = function(e3, t3, i3) {
            for (var r3 = 0, n3 = [], o3 = 0; o3 < i3.length - 1; o3++) {
              var s3 = i3[o3], l3 = i3[o3 + 1], c2 = this.distance(s3, l3);
              if ((r3 += c2) > e3 && 0 === n3.length && n3.push(a2(s3, l3, (e3 - (r3 - c2)) / c2)), r3 >= t3)
                return n3.push(a2(s3, l3, (t3 - (r3 - c2)) / c2)), n3;
              r3 > e3 && n3.push(l3);
            }
            return n3;
          }, n2.prototype.bufferPoint = function(e3, t3) {
            var i3 = t3 / this.ky, r3 = t3 / this.kx;
            return [e3[0] - r3, e3[1] - i3, e3[0] + r3, e3[1] + i3];
          }, n2.prototype.bufferBBox = function(e3, t3) {
            var i3 = t3 / this.ky, r3 = t3 / this.kx;
            return [e3[0] - r3, e3[1] - i3, e3[2] + r3, e3[3] + i3];
          }, n2.prototype.insideBBox = function(e3, t3) {
            return l2(e3[0] - t3[0]) >= 0 && l2(e3[0] - t3[2]) <= 0 && e3[1] >= t3[1] && e3[1] <= t3[3];
          }, Object.defineProperties(n2, o2), n2;
        }();
        var rr = d(ir.exports), nr = { exports: {} };
        nr.exports = function() {
          var e2 = function(e3, i2) {
            if (void 0 === e3 && (e3 = []), void 0 === i2 && (i2 = t2), this.data = e3, this.length = this.data.length, this.compare = i2, this.length > 0)
              for (var r2 = (this.length >> 1) - 1; r2 >= 0; r2--)
                this._down(r2);
          };
          function t2(e3, t3) {
            return e3 < t3 ? -1 : e3 > t3 ? 1 : 0;
          }
          return e2.prototype.push = function(e3) {
            this.data.push(e3), this.length++, this._up(this.length - 1);
          }, e2.prototype.pop = function() {
            if (0 !== this.length) {
              var e3 = this.data[0], t3 = this.data.pop();
              return this.length--, this.length > 0 && (this.data[0] = t3, this._down(0)), e3;
            }
          }, e2.prototype.peek = function() {
            return this.data[0];
          }, e2.prototype._up = function(e3) {
            for (var t3 = this.data, i2 = this.compare, r2 = t3[e3]; e3 > 0; ) {
              var n2 = e3 - 1 >> 1, o2 = t3[n2];
              if (i2(r2, o2) >= 0)
                break;
              t3[e3] = o2, e3 = n2;
            }
            t3[e3] = r2;
          }, e2.prototype._down = function(e3) {
            for (var t3 = this.data, i2 = this.compare, r2 = this.length >> 1, n2 = t3[e3]; e3 < r2; ) {
              var o2 = 1 + (e3 << 1), s2 = t3[o2], a2 = o2 + 1;
              if (a2 < this.length && i2(t3[a2], s2) < 0 && (o2 = a2, s2 = t3[a2]), i2(s2, n2) >= 0)
                break;
              t3[e3] = s2, e3 = o2;
            }
            t3[e3] = n2;
          }, e2;
        }();
        var or = d(nr.exports), sr = 8192;
        function ar(e2, t2) {
          return t2.dist - e2.dist;
        }
        const lr = 100, cr = 50;
        function hr(e2) {
          const t2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
          if (t2.length !== e2.length)
            return false;
          for (let i2 = 0; i2 < t2.length; i2++)
            if (t2[i2] !== e2[i2])
              return false;
          return true;
        }
        function ur(e2) {
          return e2[1] - e2[0] + 1;
        }
        function dr(e2, t2) {
          const i2 = e2[1] >= e2[0] && e2[1] < t2;
          return i2 || console.warn("Distance Expression: Index is out of range"), i2;
        }
        function pr(e2, t2) {
          if (e2[0] > e2[1])
            return [null, null];
          const i2 = ur(e2);
          if (t2) {
            if (2 === i2)
              return [e2, null];
            const t3 = Math.floor(i2 / 2);
            return [[e2[0], e2[0] + t3], [e2[0] + t3, e2[1]]];
          }
          {
            if (1 === i2)
              return [e2, null];
            const t3 = Math.floor(i2 / 2) - 1;
            return [[e2[0], e2[0] + t3], [e2[0] + t3 + 1, e2[1]]];
          }
        }
        function fr(e2, t2) {
          const i2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
          if (!dr(t2, e2.length))
            return i2;
          for (let r2 = t2[0]; r2 <= t2[1]; ++r2)
            Bi(i2, e2[r2]);
          return i2;
        }
        function mr(e2) {
          const t2 = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
          for (let i2 = 0; i2 < e2.length; ++i2)
            for (let r2 = 0; r2 < e2[i2].length; ++r2)
              Bi(t2, e2[i2][r2]);
          return t2;
        }
        function _r(e2, t2, i2) {
          if (hr(e2) || hr(t2))
            return NaN;
          let r2 = 0, n2 = 0;
          return e2[2] < t2[0] && (r2 = t2[0] - e2[2]), e2[0] > t2[2] && (r2 = e2[0] - t2[2]), e2[1] > t2[3] && (n2 = e2[1] - t2[3]), e2[3] < t2[1] && (n2 = t2[1] - e2[3]), i2.distance([0, 0], [r2, n2]);
        }
        function gr(e2, t2) {
          const i2 = Math.pow(2, t2.z);
          return [(n2 = (e2.x / sr + t2.x) / i2, 360 * n2 - 180), (r2 = (e2.y / sr + t2.y) / i2, 360 / Math.PI * Math.atan(Math.exp((180 - 360 * r2) * Math.PI / 180)) - 90)];
          var r2, n2;
        }
        function yr(e2, t2) {
          const i2 = [];
          for (let r2 = 0; r2 < e2.length; ++r2)
            i2.push(gr(e2[r2], t2));
          return i2;
        }
        function xr(e2, t2, i2) {
          const r2 = i2.pointOnLine(t2, e2).point;
          return i2.distance(e2, r2);
        }
        function vr(e2, t2, i2, r2, n2) {
          const o2 = i2.slice(r2[0], r2[1] + 1);
          let s2 = 1 / 0;
          for (let i3 = t2[0]; i3 <= t2[1]; ++i3)
            if (0 === (s2 = Math.min(s2, xr(e2[i3], o2, n2))))
              return 0;
          return s2;
        }
        function br(e2, t2, i2, r2, n2) {
          const o2 = Math.min(n2.pointToSegmentDistance(e2, i2, r2), n2.pointToSegmentDistance(t2, i2, r2)), s2 = Math.min(n2.pointToSegmentDistance(i2, e2, t2), n2.pointToSegmentDistance(r2, e2, t2));
          return Math.min(o2, s2);
        }
        function wr(e2, t2, i2, r2, n2) {
          if (!dr(t2, e2.length) || !dr(r2, i2.length))
            return NaN;
          let o2 = 1 / 0;
          for (let s2 = t2[0]; s2 < t2[1]; ++s2)
            for (let t3 = r2[0]; t3 < r2[1]; ++t3) {
              if (ji(e2[s2], e2[s2 + 1], i2[t3], i2[t3 + 1]))
                return 0;
              o2 = Math.min(o2, br(e2[s2], e2[s2 + 1], i2[t3], i2[t3 + 1], n2));
            }
          return o2;
        }
        function Tr(e2, t2, i2, r2, n2) {
          if (!dr(t2, e2.length) || !dr(r2, i2.length))
            return NaN;
          let o2 = 1 / 0;
          for (let s2 = t2[0]; s2 <= t2[1]; ++s2)
            for (let t3 = r2[0]; t3 <= r2[1]; ++t3)
              if (0 === (o2 = Math.min(o2, n2.distance(e2[s2], i2[t3]))))
                return o2;
          return o2;
        }
        function Er(e2, t2, i2) {
          if (Ui(e2, t2, true))
            return 0;
          let r2 = 1 / 0;
          for (const n2 of t2) {
            const t3 = n2.length;
            if (t3 < 2)
              return console.warn("Distance Expression: Invalid polygon!"), NaN;
            if (n2[0] !== n2[t3 - 1] && 0 === (r2 = Math.min(r2, i2.pointToSegmentDistance(e2, n2[t3 - 1], n2[0]))))
              return r2;
            if (0 === (r2 = Math.min(r2, xr(e2, n2, i2))))
              return r2;
          }
          return r2;
        }
        function Mr(e2, t2, i2, r2) {
          if (!dr(t2, e2.length))
            return NaN;
          for (let r3 = t2[0]; r3 <= t2[1]; ++r3)
            if (Ui(e2[r3], i2, true))
              return 0;
          let n2 = 1 / 0;
          for (let o2 = t2[0]; o2 < t2[1]; ++o2)
            for (const t3 of i2)
              for (let i3 = 0, s2 = t3.length, a2 = s2 - 1; i3 < s2; a2 = i3++) {
                if (ji(e2[o2], e2[o2 + 1], t3[a2], t3[i3]))
                  return 0;
                n2 = Math.min(n2, br(e2[o2], e2[o2 + 1], t3[a2], t3[i3], r2));
              }
          return n2;
        }
        function Ar(e2, t2) {
          for (const i2 of e2)
            for (let e3 = 0; e3 <= i2.length - 1; ++e3)
              if (Ui(i2[e3], t2, true))
                return true;
          return false;
        }
        function Sr(e2, t2, i2, r2 = 1 / 0) {
          const n2 = mr(e2), o2 = mr(t2);
          if (r2 !== 1 / 0 && _r(n2, o2, i2) >= r2)
            return r2;
          if (Fi(n2, o2)) {
            if (Ar(e2, t2))
              return 0;
          } else if (Ar(t2, e2))
            return 0;
          let s2 = r2;
          for (const r3 of e2)
            for (let e3 = 0, n3 = r3.length, o3 = n3 - 1; e3 < n3; o3 = e3++)
              for (const n4 of t2)
                for (let t3 = 0, a2 = n4.length, l2 = a2 - 1; t3 < a2; l2 = t3++) {
                  if (ji(r3[o3], r3[e3], n4[l2], n4[t3]))
                    return 0;
                  s2 = Math.min(s2, br(r3[o3], r3[e3], n4[l2], n4[t3], i2));
                }
          return s2;
        }
        function Ir(e2, t2, i2, r2, n2, o2, s2) {
          if (null === o2 || null === s2)
            return;
          const a2 = _r(fr(r2, o2), fr(n2, s2), i2);
          a2 < t2 && e2.push({ dist: a2, range1: o2, range2: s2 });
        }
        function Cr(e2, t2, i2, r2, n2 = 1 / 0) {
          let o2 = Math.min(r2.distance(e2[0], i2[0][0]), n2);
          if (0 === o2)
            return o2;
          const s2 = new or([{ dist: 0, range1: [0, e2.length - 1], range2: [0, 0] }], ar), a2 = t2 ? cr : lr, l2 = mr(i2);
          for (; s2.length; ) {
            const n3 = s2.pop();
            if (n3.dist >= o2)
              continue;
            const c2 = n3.range1;
            if (ur(c2) <= a2) {
              if (!dr(c2, e2.length))
                return NaN;
              if (t2) {
                const t3 = Mr(e2, c2, i2, r2);
                if (0 === (o2 = Math.min(o2, t3)))
                  return o2;
              } else
                for (let t3 = c2[0]; t3 <= c2[1]; ++t3) {
                  const n4 = Er(e2[t3], i2, r2);
                  if (0 === (o2 = Math.min(o2, n4)))
                    return o2;
                }
            } else {
              const i3 = pr(c2, t2);
              if (null !== i3[0]) {
                const t3 = _r(fr(e2, i3[0]), l2, r2);
                t3 < o2 && s2.push({ dist: t3, range1: i3[0], range2: [0, 0] });
              }
              if (null !== i3[1]) {
                const t3 = _r(fr(e2, i3[1]), l2, r2);
                t3 < o2 && s2.push({ dist: t3, range1: i3[1], range2: [0, 0] });
              }
            }
          }
          return o2;
        }
        function zr(e2, t2, i2, r2, n2, o2 = 1 / 0) {
          let s2 = Math.min(o2, n2.distance(e2[0], i2[0]));
          if (0 === s2)
            return s2;
          const a2 = new or([{ dist: 0, range1: [0, e2.length - 1], range2: [0, i2.length - 1] }], ar), l2 = t2 ? cr : lr, c2 = r2 ? cr : lr;
          for (; a2.length; ) {
            const o3 = a2.pop();
            if (o3.dist >= s2)
              continue;
            const h2 = o3.range1, u2 = o3.range2;
            if (ur(h2) <= l2 && ur(u2) <= c2) {
              if (!dr(h2, e2.length) || !dr(u2, i2.length))
                return NaN;
              if (t2 && r2 ? s2 = Math.min(s2, wr(e2, h2, i2, u2, n2)) : t2 || r2 ? t2 && !r2 ? s2 = Math.min(s2, vr(i2, u2, e2, h2, n2)) : !t2 && r2 && (s2 = Math.min(s2, vr(e2, h2, i2, u2, n2))) : s2 = Math.min(s2, Tr(e2, h2, i2, u2, n2)), 0 === s2)
                return s2;
            } else {
              const o4 = pr(h2, t2), l3 = pr(u2, r2);
              Ir(a2, s2, n2, e2, i2, o4[0], l3[0]), Ir(a2, s2, n2, e2, i2, o4[0], l3[1]), Ir(a2, s2, n2, e2, i2, o4[1], l3[0]), Ir(a2, s2, n2, e2, i2, o4[1], l3[1]);
            }
          }
          return s2;
        }
        function Dr(e2, t2, i2, r2, n2 = 1 / 0) {
          let o2 = n2;
          const s2 = fr(e2, [0, e2.length - 1]);
          for (const n3 of i2)
            if (!(o2 !== 1 / 0 && _r(s2, fr(n3, [0, n3.length - 1]), r2) >= o2) && (o2 = Math.min(o2, zr(e2, t2, n3, true, r2, o2)), 0 === o2))
              return o2;
          return o2;
        }
        function Pr(e2, t2, i2, r2, n2 = 1 / 0) {
          let o2 = n2;
          const s2 = fr(e2, [0, e2.length - 1]);
          for (const n3 of i2) {
            if (o2 !== 1 / 0 && _r(s2, mr(n3), r2) >= o2)
              continue;
            const i3 = Cr(e2, t2, n3, r2, o2);
            if (isNaN(i3))
              return i3;
            if (0 === (o2 = Math.min(o2, i3)))
              return o2;
          }
          return o2;
        }
        function Rr(e2) {
          return "Point" === e2 || "MultiPoint" === e2 || "LineString" === e2 || "MultiLineString" === e2 || "Polygon" === e2 || "MultiPolygon" === e2;
        }
        class Lr {
          constructor(e2, t2) {
            this.type = Ut, this.geojson = e2, this.geometries = t2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length)
              return t2.error(`'distance' expression requires either one argument, but found ' ${e2.length - 1} instead.`);
            if (fi(e2[1])) {
              const t3 = e2[1];
              if ("FeatureCollection" === t3.type) {
                for (let e3 = 0; e3 < t3.features.length; ++e3)
                  if (Rr(t3.features[e3].geometry.type))
                    return new Lr(t3, t3.features[e3].geometry);
              } else if ("Feature" === t3.type) {
                if (Rr(t3.geometry.type))
                  return new Lr(t3, t3.geometry);
              } else if (Rr(t3.type))
                return new Lr(t3, t3);
            }
            return t2.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].");
          }
          evaluate(e2) {
            const t2 = e2.geometry(), i2 = e2.canonicalID();
            if (null != t2 && null != i2) {
              if ("Point" === e2.geometryType())
                return function(e3, t3, i3) {
                  const r2 = [];
                  for (const i4 of e3)
                    for (const e4 of i4)
                      r2.push(gr(e4, t3));
                  const n2 = new rr(r2[0][1], "meters");
                  return "Point" === i3.type || "MultiPoint" === i3.type || "LineString" === i3.type ? zr(r2, false, "Point" === i3.type ? [i3.coordinates] : i3.coordinates, "LineString" === i3.type, n2) : "MultiLineString" === i3.type ? Dr(r2, false, i3.coordinates, n2) : "Polygon" === i3.type || "MultiPolygon" === i3.type ? Pr(r2, false, "Polygon" === i3.type ? [i3.coordinates] : i3.coordinates, n2) : null;
                }(t2, i2, this.geometries);
              if ("LineString" === e2.geometryType())
                return function(e3, t3, i3) {
                  const r2 = [];
                  for (const i4 of e3) {
                    const e4 = [];
                    for (const r3 of i4)
                      e4.push(gr(r3, t3));
                    r2.push(e4);
                  }
                  const n2 = new rr(r2[0][0][1], "meters");
                  if ("Point" === i3.type || "MultiPoint" === i3.type || "LineString" === i3.type)
                    return Dr("Point" === i3.type ? [i3.coordinates] : i3.coordinates, "LineString" === i3.type, r2, n2);
                  if ("MultiLineString" === i3.type) {
                    let e4 = 1 / 0;
                    for (let t4 = 0; t4 < i3.coordinates.length; t4++) {
                      const o2 = Dr(i3.coordinates[t4], true, r2, n2, e4);
                      if (isNaN(o2))
                        return o2;
                      if (0 === (e4 = Math.min(e4, o2)))
                        return e4;
                    }
                    return e4;
                  }
                  if ("Polygon" === i3.type || "MultiPolygon" === i3.type) {
                    let e4 = 1 / 0;
                    for (let t4 = 0; t4 < r2.length; t4++) {
                      const o2 = Pr(r2[t4], true, "Polygon" === i3.type ? [i3.coordinates] : i3.coordinates, n2, e4);
                      if (isNaN(o2))
                        return o2;
                      if (0 === (e4 = Math.min(e4, o2)))
                        return e4;
                    }
                    return e4;
                  }
                  return null;
                }(t2, i2, this.geometries);
              if ("Polygon" === e2.geometryType())
                return function(e3, t3, i3) {
                  const r2 = [];
                  for (const i4 of function(e4, t4) {
                    const i5 = e4.length;
                    if (i5 <= 1)
                      return [e4];
                    const r3 = [];
                    let n3, o2;
                    for (let t5 = 0; t5 < i5; t5++) {
                      const i6 = Oi(e4[t5]);
                      0 !== i6 && (e4[t5].area = Math.abs(i6), void 0 === o2 && (o2 = i6 < 0), o2 === i6 < 0 ? (n3 && r3.push(n3), n3 = [e4[t5]]) : n3.push(e4[t5]));
                    }
                    return n3 && r3.push(n3), r3;
                  }(e3)) {
                    const e4 = [];
                    for (let r3 = 0; r3 < i4.length; ++r3)
                      e4.push(yr(i4[r3], t3));
                    r2.push(e4);
                  }
                  const n2 = new rr(r2[0][0][0][1], "meters");
                  if ("Point" === i3.type || "MultiPoint" === i3.type || "LineString" === i3.type)
                    return Pr("Point" === i3.type ? [i3.coordinates] : i3.coordinates, "LineString" === i3.type, r2, n2);
                  if ("MultiLineString" === i3.type) {
                    let e4 = 1 / 0;
                    for (let t4 = 0; t4 < i3.coordinates.length; t4++) {
                      const o2 = Pr(i3.coordinates[t4], true, r2, n2, e4);
                      if (isNaN(o2))
                        return o2;
                      if (0 === (e4 = Math.min(e4, o2)))
                        return e4;
                    }
                    return e4;
                  }
                  return "Polygon" === i3.type || "MultiPolygon" === i3.type ? function(e4, t4, i4) {
                    let r3 = 1 / 0;
                    for (const n3 of e4)
                      for (const e5 of t4) {
                        const t5 = Sr(n3, e5, i4, r3);
                        if (isNaN(t5))
                          return t5;
                        if (0 === (r3 = Math.min(r3, t5)))
                          return r3;
                      }
                    return r3;
                  }("Polygon" === i3.type ? [i3.coordinates] : i3.coordinates, r2, n2) : null;
                }(t2, i2, this.geometries);
              console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");
            } else
              console.warn("Distance Expression: requirs valid feature and canonical information.");
            return null;
          }
          eachChild() {
          }
          outputDefined() {
            return true;
          }
          serialize() {
            return ["distance", this.geojson];
          }
        }
        var kr = Lr;
        function Or(e2) {
          if (e2 instanceof Pi) {
            if ("get" === e2.name && 1 === e2.args.length)
              return false;
            if ("feature-state" === e2.name)
              return false;
            if ("has" === e2.name && 1 === e2.args.length)
              return false;
            if ("properties" === e2.name || "geometry-type" === e2.name || "id" === e2.name)
              return false;
            if (/^filter-/.test(e2.name))
              return false;
          }
          if (e2 instanceof tr)
            return false;
          if (e2 instanceof kr)
            return false;
          let t2 = true;
          return e2.eachChild((e3) => {
            t2 && !Or(e3) && (t2 = false);
          }), t2;
        }
        function Br(e2) {
          if (e2 instanceof Pi && "feature-state" === e2.name)
            return false;
          let t2 = true;
          return e2.eachChild((e3) => {
            t2 && !Br(e3) && (t2 = false);
          }), t2;
        }
        function Fr(e2) {
          if (e2 instanceof Pi && "config" === e2.name)
            return false;
          let t2 = true;
          return e2.eachChild((e3) => {
            t2 && !Fr(e3) && (t2 = false);
          }), t2;
        }
        function Nr(e2, t2) {
          if (e2 instanceof Pi && t2.indexOf(e2.name) >= 0)
            return false;
          let i2 = true;
          return e2.eachChild((e3) => {
            i2 && !Nr(e3, t2) && (i2 = false);
          }), i2;
        }
        class Ur {
          constructor(e2, t2) {
            this.type = t2.type, this.name = e2, this.boundExpression = t2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length || "string" != typeof e2[1])
              return t2.error("'var' expression requires exactly one string literal argument.");
            const i2 = e2[1];
            return t2.scope.has(i2) ? new Ur(i2, t2.scope.get(i2)) : t2.error(`Unknown variable "${i2}". Make sure "${i2}" has been bound in an enclosing "let" expression before using it.`, 1);
          }
          evaluate(e2) {
            return this.boundExpression.evaluate(e2);
          }
          eachChild() {
          }
          outputDefined() {
            return false;
          }
          serialize() {
            return ["var", this.name];
          }
        }
        var Vr = Ur;
        class jr {
          constructor(e2, t2 = [], i2, r2 = new Ft(), n2 = [], o2) {
            this.registry = e2, this.path = t2, this.key = t2.map((e3) => `[${e3}]`).join(""), this.scope = r2, this.errors = n2, this.expectedType = i2, this.options = o2;
          }
          parse(e2, t2, i2, r2, n2 = {}) {
            return t2 || i2 ? this.concat(t2, i2, r2)._parse(e2, n2) : this._parse(e2, n2);
          }
          _parse(e2, t2) {
            function i2(e3, t3, i3) {
              return "assert" === i3 ? new wi(t3, [e3]) : "coerce" === i3 ? new Ii(t3, [e3]) : e3;
            }
            if (null !== e2 && "string" != typeof e2 && "boolean" != typeof e2 && "number" != typeof e2 || (e2 = ["literal", e2]), Array.isArray(e2)) {
              if (0 === e2.length)
                return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');
              const r2 = "string" == typeof e2[0] ? this.registry[e2[0]] : void 0;
              if (r2) {
                let n2 = r2.parse(e2, this);
                if (!n2)
                  return null;
                if (this.expectedType) {
                  const e3 = this.expectedType, r3 = n2.type;
                  if ("string" !== e3.kind && "number" !== e3.kind && "boolean" !== e3.kind && "object" !== e3.kind && "array" !== e3.kind || "value" !== r3.kind)
                    if ("color" !== e3.kind && "formatted" !== e3.kind && "resolvedImage" !== e3.kind || "value" !== r3.kind && "string" !== r3.kind) {
                      if (this.checkSubtype(e3, r3))
                        return null;
                    } else
                      n2 = i2(n2, e3, t2.typeAnnotation || "coerce");
                  else
                    n2 = i2(n2, e3, t2.typeAnnotation || "assert");
                }
                if (!(n2 instanceof yi) && "resolvedImage" !== n2.type.kind && qr(n2)) {
                  const e3 = new zi(this.options);
                  try {
                    n2 = new yi(n2.type, n2.evaluate(e3));
                  } catch (e4) {
                    return this.error(e4.message), null;
                  }
                }
                return n2;
              }
              return Ii.parse(["to-array", e2], this);
            }
            return this.error(void 0 === e2 ? "'undefined' value invalid. Use null instead." : "object" == typeof e2 ? 'Bare objects invalid. Use ["literal", {...}] instead.' : `Expected an array, but found ${typeof e2} instead.`);
          }
          concat(e2, t2, i2) {
            const r2 = "number" == typeof e2 ? this.path.concat(e2) : this.path, n2 = i2 ? this.scope.concat(i2) : this.scope;
            return new jr(this.registry, r2, t2 || null, n2, this.errors, this.options);
          }
          error(e2, ...t2) {
            const i2 = `${this.key}${t2.map((e3) => `[${e3}]`).join("")}`;
            this.errors.push(new Ot(i2, e2));
          }
          checkSubtype(e2, t2) {
            const i2 = Jt(e2, t2);
            return i2 && this.error(i2), i2;
          }
        }
        var Gr = jr;
        function qr(e2) {
          if (e2 instanceof Vr)
            return qr(e2.boundExpression);
          if (e2 instanceof Pi && "error" === e2.name)
            return false;
          if (e2 instanceof Pi && "config" === e2.name)
            return false;
          if (e2 instanceof Ri)
            return false;
          if (e2 instanceof tr)
            return false;
          if (e2 instanceof kr)
            return false;
          const t2 = e2 instanceof Ii || e2 instanceof wi;
          let i2 = true;
          return e2.eachChild((e3) => {
            i2 = t2 ? i2 && qr(e3) : i2 && e3 instanceof yi;
          }), !!i2 && Or(e2) && Nr(e2, ["zoom", "heatmap-density", "line-progress", "raster-value", "sky-radial-progress", "accumulated", "is-supported-script", "pitch", "distance-from-center", "measure-light"]);
        }
        function Zr(e2, t2) {
          const i2 = e2.length - 1;
          let r2, n2, o2 = 0, s2 = i2, a2 = 0;
          for (; o2 <= s2; )
            if (a2 = Math.floor((o2 + s2) / 2), r2 = e2[a2], n2 = e2[a2 + 1], r2 <= t2) {
              if (a2 === i2 || t2 < n2)
                return a2;
              o2 = a2 + 1;
            } else {
              if (!(r2 > t2))
                throw new xi("Input is not a number.");
              s2 = a2 - 1;
            }
          return 0;
        }
        class $r {
          constructor(e2, t2, i2) {
            this.type = e2, this.input = t2, this.labels = [], this.outputs = [];
            for (const [e3, t3] of i2)
              this.labels.push(e3), this.outputs.push(t3);
          }
          static parse(e2, t2) {
            if (e2.length - 1 < 4)
              return t2.error(`Expected at least 4 arguments, but found only ${e2.length - 1}.`);
            if ((e2.length - 1) % 2 != 0)
              return t2.error("Expected an even number of arguments.");
            const i2 = t2.parse(e2[1], 1, Ut);
            if (!i2)
              return null;
            const r2 = [];
            let n2 = null;
            t2.expectedType && "value" !== t2.expectedType.kind && (n2 = t2.expectedType);
            for (let i3 = 1; i3 < e2.length; i3 += 2) {
              const o2 = 1 === i3 ? -1 / 0 : e2[i3], s2 = e2[i3 + 1], a2 = i3, l2 = i3 + 1;
              if ("number" != typeof o2)
                return t2.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.', a2);
              if (r2.length && r2[r2.length - 1][0] >= o2)
                return t2.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.', a2);
              const c2 = t2.parse(s2, l2, n2);
              if (!c2)
                return null;
              n2 = n2 || c2.type, r2.push([o2, c2]);
            }
            return new $r(n2, i2, r2);
          }
          evaluate(e2) {
            const t2 = this.labels, i2 = this.outputs;
            if (1 === t2.length)
              return i2[0].evaluate(e2);
            const r2 = this.input.evaluate(e2);
            if (r2 <= t2[0])
              return i2[0].evaluate(e2);
            const n2 = t2.length;
            return r2 >= t2[n2 - 1] ? i2[n2 - 1].evaluate(e2) : i2[Zr(t2, r2)].evaluate(e2);
          }
          eachChild(e2) {
            e2(this.input);
            for (const t2 of this.outputs)
              e2(t2);
          }
          outputDefined() {
            return this.outputs.every((e2) => e2.outputDefined());
          }
          serialize() {
            const e2 = ["step", this.input.serialize()];
            for (let t2 = 0; t2 < this.labels.length; t2++)
              t2 > 0 && e2.push(this.labels[t2]), e2.push(this.outputs[t2].serialize());
            return e2;
          }
        }
        var Hr = $r;
        function Wr(e2, t2, i2) {
          return e2 * (1 - i2) + t2 * i2;
        }
        function Xr(e2, t2, i2) {
          return e2.map((e3, r2) => Wr(e3, t2[r2], i2));
        }
        var Yr = Object.freeze({ __proto__: null, array: Xr, color: function(e2, t2, i2) {
          return new li(Wr(e2.r, t2.r, i2), Wr(e2.g, t2.g, i2), Wr(e2.b, t2.b, i2), Wr(e2.a, t2.a, i2));
        }, number: Wr });
        const Kr = 0.95047, Jr = 1.08883, Qr = 4 / 29, en = 6 / 29, tn = 3 * en * en, rn = en * en * en, nn = Math.PI / 180, on = 180 / Math.PI;
        function sn(e2) {
          return e2 > rn ? Math.pow(e2, 1 / 3) : e2 / tn + Qr;
        }
        function an(e2) {
          return e2 > en ? e2 * e2 * e2 : tn * (e2 - Qr);
        }
        function ln(e2) {
          return 255 * (e2 <= 31308e-7 ? 12.92 * e2 : 1.055 * Math.pow(e2, 1 / 2.4) - 0.055);
        }
        function cn(e2) {
          return (e2 /= 255) <= 0.04045 ? e2 / 12.92 : Math.pow((e2 + 0.055) / 1.055, 2.4);
        }
        function hn(e2) {
          const t2 = cn(e2.r), i2 = cn(e2.g), r2 = cn(e2.b), n2 = sn((0.4124564 * t2 + 0.3575761 * i2 + 0.1804375 * r2) / Kr), o2 = sn((0.2126729 * t2 + 0.7151522 * i2 + 0.072175 * r2) / 1);
          return { l: 116 * o2 - 16, a: 500 * (n2 - o2), b: 200 * (o2 - sn((0.0193339 * t2 + 0.119192 * i2 + 0.9503041 * r2) / Jr)), alpha: e2.a };
        }
        function un(e2) {
          let t2 = (e2.l + 16) / 116, i2 = isNaN(e2.a) ? t2 : t2 + e2.a / 500, r2 = isNaN(e2.b) ? t2 : t2 - e2.b / 200;
          return t2 = 1 * an(t2), i2 = Kr * an(i2), r2 = Jr * an(r2), new li(ln(3.2404542 * i2 - 1.5371385 * t2 - 0.4985314 * r2), ln(-0.969266 * i2 + 1.8760108 * t2 + 0.041556 * r2), ln(0.0556434 * i2 - 0.2040259 * t2 + 1.0572252 * r2), e2.alpha);
        }
        function dn(e2, t2, i2) {
          const r2 = t2 - e2;
          return e2 + i2 * (r2 > 180 || r2 < -180 ? r2 - 360 * Math.round(r2 / 360) : r2);
        }
        const pn = { forward: hn, reverse: un, interpolate: function(e2, t2, i2) {
          return { l: Wr(e2.l, t2.l, i2), a: Wr(e2.a, t2.a, i2), b: Wr(e2.b, t2.b, i2), alpha: Wr(e2.alpha, t2.alpha, i2) };
        } }, fn = { forward: function(e2) {
          const { l: t2, a: i2, b: r2 } = hn(e2), n2 = Math.atan2(r2, i2) * on;
          return { h: n2 < 0 ? n2 + 360 : n2, c: Math.sqrt(i2 * i2 + r2 * r2), l: t2, alpha: e2.a };
        }, reverse: function(e2) {
          const t2 = e2.h * nn, i2 = e2.c;
          return un({ l: e2.l, a: Math.cos(t2) * i2, b: Math.sin(t2) * i2, alpha: e2.alpha });
        }, interpolate: function(e2, t2, i2) {
          return { h: dn(e2.h, t2.h, i2), c: Wr(e2.c, t2.c, i2), l: Wr(e2.l, t2.l, i2), alpha: Wr(e2.alpha, t2.alpha, i2) };
        } };
        var mn = Object.freeze({ __proto__: null, hcl: fn, lab: pn });
        class _n {
          constructor(e2, t2, i2, r2, n2) {
            this.type = e2, this.operator = t2, this.interpolation = i2, this.input = r2, this.labels = [], this.outputs = [];
            for (const [e3, t3] of n2)
              this.labels.push(e3), this.outputs.push(t3);
          }
          static interpolationFactor(e2, t2, i2, r2) {
            let n2 = 0;
            if ("exponential" === e2.name)
              n2 = gn(t2, e2.base, i2, r2);
            else if ("linear" === e2.name)
              n2 = gn(t2, 1, i2, r2);
            else if ("cubic-bezier" === e2.name) {
              const o2 = e2.controlPoints;
              n2 = new m(o2[0], o2[1], o2[2], o2[3]).solve(gn(t2, 1, i2, r2));
            }
            return n2;
          }
          static parse(e2, t2) {
            let [i2, r2, n2, ...o2] = e2;
            if (!Array.isArray(r2) || 0 === r2.length)
              return t2.error("Expected an interpolation type expression.", 1);
            if ("linear" === r2[0])
              r2 = { name: "linear" };
            else if ("exponential" === r2[0]) {
              const e3 = r2[1];
              if ("number" != typeof e3)
                return t2.error("Exponential interpolation requires a numeric base.", 1, 1);
              r2 = { name: "exponential", base: e3 };
            } else {
              if ("cubic-bezier" !== r2[0])
                return t2.error(`Unknown interpolation type ${String(r2[0])}`, 1, 0);
              {
                const e3 = r2.slice(1);
                if (4 !== e3.length || e3.some((e4) => "number" != typeof e4 || e4 < 0 || e4 > 1))
                  return t2.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.", 1);
                r2 = { name: "cubic-bezier", controlPoints: e3 };
              }
            }
            if (e2.length - 1 < 4)
              return t2.error(`Expected at least 4 arguments, but found only ${e2.length - 1}.`);
            if ((e2.length - 1) % 2 != 0)
              return t2.error("Expected an even number of arguments.");
            if (n2 = t2.parse(n2, 2, Ut), !n2)
              return null;
            const s2 = [];
            let a2 = null;
            "interpolate-hcl" === i2 || "interpolate-lab" === i2 ? a2 = Gt : t2.expectedType && "value" !== t2.expectedType.kind && (a2 = t2.expectedType);
            for (let e3 = 0; e3 < o2.length; e3 += 2) {
              const i3 = o2[e3], r3 = o2[e3 + 1], n3 = e3 + 3, l2 = e3 + 4;
              if ("number" != typeof i3)
                return t2.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.', n3);
              if (s2.length && s2[s2.length - 1][0] >= i3)
                return t2.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.', n3);
              const c2 = t2.parse(r3, l2, a2);
              if (!c2)
                return null;
              a2 = a2 || c2.type, s2.push([i3, c2]);
            }
            return "number" === a2.kind || "color" === a2.kind || "array" === a2.kind && "number" === a2.itemType.kind && "number" == typeof a2.N ? new _n(a2, i2, r2, n2, s2) : t2.error(`Type ${Yt(a2)} is not interpolatable.`);
          }
          evaluate(e2) {
            const t2 = this.labels, i2 = this.outputs;
            if (1 === t2.length)
              return i2[0].evaluate(e2);
            const r2 = this.input.evaluate(e2);
            if (r2 <= t2[0])
              return i2[0].evaluate(e2);
            const n2 = t2.length;
            if (r2 >= t2[n2 - 1])
              return i2[n2 - 1].evaluate(e2);
            const o2 = Zr(t2, r2), s2 = _n.interpolationFactor(this.interpolation, r2, t2[o2], t2[o2 + 1]), a2 = i2[o2].evaluate(e2), l2 = i2[o2 + 1].evaluate(e2);
            return "interpolate" === this.operator ? Yr[this.type.kind.toLowerCase()](a2, l2, s2) : "interpolate-hcl" === this.operator ? fn.reverse(fn.interpolate(fn.forward(a2), fn.forward(l2), s2)) : pn.reverse(pn.interpolate(pn.forward(a2), pn.forward(l2), s2));
          }
          eachChild(e2) {
            e2(this.input);
            for (const t2 of this.outputs)
              e2(t2);
          }
          outputDefined() {
            return this.outputs.every((e2) => e2.outputDefined());
          }
          serialize() {
            let e2;
            e2 = "linear" === this.interpolation.name ? ["linear"] : "exponential" === this.interpolation.name ? 1 === this.interpolation.base ? ["linear"] : ["exponential", this.interpolation.base] : ["cubic-bezier"].concat(this.interpolation.controlPoints);
            const t2 = [this.operator, e2, this.input.serialize()];
            for (let e3 = 0; e3 < this.labels.length; e3++)
              t2.push(this.labels[e3], this.outputs[e3].serialize());
            return t2;
          }
        }
        function gn(e2, t2, i2, r2) {
          const n2 = r2 - i2, o2 = e2 - i2;
          return 0 === n2 ? 0 : 1 === t2 ? o2 / n2 : (Math.pow(t2, o2) - 1) / (Math.pow(t2, n2) - 1);
        }
        var yn = _n;
        class xn {
          constructor(e2, t2) {
            this.type = e2, this.args = t2;
          }
          static parse(e2, t2) {
            if (e2.length < 2)
              return t2.error("Expectected at least one argument.");
            let i2 = null;
            const r2 = t2.expectedType;
            r2 && "value" !== r2.kind && (i2 = r2);
            const n2 = [];
            for (const r3 of e2.slice(1)) {
              const e3 = t2.parse(r3, 1 + n2.length, i2, void 0, { typeAnnotation: "omit" });
              if (!e3)
                return null;
              i2 = i2 || e3.type, n2.push(e3);
            }
            const o2 = r2 && n2.some((e3) => Jt(r2, e3.type));
            return new xn(o2 ? Zt : i2, n2);
          }
          evaluate(e2) {
            let t2, i2 = null, r2 = 0;
            for (const n2 of this.args) {
              if (r2++, i2 = n2.evaluate(e2), i2 && i2 instanceof di && !i2.available && (t2 || (t2 = i2), i2 = null, r2 === this.args.length))
                return t2;
              if (null !== i2)
                break;
            }
            return i2;
          }
          eachChild(e2) {
            this.args.forEach(e2);
          }
          outputDefined() {
            return this.args.every((e2) => e2.outputDefined());
          }
          serialize() {
            const e2 = ["coalesce"];
            return this.eachChild((t2) => {
              e2.push(t2.serialize());
            }), e2;
          }
        }
        var vn = xn;
        class bn {
          constructor(e2, t2) {
            this.type = t2.type, this.bindings = [].concat(e2), this.result = t2;
          }
          evaluate(e2) {
            return this.result.evaluate(e2);
          }
          eachChild(e2) {
            for (const t2 of this.bindings)
              e2(t2[1]);
            e2(this.result);
          }
          static parse(e2, t2) {
            if (e2.length < 4)
              return t2.error(`Expected at least 3 arguments, but found ${e2.length - 1} instead.`);
            const i2 = [];
            for (let r3 = 1; r3 < e2.length - 1; r3 += 2) {
              const n2 = e2[r3];
              if ("string" != typeof n2)
                return t2.error(`Expected string, but found ${typeof n2} instead.`, r3);
              if (/[^a-zA-Z0-9_]/.test(n2))
                return t2.error("Variable names must contain only alphanumeric characters or '_'.", r3);
              const o2 = t2.parse(e2[r3 + 1], r3 + 1);
              if (!o2)
                return null;
              i2.push([n2, o2]);
            }
            const r2 = t2.parse(e2[e2.length - 1], e2.length - 1, t2.expectedType, i2);
            return r2 ? new bn(i2, r2) : null;
          }
          outputDefined() {
            return this.result.outputDefined();
          }
          serialize() {
            const e2 = ["let"];
            for (const [t2, i2] of this.bindings)
              e2.push(t2, i2.serialize());
            return e2.push(this.result.serialize()), e2;
          }
        }
        var wn = bn;
        class Tn {
          constructor(e2, t2, i2) {
            this.type = e2, this.index = t2, this.input = i2;
          }
          static parse(e2, t2) {
            if (3 !== e2.length)
              return t2.error(`Expected 2 arguments, but found ${e2.length - 1} instead.`);
            const i2 = t2.parse(e2[1], 1, Ut), r2 = t2.parse(e2[2], 2, Xt(t2.expectedType || Zt));
            return i2 && r2 ? new Tn(r2.type.itemType, i2, r2) : null;
          }
          evaluate(e2) {
            const t2 = this.index.evaluate(e2), i2 = this.input.evaluate(e2);
            if (t2 < 0)
              throw new xi(`Array index out of bounds: ${t2} < 0.`);
            if (t2 >= i2.length)
              throw new xi(`Array index out of bounds: ${t2} > ${i2.length - 1}.`);
            if (t2 !== Math.floor(t2))
              throw new xi(`Array index must be an integer, but found ${t2} instead.`);
            return i2[t2];
          }
          eachChild(e2) {
            e2(this.index), e2(this.input);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            return ["at", this.index.serialize(), this.input.serialize()];
          }
        }
        var En = Tn;
        class Mn {
          constructor(e2, t2) {
            this.type = jt, this.needle = e2, this.haystack = t2;
          }
          static parse(e2, t2) {
            if (3 !== e2.length)
              return t2.error(`Expected 2 arguments, but found ${e2.length - 1} instead.`);
            const i2 = t2.parse(e2[1], 1, Zt), r2 = t2.parse(e2[2], 2, Zt);
            return i2 && r2 ? Qt(i2.type, [jt, Vt, Ut, Nt, Zt]) ? new Mn(i2, r2) : t2.error(`Expected first argument to be of type boolean, string, number or null, but found ${Yt(i2.type)} instead`) : null;
          }
          evaluate(e2) {
            const t2 = this.needle.evaluate(e2), i2 = this.haystack.evaluate(e2);
            if (null == i2)
              return false;
            if (!ei(t2, ["boolean", "string", "number", "null"]))
              throw new xi(`Expected first argument to be of type boolean, string, number or null, but found ${Yt(mi(t2))} instead.`);
            if (!ei(i2, ["string", "array"]))
              throw new xi(`Expected second argument to be of type array or string, but found ${Yt(mi(i2))} instead.`);
            return i2.indexOf(t2) >= 0;
          }
          eachChild(e2) {
            e2(this.needle), e2(this.haystack);
          }
          outputDefined() {
            return true;
          }
          serialize() {
            return ["in", this.needle.serialize(), this.haystack.serialize()];
          }
        }
        var An = Mn;
        class Sn {
          constructor(e2, t2, i2) {
            this.type = Ut, this.needle = e2, this.haystack = t2, this.fromIndex = i2;
          }
          static parse(e2, t2) {
            if (e2.length <= 2 || e2.length >= 5)
              return t2.error(`Expected 3 or 4 arguments, but found ${e2.length - 1} instead.`);
            const i2 = t2.parse(e2[1], 1, Zt), r2 = t2.parse(e2[2], 2, Zt);
            if (!i2 || !r2)
              return null;
            if (!Qt(i2.type, [jt, Vt, Ut, Nt, Zt]))
              return t2.error(`Expected first argument to be of type boolean, string, number or null, but found ${Yt(i2.type)} instead`);
            if (4 === e2.length) {
              const n2 = t2.parse(e2[3], 3, Ut);
              return n2 ? new Sn(i2, r2, n2) : null;
            }
            return new Sn(i2, r2);
          }
          evaluate(e2) {
            const t2 = this.needle.evaluate(e2), i2 = this.haystack.evaluate(e2);
            if (!ei(t2, ["boolean", "string", "number", "null"]))
              throw new xi(`Expected first argument to be of type boolean, string, number or null, but found ${Yt(mi(t2))} instead.`);
            if (!ei(i2, ["string", "array"]))
              throw new xi(`Expected second argument to be of type array or string, but found ${Yt(mi(i2))} instead.`);
            if (this.fromIndex) {
              const r2 = this.fromIndex.evaluate(e2);
              return i2.indexOf(t2, r2);
            }
            return i2.indexOf(t2);
          }
          eachChild(e2) {
            e2(this.needle), e2(this.haystack), this.fromIndex && e2(this.fromIndex);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            if (null != this.fromIndex && void 0 !== this.fromIndex) {
              const e2 = this.fromIndex.serialize();
              return ["index-of", this.needle.serialize(), this.haystack.serialize(), e2];
            }
            return ["index-of", this.needle.serialize(), this.haystack.serialize()];
          }
        }
        var In = Sn;
        class Cn {
          constructor(e2, t2, i2, r2, n2, o2) {
            this.inputType = e2, this.type = t2, this.input = i2, this.cases = r2, this.outputs = n2, this.otherwise = o2;
          }
          static parse(e2, t2) {
            if (e2.length < 5)
              return t2.error(`Expected at least 4 arguments, but found only ${e2.length - 1}.`);
            if (e2.length % 2 != 1)
              return t2.error("Expected an even number of arguments.");
            let i2, r2;
            t2.expectedType && "value" !== t2.expectedType.kind && (r2 = t2.expectedType);
            const n2 = {}, o2 = [];
            for (let s3 = 2; s3 < e2.length - 1; s3 += 2) {
              let a3 = e2[s3];
              const l2 = e2[s3 + 1];
              Array.isArray(a3) || (a3 = [a3]);
              const c2 = t2.concat(s3);
              if (0 === a3.length)
                return c2.error("Expected at least one branch label.");
              for (const e3 of a3) {
                if ("number" != typeof e3 && "string" != typeof e3)
                  return c2.error("Branch labels must be numbers or strings.");
                if ("number" == typeof e3 && Math.abs(e3) > Number.MAX_SAFE_INTEGER)
                  return c2.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);
                if ("number" == typeof e3 && Math.floor(e3) !== e3)
                  return c2.error("Numeric branch labels must be integer values.");
                if (i2) {
                  if (c2.checkSubtype(i2, mi(e3)))
                    return null;
                } else
                  i2 = mi(e3);
                if (void 0 !== n2[String(e3)])
                  return c2.error("Branch labels must be unique.");
                n2[String(e3)] = o2.length;
              }
              const h2 = t2.parse(l2, s3, r2);
              if (!h2)
                return null;
              r2 = r2 || h2.type, o2.push(h2);
            }
            const s2 = t2.parse(e2[1], 1, Zt);
            if (!s2)
              return null;
            const a2 = t2.parse(e2[e2.length - 1], e2.length - 1, r2);
            return a2 ? "value" !== s2.type.kind && t2.concat(1).checkSubtype(i2, s2.type) ? null : new Cn(i2, r2, s2, n2, o2, a2) : null;
          }
          evaluate(e2) {
            const t2 = this.input.evaluate(e2);
            return (mi(t2) === this.inputType && this.outputs[this.cases[t2]] || this.otherwise).evaluate(e2);
          }
          eachChild(e2) {
            e2(this.input), this.outputs.forEach(e2), e2(this.otherwise);
          }
          outputDefined() {
            return this.outputs.every((e2) => e2.outputDefined()) && this.otherwise.outputDefined();
          }
          serialize() {
            const e2 = ["match", this.input.serialize()], t2 = Object.keys(this.cases).sort(), i2 = [], r2 = {};
            for (const e3 of t2) {
              const t3 = r2[this.cases[e3]];
              void 0 === t3 ? (r2[this.cases[e3]] = i2.length, i2.push([this.cases[e3], [e3]])) : i2[t3][1].push(e3);
            }
            const n2 = (e3) => "number" === this.inputType.kind ? Number(e3) : e3;
            for (const [t3, r3] of i2)
              e2.push(1 === r3.length ? n2(r3[0]) : r3.map(n2)), e2.push(this.outputs[t3].serialize());
            return e2.push(this.otherwise.serialize()), e2;
          }
        }
        var zn = Cn;
        class Dn {
          constructor(e2, t2, i2) {
            this.type = e2, this.branches = t2, this.otherwise = i2;
          }
          static parse(e2, t2) {
            if (e2.length < 4)
              return t2.error(`Expected at least 3 arguments, but found only ${e2.length - 1}.`);
            if (e2.length % 2 != 0)
              return t2.error("Expected an odd number of arguments.");
            let i2;
            t2.expectedType && "value" !== t2.expectedType.kind && (i2 = t2.expectedType);
            const r2 = [];
            for (let n3 = 1; n3 < e2.length - 1; n3 += 2) {
              const o2 = t2.parse(e2[n3], n3, jt);
              if (!o2)
                return null;
              const s2 = t2.parse(e2[n3 + 1], n3 + 1, i2);
              if (!s2)
                return null;
              r2.push([o2, s2]), i2 = i2 || s2.type;
            }
            const n2 = t2.parse(e2[e2.length - 1], e2.length - 1, i2);
            return n2 ? new Dn(i2, r2, n2) : null;
          }
          evaluate(e2) {
            for (const [t2, i2] of this.branches)
              if (t2.evaluate(e2))
                return i2.evaluate(e2);
            return this.otherwise.evaluate(e2);
          }
          eachChild(e2) {
            for (const [t2, i2] of this.branches)
              e2(t2), e2(i2);
            e2(this.otherwise);
          }
          outputDefined() {
            return this.branches.every(([e2, t2]) => t2.outputDefined()) && this.otherwise.outputDefined();
          }
          serialize() {
            const e2 = ["case"];
            return this.eachChild((t2) => {
              e2.push(t2.serialize());
            }), e2;
          }
        }
        var Pn = Dn;
        class Rn {
          constructor(e2, t2, i2, r2) {
            this.type = e2, this.input = t2, this.beginIndex = i2, this.endIndex = r2;
          }
          static parse(e2, t2) {
            if (e2.length <= 2 || e2.length >= 5)
              return t2.error(`Expected 3 or 4 arguments, but found ${e2.length - 1} instead.`);
            const i2 = t2.parse(e2[1], 1, Zt), r2 = t2.parse(e2[2], 2, Ut);
            if (!i2 || !r2)
              return null;
            if (!Qt(i2.type, [Xt(Zt), Vt, Zt]))
              return t2.error(`Expected first argument to be of type array or string, but found ${Yt(i2.type)} instead`);
            if (4 === e2.length) {
              const n2 = t2.parse(e2[3], 3, Ut);
              return n2 ? new Rn(i2.type, i2, r2, n2) : null;
            }
            return new Rn(i2.type, i2, r2);
          }
          evaluate(e2) {
            const t2 = this.input.evaluate(e2), i2 = this.beginIndex.evaluate(e2);
            if (!ei(t2, ["string", "array"]))
              throw new xi(`Expected first argument to be of type array or string, but found ${Yt(mi(t2))} instead.`);
            if (this.endIndex) {
              const r2 = this.endIndex.evaluate(e2);
              return t2.slice(i2, r2);
            }
            return t2.slice(i2);
          }
          eachChild(e2) {
            e2(this.input), e2(this.beginIndex), this.endIndex && e2(this.endIndex);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            if (null != this.endIndex && void 0 !== this.endIndex) {
              const e2 = this.endIndex.serialize();
              return ["slice", this.input.serialize(), this.beginIndex.serialize(), e2];
            }
            return ["slice", this.input.serialize(), this.beginIndex.serialize()];
          }
        }
        var Ln = Rn;
        function kn(e2, t2) {
          return "==" === e2 || "!=" === e2 ? "boolean" === t2.kind || "string" === t2.kind || "number" === t2.kind || "null" === t2.kind || "value" === t2.kind : "string" === t2.kind || "number" === t2.kind || "value" === t2.kind;
        }
        function On(e2, t2, i2, r2) {
          return 0 === r2.compare(t2, i2);
        }
        function Bn(e2, t2, i2) {
          const r2 = "==" !== e2 && "!=" !== e2;
          return class n2 {
            constructor(e3, t3, i3) {
              this.type = jt, this.lhs = e3, this.rhs = t3, this.collator = i3, this.hasUntypedArgument = "value" === e3.type.kind || "value" === t3.type.kind;
            }
            static parse(e3, t3) {
              if (3 !== e3.length && 4 !== e3.length)
                return t3.error("Expected two or three arguments.");
              const i3 = e3[0];
              let o2 = t3.parse(e3[1], 1, Zt);
              if (!o2)
                return null;
              if (!kn(i3, o2.type))
                return t3.concat(1).error(`"${i3}" comparisons are not supported for type '${Yt(o2.type)}'.`);
              let s2 = t3.parse(e3[2], 2, Zt);
              if (!s2)
                return null;
              if (!kn(i3, s2.type))
                return t3.concat(2).error(`"${i3}" comparisons are not supported for type '${Yt(s2.type)}'.`);
              if (o2.type.kind !== s2.type.kind && "value" !== o2.type.kind && "value" !== s2.type.kind)
                return t3.error(`Cannot compare types '${Yt(o2.type)}' and '${Yt(s2.type)}'.`);
              r2 && ("value" === o2.type.kind && "value" !== s2.type.kind ? o2 = new wi(s2.type, [o2]) : "value" !== o2.type.kind && "value" === s2.type.kind && (s2 = new wi(o2.type, [s2])));
              let a2 = null;
              if (4 === e3.length) {
                if ("string" !== o2.type.kind && "string" !== s2.type.kind && "value" !== o2.type.kind && "value" !== s2.type.kind)
                  return t3.error("Cannot use collator to compare non-string types.");
                if (a2 = t3.parse(e3[3], 3, $t), !a2)
                  return null;
              }
              return new n2(o2, s2, a2);
            }
            evaluate(n3) {
              const o2 = this.lhs.evaluate(n3), s2 = this.rhs.evaluate(n3);
              if (r2 && this.hasUntypedArgument) {
                const t3 = mi(o2), i3 = mi(s2);
                if (t3.kind !== i3.kind || "string" !== t3.kind && "number" !== t3.kind)
                  throw new xi(`Expected arguments for "${e2}" to be (string, string) or (number, number), but found (${t3.kind}, ${i3.kind}) instead.`);
              }
              if (this.collator && !r2 && this.hasUntypedArgument) {
                const e3 = mi(o2), i3 = mi(s2);
                if ("string" !== e3.kind || "string" !== i3.kind)
                  return t2(n3, o2, s2);
              }
              return this.collator ? i2(n3, o2, s2, this.collator.evaluate(n3)) : t2(n3, o2, s2);
            }
            eachChild(e3) {
              e3(this.lhs), e3(this.rhs), this.collator && e3(this.collator);
            }
            outputDefined() {
              return true;
            }
            serialize() {
              const t3 = [e2];
              return this.eachChild((e3) => {
                t3.push(e3.serialize());
              }), t3;
            }
          };
        }
        const Fn = Bn("==", function(e2, t2, i2) {
          return t2 === i2;
        }, On), Nn = Bn("!=", function(e2, t2, i2) {
          return t2 !== i2;
        }, function(e2, t2, i2, r2) {
          return !On(0, t2, i2, r2);
        }), Un = Bn("<", function(e2, t2, i2) {
          return t2 < i2;
        }, function(e2, t2, i2, r2) {
          return r2.compare(t2, i2) < 0;
        }), Vn = Bn(">", function(e2, t2, i2) {
          return t2 > i2;
        }, function(e2, t2, i2, r2) {
          return r2.compare(t2, i2) > 0;
        }), jn = Bn("<=", function(e2, t2, i2) {
          return t2 <= i2;
        }, function(e2, t2, i2, r2) {
          return r2.compare(t2, i2) <= 0;
        }), Gn = Bn(">=", function(e2, t2, i2) {
          return t2 >= i2;
        }, function(e2, t2, i2, r2) {
          return r2.compare(t2, i2) >= 0;
        });
        class qn {
          constructor(e2, t2, i2, r2, n2, o2) {
            this.type = Vt, this.number = e2, this.locale = t2, this.currency = i2, this.unit = r2, this.minFractionDigits = n2, this.maxFractionDigits = o2;
          }
          static parse(e2, t2) {
            if (3 !== e2.length)
              return t2.error("Expected two arguments.");
            const i2 = t2.parse(e2[1], 1, Ut);
            if (!i2)
              return null;
            const r2 = e2[2];
            if ("object" != typeof r2 || Array.isArray(r2))
              return t2.error("NumberFormat options argument must be an object.");
            let n2 = null;
            if (r2.locale && (n2 = t2.parse(r2.locale, 1, Vt), !n2))
              return null;
            let o2 = null;
            if (r2.currency && (o2 = t2.parse(r2.currency, 1, Vt), !o2))
              return null;
            let s2 = null;
            if (r2.unit && (s2 = t2.parse(r2.unit, 1, Vt), !s2))
              return null;
            let a2 = null;
            if (r2["min-fraction-digits"] && (a2 = t2.parse(r2["min-fraction-digits"], 1, Ut), !a2))
              return null;
            let l2 = null;
            return r2["max-fraction-digits"] && (l2 = t2.parse(r2["max-fraction-digits"], 1, Ut), !l2) ? null : new qn(i2, n2, o2, s2, a2, l2);
          }
          evaluate(e2) {
            return new Intl.NumberFormat(this.locale ? this.locale.evaluate(e2) : [], { style: (this.currency ? "currency" : this.unit && "unit") || "decimal", currency: this.currency ? this.currency.evaluate(e2) : void 0, unit: this.unit ? this.unit.evaluate(e2) : void 0, minimumFractionDigits: this.minFractionDigits ? this.minFractionDigits.evaluate(e2) : void 0, maximumFractionDigits: this.maxFractionDigits ? this.maxFractionDigits.evaluate(e2) : void 0 }).format(this.number.evaluate(e2));
          }
          eachChild(e2) {
            e2(this.number), this.locale && e2(this.locale), this.currency && e2(this.currency), this.unit && e2(this.unit), this.minFractionDigits && e2(this.minFractionDigits), this.maxFractionDigits && e2(this.maxFractionDigits);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            const e2 = {};
            return this.locale && (e2.locale = this.locale.serialize()), this.currency && (e2.currency = this.currency.serialize()), this.unit && (e2.unit = this.unit.serialize()), this.minFractionDigits && (e2["min-fraction-digits"] = this.minFractionDigits.serialize()), this.maxFractionDigits && (e2["max-fraction-digits"] = this.maxFractionDigits.serialize()), ["number-format", this.number.serialize(), e2];
          }
        }
        class Zn {
          constructor(e2) {
            this.type = Ut, this.input = e2;
          }
          static parse(e2, t2) {
            if (2 !== e2.length)
              return t2.error(`Expected 1 argument, but found ${e2.length - 1} instead.`);
            const i2 = t2.parse(e2[1], 1);
            return i2 ? "array" !== i2.type.kind && "string" !== i2.type.kind && "value" !== i2.type.kind ? t2.error(`Expected argument of type string or array, but found ${Yt(i2.type)} instead.`) : new Zn(i2) : null;
          }
          evaluate(e2) {
            const t2 = this.input.evaluate(e2);
            if ("string" == typeof t2)
              return t2.length;
            if (Array.isArray(t2))
              return t2.length;
            throw new xi(`Expected value to be of type string or array, but found ${Yt(mi(t2))} instead.`);
          }
          eachChild(e2) {
            e2(this.input);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            const e2 = ["length"];
            return this.eachChild((t2) => {
              e2.push(t2.serialize());
            }), e2;
          }
        }
        function $n(e2) {
          return function() {
            e2 = 1831565813 + (e2 |= 0) | 0;
            let t2 = Math.imul(e2 ^ e2 >>> 15, 1 | e2);
            return t2 = t2 + Math.imul(t2 ^ t2 >>> 7, 61 | t2) ^ t2, ((t2 ^ t2 >>> 14) >>> 0) / 4294967296;
          };
        }
        const Hn = { "==": Fn, "!=": Nn, ">": Vn, "<": Un, ">=": Gn, "<=": jn, array: wi, at: En, boolean: wi, case: Pn, coalesce: vn, collator: Ri, format: Ti, image: Ei, in: An, "index-of": In, interpolate: yn, "interpolate-hcl": yn, "interpolate-lab": yn, length: Zn, let: wn, literal: yi, match: zn, number: wi, "number-format": qn, object: wi, slice: Ln, step: Hr, string: wi, "to-boolean": Ii, "to-color": Ii, "to-number": Ii, "to-string": Ii, var: Vr, within: tr, distance: kr };
        function Wn(e2, [t2, i2, r2, n2]) {
          t2 = t2.evaluate(e2), i2 = i2.evaluate(e2), r2 = r2.evaluate(e2);
          const o2 = n2 ? n2.evaluate(e2) : 1, s2 = pi(t2, i2, r2, o2);
          if (s2)
            throw new xi(s2);
          return new li(t2 / 255 * o2, i2 / 255 * o2, r2 / 255 * o2, o2);
        }
        function Xn(e2, [t2, i2, r2, n2]) {
          t2 = t2.evaluate(e2), i2 = i2.evaluate(e2), r2 = r2.evaluate(e2);
          const o2 = n2 ? n2.evaluate(e2) : 1, s2 = function(e3, t3, i3, r3) {
            return "number" == typeof e3 && e3 >= 0 && e3 <= 360 ? "number" == typeof t3 && t3 >= 0 && t3 <= 100 && "number" == typeof i3 && i3 >= 0 && i3 <= 100 ? void 0 === r3 || "number" == typeof r3 && r3 >= 0 && r3 <= 1 ? null : `Invalid hsla value [${[e3, t3, i3, r3].join(", ")}]: 'a' must be between 0 and 1.` : `Invalid hsla value [${("number" == typeof r3 ? [e3, t3, i3, r3] : [e3, t3, i3]).join(", ")}]: 's', and 'l' must be between 0 and 100.` : `Invalid hsla value [${("number" == typeof r3 ? [e3, t3, i3, r3] : [e3, t3, i3]).join(", ")}]: 'h' must be between 0 and 360.`;
          }(t2, i2, r2, o2);
          if (s2)
            throw new xi(s2);
          const a2 = `hsla(${t2}, ${i2}%, ${r2}%, ${o2})`, l2 = li.parse(a2);
          if (!l2)
            throw new xi(`Failed to parse HSLA color: ${a2}`);
          return l2;
        }
        function Yn(e2, t2) {
          return e2 in t2;
        }
        function Kn(e2, t2) {
          const i2 = t2[e2];
          return void 0 === i2 ? null : i2;
        }
        function Jn(e2, t2, i2) {
          i2.length && (t2 += `${i2}`);
          const r2 = e2.getConfig(t2);
          return r2 ? r2.evaluate(e2) : null;
        }
        function Qn(e2) {
          return { type: e2 };
        }
        Pi.register(Hn, { error: [{ kind: "error" }, [Vt], (e2, [t2]) => {
          throw new xi(t2.evaluate(e2));
        }], typeof: [Vt, [Zt], (e2, [t2]) => Yt(mi(t2.evaluate(e2)))], "to-rgba": [Xt(Ut, 4), [Gt], (e2, [t2]) => t2.evaluate(e2).toArray()], rgb: [Gt, [Ut, Ut, Ut], Wn], rgba: [Gt, [Ut, Ut, Ut, Ut], Wn], hsl: [Gt, [Ut, Ut, Ut], Xn], hsla: [Gt, [Ut, Ut, Ut, Ut], Xn], has: { type: jt, overloads: [[[Vt], (e2, [t2]) => Yn(t2.evaluate(e2), e2.properties())], [[Vt, qt], (e2, [t2, i2]) => Yn(t2.evaluate(e2), i2.evaluate(e2))]] }, get: { type: Zt, overloads: [[[Vt], (e2, [t2]) => Kn(t2.evaluate(e2), e2.properties())], [[Vt, qt], (e2, [t2, i2]) => Kn(t2.evaluate(e2), i2.evaluate(e2))]] }, config: { type: Zt, overloads: [[[Vt], (e2, [t2]) => Jn(e2, t2.evaluate(e2), "")], [[Vt, Vt], (e2, [t2, i2]) => Jn(e2, t2.evaluate(e2), i2.evaluate(e2))]] }, "feature-state": [Zt, [Vt], (e2, [t2]) => Kn(t2.evaluate(e2), e2.featureState || {})], properties: [qt, [], (e2) => e2.properties()], "geometry-type": [Vt, [], (e2) => e2.geometryType()], id: [Zt, [], (e2) => e2.id()], zoom: [Ut, [], (e2) => e2.globals.zoom], pitch: [Ut, [], (e2) => e2.globals.pitch || 0], "distance-from-center": [Ut, [], (e2) => e2.distanceFromCenter()], "measure-light": [Ut, [Vt], (e2, [t2]) => e2.measureLight(t2.evaluate(e2))], "heatmap-density": [Ut, [], (e2) => e2.globals.heatmapDensity || 0], "line-progress": [Ut, [], (e2) => e2.globals.lineProgress || 0], "raster-value": [Ut, [], (e2) => e2.globals.rasterValue || 0], "sky-radial-progress": [Ut, [], (e2) => e2.globals.skyRadialProgress || 0], accumulated: [Zt, [], (e2) => void 0 === e2.globals.accumulated ? null : e2.globals.accumulated], "+": [Ut, Qn(Ut), (e2, t2) => {
          let i2 = 0;
          for (const r2 of t2)
            i2 += r2.evaluate(e2);
          return i2;
        }], "*": [Ut, Qn(Ut), (e2, t2) => {
          let i2 = 1;
          for (const r2 of t2)
            i2 *= r2.evaluate(e2);
          return i2;
        }], "-": { type: Ut, overloads: [[[Ut, Ut], (e2, [t2, i2]) => t2.evaluate(e2) - i2.evaluate(e2)], [[Ut], (e2, [t2]) => -t2.evaluate(e2)]] }, "/": [Ut, [Ut, Ut], (e2, [t2, i2]) => t2.evaluate(e2) / i2.evaluate(e2)], "%": [Ut, [Ut, Ut], (e2, [t2, i2]) => t2.evaluate(e2) % i2.evaluate(e2)], ln2: [Ut, [], () => Math.LN2], pi: [Ut, [], () => Math.PI], e: [Ut, [], () => Math.E], "^": [Ut, [Ut, Ut], (e2, [t2, i2]) => Math.pow(t2.evaluate(e2), i2.evaluate(e2))], sqrt: [Ut, [Ut], (e2, [t2]) => Math.sqrt(t2.evaluate(e2))], log10: [Ut, [Ut], (e2, [t2]) => Math.log(t2.evaluate(e2)) / Math.LN10], ln: [Ut, [Ut], (e2, [t2]) => Math.log(t2.evaluate(e2))], log2: [Ut, [Ut], (e2, [t2]) => Math.log(t2.evaluate(e2)) / Math.LN2], sin: [Ut, [Ut], (e2, [t2]) => Math.sin(t2.evaluate(e2))], cos: [Ut, [Ut], (e2, [t2]) => Math.cos(t2.evaluate(e2))], tan: [Ut, [Ut], (e2, [t2]) => Math.tan(t2.evaluate(e2))], asin: [Ut, [Ut], (e2, [t2]) => Math.asin(t2.evaluate(e2))], acos: [Ut, [Ut], (e2, [t2]) => Math.acos(t2.evaluate(e2))], atan: [Ut, [Ut], (e2, [t2]) => Math.atan(t2.evaluate(e2))], min: [Ut, Qn(Ut), (e2, t2) => Math.min(...t2.map((t3) => t3.evaluate(e2)))], max: [Ut, Qn(Ut), (e2, t2) => Math.max(...t2.map((t3) => t3.evaluate(e2)))], abs: [Ut, [Ut], (e2, [t2]) => Math.abs(t2.evaluate(e2))], round: [Ut, [Ut], (e2, [t2]) => {
          const i2 = t2.evaluate(e2);
          return i2 < 0 ? -Math.round(-i2) : Math.round(i2);
        }], floor: [Ut, [Ut], (e2, [t2]) => Math.floor(t2.evaluate(e2))], ceil: [Ut, [Ut], (e2, [t2]) => Math.ceil(t2.evaluate(e2))], "filter-==": [jt, [Vt, Zt], (e2, [t2, i2]) => e2.properties()[t2.value] === i2.value], "filter-id-==": [jt, [Zt], (e2, [t2]) => e2.id() === t2.value], "filter-type-==": [jt, [Vt], (e2, [t2]) => e2.geometryType() === t2.value], "filter-<": [jt, [Vt, Zt], (e2, [t2, i2]) => {
          const r2 = e2.properties()[t2.value], n2 = i2.value;
          return typeof r2 == typeof n2 && r2 < n2;
        }], "filter-id-<": [jt, [Zt], (e2, [t2]) => {
          const i2 = e2.id(), r2 = t2.value;
          return typeof i2 == typeof r2 && i2 < r2;
        }], "filter->": [jt, [Vt, Zt], (e2, [t2, i2]) => {
          const r2 = e2.properties()[t2.value], n2 = i2.value;
          return typeof r2 == typeof n2 && r2 > n2;
        }], "filter-id->": [jt, [Zt], (e2, [t2]) => {
          const i2 = e2.id(), r2 = t2.value;
          return typeof i2 == typeof r2 && i2 > r2;
        }], "filter-<=": [jt, [Vt, Zt], (e2, [t2, i2]) => {
          const r2 = e2.properties()[t2.value], n2 = i2.value;
          return typeof r2 == typeof n2 && r2 <= n2;
        }], "filter-id-<=": [jt, [Zt], (e2, [t2]) => {
          const i2 = e2.id(), r2 = t2.value;
          return typeof i2 == typeof r2 && i2 <= r2;
        }], "filter->=": [jt, [Vt, Zt], (e2, [t2, i2]) => {
          const r2 = e2.properties()[t2.value], n2 = i2.value;
          return typeof r2 == typeof n2 && r2 >= n2;
        }], "filter-id->=": [jt, [Zt], (e2, [t2]) => {
          const i2 = e2.id(), r2 = t2.value;
          return typeof i2 == typeof r2 && i2 >= r2;
        }], "filter-has": [jt, [Zt], (e2, [t2]) => t2.value in e2.properties()], "filter-has-id": [jt, [], (e2) => null !== e2.id() && void 0 !== e2.id()], "filter-type-in": [jt, [Xt(Vt)], (e2, [t2]) => t2.value.indexOf(e2.geometryType()) >= 0], "filter-id-in": [jt, [Xt(Zt)], (e2, [t2]) => t2.value.indexOf(e2.id()) >= 0], "filter-in-small": [jt, [Vt, Xt(Zt)], (e2, [t2, i2]) => i2.value.indexOf(e2.properties()[t2.value]) >= 0], "filter-in-large": [jt, [Vt, Xt(Zt)], (e2, [t2, i2]) => function(e3, t3, i3, r2) {
          for (; i3 <= r2; ) {
            const n2 = i3 + r2 >> 1;
            if (t3[n2] === e3)
              return true;
            t3[n2] > e3 ? r2 = n2 - 1 : i3 = n2 + 1;
          }
          return false;
        }(e2.properties()[t2.value], i2.value, 0, i2.value.length - 1)], all: { type: jt, overloads: [[[jt, jt], (e2, [t2, i2]) => t2.evaluate(e2) && i2.evaluate(e2)], [Qn(jt), (e2, t2) => {
          for (const i2 of t2)
            if (!i2.evaluate(e2))
              return false;
          return true;
        }]] }, any: { type: jt, overloads: [[[jt, jt], (e2, [t2, i2]) => t2.evaluate(e2) || i2.evaluate(e2)], [Qn(jt), (e2, t2) => {
          for (const i2 of t2)
            if (i2.evaluate(e2))
              return true;
          return false;
        }]] }, "!": [jt, [jt], (e2, [t2]) => !t2.evaluate(e2)], "is-supported-script": [jt, [Vt], (e2, [t2]) => {
          const i2 = e2.globals && e2.globals.isSupportedScript;
          return !i2 || i2(t2.evaluate(e2));
        }], upcase: [Vt, [Vt], (e2, [t2]) => t2.evaluate(e2).toUpperCase()], downcase: [Vt, [Vt], (e2, [t2]) => t2.evaluate(e2).toLowerCase()], concat: [Vt, Qn(Zt), (e2, t2) => t2.map((t3) => _i(t3.evaluate(e2))).join("")], "resolved-locale": [Vt, [$t], (e2, [t2]) => t2.evaluate(e2).resolvedLocale()], random: [Ut, [Ut, Ut, Zt], (e2, t2) => {
          const [i2, r2, n2] = t2.map((t3) => t3.evaluate(e2));
          if (i2 > r2)
            return i2;
          if (i2 === r2)
            return i2;
          let o2;
          if ("string" == typeof n2)
            o2 = function(e3) {
              let t3 = 0;
              if (0 === e3.length)
                return t3;
              for (let i3 = 0; i3 < e3.length; i3++)
                t3 = (t3 << 5) - t3 + e3.charCodeAt(i3), t3 &= t3;
              return t3;
            }(n2);
          else {
            if ("number" != typeof n2)
              throw new xi(`Invalid seed input: ${n2}`);
            o2 = n2;
          }
          return i2 + $n(o2)() * (r2 - i2);
        }] });
        var eo = Hn;
        function to(e2) {
          return { result: "success", value: e2 };
        }
        function io(e2) {
          return { result: "error", value: e2 };
        }
        function ro(e2, t2) {
          return !!e2 && !!e2.parameters && e2.parameters.indexOf(t2) > -1;
        }
        function no(e2) {
          return "data-driven" === e2["property-type"];
        }
        function oo(e2) {
          return ro(e2.expression, "measure-light");
        }
        function so(e2) {
          return ro(e2.expression, "zoom");
        }
        function ao(e2) {
          return !!e2.expression && e2.expression.interpolated;
        }
        function lo(e2) {
          return "object" == typeof e2 && null !== e2 && !Array.isArray(e2);
        }
        function co(e2) {
          return e2;
        }
        function ho(e2, t2) {
          const i2 = "color" === t2.type, r2 = e2.stops && "object" == typeof e2.stops[0][0], n2 = r2 || !(r2 || void 0 !== e2.property), o2 = e2.type || (ao(t2) ? "exponential" : "interval");
          if (i2 && ((e2 = Pt({}, e2)).stops && (e2.stops = e2.stops.map((e3) => [e3[0], li.parse(e3[1])])), e2.default = li.parse(e2.default ? e2.default : t2.default)), e2.colorSpace && "rgb" !== e2.colorSpace && !mn[e2.colorSpace])
            throw new Error(`Unknown color space: ${e2.colorSpace}`);
          let s2, a2, l2;
          if ("exponential" === o2)
            s2 = mo;
          else if ("interval" === o2)
            s2 = fo;
          else if ("categorical" === o2) {
            s2 = po, a2 = /* @__PURE__ */ Object.create(null);
            for (const t3 of e2.stops)
              a2[t3[0]] = t3[1];
            l2 = typeof e2.stops[0][0];
          } else {
            if ("identity" !== o2)
              throw new Error(`Unknown function type "${o2}"`);
            s2 = _o;
          }
          if (r2) {
            const i3 = {}, r3 = [];
            for (let t3 = 0; t3 < e2.stops.length; t3++) {
              const n4 = e2.stops[t3], o4 = n4[0].zoom;
              void 0 === i3[o4] && (i3[o4] = { zoom: o4, type: e2.type, property: e2.property, default: e2.default, stops: [] }, r3.push(o4)), i3[o4].stops.push([n4[0].value, n4[1]]);
            }
            const n3 = [];
            for (const e3 of r3)
              n3.push([i3[e3].zoom, ho(i3[e3], t2)]);
            const o3 = { name: "linear" };
            return { kind: "composite", interpolationType: o3, interpolationFactor: yn.interpolationFactor.bind(void 0, o3), zoomStops: n3.map((e3) => e3[0]), evaluate: ({ zoom: i4 }, r4) => mo({ stops: n3, base: e2.base }, t2, i4).evaluate(i4, r4) };
          }
          if (n2) {
            const i3 = "exponential" === o2 ? { name: "exponential", base: void 0 !== e2.base ? e2.base : 1 } : null;
            return { kind: "camera", interpolationType: i3, interpolationFactor: yn.interpolationFactor.bind(void 0, i3), zoomStops: e2.stops.map((e3) => e3[0]), evaluate: ({ zoom: i4 }) => s2(e2, t2, i4, a2, l2) };
          }
          return { kind: "source", evaluate(i3, r3) {
            const n3 = r3 && r3.properties ? r3.properties[e2.property] : void 0;
            return void 0 === n3 ? uo(e2.default, t2.default) : s2(e2, t2, n3, a2, l2);
          } };
        }
        function uo(e2, t2, i2) {
          return void 0 !== e2 ? e2 : void 0 !== t2 ? t2 : void 0 !== i2 ? i2 : void 0;
        }
        function po(e2, t2, i2, r2, n2) {
          return uo(typeof i2 === n2 ? r2[i2] : void 0, e2.default, t2.default);
        }
        function fo(e2, t2, i2) {
          if ("number" !== Mi(i2))
            return uo(e2.default, t2.default);
          const r2 = e2.stops.length;
          if (1 === r2)
            return e2.stops[0][1];
          if (i2 <= e2.stops[0][0])
            return e2.stops[0][1];
          if (i2 >= e2.stops[r2 - 1][0])
            return e2.stops[r2 - 1][1];
          const n2 = Zr(e2.stops.map((e3) => e3[0]), i2);
          return e2.stops[n2][1];
        }
        function mo(e2, t2, i2) {
          const r2 = void 0 !== e2.base ? e2.base : 1;
          if ("number" !== Mi(i2))
            return uo(e2.default, t2.default);
          const n2 = e2.stops.length;
          if (1 === n2)
            return e2.stops[0][1];
          if (i2 <= e2.stops[0][0])
            return e2.stops[0][1];
          if (i2 >= e2.stops[n2 - 1][0])
            return e2.stops[n2 - 1][1];
          const o2 = Zr(e2.stops.map((e3) => e3[0]), i2), s2 = function(e3, t3, i3, r3) {
            const n3 = r3 - i3, o3 = e3 - i3;
            return 0 === n3 ? 0 : 1 === t3 ? o3 / n3 : (Math.pow(t3, o3) - 1) / (Math.pow(t3, n3) - 1);
          }(i2, r2, e2.stops[o2][0], e2.stops[o2 + 1][0]), a2 = e2.stops[o2][1], l2 = e2.stops[o2 + 1][1];
          let c2 = Yr[t2.type] || co;
          if (e2.colorSpace && "rgb" !== e2.colorSpace) {
            const t3 = mn[e2.colorSpace];
            c2 = (e3, i3) => t3.reverse(t3.interpolate(t3.forward(e3), t3.forward(i3), s2));
          }
          return "function" == typeof a2.evaluate ? { evaluate(...e3) {
            const t3 = a2.evaluate.apply(void 0, e3), i3 = l2.evaluate.apply(void 0, e3);
            if (void 0 !== t3 && void 0 !== i3)
              return c2(t3, i3, s2);
          } } : c2(a2, l2, s2);
        }
        function _o(e2, t2, i2) {
          return "color" === t2.type ? i2 = li.parse(i2) : "formatted" === t2.type ? i2 = ui.fromString(i2.toString()) : "resolvedImage" === t2.type ? i2 = di.fromString(i2.toString()) : Mi(i2) === t2.type || "enum" === t2.type && t2.values[i2] || (i2 = void 0), uo(i2, e2.default, t2.default);
        }
        class go {
          constructor(e2, t2, i2) {
            this.expression = e2, this._warningHistory = {}, this._evaluator = new zi(i2), this._defaultValue = t2 ? function(e3) {
              return "color" === e3.type && (lo(e3.default) || Array.isArray(e3.default)) ? new li(0, 0, 0, 0) : "color" === e3.type ? li.parse(e3.default) || null : void 0 === e3.default ? null : e3.default;
            }(t2) : null, this._enumValues = t2 && "enum" === t2.type ? t2.values : null;
          }
          evaluateWithoutErrorHandling(e2, t2, i2, r2, n2, o2, s2, a2) {
            return this._evaluator.globals = e2, this._evaluator.feature = t2, this._evaluator.featureState = i2, this._evaluator.canonical = r2 || null, this._evaluator.availableImages = n2 || null, this._evaluator.formattedSection = o2, this._evaluator.featureTileCoord = s2 || null, this._evaluator.featureDistanceData = a2 || null, this.expression.evaluate(this._evaluator);
          }
          evaluate(e2, t2, i2, r2, n2, o2, s2, a2) {
            this._evaluator.globals = e2, this._evaluator.feature = t2 || null, this._evaluator.featureState = i2 || null, this._evaluator.canonical = r2 || null, this._evaluator.availableImages = n2 || null, this._evaluator.formattedSection = o2 || null, this._evaluator.featureTileCoord = s2 || null, this._evaluator.featureDistanceData = a2 || null;
            try {
              const e3 = this.expression.evaluate(this._evaluator);
              if (null == e3 || "number" == typeof e3 && e3 != e3)
                return this._defaultValue;
              if (this._enumValues && !(e3 in this._enumValues))
                throw new xi(`Expected value to be one of ${Object.keys(this._enumValues).map((e4) => JSON.stringify(e4)).join(", ")}, but found ${JSON.stringify(e3)} instead.`);
              return e3;
            } catch (e3) {
              return this._warningHistory[e3.message] || (this._warningHistory[e3.message] = true, "undefined" != typeof console && console.warn(e3.message)), this._defaultValue;
            }
          }
        }
        function yo(e2) {
          return Array.isArray(e2) && e2.length > 0 && "string" == typeof e2[0] && e2[0] in eo;
        }
        function xo(e2, t2, i2) {
          const r2 = new Gr(eo, [], t2 ? function(e3) {
            const t3 = { color: Gt, string: Vt, number: Ut, enum: Vt, boolean: jt, formatted: Ht, resolvedImage: Wt };
            return "array" === e3.type ? Xt(t3[e3.value] || Zt, e3.length) : t3[e3.type];
          }(t2) : void 0, void 0, void 0, i2), n2 = r2.parse(e2, void 0, void 0, void 0, t2 && "string" === t2.type ? { typeAnnotation: "coerce" } : void 0);
          return n2 ? to(new go(n2, t2, i2)) : io(r2.errors);
        }
        class vo {
          constructor(e2, t2, i2) {
            this.kind = e2, this._styleExpression = t2, this.isLightConstant = i2, this.isStateDependent = "constant" !== e2 && !Br(t2.expression), this.isConfigDependent = !Fr(t2.expression);
          }
          evaluateWithoutErrorHandling(e2, t2, i2, r2, n2, o2) {
            return this._styleExpression.evaluateWithoutErrorHandling(e2, t2, i2, r2, n2, o2);
          }
          evaluate(e2, t2, i2, r2, n2, o2) {
            return this._styleExpression.evaluate(e2, t2, i2, r2, n2, o2);
          }
        }
        class bo {
          constructor(e2, t2, i2, r2, n2) {
            this.kind = e2, this.zoomStops = i2, this._styleExpression = t2, this.isStateDependent = "camera" !== e2 && !Br(t2.expression), this.isLightConstant = n2, this.isConfigDependent = !Fr(t2.expression), this.interpolationType = r2;
          }
          evaluateWithoutErrorHandling(e2, t2, i2, r2, n2, o2) {
            return this._styleExpression.evaluateWithoutErrorHandling(e2, t2, i2, r2, n2, o2);
          }
          evaluate(e2, t2, i2, r2, n2, o2) {
            return this._styleExpression.evaluate(e2, t2, i2, r2, n2, o2);
          }
          interpolationFactor(e2, t2, i2) {
            return this.interpolationType ? yn.interpolationFactor(this.interpolationType, e2, t2, i2) : 0;
          }
        }
        function wo(e2, t2, i2) {
          if ("error" === (e2 = xo(e2, t2, i2)).result)
            return e2;
          const r2 = e2.value.expression, n2 = Or(r2);
          if (!n2 && !no(t2))
            return io([new Ot("", "data expressions not supported")]);
          const o2 = Nr(r2, ["zoom", "pitch", "distance-from-center"]);
          if (!o2 && !so(t2))
            return io([new Ot("", "zoom expressions not supported")]);
          const s2 = Nr(r2, ["measure-light"]);
          if (!s2 && !oo(t2))
            return io([new Ot("", "measure-light expression not supported")]);
          const a2 = t2.expression && t2.expression.relaxZoomRestriction, l2 = Eo(r2);
          return l2 || o2 || a2 ? l2 instanceof Ot ? io([l2]) : l2 instanceof yn && !ao(t2) ? io([new Ot("", '"interpolate" expressions cannot be used with this property')]) : to(l2 ? new bo(n2 ? "camera" : "composite", e2.value, l2.labels, l2 instanceof yn ? l2.interpolation : void 0, s2) : new vo(n2 ? "constant" : "source", e2.value, s2)) : io([new Ot("", '"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')]);
        }
        class To {
          constructor(e2, t2) {
            this._parameters = e2, this._specification = t2, Pt(this, ho(this._parameters, this._specification));
          }
          static deserialize(e2) {
            return new To(e2._parameters, e2._specification);
          }
          static serialize(e2) {
            return { _parameters: e2._parameters, _specification: e2._specification };
          }
        }
        function Eo(e2) {
          let t2 = null;
          if (e2 instanceof wn)
            t2 = Eo(e2.result);
          else if (e2 instanceof vn) {
            for (const i2 of e2.args)
              if (t2 = Eo(i2), t2)
                break;
          } else
            (e2 instanceof Hr || e2 instanceof yn) && e2.input instanceof Pi && "zoom" === e2.input.name && (t2 = e2);
          return t2 instanceof Ot || e2.eachChild((e3) => {
            const i2 = Eo(e3);
            i2 instanceof Ot ? t2 = i2 : t2 && i2 && t2 !== i2 && (t2 = new Ot("", 'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));
          }), t2;
        }
        function Mo(e2) {
          const t2 = e2.key, i2 = e2.value, r2 = e2.valueSpec || {}, n2 = e2.objectElementValidators || {}, o2 = e2.style, s2 = e2.styleSpec;
          let a2 = [];
          const l2 = Mi(i2);
          if ("object" !== l2)
            return [new zt(t2, i2, `object expected, ${l2} found`)];
          for (const e3 in i2) {
            const l3 = e3.split(".")[0];
            let c2;
            n2[l3] ? c2 = n2[l3] : r2[l3] ? c2 = as : n2["*"] ? c2 = n2["*"] : r2["*"] && (c2 = as), c2 ? a2 = a2.concat(c2({ key: (t2 ? `${t2}.` : t2) + e3, value: i2[e3], valueSpec: r2[l3] || r2["*"], style: o2, styleSpec: s2, object: i2, objectKey: e3 }, i2)) : a2.push(new Dt(t2, i2[e3], `unknown property "${e3}"`));
          }
          for (const e3 in r2)
            n2[e3] || r2[e3].required && void 0 === r2[e3].default && void 0 === i2[e3] && a2.push(new zt(t2, i2, `missing required property "${e3}"`));
          return a2;
        }
        function Ao(e2) {
          const t2 = e2.value, i2 = e2.valueSpec, r2 = e2.style, n2 = e2.styleSpec, o2 = e2.key, s2 = e2.arrayElementValidator || as;
          if ("array" !== Mi(t2))
            return [new zt(o2, t2, `array expected, ${Mi(t2)} found`)];
          if (i2.length && t2.length !== i2.length)
            return [new zt(o2, t2, `array length ${i2.length} expected, length ${t2.length} found`)];
          if (i2["min-length"] && t2.length < i2["min-length"])
            return [new zt(o2, t2, `array length at least ${i2["min-length"]} expected, length ${t2.length} found`)];
          let a2 = { type: i2.value, values: i2.values, minimum: i2.minimum, maximum: i2.maximum, function: void 0 };
          n2.$version < 7 && (a2.function = i2.function), "object" === Mi(i2.value) && (a2 = i2.value);
          let l2 = [];
          for (let e3 = 0; e3 < t2.length; e3++)
            l2 = l2.concat(s2({ array: t2, arrayIndex: e3, value: t2[e3], valueSpec: a2, style: r2, styleSpec: n2, key: `${o2}[${e3}]` }, true));
          return l2;
        }
        function So(e2) {
          const t2 = e2.key, i2 = e2.value, r2 = e2.valueSpec;
          let n2 = Mi(i2);
          if ("number" === n2 && i2 != i2 && (n2 = "NaN"), "number" !== n2)
            return [new zt(t2, i2, `number expected, ${n2} found`)];
          if ("minimum" in r2) {
            let n3 = r2.minimum;
            if ("array" === Mi(r2.minimum) && (n3 = r2.minimum[e2.arrayIndex]), i2 < n3)
              return [new zt(t2, i2, `${i2} is less than the minimum value ${n3}`)];
          }
          if ("maximum" in r2) {
            let n3 = r2.maximum;
            if ("array" === Mi(r2.maximum) && (n3 = r2.maximum[e2.arrayIndex]), i2 > n3)
              return [new zt(t2, i2, `${i2} is greater than the maximum value ${n3}`)];
          }
          return [];
        }
        function Io(e2) {
          const t2 = e2.valueSpec, i2 = Rt(e2.value.type);
          let r2, n2, o2, s2 = {};
          const a2 = "categorical" !== i2 && void 0 === e2.value.property, l2 = !a2, c2 = "array" === Mi(e2.value.stops) && "array" === Mi(e2.value.stops[0]) && "object" === Mi(e2.value.stops[0][0]), h2 = Mo({ key: e2.key, value: e2.value, valueSpec: e2.styleSpec.function, style: e2.style, styleSpec: e2.styleSpec, objectElementValidators: { stops: function(e3) {
            if ("identity" === i2)
              return [new zt(e3.key, e3.value, 'identity function may not have a "stops" property')];
            let t3 = [];
            const r3 = e3.value;
            return t3 = t3.concat(Ao({ key: e3.key, value: r3, valueSpec: e3.valueSpec, style: e3.style, styleSpec: e3.styleSpec, arrayElementValidator: u2 })), "array" === Mi(r3) && 0 === r3.length && t3.push(new zt(e3.key, r3, "array must have at least one stop")), t3;
          }, default: function(e3) {
            return as({ key: e3.key, value: e3.value, valueSpec: t2, style: e3.style, styleSpec: e3.styleSpec });
          } } });
          return "identity" === i2 && a2 && h2.push(new zt(e2.key, e2.value, 'missing required property "property"')), "identity" === i2 || e2.value.stops || h2.push(new zt(e2.key, e2.value, 'missing required property "stops"')), "exponential" === i2 && e2.valueSpec.expression && !ao(e2.valueSpec) && h2.push(new zt(e2.key, e2.value, "exponential functions not supported")), e2.styleSpec.$version >= 8 && (l2 && !no(e2.valueSpec) ? h2.push(new zt(e2.key, e2.value, "property functions not supported")) : a2 && !so(e2.valueSpec) && h2.push(new zt(e2.key, e2.value, "zoom functions not supported"))), "categorical" !== i2 && !c2 || void 0 !== e2.value.property || h2.push(new zt(e2.key, e2.value, '"property" property is required')), h2;
          function u2(e3) {
            let i3 = [];
            const r3 = e3.value, a3 = e3.key;
            if ("array" !== Mi(r3))
              return [new zt(a3, r3, `array expected, ${Mi(r3)} found`)];
            if (2 !== r3.length)
              return [new zt(a3, r3, `array length 2 expected, length ${r3.length} found`)];
            if (c2) {
              if ("object" !== Mi(r3[0]))
                return [new zt(a3, r3, `object expected, ${Mi(r3[0])} found`)];
              if (void 0 === r3[0].zoom)
                return [new zt(a3, r3, "object stop key must have zoom")];
              if (void 0 === r3[0].value)
                return [new zt(a3, r3, "object stop key must have value")];
              const t3 = Rt(r3[0].zoom);
              if ("number" != typeof t3)
                return [new zt(a3, r3[0].zoom, "stop zoom values must be numbers")];
              if (o2 && o2 > t3)
                return [new zt(a3, r3[0].zoom, "stop zoom values must appear in ascending order")];
              t3 !== o2 && (o2 = t3, n2 = void 0, s2 = {}), i3 = i3.concat(Mo({ key: `${a3}[0]`, value: r3[0], valueSpec: { zoom: {} }, style: e3.style, styleSpec: e3.styleSpec, objectElementValidators: { zoom: So, value: d2 } }));
            } else
              i3 = i3.concat(d2({ key: `${a3}[0]`, value: r3[0], valueSpec: {}, style: e3.style, styleSpec: e3.styleSpec }, r3));
            return yo(Lt(r3[1])) ? i3.concat([new zt(`${a3}[1]`, r3[1], "expressions are not allowed in function stops.")]) : i3.concat(as({ key: `${a3}[1]`, value: r3[1], valueSpec: t2, style: e3.style, styleSpec: e3.styleSpec }));
          }
          function d2(e3, o3) {
            const a3 = Mi(e3.value), l3 = Rt(e3.value), c3 = null !== e3.value ? e3.value : o3;
            if (r2) {
              if (a3 !== r2)
                return [new zt(e3.key, c3, `${a3} stop domain type must match previous stop domain type ${r2}`)];
            } else
              r2 = a3;
            if ("number" !== a3 && "string" !== a3 && "boolean" !== a3 && "number" != typeof l3 && "string" != typeof l3 && "boolean" != typeof l3)
              return [new zt(e3.key, c3, "stop domain value must be a number, string, or boolean")];
            if ("number" !== a3 && "categorical" !== i2) {
              let r3 = `number expected, ${a3} found`;
              return no(t2) && void 0 === i2 && (r3 += '\nIf you intended to use a categorical function, specify `"type": "categorical"`.'), [new zt(e3.key, c3, r3)];
            }
            return "categorical" !== i2 || "number" !== a3 || "number" == typeof l3 && isFinite(l3) && Math.floor(l3) === l3 ? "categorical" !== i2 && "number" === a3 && "number" == typeof l3 && "number" == typeof n2 && void 0 !== n2 && l3 < n2 ? [new zt(e3.key, c3, "stop domain values must appear in ascending order")] : (n2 = l3, "categorical" === i2 && l3 in s2 ? [new zt(e3.key, c3, "stop domain values must be unique")] : (s2[l3] = true, [])) : [new zt(e3.key, c3, `integer expected, found ${String(l3)}`)];
          }
        }
        function Co(e2) {
          const t2 = ("property" === e2.expressionContext ? wo : xo)(Lt(e2.value), e2.valueSpec);
          if ("error" === t2.result)
            return t2.value.map((t3) => new zt(`${e2.key}${t3.key}`, e2.value, t3.message));
          const i2 = t2.value.expression || t2.value._styleExpression.expression;
          if ("property" === e2.expressionContext && "text-font" === e2.propertyKey && !i2.outputDefined())
            return [new zt(e2.key, e2.value, `Invalid data expression for "${e2.propertyKey}". Output values must be contained as literals within the expression.`)];
          if ("property" === e2.expressionContext && "layout" === e2.propertyType && !Br(i2))
            return [new zt(e2.key, e2.value, '"feature-state" data expressions are not supported with layout properties.')];
          if ("filter" === e2.expressionContext)
            return zo(i2, e2);
          if (e2.expressionContext && 0 === e2.expressionContext.indexOf("cluster")) {
            if (!Nr(i2, ["zoom", "feature-state"]))
              return [new zt(e2.key, e2.value, '"zoom" and "feature-state" expressions are not supported with cluster properties.')];
            if ("cluster-initial" === e2.expressionContext && !Or(i2))
              return [new zt(e2.key, e2.value, "Feature data expressions are not supported with initial expression part of cluster properties.")];
          }
          return [];
        }
        function zo(e2, t2) {
          const i2 = /* @__PURE__ */ new Set(["zoom", "feature-state", "pitch", "distance-from-center"]);
          if (t2.valueSpec && t2.valueSpec.expression)
            for (const e3 of t2.valueSpec.expression.parameters)
              i2.delete(e3);
          if (0 === i2.size)
            return [];
          const r2 = [];
          return e2 instanceof Pi && i2.has(e2.name) ? [new zt(t2.key, t2.value, `["${e2.name}"] expression is not supported in a filter for a ${t2.object.type} layer with id: ${t2.object.id}`)] : (e2.eachChild((e3) => {
            r2.push(...zo(e3, t2));
          }), r2);
        }
        function Do(e2) {
          const t2 = e2.key, i2 = e2.value, r2 = e2.valueSpec, n2 = [];
          return Array.isArray(r2.values) ? -1 === r2.values.indexOf(Rt(i2)) && n2.push(new zt(t2, i2, `expected one of [${r2.values.join(", ")}], ${JSON.stringify(i2)} found`)) : -1 === Object.keys(r2.values).indexOf(Rt(i2)) && n2.push(new zt(t2, i2, `expected one of [${Object.keys(r2.values).join(", ")}], ${JSON.stringify(i2)} found`)), n2;
        }
        function Po(e2) {
          if (true === e2 || false === e2)
            return true;
          if (!Array.isArray(e2) || 0 === e2.length)
            return false;
          switch (e2[0]) {
            case "has":
              return e2.length >= 2 && "$id" !== e2[1] && "$type" !== e2[1];
            case "in":
              return e2.length >= 3 && ("string" != typeof e2[1] || Array.isArray(e2[2]));
            case "!in":
            case "!has":
            case "none":
              return false;
            case "==":
            case "!=":
            case ">":
            case ">=":
            case "<":
            case "<=":
              return 3 !== e2.length || Array.isArray(e2[1]) || Array.isArray(e2[2]);
            case "any":
            case "all":
              for (const t2 of e2.slice(1))
                if (!Po(t2) && "boolean" != typeof t2)
                  return false;
              return true;
            default:
              return true;
          }
        }
        function Ro(e2, t2 = "fill") {
          if (null == e2)
            return { filter: () => true, needGeometry: false, needFeature: false };
          Po(e2) || (e2 = Uo(e2));
          const i2 = e2;
          let r2 = true;
          try {
            r2 = function(e3) {
              if (!Oo(e3))
                return e3;
              let t3 = Lt(e3);
              return ko(t3), t3 = Lo(t3), t3;
            }(i2);
          } catch (e3) {
            console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.
This is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md
and paste the contents of this message in the report.
Thank you!
Filter Expression:
${JSON.stringify(i2, null, 2)}
        `);
          }
          const n2 = Ct[`filter_${t2}`], o2 = xo(r2, n2);
          let s2 = null;
          if ("error" === o2.result)
            throw new Error(o2.value.map((e3) => `${e3.key}: ${e3.message}`).join(", "));
          s2 = (e3, t3, i3) => o2.value.evaluate(e3, t3, {}, i3);
          let a2 = null, l2 = null;
          if (r2 !== i2) {
            const e3 = xo(i2, n2);
            if ("error" === e3.result)
              throw new Error(e3.value.map((e4) => `${e4.key}: ${e4.message}`).join(", "));
            a2 = (t3, i3, r3, n3, o3) => e3.value.evaluate(t3, i3, {}, r3, void 0, void 0, n3, o3), l2 = !Or(e3.value.expression);
          }
          return { filter: s2, dynamicFilter: a2 || void 0, needGeometry: No(r2), needFeature: !!l2 };
        }
        function Lo(e2) {
          if (!Array.isArray(e2))
            return e2;
          const t2 = function(e3) {
            if (Bo.has(e3[0])) {
              for (let t3 = 1; t3 < e3.length; t3++)
                if (Oo(e3[t3]))
                  return true;
            }
            return e3;
          }(e2);
          return true === t2 ? t2 : t2.map((e3) => Lo(e3));
        }
        function ko(e2) {
          let t2 = false;
          const i2 = [];
          if ("case" === e2[0]) {
            for (let r2 = 1; r2 < e2.length - 1; r2 += 2)
              t2 = t2 || Oo(e2[r2]), i2.push(e2[r2 + 1]);
            i2.push(e2[e2.length - 1]);
          } else if ("match" === e2[0]) {
            t2 = t2 || Oo(e2[1]);
            for (let t3 = 2; t3 < e2.length - 1; t3 += 2)
              i2.push(e2[t3 + 1]);
            i2.push(e2[e2.length - 1]);
          } else if ("step" === e2[0]) {
            t2 = t2 || Oo(e2[1]);
            for (let t3 = 1; t3 < e2.length - 1; t3 += 2)
              i2.push(e2[t3 + 1]);
          }
          t2 && (e2.length = 0, e2.push("any", ...i2));
          for (let t3 = 1; t3 < e2.length; t3++)
            ko(e2[t3]);
        }
        function Oo(e2) {
          if (!Array.isArray(e2))
            return false;
          if ("pitch" === (t2 = e2[0]) || "distance-from-center" === t2)
            return true;
          var t2;
          for (let t3 = 1; t3 < e2.length; t3++)
            if (Oo(e2[t3]))
              return true;
          return false;
        }
        const Bo = /* @__PURE__ */ new Set(["in", "==", "!=", ">", ">=", "<", "<=", "to-boolean"]);
        function Fo(e2, t2) {
          return e2 < t2 ? -1 : e2 > t2 ? 1 : 0;
        }
        function No(e2) {
          if (!Array.isArray(e2))
            return false;
          if ("within" === e2[0] || "distance" === e2[0])
            return true;
          for (let t2 = 1; t2 < e2.length; t2++)
            if (No(e2[t2]))
              return true;
          return false;
        }
        function Uo(e2) {
          if (!e2)
            return true;
          const t2 = e2[0];
          return e2.length <= 1 ? "any" !== t2 : "==" === t2 ? Vo(e2[1], e2[2], "==") : "!=" === t2 ? qo(Vo(e2[1], e2[2], "==")) : "<" === t2 || ">" === t2 || "<=" === t2 || ">=" === t2 ? Vo(e2[1], e2[2], t2) : "any" === t2 ? (i2 = e2.slice(1), ["any"].concat(i2.map(Uo))) : "all" === t2 ? ["all"].concat(e2.slice(1).map(Uo)) : "none" === t2 ? ["all"].concat(e2.slice(1).map(Uo).map(qo)) : "in" === t2 ? jo(e2[1], e2.slice(2)) : "!in" === t2 ? qo(jo(e2[1], e2.slice(2))) : "has" === t2 ? Go(e2[1]) : "!has" !== t2 || qo(Go(e2[1]));
          var i2;
        }
        function Vo(e2, t2, i2) {
          switch (e2) {
            case "$type":
              return [`filter-type-${i2}`, t2];
            case "$id":
              return [`filter-id-${i2}`, t2];
            default:
              return [`filter-${i2}`, e2, t2];
          }
        }
        function jo(e2, t2) {
          if (0 === t2.length)
            return false;
          switch (e2) {
            case "$type":
              return ["filter-type-in", ["literal", t2]];
            case "$id":
              return ["filter-id-in", ["literal", t2]];
            default:
              return t2.length > 200 && !t2.some((e3) => typeof e3 != typeof t2[0]) ? ["filter-in-large", e2, ["literal", t2.sort(Fo)]] : ["filter-in-small", e2, ["literal", t2]];
          }
        }
        function Go(e2) {
          switch (e2) {
            case "$type":
              return true;
            case "$id":
              return ["filter-has-id"];
            default:
              return ["filter-has", e2];
          }
        }
        function qo(e2) {
          return ["!", e2];
        }
        function Zo(e2) {
          return Po(Lt(e2.value)) ? Co(Pt({}, e2, { expressionContext: "filter", valueSpec: e2.styleSpec[`filter_${e2.layerType || "fill"}`] })) : $o(e2);
        }
        function $o(e2) {
          const t2 = e2.value, i2 = e2.key;
          if ("array" !== Mi(t2))
            return [new zt(i2, t2, `array expected, ${Mi(t2)} found`)];
          const r2 = e2.styleSpec;
          let n2, o2 = [];
          if (t2.length < 1)
            return [new zt(i2, t2, "filter array must have at least 1 element")];
          switch (o2 = o2.concat(Do({ key: `${i2}[0]`, value: t2[0], valueSpec: r2.filter_operator, style: e2.style, styleSpec: e2.styleSpec })), Rt(t2[0])) {
            case "<":
            case "<=":
            case ">":
            case ">=":
              t2.length >= 2 && "$type" === Rt(t2[1]) && o2.push(new zt(i2, t2, `"$type" cannot be use with operator "${t2[0]}"`));
            case "==":
            case "!=":
              3 !== t2.length && o2.push(new zt(i2, t2, `filter array for operator "${t2[0]}" must have 3 elements`));
            case "in":
            case "!in":
              t2.length >= 2 && (n2 = Mi(t2[1]), "string" !== n2 && o2.push(new zt(`${i2}[1]`, t2[1], `string expected, ${n2} found`)));
              for (let s2 = 2; s2 < t2.length; s2++)
                n2 = Mi(t2[s2]), "$type" === Rt(t2[1]) ? o2 = o2.concat(Do({ key: `${i2}[${s2}]`, value: t2[s2], valueSpec: r2.geometry_type, style: e2.style, styleSpec: e2.styleSpec })) : "string" !== n2 && "number" !== n2 && "boolean" !== n2 && o2.push(new zt(`${i2}[${s2}]`, t2[s2], `string, number, or boolean expected, ${n2} found`));
              break;
            case "any":
            case "all":
            case "none":
              for (let r3 = 1; r3 < t2.length; r3++)
                o2 = o2.concat($o({ key: `${i2}[${r3}]`, value: t2[r3], style: e2.style, styleSpec: e2.styleSpec }));
              break;
            case "has":
            case "!has":
              n2 = Mi(t2[1]), 2 !== t2.length ? o2.push(new zt(i2, t2, `filter array for "${t2[0]}" operator must have 2 elements`)) : "string" !== n2 && o2.push(new zt(`${i2}[1]`, t2[1], `string expected, ${n2} found`));
          }
          return o2;
        }
        function Ho(e2, t2) {
          const i2 = e2.key, r2 = e2.style, n2 = e2.layer, o2 = e2.styleSpec, s2 = e2.value, a2 = e2.objectKey, l2 = o2[`${t2}_${e2.layerType}`];
          if (!l2)
            return [];
          const c2 = a2.match(/^(.*)-transition$/);
          if ("paint" === t2 && c2 && l2[c2[1]] && l2[c2[1]].transition)
            return as({ key: i2, value: s2, valueSpec: o2.transition, style: r2, styleSpec: o2 });
          const h2 = e2.valueSpec || l2[a2];
          if (!h2)
            return [new Dt(i2, s2, `unknown property "${a2}"`)];
          let u2;
          if ("string" === Mi(s2) && no(h2) && !h2.tokens && (u2 = /^{([^}]+)}$/.exec(s2))) {
            const e3 = `\`{ "type": "identity", "property": ${u2 ? JSON.stringify(u2[1]) : '"_"'} }\``;
            return [new zt(i2, s2, `"${a2}" does not support interpolation syntax
Use an identity property function instead: ${e3}.`)];
          }
          const d2 = [];
          if ("symbol" === e2.layerType)
            "text-field" !== a2 || !r2 || r2.glyphs || r2.imports || d2.push(new zt(i2, s2, 'use of "text-field" requires a style "glyphs" property')), "text-font" === a2 && lo(Lt(s2)) && "identity" === Rt(s2.type) && d2.push(new zt(i2, s2, '"text-font" does not support identity functions'));
          else if ("model" === e2.layerType && "paint" === t2 && n2 && n2.layout && n2.layout.hasOwnProperty("model-id") && no(h2) && (oo(h2) || so(h2))) {
            const e3 = wo(Lt(s2), h2), t3 = e3.value.expression || e3.value._styleExpression.expression;
            t3 && !Nr(t3, ["measure-light"]) && d2.push(new zt(i2, s2, `${a2} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`));
          }
          return d2.concat(as({ key: e2.key, value: s2, valueSpec: h2, style: r2, styleSpec: o2, expressionContext: "property", propertyType: t2, propertyKey: a2 }));
        }
        function Wo(e2) {
          return Ho(e2, "paint");
        }
        function Xo(e2) {
          return Ho(e2, "layout");
        }
        function Yo(e2) {
          let t2 = [];
          const i2 = e2.value, r2 = e2.key, n2 = e2.style, o2 = e2.styleSpec;
          i2.type || i2.ref || t2.push(new zt(r2, i2, 'either "type" or "ref" is required'));
          let s2 = Rt(i2.type);
          const a2 = Rt(i2.ref);
          if (i2.id) {
            const o3 = Rt(i2.id);
            for (let s3 = 0; s3 < e2.arrayIndex; s3++) {
              const e3 = n2.layers[s3];
              Rt(e3.id) === o3 && t2.push(new zt(r2, i2.id, `duplicate layer id "${i2.id}", previously used at line ${e3.id.__line__}`));
            }
          }
          if ("ref" in i2) {
            let e3;
            ["type", "source", "source-layer", "filter", "layout"].forEach((e4) => {
              e4 in i2 && t2.push(new zt(r2, i2[e4], `"${e4}" is prohibited for ref layers`));
            }), n2.layers.forEach((t3) => {
              Rt(t3.id) === a2 && (e3 = t3);
            }), e3 ? e3.ref ? t2.push(new zt(r2, i2.ref, "ref cannot reference another ref layer")) : s2 = Rt(e3.type) : "string" == typeof a2 && t2.push(new zt(r2, i2.ref, `ref layer "${a2}" not found`));
          } else if ("background" !== s2 && "sky" !== s2 && "slot" !== s2)
            if (i2.source) {
              const e3 = n2.sources && n2.sources[i2.source], o3 = e3 && Rt(e3.type);
              e3 ? "vector" === o3 && "raster" === s2 ? t2.push(new zt(r2, i2.source, `layer "${i2.id}" requires a raster source`)) : "raster" === o3 && "raster" !== s2 ? t2.push(new zt(r2, i2.source, `layer "${i2.id}" requires a vector source`)) : "vector" !== o3 || i2["source-layer"] ? "raster-dem" === o3 && "hillshade" !== s2 ? t2.push(new zt(r2, i2.source, "raster-dem source can only be used with layer type 'hillshade'.")) : "line" !== s2 || !i2.paint || !i2.paint["line-gradient"] && !i2.paint["line-trim-offset"] || "geojson" === o3 && e3.lineMetrics || t2.push(new zt(r2, i2, `layer "${i2.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)) : t2.push(new zt(r2, i2, `layer "${i2.id}" must specify a "source-layer"`)) : t2.push(new zt(r2, i2.source, `source "${i2.source}" not found`));
            } else
              t2.push(new zt(r2, i2, 'missing required property "source"'));
          return t2 = t2.concat(Mo({ key: r2, value: i2, valueSpec: o2.layer, style: e2.style, styleSpec: e2.styleSpec, objectElementValidators: { "*": () => [], type: () => as({ key: `${r2}.type`, value: i2.type, valueSpec: o2.layer.type, style: e2.style, styleSpec: e2.styleSpec, object: i2, objectKey: "type" }), filter: (e3) => Zo(Pt({ layerType: s2 }, e3)), layout: (e3) => Mo({ layer: i2, key: e3.key, value: e3.value, valueSpec: {}, style: e3.style, styleSpec: e3.styleSpec, objectElementValidators: { "*": (e4) => Xo(Pt({ layerType: s2 }, e4)) } }), paint: (e3) => Mo({ layer: i2, key: e3.key, value: e3.value, valueSpec: {}, style: e3.style, styleSpec: e3.styleSpec, objectElementValidators: { "*": (e4) => Wo(Pt({ layerType: s2, layer: i2 }, e4)) } }) } })), t2;
        }
        function Ko(e2) {
          const t2 = e2.value, i2 = e2.key, r2 = Mi(t2);
          return "string" !== r2 ? [new zt(i2, t2, `string expected, ${r2} found`)] : [];
        }
        const Jo = { promoteId: function({ key: e2, value: t2 }) {
          if ("string" === Mi(t2))
            return Ko({ key: e2, value: t2 });
          {
            const i2 = [];
            for (const r2 in t2)
              i2.push(...Ko({ key: `${e2}.${r2}`, value: t2[r2] }));
            return i2;
          }
        } };
        function Qo(e2) {
          const t2 = e2.value, i2 = e2.key, r2 = e2.styleSpec, n2 = e2.style;
          if (!t2.type)
            return [new zt(i2, t2, '"type" is required')];
          const o2 = Rt(t2.type);
          let s2;
          switch (o2) {
            case "vector":
            case "raster":
            case "raster-dem":
              return s2 = Mo({ key: i2, value: t2, valueSpec: r2[`source_${o2.replace("-", "_")}`], style: e2.style, styleSpec: r2, objectElementValidators: Jo }), s2;
            case "geojson":
              if (s2 = Mo({ key: i2, value: t2, valueSpec: r2.source_geojson, style: n2, styleSpec: r2, objectElementValidators: Jo }), t2.cluster)
                for (const e3 in t2.clusterProperties) {
                  const [r3, n3] = t2.clusterProperties[e3], o3 = "string" == typeof r3 ? [r3, ["accumulated"], ["get", e3]] : r3;
                  s2.push(...Co({ key: `${i2}.${e3}.map`, value: n3, expressionContext: "cluster-map" })), s2.push(...Co({ key: `${i2}.${e3}.reduce`, value: o3, expressionContext: "cluster-reduce" }));
                }
              return s2;
            case "video":
              return Mo({ key: i2, value: t2, valueSpec: r2.source_video, style: n2, styleSpec: r2 });
            case "image":
              return Mo({ key: i2, value: t2, valueSpec: r2.source_image, style: n2, styleSpec: r2 });
            case "canvas":
              return [new zt(i2, null, "Please use runtime APIs to add canvas sources, rather than including them in stylesheets.", "source.canvas")];
            default:
              return Do({ key: `${i2}.type`, value: t2.type, valueSpec: { values: es(r2) }, style: n2, styleSpec: r2 });
          }
        }
        function es(e2) {
          return e2.source.reduce((t2, i2) => {
            const r2 = e2[i2];
            return "enum" === r2.type.type && (t2 = t2.concat(Object.keys(r2.type.values))), t2;
          }, []);
        }
        function ts(e2) {
          const t2 = e2.value;
          let i2 = [];
          if (!t2)
            return i2;
          const r2 = Mi(t2);
          return "string" !== r2 ? (i2 = i2.concat([new zt(e2.key, t2, `string expected, "${r2}" found`)]), i2) : (function(e3) {
            const t3 = -1 === e3.indexOf("://");
            try {
              return new URL(e3, t3 ? "http://example.com" : void 0), true;
            } catch (e4) {
              return false;
            }
          }(t2) || (i2 = i2.concat([new zt(e2.key, t2, `invalid url "${t2}"`)])), i2);
        }
        function is(e2) {
          const t2 = e2.value, i2 = e2.styleSpec, r2 = i2.light, n2 = e2.style;
          let o2 = [];
          const s2 = Mi(t2);
          if (void 0 === t2)
            return o2;
          if ("object" !== s2)
            return o2 = o2.concat([new zt("light", t2, `object expected, ${s2} found`)]), o2;
          for (const e3 in t2) {
            const s3 = e3.match(/^(.*)-transition$/);
            o2 = o2.concat(s3 && r2[s3[1]] && r2[s3[1]].transition ? as({ key: e3, value: t2[e3], valueSpec: i2.transition, style: n2, styleSpec: i2 }) : r2[e3] ? as({ key: e3, value: t2[e3], valueSpec: r2[e3], style: n2, styleSpec: i2 }) : [new zt(e3, t2[e3], `unknown property "${e3}"`)]);
          }
          return o2;
        }
        function rs(e2) {
          const t2 = e2.value;
          let i2 = [];
          if (!t2)
            return i2;
          const r2 = Mi(t2);
          if ("object" !== r2)
            return i2 = i2.concat([new zt("light-3d", t2, `object expected, ${r2} found`)]), i2;
          const n2 = e2.styleSpec, o2 = n2["light-3d"], s2 = e2.key, a2 = e2.style, l2 = e2.style.lights;
          for (const e3 of ["type", "id"])
            if (!(e3 in t2))
              return i2 = i2.concat([new zt("light-3d", t2, `missing property ${e3} on light`)]), i2;
          if (t2.type && l2)
            for (let r3 = 0; r3 < e2.arrayIndex; r3++) {
              const e3 = Rt(t2.type), n3 = l2[r3];
              Rt(n3.type) === e3 && i2.push(new zt(s2, t2.id, `duplicate light type "${t2.type}", previously defined at line ${n3.id.__line__}`));
            }
          const c2 = `properties_light_${t2.type}`;
          if (!(c2 in n2))
            return i2 = i2.concat([new zt("light-3d", t2, `Invalid light type ${t2.type}`)]), i2;
          const h2 = n2[c2];
          for (const r3 in t2)
            if ("properties" === r3) {
              const o3 = t2[r3], s3 = Mi(o3);
              if ("object" !== s3)
                return i2 = i2.concat([new zt("properties", o3, `object expected, ${s3} found`)]), i2;
              for (const t3 in o3)
                i2 = i2.concat(h2[t3] ? as({ key: t3, value: o3[t3], valueSpec: h2[t3], style: a2, styleSpec: n2 }) : [new Dt(e2.key, o3[t3], `unknown property "${t3}"`)]);
            } else {
              const e3 = r3.match(/^(.*)-transition$/);
              i2 = i2.concat(e3 && o2[e3[1]] && o2[e3[1]].transition ? as({ key: r3, value: t2[r3], valueSpec: n2.transition, style: a2, styleSpec: n2 }) : o2[r3] ? as({ key: r3, value: t2[r3], valueSpec: o2[r3], style: a2, styleSpec: n2 }) : [new Dt(r3, t2[r3], `unknown property "${r3}"`)]);
            }
          return i2;
        }
        function ns(e2) {
          const t2 = e2.value, i2 = e2.key, r2 = e2.style, n2 = e2.styleSpec, o2 = n2.terrain;
          let s2 = [];
          const a2 = Mi(t2);
          if (void 0 === t2)
            return s2;
          if ("object" !== a2)
            return s2 = s2.concat([new zt("terrain", t2, `object expected, ${a2} found`)]), s2;
          for (const e3 in t2) {
            const i3 = e3.match(/^(.*)-transition$/);
            s2 = s2.concat(i3 && o2[i3[1]] && o2[i3[1]].transition ? as({ key: e3, value: t2[e3], valueSpec: n2.transition, style: r2, styleSpec: n2 }) : o2[e3] ? as({ key: e3, value: t2[e3], valueSpec: o2[e3], style: r2, styleSpec: n2 }) : [new Dt(e3, t2[e3], `unknown property "${e3}"`)]);
          }
          if (t2.source) {
            const e3 = r2.sources && r2.sources[t2.source], n3 = e3 && Rt(e3.type);
            e3 ? "raster-dem" !== n3 && s2.push(new zt(i2, t2.source, `terrain cannot be used with a source of type ${String(n3)}, it only be used with a "raster-dem" source type`)) : s2.push(new zt(i2, t2.source, `source "${t2.source}" not found`));
          } else
            s2.push(new zt(i2, t2, 'terrain is missing required property "source"'));
          return s2;
        }
        function os(e2) {
          const t2 = e2.value, i2 = e2.style, r2 = e2.styleSpec, n2 = r2.fog;
          let o2 = [];
          const s2 = Mi(t2);
          if (void 0 === t2)
            return o2;
          if ("object" !== s2)
            return o2 = o2.concat([new zt("fog", t2, `object expected, ${s2} found`)]), o2;
          for (const e3 in t2) {
            const s3 = e3.match(/^(.*)-transition$/);
            o2 = o2.concat(s3 && n2[s3[1]] && n2[s3[1]].transition ? as({ key: e3, value: t2[e3], valueSpec: r2.transition, style: i2, styleSpec: r2 }) : n2[e3] ? as({ key: e3, value: t2[e3], valueSpec: n2[e3], style: i2, styleSpec: r2 }) : [new Dt(e3, t2[e3], `unknown property "${e3}"`)]);
          }
          return o2;
        }
        const ss = { "*": () => [], array: Ao, boolean: function(e2) {
          const t2 = e2.value, i2 = e2.key, r2 = Mi(t2);
          return "boolean" !== r2 ? [new zt(i2, t2, `boolean expected, ${r2} found`)] : [];
        }, number: So, color: function(e2) {
          const t2 = e2.key, i2 = e2.value, r2 = Mi(i2);
          return "string" !== r2 ? [new zt(t2, i2, `color expected, ${r2} found`)] : null === ti(i2) ? [new zt(t2, i2, `color expected, "${i2}" found`)] : [];
        }, enum: Do, filter: Zo, function: Io, layer: Yo, object: Mo, source: Qo, model: ts, light: is, "light-3d": rs, terrain: ns, fog: os, string: Ko, formatted: function(e2) {
          return 0 === Ko(e2).length ? [] : Co(e2);
        }, resolvedImage: function(e2) {
          return 0 === Ko(e2).length ? [] : Co(e2);
        }, projection: function(e2) {
          const t2 = e2.value, i2 = e2.styleSpec, r2 = i2.projection, n2 = e2.style;
          let o2 = [];
          const s2 = Mi(t2);
          if ("object" === s2)
            for (const e3 in t2)
              o2 = o2.concat(as({ key: e3, value: t2[e3], valueSpec: r2[e3], style: n2, styleSpec: i2 }));
          else
            "string" !== s2 && (o2 = o2.concat([new zt("projection", t2, `object or string expected, ${s2} found`)]));
          return o2;
        }, import: function(e2) {
          const { value: t2, styleSpec: i2 } = e2, { data: r2, ...n2 } = t2;
          Object.defineProperty(n2, "__line__", { value: t2.__line__, enumerable: false });
          let o2 = Mo(Pt({}, e2, { value: n2, valueSpec: i2.import }));
          return "" === Rt(n2.id) && o2.push(new zt(`${e2.key}.id`, n2, "import id can't be an empty string")), r2 && (o2 = o2.concat(cs(r2, i2, { key: `${e2.key}.data` }))), o2;
        } };
        function as(e2, t2 = false) {
          const i2 = e2.value, r2 = e2.valueSpec, n2 = e2.styleSpec;
          if (r2.expression && lo(Rt(i2)))
            return Io(e2);
          if (r2.expression && yo(Lt(i2)))
            return Co(e2);
          if (r2.type && ss[r2.type]) {
            const i3 = ss[r2.type](e2);
            return true === t2 && i3.length > 0 && "array" === Mi(e2.value) ? Co(e2) : i3;
          }
          return Mo(Pt({}, e2, { valueSpec: r2.type ? n2[r2.type] : r2 }));
        }
        function ls(e2) {
          const t2 = e2.value, i2 = e2.key, r2 = Ko(e2);
          return r2.length || (-1 === t2.indexOf("{fontstack}") && r2.push(new zt(i2, t2, '"glyphs" url must include a "{fontstack}" token')), -1 === t2.indexOf("{range}") && r2.push(new zt(i2, t2, '"glyphs" url must include a "{range}" token'))), r2;
        }
        function cs(e2, t2 = Ct, i2 = {}) {
          return as({ key: i2.key || "", value: e2, valueSpec: t2.$root, styleSpec: t2, style: e2, objectElementValidators: { glyphs: ls, "*": () => [] } });
        }
        function hs(e2, t2 = Ct) {
          return bs(cs(e2, t2));
        }
        const us = (e2) => bs(Qo(e2)), ds = (e2) => bs(is(e2)), ps = (e2) => bs(rs(e2)), fs = (e2) => bs(ns(e2)), ms = (e2) => bs(os(e2)), _s = (e2) => bs(Yo(e2)), gs = (e2) => bs(Zo(e2)), ys = (e2) => bs(Wo(e2)), xs = (e2) => bs(Xo(e2)), vs = (e2) => bs(ts(e2));
        function bs(e2) {
          return e2.slice().sort((e3, t2) => e3.line && t2.line ? e3.line - t2.line : 0);
        }
        function ws(e2, t2) {
          let i2 = false;
          if (t2 && t2.length)
            for (const r2 of t2)
              r2 instanceof Dt ? W(r2.message) : (e2.fire(new St(new Error(r2.message))), i2 = true);
          return i2;
        }
        var Ts = Ms, Es = 3;
        function Ms(e2, t2, i2) {
          var r2 = this.cells = [];
          if (e2 instanceof ArrayBuffer) {
            this.arrayBuffer = e2;
            var n2 = new Int32Array(this.arrayBuffer);
            e2 = n2[0], this.d = (t2 = n2[1]) + 2 * (i2 = n2[2]);
            for (var o2 = 0; o2 < this.d * this.d; o2++) {
              var s2 = n2[Es + o2], a2 = n2[Es + o2 + 1];
              r2.push(s2 === a2 ? null : n2.subarray(s2, a2));
            }
            var l2 = n2[Es + r2.length + 1];
            this.keys = n2.subarray(n2[Es + r2.length], l2), this.bboxes = n2.subarray(l2), this.insert = this._insertReadonly;
          } else {
            this.d = t2 + 2 * i2;
            for (var c2 = 0; c2 < this.d * this.d; c2++)
              r2.push([]);
            this.keys = [], this.bboxes = [];
          }
          this.n = t2, this.extent = e2, this.padding = i2, this.scale = t2 / e2, this.uid = 0;
          var h2 = i2 / t2 * e2;
          this.min = -h2, this.max = e2 + h2;
        }
        Ms.prototype.insert = function(e2, t2, i2, r2, n2) {
          this._forEachCell(t2, i2, r2, n2, this._insertCell, this.uid++), this.keys.push(e2), this.bboxes.push(t2), this.bboxes.push(i2), this.bboxes.push(r2), this.bboxes.push(n2);
        }, Ms.prototype._insertReadonly = function() {
          throw "Cannot insert into a GridIndex created from an ArrayBuffer.";
        }, Ms.prototype._insertCell = function(e2, t2, i2, r2, n2, o2) {
          this.cells[n2].push(o2);
        }, Ms.prototype.query = function(e2, t2, i2, r2, n2) {
          var o2 = this.min, s2 = this.max;
          if (e2 <= o2 && t2 <= o2 && s2 <= i2 && s2 <= r2 && !n2)
            return Array.prototype.slice.call(this.keys);
          var a2 = [];
          return this._forEachCell(e2, t2, i2, r2, this._queryCell, a2, {}, n2), a2;
        }, Ms.prototype._queryCell = function(e2, t2, i2, r2, n2, o2, s2, a2) {
          var l2 = this.cells[n2];
          if (null !== l2)
            for (var c2 = this.keys, h2 = this.bboxes, u2 = 0; u2 < l2.length; u2++) {
              var d2 = l2[u2];
              if (void 0 === s2[d2]) {
                var p2 = 4 * d2;
                (a2 ? a2(h2[p2 + 0], h2[p2 + 1], h2[p2 + 2], h2[p2 + 3]) : e2 <= h2[p2 + 2] && t2 <= h2[p2 + 3] && i2 >= h2[p2 + 0] && r2 >= h2[p2 + 1]) ? (s2[d2] = true, o2.push(c2[d2])) : s2[d2] = false;
              }
            }
        }, Ms.prototype._forEachCell = function(e2, t2, i2, r2, n2, o2, s2, a2) {
          for (var l2 = this._convertToCellCoord(e2), c2 = this._convertToCellCoord(t2), h2 = this._convertToCellCoord(i2), u2 = this._convertToCellCoord(r2), d2 = l2; d2 <= h2; d2++)
            for (var p2 = c2; p2 <= u2; p2++) {
              var f2 = this.d * p2 + d2;
              if ((!a2 || a2(this._convertFromCellCoord(d2), this._convertFromCellCoord(p2), this._convertFromCellCoord(d2 + 1), this._convertFromCellCoord(p2 + 1))) && n2.call(this, e2, t2, i2, r2, f2, o2, s2, a2))
                return;
            }
        }, Ms.prototype._convertFromCellCoord = function(e2) {
          return (e2 - this.padding) / this.scale;
        }, Ms.prototype._convertToCellCoord = function(e2) {
          return Math.max(0, Math.min(this.d - 1, Math.floor(e2 * this.scale) + this.padding));
        }, Ms.prototype.toArrayBuffer = function() {
          if (this.arrayBuffer)
            return this.arrayBuffer;
          for (var e2 = this.cells, t2 = Es + this.cells.length + 1 + 1, i2 = 0, r2 = 0; r2 < this.cells.length; r2++)
            i2 += this.cells[r2].length;
          var n2 = new Int32Array(t2 + i2 + this.keys.length + this.bboxes.length);
          n2[0] = this.extent, n2[1] = this.n, n2[2] = this.padding;
          for (var o2 = t2, s2 = 0; s2 < e2.length; s2++) {
            var a2 = e2[s2];
            n2[Es + s2] = o2, n2.set(a2, o2), o2 += a2.length;
          }
          return n2[Es + e2.length] = o2, n2.set(this.keys, o2), n2[Es + e2.length + 1] = o2 += this.keys.length, n2.set(this.bboxes, o2), o2 += this.bboxes.length, n2.buffer;
        };
        var As = d(Ts);
        const Ss = {};
        function Is(e2, t2, i2 = {}) {
          Object.defineProperty(e2, "_classRegistryKey", { value: t2, writeable: false }), Ss[t2] = { klass: e2, omit: i2.omit || [] };
        }
        Is(Object, "Object"), As.serialize = function(e2, t2) {
          const i2 = e2.toArrayBuffer();
          return t2 && t2.add(i2), { buffer: i2 };
        }, As.deserialize = function(e2) {
          return new As(e2.buffer);
        }, Object.defineProperty(As, "name", { value: "Grid" }), Is(As, "Grid"), Is(li, "Color"), Is(Error, "Error"), Is(xe, "AJAXError"), Is(di, "ResolvedImage"), Is(To, "StylePropertyFunction"), Is(go, "StyleExpression", { omit: ["_evaluator"] }), Is(bo, "ZoomDependentExpression"), Is(vo, "ZoomConstantExpression"), Is(Pi, "CompoundExpression", { omit: ["_evaluate"] });
        for (const e2 in eo)
          Ss[eo[e2]._classRegistryKey] || Is(eo[e2], `Expression${e2}`);
        function Cs(e2) {
          return e2 && "undefined" != typeof ArrayBuffer && (e2 instanceof ArrayBuffer || e2.constructor && "ArrayBuffer" === e2.constructor.name);
        }
        function zs(e2) {
          return t.ImageBitmap && e2 instanceof t.ImageBitmap;
        }
        function Ds(e2, i2) {
          if (null == e2 || "boolean" == typeof e2 || "number" == typeof e2 || "string" == typeof e2 || e2 instanceof Boolean || e2 instanceof Number || e2 instanceof String || e2 instanceof Date || e2 instanceof RegExp)
            return e2;
          if (Cs(e2) || zs(e2))
            return i2 && i2.add(e2), e2;
          if (ArrayBuffer.isView(e2)) {
            const t2 = e2;
            return i2 && i2.add(t2.buffer), t2;
          }
          if (e2 instanceof t.ImageData)
            return i2 && i2.add(e2.data.buffer), e2;
          if (Array.isArray(e2)) {
            const t2 = [];
            for (const r2 of e2)
              t2.push(Ds(r2, i2));
            return t2;
          }
          if (e2 instanceof Map) {
            const t2 = { $name: "Map" };
            for (const [i3, r2] of e2.entries())
              t2[i3] = Ds(r2);
            return t2;
          }
          if ("object" == typeof e2) {
            const t2 = e2.constructor, r2 = t2._classRegistryKey;
            if (!r2)
              throw new Error(`can't serialize object of unregistered class ${r2}`);
            const n2 = t2.serialize ? t2.serialize(e2, i2) : {};
            if (!t2.serialize) {
              for (const t3 in e2)
                e2.hasOwnProperty(t3) && (Ss[r2].omit.indexOf(t3) >= 0 || (n2[t3] = Ds(e2[t3], i2)));
              e2 instanceof Error && (n2.message = e2.message);
            }
            if (n2.$name)
              throw new Error("$name property is reserved for worker serialization logic.");
            return "Object" !== r2 && (n2.$name = r2), n2;
          }
          throw new Error("can't serialize object of type " + typeof e2);
        }
        function Ps(e2) {
          if (null == e2 || "boolean" == typeof e2 || "number" == typeof e2 || "string" == typeof e2 || e2 instanceof Boolean || e2 instanceof Number || e2 instanceof String || e2 instanceof Date || e2 instanceof RegExp || Cs(e2) || zs(e2) || ArrayBuffer.isView(e2) || e2 instanceof t.ImageData)
            return e2;
          if (Array.isArray(e2))
            return e2.map(Ps);
          if ("object" == typeof e2) {
            const t2 = e2.$name || "Object";
            if ("Map" === t2) {
              const t3 = /* @__PURE__ */ new Map();
              for (const i3 of Object.keys(e2))
                "$name" !== i3 && t3.set(i3, Ps(e2[i3]));
              return t3;
            }
            const { klass: i2 } = Ss[t2];
            if (!i2)
              throw new Error(`can't deserialize unregistered class ${t2}`);
            if (i2.deserialize)
              return i2.deserialize(e2);
            const r2 = Object.create(i2.prototype);
            for (const t3 of Object.keys(e2))
              "$name" !== t3 && (r2[t3] = Ps(e2[t3]));
            return r2;
          }
          throw new Error("can't deserialize object of type " + typeof e2);
        }
        const Rs = { "Latin-1 Supplement": (e2) => e2 >= 128 && e2 <= 255, Arabic: (e2) => e2 >= 1536 && e2 <= 1791, "Arabic Supplement": (e2) => e2 >= 1872 && e2 <= 1919, "Arabic Extended-A": (e2) => e2 >= 2208 && e2 <= 2303, "Hangul Jamo": (e2) => e2 >= 4352 && e2 <= 4607, "Unified Canadian Aboriginal Syllabics": (e2) => e2 >= 5120 && e2 <= 5759, Khmer: (e2) => e2 >= 6016 && e2 <= 6143, "Unified Canadian Aboriginal Syllabics Extended": (e2) => e2 >= 6320 && e2 <= 6399, "General Punctuation": (e2) => e2 >= 8192 && e2 <= 8303, "Letterlike Symbols": (e2) => e2 >= 8448 && e2 <= 8527, "Number Forms": (e2) => e2 >= 8528 && e2 <= 8591, "Miscellaneous Technical": (e2) => e2 >= 8960 && e2 <= 9215, "Control Pictures": (e2) => e2 >= 9216 && e2 <= 9279, "Optical Character Recognition": (e2) => e2 >= 9280 && e2 <= 9311, "Enclosed Alphanumerics": (e2) => e2 >= 9312 && e2 <= 9471, "Geometric Shapes": (e2) => e2 >= 9632 && e2 <= 9727, "Miscellaneous Symbols": (e2) => e2 >= 9728 && e2 <= 9983, "Miscellaneous Symbols and Arrows": (e2) => e2 >= 11008 && e2 <= 11263, "CJK Radicals Supplement": (e2) => e2 >= 11904 && e2 <= 12031, "Kangxi Radicals": (e2) => e2 >= 12032 && e2 <= 12255, "Ideographic Description Characters": (e2) => e2 >= 12272 && e2 <= 12287, "CJK Symbols and Punctuation": (e2) => e2 >= 12288 && e2 <= 12351, Hiragana: (e2) => e2 >= 12352 && e2 <= 12447, Katakana: (e2) => e2 >= 12448 && e2 <= 12543, Bopomofo: (e2) => e2 >= 12544 && e2 <= 12591, "Hangul Compatibility Jamo": (e2) => e2 >= 12592 && e2 <= 12687, Kanbun: (e2) => e2 >= 12688 && e2 <= 12703, "Bopomofo Extended": (e2) => e2 >= 12704 && e2 <= 12735, "CJK Strokes": (e2) => e2 >= 12736 && e2 <= 12783, "Katakana Phonetic Extensions": (e2) => e2 >= 12784 && e2 <= 12799, "Enclosed CJK Letters and Months": (e2) => e2 >= 12800 && e2 <= 13055, "CJK Compatibility": (e2) => e2 >= 13056 && e2 <= 13311, "CJK Unified Ideographs Extension A": (e2) => e2 >= 13312 && e2 <= 19903, "Yijing Hexagram Symbols": (e2) => e2 >= 19904 && e2 <= 19967, "CJK Unified Ideographs": (e2) => e2 >= 19968 && e2 <= 40959, "Yi Syllables": (e2) => e2 >= 40960 && e2 <= 42127, "Yi Radicals": (e2) => e2 >= 42128 && e2 <= 42191, "Hangul Jamo Extended-A": (e2) => e2 >= 43360 && e2 <= 43391, "Hangul Syllables": (e2) => e2 >= 44032 && e2 <= 55215, "Hangul Jamo Extended-B": (e2) => e2 >= 55216 && e2 <= 55295, "Private Use Area": (e2) => e2 >= 57344 && e2 <= 63743, "CJK Compatibility Ideographs": (e2) => e2 >= 63744 && e2 <= 64255, "Arabic Presentation Forms-A": (e2) => e2 >= 64336 && e2 <= 65023, "Vertical Forms": (e2) => e2 >= 65040 && e2 <= 65055, "CJK Compatibility Forms": (e2) => e2 >= 65072 && e2 <= 65103, "Small Form Variants": (e2) => e2 >= 65104 && e2 <= 65135, "Arabic Presentation Forms-B": (e2) => e2 >= 65136 && e2 <= 65279, "Halfwidth and Fullwidth Forms": (e2) => e2 >= 65280 && e2 <= 65519, "CJK Unified Ideographs Extension B": (e2) => e2 >= 131072 && e2 <= 173791 };
        function Ls(e2) {
          for (const t2 of e2)
            if (Bs(t2.charCodeAt(0)))
              return true;
          return false;
        }
        function ks(e2) {
          for (const t2 of e2)
            if (!Os(t2.charCodeAt(0)))
              return false;
          return true;
        }
        function Os(e2) {
          return !(Rs.Arabic(e2) || Rs["Arabic Supplement"](e2) || Rs["Arabic Extended-A"](e2) || Rs["Arabic Presentation Forms-A"](e2) || Rs["Arabic Presentation Forms-B"](e2));
        }
        function Bs(e2) {
          return !(746 !== e2 && 747 !== e2 && (e2 < 4352 || !(Rs["Bopomofo Extended"](e2) || Rs.Bopomofo(e2) || Rs["CJK Compatibility Forms"](e2) && !(e2 >= 65097 && e2 <= 65103) || Rs["CJK Compatibility Ideographs"](e2) || Rs["CJK Compatibility"](e2) || Rs["CJK Radicals Supplement"](e2) || Rs["CJK Strokes"](e2) || !(!Rs["CJK Symbols and Punctuation"](e2) || e2 >= 12296 && e2 <= 12305 || e2 >= 12308 && e2 <= 12319 || 12336 === e2) || Rs["CJK Unified Ideographs Extension A"](e2) || Rs["CJK Unified Ideographs"](e2) || Rs["Enclosed CJK Letters and Months"](e2) || Rs["Hangul Compatibility Jamo"](e2) || Rs["Hangul Jamo Extended-A"](e2) || Rs["Hangul Jamo Extended-B"](e2) || Rs["Hangul Jamo"](e2) || Rs["Hangul Syllables"](e2) || Rs.Hiragana(e2) || Rs["Ideographic Description Characters"](e2) || Rs.Kanbun(e2) || Rs["Kangxi Radicals"](e2) || Rs["Katakana Phonetic Extensions"](e2) || Rs.Katakana(e2) && 12540 !== e2 || !(!Rs["Halfwidth and Fullwidth Forms"](e2) || 65288 === e2 || 65289 === e2 || 65293 === e2 || e2 >= 65306 && e2 <= 65310 || 65339 === e2 || 65341 === e2 || 65343 === e2 || e2 >= 65371 && e2 <= 65503 || 65507 === e2 || e2 >= 65512 && e2 <= 65519) || !(!Rs["Small Form Variants"](e2) || e2 >= 65112 && e2 <= 65118 || e2 >= 65123 && e2 <= 65126) || Rs["Unified Canadian Aboriginal Syllabics"](e2) || Rs["Unified Canadian Aboriginal Syllabics Extended"](e2) || Rs["Vertical Forms"](e2) || Rs["Yijing Hexagram Symbols"](e2) || Rs["Yi Syllables"](e2) || Rs["Yi Radicals"](e2))));
        }
        function Fs(e2) {
          return !(Bs(e2) || function(e3) {
            return !!(Rs["Latin-1 Supplement"](e3) && (167 === e3 || 169 === e3 || 174 === e3 || 177 === e3 || 188 === e3 || 189 === e3 || 190 === e3 || 215 === e3 || 247 === e3) || Rs["General Punctuation"](e3) && (8214 === e3 || 8224 === e3 || 8225 === e3 || 8240 === e3 || 8241 === e3 || 8251 === e3 || 8252 === e3 || 8258 === e3 || 8263 === e3 || 8264 === e3 || 8265 === e3 || 8273 === e3) || Rs["Letterlike Symbols"](e3) || Rs["Number Forms"](e3) || Rs["Miscellaneous Technical"](e3) && (e3 >= 8960 && e3 <= 8967 || e3 >= 8972 && e3 <= 8991 || e3 >= 8996 && e3 <= 9e3 || 9003 === e3 || e3 >= 9085 && e3 <= 9114 || e3 >= 9150 && e3 <= 9165 || 9167 === e3 || e3 >= 9169 && e3 <= 9179 || e3 >= 9186 && e3 <= 9215) || Rs["Control Pictures"](e3) && 9251 !== e3 || Rs["Optical Character Recognition"](e3) || Rs["Enclosed Alphanumerics"](e3) || Rs["Geometric Shapes"](e3) || Rs["Miscellaneous Symbols"](e3) && !(e3 >= 9754 && e3 <= 9759) || Rs["Miscellaneous Symbols and Arrows"](e3) && (e3 >= 11026 && e3 <= 11055 || e3 >= 11088 && e3 <= 11097 || e3 >= 11192 && e3 <= 11243) || Rs["CJK Symbols and Punctuation"](e3) || Rs.Katakana(e3) || Rs["Private Use Area"](e3) || Rs["CJK Compatibility Forms"](e3) || Rs["Small Form Variants"](e3) || Rs["Halfwidth and Fullwidth Forms"](e3) || 8734 === e3 || 8756 === e3 || 8757 === e3 || e3 >= 9984 && e3 <= 10087 || e3 >= 10102 && e3 <= 10131 || 65532 === e3 || 65533 === e3);
          }(e2));
        }
        function Ns(e2) {
          return e2 >= 1424 && e2 <= 2303 || Rs["Arabic Presentation Forms-A"](e2) || Rs["Arabic Presentation Forms-B"](e2);
        }
        function Us(e2, t2) {
          return !(!t2 && Ns(e2) || e2 >= 2304 && e2 <= 3583 || e2 >= 3840 && e2 <= 4255 || Rs.Khmer(e2));
        }
        function Vs(e2) {
          for (const t2 of e2)
            if (Ns(t2.charCodeAt(0)))
              return true;
          return false;
        }
        const js = "deferred", Gs = "loading", qs = "loaded";
        let Zs = null, $s = "unavailable", Hs = null;
        const Ws = function(e2) {
          e2 && "string" == typeof e2 && e2.indexOf("NetworkError") > -1 && ($s = "error"), Zs && Zs(e2);
        };
        function Xs() {
          Ys.fire(new At("pluginStateChange", { pluginStatus: $s, pluginURL: Hs }));
        }
        const Ys = new It(), Ks = function() {
          return $s;
        }, Js = function() {
          if ($s !== js || !Hs)
            throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");
          $s = Gs, Xs(), Hs && Te({ url: Hs }, (e2) => {
            e2 ? Ws(e2) : ($s = qs, Xs());
          });
        }, Qs = { applyArabicShaping: null, processBidirectionalText: null, processStyledBidirectionalText: null, isLoaded: () => $s === qs || null != Qs.applyArabicShaping, isLoading: () => $s === Gs, setState(e2) {
          $s = e2.pluginStatus, Hs = e2.pluginURL;
        }, isParsed: () => null != Qs.applyArabicShaping && null != Qs.processBidirectionalText && null != Qs.processStyledBidirectionalText, getPluginURL: () => Hs };
        class ea {
          constructor(e2, t2) {
            this.zoom = e2, t2 ? (this.now = t2.now, this.fadeDuration = t2.fadeDuration, this.transition = t2.transition, this.pitch = t2.pitch, this.brightness = t2.brightness) : (this.now = 0, this.fadeDuration = 0, this.transition = {}, this.pitch = 0, this.brightness = 0);
          }
          isSupportedScript(e2) {
            return function(e3, t2) {
              for (const i2 of e3)
                if (!Us(i2.charCodeAt(0), t2))
                  return false;
              return true;
            }(e2, Qs.isLoaded());
          }
        }
        class ta {
          constructor(e2, t2, i2) {
            this.property = e2, this.value = t2, this.expression = function(e3, t3, i3) {
              if (lo(e3))
                return new To(e3, t3);
              if (yo(e3) || Array.isArray(e3) && e3.length > 0) {
                const r2 = wo(e3, t3, i3);
                if ("error" === r2.result)
                  throw new Error(r2.value.map((e4) => `${e4.key}: ${e4.message}`).join(", "));
                return r2.value;
              }
              {
                let i4 = e3;
                return "string" == typeof e3 && "color" === t3.type && (i4 = li.parse(e3)), { kind: "constant", isConfigDependent: false, evaluate: () => i4 };
              }
            }(void 0 === t2 ? e2.specification.default : t2, e2.specification, i2);
          }
          isDataDriven() {
            return "source" === this.expression.kind || "composite" === this.expression.kind;
          }
          possiblyEvaluate(e2, t2, i2) {
            return this.property.possiblyEvaluate(this, e2, t2, i2);
          }
        }
        class ia {
          constructor(e2, t2) {
            this.property = e2, this.value = new ta(e2, void 0, t2);
          }
          transitioned(e2, t2) {
            return new na(this.property, this.value, t2, k({}, e2.transition, this.transition), e2.now);
          }
          untransitioned() {
            return new na(this.property, this.value, null, {}, 0);
          }
        }
        class ra {
          constructor(e2, t2) {
            this._properties = e2, this._values = Object.create(e2.defaultTransitionablePropertyValues), this._options = t2, this.isConfigDependent = false;
          }
          getValue(e2) {
            return $(this._values[e2].value.value);
          }
          setValue(e2, t2) {
            this._values.hasOwnProperty(e2) || (this._values[e2] = new ia(this._values[e2].property, this._options)), this._values[e2].value = new ta(this._values[e2].property, null === t2 ? void 0 : $(t2), this._options), this.isConfigDependent = this.isConfigDependent || this._values[e2].value.expression.isConfigDependent;
          }
          setTransitionOrValue(e2, t2) {
            t2 && (this._options = t2);
            const i2 = this._properties.properties;
            if (e2)
              for (const t3 in e2) {
                const r2 = e2[t3];
                if (G(t3, "-transition")) {
                  const e3 = t3.slice(0, -11);
                  i2[e3] && this.setTransition(e3, r2);
                } else
                  i2[t3] && this.setValue(t3, r2);
              }
          }
          getTransition(e2) {
            return $(this._values[e2].transition);
          }
          setTransition(e2, t2) {
            this._values.hasOwnProperty(e2) || (this._values[e2] = new ia(this._values[e2].property)), this._values[e2].transition = $(t2) || void 0;
          }
          serialize() {
            const e2 = {};
            for (const t2 of Object.keys(this._values)) {
              const i2 = this.getValue(t2);
              void 0 !== i2 && (e2[t2] = i2);
              const r2 = this.getTransition(t2);
              void 0 !== r2 && (e2[`${t2}-transition`] = r2);
            }
            return e2;
          }
          transitioned(e2, t2) {
            const i2 = new oa(this._properties);
            for (const r2 of Object.keys(this._values))
              i2._values[r2] = this._values[r2].transitioned(e2, t2._values[r2]);
            return i2;
          }
          untransitioned() {
            const e2 = new oa(this._properties);
            for (const t2 of Object.keys(this._values))
              e2._values[t2] = this._values[t2].untransitioned();
            return e2;
          }
        }
        class na {
          constructor(e2, t2, i2, r2, n2) {
            const o2 = r2.delay || 0, s2 = r2.duration || 0;
            n2 = n2 || 0, this.property = e2, this.value = t2, this.begin = n2 + o2, this.end = this.begin + s2, e2.specification.transition && (r2.delay || r2.duration) && (this.prior = i2);
          }
          possiblyEvaluate(e2, t2, i2) {
            const r2 = e2.now || 0, n2 = this.value.possiblyEvaluate(e2, t2, i2), o2 = this.prior;
            if (o2) {
              if (r2 > this.end)
                return this.prior = null, n2;
              if (this.value.isDataDriven())
                return this.prior = null, n2;
              if (r2 < this.begin)
                return o2.possiblyEvaluate(e2, t2, i2);
              {
                const s2 = (r2 - this.begin) / (this.end - this.begin);
                return this.property.interpolate(o2.possiblyEvaluate(e2, t2, i2), n2, M(s2));
              }
            }
            return n2;
          }
        }
        class oa {
          constructor(e2) {
            this._properties = e2, this._values = Object.create(e2.defaultTransitioningPropertyValues);
          }
          possiblyEvaluate(e2, t2, i2) {
            const r2 = new la(this._properties);
            for (const n2 of Object.keys(this._values))
              r2._values[n2] = this._values[n2].possiblyEvaluate(e2, t2, i2);
            return r2;
          }
          hasTransition() {
            for (const e2 of Object.keys(this._values))
              if (this._values[e2].prior)
                return true;
            return false;
          }
        }
        class sa {
          constructor(e2, t2) {
            this._properties = e2, this._values = Object.create(e2.defaultPropertyValues), this._options = t2, this.isConfigDependent = false;
          }
          getValue(e2) {
            return $(this._values[e2].value);
          }
          setValue(e2, t2) {
            this._values[e2] = new ta(this._values[e2].property, null === t2 ? void 0 : $(t2), this._options), this.isConfigDependent = this.isConfigDependent || this._values[e2].expression.isConfigDependent;
          }
          serialize() {
            const e2 = {};
            for (const t2 of Object.keys(this._values)) {
              const i2 = this.getValue(t2);
              void 0 !== i2 && (e2[t2] = i2);
            }
            return e2;
          }
          possiblyEvaluate(e2, t2, i2) {
            const r2 = new la(this._properties);
            for (const n2 of Object.keys(this._values))
              r2._values[n2] = this._values[n2].possiblyEvaluate(e2, t2, i2);
            return r2;
          }
        }
        class aa {
          constructor(e2, t2, i2) {
            this.property = e2, this.value = t2, this.parameters = i2;
          }
          isConstant() {
            return "constant" === this.value.kind;
          }
          constantOr(e2) {
            return "constant" === this.value.kind ? this.value.value : e2;
          }
          evaluate(e2, t2, i2, r2) {
            return this.property.evaluate(this.value, this.parameters, e2, t2, i2, r2);
          }
        }
        class la {
          constructor(e2) {
            this._properties = e2, this._values = Object.create(e2.defaultPossiblyEvaluatedValues);
          }
          get(e2) {
            return this._values[e2];
          }
        }
        class ca {
          constructor(e2) {
            this.specification = e2;
          }
          possiblyEvaluate(e2, t2) {
            return e2.expression.evaluate(t2);
          }
          interpolate(e2, t2, i2) {
            const r2 = Yr[this.specification.type];
            return r2 ? r2(e2, t2, i2) : e2;
          }
        }
        class ha {
          constructor(e2, t2) {
            this.specification = e2, this.overrides = t2;
          }
          possiblyEvaluate(e2, t2, i2, r2) {
            return new aa(this, "constant" === e2.expression.kind || "camera" === e2.expression.kind ? { kind: "constant", value: e2.expression.evaluate(t2, null, {}, i2, r2) } : e2.expression, t2);
          }
          interpolate(e2, t2, i2) {
            if ("constant" !== e2.value.kind || "constant" !== t2.value.kind)
              return e2;
            if (void 0 === e2.value.value || void 0 === t2.value.value)
              return new aa(this, { kind: "constant", value: void 0 }, e2.parameters);
            const r2 = Yr[this.specification.type];
            return r2 ? new aa(this, { kind: "constant", value: r2(e2.value.value, t2.value.value, i2) }, e2.parameters) : e2;
          }
          evaluate(e2, t2, i2, r2, n2, o2) {
            return "constant" === e2.kind ? e2.value : e2.evaluate(t2, i2, r2, n2, o2);
          }
        }
        class ua {
          constructor(e2) {
            this.specification = e2;
          }
          possiblyEvaluate(e2, t2, i2, r2) {
            return !!e2.expression.evaluate(t2, null, {}, i2, r2);
          }
          interpolate() {
            return false;
          }
        }
        class da {
          constructor(e2) {
            this.properties = e2, this.defaultPropertyValues = {}, this.defaultTransitionablePropertyValues = {}, this.defaultTransitioningPropertyValues = {}, this.defaultPossiblyEvaluatedValues = {}, this.overridableProperties = [];
            const t2 = new ea(0, {});
            for (const i2 in e2) {
              const r2 = e2[i2];
              r2.specification.overridable && this.overridableProperties.push(i2);
              const n2 = this.defaultPropertyValues[i2] = new ta(r2, void 0), o2 = this.defaultTransitionablePropertyValues[i2] = new ia(r2);
              this.defaultTransitioningPropertyValues[i2] = o2.untransitioned(), this.defaultPossiblyEvaluatedValues[i2] = n2.possiblyEvaluate(t2);
            }
          }
        }
        function pa(e2, t2) {
          return t2 ? `${e2}${t2}` : e2;
        }
        function fa(e2) {
          const t2 = e2.indexOf("");
          return t2 >= 0 ? e2.slice(0, t2) : e2;
        }
        Is(ha, "DataDrivenProperty"), Is(ca, "DataConstantProperty"), Is(ua, "ColorRampProperty");
        const ma = "-transition";
        class _a extends It {
          constructor(e2, t2, i2) {
            if (super(), this.id = e2.id, this.type = e2.type, this._featureFilter = { filter: () => true, needGeometry: false, needFeature: false }, this._filterCompiled = false, this.isConfigDependent = false, "custom" !== e2.type && (this.metadata = e2.metadata, this.minzoom = e2.minzoom, this.maxzoom = e2.maxzoom, "background" !== e2.type && "sky" !== e2.type && "slot" !== e2.type && (this.source = e2.source, this.sourceLayer = e2["source-layer"], this.filter = e2.filter), this.options = i2, e2.slot && (this.slot = e2.slot), t2.layout && (this._unevaluatedLayout = new sa(t2.layout, i2), this.isConfigDependent = this.isConfigDependent || this._unevaluatedLayout.isConfigDependent), t2.paint)) {
              this._transitionablePaint = new ra(t2.paint, i2);
              for (const t3 in e2.paint)
                this.setPaintProperty(t3, e2.paint[t3], { validate: false });
              for (const t3 in e2.layout)
                this.setLayoutProperty(t3, e2.layout[t3], { validate: false });
              this.isConfigDependent = this.isConfigDependent || this._transitionablePaint.isConfigDependent, this._transitioningPaint = this._transitionablePaint.untransitioned(), this.paint = new la(t2.paint);
            }
          }
          setScope(e2) {
            this.scope = e2, this.fqid = pa(this.id, e2);
          }
          getLayoutProperty(e2) {
            return "visibility" === e2 ? this.visibility : this._unevaluatedLayout.getValue(e2);
          }
          setLayoutProperty(e2, t2, i2 = {}) {
            if (null != t2 && this._validate(xs, `layers.${this.id}.layout.${e2}`, e2, t2, i2))
              return;
            if ("custom" === this.type && "visibility" === e2)
              return void (this.visibility = t2);
            const r2 = this._unevaluatedLayout;
            r2._properties.properties[e2] && (r2.setValue(e2, t2), this.isConfigDependent = this.isConfigDependent || r2.isConfigDependent, "visibility" === e2 && this.possiblyEvaluateVisibility());
          }
          possiblyEvaluateVisibility() {
            this.visibility = this._unevaluatedLayout._values.visibility.possiblyEvaluate({ zoom: 0 });
          }
          getPaintProperty(e2) {
            return G(e2, ma) ? this._transitionablePaint.getTransition(e2.slice(0, -11)) : this._transitionablePaint.getValue(e2);
          }
          setPaintProperty(e2, t2, i2 = {}) {
            if (null != t2 && this._validate(ys, `layers.${this.id}.paint.${e2}`, e2, t2, i2))
              return false;
            const r2 = this._transitionablePaint, n2 = r2._properties.properties;
            if (G(e2, ma)) {
              const i3 = e2.slice(0, -11);
              return n2[i3] && r2.setTransition(i3, t2 || void 0), false;
            }
            if (!n2[e2])
              return false;
            const o2 = r2._values[e2], s2 = o2.value.isDataDriven(), a2 = o2.value;
            r2.setValue(e2, t2), this.isConfigDependent = this.isConfigDependent || r2.isConfigDependent, this._handleSpecialPaintPropertyUpdate(e2);
            const l2 = r2._values[e2].value, c2 = l2.isDataDriven(), h2 = G(e2, "pattern") || "line-dasharray" === e2;
            return c2 || s2 || h2 || this._handleOverridablePaintPropertyUpdate(e2, a2, l2);
          }
          _handleSpecialPaintPropertyUpdate(e2) {
          }
          getProgramIds() {
            return null;
          }
          getDefaultProgramParams(e2, t2) {
            return null;
          }
          _handleOverridablePaintPropertyUpdate(e2, t2, i2) {
            return false;
          }
          isHidden(e2) {
            return !!(this.minzoom && e2 < this.minzoom) || !!(this.maxzoom && e2 >= this.maxzoom) || "none" === this.visibility;
          }
          updateTransitions(e2) {
            this._transitioningPaint = this._transitionablePaint.transitioned(e2, this._transitioningPaint);
          }
          hasTransition() {
            return this._transitioningPaint.hasTransition();
          }
          recalculate(e2, t2) {
            this._unevaluatedLayout && (this.layout = this._unevaluatedLayout.possiblyEvaluate(e2, void 0, t2)), this.paint = this._transitioningPaint.possiblyEvaluate(e2, void 0, t2);
          }
          serialize() {
            return Z({ id: this.id, type: this.type, slot: this.slot, source: this.source, "source-layer": this.sourceLayer, metadata: this.metadata, minzoom: this.minzoom, maxzoom: this.maxzoom, filter: this.filter, layout: this._unevaluatedLayout && this._unevaluatedLayout.serialize(), paint: this._transitionablePaint && this._transitionablePaint.serialize() }, (e2, t2) => !(void 0 === e2 || "layout" === t2 && !Object.keys(e2).length || "paint" === t2 && !Object.keys(e2).length));
          }
          _validate(e2, t2, i2, r2, n2 = {}) {
            return (!n2 || false !== n2.validate) && ws(this, e2.call(hs, { key: t2, layerType: this.type, objectKey: i2, value: r2, styleSpec: Ct, style: { glyphs: true, sprite: true } }));
          }
          is3D() {
            return false;
          }
          isSky() {
            return false;
          }
          isTileClipped() {
            return false;
          }
          hasOffscreenPass() {
            return false;
          }
          hasShadowPass() {
            return false;
          }
          canCastShadows() {
            return false;
          }
          hasLightBeamPass() {
            return false;
          }
          cutoffRange() {
            return 0;
          }
          resize() {
          }
          isStateDependent() {
            for (const e2 in this.paint._values) {
              const t2 = this.paint.get(e2);
              if (t2 instanceof aa && no(t2.property.specification) && ("source" === t2.value.kind || "composite" === t2.value.kind) && t2.value.isStateDependent)
                return true;
            }
            return false;
          }
          compileFilter() {
            this._filterCompiled || (this._featureFilter = Ro(this.filter), this._filterCompiled = true);
          }
          invalidateCompiledFilter() {
            this._filterCompiled = false;
          }
          dynamicFilter() {
            return this._featureFilter.dynamicFilter;
          }
          dynamicFilterNeedsFeature() {
            return this._featureFilter.needFeature;
          }
        }
        class ga {
          constructor() {
            this.changed = false, this._updatedLayers = {}, this._removedLayers = {}, this.updatedSourceCaches = {}, this.updatedPaintProps = /* @__PURE__ */ new Set(), this.changedImages = /* @__PURE__ */ new Set();
          }
          updateLayer(e2) {
            const t2 = e2.scope;
            this._updatedLayers[t2] = this._updatedLayers[t2] || /* @__PURE__ */ new Set(), this._updatedLayers[t2].add(e2.id);
          }
          removeLayer(e2) {
            const t2 = e2.scope;
            this._removedLayers[t2] = this._removedLayers[t2] || {}, this._updatedLayers[t2] = this._updatedLayers[t2] || /* @__PURE__ */ new Set(), this._removedLayers[t2][e2.id] = e2, this._updatedLayers[t2].delete(e2.id), this.updatedPaintProps.delete(e2.fqid);
          }
          getRemovedLayer(e2) {
            return this._removedLayers[e2.scope] ? this._removedLayers[e2.scope][e2.id] : null;
          }
          discardLayerRemoval(e2) {
            this._removedLayers[e2.scope] && delete this._removedLayers[e2.scope][e2.id];
          }
          getLayerUpdatesByScope() {
            const e2 = {};
            for (const t2 in this._updatedLayers)
              e2[t2] = e2[t2] || {}, e2[t2].updatedIds = Array.from(this._updatedLayers[t2].values());
            for (const t2 in this._removedLayers)
              e2[t2] = e2[t2] || {}, e2[t2].removedIds = Object.keys(this._removedLayers[t2]);
            return e2;
          }
          reset() {
            this.changed = false, this._updatedLayers = {}, this._removedLayers = {}, this.updatedSourceCaches = {}, this.updatedPaintProps.clear(), this.changedImages.clear();
          }
        }
        const ya = { Int8: Int8Array, Uint8: Uint8Array, Int16: Int16Array, Uint16: Uint16Array, Int32: Int32Array, Uint32: Uint32Array, Float32: Float32Array };
        class xa {
          constructor(e2, t2) {
            this._structArray = e2, this._pos1 = t2 * this.size, this._pos2 = this._pos1 / 2, this._pos4 = this._pos1 / 4, this._pos8 = this._pos1 / 8;
          }
        }
        class va {
          constructor() {
            this.isTransferred = false, this.capacity = -1, this.resize(0);
          }
          static serialize(e2, t2) {
            return e2._trim(), t2 && (e2.isTransferred = true, t2.add(e2.arrayBuffer)), { length: e2.length, arrayBuffer: e2.arrayBuffer };
          }
          static deserialize(e2) {
            const t2 = Object.create(this.prototype);
            return t2.arrayBuffer = e2.arrayBuffer, t2.length = e2.length, t2.capacity = e2.arrayBuffer.byteLength / t2.bytesPerElement, t2._refreshViews(), t2;
          }
          _trim() {
            this.length !== this.capacity && (this.capacity = this.length, this.arrayBuffer = this.arrayBuffer.slice(0, this.length * this.bytesPerElement), this._refreshViews());
          }
          clear() {
            this.length = 0;
          }
          resize(e2) {
            this.reserve(e2), this.length = e2;
          }
          reserve(e2) {
            if (e2 > this.capacity) {
              this.capacity = Math.max(e2, Math.floor(5 * this.capacity), 128), this.arrayBuffer = new ArrayBuffer(this.capacity * this.bytesPerElement);
              const t2 = this.uint8;
              this._refreshViews(), t2 && this.uint8.set(t2);
            }
          }
          _refreshViews() {
            throw new Error("_refreshViews() must be implemented by each concrete StructArray layout");
          }
          destroy() {
            this.int8 = this.uint8 = this.int16 = this.uint16 = this.int32 = this.uint32 = this.float32 = null, this.arrayBuffer = null;
          }
        }
        function ba(e2, t2 = 1) {
          let i2 = 0, r2 = 0;
          return { members: e2.map((e3) => {
            const n2 = ya[e3.type].BYTES_PER_ELEMENT, o2 = i2 = wa(i2, Math.max(t2, n2)), s2 = e3.components || 1;
            return r2 = Math.max(r2, n2), i2 += n2 * s2, { name: e3.name, type: e3.type, components: s2, offset: o2 };
          }), size: wa(i2, Math.max(r2, t2)), alignment: t2 };
        }
        function wa(e2, t2) {
          return Math.ceil(e2 / t2) * t2;
        }
        class Ta extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2) {
            const i2 = this.length;
            return this.resize(i2 + 1), this.emplace(i2, e2, t2);
          }
          emplace(e2, t2, i2) {
            const r2 = 2 * e2;
            return this.int16[r2 + 0] = t2, this.int16[r2 + 1] = i2, e2;
          }
        }
        Ta.prototype.bytesPerElement = 4, Is(Ta, "StructArrayLayout2i4");
        class Ea extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2) {
            const r2 = this.length;
            return this.resize(r2 + 1), this.emplace(r2, e2, t2, i2);
          }
          emplace(e2, t2, i2, r2) {
            const n2 = 3 * e2;
            return this.int16[n2 + 0] = t2, this.int16[n2 + 1] = i2, this.int16[n2 + 2] = r2, e2;
          }
        }
        Ea.prototype.bytesPerElement = 6, Is(Ea, "StructArrayLayout3i6");
        class Ma extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2) {
            const n2 = this.length;
            return this.resize(n2 + 1), this.emplace(n2, e2, t2, i2, r2);
          }
          emplace(e2, t2, i2, r2, n2) {
            const o2 = 4 * e2;
            return this.int16[o2 + 0] = t2, this.int16[o2 + 1] = i2, this.int16[o2 + 2] = r2, this.int16[o2 + 3] = n2, e2;
          }
        }
        Ma.prototype.bytesPerElement = 8, Is(Ma, "StructArrayLayout4i8");
        class Aa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2) {
            const o2 = this.length;
            return this.resize(o2 + 1), this.emplace(o2, e2, t2, i2, r2, n2);
          }
          emplace(e2, t2, i2, r2, n2, o2) {
            const s2 = 5 * e2;
            return this.int16[s2 + 0] = t2, this.int16[s2 + 1] = i2, this.int16[s2 + 2] = r2, this.int16[s2 + 3] = n2, this.int16[s2 + 4] = o2, e2;
          }
        }
        Aa.prototype.bytesPerElement = 10, Is(Aa, "StructArrayLayout5i10");
        class Sa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.length;
            return this.resize(a2 + 1), this.emplace(a2, e2, t2, i2, r2, n2, o2, s2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = 6 * e2, c2 = 12 * e2, h2 = 3 * e2;
            return this.int16[l2 + 0] = t2, this.int16[l2 + 1] = i2, this.uint8[c2 + 4] = r2, this.uint8[c2 + 5] = n2, this.uint8[c2 + 6] = o2, this.uint8[c2 + 7] = s2, this.float32[h2 + 2] = a2, e2;
          }
        }
        Sa.prototype.bytesPerElement = 12, Is(Sa, "StructArrayLayout2i4ub1f12");
        class Ia extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2) {
            const n2 = this.length;
            return this.resize(n2 + 1), this.emplace(n2, e2, t2, i2, r2);
          }
          emplace(e2, t2, i2, r2, n2) {
            const o2 = 4 * e2;
            return this.float32[o2 + 0] = t2, this.float32[o2 + 1] = i2, this.float32[o2 + 2] = r2, this.float32[o2 + 3] = n2, e2;
          }
        }
        Ia.prototype.bytesPerElement = 16, Is(Ia, "StructArrayLayout4f16");
        class Ca extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2) {
            const o2 = this.length;
            return this.resize(o2 + 1), this.emplace(o2, e2, t2, i2, r2, n2);
          }
          emplace(e2, t2, i2, r2, n2, o2) {
            const s2 = 6 * e2, a2 = 3 * e2;
            return this.uint16[s2 + 0] = t2, this.uint16[s2 + 1] = i2, this.uint16[s2 + 2] = r2, this.uint16[s2 + 3] = n2, this.float32[a2 + 2] = o2, e2;
          }
        }
        Ca.prototype.bytesPerElement = 12, Is(Ca, "StructArrayLayout4ui1f12");
        class za extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2) {
            const n2 = this.length;
            return this.resize(n2 + 1), this.emplace(n2, e2, t2, i2, r2);
          }
          emplace(e2, t2, i2, r2, n2) {
            const o2 = 4 * e2;
            return this.uint16[o2 + 0] = t2, this.uint16[o2 + 1] = i2, this.uint16[o2 + 2] = r2, this.uint16[o2 + 3] = n2, e2;
          }
        }
        za.prototype.bytesPerElement = 8, Is(za, "StructArrayLayout4ui8");
        class Da extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2) {
            const s2 = this.length;
            return this.resize(s2 + 1), this.emplace(s2, e2, t2, i2, r2, n2, o2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = 6 * e2;
            return this.int16[a2 + 0] = t2, this.int16[a2 + 1] = i2, this.int16[a2 + 2] = r2, this.int16[a2 + 3] = n2, this.int16[a2 + 4] = o2, this.int16[a2 + 5] = s2, e2;
          }
        }
        Da.prototype.bytesPerElement = 12, Is(Da, "StructArrayLayout6i12");
        class Pa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2) {
            const d2 = this.length;
            return this.resize(d2 + 1), this.emplace(d2, e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2) {
            const p2 = 12 * e2;
            return this.int16[p2 + 0] = t2, this.int16[p2 + 1] = i2, this.int16[p2 + 2] = r2, this.int16[p2 + 3] = n2, this.uint16[p2 + 4] = o2, this.uint16[p2 + 5] = s2, this.uint16[p2 + 6] = a2, this.uint16[p2 + 7] = l2, this.int16[p2 + 8] = c2, this.int16[p2 + 9] = h2, this.int16[p2 + 10] = u2, this.int16[p2 + 11] = d2, e2;
          }
        }
        Pa.prototype.bytesPerElement = 24, Is(Pa, "StructArrayLayout4i4ui4i24");
        class Ra extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2) {
            const s2 = this.length;
            return this.resize(s2 + 1), this.emplace(s2, e2, t2, i2, r2, n2, o2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = 10 * e2, l2 = 5 * e2;
            return this.int16[a2 + 0] = t2, this.int16[a2 + 1] = i2, this.int16[a2 + 2] = r2, this.float32[l2 + 2] = n2, this.float32[l2 + 3] = o2, this.float32[l2 + 4] = s2, e2;
          }
        }
        Ra.prototype.bytesPerElement = 20, Is(Ra, "StructArrayLayout3i3f20");
        class La extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint32 = new Uint32Array(this.arrayBuffer);
          }
          emplaceBack(e2) {
            const t2 = this.length;
            return this.resize(t2 + 1), this.emplace(t2, e2);
          }
          emplace(e2, t2) {
            return this.uint32[1 * e2 + 0] = t2, e2;
          }
        }
        La.prototype.bytesPerElement = 4, Is(La, "StructArrayLayout1ul4");
        class ka extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2) {
            const i2 = this.length;
            return this.resize(i2 + 1), this.emplace(i2, e2, t2);
          }
          emplace(e2, t2, i2) {
            const r2 = 2 * e2;
            return this.uint16[r2 + 0] = t2, this.uint16[r2 + 1] = i2, e2;
          }
        }
        ka.prototype.bytesPerElement = 4, Is(ka, "StructArrayLayout2ui4");
        class Oa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer), this.uint32 = new Uint32Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2) {
            const p2 = this.length;
            return this.resize(p2 + 1), this.emplace(p2, e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2) {
            const f2 = 20 * e2, m2 = 10 * e2;
            return this.int16[f2 + 0] = t2, this.int16[f2 + 1] = i2, this.int16[f2 + 2] = r2, this.int16[f2 + 3] = n2, this.int16[f2 + 4] = o2, this.float32[m2 + 3] = s2, this.float32[m2 + 4] = a2, this.float32[m2 + 5] = l2, this.float32[m2 + 6] = c2, this.int16[f2 + 14] = h2, this.uint32[m2 + 8] = u2, this.uint16[f2 + 18] = d2, this.uint16[f2 + 19] = p2, e2;
          }
        }
        Oa.prototype.bytesPerElement = 40, Is(Oa, "StructArrayLayout5i4f1i1ul2ui40");
        class Ba extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.length;
            return this.resize(a2 + 1), this.emplace(a2, e2, t2, i2, r2, n2, o2, s2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = 8 * e2;
            return this.int16[l2 + 0] = t2, this.int16[l2 + 1] = i2, this.int16[l2 + 2] = r2, this.int16[l2 + 4] = n2, this.int16[l2 + 5] = o2, this.int16[l2 + 6] = s2, this.int16[l2 + 7] = a2, e2;
          }
        }
        Ba.prototype.bytesPerElement = 16, Is(Ba, "StructArrayLayout3i2i2i16");
        class Fa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2) {
            const o2 = this.length;
            return this.resize(o2 + 1), this.emplace(o2, e2, t2, i2, r2, n2);
          }
          emplace(e2, t2, i2, r2, n2, o2) {
            const s2 = 4 * e2, a2 = 8 * e2;
            return this.float32[s2 + 0] = t2, this.float32[s2 + 1] = i2, this.float32[s2 + 2] = r2, this.int16[a2 + 6] = n2, this.int16[a2 + 7] = o2, e2;
          }
        }
        Fa.prototype.bytesPerElement = 16, Is(Fa, "StructArrayLayout2f1f2i16");
        class Na extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2) {
            const n2 = this.length;
            return this.resize(n2 + 1), this.emplace(n2, e2, t2, i2, r2);
          }
          emplace(e2, t2, i2, r2, n2) {
            const o2 = 12 * e2, s2 = 3 * e2;
            return this.uint8[o2 + 0] = t2, this.uint8[o2 + 1] = i2, this.float32[s2 + 1] = r2, this.float32[s2 + 2] = n2, e2;
          }
        }
        Na.prototype.bytesPerElement = 12, Is(Na, "StructArrayLayout2ub2f12");
        class Ua extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2) {
            const r2 = this.length;
            return this.resize(r2 + 1), this.emplace(r2, e2, t2, i2);
          }
          emplace(e2, t2, i2, r2) {
            const n2 = 3 * e2;
            return this.float32[n2 + 0] = t2, this.float32[n2 + 1] = i2, this.float32[n2 + 2] = r2, e2;
          }
        }
        Ua.prototype.bytesPerElement = 12, Is(Ua, "StructArrayLayout3f12");
        class Va extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2) {
            const r2 = this.length;
            return this.resize(r2 + 1), this.emplace(r2, e2, t2, i2);
          }
          emplace(e2, t2, i2, r2) {
            const n2 = 3 * e2;
            return this.uint16[n2 + 0] = t2, this.uint16[n2 + 1] = i2, this.uint16[n2 + 2] = r2, e2;
          }
        }
        Va.prototype.bytesPerElement = 6, Is(Va, "StructArrayLayout3ui6");
        class ja extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer), this.uint32 = new Uint32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2) {
            const b2 = this.length;
            return this.resize(b2 + 1), this.emplace(b2, e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2, b2) {
            const w2 = 30 * e2, T2 = 15 * e2, E2 = 60 * e2;
            return this.int16[w2 + 0] = t2, this.int16[w2 + 1] = i2, this.int16[w2 + 2] = r2, this.float32[T2 + 2] = n2, this.float32[T2 + 3] = o2, this.uint16[w2 + 8] = s2, this.uint16[w2 + 9] = a2, this.uint32[T2 + 5] = l2, this.uint32[T2 + 6] = c2, this.uint32[T2 + 7] = h2, this.uint16[w2 + 16] = u2, this.uint16[w2 + 17] = d2, this.uint16[w2 + 18] = p2, this.float32[T2 + 10] = f2, this.float32[T2 + 11] = m2, this.uint8[E2 + 48] = _2, this.uint8[E2 + 49] = g2, this.uint8[E2 + 50] = y2, this.uint32[T2 + 13] = x2, this.int16[w2 + 28] = v2, this.uint8[E2 + 58] = b2, e2;
          }
        }
        ja.prototype.bytesPerElement = 60, Is(ja, "StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");
        class Ga extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer), this.int16 = new Int16Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer), this.uint32 = new Uint32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2, b2, w2, T2, E2, M2, A2, S2, I2, C2, z2, D2) {
            const P2 = this.length;
            return this.resize(P2 + 1), this.emplace(P2, e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2, b2, w2, T2, E2, M2, A2, S2, I2, C2, z2, D2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2, b2, w2, T2, E2, M2, A2, S2, I2, C2, z2, D2, P2) {
            const R2 = 20 * e2, L2 = 40 * e2, k2 = 80 * e2;
            return this.float32[R2 + 0] = t2, this.float32[R2 + 1] = i2, this.int16[L2 + 4] = r2, this.int16[L2 + 5] = n2, this.int16[L2 + 6] = o2, this.int16[L2 + 7] = s2, this.int16[L2 + 8] = a2, this.int16[L2 + 9] = l2, this.int16[L2 + 10] = c2, this.int16[L2 + 11] = h2, this.int16[L2 + 12] = u2, this.uint16[L2 + 13] = d2, this.uint16[L2 + 14] = p2, this.uint16[L2 + 15] = f2, this.uint16[L2 + 16] = m2, this.uint16[L2 + 17] = _2, this.uint16[L2 + 18] = g2, this.uint16[L2 + 19] = y2, this.uint16[L2 + 20] = x2, this.uint16[L2 + 21] = v2, this.uint16[L2 + 22] = b2, this.uint16[L2 + 23] = w2, this.uint16[L2 + 24] = T2, this.uint16[L2 + 25] = E2, this.uint16[L2 + 26] = M2, this.uint16[L2 + 27] = A2, this.uint32[R2 + 14] = S2, this.float32[R2 + 15] = I2, this.float32[R2 + 16] = C2, this.float32[R2 + 17] = z2, this.float32[R2 + 18] = D2, this.uint8[k2 + 76] = P2, e2;
          }
        }
        Ga.prototype.bytesPerElement = 80, Is(Ga, "StructArrayLayout2f9i15ui1ul4f1ub80");
        class qa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2) {
            const t2 = this.length;
            return this.resize(t2 + 1), this.emplace(t2, e2);
          }
          emplace(e2, t2) {
            return this.float32[1 * e2 + 0] = t2, e2;
          }
        }
        qa.prototype.bytesPerElement = 4, Is(qa, "StructArrayLayout1f4");
        class Za extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2) {
            const o2 = this.length;
            return this.resize(o2 + 1), this.emplace(o2, e2, t2, i2, r2, n2);
          }
          emplace(e2, t2, i2, r2, n2, o2) {
            const s2 = 5 * e2;
            return this.float32[s2 + 0] = t2, this.float32[s2 + 1] = i2, this.float32[s2 + 2] = r2, this.float32[s2 + 3] = n2, this.float32[s2 + 4] = o2, e2;
          }
        }
        Za.prototype.bytesPerElement = 20, Is(Za, "StructArrayLayout5f20");
        class $a extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.length;
            return this.resize(a2 + 1), this.emplace(a2, e2, t2, i2, r2, n2, o2, s2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = 7 * e2;
            return this.float32[l2 + 0] = t2, this.float32[l2 + 1] = i2, this.float32[l2 + 2] = r2, this.float32[l2 + 3] = n2, this.float32[l2 + 4] = o2, this.float32[l2 + 5] = s2, this.float32[l2 + 6] = a2, e2;
          }
        }
        $a.prototype.bytesPerElement = 28, Is($a, "StructArrayLayout7f28");
        class Ha extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint32 = new Uint32Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2) {
            const n2 = this.length;
            return this.resize(n2 + 1), this.emplace(n2, e2, t2, i2, r2);
          }
          emplace(e2, t2, i2, r2, n2) {
            const o2 = 6 * e2;
            return this.uint32[3 * e2 + 0] = t2, this.uint16[o2 + 2] = i2, this.uint16[o2 + 3] = r2, this.uint16[o2 + 4] = n2, e2;
          }
        }
        Ha.prototype.bytesPerElement = 12, Is(Ha, "StructArrayLayout1ul3ui12");
        class Wa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer);
          }
          emplaceBack(e2) {
            const t2 = this.length;
            return this.resize(t2 + 1), this.emplace(t2, e2);
          }
          emplace(e2, t2) {
            return this.uint16[1 * e2 + 0] = t2, e2;
          }
        }
        Wa.prototype.bytesPerElement = 2, Is(Wa, "StructArrayLayout1ui2");
        class Xa extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2) {
            const i2 = this.length;
            return this.resize(i2 + 1), this.emplace(i2, e2, t2);
          }
          emplace(e2, t2, i2) {
            const r2 = 2 * e2;
            return this.float32[r2 + 0] = t2, this.float32[r2 + 1] = i2, e2;
          }
        }
        Xa.prototype.bytesPerElement = 8, Is(Xa, "StructArrayLayout2f8");
        class Ya extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2) {
            const _2 = this.length;
            return this.resize(_2 + 1), this.emplace(_2, e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2) {
            const g2 = 16 * e2;
            return this.float32[g2 + 0] = t2, this.float32[g2 + 1] = i2, this.float32[g2 + 2] = r2, this.float32[g2 + 3] = n2, this.float32[g2 + 4] = o2, this.float32[g2 + 5] = s2, this.float32[g2 + 6] = a2, this.float32[g2 + 7] = l2, this.float32[g2 + 8] = c2, this.float32[g2 + 9] = h2, this.float32[g2 + 10] = u2, this.float32[g2 + 11] = d2, this.float32[g2 + 12] = p2, this.float32[g2 + 13] = f2, this.float32[g2 + 14] = m2, this.float32[g2 + 15] = _2, e2;
          }
        }
        Ya.prototype.bytesPerElement = 64, Is(Ya, "StructArrayLayout16f64");
        class Ka extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer), this.uint16 = new Uint16Array(this.arrayBuffer), this.float32 = new Float32Array(this.arrayBuffer);
          }
          emplaceBack(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.length;
            return this.resize(a2 + 1), this.emplace(a2, e2, t2, i2, r2, n2, o2, s2);
          }
          emplace(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = 10 * e2, c2 = 5 * e2;
            return this.uint16[l2 + 0] = t2, this.uint16[l2 + 1] = i2, this.uint16[l2 + 2] = r2, this.uint16[l2 + 3] = n2, this.float32[c2 + 2] = o2, this.float32[c2 + 3] = s2, this.float32[c2 + 4] = a2, e2;
          }
        }
        Ka.prototype.bytesPerElement = 20, Is(Ka, "StructArrayLayout4ui3f20");
        class Ja extends va {
          _refreshViews() {
            this.uint8 = new Uint8Array(this.arrayBuffer);
          }
          emplaceBack(e2) {
            const t2 = this.length;
            return this.resize(t2 + 1), this.emplace(t2, e2);
          }
          emplace(e2, t2) {
            return this.uint8[1 * e2 + 0] = t2, e2;
          }
        }
        Ja.prototype.bytesPerElement = 1, Is(Ja, "StructArrayLayout1ub1");
        class Qa extends xa {
          get projectedAnchorX() {
            return this._structArray.int16[this._pos2 + 0];
          }
          get projectedAnchorY() {
            return this._structArray.int16[this._pos2 + 1];
          }
          get projectedAnchorZ() {
            return this._structArray.int16[this._pos2 + 2];
          }
          get tileAnchorX() {
            return this._structArray.int16[this._pos2 + 3];
          }
          get tileAnchorY() {
            return this._structArray.int16[this._pos2 + 4];
          }
          get x1() {
            return this._structArray.float32[this._pos4 + 3];
          }
          get y1() {
            return this._structArray.float32[this._pos4 + 4];
          }
          get x2() {
            return this._structArray.float32[this._pos4 + 5];
          }
          get y2() {
            return this._structArray.float32[this._pos4 + 6];
          }
          get padding() {
            return this._structArray.int16[this._pos2 + 14];
          }
          get featureIndex() {
            return this._structArray.uint32[this._pos4 + 8];
          }
          get sourceLayerIndex() {
            return this._structArray.uint16[this._pos2 + 18];
          }
          get bucketIndex() {
            return this._structArray.uint16[this._pos2 + 19];
          }
        }
        Qa.prototype.size = 40;
        class el extends Oa {
          get(e2) {
            return new Qa(this, e2);
          }
        }
        Is(el, "CollisionBoxArray");
        class tl extends xa {
          get projectedAnchorX() {
            return this._structArray.int16[this._pos2 + 0];
          }
          get projectedAnchorY() {
            return this._structArray.int16[this._pos2 + 1];
          }
          get projectedAnchorZ() {
            return this._structArray.int16[this._pos2 + 2];
          }
          get tileAnchorX() {
            return this._structArray.float32[this._pos4 + 2];
          }
          get tileAnchorY() {
            return this._structArray.float32[this._pos4 + 3];
          }
          get glyphStartIndex() {
            return this._structArray.uint16[this._pos2 + 8];
          }
          get numGlyphs() {
            return this._structArray.uint16[this._pos2 + 9];
          }
          get vertexStartIndex() {
            return this._structArray.uint32[this._pos4 + 5];
          }
          get lineStartIndex() {
            return this._structArray.uint32[this._pos4 + 6];
          }
          get lineLength() {
            return this._structArray.uint32[this._pos4 + 7];
          }
          get segment() {
            return this._structArray.uint16[this._pos2 + 16];
          }
          get lowerSize() {
            return this._structArray.uint16[this._pos2 + 17];
          }
          get upperSize() {
            return this._structArray.uint16[this._pos2 + 18];
          }
          get lineOffsetX() {
            return this._structArray.float32[this._pos4 + 10];
          }
          get lineOffsetY() {
            return this._structArray.float32[this._pos4 + 11];
          }
          get writingMode() {
            return this._structArray.uint8[this._pos1 + 48];
          }
          get placedOrientation() {
            return this._structArray.uint8[this._pos1 + 49];
          }
          set placedOrientation(e2) {
            this._structArray.uint8[this._pos1 + 49] = e2;
          }
          get hidden() {
            return this._structArray.uint8[this._pos1 + 50];
          }
          set hidden(e2) {
            this._structArray.uint8[this._pos1 + 50] = e2;
          }
          get crossTileID() {
            return this._structArray.uint32[this._pos4 + 13];
          }
          set crossTileID(e2) {
            this._structArray.uint32[this._pos4 + 13] = e2;
          }
          get associatedIconIndex() {
            return this._structArray.int16[this._pos2 + 28];
          }
          get flipState() {
            return this._structArray.uint8[this._pos1 + 58];
          }
          set flipState(e2) {
            this._structArray.uint8[this._pos1 + 58] = e2;
          }
        }
        tl.prototype.size = 60;
        class il extends ja {
          get(e2) {
            return new tl(this, e2);
          }
        }
        Is(il, "PlacedSymbolArray");
        class rl extends xa {
          get tileAnchorX() {
            return this._structArray.float32[this._pos4 + 0];
          }
          get tileAnchorY() {
            return this._structArray.float32[this._pos4 + 1];
          }
          get projectedAnchorX() {
            return this._structArray.int16[this._pos2 + 4];
          }
          get projectedAnchorY() {
            return this._structArray.int16[this._pos2 + 5];
          }
          get projectedAnchorZ() {
            return this._structArray.int16[this._pos2 + 6];
          }
          get rightJustifiedTextSymbolIndex() {
            return this._structArray.int16[this._pos2 + 7];
          }
          get centerJustifiedTextSymbolIndex() {
            return this._structArray.int16[this._pos2 + 8];
          }
          get leftJustifiedTextSymbolIndex() {
            return this._structArray.int16[this._pos2 + 9];
          }
          get verticalPlacedTextSymbolIndex() {
            return this._structArray.int16[this._pos2 + 10];
          }
          get placedIconSymbolIndex() {
            return this._structArray.int16[this._pos2 + 11];
          }
          get verticalPlacedIconSymbolIndex() {
            return this._structArray.int16[this._pos2 + 12];
          }
          get key() {
            return this._structArray.uint16[this._pos2 + 13];
          }
          get textBoxStartIndex() {
            return this._structArray.uint16[this._pos2 + 14];
          }
          get textBoxEndIndex() {
            return this._structArray.uint16[this._pos2 + 15];
          }
          get verticalTextBoxStartIndex() {
            return this._structArray.uint16[this._pos2 + 16];
          }
          get verticalTextBoxEndIndex() {
            return this._structArray.uint16[this._pos2 + 17];
          }
          get iconBoxStartIndex() {
            return this._structArray.uint16[this._pos2 + 18];
          }
          get iconBoxEndIndex() {
            return this._structArray.uint16[this._pos2 + 19];
          }
          get verticalIconBoxStartIndex() {
            return this._structArray.uint16[this._pos2 + 20];
          }
          get verticalIconBoxEndIndex() {
            return this._structArray.uint16[this._pos2 + 21];
          }
          get featureIndex() {
            return this._structArray.uint16[this._pos2 + 22];
          }
          get numHorizontalGlyphVertices() {
            return this._structArray.uint16[this._pos2 + 23];
          }
          get numVerticalGlyphVertices() {
            return this._structArray.uint16[this._pos2 + 24];
          }
          get numIconVertices() {
            return this._structArray.uint16[this._pos2 + 25];
          }
          get numVerticalIconVertices() {
            return this._structArray.uint16[this._pos2 + 26];
          }
          get useRuntimeCollisionCircles() {
            return this._structArray.uint16[this._pos2 + 27];
          }
          get crossTileID() {
            return this._structArray.uint32[this._pos4 + 14];
          }
          set crossTileID(e2) {
            this._structArray.uint32[this._pos4 + 14] = e2;
          }
          get textOffset0() {
            return this._structArray.float32[this._pos4 + 15];
          }
          get textOffset1() {
            return this._structArray.float32[this._pos4 + 16];
          }
          get collisionCircleDiameter() {
            return this._structArray.float32[this._pos4 + 17];
          }
          get zOffset() {
            return this._structArray.float32[this._pos4 + 18];
          }
          set zOffset(e2) {
            this._structArray.float32[this._pos4 + 18] = e2;
          }
          get hasIconTextFit() {
            return this._structArray.uint8[this._pos1 + 76];
          }
        }
        rl.prototype.size = 80;
        class nl extends Ga {
          get(e2) {
            return new rl(this, e2);
          }
        }
        Is(nl, "SymbolInstanceArray");
        class ol extends qa {
          getoffsetX(e2) {
            return this.float32[1 * e2 + 0];
          }
        }
        Is(ol, "GlyphOffsetArray");
        class sl extends Ta {
          getx(e2) {
            return this.int16[2 * e2 + 0];
          }
          gety(e2) {
            return this.int16[2 * e2 + 1];
          }
        }
        Is(sl, "SymbolLineVertexArray");
        class al extends xa {
          get featureIndex() {
            return this._structArray.uint32[this._pos4 + 0];
          }
          get sourceLayerIndex() {
            return this._structArray.uint16[this._pos2 + 2];
          }
          get bucketIndex() {
            return this._structArray.uint16[this._pos2 + 3];
          }
          get layoutVertexArrayOffset() {
            return this._structArray.uint16[this._pos2 + 4];
          }
        }
        al.prototype.size = 12;
        class ll extends Ha {
          get(e2) {
            return new al(this, e2);
          }
        }
        Is(ll, "FeatureIndexArray");
        class cl extends ka {
          geta_centroid_pos0(e2) {
            return this.uint16[2 * e2 + 0];
          }
          geta_centroid_pos1(e2) {
            return this.uint16[2 * e2 + 1];
          }
        }
        Is(cl, "FillExtrusionCentroidArray");
        const hl = ba([{ name: "a_pos", components: 2, type: "Int16" }], 4), ul = ba([{ name: "a_pos_3", components: 3, type: "Int16" }, { name: "a_pos_normal_3", components: 3, type: "Int16" }]);
        class dl {
          constructor(e2 = []) {
            this.segments = e2;
          }
          _prepareSegment(e2, t2, i2, r2) {
            let n2 = this.segments[this.segments.length - 1];
            return e2 > dl.MAX_VERTEX_ARRAY_LENGTH && W(`Max vertices per segment is ${dl.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e2}`), (!n2 || n2.vertexLength + e2 > dl.MAX_VERTEX_ARRAY_LENGTH || n2.sortKey !== r2) && (n2 = { vertexOffset: t2, primitiveOffset: i2, vertexLength: 0, primitiveLength: 0 }, void 0 !== r2 && (n2.sortKey = r2), this.segments.push(n2)), n2;
          }
          prepareSegment(e2, t2, i2, r2) {
            return this._prepareSegment(e2, t2.length, i2.length, r2);
          }
          get() {
            return this.segments;
          }
          destroy() {
            for (const e2 of this.segments)
              for (const t2 in e2.vaos)
                e2.vaos[t2].destroy();
          }
          static simpleSegment(e2, t2, i2, r2) {
            return new dl([{ vertexOffset: e2, primitiveOffset: t2, vertexLength: i2, primitiveLength: r2, vaos: {}, sortKey: 0 }]);
          }
        }
        function pl(e2, t2) {
          return 256 * (e2 = z(Math.floor(e2), 0, 255)) + z(Math.floor(t2), 0, 255);
        }
        dl.MAX_VERTEX_ARRAY_LENGTH = Math.pow(2, 16) - 1, Is(dl, "SegmentVector");
        const fl = ba([{ name: "a_pattern", components: 4, type: "Uint16" }, { name: "a_pixel_ratio", components: 1, type: "Float32" }]), ml = ba([{ name: "a_dash", components: 4, type: "Uint16" }]);
        var _l = { exports: {} }, gl = { exports: {} };
        !function(e2) {
          e2.exports = function(e3, t2) {
            var i2, r2, n2, o2, s2, a2, l2, c2;
            for (r2 = e3.length - (i2 = 3 & e3.length), n2 = t2, s2 = 3432918353, a2 = 461845907, c2 = 0; c2 < r2; )
              l2 = 255 & e3.charCodeAt(c2) | (255 & e3.charCodeAt(++c2)) << 8 | (255 & e3.charCodeAt(++c2)) << 16 | (255 & e3.charCodeAt(++c2)) << 24, ++c2, n2 = 27492 + (65535 & (o2 = 5 * (65535 & (n2 = (n2 ^= l2 = (65535 & (l2 = (l2 = (65535 & l2) * s2 + (((l2 >>> 16) * s2 & 65535) << 16) & 4294967295) << 15 | l2 >>> 17)) * a2 + (((l2 >>> 16) * a2 & 65535) << 16) & 4294967295) << 13 | n2 >>> 19)) + ((5 * (n2 >>> 16) & 65535) << 16) & 4294967295)) + ((58964 + (o2 >>> 16) & 65535) << 16);
            switch (l2 = 0, i2) {
              case 3:
                l2 ^= (255 & e3.charCodeAt(c2 + 2)) << 16;
              case 2:
                l2 ^= (255 & e3.charCodeAt(c2 + 1)) << 8;
              case 1:
                n2 ^= l2 = (65535 & (l2 = (l2 = (65535 & (l2 ^= 255 & e3.charCodeAt(c2))) * s2 + (((l2 >>> 16) * s2 & 65535) << 16) & 4294967295) << 15 | l2 >>> 17)) * a2 + (((l2 >>> 16) * a2 & 65535) << 16) & 4294967295;
            }
            return n2 ^= e3.length, n2 = 2246822507 * (65535 & (n2 ^= n2 >>> 16)) + ((2246822507 * (n2 >>> 16) & 65535) << 16) & 4294967295, n2 = 3266489909 * (65535 & (n2 ^= n2 >>> 13)) + ((3266489909 * (n2 >>> 16) & 65535) << 16) & 4294967295, (n2 ^= n2 >>> 16) >>> 0;
          };
        }(gl);
        var yl = gl.exports, xl = { exports: {} };
        !function(e2) {
          e2.exports = function(e3, t2) {
            for (var i2, r2 = e3.length, n2 = t2 ^ r2, o2 = 0; r2 >= 4; )
              i2 = 1540483477 * (65535 & (i2 = 255 & e3.charCodeAt(o2) | (255 & e3.charCodeAt(++o2)) << 8 | (255 & e3.charCodeAt(++o2)) << 16 | (255 & e3.charCodeAt(++o2)) << 24)) + ((1540483477 * (i2 >>> 16) & 65535) << 16), n2 = 1540483477 * (65535 & n2) + ((1540483477 * (n2 >>> 16) & 65535) << 16) ^ (i2 = 1540483477 * (65535 & (i2 ^= i2 >>> 24)) + ((1540483477 * (i2 >>> 16) & 65535) << 16)), r2 -= 4, ++o2;
            switch (r2) {
              case 3:
                n2 ^= (255 & e3.charCodeAt(o2 + 2)) << 16;
              case 2:
                n2 ^= (255 & e3.charCodeAt(o2 + 1)) << 8;
              case 1:
                n2 = 1540483477 * (65535 & (n2 ^= 255 & e3.charCodeAt(o2))) + ((1540483477 * (n2 >>> 16) & 65535) << 16);
            }
            return n2 = 1540483477 * (65535 & (n2 ^= n2 >>> 13)) + ((1540483477 * (n2 >>> 16) & 65535) << 16), (n2 ^= n2 >>> 15) >>> 0;
          };
        }(xl);
        var vl = yl, bl = xl.exports;
        _l.exports = vl, _l.exports.murmur3 = vl, _l.exports.murmur2 = bl;
        var wl = d(_l.exports);
        class Tl {
          constructor() {
            this.ids = [], this.uniqueIds = [], this.positions = [], this.indexed = false;
          }
          add(e2, t2, i2, r2) {
            this.ids.push(El(e2)), this.positions.push(t2, i2, r2);
          }
          eachPosition(e2, t2) {
            const i2 = El(e2);
            let r2 = 0, n2 = this.ids.length - 1;
            for (; r2 < n2; ) {
              const e3 = r2 + n2 >> 1;
              this.ids[e3] >= i2 ? n2 = e3 : r2 = e3 + 1;
            }
            for (; this.ids[r2] === i2; )
              t2(this.positions[3 * r2], this.positions[3 * r2 + 1], this.positions[3 * r2 + 2]), r2++;
          }
          static serialize(e2, t2) {
            const i2 = new Float64Array(e2.ids), r2 = new Uint32Array(e2.positions);
            return Ml(i2, r2, 0, i2.length - 1), t2 && (t2.add(i2.buffer), t2.add(r2.buffer)), { ids: i2, positions: r2 };
          }
          static deserialize(e2) {
            const t2 = new Tl();
            let i2;
            t2.ids = e2.ids, t2.positions = e2.positions;
            for (const e3 of t2.ids)
              e3 !== i2 && t2.uniqueIds.push(e3), i2 = e3;
            return t2.indexed = true, t2;
          }
        }
        function El(e2) {
          const t2 = +e2;
          return !isNaN(t2) && Number.MIN_SAFE_INTEGER <= t2 && t2 <= Number.MAX_SAFE_INTEGER ? t2 : wl(String(e2));
        }
        function Ml(e2, t2, i2, r2) {
          for (; i2 < r2; ) {
            const n2 = e2[i2 + r2 >> 1];
            let o2 = i2 - 1, s2 = r2 + 1;
            for (; ; ) {
              do {
                o2++;
              } while (e2[o2] < n2);
              do {
                s2--;
              } while (e2[s2] > n2);
              if (o2 >= s2)
                break;
              Al(e2, o2, s2), Al(t2, 3 * o2, 3 * s2), Al(t2, 3 * o2 + 1, 3 * s2 + 1), Al(t2, 3 * o2 + 2, 3 * s2 + 2);
            }
            s2 - i2 < r2 - s2 ? (Ml(e2, t2, i2, s2), i2 = s2 + 1) : (Ml(e2, t2, s2 + 1, r2), r2 = s2);
          }
        }
        function Al(e2, t2, i2) {
          const r2 = e2[t2];
          e2[t2] = e2[i2], e2[i2] = r2;
        }
        Is(Tl, "FeaturePositionMap");
        class Sl {
          constructor(e2) {
            this.gl = e2.gl, this.initialized = false;
          }
          fetchUniformLocation(e2, t2) {
            return this.location || this.initialized || (this.location = this.gl.getUniformLocation(e2, t2), this.initialized = true), !!this.location;
          }
        }
        class Il extends Sl {
          constructor(e2) {
            super(e2), this.current = 0;
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && this.current !== i2 && (this.current = i2, this.gl.uniform1i(this.location, i2));
          }
        }
        class Cl extends Sl {
          constructor(e2) {
            super(e2), this.current = 0;
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && this.current !== i2 && (this.current = i2, this.gl.uniform1f(this.location, i2));
          }
        }
        class zl extends Sl {
          constructor(e2) {
            super(e2), this.current = [0, 0];
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && (i2[0] === this.current[0] && i2[1] === this.current[1] || (this.current = i2, this.gl.uniform2f(this.location, i2[0], i2[1])));
          }
        }
        class Dl extends Sl {
          constructor(e2) {
            super(e2), this.current = [0, 0, 0];
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && (i2[0] === this.current[0] && i2[1] === this.current[1] && i2[2] === this.current[2] || (this.current = i2, this.gl.uniform3f(this.location, i2[0], i2[1], i2[2])));
          }
        }
        class Pl extends Sl {
          constructor(e2) {
            super(e2), this.current = [0, 0, 0, 0];
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && (i2[0] === this.current[0] && i2[1] === this.current[1] && i2[2] === this.current[2] && i2[3] === this.current[3] || (this.current = i2, this.gl.uniform4f(this.location, i2[0], i2[1], i2[2], i2[3])));
          }
        }
        class Rl extends Sl {
          constructor(e2) {
            super(e2), this.current = li.transparent;
          }
          set(e2, t2, i2) {
            this.fetchUniformLocation(e2, t2) && (i2.r === this.current.r && i2.g === this.current.g && i2.b === this.current.b && i2.a === this.current.a || (this.current = i2, this.gl.uniform4f(this.location, i2.r, i2.g, i2.b, i2.a)));
          }
        }
        const Ll = new Float32Array(16);
        class kl extends Sl {
          constructor(e2) {
            super(e2), this.current = Ll;
          }
          set(e2, t2, i2) {
            if (this.fetchUniformLocation(e2, t2)) {
              if (i2[12] !== this.current[12] || i2[0] !== this.current[0])
                return this.current = i2, void this.gl.uniformMatrix4fv(this.location, false, i2);
              for (let e3 = 1; e3 < 16; e3++)
                if (i2[e3] !== this.current[e3]) {
                  this.current = i2, this.gl.uniformMatrix4fv(this.location, false, i2);
                  break;
                }
            }
          }
        }
        const Ol = new Float32Array(9);
        class Bl extends Sl {
          constructor(e2) {
            super(e2), this.current = Ol;
          }
          set(e2, t2, i2) {
            if (this.fetchUniformLocation(e2, t2)) {
              for (let e3 = 0; e3 < 9; e3++)
                if (i2[e3] !== this.current[e3]) {
                  this.current = i2, this.gl.uniformMatrix3fv(this.location, false, i2);
                  break;
                }
            }
          }
        }
        const Fl = new Float32Array(4);
        class Nl extends Sl {
          constructor(e2) {
            super(e2), this.current = Fl;
          }
          set(e2, t2, i2) {
            if (this.fetchUniformLocation(e2, t2)) {
              for (let e3 = 0; e3 < 4; e3++)
                if (i2[e3] !== this.current[e3]) {
                  this.current = i2, this.gl.uniformMatrix2fv(this.location, false, i2);
                  break;
                }
            }
          }
        }
        function Ul(e2) {
          return [pl(255 * e2.r, 255 * e2.g), pl(255 * e2.b, 255 * e2.a)];
        }
        class Vl {
          constructor(e2, t2, i2) {
            this.value = e2, this.uniformNames = t2.map((e3) => `u_${e3}`), this.type = i2;
          }
          setUniform(e2, t2, i2, r2, n2) {
            t2.set(e2, n2, r2.constantOr(this.value));
          }
          getBinding(e2, t2) {
            return "color" === this.type ? new Rl(e2) : new Cl(e2);
          }
        }
        class jl {
          constructor(e2, t2) {
            this.uniformNames = t2.map((e3) => `u_${e3}`), this.pattern = null, this.pixelRatio = 1;
          }
          setConstantPatternPositions(e2) {
            this.pixelRatio = e2.pixelRatio || 1, this.pattern = e2.tl.concat(e2.br);
          }
          setUniform(e2, t2, i2, r2, n2) {
            const o2 = "u_pattern" === n2 || "u_dash" === n2 ? this.pattern : "u_pixel_ratio" === n2 ? this.pixelRatio : null;
            o2 && t2.set(e2, n2, o2);
          }
          getBinding(e2, t2) {
            return "u_pattern" === t2 || "u_dash" === t2 ? new Pl(e2) : new Cl(e2);
          }
        }
        class Gl {
          constructor(e2, t2, i2, r2) {
            this.expression = e2, this.type = i2, this.maxValue = 0, this.paintVertexAttributes = t2.map((e3) => ({ name: `a_${e3}`, type: "Float32", components: "color" === i2 ? 2 : 1, offset: 0 })), this.paintVertexArray = new r2();
          }
          populatePaintArray(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.paintVertexArray.length, l2 = this.expression.evaluate(new ea(0, { brightness: o2 }), t2, {}, n2, r2, s2);
            this.paintVertexArray.resize(e2), this._setPaintValue(a2, e2, l2);
          }
          updatePaintArray(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.expression.evaluate({ zoom: 0, brightness: s2 }, i2, r2, void 0, n2);
            this._setPaintValue(e2, t2, a2);
          }
          _setPaintValue(e2, t2, i2) {
            if ("color" === this.type) {
              const r2 = Ul(i2);
              for (let i3 = e2; i3 < t2; i3++)
                this.paintVertexArray.emplace(i3, r2[0], r2[1]);
            } else {
              for (let r2 = e2; r2 < t2; r2++)
                this.paintVertexArray.emplace(r2, i2);
              this.maxValue = Math.max(this.maxValue, Math.abs(i2));
            }
          }
          upload(e2) {
            this.paintVertexArray && this.paintVertexArray.arrayBuffer && (this.paintVertexBuffer && this.paintVertexBuffer.buffer ? this.paintVertexBuffer.updateData(this.paintVertexArray) : this.paintVertexBuffer = e2.createVertexBuffer(this.paintVertexArray, this.paintVertexAttributes, this.expression.isStateDependent || !this.expression.isLightConstant));
          }
          destroy() {
            this.paintVertexBuffer && this.paintVertexBuffer.destroy();
          }
        }
        class ql {
          constructor(e2, t2, i2, r2, n2, o2) {
            this.expression = e2, this.uniformNames = t2.map((e3) => `u_${e3}_t`), this.type = i2, this.useIntegerZoom = r2, this.zoom = n2, this.maxValue = 0, this.paintVertexAttributes = t2.map((e3) => ({ name: `a_${e3}`, type: "Float32", components: "color" === i2 ? 4 : 2, offset: 0 })), this.paintVertexArray = new o2();
          }
          populatePaintArray(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.expression.evaluate(new ea(this.zoom, { brightness: o2 }), t2, {}, n2, r2, s2), l2 = this.expression.evaluate(new ea(this.zoom + 1, { brightness: o2 }), t2, {}, n2, r2, s2), c2 = this.paintVertexArray.length;
            this.paintVertexArray.resize(e2), this._setPaintValue(c2, e2, a2, l2);
          }
          updatePaintArray(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.expression.evaluate({ zoom: this.zoom, brightness: s2 }, i2, r2, void 0, n2), l2 = this.expression.evaluate({ zoom: this.zoom + 1, brightness: s2 }, i2, r2, void 0, n2);
            this._setPaintValue(e2, t2, a2, l2);
          }
          _setPaintValue(e2, t2, i2, r2) {
            if ("color" === this.type) {
              const n2 = Ul(i2), o2 = Ul(r2);
              for (let i3 = e2; i3 < t2; i3++)
                this.paintVertexArray.emplace(i3, n2[0], n2[1], o2[0], o2[1]);
            } else {
              for (let n2 = e2; n2 < t2; n2++)
                this.paintVertexArray.emplace(n2, i2, r2);
              this.maxValue = Math.max(this.maxValue, Math.abs(i2), Math.abs(r2));
            }
          }
          upload(e2) {
            this.paintVertexArray && this.paintVertexArray.arrayBuffer && (this.paintVertexBuffer && this.paintVertexBuffer.buffer ? this.paintVertexBuffer.updateData(this.paintVertexArray) : this.paintVertexBuffer = e2.createVertexBuffer(this.paintVertexArray, this.paintVertexAttributes, this.expression.isStateDependent || !this.expression.isLightConstant));
          }
          destroy() {
            this.paintVertexBuffer && this.paintVertexBuffer.destroy();
          }
          setUniform(e2, t2, i2, r2, n2) {
            const o2 = this.useIntegerZoom ? Math.floor(i2.zoom) : i2.zoom, s2 = z(this.expression.interpolationFactor(o2, this.zoom, this.zoom + 1), 0, 1);
            t2.set(e2, n2, s2);
          }
          getBinding(e2, t2) {
            return new Cl(e2);
          }
        }
        class Zl {
          constructor(e2, t2, i2, r2, n2) {
            this.expression = e2, this.layerId = n2, this.paintVertexAttributes = ("array" === i2 ? ml : fl).members;
            for (let e3 = 0; e3 < t2.length; ++e3)
              ;
            this.paintVertexArray = new r2();
          }
          populatePaintArray(e2, t2, i2) {
            const r2 = this.paintVertexArray.length;
            this.paintVertexArray.resize(e2), this._setPaintValues(r2, e2, t2.patterns && t2.patterns[this.layerId], i2);
          }
          updatePaintArray(e2, t2, i2, r2, n2, o2, s2) {
            this._setPaintValues(e2, t2, i2.patterns && i2.patterns[this.layerId], o2);
          }
          _setPaintValues(e2, t2, i2, r2) {
            if (!r2 || !i2)
              return;
            const n2 = r2[i2];
            if (!n2)
              return;
            const { tl: o2, br: s2, pixelRatio: a2 } = n2;
            for (let i3 = e2; i3 < t2; i3++)
              this.paintVertexArray.emplace(i3, o2[0], o2[1], s2[0], s2[1], a2);
          }
          upload(e2) {
            this.paintVertexArray && this.paintVertexArray.arrayBuffer && (this.paintVertexBuffer = e2.createVertexBuffer(this.paintVertexArray, this.paintVertexAttributes, this.expression.isStateDependent || !this.expression.isLightConstant));
          }
          destroy() {
            this.paintVertexBuffer && this.paintVertexBuffer.destroy();
          }
        }
        class $l {
          constructor(e2, t2, i2 = () => true) {
            this.binders = {}, this._buffers = [];
            const r2 = [];
            for (const n2 in e2.paint._values) {
              const o2 = e2.paint.get(n2);
              if (!i2(n2))
                continue;
              if (!(o2 instanceof aa && no(o2.property.specification)))
                continue;
              const s2 = Xl(n2, e2.type), a2 = o2.value, l2 = o2.property.specification.type, c2 = !!o2.property.useIntegerZoom, h2 = "line-dasharray" === n2 || n2.endsWith("pattern"), u2 = "line-dasharray" === n2 && "constant" !== e2.layout.get("line-cap").value.kind;
              if ("constant" !== a2.kind || u2)
                if ("source" === a2.kind || u2 || h2) {
                  const t3 = Jl(n2, l2, "source");
                  this.binders[n2] = h2 ? new Zl(a2, s2, l2, t3, e2.id) : new Gl(a2, s2, l2, t3), r2.push(`/a_${n2}`);
                } else {
                  const e3 = Jl(n2, l2, "composite");
                  this.binders[n2] = new ql(a2, s2, l2, c2, t2, e3), r2.push(`/z_${n2}`);
                }
              else
                this.binders[n2] = h2 ? new jl(a2.value, s2) : new Vl(a2.value, s2, l2), r2.push(`/u_${n2}`);
            }
            this.cacheKey = r2.sort().join("");
          }
          getMaxValue(e2) {
            const t2 = this.binders[e2];
            return t2 instanceof Gl || t2 instanceof ql ? t2.maxValue : 0;
          }
          populatePaintArrays(e2, t2, i2, r2, n2, o2, s2) {
            for (const a2 in this.binders) {
              const l2 = this.binders[a2];
              (l2 instanceof Gl || l2 instanceof ql || l2 instanceof Zl) && l2.populatePaintArray(e2, t2, i2, r2, n2, o2, s2);
            }
          }
          setConstantPatternPositions(e2) {
            for (const t2 in this.binders) {
              const i2 = this.binders[t2];
              i2 instanceof jl && i2.setConstantPatternPositions(e2);
            }
          }
          updatePaintArrays(e2, t2, i2, r2, n2, o2, s2, a2) {
            let l2 = false;
            const c2 = Object.keys(e2), h2 = 0 !== c2.length, u2 = h2 ? c2 : t2.uniqueIds;
            for (const c3 in this.binders) {
              const d2 = this.binders[c3];
              if ((d2 instanceof Gl || d2 instanceof ql || d2 instanceof Zl) && (true === d2.expression.isStateDependent || false === d2.expression.isLightConstant)) {
                const p2 = n2.paint.get(c3);
                d2.expression = p2.value;
                for (const i3 of u2) {
                  const n3 = e2[i3.toString()];
                  t2.eachPosition(i3, (e3, t3, i4) => {
                    const l3 = r2.feature(e3);
                    d2.updatePaintArray(t3, i4, l3, n3, o2, s2, a2);
                  });
                }
                if (!h2)
                  for (const t3 of i2.uniqueIds) {
                    const n3 = e2[t3.toString()];
                    i2.eachPosition(t3, (e3, t4, i3) => {
                      const l3 = r2.feature(e3);
                      d2.updatePaintArray(t4, i3, l3, n3, o2, s2, a2);
                    });
                  }
                l2 = true;
              }
            }
            return l2;
          }
          defines() {
            const e2 = [];
            for (const t2 in this.binders) {
              const i2 = this.binders[t2];
              (i2 instanceof Vl || i2 instanceof jl) && e2.push(...i2.uniformNames.map((e3) => `#define HAS_UNIFORM_${e3}`));
            }
            return e2;
          }
          getBinderAttributes() {
            const e2 = [];
            for (const t2 in this.binders) {
              const i2 = this.binders[t2];
              if (i2 instanceof Gl || i2 instanceof ql || i2 instanceof Zl)
                for (let t3 = 0; t3 < i2.paintVertexAttributes.length; t3++)
                  e2.push(i2.paintVertexAttributes[t3].name);
            }
            return e2;
          }
          getBinderUniforms() {
            const e2 = [];
            for (const t2 in this.binders) {
              const i2 = this.binders[t2];
              if (i2 instanceof Vl || i2 instanceof jl || i2 instanceof ql)
                for (const t3 of i2.uniformNames)
                  e2.push(t3);
            }
            return e2;
          }
          getPaintVertexBuffers() {
            return this._buffers;
          }
          getUniforms(e2) {
            const t2 = [];
            for (const i2 in this.binders) {
              const r2 = this.binders[i2];
              if (r2 instanceof Vl || r2 instanceof jl || r2 instanceof ql)
                for (const n2 of r2.uniformNames)
                  t2.push({ name: n2, property: i2, binding: r2.getBinding(e2, n2) });
            }
            return t2;
          }
          setUniforms(e2, t2, i2, r2, n2) {
            for (const { name: t3, property: o2, binding: s2 } of i2)
              this.binders[o2].setUniform(e2, s2, n2, r2.get(o2), t3);
          }
          updatePaintBuffers() {
            this._buffers = [];
            for (const e2 in this.binders) {
              const t2 = this.binders[e2];
              (t2 instanceof Gl || t2 instanceof ql || t2 instanceof Zl) && t2.paintVertexBuffer && this._buffers.push(t2.paintVertexBuffer);
            }
          }
          upload(e2) {
            for (const t2 in this.binders) {
              const i2 = this.binders[t2];
              (i2 instanceof Gl || i2 instanceof ql || i2 instanceof Zl) && i2.upload(e2);
            }
            this.updatePaintBuffers();
          }
          destroy() {
            for (const e2 in this.binders) {
              const t2 = this.binders[e2];
              (t2 instanceof Gl || t2 instanceof ql || t2 instanceof Zl) && t2.destroy();
            }
          }
        }
        class Hl {
          constructor(e2, t2, i2 = () => true) {
            this.programConfigurations = {};
            for (const r2 of e2)
              this.programConfigurations[r2.id] = new $l(r2, t2, i2);
            this.needsUpload = false, this._featureMap = new Tl(), this._featureMapWithoutIds = new Tl(), this._bufferOffset = 0, this._idlessCounter = 0;
          }
          populatePaintArrays(e2, t2, i2, r2, n2, o2, s2, a2) {
            for (const i3 in this.programConfigurations)
              this.programConfigurations[i3].populatePaintArrays(e2, t2, r2, n2, o2, s2, a2);
            void 0 !== t2.id ? this._featureMap.add(t2.id, i2, this._bufferOffset, e2) : (this._featureMapWithoutIds.add(this._idlessCounter, i2, this._bufferOffset, e2), this._idlessCounter += 1), this._bufferOffset = e2, this.needsUpload = true;
          }
          updatePaintArrays(e2, t2, i2, r2, n2, o2) {
            for (const s2 of i2)
              this.needsUpload = this.programConfigurations[s2.id].updatePaintArrays(e2, this._featureMap, this._featureMapWithoutIds, t2, s2, r2, n2, o2 || 0) || this.needsUpload;
          }
          get(e2) {
            return this.programConfigurations[e2];
          }
          upload(e2) {
            if (this.needsUpload) {
              for (const t2 in this.programConfigurations)
                this.programConfigurations[t2].upload(e2);
              this.needsUpload = false;
            }
          }
          destroy() {
            for (const e2 in this.programConfigurations)
              this.programConfigurations[e2].destroy();
          }
        }
        const Wl = { "text-opacity": ["opacity"], "icon-opacity": ["opacity"], "text-color": ["fill_color"], "icon-color": ["fill_color"], "text-emissive-strength": ["emissive_strength"], "icon-emissive-strength": ["emissive_strength"], "text-halo-color": ["halo_color"], "icon-halo-color": ["halo_color"], "text-halo-blur": ["halo_blur"], "icon-halo-blur": ["halo_blur"], "text-halo-width": ["halo_width"], "icon-halo-width": ["halo_width"], "line-gap-width": ["gapwidth"], "line-pattern": ["pattern", "pixel_ratio"], "fill-pattern": ["pattern", "pixel_ratio"], "fill-extrusion-pattern": ["pattern", "pixel_ratio"], "line-dasharray": ["dash"] };
        function Xl(e2, t2) {
          return Wl[e2] || [e2.replace(`${t2}-`, "").replace(/-/g, "_")];
        }
        const Yl = { "line-pattern": { source: Ca, composite: Ca }, "fill-pattern": { source: Ca, composite: Ca }, "fill-extrusion-pattern": { source: Ca, composite: Ca }, "line-dasharray": { source: za, composite: za } }, Kl = { color: { source: Xa, composite: Ia }, number: { source: qa, composite: Xa } };
        function Jl(e2, t2, i2) {
          const r2 = Yl[e2];
          return r2 && r2[i2] || Kl[t2][i2];
        }
        Is(Vl, "ConstantBinder"), Is(jl, "PatternConstantBinder"), Is(Gl, "SourceExpressionBinder"), Is(Zl, "PatternCompositeBinder"), Is(ql, "CompositeExpressionBinder"), Is($l, "ProgramConfiguration", { omit: ["_buffers"] }), Is(Hl, "ProgramConfigurationSet");
        class Ql {
          constructor(e2, t2) {
            e2 && (t2 ? this.setSouthWest(e2).setNorthEast(t2) : 4 === e2.length ? this.setSouthWest([e2[0], e2[1]]).setNorthEast([e2[2], e2[3]]) : this.setSouthWest(e2[0]).setNorthEast(e2[1]));
          }
          setNorthEast(e2) {
            return this._ne = e2 instanceof Nd ? new Nd(e2.lng, e2.lat) : Nd.convert(e2), this;
          }
          setSouthWest(e2) {
            return this._sw = e2 instanceof Nd ? new Nd(e2.lng, e2.lat) : Nd.convert(e2), this;
          }
          extend(e2) {
            const t2 = this._sw, i2 = this._ne;
            let r2, n2;
            if (e2 instanceof Nd)
              r2 = e2, n2 = e2;
            else {
              if (!(e2 instanceof Ql))
                return Array.isArray(e2) ? 4 === e2.length || e2.every(Array.isArray) ? this.extend(Ql.convert(e2)) : this.extend(Nd.convert(e2)) : "object" == typeof e2 && null !== e2 && e2.hasOwnProperty("lat") && (e2.hasOwnProperty("lon") || e2.hasOwnProperty("lng")) ? this.extend(Nd.convert(e2)) : this;
              if (r2 = e2._sw, n2 = e2._ne, !r2 || !n2)
                return this;
            }
            return t2 || i2 ? (t2.lng = Math.min(r2.lng, t2.lng), t2.lat = Math.min(r2.lat, t2.lat), i2.lng = Math.max(n2.lng, i2.lng), i2.lat = Math.max(n2.lat, i2.lat)) : (this._sw = new Nd(r2.lng, r2.lat), this._ne = new Nd(n2.lng, n2.lat)), this;
          }
          getCenter() {
            return new Nd((this._sw.lng + this._ne.lng) / 2, (this._sw.lat + this._ne.lat) / 2);
          }
          getSouthWest() {
            return this._sw;
          }
          getNorthEast() {
            return this._ne;
          }
          getNorthWest() {
            return new Nd(this.getWest(), this.getNorth());
          }
          getSouthEast() {
            return new Nd(this.getEast(), this.getSouth());
          }
          getWest() {
            return this._sw.lng;
          }
          getSouth() {
            return this._sw.lat;
          }
          getEast() {
            return this._ne.lng;
          }
          getNorth() {
            return this._ne.lat;
          }
          toArray() {
            return [this._sw.toArray(), this._ne.toArray()];
          }
          toString() {
            return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`;
          }
          isEmpty() {
            return !(this._sw && this._ne);
          }
          contains(e2) {
            const { lng: t2, lat: i2 } = Nd.convert(e2);
            let r2 = this._sw.lng <= t2 && t2 <= this._ne.lng;
            return this._sw.lng > this._ne.lng && (r2 = this._sw.lng >= t2 && t2 >= this._ne.lng), this._sw.lat <= i2 && i2 <= this._ne.lat && r2;
          }
          static convert(e2) {
            return !e2 || e2 instanceof Ql ? e2 : new Ql(e2);
          }
        }
        var ec = {}, tc = {};
        Object.defineProperty(tc, "__esModule", { value: true }), tc.setMatrixArrayType = function(e2) {
          tc.ARRAY_TYPE = rc = e2;
        }, tc.toRadian = function(e2) {
          return e2 * oc;
        }, tc.equals = function(e2, t2) {
          return Math.abs(e2 - t2) <= ic * Math.max(1, Math.abs(e2), Math.abs(t2));
        }, tc.RANDOM = tc.ARRAY_TYPE = tc.EPSILON = void 0;
        var ic = 1e-6;
        tc.EPSILON = ic;
        var rc = "undefined" != typeof Float32Array ? Float32Array : Array;
        tc.ARRAY_TYPE = rc;
        var nc = Math.random;
        tc.RANDOM = nc;
        var oc = Math.PI / 180;
        Math.hypot || (Math.hypot = function() {
          for (var e2 = 0, t2 = arguments.length; t2--; )
            e2 += arguments[t2] * arguments[t2];
          return Math.sqrt(e2);
        });
        var sc = {};
        function ac(e2) {
          return ac = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, ac(e2);
        }
        Object.defineProperty(sc, "__esModule", { value: true }), sc.create = function() {
          var e2 = new lc.ARRAY_TYPE(4);
          return lc.ARRAY_TYPE != Float32Array && (e2[1] = 0, e2[2] = 0), e2[0] = 1, e2[3] = 1, e2;
        }, sc.clone = function(e2) {
          var t2 = new lc.ARRAY_TYPE(4);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2;
        }, sc.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2;
        }, sc.identity = function(e2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2;
        }, sc.fromValues = function(e2, t2, i2, r2) {
          var n2 = new lc.ARRAY_TYPE(4);
          return n2[0] = e2, n2[1] = t2, n2[2] = i2, n2[3] = r2, n2;
        }, sc.set = function(e2, t2, i2, r2, n2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2;
        }, sc.transpose = function(e2, t2) {
          if (e2 === t2) {
            var i2 = t2[1];
            e2[1] = t2[2], e2[2] = i2;
          } else
            e2[0] = t2[0], e2[1] = t2[2], e2[2] = t2[1], e2[3] = t2[3];
          return e2;
        }, sc.invert = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2 * o2 - n2 * r2;
          return s2 ? (e2[0] = o2 * (s2 = 1 / s2), e2[1] = -r2 * s2, e2[2] = -n2 * s2, e2[3] = i2 * s2, e2) : null;
        }, sc.adjoint = function(e2, t2) {
          var i2 = t2[0];
          return e2[0] = t2[3], e2[1] = -t2[1], e2[2] = -t2[2], e2[3] = i2, e2;
        }, sc.determinant = function(e2) {
          return e2[0] * e2[3] - e2[2] * e2[1];
        }, sc.multiply = hc, sc.rotate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = Math.sin(i2), l2 = Math.cos(i2);
          return e2[0] = r2 * l2 + o2 * a2, e2[1] = n2 * l2 + s2 * a2, e2[2] = r2 * -a2 + o2 * l2, e2[3] = n2 * -a2 + s2 * l2, e2;
        }, sc.scale = function(e2, t2, i2) {
          var r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2[0], a2 = i2[1];
          return e2[0] = t2[0] * s2, e2[1] = r2 * s2, e2[2] = n2 * a2, e2[3] = o2 * a2, e2;
        }, sc.fromRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = r2, e2[1] = i2, e2[2] = -i2, e2[3] = r2, e2;
        }, sc.fromScaling = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = 0, e2[2] = 0, e2[3] = t2[1], e2;
        }, sc.str = function(e2) {
          return "mat2(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ")";
        }, sc.frob = function(e2) {
          return Math.hypot(e2[0], e2[1], e2[2], e2[3]);
        }, sc.LDU = function(e2, t2, i2, r2) {
          return e2[2] = r2[2] / r2[0], i2[0] = r2[0], i2[1] = r2[1], i2[3] = r2[3] - e2[2] * i2[1], [e2, t2, i2];
        }, sc.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2;
        }, sc.subtract = uc, sc.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3];
        }, sc.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = t2[0], a2 = t2[1], l2 = t2[2], c2 = t2[3];
          return Math.abs(i2 - s2) <= lc.EPSILON * Math.max(1, Math.abs(i2), Math.abs(s2)) && Math.abs(r2 - a2) <= lc.EPSILON * Math.max(1, Math.abs(r2), Math.abs(a2)) && Math.abs(n2 - l2) <= lc.EPSILON * Math.max(1, Math.abs(n2), Math.abs(l2)) && Math.abs(o2 - c2) <= lc.EPSILON * Math.max(1, Math.abs(o2), Math.abs(c2));
        }, sc.multiplyScalar = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2;
        }, sc.multiplyScalarAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2[3] = t2[3] + i2[3] * r2, e2;
        }, sc.sub = sc.mul = void 0;
        var lc = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== ac(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = cc(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function cc(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (cc = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function hc(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = i2[0], l2 = i2[1], c2 = i2[2], h2 = i2[3];
          return e2[0] = r2 * a2 + o2 * l2, e2[1] = n2 * a2 + s2 * l2, e2[2] = r2 * c2 + o2 * h2, e2[3] = n2 * c2 + s2 * h2, e2;
        }
        function uc(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2[3] = t2[3] - i2[3], e2;
        }
        sc.mul = hc, sc.sub = uc;
        var dc = {};
        function pc(e2) {
          return pc = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, pc(e2);
        }
        Object.defineProperty(dc, "__esModule", { value: true }), dc.create = function() {
          var e2 = new fc.ARRAY_TYPE(6);
          return fc.ARRAY_TYPE != Float32Array && (e2[1] = 0, e2[2] = 0, e2[4] = 0, e2[5] = 0), e2[0] = 1, e2[3] = 1, e2;
        }, dc.clone = function(e2) {
          var t2 = new fc.ARRAY_TYPE(6);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2[4] = e2[4], t2[5] = e2[5], t2;
        }, dc.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[4] = t2[4], e2[5] = t2[5], e2;
        }, dc.identity = function(e2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2[4] = 0, e2[5] = 0, e2;
        }, dc.fromValues = function(e2, t2, i2, r2, n2, o2) {
          var s2 = new fc.ARRAY_TYPE(6);
          return s2[0] = e2, s2[1] = t2, s2[2] = i2, s2[3] = r2, s2[4] = n2, s2[5] = o2, s2;
        }, dc.set = function(e2, t2, i2, r2, n2, o2, s2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2[4] = o2, e2[5] = s2, e2;
        }, dc.invert = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = i2 * o2 - r2 * n2;
          return l2 ? (e2[0] = o2 * (l2 = 1 / l2), e2[1] = -r2 * l2, e2[2] = -n2 * l2, e2[3] = i2 * l2, e2[4] = (n2 * a2 - o2 * s2) * l2, e2[5] = (r2 * s2 - i2 * a2) * l2, e2) : null;
        }, dc.determinant = function(e2) {
          return e2[0] * e2[3] - e2[1] * e2[2];
        }, dc.multiply = _c, dc.rotate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = Math.sin(i2), h2 = Math.cos(i2);
          return e2[0] = r2 * h2 + o2 * c2, e2[1] = n2 * h2 + s2 * c2, e2[2] = r2 * -c2 + o2 * h2, e2[3] = n2 * -c2 + s2 * h2, e2[4] = a2, e2[5] = l2, e2;
        }, dc.scale = function(e2, t2, i2) {
          var r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = i2[0], c2 = i2[1];
          return e2[0] = t2[0] * l2, e2[1] = r2 * l2, e2[2] = n2 * c2, e2[3] = o2 * c2, e2[4] = s2, e2[5] = a2, e2;
        }, dc.translate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = i2[0], h2 = i2[1];
          return e2[0] = r2, e2[1] = n2, e2[2] = o2, e2[3] = s2, e2[4] = r2 * c2 + o2 * h2 + a2, e2[5] = n2 * c2 + s2 * h2 + l2, e2;
        }, dc.fromRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = r2, e2[1] = i2, e2[2] = -i2, e2[3] = r2, e2[4] = 0, e2[5] = 0, e2;
        }, dc.fromScaling = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = 0, e2[2] = 0, e2[3] = t2[1], e2[4] = 0, e2[5] = 0, e2;
        }, dc.fromTranslation = function(e2, t2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2[4] = t2[0], e2[5] = t2[1], e2;
        }, dc.str = function(e2) {
          return "mat2d(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ", " + e2[4] + ", " + e2[5] + ")";
        }, dc.frob = function(e2) {
          return Math.hypot(e2[0], e2[1], e2[2], e2[3], e2[4], e2[5], 1);
        }, dc.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2[4] = t2[4] + i2[4], e2[5] = t2[5] + i2[5], e2;
        }, dc.subtract = gc, dc.multiplyScalar = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2[4] = t2[4] * i2, e2[5] = t2[5] * i2, e2;
        }, dc.multiplyScalarAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2[3] = t2[3] + i2[3] * r2, e2[4] = t2[4] + i2[4] * r2, e2[5] = t2[5] + i2[5] * r2, e2;
        }, dc.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3] && e2[4] === t2[4] && e2[5] === t2[5];
        }, dc.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = e2[4], a2 = e2[5], l2 = t2[0], c2 = t2[1], h2 = t2[2], u2 = t2[3], d2 = t2[4], p2 = t2[5];
          return Math.abs(i2 - l2) <= fc.EPSILON * Math.max(1, Math.abs(i2), Math.abs(l2)) && Math.abs(r2 - c2) <= fc.EPSILON * Math.max(1, Math.abs(r2), Math.abs(c2)) && Math.abs(n2 - h2) <= fc.EPSILON * Math.max(1, Math.abs(n2), Math.abs(h2)) && Math.abs(o2 - u2) <= fc.EPSILON * Math.max(1, Math.abs(o2), Math.abs(u2)) && Math.abs(s2 - d2) <= fc.EPSILON * Math.max(1, Math.abs(s2), Math.abs(d2)) && Math.abs(a2 - p2) <= fc.EPSILON * Math.max(1, Math.abs(a2), Math.abs(p2));
        }, dc.sub = dc.mul = void 0;
        var fc = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== pc(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = mc(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function mc(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (mc = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function _c(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = i2[0], h2 = i2[1], u2 = i2[2], d2 = i2[3], p2 = i2[4], f2 = i2[5];
          return e2[0] = r2 * c2 + o2 * h2, e2[1] = n2 * c2 + s2 * h2, e2[2] = r2 * u2 + o2 * d2, e2[3] = n2 * u2 + s2 * d2, e2[4] = r2 * p2 + o2 * f2 + a2, e2[5] = n2 * p2 + s2 * f2 + l2, e2;
        }
        function gc(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2[3] = t2[3] - i2[3], e2[4] = t2[4] - i2[4], e2[5] = t2[5] - i2[5], e2;
        }
        dc.mul = _c, dc.sub = gc;
        var yc = {};
        function xc(e2) {
          return xc = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, xc(e2);
        }
        Object.defineProperty(yc, "__esModule", { value: true }), yc.create = function() {
          var e2 = new vc.ARRAY_TYPE(9);
          return vc.ARRAY_TYPE != Float32Array && (e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[5] = 0, e2[6] = 0, e2[7] = 0), e2[0] = 1, e2[4] = 1, e2[8] = 1, e2;
        }, yc.fromMat4 = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[4], e2[4] = t2[5], e2[5] = t2[6], e2[6] = t2[8], e2[7] = t2[9], e2[8] = t2[10], e2;
        }, yc.clone = function(e2) {
          var t2 = new vc.ARRAY_TYPE(9);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2[4] = e2[4], t2[5] = e2[5], t2[6] = e2[6], t2[7] = e2[7], t2[8] = e2[8], t2;
        }, yc.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[4] = t2[4], e2[5] = t2[5], e2[6] = t2[6], e2[7] = t2[7], e2[8] = t2[8], e2;
        }, yc.fromValues = function(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          var c2 = new vc.ARRAY_TYPE(9);
          return c2[0] = e2, c2[1] = t2, c2[2] = i2, c2[3] = r2, c2[4] = n2, c2[5] = o2, c2[6] = s2, c2[7] = a2, c2[8] = l2, c2;
        }, yc.set = function(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2[4] = o2, e2[5] = s2, e2[6] = a2, e2[7] = l2, e2[8] = c2, e2;
        }, yc.identity = function(e2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 1, e2[5] = 0, e2[6] = 0, e2[7] = 0, e2[8] = 1, e2;
        }, yc.transpose = function(e2, t2) {
          if (e2 === t2) {
            var i2 = t2[1], r2 = t2[2], n2 = t2[5];
            e2[1] = t2[3], e2[2] = t2[6], e2[3] = i2, e2[5] = t2[7], e2[6] = r2, e2[7] = n2;
          } else
            e2[0] = t2[0], e2[1] = t2[3], e2[2] = t2[6], e2[3] = t2[1], e2[4] = t2[4], e2[5] = t2[7], e2[6] = t2[2], e2[7] = t2[5], e2[8] = t2[8];
          return e2;
        }, yc.invert = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = t2[6], c2 = t2[7], h2 = t2[8], u2 = h2 * s2 - a2 * c2, d2 = -h2 * o2 + a2 * l2, p2 = c2 * o2 - s2 * l2, f2 = i2 * u2 + r2 * d2 + n2 * p2;
          return f2 ? (e2[0] = u2 * (f2 = 1 / f2), e2[1] = (-h2 * r2 + n2 * c2) * f2, e2[2] = (a2 * r2 - n2 * s2) * f2, e2[3] = d2 * f2, e2[4] = (h2 * i2 - n2 * l2) * f2, e2[5] = (-a2 * i2 + n2 * o2) * f2, e2[6] = p2 * f2, e2[7] = (-c2 * i2 + r2 * l2) * f2, e2[8] = (s2 * i2 - r2 * o2) * f2, e2) : null;
        }, yc.adjoint = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = t2[6], c2 = t2[7], h2 = t2[8];
          return e2[0] = s2 * h2 - a2 * c2, e2[1] = n2 * c2 - r2 * h2, e2[2] = r2 * a2 - n2 * s2, e2[3] = a2 * l2 - o2 * h2, e2[4] = i2 * h2 - n2 * l2, e2[5] = n2 * o2 - i2 * a2, e2[6] = o2 * c2 - s2 * l2, e2[7] = r2 * l2 - i2 * c2, e2[8] = i2 * s2 - r2 * o2, e2;
        }, yc.determinant = function(e2) {
          var t2 = e2[3], i2 = e2[4], r2 = e2[5], n2 = e2[6], o2 = e2[7], s2 = e2[8];
          return e2[0] * (s2 * i2 - r2 * o2) + e2[1] * (-s2 * t2 + r2 * n2) + e2[2] * (o2 * t2 - i2 * n2);
        }, yc.multiply = wc, yc.translate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = t2[8], d2 = i2[0], p2 = i2[1];
          return e2[0] = r2, e2[1] = n2, e2[2] = o2, e2[3] = s2, e2[4] = a2, e2[5] = l2, e2[6] = d2 * r2 + p2 * s2 + c2, e2[7] = d2 * n2 + p2 * a2 + h2, e2[8] = d2 * o2 + p2 * l2 + u2, e2;
        }, yc.rotate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = t2[8], d2 = Math.sin(i2), p2 = Math.cos(i2);
          return e2[0] = p2 * r2 + d2 * s2, e2[1] = p2 * n2 + d2 * a2, e2[2] = p2 * o2 + d2 * l2, e2[3] = p2 * s2 - d2 * r2, e2[4] = p2 * a2 - d2 * n2, e2[5] = p2 * l2 - d2 * o2, e2[6] = c2, e2[7] = h2, e2[8] = u2, e2;
        }, yc.scale = function(e2, t2, i2) {
          var r2 = i2[0], n2 = i2[1];
          return e2[0] = r2 * t2[0], e2[1] = r2 * t2[1], e2[2] = r2 * t2[2], e2[3] = n2 * t2[3], e2[4] = n2 * t2[4], e2[5] = n2 * t2[5], e2[6] = t2[6], e2[7] = t2[7], e2[8] = t2[8], e2;
        }, yc.fromTranslation = function(e2, t2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 1, e2[5] = 0, e2[6] = t2[0], e2[7] = t2[1], e2[8] = 1, e2;
        }, yc.fromRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = r2, e2[1] = i2, e2[2] = 0, e2[3] = -i2, e2[4] = r2, e2[5] = 0, e2[6] = 0, e2[7] = 0, e2[8] = 1, e2;
        }, yc.fromScaling = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = t2[1], e2[5] = 0, e2[6] = 0, e2[7] = 0, e2[8] = 1, e2;
        }, yc.fromMat2d = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = 0, e2[3] = t2[2], e2[4] = t2[3], e2[5] = 0, e2[6] = t2[4], e2[7] = t2[5], e2[8] = 1, e2;
        }, yc.fromQuat = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2 + i2, a2 = r2 + r2, l2 = n2 + n2, c2 = i2 * s2, h2 = r2 * s2, u2 = r2 * a2, d2 = n2 * s2, p2 = n2 * a2, f2 = n2 * l2, m2 = o2 * s2, _2 = o2 * a2, g2 = o2 * l2;
          return e2[0] = 1 - u2 - f2, e2[3] = h2 - g2, e2[6] = d2 + _2, e2[1] = h2 + g2, e2[4] = 1 - c2 - f2, e2[7] = p2 - m2, e2[2] = d2 - _2, e2[5] = p2 + m2, e2[8] = 1 - c2 - u2, e2;
        }, yc.normalFromMat4 = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = t2[6], c2 = t2[7], h2 = t2[8], u2 = t2[9], d2 = t2[10], p2 = t2[11], f2 = t2[12], m2 = t2[13], _2 = t2[14], g2 = t2[15], y2 = i2 * a2 - r2 * s2, x2 = i2 * l2 - n2 * s2, v2 = i2 * c2 - o2 * s2, b2 = r2 * l2 - n2 * a2, w2 = r2 * c2 - o2 * a2, T2 = n2 * c2 - o2 * l2, E2 = h2 * m2 - u2 * f2, M2 = h2 * _2 - d2 * f2, A2 = h2 * g2 - p2 * f2, S2 = u2 * _2 - d2 * m2, I2 = u2 * g2 - p2 * m2, C2 = d2 * g2 - p2 * _2, z2 = y2 * C2 - x2 * I2 + v2 * S2 + b2 * A2 - w2 * M2 + T2 * E2;
          return z2 ? (e2[0] = (a2 * C2 - l2 * I2 + c2 * S2) * (z2 = 1 / z2), e2[1] = (l2 * A2 - s2 * C2 - c2 * M2) * z2, e2[2] = (s2 * I2 - a2 * A2 + c2 * E2) * z2, e2[3] = (n2 * I2 - r2 * C2 - o2 * S2) * z2, e2[4] = (i2 * C2 - n2 * A2 + o2 * M2) * z2, e2[5] = (r2 * A2 - i2 * I2 - o2 * E2) * z2, e2[6] = (m2 * T2 - _2 * w2 + g2 * b2) * z2, e2[7] = (_2 * v2 - f2 * T2 - g2 * x2) * z2, e2[8] = (f2 * w2 - m2 * v2 + g2 * y2) * z2, e2) : null;
        }, yc.projection = function(e2, t2, i2) {
          return e2[0] = 2 / t2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = -2 / i2, e2[5] = 0, e2[6] = -1, e2[7] = 1, e2[8] = 1, e2;
        }, yc.str = function(e2) {
          return "mat3(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ", " + e2[4] + ", " + e2[5] + ", " + e2[6] + ", " + e2[7] + ", " + e2[8] + ")";
        }, yc.frob = function(e2) {
          return Math.hypot(e2[0], e2[1], e2[2], e2[3], e2[4], e2[5], e2[6], e2[7], e2[8]);
        }, yc.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2[4] = t2[4] + i2[4], e2[5] = t2[5] + i2[5], e2[6] = t2[6] + i2[6], e2[7] = t2[7] + i2[7], e2[8] = t2[8] + i2[8], e2;
        }, yc.subtract = Tc, yc.multiplyScalar = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2[4] = t2[4] * i2, e2[5] = t2[5] * i2, e2[6] = t2[6] * i2, e2[7] = t2[7] * i2, e2[8] = t2[8] * i2, e2;
        }, yc.multiplyScalarAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2[3] = t2[3] + i2[3] * r2, e2[4] = t2[4] + i2[4] * r2, e2[5] = t2[5] + i2[5] * r2, e2[6] = t2[6] + i2[6] * r2, e2[7] = t2[7] + i2[7] * r2, e2[8] = t2[8] + i2[8] * r2, e2;
        }, yc.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3] && e2[4] === t2[4] && e2[5] === t2[5] && e2[6] === t2[6] && e2[7] === t2[7] && e2[8] === t2[8];
        }, yc.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = e2[4], a2 = e2[5], l2 = e2[6], c2 = e2[7], h2 = e2[8], u2 = t2[0], d2 = t2[1], p2 = t2[2], f2 = t2[3], m2 = t2[4], _2 = t2[5], g2 = t2[6], y2 = t2[7], x2 = t2[8];
          return Math.abs(i2 - u2) <= vc.EPSILON * Math.max(1, Math.abs(i2), Math.abs(u2)) && Math.abs(r2 - d2) <= vc.EPSILON * Math.max(1, Math.abs(r2), Math.abs(d2)) && Math.abs(n2 - p2) <= vc.EPSILON * Math.max(1, Math.abs(n2), Math.abs(p2)) && Math.abs(o2 - f2) <= vc.EPSILON * Math.max(1, Math.abs(o2), Math.abs(f2)) && Math.abs(s2 - m2) <= vc.EPSILON * Math.max(1, Math.abs(s2), Math.abs(m2)) && Math.abs(a2 - _2) <= vc.EPSILON * Math.max(1, Math.abs(a2), Math.abs(_2)) && Math.abs(l2 - g2) <= vc.EPSILON * Math.max(1, Math.abs(l2), Math.abs(g2)) && Math.abs(c2 - y2) <= vc.EPSILON * Math.max(1, Math.abs(c2), Math.abs(y2)) && Math.abs(h2 - x2) <= vc.EPSILON * Math.max(1, Math.abs(h2), Math.abs(x2));
        }, yc.sub = yc.mul = void 0;
        var vc = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== xc(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = bc(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function bc(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (bc = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function wc(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = t2[8], d2 = i2[0], p2 = i2[1], f2 = i2[2], m2 = i2[3], _2 = i2[4], g2 = i2[5], y2 = i2[6], x2 = i2[7], v2 = i2[8];
          return e2[0] = d2 * r2 + p2 * s2 + f2 * c2, e2[1] = d2 * n2 + p2 * a2 + f2 * h2, e2[2] = d2 * o2 + p2 * l2 + f2 * u2, e2[3] = m2 * r2 + _2 * s2 + g2 * c2, e2[4] = m2 * n2 + _2 * a2 + g2 * h2, e2[5] = m2 * o2 + _2 * l2 + g2 * u2, e2[6] = y2 * r2 + x2 * s2 + v2 * c2, e2[7] = y2 * n2 + x2 * a2 + v2 * h2, e2[8] = y2 * o2 + x2 * l2 + v2 * u2, e2;
        }
        function Tc(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2[3] = t2[3] - i2[3], e2[4] = t2[4] - i2[4], e2[5] = t2[5] - i2[5], e2[6] = t2[6] - i2[6], e2[7] = t2[7] - i2[7], e2[8] = t2[8] - i2[8], e2;
        }
        yc.mul = wc, yc.sub = Tc;
        var Ec = {};
        function Mc(e2) {
          return Mc = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, Mc(e2);
        }
        Object.defineProperty(Ec, "__esModule", { value: true }), Ec.create = function() {
          var e2 = new Ac.ARRAY_TYPE(16);
          return Ac.ARRAY_TYPE != Float32Array && (e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0), e2[0] = 1, e2[5] = 1, e2[10] = 1, e2[15] = 1, e2;
        }, Ec.clone = function(e2) {
          var t2 = new Ac.ARRAY_TYPE(16);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2[4] = e2[4], t2[5] = e2[5], t2[6] = e2[6], t2[7] = e2[7], t2[8] = e2[8], t2[9] = e2[9], t2[10] = e2[10], t2[11] = e2[11], t2[12] = e2[12], t2[13] = e2[13], t2[14] = e2[14], t2[15] = e2[15], t2;
        }, Ec.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[4] = t2[4], e2[5] = t2[5], e2[6] = t2[6], e2[7] = t2[7], e2[8] = t2[8], e2[9] = t2[9], e2[10] = t2[10], e2[11] = t2[11], e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15], e2;
        }, Ec.fromValues = function(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2) {
          var _2 = new Ac.ARRAY_TYPE(16);
          return _2[0] = e2, _2[1] = t2, _2[2] = i2, _2[3] = r2, _2[4] = n2, _2[5] = o2, _2[6] = s2, _2[7] = a2, _2[8] = l2, _2[9] = c2, _2[10] = h2, _2[11] = u2, _2[12] = d2, _2[13] = p2, _2[14] = f2, _2[15] = m2, _2;
        }, Ec.set = function(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2[4] = o2, e2[5] = s2, e2[6] = a2, e2[7] = l2, e2[8] = c2, e2[9] = h2, e2[10] = u2, e2[11] = d2, e2[12] = p2, e2[13] = f2, e2[14] = m2, e2[15] = _2, e2;
        }, Ec.identity = Ic, Ec.transpose = function(e2, t2) {
          if (e2 === t2) {
            var i2 = t2[1], r2 = t2[2], n2 = t2[3], o2 = t2[6], s2 = t2[7], a2 = t2[11];
            e2[1] = t2[4], e2[2] = t2[8], e2[3] = t2[12], e2[4] = i2, e2[6] = t2[9], e2[7] = t2[13], e2[8] = r2, e2[9] = o2, e2[11] = t2[14], e2[12] = n2, e2[13] = s2, e2[14] = a2;
          } else
            e2[0] = t2[0], e2[1] = t2[4], e2[2] = t2[8], e2[3] = t2[12], e2[4] = t2[1], e2[5] = t2[5], e2[6] = t2[9], e2[7] = t2[13], e2[8] = t2[2], e2[9] = t2[6], e2[10] = t2[10], e2[11] = t2[14], e2[12] = t2[3], e2[13] = t2[7], e2[14] = t2[11], e2[15] = t2[15];
          return e2;
        }, Ec.invert = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = t2[6], c2 = t2[7], h2 = t2[8], u2 = t2[9], d2 = t2[10], p2 = t2[11], f2 = t2[12], m2 = t2[13], _2 = t2[14], g2 = t2[15], y2 = i2 * a2 - r2 * s2, x2 = i2 * l2 - n2 * s2, v2 = i2 * c2 - o2 * s2, b2 = r2 * l2 - n2 * a2, w2 = r2 * c2 - o2 * a2, T2 = n2 * c2 - o2 * l2, E2 = h2 * m2 - u2 * f2, M2 = h2 * _2 - d2 * f2, A2 = h2 * g2 - p2 * f2, S2 = u2 * _2 - d2 * m2, I2 = u2 * g2 - p2 * m2, C2 = d2 * g2 - p2 * _2, z2 = y2 * C2 - x2 * I2 + v2 * S2 + b2 * A2 - w2 * M2 + T2 * E2;
          return z2 ? (e2[0] = (a2 * C2 - l2 * I2 + c2 * S2) * (z2 = 1 / z2), e2[1] = (n2 * I2 - r2 * C2 - o2 * S2) * z2, e2[2] = (m2 * T2 - _2 * w2 + g2 * b2) * z2, e2[3] = (d2 * w2 - u2 * T2 - p2 * b2) * z2, e2[4] = (l2 * A2 - s2 * C2 - c2 * M2) * z2, e2[5] = (i2 * C2 - n2 * A2 + o2 * M2) * z2, e2[6] = (_2 * v2 - f2 * T2 - g2 * x2) * z2, e2[7] = (h2 * T2 - d2 * v2 + p2 * x2) * z2, e2[8] = (s2 * I2 - a2 * A2 + c2 * E2) * z2, e2[9] = (r2 * A2 - i2 * I2 - o2 * E2) * z2, e2[10] = (f2 * w2 - m2 * v2 + g2 * y2) * z2, e2[11] = (u2 * v2 - h2 * w2 - p2 * y2) * z2, e2[12] = (a2 * M2 - s2 * S2 - l2 * E2) * z2, e2[13] = (i2 * S2 - r2 * M2 + n2 * E2) * z2, e2[14] = (m2 * x2 - f2 * b2 - _2 * y2) * z2, e2[15] = (h2 * b2 - u2 * x2 + d2 * y2) * z2, e2) : null;
        }, Ec.adjoint = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = t2[4], a2 = t2[5], l2 = t2[6], c2 = t2[7], h2 = t2[8], u2 = t2[9], d2 = t2[10], p2 = t2[11], f2 = t2[12], m2 = t2[13], _2 = t2[14], g2 = t2[15];
          return e2[0] = a2 * (d2 * g2 - p2 * _2) - u2 * (l2 * g2 - c2 * _2) + m2 * (l2 * p2 - c2 * d2), e2[1] = -(r2 * (d2 * g2 - p2 * _2) - u2 * (n2 * g2 - o2 * _2) + m2 * (n2 * p2 - o2 * d2)), e2[2] = r2 * (l2 * g2 - c2 * _2) - a2 * (n2 * g2 - o2 * _2) + m2 * (n2 * c2 - o2 * l2), e2[3] = -(r2 * (l2 * p2 - c2 * d2) - a2 * (n2 * p2 - o2 * d2) + u2 * (n2 * c2 - o2 * l2)), e2[4] = -(s2 * (d2 * g2 - p2 * _2) - h2 * (l2 * g2 - c2 * _2) + f2 * (l2 * p2 - c2 * d2)), e2[5] = i2 * (d2 * g2 - p2 * _2) - h2 * (n2 * g2 - o2 * _2) + f2 * (n2 * p2 - o2 * d2), e2[6] = -(i2 * (l2 * g2 - c2 * _2) - s2 * (n2 * g2 - o2 * _2) + f2 * (n2 * c2 - o2 * l2)), e2[7] = i2 * (l2 * p2 - c2 * d2) - s2 * (n2 * p2 - o2 * d2) + h2 * (n2 * c2 - o2 * l2), e2[8] = s2 * (u2 * g2 - p2 * m2) - h2 * (a2 * g2 - c2 * m2) + f2 * (a2 * p2 - c2 * u2), e2[9] = -(i2 * (u2 * g2 - p2 * m2) - h2 * (r2 * g2 - o2 * m2) + f2 * (r2 * p2 - o2 * u2)), e2[10] = i2 * (a2 * g2 - c2 * m2) - s2 * (r2 * g2 - o2 * m2) + f2 * (r2 * c2 - o2 * a2), e2[11] = -(i2 * (a2 * p2 - c2 * u2) - s2 * (r2 * p2 - o2 * u2) + h2 * (r2 * c2 - o2 * a2)), e2[12] = -(s2 * (u2 * _2 - d2 * m2) - h2 * (a2 * _2 - l2 * m2) + f2 * (a2 * d2 - l2 * u2)), e2[13] = i2 * (u2 * _2 - d2 * m2) - h2 * (r2 * _2 - n2 * m2) + f2 * (r2 * d2 - n2 * u2), e2[14] = -(i2 * (a2 * _2 - l2 * m2) - s2 * (r2 * _2 - n2 * m2) + f2 * (r2 * l2 - n2 * a2)), e2[15] = i2 * (a2 * d2 - l2 * u2) - s2 * (r2 * d2 - n2 * u2) + h2 * (r2 * l2 - n2 * a2), e2;
        }, Ec.determinant = function(e2) {
          var t2 = e2[0], i2 = e2[1], r2 = e2[2], n2 = e2[3], o2 = e2[4], s2 = e2[5], a2 = e2[6], l2 = e2[7], c2 = e2[8], h2 = e2[9], u2 = e2[10], d2 = e2[11], p2 = e2[12], f2 = e2[13], m2 = e2[14], _2 = e2[15];
          return (t2 * s2 - i2 * o2) * (u2 * _2 - d2 * m2) - (t2 * a2 - r2 * o2) * (h2 * _2 - d2 * f2) + (t2 * l2 - n2 * o2) * (h2 * m2 - u2 * f2) + (i2 * a2 - r2 * s2) * (c2 * _2 - d2 * p2) - (i2 * l2 - n2 * s2) * (c2 * m2 - u2 * p2) + (r2 * l2 - n2 * a2) * (c2 * f2 - h2 * p2);
        }, Ec.multiply = Cc, Ec.translate = function(e2, t2, i2) {
          var r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2 = i2[0], _2 = i2[1], g2 = i2[2];
          return t2 === e2 ? (e2[12] = t2[0] * m2 + t2[4] * _2 + t2[8] * g2 + t2[12], e2[13] = t2[1] * m2 + t2[5] * _2 + t2[9] * g2 + t2[13], e2[14] = t2[2] * m2 + t2[6] * _2 + t2[10] * g2 + t2[14], e2[15] = t2[3] * m2 + t2[7] * _2 + t2[11] * g2 + t2[15]) : (n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = t2[8], d2 = t2[9], p2 = t2[10], f2 = t2[11], e2[0] = r2 = t2[0], e2[1] = n2, e2[2] = o2, e2[3] = s2, e2[4] = a2, e2[5] = l2, e2[6] = c2, e2[7] = h2, e2[8] = u2, e2[9] = d2, e2[10] = p2, e2[11] = f2, e2[12] = r2 * m2 + a2 * _2 + u2 * g2 + t2[12], e2[13] = n2 * m2 + l2 * _2 + d2 * g2 + t2[13], e2[14] = o2 * m2 + c2 * _2 + p2 * g2 + t2[14], e2[15] = s2 * m2 + h2 * _2 + f2 * g2 + t2[15]), e2;
        }, Ec.scale = function(e2, t2, i2) {
          var r2 = i2[0], n2 = i2[1], o2 = i2[2];
          return e2[0] = t2[0] * r2, e2[1] = t2[1] * r2, e2[2] = t2[2] * r2, e2[3] = t2[3] * r2, e2[4] = t2[4] * n2, e2[5] = t2[5] * n2, e2[6] = t2[6] * n2, e2[7] = t2[7] * n2, e2[8] = t2[8] * o2, e2[9] = t2[9] * o2, e2[10] = t2[10] * o2, e2[11] = t2[11] * o2, e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15], e2;
        }, Ec.rotate = function(e2, t2, i2, r2) {
          var n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, y2, x2, v2, b2, w2, T2, E2, M2, A2, S2, I2 = r2[0], C2 = r2[1], z2 = r2[2], D2 = Math.hypot(I2, C2, z2);
          return D2 < Ac.EPSILON ? null : (I2 *= D2 = 1 / D2, C2 *= D2, z2 *= D2, n2 = Math.sin(i2), o2 = Math.cos(i2), l2 = t2[1], c2 = t2[2], h2 = t2[3], d2 = t2[5], p2 = t2[6], f2 = t2[7], _2 = t2[9], g2 = t2[10], y2 = t2[11], w2 = I2 * C2 * (s2 = 1 - o2) - z2 * n2, T2 = C2 * C2 * s2 + o2, E2 = z2 * C2 * s2 + I2 * n2, M2 = I2 * z2 * s2 + C2 * n2, A2 = C2 * z2 * s2 - I2 * n2, S2 = z2 * z2 * s2 + o2, e2[0] = (a2 = t2[0]) * (x2 = I2 * I2 * s2 + o2) + (u2 = t2[4]) * (v2 = C2 * I2 * s2 + z2 * n2) + (m2 = t2[8]) * (b2 = z2 * I2 * s2 - C2 * n2), e2[1] = l2 * x2 + d2 * v2 + _2 * b2, e2[2] = c2 * x2 + p2 * v2 + g2 * b2, e2[3] = h2 * x2 + f2 * v2 + y2 * b2, e2[4] = a2 * w2 + u2 * T2 + m2 * E2, e2[5] = l2 * w2 + d2 * T2 + _2 * E2, e2[6] = c2 * w2 + p2 * T2 + g2 * E2, e2[7] = h2 * w2 + f2 * T2 + y2 * E2, e2[8] = a2 * M2 + u2 * A2 + m2 * S2, e2[9] = l2 * M2 + d2 * A2 + _2 * S2, e2[10] = c2 * M2 + p2 * A2 + g2 * S2, e2[11] = h2 * M2 + f2 * A2 + y2 * S2, t2 !== e2 && (e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15]), e2);
        }, Ec.rotateX = function(e2, t2, i2) {
          var r2 = Math.sin(i2), n2 = Math.cos(i2), o2 = t2[4], s2 = t2[5], a2 = t2[6], l2 = t2[7], c2 = t2[8], h2 = t2[9], u2 = t2[10], d2 = t2[11];
          return t2 !== e2 && (e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15]), e2[4] = o2 * n2 + c2 * r2, e2[5] = s2 * n2 + h2 * r2, e2[6] = a2 * n2 + u2 * r2, e2[7] = l2 * n2 + d2 * r2, e2[8] = c2 * n2 - o2 * r2, e2[9] = h2 * n2 - s2 * r2, e2[10] = u2 * n2 - a2 * r2, e2[11] = d2 * n2 - l2 * r2, e2;
        }, Ec.rotateY = function(e2, t2, i2) {
          var r2 = Math.sin(i2), n2 = Math.cos(i2), o2 = t2[0], s2 = t2[1], a2 = t2[2], l2 = t2[3], c2 = t2[8], h2 = t2[9], u2 = t2[10], d2 = t2[11];
          return t2 !== e2 && (e2[4] = t2[4], e2[5] = t2[5], e2[6] = t2[6], e2[7] = t2[7], e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15]), e2[0] = o2 * n2 - c2 * r2, e2[1] = s2 * n2 - h2 * r2, e2[2] = a2 * n2 - u2 * r2, e2[3] = l2 * n2 - d2 * r2, e2[8] = o2 * r2 + c2 * n2, e2[9] = s2 * r2 + h2 * n2, e2[10] = a2 * r2 + u2 * n2, e2[11] = l2 * r2 + d2 * n2, e2;
        }, Ec.rotateZ = function(e2, t2, i2) {
          var r2 = Math.sin(i2), n2 = Math.cos(i2), o2 = t2[0], s2 = t2[1], a2 = t2[2], l2 = t2[3], c2 = t2[4], h2 = t2[5], u2 = t2[6], d2 = t2[7];
          return t2 !== e2 && (e2[8] = t2[8], e2[9] = t2[9], e2[10] = t2[10], e2[11] = t2[11], e2[12] = t2[12], e2[13] = t2[13], e2[14] = t2[14], e2[15] = t2[15]), e2[0] = o2 * n2 + c2 * r2, e2[1] = s2 * n2 + h2 * r2, e2[2] = a2 * n2 + u2 * r2, e2[3] = l2 * n2 + d2 * r2, e2[4] = c2 * n2 - o2 * r2, e2[5] = h2 * n2 - s2 * r2, e2[6] = u2 * n2 - a2 * r2, e2[7] = d2 * n2 - l2 * r2, e2;
        }, Ec.fromTranslation = function(e2, t2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = 1, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = 1, e2[11] = 0, e2[12] = t2[0], e2[13] = t2[1], e2[14] = t2[2], e2[15] = 1, e2;
        }, Ec.fromScaling = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = t2[1], e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = t2[2], e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }, Ec.fromRotation = function(e2, t2, i2) {
          var r2, n2, o2, s2 = i2[0], a2 = i2[1], l2 = i2[2], c2 = Math.hypot(s2, a2, l2);
          return c2 < Ac.EPSILON ? null : (s2 *= c2 = 1 / c2, a2 *= c2, l2 *= c2, r2 = Math.sin(t2), n2 = Math.cos(t2), e2[0] = s2 * s2 * (o2 = 1 - n2) + n2, e2[1] = a2 * s2 * o2 + l2 * r2, e2[2] = l2 * s2 * o2 - a2 * r2, e2[3] = 0, e2[4] = s2 * a2 * o2 - l2 * r2, e2[5] = a2 * a2 * o2 + n2, e2[6] = l2 * a2 * o2 + s2 * r2, e2[7] = 0, e2[8] = s2 * l2 * o2 + a2 * r2, e2[9] = a2 * l2 * o2 - s2 * r2, e2[10] = l2 * l2 * o2 + n2, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2);
        }, Ec.fromXRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = r2, e2[6] = i2, e2[7] = 0, e2[8] = 0, e2[9] = -i2, e2[10] = r2, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }, Ec.fromYRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = r2, e2[1] = 0, e2[2] = -i2, e2[3] = 0, e2[4] = 0, e2[5] = 1, e2[6] = 0, e2[7] = 0, e2[8] = i2, e2[9] = 0, e2[10] = r2, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }, Ec.fromZRotation = function(e2, t2) {
          var i2 = Math.sin(t2), r2 = Math.cos(t2);
          return e2[0] = r2, e2[1] = i2, e2[2] = 0, e2[3] = 0, e2[4] = -i2, e2[5] = r2, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = 1, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }, Ec.fromRotationTranslation = zc, Ec.fromQuat2 = function(e2, t2) {
          var i2 = new Ac.ARRAY_TYPE(3), r2 = -t2[0], n2 = -t2[1], o2 = -t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = r2 * r2 + n2 * n2 + o2 * o2 + s2 * s2;
          return u2 > 0 ? (i2[0] = 2 * (a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2) / u2, i2[1] = 2 * (l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2) / u2, i2[2] = 2 * (c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2) / u2) : (i2[0] = 2 * (a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2), i2[1] = 2 * (l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2), i2[2] = 2 * (c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2)), zc(e2, t2, i2), e2;
        }, Ec.getTranslation = function(e2, t2) {
          return e2[0] = t2[12], e2[1] = t2[13], e2[2] = t2[14], e2;
        }, Ec.getScaling = Dc, Ec.getRotation = function(e2, t2) {
          var i2 = new Ac.ARRAY_TYPE(3);
          Dc(i2, t2);
          var r2 = 1 / i2[0], n2 = 1 / i2[1], o2 = 1 / i2[2], s2 = t2[0] * r2, a2 = t2[1] * n2, l2 = t2[2] * o2, c2 = t2[4] * r2, h2 = t2[5] * n2, u2 = t2[6] * o2, d2 = t2[8] * r2, p2 = t2[9] * n2, f2 = t2[10] * o2, m2 = s2 + h2 + f2, _2 = 0;
          return m2 > 0 ? (_2 = 2 * Math.sqrt(m2 + 1), e2[3] = 0.25 * _2, e2[0] = (u2 - p2) / _2, e2[1] = (d2 - l2) / _2, e2[2] = (a2 - c2) / _2) : s2 > h2 && s2 > f2 ? (_2 = 2 * Math.sqrt(1 + s2 - h2 - f2), e2[3] = (u2 - p2) / _2, e2[0] = 0.25 * _2, e2[1] = (a2 + c2) / _2, e2[2] = (d2 + l2) / _2) : h2 > f2 ? (_2 = 2 * Math.sqrt(1 + h2 - s2 - f2), e2[3] = (d2 - l2) / _2, e2[0] = (a2 + c2) / _2, e2[1] = 0.25 * _2, e2[2] = (u2 + p2) / _2) : (_2 = 2 * Math.sqrt(1 + f2 - s2 - h2), e2[3] = (a2 - c2) / _2, e2[0] = (d2 + l2) / _2, e2[1] = (u2 + p2) / _2, e2[2] = 0.25 * _2), e2;
        }, Ec.fromRotationTranslationScale = function(e2, t2, i2, r2) {
          var n2 = t2[0], o2 = t2[1], s2 = t2[2], a2 = t2[3], l2 = n2 + n2, c2 = o2 + o2, h2 = s2 + s2, u2 = n2 * l2, d2 = n2 * c2, p2 = n2 * h2, f2 = o2 * c2, m2 = o2 * h2, _2 = s2 * h2, g2 = a2 * l2, y2 = a2 * c2, x2 = a2 * h2, v2 = r2[0], b2 = r2[1], w2 = r2[2];
          return e2[0] = (1 - (f2 + _2)) * v2, e2[1] = (d2 + x2) * v2, e2[2] = (p2 - y2) * v2, e2[3] = 0, e2[4] = (d2 - x2) * b2, e2[5] = (1 - (u2 + _2)) * b2, e2[6] = (m2 + g2) * b2, e2[7] = 0, e2[8] = (p2 + y2) * w2, e2[9] = (m2 - g2) * w2, e2[10] = (1 - (u2 + f2)) * w2, e2[11] = 0, e2[12] = i2[0], e2[13] = i2[1], e2[14] = i2[2], e2[15] = 1, e2;
        }, Ec.fromRotationTranslationScaleOrigin = function(e2, t2, i2, r2, n2) {
          var o2 = t2[0], s2 = t2[1], a2 = t2[2], l2 = t2[3], c2 = o2 + o2, h2 = s2 + s2, u2 = a2 + a2, d2 = o2 * c2, p2 = o2 * h2, f2 = o2 * u2, m2 = s2 * h2, _2 = s2 * u2, g2 = a2 * u2, y2 = l2 * c2, x2 = l2 * h2, v2 = l2 * u2, b2 = r2[0], w2 = r2[1], T2 = r2[2], E2 = n2[0], M2 = n2[1], A2 = n2[2], S2 = (1 - (m2 + g2)) * b2, I2 = (p2 + v2) * b2, C2 = (f2 - x2) * b2, z2 = (p2 - v2) * w2, D2 = (1 - (d2 + g2)) * w2, P2 = (_2 + y2) * w2, R2 = (f2 + x2) * T2, L2 = (_2 - y2) * T2, k2 = (1 - (d2 + m2)) * T2;
          return e2[0] = S2, e2[1] = I2, e2[2] = C2, e2[3] = 0, e2[4] = z2, e2[5] = D2, e2[6] = P2, e2[7] = 0, e2[8] = R2, e2[9] = L2, e2[10] = k2, e2[11] = 0, e2[12] = i2[0] + E2 - (S2 * E2 + z2 * M2 + R2 * A2), e2[13] = i2[1] + M2 - (I2 * E2 + D2 * M2 + L2 * A2), e2[14] = i2[2] + A2 - (C2 * E2 + P2 * M2 + k2 * A2), e2[15] = 1, e2;
        }, Ec.fromQuat = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2 + i2, a2 = r2 + r2, l2 = n2 + n2, c2 = i2 * s2, h2 = r2 * s2, u2 = r2 * a2, d2 = n2 * s2, p2 = n2 * a2, f2 = n2 * l2, m2 = o2 * s2, _2 = o2 * a2, g2 = o2 * l2;
          return e2[0] = 1 - u2 - f2, e2[1] = h2 + g2, e2[2] = d2 - _2, e2[3] = 0, e2[4] = h2 - g2, e2[5] = 1 - c2 - f2, e2[6] = p2 + m2, e2[7] = 0, e2[8] = d2 + _2, e2[9] = p2 - m2, e2[10] = 1 - c2 - u2, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }, Ec.frustum = function(e2, t2, i2, r2, n2, o2, s2) {
          var a2 = 1 / (i2 - t2), l2 = 1 / (n2 - r2), c2 = 1 / (o2 - s2);
          return e2[0] = 2 * o2 * a2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = 2 * o2 * l2, e2[6] = 0, e2[7] = 0, e2[8] = (i2 + t2) * a2, e2[9] = (n2 + r2) * l2, e2[10] = (s2 + o2) * c2, e2[11] = -1, e2[12] = 0, e2[13] = 0, e2[14] = s2 * o2 * 2 * c2, e2[15] = 0, e2;
        }, Ec.perspectiveNO = Pc, Ec.perspectiveZO = function(e2, t2, i2, r2, n2) {
          var o2, s2 = 1 / Math.tan(t2 / 2);
          return e2[0] = s2 / i2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = s2, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[11] = -1, e2[12] = 0, e2[13] = 0, e2[15] = 0, null != n2 && n2 !== 1 / 0 ? (e2[10] = n2 * (o2 = 1 / (r2 - n2)), e2[14] = n2 * r2 * o2) : (e2[10] = -1, e2[14] = -r2), e2;
        }, Ec.perspectiveFromFieldOfView = function(e2, t2, i2, r2) {
          var n2 = Math.tan(t2.upDegrees * Math.PI / 180), o2 = Math.tan(t2.downDegrees * Math.PI / 180), s2 = Math.tan(t2.leftDegrees * Math.PI / 180), a2 = Math.tan(t2.rightDegrees * Math.PI / 180), l2 = 2 / (s2 + a2), c2 = 2 / (n2 + o2);
          return e2[0] = l2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = c2, e2[6] = 0, e2[7] = 0, e2[8] = -(s2 - a2) * l2 * 0.5, e2[9] = (n2 - o2) * c2 * 0.5, e2[10] = r2 / (i2 - r2), e2[11] = -1, e2[12] = 0, e2[13] = 0, e2[14] = r2 * i2 / (i2 - r2), e2[15] = 0, e2;
        }, Ec.orthoNO = Rc, Ec.orthoZO = function(e2, t2, i2, r2, n2, o2, s2) {
          var a2 = 1 / (t2 - i2), l2 = 1 / (r2 - n2), c2 = 1 / (o2 - s2);
          return e2[0] = -2 * a2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = -2 * l2, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = c2, e2[11] = 0, e2[12] = (t2 + i2) * a2, e2[13] = (n2 + r2) * l2, e2[14] = o2 * c2, e2[15] = 1, e2;
        }, Ec.lookAt = function(e2, t2, i2, r2) {
          var n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2 = t2[0], m2 = t2[1], _2 = t2[2], g2 = r2[0], y2 = r2[1], x2 = r2[2], v2 = i2[0], b2 = i2[1], w2 = i2[2];
          return Math.abs(f2 - v2) < Ac.EPSILON && Math.abs(m2 - b2) < Ac.EPSILON && Math.abs(_2 - w2) < Ac.EPSILON ? Ic(e2) : (h2 = f2 - v2, u2 = m2 - b2, d2 = _2 - w2, n2 = y2 * (d2 *= p2 = 1 / Math.hypot(h2, u2, d2)) - x2 * (u2 *= p2), o2 = x2 * (h2 *= p2) - g2 * d2, s2 = g2 * u2 - y2 * h2, (p2 = Math.hypot(n2, o2, s2)) ? (n2 *= p2 = 1 / p2, o2 *= p2, s2 *= p2) : (n2 = 0, o2 = 0, s2 = 0), a2 = u2 * s2 - d2 * o2, l2 = d2 * n2 - h2 * s2, c2 = h2 * o2 - u2 * n2, (p2 = Math.hypot(a2, l2, c2)) ? (a2 *= p2 = 1 / p2, l2 *= p2, c2 *= p2) : (a2 = 0, l2 = 0, c2 = 0), e2[0] = n2, e2[1] = a2, e2[2] = h2, e2[3] = 0, e2[4] = o2, e2[5] = l2, e2[6] = u2, e2[7] = 0, e2[8] = s2, e2[9] = c2, e2[10] = d2, e2[11] = 0, e2[12] = -(n2 * f2 + o2 * m2 + s2 * _2), e2[13] = -(a2 * f2 + l2 * m2 + c2 * _2), e2[14] = -(h2 * f2 + u2 * m2 + d2 * _2), e2[15] = 1, e2);
        }, Ec.targetTo = function(e2, t2, i2, r2) {
          var n2 = t2[0], o2 = t2[1], s2 = t2[2], a2 = r2[0], l2 = r2[1], c2 = r2[2], h2 = n2 - i2[0], u2 = o2 - i2[1], d2 = s2 - i2[2], p2 = h2 * h2 + u2 * u2 + d2 * d2;
          p2 > 0 && (h2 *= p2 = 1 / Math.sqrt(p2), u2 *= p2, d2 *= p2);
          var f2 = l2 * d2 - c2 * u2, m2 = c2 * h2 - a2 * d2, _2 = a2 * u2 - l2 * h2;
          return (p2 = f2 * f2 + m2 * m2 + _2 * _2) > 0 && (f2 *= p2 = 1 / Math.sqrt(p2), m2 *= p2, _2 *= p2), e2[0] = f2, e2[1] = m2, e2[2] = _2, e2[3] = 0, e2[4] = u2 * _2 - d2 * m2, e2[5] = d2 * f2 - h2 * _2, e2[6] = h2 * m2 - u2 * f2, e2[7] = 0, e2[8] = h2, e2[9] = u2, e2[10] = d2, e2[11] = 0, e2[12] = n2, e2[13] = o2, e2[14] = s2, e2[15] = 1, e2;
        }, Ec.str = function(e2) {
          return "mat4(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ", " + e2[4] + ", " + e2[5] + ", " + e2[6] + ", " + e2[7] + ", " + e2[8] + ", " + e2[9] + ", " + e2[10] + ", " + e2[11] + ", " + e2[12] + ", " + e2[13] + ", " + e2[14] + ", " + e2[15] + ")";
        }, Ec.frob = function(e2) {
          return Math.hypot(e2[0], e2[1], e2[2], e2[3], e2[4], e2[5], e2[6], e2[7], e2[8], e2[9], e2[10], e2[11], e2[12], e2[13], e2[14], e2[15]);
        }, Ec.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2[4] = t2[4] + i2[4], e2[5] = t2[5] + i2[5], e2[6] = t2[6] + i2[6], e2[7] = t2[7] + i2[7], e2[8] = t2[8] + i2[8], e2[9] = t2[9] + i2[9], e2[10] = t2[10] + i2[10], e2[11] = t2[11] + i2[11], e2[12] = t2[12] + i2[12], e2[13] = t2[13] + i2[13], e2[14] = t2[14] + i2[14], e2[15] = t2[15] + i2[15], e2;
        }, Ec.subtract = Lc, Ec.multiplyScalar = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2[4] = t2[4] * i2, e2[5] = t2[5] * i2, e2[6] = t2[6] * i2, e2[7] = t2[7] * i2, e2[8] = t2[8] * i2, e2[9] = t2[9] * i2, e2[10] = t2[10] * i2, e2[11] = t2[11] * i2, e2[12] = t2[12] * i2, e2[13] = t2[13] * i2, e2[14] = t2[14] * i2, e2[15] = t2[15] * i2, e2;
        }, Ec.multiplyScalarAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2[3] = t2[3] + i2[3] * r2, e2[4] = t2[4] + i2[4] * r2, e2[5] = t2[5] + i2[5] * r2, e2[6] = t2[6] + i2[6] * r2, e2[7] = t2[7] + i2[7] * r2, e2[8] = t2[8] + i2[8] * r2, e2[9] = t2[9] + i2[9] * r2, e2[10] = t2[10] + i2[10] * r2, e2[11] = t2[11] + i2[11] * r2, e2[12] = t2[12] + i2[12] * r2, e2[13] = t2[13] + i2[13] * r2, e2[14] = t2[14] + i2[14] * r2, e2[15] = t2[15] + i2[15] * r2, e2;
        }, Ec.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3] && e2[4] === t2[4] && e2[5] === t2[5] && e2[6] === t2[6] && e2[7] === t2[7] && e2[8] === t2[8] && e2[9] === t2[9] && e2[10] === t2[10] && e2[11] === t2[11] && e2[12] === t2[12] && e2[13] === t2[13] && e2[14] === t2[14] && e2[15] === t2[15];
        }, Ec.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = e2[4], a2 = e2[5], l2 = e2[6], c2 = e2[7], h2 = e2[8], u2 = e2[9], d2 = e2[10], p2 = e2[11], f2 = e2[12], m2 = e2[13], _2 = e2[14], g2 = e2[15], y2 = t2[0], x2 = t2[1], v2 = t2[2], b2 = t2[3], w2 = t2[4], T2 = t2[5], E2 = t2[6], M2 = t2[7], A2 = t2[8], S2 = t2[9], I2 = t2[10], C2 = t2[11], z2 = t2[12], D2 = t2[13], P2 = t2[14], R2 = t2[15];
          return Math.abs(i2 - y2) <= Ac.EPSILON * Math.max(1, Math.abs(i2), Math.abs(y2)) && Math.abs(r2 - x2) <= Ac.EPSILON * Math.max(1, Math.abs(r2), Math.abs(x2)) && Math.abs(n2 - v2) <= Ac.EPSILON * Math.max(1, Math.abs(n2), Math.abs(v2)) && Math.abs(o2 - b2) <= Ac.EPSILON * Math.max(1, Math.abs(o2), Math.abs(b2)) && Math.abs(s2 - w2) <= Ac.EPSILON * Math.max(1, Math.abs(s2), Math.abs(w2)) && Math.abs(a2 - T2) <= Ac.EPSILON * Math.max(1, Math.abs(a2), Math.abs(T2)) && Math.abs(l2 - E2) <= Ac.EPSILON * Math.max(1, Math.abs(l2), Math.abs(E2)) && Math.abs(c2 - M2) <= Ac.EPSILON * Math.max(1, Math.abs(c2), Math.abs(M2)) && Math.abs(h2 - A2) <= Ac.EPSILON * Math.max(1, Math.abs(h2), Math.abs(A2)) && Math.abs(u2 - S2) <= Ac.EPSILON * Math.max(1, Math.abs(u2), Math.abs(S2)) && Math.abs(d2 - I2) <= Ac.EPSILON * Math.max(1, Math.abs(d2), Math.abs(I2)) && Math.abs(p2 - C2) <= Ac.EPSILON * Math.max(1, Math.abs(p2), Math.abs(C2)) && Math.abs(f2 - z2) <= Ac.EPSILON * Math.max(1, Math.abs(f2), Math.abs(z2)) && Math.abs(m2 - D2) <= Ac.EPSILON * Math.max(1, Math.abs(m2), Math.abs(D2)) && Math.abs(_2 - P2) <= Ac.EPSILON * Math.max(1, Math.abs(_2), Math.abs(P2)) && Math.abs(g2 - R2) <= Ac.EPSILON * Math.max(1, Math.abs(g2), Math.abs(R2));
        }, Ec.sub = Ec.mul = Ec.ortho = Ec.perspective = void 0;
        var Ac = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== Mc(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = Sc(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function Sc(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (Sc = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function Ic(e2) {
          return e2[0] = 1, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = 1, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = 1, e2[11] = 0, e2[12] = 0, e2[13] = 0, e2[14] = 0, e2[15] = 1, e2;
        }
        function Cc(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = t2[8], d2 = t2[9], p2 = t2[10], f2 = t2[11], m2 = t2[12], _2 = t2[13], g2 = t2[14], y2 = t2[15], x2 = i2[0], v2 = i2[1], b2 = i2[2], w2 = i2[3];
          return e2[0] = x2 * r2 + v2 * a2 + b2 * u2 + w2 * m2, e2[1] = x2 * n2 + v2 * l2 + b2 * d2 + w2 * _2, e2[2] = x2 * o2 + v2 * c2 + b2 * p2 + w2 * g2, e2[3] = x2 * s2 + v2 * h2 + b2 * f2 + w2 * y2, e2[4] = (x2 = i2[4]) * r2 + (v2 = i2[5]) * a2 + (b2 = i2[6]) * u2 + (w2 = i2[7]) * m2, e2[5] = x2 * n2 + v2 * l2 + b2 * d2 + w2 * _2, e2[6] = x2 * o2 + v2 * c2 + b2 * p2 + w2 * g2, e2[7] = x2 * s2 + v2 * h2 + b2 * f2 + w2 * y2, e2[8] = (x2 = i2[8]) * r2 + (v2 = i2[9]) * a2 + (b2 = i2[10]) * u2 + (w2 = i2[11]) * m2, e2[9] = x2 * n2 + v2 * l2 + b2 * d2 + w2 * _2, e2[10] = x2 * o2 + v2 * c2 + b2 * p2 + w2 * g2, e2[11] = x2 * s2 + v2 * h2 + b2 * f2 + w2 * y2, e2[12] = (x2 = i2[12]) * r2 + (v2 = i2[13]) * a2 + (b2 = i2[14]) * u2 + (w2 = i2[15]) * m2, e2[13] = x2 * n2 + v2 * l2 + b2 * d2 + w2 * _2, e2[14] = x2 * o2 + v2 * c2 + b2 * p2 + w2 * g2, e2[15] = x2 * s2 + v2 * h2 + b2 * f2 + w2 * y2, e2;
        }
        function zc(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = r2 + r2, l2 = n2 + n2, c2 = o2 + o2, h2 = r2 * a2, u2 = r2 * l2, d2 = r2 * c2, p2 = n2 * l2, f2 = n2 * c2, m2 = o2 * c2, _2 = s2 * a2, g2 = s2 * l2, y2 = s2 * c2;
          return e2[0] = 1 - (p2 + m2), e2[1] = u2 + y2, e2[2] = d2 - g2, e2[3] = 0, e2[4] = u2 - y2, e2[5] = 1 - (h2 + m2), e2[6] = f2 + _2, e2[7] = 0, e2[8] = d2 + g2, e2[9] = f2 - _2, e2[10] = 1 - (h2 + p2), e2[11] = 0, e2[12] = i2[0], e2[13] = i2[1], e2[14] = i2[2], e2[15] = 1, e2;
        }
        function Dc(e2, t2) {
          var i2 = t2[4], r2 = t2[5], n2 = t2[6], o2 = t2[8], s2 = t2[9], a2 = t2[10];
          return e2[0] = Math.hypot(t2[0], t2[1], t2[2]), e2[1] = Math.hypot(i2, r2, n2), e2[2] = Math.hypot(o2, s2, a2), e2;
        }
        function Pc(e2, t2, i2, r2, n2) {
          var o2, s2 = 1 / Math.tan(t2 / 2);
          return e2[0] = s2 / i2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = s2, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[11] = -1, e2[12] = 0, e2[13] = 0, e2[15] = 0, null != n2 && n2 !== 1 / 0 ? (e2[10] = (n2 + r2) * (o2 = 1 / (r2 - n2)), e2[14] = 2 * n2 * r2 * o2) : (e2[10] = -1, e2[14] = -2 * r2), e2;
        }
        function Rc(e2, t2, i2, r2, n2, o2, s2) {
          var a2 = 1 / (t2 - i2), l2 = 1 / (r2 - n2), c2 = 1 / (o2 - s2);
          return e2[0] = -2 * a2, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2[4] = 0, e2[5] = -2 * l2, e2[6] = 0, e2[7] = 0, e2[8] = 0, e2[9] = 0, e2[10] = 2 * c2, e2[11] = 0, e2[12] = (t2 + i2) * a2, e2[13] = (n2 + r2) * l2, e2[14] = (s2 + o2) * c2, e2[15] = 1, e2;
        }
        function Lc(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2[3] = t2[3] - i2[3], e2[4] = t2[4] - i2[4], e2[5] = t2[5] - i2[5], e2[6] = t2[6] - i2[6], e2[7] = t2[7] - i2[7], e2[8] = t2[8] - i2[8], e2[9] = t2[9] - i2[9], e2[10] = t2[10] - i2[10], e2[11] = t2[11] - i2[11], e2[12] = t2[12] - i2[12], e2[13] = t2[13] - i2[13], e2[14] = t2[14] - i2[14], e2[15] = t2[15] - i2[15], e2;
        }
        Ec.perspective = Pc, Ec.ortho = Rc, Ec.mul = Cc, Ec.sub = Lc;
        var kc = {}, Oc = {};
        function Bc(e2) {
          return Bc = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, Bc(e2);
        }
        Object.defineProperty(Oc, "__esModule", { value: true }), Oc.create = Uc, Oc.clone = function(e2) {
          var t2 = new Fc.ARRAY_TYPE(3);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2;
        }, Oc.length = Vc, Oc.fromValues = function(e2, t2, i2) {
          var r2 = new Fc.ARRAY_TYPE(3);
          return r2[0] = e2, r2[1] = t2, r2[2] = i2, r2;
        }, Oc.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2;
        }, Oc.set = function(e2, t2, i2, r2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2;
        }, Oc.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2;
        }, Oc.subtract = jc, Oc.multiply = Gc, Oc.divide = qc, Oc.ceil = function(e2, t2) {
          return e2[0] = Math.ceil(t2[0]), e2[1] = Math.ceil(t2[1]), e2[2] = Math.ceil(t2[2]), e2;
        }, Oc.floor = function(e2, t2) {
          return e2[0] = Math.floor(t2[0]), e2[1] = Math.floor(t2[1]), e2[2] = Math.floor(t2[2]), e2;
        }, Oc.min = function(e2, t2, i2) {
          return e2[0] = Math.min(t2[0], i2[0]), e2[1] = Math.min(t2[1], i2[1]), e2[2] = Math.min(t2[2], i2[2]), e2;
        }, Oc.max = function(e2, t2, i2) {
          return e2[0] = Math.max(t2[0], i2[0]), e2[1] = Math.max(t2[1], i2[1]), e2[2] = Math.max(t2[2], i2[2]), e2;
        }, Oc.round = function(e2, t2) {
          return e2[0] = Math.round(t2[0]), e2[1] = Math.round(t2[1]), e2[2] = Math.round(t2[2]), e2;
        }, Oc.scale = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2;
        }, Oc.scaleAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2;
        }, Oc.distance = Zc, Oc.squaredDistance = $c, Oc.squaredLength = Hc, Oc.negate = function(e2, t2) {
          return e2[0] = -t2[0], e2[1] = -t2[1], e2[2] = -t2[2], e2;
        }, Oc.inverse = function(e2, t2) {
          return e2[0] = 1 / t2[0], e2[1] = 1 / t2[1], e2[2] = 1 / t2[2], e2;
        }, Oc.normalize = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = i2 * i2 + r2 * r2 + n2 * n2;
          return o2 > 0 && (o2 = 1 / Math.sqrt(o2)), e2[0] = t2[0] * o2, e2[1] = t2[1] * o2, e2[2] = t2[2] * o2, e2;
        }, Oc.dot = Wc, Oc.cross = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = i2[0], a2 = i2[1], l2 = i2[2];
          return e2[0] = n2 * l2 - o2 * a2, e2[1] = o2 * s2 - r2 * l2, e2[2] = r2 * a2 - n2 * s2, e2;
        }, Oc.lerp = function(e2, t2, i2, r2) {
          var n2 = t2[0], o2 = t2[1], s2 = t2[2];
          return e2[0] = n2 + r2 * (i2[0] - n2), e2[1] = o2 + r2 * (i2[1] - o2), e2[2] = s2 + r2 * (i2[2] - s2), e2;
        }, Oc.hermite = function(e2, t2, i2, r2, n2, o2) {
          var s2 = o2 * o2, a2 = s2 * (2 * o2 - 3) + 1, l2 = s2 * (o2 - 2) + o2, c2 = s2 * (o2 - 1), h2 = s2 * (3 - 2 * o2);
          return e2[0] = t2[0] * a2 + i2[0] * l2 + r2[0] * c2 + n2[0] * h2, e2[1] = t2[1] * a2 + i2[1] * l2 + r2[1] * c2 + n2[1] * h2, e2[2] = t2[2] * a2 + i2[2] * l2 + r2[2] * c2 + n2[2] * h2, e2;
        }, Oc.bezier = function(e2, t2, i2, r2, n2, o2) {
          var s2 = 1 - o2, a2 = s2 * s2, l2 = o2 * o2, c2 = a2 * s2, h2 = 3 * o2 * a2, u2 = 3 * l2 * s2, d2 = l2 * o2;
          return e2[0] = t2[0] * c2 + i2[0] * h2 + r2[0] * u2 + n2[0] * d2, e2[1] = t2[1] * c2 + i2[1] * h2 + r2[1] * u2 + n2[1] * d2, e2[2] = t2[2] * c2 + i2[2] * h2 + r2[2] * u2 + n2[2] * d2, e2;
        }, Oc.random = function(e2, t2) {
          t2 = t2 || 1;
          var i2 = 2 * Fc.RANDOM() * Math.PI, r2 = 2 * Fc.RANDOM() - 1, n2 = Math.sqrt(1 - r2 * r2) * t2;
          return e2[0] = Math.cos(i2) * n2, e2[1] = Math.sin(i2) * n2, e2[2] = r2 * t2, e2;
        }, Oc.transformMat4 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = i2[3] * r2 + i2[7] * n2 + i2[11] * o2 + i2[15];
          return e2[0] = (i2[0] * r2 + i2[4] * n2 + i2[8] * o2 + i2[12]) / (s2 = s2 || 1), e2[1] = (i2[1] * r2 + i2[5] * n2 + i2[9] * o2 + i2[13]) / s2, e2[2] = (i2[2] * r2 + i2[6] * n2 + i2[10] * o2 + i2[14]) / s2, e2;
        }, Oc.transformMat3 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2];
          return e2[0] = r2 * i2[0] + n2 * i2[3] + o2 * i2[6], e2[1] = r2 * i2[1] + n2 * i2[4] + o2 * i2[7], e2[2] = r2 * i2[2] + n2 * i2[5] + o2 * i2[8], e2;
        }, Oc.transformQuat = function(e2, t2, i2) {
          var r2 = i2[0], n2 = i2[1], o2 = i2[2], s2 = t2[0], a2 = t2[1], l2 = t2[2], c2 = n2 * l2 - o2 * a2, h2 = o2 * s2 - r2 * l2, u2 = r2 * a2 - n2 * s2, d2 = n2 * u2 - o2 * h2, p2 = o2 * c2 - r2 * u2, f2 = r2 * h2 - n2 * c2, m2 = 2 * i2[3];
          return h2 *= m2, u2 *= m2, p2 *= 2, f2 *= 2, e2[0] = s2 + (c2 *= m2) + (d2 *= 2), e2[1] = a2 + h2 + p2, e2[2] = l2 + u2 + f2, e2;
        }, Oc.rotateX = function(e2, t2, i2, r2) {
          var n2 = [], o2 = [];
          return n2[0] = t2[0] - i2[0], n2[1] = t2[1] - i2[1], n2[2] = t2[2] - i2[2], o2[0] = n2[0], o2[1] = n2[1] * Math.cos(r2) - n2[2] * Math.sin(r2), o2[2] = n2[1] * Math.sin(r2) + n2[2] * Math.cos(r2), e2[0] = o2[0] + i2[0], e2[1] = o2[1] + i2[1], e2[2] = o2[2] + i2[2], e2;
        }, Oc.rotateY = function(e2, t2, i2, r2) {
          var n2 = [], o2 = [];
          return n2[0] = t2[0] - i2[0], n2[1] = t2[1] - i2[1], n2[2] = t2[2] - i2[2], o2[0] = n2[2] * Math.sin(r2) + n2[0] * Math.cos(r2), o2[1] = n2[1], o2[2] = n2[2] * Math.cos(r2) - n2[0] * Math.sin(r2), e2[0] = o2[0] + i2[0], e2[1] = o2[1] + i2[1], e2[2] = o2[2] + i2[2], e2;
        }, Oc.rotateZ = function(e2, t2, i2, r2) {
          var n2 = [], o2 = [];
          return n2[0] = t2[0] - i2[0], n2[1] = t2[1] - i2[1], n2[2] = t2[2] - i2[2], o2[0] = n2[0] * Math.cos(r2) - n2[1] * Math.sin(r2), o2[1] = n2[0] * Math.sin(r2) + n2[1] * Math.cos(r2), o2[2] = n2[2], e2[0] = o2[0] + i2[0], e2[1] = o2[1] + i2[1], e2[2] = o2[2] + i2[2], e2;
        }, Oc.angle = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = t2[0], s2 = t2[1], a2 = t2[2], l2 = Math.sqrt(i2 * i2 + r2 * r2 + n2 * n2) * Math.sqrt(o2 * o2 + s2 * s2 + a2 * a2), c2 = l2 && Wc(e2, t2) / l2;
          return Math.acos(Math.min(Math.max(c2, -1), 1));
        }, Oc.zero = function(e2) {
          return e2[0] = 0, e2[1] = 0, e2[2] = 0, e2;
        }, Oc.str = function(e2) {
          return "vec3(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ")";
        }, Oc.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2];
        }, Oc.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = t2[0], s2 = t2[1], a2 = t2[2];
          return Math.abs(i2 - o2) <= Fc.EPSILON * Math.max(1, Math.abs(i2), Math.abs(o2)) && Math.abs(r2 - s2) <= Fc.EPSILON * Math.max(1, Math.abs(r2), Math.abs(s2)) && Math.abs(n2 - a2) <= Fc.EPSILON * Math.max(1, Math.abs(n2), Math.abs(a2));
        }, Oc.forEach = Oc.sqrLen = Oc.len = Oc.sqrDist = Oc.dist = Oc.div = Oc.mul = Oc.sub = void 0;
        var Fc = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== Bc(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = Nc(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function Nc(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (Nc = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function Uc() {
          var e2 = new Fc.ARRAY_TYPE(3);
          return Fc.ARRAY_TYPE != Float32Array && (e2[0] = 0, e2[1] = 0, e2[2] = 0), e2;
        }
        function Vc(e2) {
          return Math.hypot(e2[0], e2[1], e2[2]);
        }
        function jc(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2;
        }
        function Gc(e2, t2, i2) {
          return e2[0] = t2[0] * i2[0], e2[1] = t2[1] * i2[1], e2[2] = t2[2] * i2[2], e2;
        }
        function qc(e2, t2, i2) {
          return e2[0] = t2[0] / i2[0], e2[1] = t2[1] / i2[1], e2[2] = t2[2] / i2[2], e2;
        }
        function Zc(e2, t2) {
          return Math.hypot(t2[0] - e2[0], t2[1] - e2[1], t2[2] - e2[2]);
        }
        function $c(e2, t2) {
          var i2 = t2[0] - e2[0], r2 = t2[1] - e2[1], n2 = t2[2] - e2[2];
          return i2 * i2 + r2 * r2 + n2 * n2;
        }
        function Hc(e2) {
          var t2 = e2[0], i2 = e2[1], r2 = e2[2];
          return t2 * t2 + i2 * i2 + r2 * r2;
        }
        function Wc(e2, t2) {
          return e2[0] * t2[0] + e2[1] * t2[1] + e2[2] * t2[2];
        }
        Oc.sub = jc, Oc.mul = Gc, Oc.div = qc, Oc.dist = Zc, Oc.sqrDist = $c, Oc.len = Vc, Oc.sqrLen = Hc;
        var Xc, Yc = (Xc = Uc(), function(e2, t2, i2, r2, n2, o2) {
          var s2, a2;
          for (t2 || (t2 = 3), i2 || (i2 = 0), a2 = r2 ? Math.min(r2 * t2 + i2, e2.length) : e2.length, s2 = i2; s2 < a2; s2 += t2)
            Xc[0] = e2[s2], Xc[1] = e2[s2 + 1], Xc[2] = e2[s2 + 2], n2(Xc, Xc, o2), e2[s2] = Xc[0], e2[s2 + 1] = Xc[1], e2[s2 + 2] = Xc[2];
          return e2;
        });
        Oc.forEach = Yc;
        var Kc = {};
        function Jc(e2) {
          return Jc = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, Jc(e2);
        }
        Object.defineProperty(Kc, "__esModule", { value: true }), Kc.create = th, Kc.clone = function(e2) {
          var t2 = new Qc.ARRAY_TYPE(4);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2;
        }, Kc.fromValues = function(e2, t2, i2, r2) {
          var n2 = new Qc.ARRAY_TYPE(4);
          return n2[0] = e2, n2[1] = t2, n2[2] = i2, n2[3] = r2, n2;
        }, Kc.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2;
        }, Kc.set = function(e2, t2, i2, r2, n2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2;
        }, Kc.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2;
        }, Kc.subtract = ih, Kc.multiply = rh, Kc.divide = nh, Kc.ceil = function(e2, t2) {
          return e2[0] = Math.ceil(t2[0]), e2[1] = Math.ceil(t2[1]), e2[2] = Math.ceil(t2[2]), e2[3] = Math.ceil(t2[3]), e2;
        }, Kc.floor = function(e2, t2) {
          return e2[0] = Math.floor(t2[0]), e2[1] = Math.floor(t2[1]), e2[2] = Math.floor(t2[2]), e2[3] = Math.floor(t2[3]), e2;
        }, Kc.min = function(e2, t2, i2) {
          return e2[0] = Math.min(t2[0], i2[0]), e2[1] = Math.min(t2[1], i2[1]), e2[2] = Math.min(t2[2], i2[2]), e2[3] = Math.min(t2[3], i2[3]), e2;
        }, Kc.max = function(e2, t2, i2) {
          return e2[0] = Math.max(t2[0], i2[0]), e2[1] = Math.max(t2[1], i2[1]), e2[2] = Math.max(t2[2], i2[2]), e2[3] = Math.max(t2[3], i2[3]), e2;
        }, Kc.round = function(e2, t2) {
          return e2[0] = Math.round(t2[0]), e2[1] = Math.round(t2[1]), e2[2] = Math.round(t2[2]), e2[3] = Math.round(t2[3]), e2;
        }, Kc.scale = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2;
        }, Kc.scaleAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2[2] = t2[2] + i2[2] * r2, e2[3] = t2[3] + i2[3] * r2, e2;
        }, Kc.distance = oh, Kc.squaredDistance = sh, Kc.length = ah, Kc.squaredLength = lh, Kc.negate = function(e2, t2) {
          return e2[0] = -t2[0], e2[1] = -t2[1], e2[2] = -t2[2], e2[3] = -t2[3], e2;
        }, Kc.inverse = function(e2, t2) {
          return e2[0] = 1 / t2[0], e2[1] = 1 / t2[1], e2[2] = 1 / t2[2], e2[3] = 1 / t2[3], e2;
        }, Kc.normalize = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2 * i2 + r2 * r2 + n2 * n2 + o2 * o2;
          return s2 > 0 && (s2 = 1 / Math.sqrt(s2)), e2[0] = i2 * s2, e2[1] = r2 * s2, e2[2] = n2 * s2, e2[3] = o2 * s2, e2;
        }, Kc.dot = function(e2, t2) {
          return e2[0] * t2[0] + e2[1] * t2[1] + e2[2] * t2[2] + e2[3] * t2[3];
        }, Kc.cross = function(e2, t2, i2, r2) {
          var n2 = i2[0] * r2[1] - i2[1] * r2[0], o2 = i2[0] * r2[2] - i2[2] * r2[0], s2 = i2[0] * r2[3] - i2[3] * r2[0], a2 = i2[1] * r2[2] - i2[2] * r2[1], l2 = i2[1] * r2[3] - i2[3] * r2[1], c2 = i2[2] * r2[3] - i2[3] * r2[2], h2 = t2[0], u2 = t2[1], d2 = t2[2], p2 = t2[3];
          return e2[0] = u2 * c2 - d2 * l2 + p2 * a2, e2[1] = -h2 * c2 + d2 * s2 - p2 * o2, e2[2] = h2 * l2 - u2 * s2 + p2 * n2, e2[3] = -h2 * a2 + u2 * o2 - d2 * n2, e2;
        }, Kc.lerp = function(e2, t2, i2, r2) {
          var n2 = t2[0], o2 = t2[1], s2 = t2[2], a2 = t2[3];
          return e2[0] = n2 + r2 * (i2[0] - n2), e2[1] = o2 + r2 * (i2[1] - o2), e2[2] = s2 + r2 * (i2[2] - s2), e2[3] = a2 + r2 * (i2[3] - a2), e2;
        }, Kc.random = function(e2, t2) {
          var i2, r2, n2, o2, s2, a2;
          t2 = t2 || 1;
          do {
            s2 = (i2 = 2 * Qc.RANDOM() - 1) * i2 + (r2 = 2 * Qc.RANDOM() - 1) * r2;
          } while (s2 >= 1);
          do {
            a2 = (n2 = 2 * Qc.RANDOM() - 1) * n2 + (o2 = 2 * Qc.RANDOM() - 1) * o2;
          } while (a2 >= 1);
          var l2 = Math.sqrt((1 - s2) / a2);
          return e2[0] = t2 * i2, e2[1] = t2 * r2, e2[2] = t2 * n2 * l2, e2[3] = t2 * o2 * l2, e2;
        }, Kc.transformMat4 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3];
          return e2[0] = i2[0] * r2 + i2[4] * n2 + i2[8] * o2 + i2[12] * s2, e2[1] = i2[1] * r2 + i2[5] * n2 + i2[9] * o2 + i2[13] * s2, e2[2] = i2[2] * r2 + i2[6] * n2 + i2[10] * o2 + i2[14] * s2, e2[3] = i2[3] * r2 + i2[7] * n2 + i2[11] * o2 + i2[15] * s2, e2;
        }, Kc.transformQuat = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = i2[0], a2 = i2[1], l2 = i2[2], c2 = i2[3], h2 = c2 * r2 + a2 * o2 - l2 * n2, u2 = c2 * n2 + l2 * r2 - s2 * o2, d2 = c2 * o2 + s2 * n2 - a2 * r2, p2 = -s2 * r2 - a2 * n2 - l2 * o2;
          return e2[0] = h2 * c2 + p2 * -s2 + u2 * -l2 - d2 * -a2, e2[1] = u2 * c2 + p2 * -a2 + d2 * -s2 - h2 * -l2, e2[2] = d2 * c2 + p2 * -l2 + h2 * -a2 - u2 * -s2, e2[3] = t2[3], e2;
        }, Kc.zero = function(e2) {
          return e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 0, e2;
        }, Kc.str = function(e2) {
          return "vec4(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ")";
        }, Kc.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3];
        }, Kc.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = t2[0], a2 = t2[1], l2 = t2[2], c2 = t2[3];
          return Math.abs(i2 - s2) <= Qc.EPSILON * Math.max(1, Math.abs(i2), Math.abs(s2)) && Math.abs(r2 - a2) <= Qc.EPSILON * Math.max(1, Math.abs(r2), Math.abs(a2)) && Math.abs(n2 - l2) <= Qc.EPSILON * Math.max(1, Math.abs(n2), Math.abs(l2)) && Math.abs(o2 - c2) <= Qc.EPSILON * Math.max(1, Math.abs(o2), Math.abs(c2));
        }, Kc.forEach = Kc.sqrLen = Kc.len = Kc.sqrDist = Kc.dist = Kc.div = Kc.mul = Kc.sub = void 0;
        var Qc = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== Jc(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = eh(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function eh(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (eh = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function th() {
          var e2 = new Qc.ARRAY_TYPE(4);
          return Qc.ARRAY_TYPE != Float32Array && (e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 0), e2;
        }
        function ih(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2[2] = t2[2] - i2[2], e2[3] = t2[3] - i2[3], e2;
        }
        function rh(e2, t2, i2) {
          return e2[0] = t2[0] * i2[0], e2[1] = t2[1] * i2[1], e2[2] = t2[2] * i2[2], e2[3] = t2[3] * i2[3], e2;
        }
        function nh(e2, t2, i2) {
          return e2[0] = t2[0] / i2[0], e2[1] = t2[1] / i2[1], e2[2] = t2[2] / i2[2], e2[3] = t2[3] / i2[3], e2;
        }
        function oh(e2, t2) {
          return Math.hypot(t2[0] - e2[0], t2[1] - e2[1], t2[2] - e2[2], t2[3] - e2[3]);
        }
        function sh(e2, t2) {
          var i2 = t2[0] - e2[0], r2 = t2[1] - e2[1], n2 = t2[2] - e2[2], o2 = t2[3] - e2[3];
          return i2 * i2 + r2 * r2 + n2 * n2 + o2 * o2;
        }
        function ah(e2) {
          return Math.hypot(e2[0], e2[1], e2[2], e2[3]);
        }
        function lh(e2) {
          var t2 = e2[0], i2 = e2[1], r2 = e2[2], n2 = e2[3];
          return t2 * t2 + i2 * i2 + r2 * r2 + n2 * n2;
        }
        Kc.sub = ih, Kc.mul = rh, Kc.div = nh, Kc.dist = oh, Kc.sqrDist = sh, Kc.len = ah, Kc.sqrLen = lh;
        var ch = function() {
          var e2 = th();
          return function(t2, i2, r2, n2, o2, s2) {
            var a2, l2;
            for (i2 || (i2 = 4), r2 || (r2 = 0), l2 = n2 ? Math.min(n2 * i2 + r2, t2.length) : t2.length, a2 = r2; a2 < l2; a2 += i2)
              e2[0] = t2[a2], e2[1] = t2[a2 + 1], e2[2] = t2[a2 + 2], e2[3] = t2[a2 + 3], o2(e2, e2, s2), t2[a2] = e2[0], t2[a2 + 1] = e2[1], t2[a2 + 2] = e2[2], t2[a2 + 3] = e2[3];
            return t2;
          };
        }();
        function hh(e2) {
          return hh = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, hh(e2);
        }
        Kc.forEach = ch, Object.defineProperty(kc, "__esModule", { value: true }), kc.create = gh, kc.identity = function(e2) {
          return e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2;
        }, kc.setAxisAngle = yh, kc.getAxisAngle = function(e2, t2) {
          var i2 = 2 * Math.acos(t2[3]), r2 = Math.sin(i2 / 2);
          return r2 > uh.EPSILON ? (e2[0] = t2[0] / r2, e2[1] = t2[1] / r2, e2[2] = t2[2] / r2) : (e2[0] = 1, e2[1] = 0, e2[2] = 0), i2;
        }, kc.getAngle = function(e2, t2) {
          var i2 = Mh(e2, t2);
          return Math.acos(2 * i2 * i2 - 1);
        }, kc.multiply = xh, kc.rotateX = function(e2, t2, i2) {
          i2 *= 0.5;
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = Math.sin(i2), l2 = Math.cos(i2);
          return e2[0] = r2 * l2 + s2 * a2, e2[1] = n2 * l2 + o2 * a2, e2[2] = o2 * l2 - n2 * a2, e2[3] = s2 * l2 - r2 * a2, e2;
        }, kc.rotateY = function(e2, t2, i2) {
          i2 *= 0.5;
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = Math.sin(i2), l2 = Math.cos(i2);
          return e2[0] = r2 * l2 - o2 * a2, e2[1] = n2 * l2 + s2 * a2, e2[2] = o2 * l2 + r2 * a2, e2[3] = s2 * l2 - n2 * a2, e2;
        }, kc.rotateZ = function(e2, t2, i2) {
          i2 *= 0.5;
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = Math.sin(i2), l2 = Math.cos(i2);
          return e2[0] = r2 * l2 + n2 * a2, e2[1] = n2 * l2 - r2 * a2, e2[2] = o2 * l2 + s2 * a2, e2[3] = s2 * l2 - o2 * a2, e2;
        }, kc.calculateW = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2];
          return e2[0] = i2, e2[1] = r2, e2[2] = n2, e2[3] = Math.sqrt(Math.abs(1 - i2 * i2 - r2 * r2 - n2 * n2)), e2;
        }, kc.exp = vh, kc.ln = bh, kc.pow = function(e2, t2, i2) {
          return bh(e2, t2), Eh(e2, e2, i2), vh(e2, e2), e2;
        }, kc.slerp = wh, kc.random = function(e2) {
          var t2 = uh.RANDOM(), i2 = uh.RANDOM(), r2 = uh.RANDOM(), n2 = Math.sqrt(1 - t2), o2 = Math.sqrt(t2);
          return e2[0] = n2 * Math.sin(2 * Math.PI * i2), e2[1] = n2 * Math.cos(2 * Math.PI * i2), e2[2] = o2 * Math.sin(2 * Math.PI * r2), e2[3] = o2 * Math.cos(2 * Math.PI * r2), e2;
        }, kc.invert = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = i2 * i2 + r2 * r2 + n2 * n2 + o2 * o2, a2 = s2 ? 1 / s2 : 0;
          return e2[0] = -i2 * a2, e2[1] = -r2 * a2, e2[2] = -n2 * a2, e2[3] = o2 * a2, e2;
        }, kc.conjugate = function(e2, t2) {
          return e2[0] = -t2[0], e2[1] = -t2[1], e2[2] = -t2[2], e2[3] = t2[3], e2;
        }, kc.fromMat3 = Th, kc.fromEuler = function(e2, t2, i2, r2) {
          var n2 = 0.5 * Math.PI / 180;
          t2 *= n2, i2 *= n2, r2 *= n2;
          var o2 = Math.sin(t2), s2 = Math.cos(t2), a2 = Math.sin(i2), l2 = Math.cos(i2), c2 = Math.sin(r2), h2 = Math.cos(r2);
          return e2[0] = o2 * l2 * h2 - s2 * a2 * c2, e2[1] = s2 * a2 * h2 + o2 * l2 * c2, e2[2] = s2 * l2 * c2 - o2 * a2 * h2, e2[3] = s2 * l2 * h2 + o2 * a2 * c2, e2;
        }, kc.str = function(e2) {
          return "quat(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ")";
        }, kc.setAxes = kc.sqlerp = kc.rotationTo = kc.equals = kc.exactEquals = kc.normalize = kc.sqrLen = kc.squaredLength = kc.len = kc.length = kc.lerp = kc.dot = kc.scale = kc.mul = kc.add = kc.set = kc.copy = kc.fromValues = kc.clone = void 0;
        var uh = _h(tc), dh = _h(yc), ph = _h(Oc), fh = _h(Kc);
        function mh(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (mh = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function _h(e2, t2) {
          if (!t2 && e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== hh(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = mh(t2);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }
        function gh() {
          var e2 = new uh.ARRAY_TYPE(4);
          return uh.ARRAY_TYPE != Float32Array && (e2[0] = 0, e2[1] = 0, e2[2] = 0), e2[3] = 1, e2;
        }
        function yh(e2, t2, i2) {
          i2 *= 0.5;
          var r2 = Math.sin(i2);
          return e2[0] = r2 * t2[0], e2[1] = r2 * t2[1], e2[2] = r2 * t2[2], e2[3] = Math.cos(i2), e2;
        }
        function xh(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = i2[0], l2 = i2[1], c2 = i2[2], h2 = i2[3];
          return e2[0] = r2 * h2 + s2 * a2 + n2 * c2 - o2 * l2, e2[1] = n2 * h2 + s2 * l2 + o2 * a2 - r2 * c2, e2[2] = o2 * h2 + s2 * c2 + r2 * l2 - n2 * a2, e2[3] = s2 * h2 - r2 * a2 - n2 * l2 - o2 * c2, e2;
        }
        function vh(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = Math.sqrt(i2 * i2 + r2 * r2 + n2 * n2), a2 = Math.exp(o2), l2 = s2 > 0 ? a2 * Math.sin(s2) / s2 : 0;
          return e2[0] = i2 * l2, e2[1] = r2 * l2, e2[2] = n2 * l2, e2[3] = a2 * Math.cos(s2), e2;
        }
        function bh(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = t2[2], o2 = t2[3], s2 = Math.sqrt(i2 * i2 + r2 * r2 + n2 * n2), a2 = s2 > 0 ? Math.atan2(s2, o2) / s2 : 0;
          return e2[0] = i2 * a2, e2[1] = r2 * a2, e2[2] = n2 * a2, e2[3] = 0.5 * Math.log(i2 * i2 + r2 * r2 + n2 * n2 + o2 * o2), e2;
        }
        function wh(e2, t2, i2, r2) {
          var n2, o2, s2, a2, l2, c2 = t2[0], h2 = t2[1], u2 = t2[2], d2 = t2[3], p2 = i2[0], f2 = i2[1], m2 = i2[2], _2 = i2[3];
          return (o2 = c2 * p2 + h2 * f2 + u2 * m2 + d2 * _2) < 0 && (o2 = -o2, p2 = -p2, f2 = -f2, m2 = -m2, _2 = -_2), 1 - o2 > uh.EPSILON ? (n2 = Math.acos(o2), s2 = Math.sin(n2), a2 = Math.sin((1 - r2) * n2) / s2, l2 = Math.sin(r2 * n2) / s2) : (a2 = 1 - r2, l2 = r2), e2[0] = a2 * c2 + l2 * p2, e2[1] = a2 * h2 + l2 * f2, e2[2] = a2 * u2 + l2 * m2, e2[3] = a2 * d2 + l2 * _2, e2;
        }
        function Th(e2, t2) {
          var i2, r2 = t2[0] + t2[4] + t2[8];
          if (r2 > 0)
            i2 = Math.sqrt(r2 + 1), e2[3] = 0.5 * i2, e2[0] = (t2[5] - t2[7]) * (i2 = 0.5 / i2), e2[1] = (t2[6] - t2[2]) * i2, e2[2] = (t2[1] - t2[3]) * i2;
          else {
            var n2 = 0;
            t2[4] > t2[0] && (n2 = 1), t2[8] > t2[3 * n2 + n2] && (n2 = 2);
            var o2 = (n2 + 1) % 3, s2 = (n2 + 2) % 3;
            i2 = Math.sqrt(t2[3 * n2 + n2] - t2[3 * o2 + o2] - t2[3 * s2 + s2] + 1), e2[n2] = 0.5 * i2, e2[3] = (t2[3 * o2 + s2] - t2[3 * s2 + o2]) * (i2 = 0.5 / i2), e2[o2] = (t2[3 * o2 + n2] + t2[3 * n2 + o2]) * i2, e2[s2] = (t2[3 * s2 + n2] + t2[3 * n2 + s2]) * i2;
          }
          return e2;
        }
        kc.clone = fh.clone, kc.fromValues = fh.fromValues, kc.copy = fh.copy, kc.set = fh.set, kc.add = fh.add, kc.mul = xh;
        var Eh = fh.scale;
        kc.scale = Eh;
        var Mh = fh.dot;
        kc.dot = Mh, kc.lerp = fh.lerp;
        var Ah = fh.length;
        kc.length = Ah, kc.len = Ah;
        var Sh = fh.squaredLength;
        kc.squaredLength = Sh, kc.sqrLen = Sh;
        var Ih = fh.normalize;
        kc.normalize = Ih, kc.exactEquals = fh.exactEquals, kc.equals = fh.equals;
        var Ch, zh, Dh, Ph = (Ch = ph.create(), zh = ph.fromValues(1, 0, 0), Dh = ph.fromValues(0, 1, 0), function(e2, t2, i2) {
          var r2 = ph.dot(t2, i2);
          return r2 < -0.999999 ? (ph.cross(Ch, zh, t2), ph.len(Ch) < 1e-6 && ph.cross(Ch, Dh, t2), ph.normalize(Ch, Ch), yh(e2, Ch, Math.PI), e2) : r2 > 0.999999 ? (e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2) : (ph.cross(Ch, t2, i2), e2[0] = Ch[0], e2[1] = Ch[1], e2[2] = Ch[2], e2[3] = 1 + r2, Ih(e2, e2));
        });
        kc.rotationTo = Ph;
        var Rh, Lh, kh = (Rh = gh(), Lh = gh(), function(e2, t2, i2, r2, n2, o2) {
          return wh(Rh, t2, n2, o2), wh(Lh, i2, r2, o2), wh(e2, Rh, Lh, 2 * o2 * (1 - o2)), e2;
        });
        kc.sqlerp = kh;
        var Oh, Bh = (Oh = dh.create(), function(e2, t2, i2, r2) {
          return Oh[0] = i2[0], Oh[3] = i2[1], Oh[6] = i2[2], Oh[1] = r2[0], Oh[4] = r2[1], Oh[7] = r2[2], Oh[2] = -t2[0], Oh[5] = -t2[1], Oh[8] = -t2[2], Ih(e2, Th(e2, Oh));
        });
        kc.setAxes = Bh;
        var Fh = {};
        function Nh(e2) {
          return Nh = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, Nh(e2);
        }
        Object.defineProperty(Fh, "__esModule", { value: true }), Fh.create = function() {
          var e2 = new Uh.ARRAY_TYPE(8);
          return Uh.ARRAY_TYPE != Float32Array && (e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[4] = 0, e2[5] = 0, e2[6] = 0, e2[7] = 0), e2[3] = 1, e2;
        }, Fh.clone = function(e2) {
          var t2 = new Uh.ARRAY_TYPE(8);
          return t2[0] = e2[0], t2[1] = e2[1], t2[2] = e2[2], t2[3] = e2[3], t2[4] = e2[4], t2[5] = e2[5], t2[6] = e2[6], t2[7] = e2[7], t2;
        }, Fh.fromValues = function(e2, t2, i2, r2, n2, o2, s2, a2) {
          var l2 = new Uh.ARRAY_TYPE(8);
          return l2[0] = e2, l2[1] = t2, l2[2] = i2, l2[3] = r2, l2[4] = n2, l2[5] = o2, l2[6] = s2, l2[7] = a2, l2;
        }, Fh.fromRotationTranslationValues = function(e2, t2, i2, r2, n2, o2, s2) {
          var a2 = new Uh.ARRAY_TYPE(8);
          a2[0] = e2, a2[1] = t2, a2[2] = i2, a2[3] = r2;
          var l2 = 0.5 * n2, c2 = 0.5 * o2, h2 = 0.5 * s2;
          return a2[4] = l2 * r2 + c2 * i2 - h2 * t2, a2[5] = c2 * r2 + h2 * e2 - l2 * i2, a2[6] = h2 * r2 + l2 * t2 - c2 * e2, a2[7] = -l2 * e2 - c2 * t2 - h2 * i2, a2;
        }, Fh.fromRotationTranslation = Zh, Fh.fromTranslation = function(e2, t2) {
          return e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2[4] = 0.5 * t2[0], e2[5] = 0.5 * t2[1], e2[6] = 0.5 * t2[2], e2[7] = 0, e2;
        }, Fh.fromRotation = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[4] = 0, e2[5] = 0, e2[6] = 0, e2[7] = 0, e2;
        }, Fh.fromMat4 = function(e2, t2) {
          var i2 = Vh.create();
          jh.getRotation(i2, t2);
          var r2 = new Uh.ARRAY_TYPE(3);
          return jh.getTranslation(r2, t2), Zh(e2, i2, r2), e2;
        }, Fh.copy = $h, Fh.identity = function(e2) {
          return e2[0] = 0, e2[1] = 0, e2[2] = 0, e2[3] = 1, e2[4] = 0, e2[5] = 0, e2[6] = 0, e2[7] = 0, e2;
        }, Fh.set = function(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          return e2[0] = t2, e2[1] = i2, e2[2] = r2, e2[3] = n2, e2[4] = o2, e2[5] = s2, e2[6] = a2, e2[7] = l2, e2;
        }, Fh.getDual = function(e2, t2) {
          return e2[0] = t2[4], e2[1] = t2[5], e2[2] = t2[6], e2[3] = t2[7], e2;
        }, Fh.setDual = function(e2, t2) {
          return e2[4] = t2[0], e2[5] = t2[1], e2[6] = t2[2], e2[7] = t2[3], e2;
        }, Fh.getTranslation = function(e2, t2) {
          var i2 = t2[4], r2 = t2[5], n2 = t2[6], o2 = t2[7], s2 = -t2[0], a2 = -t2[1], l2 = -t2[2], c2 = t2[3];
          return e2[0] = 2 * (i2 * c2 + o2 * s2 + r2 * l2 - n2 * a2), e2[1] = 2 * (r2 * c2 + o2 * a2 + n2 * s2 - i2 * l2), e2[2] = 2 * (n2 * c2 + o2 * l2 + i2 * a2 - r2 * s2), e2;
        }, Fh.translate = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = 0.5 * i2[0], l2 = 0.5 * i2[1], c2 = 0.5 * i2[2], h2 = t2[4], u2 = t2[5], d2 = t2[6], p2 = t2[7];
          return e2[0] = r2, e2[1] = n2, e2[2] = o2, e2[3] = s2, e2[4] = s2 * a2 + n2 * c2 - o2 * l2 + h2, e2[5] = s2 * l2 + o2 * a2 - r2 * c2 + u2, e2[6] = s2 * c2 + r2 * l2 - n2 * a2 + d2, e2[7] = -r2 * a2 - n2 * l2 - o2 * c2 + p2, e2;
        }, Fh.rotateX = function(e2, t2, i2) {
          var r2 = -t2[0], n2 = -t2[1], o2 = -t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2, d2 = l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2, p2 = c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2, f2 = h2 * s2 - a2 * r2 - l2 * n2 - c2 * o2;
          return Vh.rotateX(e2, t2, i2), e2[4] = u2 * (s2 = e2[3]) + f2 * (r2 = e2[0]) + d2 * (o2 = e2[2]) - p2 * (n2 = e2[1]), e2[5] = d2 * s2 + f2 * n2 + p2 * r2 - u2 * o2, e2[6] = p2 * s2 + f2 * o2 + u2 * n2 - d2 * r2, e2[7] = f2 * s2 - u2 * r2 - d2 * n2 - p2 * o2, e2;
        }, Fh.rotateY = function(e2, t2, i2) {
          var r2 = -t2[0], n2 = -t2[1], o2 = -t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2, d2 = l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2, p2 = c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2, f2 = h2 * s2 - a2 * r2 - l2 * n2 - c2 * o2;
          return Vh.rotateY(e2, t2, i2), e2[4] = u2 * (s2 = e2[3]) + f2 * (r2 = e2[0]) + d2 * (o2 = e2[2]) - p2 * (n2 = e2[1]), e2[5] = d2 * s2 + f2 * n2 + p2 * r2 - u2 * o2, e2[6] = p2 * s2 + f2 * o2 + u2 * n2 - d2 * r2, e2[7] = f2 * s2 - u2 * r2 - d2 * n2 - p2 * o2, e2;
        }, Fh.rotateZ = function(e2, t2, i2) {
          var r2 = -t2[0], n2 = -t2[1], o2 = -t2[2], s2 = t2[3], a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2, d2 = l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2, p2 = c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2, f2 = h2 * s2 - a2 * r2 - l2 * n2 - c2 * o2;
          return Vh.rotateZ(e2, t2, i2), e2[4] = u2 * (s2 = e2[3]) + f2 * (r2 = e2[0]) + d2 * (o2 = e2[2]) - p2 * (n2 = e2[1]), e2[5] = d2 * s2 + f2 * n2 + p2 * r2 - u2 * o2, e2[6] = p2 * s2 + f2 * o2 + u2 * n2 - d2 * r2, e2[7] = f2 * s2 - u2 * r2 - d2 * n2 - p2 * o2, e2;
        }, Fh.rotateByQuatAppend = function(e2, t2, i2) {
          var r2 = i2[0], n2 = i2[1], o2 = i2[2], s2 = i2[3], a2 = t2[0], l2 = t2[1], c2 = t2[2], h2 = t2[3];
          return e2[0] = a2 * s2 + h2 * r2 + l2 * o2 - c2 * n2, e2[1] = l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2, e2[2] = c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2, e2[3] = h2 * s2 - a2 * r2 - l2 * n2 - c2 * o2, e2[4] = (a2 = t2[4]) * s2 + (h2 = t2[7]) * r2 + (l2 = t2[5]) * o2 - (c2 = t2[6]) * n2, e2[5] = l2 * s2 + h2 * n2 + c2 * r2 - a2 * o2, e2[6] = c2 * s2 + h2 * o2 + a2 * n2 - l2 * r2, e2[7] = h2 * s2 - a2 * r2 - l2 * n2 - c2 * o2, e2;
        }, Fh.rotateByQuatPrepend = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = i2[0], l2 = i2[1], c2 = i2[2], h2 = i2[3];
          return e2[0] = r2 * h2 + s2 * a2 + n2 * c2 - o2 * l2, e2[1] = n2 * h2 + s2 * l2 + o2 * a2 - r2 * c2, e2[2] = o2 * h2 + s2 * c2 + r2 * l2 - n2 * a2, e2[3] = s2 * h2 - r2 * a2 - n2 * l2 - o2 * c2, e2[4] = r2 * (h2 = i2[7]) + s2 * (a2 = i2[4]) + n2 * (c2 = i2[6]) - o2 * (l2 = i2[5]), e2[5] = n2 * h2 + s2 * l2 + o2 * a2 - r2 * c2, e2[6] = o2 * h2 + s2 * c2 + r2 * l2 - n2 * a2, e2[7] = s2 * h2 - r2 * a2 - n2 * l2 - o2 * c2, e2;
        }, Fh.rotateAroundAxis = function(e2, t2, i2, r2) {
          if (Math.abs(r2) < Uh.EPSILON)
            return $h(e2, t2);
          var n2 = Math.hypot(i2[0], i2[1], i2[2]);
          r2 *= 0.5;
          var o2 = Math.sin(r2), s2 = o2 * i2[0] / n2, a2 = o2 * i2[1] / n2, l2 = o2 * i2[2] / n2, c2 = Math.cos(r2), h2 = t2[0], u2 = t2[1], d2 = t2[2], p2 = t2[3];
          e2[0] = h2 * c2 + p2 * s2 + u2 * l2 - d2 * a2, e2[1] = u2 * c2 + p2 * a2 + d2 * s2 - h2 * l2, e2[2] = d2 * c2 + p2 * l2 + h2 * a2 - u2 * s2, e2[3] = p2 * c2 - h2 * s2 - u2 * a2 - d2 * l2;
          var f2 = t2[4], m2 = t2[5], _2 = t2[6], g2 = t2[7];
          return e2[4] = f2 * c2 + g2 * s2 + m2 * l2 - _2 * a2, e2[5] = m2 * c2 + g2 * a2 + _2 * s2 - f2 * l2, e2[6] = _2 * c2 + g2 * l2 + f2 * a2 - m2 * s2, e2[7] = g2 * c2 - f2 * s2 - m2 * a2 - _2 * l2, e2;
        }, Fh.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2[2] = t2[2] + i2[2], e2[3] = t2[3] + i2[3], e2[4] = t2[4] + i2[4], e2[5] = t2[5] + i2[5], e2[6] = t2[6] + i2[6], e2[7] = t2[7] + i2[7], e2;
        }, Fh.multiply = Hh, Fh.scale = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2[2] = t2[2] * i2, e2[3] = t2[3] * i2, e2[4] = t2[4] * i2, e2[5] = t2[5] * i2, e2[6] = t2[6] * i2, e2[7] = t2[7] * i2, e2;
        }, Fh.lerp = function(e2, t2, i2, r2) {
          var n2 = 1 - r2;
          return Wh(t2, i2) < 0 && (r2 = -r2), e2[0] = t2[0] * n2 + i2[0] * r2, e2[1] = t2[1] * n2 + i2[1] * r2, e2[2] = t2[2] * n2 + i2[2] * r2, e2[3] = t2[3] * n2 + i2[3] * r2, e2[4] = t2[4] * n2 + i2[4] * r2, e2[5] = t2[5] * n2 + i2[5] * r2, e2[6] = t2[6] * n2 + i2[6] * r2, e2[7] = t2[7] * n2 + i2[7] * r2, e2;
        }, Fh.invert = function(e2, t2) {
          var i2 = Yh(t2);
          return e2[0] = -t2[0] / i2, e2[1] = -t2[1] / i2, e2[2] = -t2[2] / i2, e2[3] = t2[3] / i2, e2[4] = -t2[4] / i2, e2[5] = -t2[5] / i2, e2[6] = -t2[6] / i2, e2[7] = t2[7] / i2, e2;
        }, Fh.conjugate = function(e2, t2) {
          return e2[0] = -t2[0], e2[1] = -t2[1], e2[2] = -t2[2], e2[3] = t2[3], e2[4] = -t2[4], e2[5] = -t2[5], e2[6] = -t2[6], e2[7] = t2[7], e2;
        }, Fh.normalize = function(e2, t2) {
          var i2 = Yh(t2);
          if (i2 > 0) {
            i2 = Math.sqrt(i2);
            var r2 = t2[0] / i2, n2 = t2[1] / i2, o2 = t2[2] / i2, s2 = t2[3] / i2, a2 = t2[4], l2 = t2[5], c2 = t2[6], h2 = t2[7], u2 = r2 * a2 + n2 * l2 + o2 * c2 + s2 * h2;
            e2[0] = r2, e2[1] = n2, e2[2] = o2, e2[3] = s2, e2[4] = (a2 - r2 * u2) / i2, e2[5] = (l2 - n2 * u2) / i2, e2[6] = (c2 - o2 * u2) / i2, e2[7] = (h2 - s2 * u2) / i2;
          }
          return e2;
        }, Fh.str = function(e2) {
          return "quat2(" + e2[0] + ", " + e2[1] + ", " + e2[2] + ", " + e2[3] + ", " + e2[4] + ", " + e2[5] + ", " + e2[6] + ", " + e2[7] + ")";
        }, Fh.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1] && e2[2] === t2[2] && e2[3] === t2[3] && e2[4] === t2[4] && e2[5] === t2[5] && e2[6] === t2[6] && e2[7] === t2[7];
        }, Fh.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = e2[2], o2 = e2[3], s2 = e2[4], a2 = e2[5], l2 = e2[6], c2 = e2[7], h2 = t2[0], u2 = t2[1], d2 = t2[2], p2 = t2[3], f2 = t2[4], m2 = t2[5], _2 = t2[6], g2 = t2[7];
          return Math.abs(i2 - h2) <= Uh.EPSILON * Math.max(1, Math.abs(i2), Math.abs(h2)) && Math.abs(r2 - u2) <= Uh.EPSILON * Math.max(1, Math.abs(r2), Math.abs(u2)) && Math.abs(n2 - d2) <= Uh.EPSILON * Math.max(1, Math.abs(n2), Math.abs(d2)) && Math.abs(o2 - p2) <= Uh.EPSILON * Math.max(1, Math.abs(o2), Math.abs(p2)) && Math.abs(s2 - f2) <= Uh.EPSILON * Math.max(1, Math.abs(s2), Math.abs(f2)) && Math.abs(a2 - m2) <= Uh.EPSILON * Math.max(1, Math.abs(a2), Math.abs(m2)) && Math.abs(l2 - _2) <= Uh.EPSILON * Math.max(1, Math.abs(l2), Math.abs(_2)) && Math.abs(c2 - g2) <= Uh.EPSILON * Math.max(1, Math.abs(c2), Math.abs(g2));
        }, Fh.sqrLen = Fh.squaredLength = Fh.len = Fh.length = Fh.dot = Fh.mul = Fh.setReal = Fh.getReal = void 0;
        var Uh = qh(tc), Vh = qh(kc), jh = qh(Ec);
        function Gh(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (Gh = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function qh(e2, t2) {
          if (!t2 && e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== Nh(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = Gh(t2);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }
        function Zh(e2, t2, i2) {
          var r2 = 0.5 * i2[0], n2 = 0.5 * i2[1], o2 = 0.5 * i2[2], s2 = t2[0], a2 = t2[1], l2 = t2[2], c2 = t2[3];
          return e2[0] = s2, e2[1] = a2, e2[2] = l2, e2[3] = c2, e2[4] = r2 * c2 + n2 * l2 - o2 * a2, e2[5] = n2 * c2 + o2 * s2 - r2 * l2, e2[6] = o2 * c2 + r2 * a2 - n2 * s2, e2[7] = -r2 * s2 - n2 * a2 - o2 * l2, e2;
        }
        function $h(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2[2] = t2[2], e2[3] = t2[3], e2[4] = t2[4], e2[5] = t2[5], e2[6] = t2[6], e2[7] = t2[7], e2;
        }
        function Hh(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1], o2 = t2[2], s2 = t2[3], a2 = i2[4], l2 = i2[5], c2 = i2[6], h2 = i2[7], u2 = t2[4], d2 = t2[5], p2 = t2[6], f2 = t2[7], m2 = i2[0], _2 = i2[1], g2 = i2[2], y2 = i2[3];
          return e2[0] = r2 * y2 + s2 * m2 + n2 * g2 - o2 * _2, e2[1] = n2 * y2 + s2 * _2 + o2 * m2 - r2 * g2, e2[2] = o2 * y2 + s2 * g2 + r2 * _2 - n2 * m2, e2[3] = s2 * y2 - r2 * m2 - n2 * _2 - o2 * g2, e2[4] = r2 * h2 + s2 * a2 + n2 * c2 - o2 * l2 + u2 * y2 + f2 * m2 + d2 * g2 - p2 * _2, e2[5] = n2 * h2 + s2 * l2 + o2 * a2 - r2 * c2 + d2 * y2 + f2 * _2 + p2 * m2 - u2 * g2, e2[6] = o2 * h2 + s2 * c2 + r2 * l2 - n2 * a2 + p2 * y2 + f2 * g2 + u2 * _2 - d2 * m2, e2[7] = s2 * h2 - r2 * a2 - n2 * l2 - o2 * c2 + f2 * y2 - u2 * m2 - d2 * _2 - p2 * g2, e2;
        }
        Fh.getReal = Vh.copy, Fh.setReal = Vh.copy, Fh.mul = Hh;
        var Wh = Vh.dot;
        Fh.dot = Wh;
        var Xh = Vh.length;
        Fh.length = Xh, Fh.len = Xh;
        var Yh = Vh.squaredLength;
        Fh.squaredLength = Yh, Fh.sqrLen = Yh;
        var Kh = {};
        function Jh(e2) {
          return Jh = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, Jh(e2);
        }
        Object.defineProperty(Kh, "__esModule", { value: true }), Kh.create = tu, Kh.clone = function(e2) {
          var t2 = new Qh.ARRAY_TYPE(2);
          return t2[0] = e2[0], t2[1] = e2[1], t2;
        }, Kh.fromValues = function(e2, t2) {
          var i2 = new Qh.ARRAY_TYPE(2);
          return i2[0] = e2, i2[1] = t2, i2;
        }, Kh.copy = function(e2, t2) {
          return e2[0] = t2[0], e2[1] = t2[1], e2;
        }, Kh.set = function(e2, t2, i2) {
          return e2[0] = t2, e2[1] = i2, e2;
        }, Kh.add = function(e2, t2, i2) {
          return e2[0] = t2[0] + i2[0], e2[1] = t2[1] + i2[1], e2;
        }, Kh.subtract = iu, Kh.multiply = ru, Kh.divide = nu, Kh.ceil = function(e2, t2) {
          return e2[0] = Math.ceil(t2[0]), e2[1] = Math.ceil(t2[1]), e2;
        }, Kh.floor = function(e2, t2) {
          return e2[0] = Math.floor(t2[0]), e2[1] = Math.floor(t2[1]), e2;
        }, Kh.min = function(e2, t2, i2) {
          return e2[0] = Math.min(t2[0], i2[0]), e2[1] = Math.min(t2[1], i2[1]), e2;
        }, Kh.max = function(e2, t2, i2) {
          return e2[0] = Math.max(t2[0], i2[0]), e2[1] = Math.max(t2[1], i2[1]), e2;
        }, Kh.round = function(e2, t2) {
          return e2[0] = Math.round(t2[0]), e2[1] = Math.round(t2[1]), e2;
        }, Kh.scale = function(e2, t2, i2) {
          return e2[0] = t2[0] * i2, e2[1] = t2[1] * i2, e2;
        }, Kh.scaleAndAdd = function(e2, t2, i2, r2) {
          return e2[0] = t2[0] + i2[0] * r2, e2[1] = t2[1] + i2[1] * r2, e2;
        }, Kh.distance = ou, Kh.squaredDistance = su, Kh.length = au, Kh.squaredLength = lu, Kh.negate = function(e2, t2) {
          return e2[0] = -t2[0], e2[1] = -t2[1], e2;
        }, Kh.inverse = function(e2, t2) {
          return e2[0] = 1 / t2[0], e2[1] = 1 / t2[1], e2;
        }, Kh.normalize = function(e2, t2) {
          var i2 = t2[0], r2 = t2[1], n2 = i2 * i2 + r2 * r2;
          return n2 > 0 && (n2 = 1 / Math.sqrt(n2)), e2[0] = t2[0] * n2, e2[1] = t2[1] * n2, e2;
        }, Kh.dot = function(e2, t2) {
          return e2[0] * t2[0] + e2[1] * t2[1];
        }, Kh.cross = function(e2, t2, i2) {
          var r2 = t2[0] * i2[1] - t2[1] * i2[0];
          return e2[0] = e2[1] = 0, e2[2] = r2, e2;
        }, Kh.lerp = function(e2, t2, i2, r2) {
          var n2 = t2[0], o2 = t2[1];
          return e2[0] = n2 + r2 * (i2[0] - n2), e2[1] = o2 + r2 * (i2[1] - o2), e2;
        }, Kh.random = function(e2, t2) {
          t2 = t2 || 1;
          var i2 = 2 * Qh.RANDOM() * Math.PI;
          return e2[0] = Math.cos(i2) * t2, e2[1] = Math.sin(i2) * t2, e2;
        }, Kh.transformMat2 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1];
          return e2[0] = i2[0] * r2 + i2[2] * n2, e2[1] = i2[1] * r2 + i2[3] * n2, e2;
        }, Kh.transformMat2d = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1];
          return e2[0] = i2[0] * r2 + i2[2] * n2 + i2[4], e2[1] = i2[1] * r2 + i2[3] * n2 + i2[5], e2;
        }, Kh.transformMat3 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1];
          return e2[0] = i2[0] * r2 + i2[3] * n2 + i2[6], e2[1] = i2[1] * r2 + i2[4] * n2 + i2[7], e2;
        }, Kh.transformMat4 = function(e2, t2, i2) {
          var r2 = t2[0], n2 = t2[1];
          return e2[0] = i2[0] * r2 + i2[4] * n2 + i2[12], e2[1] = i2[1] * r2 + i2[5] * n2 + i2[13], e2;
        }, Kh.rotate = function(e2, t2, i2, r2) {
          var n2 = t2[0] - i2[0], o2 = t2[1] - i2[1], s2 = Math.sin(r2), a2 = Math.cos(r2);
          return e2[0] = n2 * a2 - o2 * s2 + i2[0], e2[1] = n2 * s2 + o2 * a2 + i2[1], e2;
        }, Kh.angle = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = t2[0], o2 = t2[1], s2 = Math.sqrt(i2 * i2 + r2 * r2) * Math.sqrt(n2 * n2 + o2 * o2);
          return Math.acos(Math.min(Math.max(s2 && (i2 * n2 + r2 * o2) / s2, -1), 1));
        }, Kh.zero = function(e2) {
          return e2[0] = 0, e2[1] = 0, e2;
        }, Kh.str = function(e2) {
          return "vec2(" + e2[0] + ", " + e2[1] + ")";
        }, Kh.exactEquals = function(e2, t2) {
          return e2[0] === t2[0] && e2[1] === t2[1];
        }, Kh.equals = function(e2, t2) {
          var i2 = e2[0], r2 = e2[1], n2 = t2[0], o2 = t2[1];
          return Math.abs(i2 - n2) <= Qh.EPSILON * Math.max(1, Math.abs(i2), Math.abs(n2)) && Math.abs(r2 - o2) <= Qh.EPSILON * Math.max(1, Math.abs(r2), Math.abs(o2));
        }, Kh.forEach = Kh.sqrLen = Kh.sqrDist = Kh.dist = Kh.div = Kh.mul = Kh.sub = Kh.len = void 0;
        var Qh = function(e2, t2) {
          if (e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== Jh(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = eu(void 0);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }(tc);
        function eu(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (eu = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function tu() {
          var e2 = new Qh.ARRAY_TYPE(2);
          return Qh.ARRAY_TYPE != Float32Array && (e2[0] = 0, e2[1] = 0), e2;
        }
        function iu(e2, t2, i2) {
          return e2[0] = t2[0] - i2[0], e2[1] = t2[1] - i2[1], e2;
        }
        function ru(e2, t2, i2) {
          return e2[0] = t2[0] * i2[0], e2[1] = t2[1] * i2[1], e2;
        }
        function nu(e2, t2, i2) {
          return e2[0] = t2[0] / i2[0], e2[1] = t2[1] / i2[1], e2;
        }
        function ou(e2, t2) {
          return Math.hypot(t2[0] - e2[0], t2[1] - e2[1]);
        }
        function su(e2, t2) {
          var i2 = t2[0] - e2[0], r2 = t2[1] - e2[1];
          return i2 * i2 + r2 * r2;
        }
        function au(e2) {
          return Math.hypot(e2[0], e2[1]);
        }
        function lu(e2) {
          var t2 = e2[0], i2 = e2[1];
          return t2 * t2 + i2 * i2;
        }
        Kh.len = au, Kh.sub = iu, Kh.mul = ru, Kh.div = nu, Kh.dist = ou, Kh.sqrDist = su, Kh.sqrLen = lu;
        var cu = function() {
          var e2 = tu();
          return function(t2, i2, r2, n2, o2, s2) {
            var a2, l2;
            for (i2 || (i2 = 2), r2 || (r2 = 0), l2 = n2 ? Math.min(n2 * i2 + r2, t2.length) : t2.length, a2 = r2; a2 < l2; a2 += i2)
              e2[0] = t2[a2], e2[1] = t2[a2 + 1], o2(e2, e2, s2), t2[a2] = e2[0], t2[a2 + 1] = e2[1];
            return t2;
          };
        }();
        function hu(e2) {
          return hu = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, hu(e2);
        }
        Kh.forEach = cu, Object.defineProperty(ec, "__esModule", { value: true });
        var uu = ec.vec4 = Mu = ec.vec3 = ec.vec2 = ec.quat2 = bu = ec.quat = xu = ec.mat4 = gu = ec.mat3 = ec.mat2d = fu = ec.mat2 = ec.glMatrix = void 0, du = Iu(tc);
        ec.glMatrix = du;
        var pu = Iu(sc), fu = ec.mat2 = pu, mu = Iu(dc);
        ec.mat2d = mu;
        var _u = Iu(yc), gu = ec.mat3 = _u, yu = Iu(Ec), xu = ec.mat4 = yu, vu = Iu(kc), bu = ec.quat = vu, wu = Iu(Fh);
        ec.quat2 = wu;
        var Tu = Iu(Kh);
        ec.vec2 = Tu;
        var Eu = Iu(Oc), Mu = ec.vec3 = Eu, Au = Iu(Kc);
        function Su(e2) {
          if ("function" != typeof WeakMap)
            return null;
          var t2 = /* @__PURE__ */ new WeakMap(), i2 = /* @__PURE__ */ new WeakMap();
          return (Su = function(e3) {
            return e3 ? i2 : t2;
          })(e2);
        }
        function Iu(e2, t2) {
          if (!t2 && e2 && e2.__esModule)
            return e2;
          if (null === e2 || "object" !== hu(e2) && "function" != typeof e2)
            return { default: e2 };
          var i2 = Su(t2);
          if (i2 && i2.has(e2))
            return i2.get(e2);
          var r2 = {}, n2 = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var o2 in e2)
            if ("default" !== o2 && Object.prototype.hasOwnProperty.call(e2, o2)) {
              var s2 = n2 ? Object.getOwnPropertyDescriptor(e2, o2) : null;
              s2 && (s2.get || s2.set) ? Object.defineProperty(r2, o2, s2) : r2[o2] = e2[o2];
            }
          return r2.default = e2, i2 && i2.set(e2, r2), r2;
        }
        uu = ec.vec4 = Au;
        const Cu = ba([{ type: "Float32", name: "a_globe_pos", components: 3 }, { type: "Float32", name: "a_uv", components: 2 }]), { members: zu } = Cu, Du = ba([{ name: "a_pos_3", components: 3, type: "Int16" }]);
        var Pu = ba([{ name: "a_pos", type: "Int16", components: 2 }]), Ru = {};
        !function(e2, t2) {
          !function(e3) {
            function t3(e4, t4, r2) {
              var n2 = i2(256 * e4, 256 * (t4 = Math.pow(2, r2) - t4 - 1), r2), o2 = i2(256 * (e4 + 1), 256 * (t4 + 1), r2);
              return n2[0] + "," + n2[1] + "," + o2[0] + "," + o2[1];
            }
            function i2(e4, t4, i3) {
              var r2 = 2 * Math.PI * 6378137 / 256 / Math.pow(2, i3);
              return [e4 * r2 - 2 * Math.PI * 6378137 / 2, t4 * r2 - 2 * Math.PI * 6378137 / 2];
            }
            e3.getURL = function(e4, i3, r2, n2, o2, s2) {
              return s2 = s2 || {}, e4 + "?" + ["bbox=" + t3(r2, n2, o2), "format=" + (s2.format || "image/png"), "service=" + (s2.service || "WMS"), "version=" + (s2.version || "1.1.1"), "request=" + (s2.request || "GetMap"), "srs=" + (s2.srs || "EPSG:3857"), "width=" + (s2.width || 256), "height=" + (s2.height || 256), "layers=" + i3].join("&");
            }, e3.getTileBBox = t3, e3.getMercCoords = i2, Object.defineProperty(e3, "__esModule", { value: true });
          }(t2);
        }(0, Ru);
        var Lu = Ru;
        class ku {
          constructor(e2, t2, i2) {
            this.z = e2, this.x = t2, this.y = i2, this.key = Fu(0, e2, e2, t2, i2);
          }
          equals(e2) {
            return this.z === e2.z && this.x === e2.x && this.y === e2.y;
          }
          url(e2, t2) {
            const i2 = Lu.getTileBBox(this.x, this.y, this.z), r2 = function(e3, t3, i3) {
              let r3, n2 = "";
              for (let o2 = e3; o2 > 0; o2--)
                r3 = 1 << o2 - 1, n2 += (t3 & r3 ? 1 : 0) + (i3 & r3 ? 2 : 0);
              return n2;
            }(this.z, this.x, this.y);
            return e2[(this.x + this.y) % e2.length].replace("{prefix}", (this.x % 16).toString(16) + (this.y % 16).toString(16)).replace(/{z}/g, String(this.z)).replace(/{x}/g, String(this.x)).replace(/{y}/g, String("tms" === t2 ? Math.pow(2, this.z) - this.y - 1 : this.y)).replace("{quadkey}", r2).replace("{bbox-epsg-3857}", i2);
          }
          toString() {
            return `${this.z}/${this.x}/${this.y}`;
          }
        }
        class Ou {
          constructor(e2, t2) {
            this.wrap = e2, this.canonical = t2, this.key = Fu(e2, t2.z, t2.z, t2.x, t2.y);
          }
        }
        class Bu {
          constructor(e2, t2, i2, r2, n2) {
            this.overscaledZ = e2, this.wrap = t2, this.canonical = new ku(i2, +r2, +n2), this.key = 0 === t2 && e2 === i2 ? this.canonical.key : Fu(t2, e2, i2, r2, n2);
          }
          equals(e2) {
            return this.overscaledZ === e2.overscaledZ && this.wrap === e2.wrap && this.canonical.equals(e2.canonical);
          }
          scaledTo(e2) {
            const t2 = this.canonical.z - e2;
            return e2 > this.canonical.z ? new Bu(e2, this.wrap, this.canonical.z, this.canonical.x, this.canonical.y) : new Bu(e2, this.wrap, e2, this.canonical.x >> t2, this.canonical.y >> t2);
          }
          calculateScaledKey(e2, t2 = true) {
            if (this.overscaledZ === e2 && t2)
              return this.key;
            if (e2 > this.canonical.z)
              return Fu(this.wrap * +t2, e2, this.canonical.z, this.canonical.x, this.canonical.y);
            {
              const i2 = this.canonical.z - e2;
              return Fu(this.wrap * +t2, e2, e2, this.canonical.x >> i2, this.canonical.y >> i2);
            }
          }
          isChildOf(e2) {
            if (e2.wrap !== this.wrap)
              return false;
            const t2 = this.canonical.z - e2.canonical.z;
            return 0 === e2.overscaledZ || e2.overscaledZ < this.overscaledZ && e2.canonical.z < this.canonical.z && e2.canonical.x === this.canonical.x >> t2 && e2.canonical.y === this.canonical.y >> t2;
          }
          children(e2) {
            if (this.overscaledZ >= e2)
              return [new Bu(this.overscaledZ + 1, this.wrap, this.canonical.z, this.canonical.x, this.canonical.y)];
            const t2 = this.canonical.z + 1, i2 = 2 * this.canonical.x, r2 = 2 * this.canonical.y;
            return [new Bu(t2, this.wrap, t2, i2, r2), new Bu(t2, this.wrap, t2, i2 + 1, r2), new Bu(t2, this.wrap, t2, i2, r2 + 1), new Bu(t2, this.wrap, t2, i2 + 1, r2 + 1)];
          }
          isLessThan(e2) {
            return this.wrap < e2.wrap || !(this.wrap > e2.wrap) && (this.overscaledZ < e2.overscaledZ || !(this.overscaledZ > e2.overscaledZ) && (this.canonical.x < e2.canonical.x || !(this.canonical.x > e2.canonical.x) && this.canonical.y < e2.canonical.y));
          }
          wrapped() {
            return new Bu(this.overscaledZ, 0, this.canonical.z, this.canonical.x, this.canonical.y);
          }
          unwrapTo(e2) {
            return new Bu(this.overscaledZ, e2, this.canonical.z, this.canonical.x, this.canonical.y);
          }
          overscaleFactor() {
            return Math.pow(2, this.overscaledZ - this.canonical.z);
          }
          toUnwrapped() {
            return new Ou(this.wrap, this.canonical);
          }
          toString() {
            return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`;
          }
        }
        function Fu(e2, t2, i2, r2, n2) {
          const o2 = 1 << Math.min(i2, 22);
          let s2 = o2 * (n2 % o2) + r2 % o2;
          return e2 && i2 < 22 && (s2 += o2 * o2 * ((e2 < 0 ? -2 * e2 - 1 : 2 * e2) % (1 << 2 * (22 - i2)))), 16 * (32 * s2 + i2) + (t2 - i2);
        }
        const Nu = [(e2) => {
          let t2 = e2.canonical.x - 1, i2 = e2.wrap;
          return t2 < 0 && (t2 = (1 << e2.canonical.z) - 1, i2--), new Bu(e2.overscaledZ, i2, e2.canonical.z, t2, e2.canonical.y);
        }, (e2) => {
          let t2 = e2.canonical.x + 1, i2 = e2.wrap;
          return t2 === 1 << e2.canonical.z && (t2 = 0, i2++), new Bu(e2.overscaledZ, i2, e2.canonical.z, t2, e2.canonical.y);
        }, (e2) => new Bu(e2.overscaledZ, e2.wrap, e2.canonical.z, e2.canonical.x, (0 === e2.canonical.y ? 1 << e2.canonical.z : e2.canonical.y) - 1), (e2) => new Bu(e2.overscaledZ, e2.wrap, e2.canonical.z, e2.canonical.x, e2.canonical.y === (1 << e2.canonical.z) - 1 ? 0 : e2.canonical.y + 1)];
        Is(ku, "CanonicalTileID"), Is(Bu, "OverscaledTileID", { omit: ["projMatrix"] });
        class Uu {
          constructor(e2, t2) {
            this.pos = e2, this.dir = t2;
          }
          intersectsPlane(e2, t2, i2) {
            const r2 = Mu.dot(t2, this.dir);
            if (Math.abs(r2) < 1e-6)
              return false;
            const n2 = ((e2[0] - this.pos[0]) * t2[0] + (e2[1] - this.pos[1]) * t2[1] + (e2[2] - this.pos[2]) * t2[2]) / r2;
            return i2[0] = this.pos[0] + this.dir[0] * n2, i2[1] = this.pos[1] + this.dir[1] * n2, i2[2] = this.pos[2] + this.dir[2] * n2, true;
          }
          closestPointOnSphere(e2, t2, i2) {
            if (Mu.equals(this.pos, e2) || 0 === t2)
              return i2[0] = i2[1] = i2[2] = 0, false;
            const [r2, n2, o2] = this.dir, s2 = this.pos[0] - e2[0], a2 = this.pos[1] - e2[1], l2 = this.pos[2] - e2[2], c2 = r2 * r2 + n2 * n2 + o2 * o2, h2 = 2 * (s2 * r2 + a2 * n2 + l2 * o2), u2 = h2 * h2 - 4 * c2 * (s2 * s2 + a2 * a2 + l2 * l2 - t2 * t2);
            if (u2 < 0) {
              const e3 = Math.max(-h2 / 2, 0), c3 = s2 + r2 * e3, u3 = a2 + n2 * e3, d2 = l2 + o2 * e3, p2 = Math.hypot(c3, u3, d2);
              return i2[0] = c3 * t2 / p2, i2[1] = u3 * t2 / p2, i2[2] = d2 * t2 / p2, false;
            }
            {
              const e3 = (-h2 - Math.sqrt(u2)) / (2 * c2);
              if (e3 < 0) {
                const e4 = Math.hypot(s2, a2, l2);
                return i2[0] = s2 * t2 / e4, i2[1] = a2 * t2 / e4, i2[2] = l2 * t2 / e4, false;
              }
              return i2[0] = s2 + r2 * e3, i2[1] = a2 + n2 * e3, i2[2] = l2 + o2 * e3, true;
            }
          }
        }
        class Vu {
          constructor(e2, t2, i2, r2, n2) {
            this.TL = e2, this.TR = t2, this.BR = i2, this.BL = r2, this.horizon = n2;
          }
          static fromInvProjectionMatrix(e2, t2, i2) {
            const r2 = [-1, 1, 1], n2 = [1, 1, 1], o2 = [1, -1, 1], s2 = [-1, -1, 1], a2 = Mu.transformMat4(r2, r2, e2), l2 = Mu.transformMat4(n2, n2, e2), c2 = Mu.transformMat4(o2, o2, e2), h2 = Mu.transformMat4(s2, s2, e2);
            return new Vu(a2, l2, c2, h2, t2 / i2);
          }
        }
        function ju(e2, t2, i2) {
          let r2 = 1 / 0, n2 = -1 / 0;
          const o2 = [];
          for (const s2 of e2) {
            Mu.sub(o2, s2, t2);
            const e3 = Mu.dot(o2, i2);
            r2 = Math.min(r2, e3), n2 = Math.max(n2, e3);
          }
          return [r2, n2];
        }
        function Gu(e2, t2) {
          let i2 = true;
          for (let r2 = 0; r2 < e2.planes.length; r2++) {
            const n2 = e2.planes[r2];
            let o2 = 0;
            for (let e3 = 0; e3 < t2.length; e3++)
              o2 += Mu.dot(n2, t2[e3]) + n2[3] >= 0;
            if (0 === o2)
              return 0;
            o2 !== t2.length && (i2 = false);
          }
          return i2 ? 2 : 1;
        }
        function qu(e2, t2) {
          for (const i2 of e2.projections) {
            const r2 = ju(t2, e2.points[0], i2.axis);
            if (i2.projection[1] < r2[0] || i2.projection[0] > r2[1])
              return 0;
          }
          return 1;
        }
        function Zu(e2, t2) {
          let i2 = 0;
          const r2 = [0, 0, 0, 0];
          for (let n2 = 0; n2 < e2.length; n2++)
            r2[0] = e2[n2][0], r2[1] = e2[n2][1], r2[2] = e2[n2][2], r2[3] = 1, uu.dot(r2, t2) >= 0 && i2++;
          return i2;
        }
        class $u {
          constructor(e2, t2) {
            this.points = e2 || new Array(8).fill([0, 0, 0]), this.planes = t2 || new Array(6).fill([0, 0, 0, 0]), this.bounds = Hu.fromPoints(this.points), this.projections = [], this.frustumEdges = [Mu.sub([], this.points[2], this.points[3]), Mu.sub([], this.points[0], this.points[3]), Mu.sub([], this.points[4], this.points[0]), Mu.sub([], this.points[5], this.points[1]), Mu.sub([], this.points[6], this.points[2]), Mu.sub([], this.points[7], this.points[3])];
            for (const e3 of this.frustumEdges) {
              const t3 = [0, -e3[2], e3[1]], i2 = [e3[2], 0, -e3[0]];
              this.projections.push({ axis: t3, projection: ju(this.points, this.points[0], t3) }), this.projections.push({ axis: i2, projection: ju(this.points, this.points[0], i2) });
            }
          }
          static fromInvProjectionMatrix(e2, t2, i2, r2) {
            const n2 = Math.pow(2, i2), o2 = [[-1, 1, -1, 1], [1, 1, -1, 1], [1, -1, -1, 1], [-1, -1, -1, 1], [-1, 1, 1, 1], [1, 1, 1, 1], [1, -1, 1, 1], [-1, -1, 1, 1]].map((i3) => {
              const o3 = uu.transformMat4([], i3, e2), s3 = 1 / o3[3] / t2 * n2;
              return uu.mul(o3, o3, [s3, s3, r2 ? 1 / o3[3] : s3, s3]);
            }), s2 = [[0, 1, 2], [6, 5, 4], [0, 3, 7], [2, 1, 5], [3, 2, 6], [0, 4, 5]].map((e3) => {
              const t3 = Mu.sub([], o2[e3[0]], o2[e3[1]]), i3 = Mu.sub([], o2[e3[2]], o2[e3[1]]), r3 = Mu.normalize([], Mu.cross([], t3, i3)), n3 = -Mu.dot(r3, o2[e3[1]]);
              return r3.concat(n3);
            }), a2 = [];
            for (let e3 = 0; e3 < o2.length; e3++)
              a2.push([o2[e3][0], o2[e3][1], o2[e3][2]]);
            return new $u(a2, s2);
          }
          intersectsPrecise(e2, t2, i2) {
            for (let i3 = 0; i3 < t2.length; i3++)
              if (!Zu(e2, t2[i3]))
                return 0;
            for (let t3 = 0; t3 < this.planes.length; t3++)
              if (!Zu(e2, this.planes[t3]))
                return 0;
            for (const t3 of i2)
              for (const i3 of this.frustumEdges) {
                const r2 = Mu.cross([], t3, i3), n2 = Mu.length(r2);
                if (0 === n2)
                  continue;
                Mu.scale(r2, r2, 1 / n2);
                const o2 = ju(this.points, this.points[0], r2), s2 = ju(e2, this.points[0], r2);
                if (o2[0] > s2[1] || s2[0] > o2[1])
                  return 0;
              }
            return 1;
          }
        }
        class Hu {
          static fromPoints(e2) {
            const t2 = [1 / 0, 1 / 0, 1 / 0], i2 = [-1 / 0, -1 / 0, -1 / 0];
            for (const r2 of e2)
              Mu.min(t2, t2, r2), Mu.max(i2, i2, r2);
            return new Hu(t2, i2);
          }
          static fromTileIdAndHeight(e2, t2, i2) {
            const r2 = 1 << e2.canonical.z, n2 = e2.canonical.x, o2 = e2.canonical.y;
            return new Hu([n2 / r2, o2 / r2, t2], [(n2 + 1) / r2, (o2 + 1) / r2, i2]);
          }
          static applyTransform(e2, t2) {
            const i2 = e2.getCorners();
            for (let e3 = 0; e3 < i2.length; ++e3)
              Mu.transformMat4(i2[e3], i2[e3], t2);
            return Hu.fromPoints(i2);
          }
          static projectAabbCorners(e2, t2) {
            const i2 = e2.getCorners();
            for (let e3 = 0; e3 < i2.length; ++e3)
              Mu.transformMat4(i2[e3], i2[e3], t2);
            return i2;
          }
          constructor(e2, t2) {
            this.min = e2, this.max = t2, this.center = Mu.scale([], Mu.add([], this.min, this.max), 0.5);
          }
          quadrant(e2) {
            const t2 = [e2 % 2 == 0, e2 < 2], i2 = Mu.clone(this.min), r2 = Mu.clone(this.max);
            for (let e3 = 0; e3 < t2.length; e3++)
              i2[e3] = t2[e3] ? this.min[e3] : this.center[e3], r2[e3] = t2[e3] ? this.center[e3] : this.max[e3];
            return r2[2] = this.max[2], new Hu(i2, r2);
          }
          distanceX(e2) {
            return Math.max(Math.min(this.max[0], e2[0]), this.min[0]) - e2[0];
          }
          distanceY(e2) {
            return Math.max(Math.min(this.max[1], e2[1]), this.min[1]) - e2[1];
          }
          distanceZ(e2) {
            return Math.max(Math.min(this.max[2], e2[2]), this.min[2]) - e2[2];
          }
          getCorners() {
            const e2 = this.min, t2 = this.max;
            return [[e2[0], e2[1], e2[2]], [t2[0], e2[1], e2[2]], [t2[0], t2[1], e2[2]], [e2[0], t2[1], e2[2]], [e2[0], e2[1], t2[2]], [t2[0], e2[1], t2[2]], [t2[0], t2[1], t2[2]], [e2[0], t2[1], t2[2]]];
          }
          intersects(e2) {
            return this.intersectsAabb(e2.bounds) ? Gu(e2, this.getCorners()) : 0;
          }
          intersectsFlat(e2) {
            return this.intersectsAabb(e2.bounds) ? Gu(e2, [[this.min[0], this.min[1], 0], [this.max[0], this.min[1], 0], [this.max[0], this.max[1], 0], [this.min[0], this.max[1], 0]]) : 0;
          }
          intersectsPrecise(e2, t2) {
            return t2 || this.intersects(e2) ? qu(e2, this.getCorners()) : 0;
          }
          intersectsPreciseFlat(e2, t2) {
            return t2 || this.intersectsFlat(e2) ? qu(e2, [[this.min[0], this.min[1], 0], [this.max[0], this.min[1], 0], [this.max[0], this.max[1], 0], [this.min[0], this.max[1], 0]]) : 0;
          }
          intersectsAabb(e2) {
            for (let t2 = 0; t2 < 3; ++t2)
              if (this.min[t2] > e2.max[t2] || e2.min[t2] > this.max[t2])
                return false;
            return true;
          }
          intersectsAabbXY(e2) {
            return !(this.min[0] > e2.max[0] || e2.min[0] > this.max[0] || this.min[1] > e2.max[1] || e2.min[1] > this.max[1]);
          }
          encapsulate(e2) {
            for (let t2 = 0; t2 < 3; t2++)
              this.min[t2] = Math.min(this.min[t2], e2.min[t2]), this.max[t2] = Math.max(this.max[t2], e2.max[t2]);
          }
          encapsulatePoint(e2) {
            for (let t2 = 0; t2 < 3; t2++)
              this.min[t2] = Math.min(this.min[t2], e2[t2]), this.max[t2] = Math.max(this.max[t2], e2[t2]);
          }
          closestPoint(e2) {
            return [Math.max(Math.min(this.max[0], e2[0]), this.min[0]), Math.max(Math.min(this.max[1], e2[1]), this.min[1]), Math.max(Math.min(this.max[2], e2[2]), this.min[2])];
          }
        }
        Is(Hu, "Aabb");
        const Wu = 5, Xu = 6, Yu = sr / Math.PI / 2, Ku = 16383, Ju = 64, Qu = [Ju, 32, 16], ed = -Yu, td = Yu, id = [new Hu([ed, ed, ed], [td, td, td]), new Hu([ed, ed, ed], [0, 0, td]), new Hu([0, ed, ed], [td, 0, td]), new Hu([ed, 0, ed], [0, td, td]), new Hu([0, 0, ed], [td, td, td])];
        function rd(e2) {
          return e2 * Yu / Od;
        }
        function nd(e2, t2, i2, r2 = true) {
          const n2 = Mu.scale([], e2._camera.position, e2.worldSize), o2 = [t2, i2, 1, 1];
          uu.transformMat4(o2, o2, e2.pixelMatrixInverse), uu.scale(o2, o2, 1 / o2[3]);
          const s2 = Mu.sub([], o2, n2), a2 = Mu.normalize([], s2), l2 = e2.globeMatrix, c2 = [l2[12], l2[13], l2[14]], h2 = Mu.sub([], c2, n2), u2 = Mu.length(h2), d2 = Mu.normalize([], h2), p2 = e2.worldSize / (2 * Math.PI), f2 = Mu.dot(d2, a2), m2 = Math.asin(p2 / u2);
          if (m2 < Math.acos(f2)) {
            if (!r2)
              return null;
            const e3 = [], t3 = [];
            Mu.scale(e3, a2, u2 / f2), Mu.normalize(t3, Mu.sub(t3, e3, h2)), Mu.normalize(a2, Mu.add(a2, h2, Mu.scale(a2, t3, Math.tan(m2) * u2)));
          }
          const _2 = [];
          new Uu(n2, a2).closestPointOnSphere(c2, p2, _2);
          const g2 = Mu.normalize([], ne(l2, 0)), y2 = Mu.normalize([], ne(l2, 1)), x2 = Mu.normalize([], ne(l2, 2)), v2 = Mu.dot(g2, _2), b2 = Mu.dot(y2, _2), w2 = Mu.dot(x2, _2), E2 = T(Math.asin(-b2 / p2));
          let M2 = T(Math.atan2(v2, w2));
          M2 = e2.center.lng + function(e3, t3) {
            const i3 = (t3 - e3 + 180) % 360 - 180;
            return i3 < -180 ? i3 + 360 : i3;
          }(e2.center.lng, M2);
          const A2 = Gd(M2), S2 = z(qd(E2), 0, 1);
          return new ep(A2, S2);
        }
        class od {
          constructor(e2, t2, i2) {
            this.a = Mu.sub([], e2, i2), this.b = Mu.sub([], t2, i2), this.center = i2;
            const r2 = Mu.normalize([], this.a), n2 = Mu.normalize([], this.b);
            this.angle = Math.acos(Mu.dot(r2, n2));
          }
        }
        function sd(e2, t2) {
          if (0 === e2.angle)
            return null;
          let i2;
          return i2 = 0 === e2.a[t2] ? 1 / e2.angle * 0.5 * Math.PI : 1 / e2.angle * Math.atan(e2.b[t2] / e2.a[t2] / Math.sin(e2.angle) - 1 / Math.tan(e2.angle)), i2 < 0 || i2 > 1 ? null : function(e3, t3, i3, r2) {
            const n2 = Math.sin(i3);
            return e3 * (Math.sin((1 - r2) * i3) / n2) + t3 * (Math.sin(r2 * i3) / n2);
          }(e2.a[t2], e2.b[t2], e2.angle, z(i2, 0, 1)) + e2.center[t2];
        }
        function ad(e2) {
          if (e2.z <= 1)
            return id[e2.z + 2 * e2.y + e2.x];
          const t2 = pd(dd(e2));
          return Hu.fromPoints(t2);
        }
        function ld(e2, t2, i2) {
          return Mu.scale(e2, e2, 1 - i2), Mu.scaleAndAdd(e2, e2, t2, i2);
        }
        function cd(e2, t2) {
          const i2 = Ed(t2.zoom);
          if (0 === i2)
            return ad(e2);
          const r2 = dd(e2), n2 = pd(r2), o2 = Gd(r2.getWest()) * t2.worldSize, s2 = Gd(r2.getEast()) * t2.worldSize, a2 = qd(r2.getNorth()) * t2.worldSize, l2 = qd(r2.getSouth()) * t2.worldSize, c2 = [o2, a2, 0], h2 = [s2, a2, 0], u2 = [o2, l2, 0], d2 = [s2, l2, 0], p2 = xu.invert([], t2.globeMatrix);
          return Mu.transformMat4(c2, c2, p2), Mu.transformMat4(h2, h2, p2), Mu.transformMat4(u2, u2, p2), Mu.transformMat4(d2, d2, p2), n2[0] = ld(n2[0], u2, i2), n2[1] = ld(n2[1], d2, i2), n2[2] = ld(n2[2], h2, i2), n2[3] = ld(n2[3], c2, i2), Hu.fromPoints(n2);
        }
        function hd(e2, t2, i2) {
          for (const r2 of e2)
            Mu.transformMat4(r2, r2, t2), Mu.scale(r2, r2, i2);
        }
        function ud(e2, t2, i2, r2) {
          const n2 = t2 / e2.worldSize, o2 = e2.globeMatrix;
          if (i2.z <= 1) {
            const e3 = ad(i2).getCorners();
            return hd(e3, o2, n2), Hu.fromPoints(e3);
          }
          const s2 = dd(i2, r2), a2 = pd(s2);
          hd(a2, o2, n2);
          const l2 = Number.MAX_VALUE, c2 = [-l2, -l2, -l2], h2 = [l2, l2, l2];
          if (s2.contains(e2.center)) {
            for (const e3 of a2)
              Mu.min(h2, h2, e3), Mu.max(c2, c2, e3);
            c2[2] = 0;
            const t3 = e2.point, i3 = [t3.x * n2, t3.y * n2, 0];
            return Mu.min(h2, h2, i3), Mu.max(c2, c2, i3), new Hu(h2, c2);
          }
          const u2 = [o2[12] * n2, o2[13] * n2, o2[14] * n2], d2 = s2.getCenter(), p2 = z(e2.center.lat, -Xd, Xd), f2 = z(d2.lat, -Xd, Xd), m2 = Gd(e2.center.lng), _2 = qd(p2);
          let g2 = m2 - Gd(d2.lng);
          const y2 = _2 - qd(f2);
          g2 > 0.5 ? g2 -= 1 : g2 < -0.5 && (g2 += 1);
          let x2 = 0;
          if (Math.abs(g2) > Math.abs(y2))
            x2 = g2 >= 0 ? 1 : 3;
          else {
            x2 = y2 >= 0 ? 0 : 2;
            const e3 = [o2[4] * n2, o2[5] * n2, o2[6] * n2], t3 = -Math.sin(w(y2 >= 0 ? s2.getSouth() : s2.getNorth())) * Yu;
            Mu.scaleAndAdd(u2, u2, e3, t3);
          }
          const v2 = a2[x2], b2 = a2[(x2 + 1) % 4], T2 = new od(v2, b2, u2), E2 = [sd(T2, 0) || v2[0], sd(T2, 1) || v2[1], sd(T2, 2) || v2[2]], M2 = Ed(e2.zoom);
          if (M2 > 0) {
            const r3 = function({ x: e3, y: t3, z: i3 }, r4, n4, o3, s3) {
              const a3 = 1 / (1 << i3);
              let l3 = e3 * a3, c3 = l3 + a3, h3 = t3 * a3, u3 = h3 + a3, d3 = 0;
              const p3 = (l3 + c3) / 2 - o3;
              return p3 > 0.5 ? d3 = -1 : p3 < -0.5 && (d3 = 1), l3 = ((l3 + d3) * r4 - (o3 *= r4)) * n4 + o3, c3 = ((c3 + d3) * r4 - o3) * n4 + o3, h3 = (h3 * r4 - (s3 *= r4)) * n4 + s3, u3 = (u3 * r4 - s3) * n4 + s3, [[l3, u3, 0], [c3, u3, 0], [c3, h3, 0], [l3, h3, 0]];
            }(i2, t2, e2._pixelsPerMercatorPixel, m2, _2);
            for (let e3 = 0; e3 < a2.length; e3++)
              ld(a2[e3], r3[e3], M2);
            const n3 = Mu.add([], r3[x2], r3[(x2 + 1) % 4]);
            Mu.scale(n3, n3, 0.5), ld(E2, n3, M2);
          }
          for (const e3 of a2)
            Mu.min(h2, h2, e3), Mu.max(c2, c2, e3);
          return h2[2] = Math.min(v2[2], b2[2]), Mu.min(h2, h2, E2), Mu.max(c2, c2, E2), new Hu(h2, c2);
        }
        function dd({ x: e2, y: t2, z: i2 }, r2 = false) {
          const n2 = 1 / (1 << i2), o2 = new Nd($d(e2 * n2), t2 === (1 << i2) - 1 && r2 ? -90 : Hd((t2 + 1) * n2)), s2 = new Nd($d((e2 + 1) * n2), 0 === t2 && r2 ? 90 : Hd(t2 * n2));
          return new Ql(o2, s2);
        }
        function pd(e2) {
          const t2 = w(e2.getNorth()), i2 = w(e2.getSouth()), r2 = Math.cos(t2), n2 = Math.cos(i2), o2 = Math.sin(t2), s2 = Math.sin(i2), a2 = e2.getWest(), l2 = e2.getEast();
          return [fd(n2, s2, a2), fd(n2, s2, l2), fd(r2, o2, l2), fd(r2, o2, a2)];
        }
        function fd(e2, t2, i2, r2 = Yu) {
          return i2 = w(i2), [e2 * Math.sin(i2) * r2, -t2 * r2, e2 * Math.cos(i2) * r2];
        }
        function md(e2, t2, i2) {
          return fd(Math.cos(w(e2)), Math.sin(w(e2)), t2, i2);
        }
        function _d(e2, t2, i2, r2) {
          const n2 = 1 << i2.z, o2 = (e2 / sr + i2.x) / n2;
          return md(Hd((t2 / sr + i2.y) / n2), $d(o2), r2);
        }
        function gd({ min: e2, max: t2 }) {
          return Ku / Math.max(t2[0] - e2[0], t2[1] - e2[1], t2[2] - e2[2]);
        }
        const yd = new Float64Array(16);
        function xd(e2) {
          const t2 = gd(e2), i2 = xu.fromScaling(yd, [t2, t2, t2]);
          return xu.translate(i2, i2, Mu.negate([], e2.min));
        }
        function vd(e2) {
          const t2 = xu.fromTranslation(yd, e2.min), i2 = 1 / gd(e2);
          return xu.scale(t2, t2, [i2, i2, i2]);
        }
        function bd(e2) {
          const t2 = sr / (2 * Math.PI);
          return e2 / (2 * Math.PI) / t2;
        }
        function wd(e2, t2) {
          return sr / (512 * Math.pow(2, e2)) * gd(ad(t2));
        }
        function Td(e2, t2, i2, r2, n2) {
          const o2 = bd(i2), s2 = [e2, t2, -i2 / (2 * Math.PI)], a2 = xu.identity(new Float64Array(16));
          return xu.translate(a2, a2, s2), xu.scale(a2, a2, [o2, o2, o2]), xu.rotateX(a2, a2, w(-n2)), xu.rotateY(a2, a2, w(-r2)), a2;
        }
        function Ed(e2) {
          return D(Wu, Xu, e2);
        }
        function Md(e2, t2, i2) {
          const r2 = xu.identity(new Float64Array(16)), n2 = (t2 / (1 << e2) - 0.5) * Math.PI * 2;
          return xu.rotateY(r2, i2.globeMatrix, n2), Float32Array.from(r2);
        }
        function Ad(e2, t2, i2) {
          const r2 = Ed(i2.zoom), n2 = e2.style.map._antialias, o2 = t2.extStandardDerivativesForceOff || e2.terrain && e2.terrain.exaggeration() > 0;
          return 0 === r2 && !n2 && !o2;
        }
        function Sd(e2, t2, i2, r2) {
          const n2 = t2.getNorth(), o2 = t2.getSouth(), s2 = t2.getWest(), a2 = t2.getEast(), l2 = 1 << e2.z, c2 = a2 - s2, h2 = n2 - o2, u2 = c2 / Ju, d2 = -h2 / Qu[i2], p2 = [0, u2, 0, d2, 0, 0, n2, s2, 0];
          if (e2.z > 0) {
            const e3 = 180 / r2;
            gu.multiply(p2, p2, [e3 / c2 + 1, 0, 0, 0, e3 / h2 + 1, 0, -0.5 * e3 / u2, 0.5 * e3 / d2, 1]);
          }
          return p2[2] = l2, p2[5] = e2.x, p2[8] = e2.y, p2;
        }
        function Id(e2) {
          const t2 = Xd - 5;
          e2 = z(e2, -t2, t2) / t2 * 90;
          const i2 = Math.pow(Math.abs(Math.sin(w(e2))), 3);
          return Math.round(i2 * (Qu.length - 1));
        }
        function Cd(e2) {
          const t2 = [0, 0, 0], i2 = xu.identity(new Float64Array(16));
          return xu.multiply(i2, e2.pixelMatrix, e2.globeMatrix), Mu.transformMat4(t2, t2, i2), new y(t2[0], t2[1]);
        }
        function zd(e2, t2) {
          const i2 = md(t2.lat, t2.lng), r2 = function(e3) {
            const t3 = md(e3._center.lat, e3._center.lng), i3 = Mu.fromValues(0, 1, 0);
            let r3 = Mu.cross([], i3, t3);
            const n3 = xu.fromRotation([], -e3.angle, t3);
            r3 = Mu.transformMat4(r3, r3, n3), xu.fromRotation(n3, -e3._pitch, r3);
            const o2 = Mu.normalize([], t3);
            return Mu.scale(o2, o2, rd(e3.cameraToCenterDistance / e3.pixelsPerMeter)), Mu.transformMat4(o2, o2, n3), Mu.add([], t3, o2);
          }(e2), n2 = Mu.subtract([], r2, i2);
          return Mu.angle(n2, i2);
        }
        function Dd(e2, t2) {
          return zd(e2, t2) > Math.PI / 2 * 1.01;
        }
        const Pd = w(85), Rd = Math.cos(Pd), Ld = Math.sin(Pd);
        class kd {
          constructor(e2) {
            this._createGrid(e2), this._createPoles(e2);
          }
          destroy() {
            this._poleIndexBuffer.destroy(), this._gridBuffer.destroy(), this._gridIndexBuffer.destroy(), this._poleNorthVertexBuffer.destroy(), this._poleSouthVertexBuffer.destroy();
            for (const e2 of this._poleSegments)
              e2.destroy();
            for (const e2 of this._gridSegments)
              e2.withSkirts.destroy(), e2.withoutSkirts.destroy();
          }
          _fillGridMeshWithLods(e2, t2) {
            const i2 = new Ta(), r2 = new Va(), n2 = [], o2 = e2 + 1 + 2, s2 = t2[0] + 1, a2 = t2[0] + 1 + (1 + t2.length), l2 = (e3, t3, i3) => {
              let r3 = e3 === o2 - 1 ? e3 - 2 : 0 === e3 ? e3 : e3 - 1;
              return r3 += i3 ? 24575 : 0, [r3, t3];
            };
            for (let e3 = 0; e3 < o2; ++e3)
              i2.emplaceBack(...l2(e3, 0, true));
            for (let e3 = 0; e3 < s2; ++e3)
              for (let t3 = 0; t3 < o2; ++t3)
                i2.emplaceBack(...l2(t3, e3, (0 === t3 || t3 === o2 - 1) && true));
            for (let e3 = 0; e3 < t2.length; ++e3) {
              const r3 = t2[e3];
              for (let e4 = 0; e4 < o2; ++e4)
                i2.emplaceBack(...l2(e4, r3, true));
            }
            for (let e3 = 0; e3 < t2.length; ++e3) {
              const s3 = r2.length, l3 = t2[e3] + 1 + 2, c2 = new Va();
              for (let i3 = 0; i3 < l3 - 1; i3++) {
                const n3 = i3 === l3 - 2, s4 = n3 ? o2 * (a2 - t2.length + e3 - i3) : o2;
                for (let e4 = 0; e4 < o2 - 1; e4++) {
                  const t3 = i3 * o2 + e4;
                  0 === i3 || n3 || 0 === e4 || e4 === o2 - 2 ? (c2.emplaceBack(t3 + 1, t3, t3 + s4), c2.emplaceBack(t3 + s4, t3 + s4 + 1, t3 + 1)) : (r2.emplaceBack(t3 + 1, t3, t3 + s4), r2.emplaceBack(t3 + s4, t3 + s4 + 1, t3 + 1));
                }
              }
              const h2 = dl.simpleSegment(0, s3, i2.length, r2.length - s3);
              for (let e4 = 0; e4 < c2.uint16.length; e4 += 3)
                r2.emplaceBack(c2.uint16[e4], c2.uint16[e4 + 1], c2.uint16[e4 + 2]);
              const u2 = dl.simpleSegment(0, s3, i2.length, r2.length - s3);
              n2.push({ withoutSkirts: h2, withSkirts: u2 });
            }
            return { vertices: i2, indices: r2, segments: n2 };
          }
          _createGrid(e2) {
            const t2 = this._fillGridMeshWithLods(Ju, Qu);
            this._gridSegments = t2.segments, this._gridBuffer = e2.createVertexBuffer(t2.vertices, Pu.members), this._gridIndexBuffer = e2.createIndexBuffer(t2.indices, true);
          }
          _createPoles(e2) {
            const t2 = new Va();
            for (let e3 = 0; e3 <= Ju; e3++)
              t2.emplaceBack(0, e3 + 1, e3 + 2);
            this._poleIndexBuffer = e2.createIndexBuffer(t2, true);
            const i2 = new Za(), r2 = new Za(), n2 = new Za(), o2 = new Za();
            this._poleSegments = [];
            for (let e3 = 0, t3 = 0; e3 < Wu; e3++) {
              const s2 = 360 / (1 << e3);
              i2.emplaceBack(0, -Yu, 0, 0.5, 0), r2.emplaceBack(0, -Yu, 0, 0.5, 1), n2.emplaceBack(0, -Yu, 0, 0.5, 0.5), o2.emplaceBack(0, -Yu, 0, 0.5, 0.5);
              for (let e4 = 0; e4 <= Ju; e4++) {
                let t4 = e4 / Ju, a2 = 0;
                const l2 = Wr(0, s2, t4), [c2, h2, u2] = fd(Rd, Ld, l2, Yu);
                i2.emplaceBack(c2, h2, u2, t4, a2), r2.emplaceBack(c2, h2, u2, t4, 1 - a2);
                const d2 = w(l2);
                t4 = 0.5 + 0.5 * Math.sin(d2), a2 = 0.5 + 0.5 * Math.cos(d2), n2.emplaceBack(c2, h2, u2, t4, a2), o2.emplaceBack(c2, h2, u2, t4, 1 - a2);
              }
              this._poleSegments.push(dl.simpleSegment(t3, 0, 66, 64)), t3 += 66;
            }
            this._poleNorthVertexBuffer = e2.createVertexBuffer(i2, zu, false), this._poleSouthVertexBuffer = e2.createVertexBuffer(r2, zu, false), this._texturedPoleNorthVertexBuffer = e2.createVertexBuffer(n2, zu, false), this._texturedPoleSouthVertexBuffer = e2.createVertexBuffer(o2, zu, false);
          }
          getGridBuffers(e2, t2) {
            return [this._gridBuffer, this._gridIndexBuffer, t2 ? this._gridSegments[e2].withSkirts : this._gridSegments[e2].withoutSkirts];
          }
          getPoleBuffers(e2, t2) {
            return [t2 ? this._texturedPoleNorthVertexBuffer : this._poleNorthVertexBuffer, t2 ? this._texturedPoleSouthVertexBuffer : this._poleSouthVertexBuffer, this._poleIndexBuffer, this._poleSegments[e2]];
          }
        }
        const Od = 63710088e-1, Bd = 2 * Math.PI * Od;
        class Fd {
          constructor(e2, t2) {
            if (isNaN(e2) || isNaN(t2))
              throw new Error(`Invalid LngLat object: (${e2}, ${t2})`);
            if (this.lng = +e2, this.lat = +t2, this.lat > 90 || this.lat < -90)
              throw new Error("Invalid LngLat latitude value: must be between -90 and 90");
          }
          wrap() {
            return new Fd(P(this.lng, -180, 180), this.lat);
          }
          toArray() {
            return [this.lng, this.lat];
          }
          toString() {
            return `LngLat(${this.lng}, ${this.lat})`;
          }
          distanceTo(e2) {
            const t2 = Math.PI / 180, i2 = this.lat * t2, r2 = e2.lat * t2, n2 = Math.sin(i2) * Math.sin(r2) + Math.cos(i2) * Math.cos(r2) * Math.cos((e2.lng - this.lng) * t2);
            return Od * Math.acos(Math.min(n2, 1));
          }
          toBounds(e2 = 0) {
            const t2 = 360 * e2 / 40075017, i2 = t2 / Math.cos(Math.PI / 180 * this.lat);
            return new Ql(new Fd(this.lng - i2, this.lat - t2), new Fd(this.lng + i2, this.lat + t2));
          }
          toEcef(e2) {
            const t2 = rd(e2);
            return md(this.lat, this.lng, Yu + t2);
          }
          static convert(e2) {
            if (e2 instanceof Fd)
              return e2;
            if (Array.isArray(e2) && (2 === e2.length || 3 === e2.length))
              return new Fd(Number(e2[0]), Number(e2[1]));
            if (!Array.isArray(e2) && "object" == typeof e2 && null !== e2)
              return new Fd(Number("lng" in e2 ? e2.lng : e2.lon), Number(e2.lat));
            throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]");
          }
        }
        var Nd = Fd;
        const Ud = 0, Vd = 25.5;
        function jd(e2) {
          return Bd * Math.cos(e2 * Math.PI / 180);
        }
        function Gd(e2) {
          return (180 + e2) / 360;
        }
        function qd(e2) {
          return (180 - 180 / Math.PI * Math.log(Math.tan(Math.PI / 4 + e2 * Math.PI / 360))) / 360;
        }
        function Zd(e2, t2) {
          return e2 / jd(t2);
        }
        function $d(e2) {
          return 360 * e2 - 180;
        }
        function Hd(e2) {
          return 360 / Math.PI * Math.atan(Math.exp((180 - 360 * e2) * Math.PI / 180)) - 90;
        }
        function Wd(e2, t2) {
          return e2 * jd(Hd(t2));
        }
        const Xd = 85.051129;
        function Yd(e2) {
          return Math.cos(w(z(e2, -Xd, Xd)));
        }
        function Kd(e2, t2) {
          const i2 = z(t2, Ud, Vd), r2 = Math.pow(2, i2);
          return Yd(e2) * Bd / (512 * r2);
        }
        function Jd(e2) {
          return 1 / Math.cos(e2 * Math.PI / 180);
        }
        function Qd(e2, t2 = 0) {
          const i2 = Math.exp(Math.PI * (1 - (e2.y + t2 / sr) / (1 << e2.z) * 2));
          return 80150034 * i2 / (i2 * i2 + 1) / sr / (1 << e2.z);
        }
        class ep {
          constructor(e2, t2, i2 = 0) {
            this.x = +e2, this.y = +t2, this.z = +i2;
          }
          static fromLngLat(e2, t2 = 0) {
            const i2 = Nd.convert(e2);
            return new ep(Gd(i2.lng), qd(i2.lat), Zd(t2, i2.lat));
          }
          toLngLat() {
            return new Nd($d(this.x), Hd(this.y));
          }
          toAltitude() {
            return Wd(this.z, this.y);
          }
          meterInMercatorCoordinateUnits() {
            return 1 / Bd * Jd(Hd(this.y));
          }
        }
        function tp(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          const c2 = (t2 + r2) / 2, h2 = (i2 + n2) / 2, u2 = new y(c2, h2);
          a2(u2), function(e3, t3, i3, r3, n3, o3) {
            const s3 = i3 - n3, a3 = r3 - o3;
            return Math.abs((r3 - t3) * s3 - (i3 - e3) * a3) / Math.hypot(s3, a3);
          }(u2.x, u2.y, o2.x, o2.y, s2.x, s2.y) >= l2 ? (tp(e2, t2, i2, c2, h2, o2, u2, a2, l2), tp(e2, c2, h2, r2, n2, u2, s2, a2, l2)) : e2.push(s2);
        }
        function ip(e2, t2, i2) {
          let r2 = e2[0], n2 = r2.x, o2 = r2.y;
          t2(r2);
          const s2 = [r2];
          for (let a2 = 1; a2 < e2.length; a2++) {
            const l2 = e2[a2], { x: c2, y: h2 } = l2;
            t2(l2), tp(s2, n2, o2, c2, h2, r2, l2, t2, i2), n2 = c2, o2 = h2, r2 = l2;
          }
          return s2;
        }
        function rp(e2, t2, i2, r2) {
          if (r2(t2, i2)) {
            const n2 = t2.add(i2)._mult(0.5);
            rp(e2, t2, n2, r2), rp(e2, n2, i2, r2);
          } else
            e2.push(i2);
        }
        function np(e2, t2) {
          let i2 = e2[0];
          const r2 = [i2];
          for (let n2 = 1; n2 < e2.length; n2++) {
            const o2 = e2[n2];
            rp(r2, i2, o2, t2), i2 = o2;
          }
          return r2;
        }
        const op = Math.pow(2, 14) - 1, sp = -op - 1;
        function ap(e2, t2) {
          const i2 = Math.round(e2.x * t2), r2 = Math.round(e2.y * t2);
          return e2.x = z(i2, sp, op), e2.y = z(r2, sp, op), (i2 < e2.x || i2 > e2.x + 1 || r2 < e2.y || r2 > e2.y + 1) && W("Geometry exceeds allowed extent, reduce your vector tile buffer size"), e2;
        }
        function lp(e2, t2, i2) {
          const r2 = e2.loadGeometry(), n2 = e2.extent, o2 = sr / n2;
          if (t2 && i2 && i2.projection.isReprojectedInTileSpace) {
            const o3 = 1 << t2.z, { scale: s2, x: a2, y: l2, projection: c2 } = i2, h2 = (e3) => {
              const i3 = $d((t2.x + e3.x / n2) / o3), r3 = Hd((t2.y + e3.y / n2) / o3), h3 = c2.project(i3, r3);
              e3.x = (h3.x * s2 - a2) * n2, e3.y = (h3.y * s2 - l2) * n2;
            };
            for (let t3 = 0; t3 < r2.length; t3++)
              if (1 !== e2.type)
                r2[t3] = ip(r2[t3], h2, 1);
              else {
                const e3 = [];
                for (const i3 of r2[t3])
                  i3.x < 0 || i3.x >= n2 || i3.y < 0 || i3.y >= n2 || (h2(i3), e3.push(i3));
                r2[t3] = e3;
              }
          }
          for (const e3 of r2)
            for (const t3 of e3)
              ap(t3, o2);
          return r2;
        }
        function cp(e2, t2) {
          return { type: e2.type, id: e2.id, properties: e2.properties, geometry: t2 ? lp(e2) : [] };
        }
        function hp(e2, t2, i2, r2, n2) {
          e2.emplaceBack(2 * t2 + (r2 + 1) / 2, 2 * i2 + (n2 + 1) / 2);
        }
        function up(e2, t2, i2) {
          const r2 = 16384;
          e2.emplaceBack(t2.x, t2.y, t2.z, i2[0] * r2, i2[1] * r2, i2[2] * r2);
        }
        class dp {
          constructor(e2) {
            this.zoom = e2.zoom, this.overscaling = e2.overscaling, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.index = e2.index, this.hasPattern = false, this.projection = e2.projection, this.layoutVertexArray = new Ta(), this.indexArray = new Va(), this.segments = new dl(), this.programConfigurations = new Hl(e2.layers, e2.zoom), this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id);
          }
          populate(e2, t2, i2, r2) {
            const n2 = this.layers[0], o2 = [];
            let s2 = null;
            "circle" === n2.type && (s2 = n2.layout.get("circle-sort-key"));
            for (const { feature: t3, id: n3, index: a3, sourceLayerIndex: l2 } of e2) {
              const e3 = this.layers[0]._featureFilter.needGeometry, c2 = cp(t3, e3);
              if (!this.layers[0]._featureFilter.filter(new ea(this.zoom), c2, i2))
                continue;
              const h2 = s2 ? s2.evaluate(c2, {}, i2) : void 0, u2 = { id: n3, properties: t3.properties, type: t3.type, sourceLayerIndex: l2, index: a3, geometry: e3 ? c2.geometry : lp(t3, i2, r2), patterns: {}, sortKey: h2 };
              o2.push(u2);
            }
            s2 && o2.sort((e3, t3) => e3.sortKey - t3.sortKey);
            let a2 = null;
            "globe" === r2.projection.name && (this.globeExtVertexArray = new Da(), a2 = r2.projection);
            for (const r3 of o2) {
              const { geometry: n3, index: o3, sourceLayerIndex: s3 } = r3, l2 = e2[o3].feature;
              this.addFeature(r3, n3, o3, t2.availableImages, i2, a2, t2.brightness), t2.featureIndex.insert(l2, n3, o3, s3, this.index);
            }
          }
          update(e2, t2, i2, r2, n2) {
            const o2 = 0 !== Object.keys(e2).length;
            o2 && !this.stateDependentLayers.length || this.programConfigurations.updatePaintArrays(e2, t2, o2 ? this.stateDependentLayers : this.layers, i2, r2, n2);
          }
          isEmpty() {
            return 0 === this.layoutVertexArray.length;
          }
          uploadPending() {
            return !this.uploaded || this.programConfigurations.needsUpload;
          }
          upload(e2) {
            this.uploaded || (this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, hl.members), this.indexBuffer = e2.createIndexBuffer(this.indexArray), this.globeExtVertexArray && (this.globeExtVertexBuffer = e2.createVertexBuffer(this.globeExtVertexArray, ul.members))), this.programConfigurations.upload(e2), this.uploaded = true;
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.globeExtVertexBuffer && this.globeExtVertexBuffer.destroy());
          }
          addFeature(e2, t2, i2, r2, n2, o2, s2) {
            for (const i3 of t2)
              for (const t3 of i3) {
                const i4 = t3.x, r3 = t3.y;
                if (i4 < 0 || i4 >= sr || r3 < 0 || r3 >= sr)
                  continue;
                if (o2) {
                  const e3 = o2.projectTilePoint(i4, r3, n2), t4 = o2.upVector(n2, i4, r3), s4 = this.globeExtVertexArray;
                  up(s4, e3, t4), up(s4, e3, t4), up(s4, e3, t4), up(s4, e3, t4);
                }
                const s3 = this.segments.prepareSegment(4, this.layoutVertexArray, this.indexArray, e2.sortKey), a2 = s3.vertexLength;
                hp(this.layoutVertexArray, i4, r3, -1, -1), hp(this.layoutVertexArray, i4, r3, 1, -1), hp(this.layoutVertexArray, i4, r3, 1, 1), hp(this.layoutVertexArray, i4, r3, -1, 1), this.indexArray.emplaceBack(a2, a2 + 1, a2 + 2), this.indexArray.emplaceBack(a2, a2 + 2, a2 + 3), s3.vertexLength += 4, s3.primitiveLength += 2;
              }
            this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length, e2, i2, {}, r2, n2, s2);
          }
        }
        function pp(e2, t2) {
          for (let i2 = 0; i2 < e2.length; i2++)
            if (wp(t2, e2[i2]))
              return true;
          for (let i2 = 0; i2 < t2.length; i2++)
            if (wp(e2, t2[i2]))
              return true;
          return !!gp(e2, t2);
        }
        function fp(e2, t2, i2) {
          return !!wp(e2, t2) || !!xp(t2, e2, i2);
        }
        function mp(e2, t2) {
          if (1 === e2.length)
            return bp(t2, e2[0]);
          for (let i2 = 0; i2 < t2.length; i2++) {
            const r2 = t2[i2];
            for (let t3 = 0; t3 < r2.length; t3++)
              if (wp(e2, r2[t3]))
                return true;
          }
          for (let i2 = 0; i2 < e2.length; i2++)
            if (bp(t2, e2[i2]))
              return true;
          for (let i2 = 0; i2 < t2.length; i2++)
            if (gp(e2, t2[i2]))
              return true;
          return false;
        }
        function _p(e2, t2, i2) {
          if (e2.length > 1) {
            if (gp(e2, t2))
              return true;
            for (let r2 = 0; r2 < t2.length; r2++)
              if (xp(t2[r2], e2, i2))
                return true;
          }
          for (let r2 = 0; r2 < e2.length; r2++)
            if (xp(e2[r2], t2, i2))
              return true;
          return false;
        }
        function gp(e2, t2) {
          if (0 === e2.length || 0 === t2.length)
            return false;
          for (let i2 = 0; i2 < e2.length - 1; i2++) {
            const r2 = e2[i2], n2 = e2[i2 + 1];
            for (let e3 = 0; e3 < t2.length - 1; e3++)
              if (yp(r2, n2, t2[e3], t2[e3 + 1]))
                return true;
          }
          return false;
        }
        function yp(e2, t2, i2, r2) {
          return X(e2, i2, r2) !== X(t2, i2, r2) && X(e2, t2, i2) !== X(e2, t2, r2);
        }
        function xp(e2, t2, i2) {
          const r2 = i2 * i2;
          if (1 === t2.length)
            return e2.distSqr(t2[0]) < r2;
          for (let i3 = 1; i3 < t2.length; i3++)
            if (vp(e2, t2[i3 - 1], t2[i3]) < r2)
              return true;
          return false;
        }
        function vp(e2, t2, i2) {
          const r2 = t2.distSqr(i2);
          if (0 === r2)
            return e2.distSqr(t2);
          const n2 = ((e2.x - t2.x) * (i2.x - t2.x) + (e2.y - t2.y) * (i2.y - t2.y)) / r2;
          return e2.distSqr(n2 < 0 ? t2 : n2 > 1 ? i2 : i2.sub(t2)._mult(n2)._add(t2));
        }
        function bp(e2, t2) {
          let i2, r2, n2, o2 = false;
          for (let s2 = 0; s2 < e2.length; s2++) {
            i2 = e2[s2];
            for (let e3 = 0, s3 = i2.length - 1; e3 < i2.length; s3 = e3++)
              r2 = i2[e3], n2 = i2[s3], r2.y > t2.y != n2.y > t2.y && t2.x < (n2.x - r2.x) * (t2.y - r2.y) / (n2.y - r2.y) + r2.x && (o2 = !o2);
          }
          return o2;
        }
        function wp(e2, t2) {
          let i2 = false;
          for (let r2 = 0, n2 = e2.length - 1; r2 < e2.length; n2 = r2++) {
            const o2 = e2[r2], s2 = e2[n2];
            o2.y > t2.y != s2.y > t2.y && t2.x < (s2.x - o2.x) * (t2.y - o2.y) / (s2.y - o2.y) + o2.x && (i2 = !i2);
          }
          return i2;
        }
        function Tp(e2, t2, i2, r2, n2) {
          for (const o3 of e2)
            if (t2 <= o3.x && i2 <= o3.y && r2 >= o3.x && n2 >= o3.y)
              return true;
          const o2 = [new y(t2, i2), new y(t2, n2), new y(r2, n2), new y(r2, i2)];
          if (e2.length > 2) {
            for (const t3 of o2)
              if (wp(e2, t3))
                return true;
          }
          for (let t3 = 0; t3 < e2.length - 1; t3++)
            if (Ep(e2[t3], e2[t3 + 1], o2))
              return true;
          return false;
        }
        function Ep(e2, t2, i2) {
          const r2 = i2[0], n2 = i2[2];
          if (e2.x < r2.x && t2.x < r2.x || e2.x > n2.x && t2.x > n2.x || e2.y < r2.y && t2.y < r2.y || e2.y > n2.y && t2.y > n2.y)
            return false;
          const o2 = X(e2, t2, i2[0]);
          return o2 !== X(e2, t2, i2[1]) || o2 !== X(e2, t2, i2[2]) || o2 !== X(e2, t2, i2[3]);
        }
        function Mp(e2, t2, i2, r2, n2, o2) {
          let s2 = t2.y - e2.y, a2 = e2.x - t2.x;
          if (o2 = o2 || 0) {
            const e3 = s2 * s2 + a2 * a2;
            if (0 === e3)
              return true;
            const t3 = Math.sqrt(e3);
            s2 /= t3, a2 /= t3;
          }
          return !((i2.x - e2.x) * s2 + (i2.y - e2.y) * a2 - o2 < 0 || (r2.x - e2.x) * s2 + (r2.y - e2.y) * a2 - o2 < 0 || (n2.x - e2.x) * s2 + (n2.y - e2.y) * a2 - o2 < 0);
        }
        function Ap(e2, t2, i2, r2, n2, o2, s2) {
          return !(Mp(e2, t2, r2, n2, o2, s2) || Mp(t2, i2, r2, n2, o2, s2) || Mp(i2, e2, r2, n2, o2, s2) || Mp(r2, n2, e2, t2, i2, s2) || Mp(n2, o2, e2, t2, i2, s2) || Mp(o2, r2, e2, t2, i2, s2));
        }
        function Sp(e2, t2, i2) {
          const r2 = t2.paint.get(e2).value;
          return "constant" === r2.kind ? r2.value : i2.programConfigurations.get(t2.id).getMaxValue(e2);
        }
        function Ip(e2) {
          return Math.sqrt(e2[0] * e2[0] + e2[1] * e2[1]);
        }
        function Cp(e2, t2, i2, r2, n2) {
          if (!t2[0] && !t2[1])
            return e2;
          const o2 = y.convert(t2)._mult(n2);
          "viewport" === i2 && o2._rotate(-r2);
          const s2 = [];
          for (let t3 = 0; t3 < e2.length; t3++)
            s2.push(e2[t3].sub(o2));
          return s2;
        }
        function zp(e2, t2, i2, r2) {
          const n2 = y.convert(e2)._mult(r2);
          return "viewport" === t2 && n2._rotate(-i2), n2;
        }
        Is(dp, "CircleBucket", { omit: ["layers"] });
        const Dp = new da({ "circle-sort-key": new ha(Ct.layout_circle["circle-sort-key"]), visibility: new ca(Ct.layout_circle.visibility) });
        var Pp = { paint: new da({ "circle-radius": new ha(Ct.paint_circle["circle-radius"]), "circle-color": new ha(Ct.paint_circle["circle-color"]), "circle-blur": new ha(Ct.paint_circle["circle-blur"]), "circle-opacity": new ha(Ct.paint_circle["circle-opacity"]), "circle-translate": new ca(Ct.paint_circle["circle-translate"]), "circle-translate-anchor": new ca(Ct.paint_circle["circle-translate-anchor"]), "circle-pitch-scale": new ca(Ct.paint_circle["circle-pitch-scale"]), "circle-pitch-alignment": new ca(Ct.paint_circle["circle-pitch-alignment"]), "circle-stroke-width": new ha(Ct.paint_circle["circle-stroke-width"]), "circle-stroke-color": new ha(Ct.paint_circle["circle-stroke-color"]), "circle-stroke-opacity": new ha(Ct.paint_circle["circle-stroke-opacity"]), "circle-emissive-strength": new ca(Ct.paint_circle["circle-emissive-strength"]) }), layout: Dp };
        const Rp = xu.create(), Lp = (e2, t2, i2, r2, n2, o2) => {
          const s2 = e2.transform, a2 = "globe" === s2.projection.name;
          let l2;
          if ("map" === o2.paint.get("circle-pitch-alignment"))
            if (a2) {
              const e3 = wd(s2.zoom, t2.canonical) * s2._pixelsPerMercatorPixel;
              l2 = Float32Array.from([e3, 0, 0, e3]);
            } else
              l2 = s2.calculatePixelsToTileUnitsMatrix(i2);
          else
            l2 = new Float32Array([s2.pixelsToGLUnits[0], 0, 0, s2.pixelsToGLUnits[1]]);
          const c2 = { u_camera_to_center_distance: e2.transform.getCameraToCenterDistance(s2.projection), u_matrix: e2.translatePosMatrix(t2.projMatrix, i2, o2.paint.get("circle-translate"), o2.paint.get("circle-translate-anchor")), u_device_pixel_ratio: ht.devicePixelRatio, u_extrude_scale: l2, u_inv_rot_matrix: Rp, u_merc_center: [0, 0], u_tile_id: [0, 0, 0], u_zoom_transition: 0, u_up_dir: [0, 0, 0], u_emissive_strength: o2.paint.get("circle-emissive-strength") };
          if (a2) {
            c2.u_inv_rot_matrix = r2, c2.u_merc_center = n2, c2.u_tile_id = [t2.canonical.x, t2.canonical.y, 1 << t2.canonical.z], c2.u_zoom_transition = Ed(s2.zoom);
            const e3 = n2[0] * sr, i3 = n2[1] * sr;
            c2.u_up_dir = s2.projection.upVector(new ku(0, 0, 0), e3, i3);
          }
          return c2;
        }, kp = (e2) => {
          const t2 = [];
          return "map" === e2.paint.get("circle-pitch-alignment") && t2.push("PITCH_WITH_MAP"), "map" === e2.paint.get("circle-pitch-scale") && t2.push("SCALE_WITH_MAP"), t2;
        };
        function Op(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          if (o2 && e2.queryGeometry.isAboveHorizon)
            return false;
          o2 && (l2 *= e2.pixelToTileUnitsFactor);
          const c2 = e2.tileID.canonical, h2 = i2.projection.upVectorScale(c2, i2.center.lat, i2.worldSize).metersToTile;
          for (const u2 of t2)
            for (const t3 of u2) {
              const u3 = t3.add(a2), d2 = n2 && i2.elevation ? i2.elevation.exaggeration() * n2.getElevationAt(u3.x, u3.y, true) : 0, p2 = i2.projection.projectTilePoint(u3.x, u3.y, c2);
              if (d2 > 0) {
                const e3 = i2.projection.upVector(c2, u3.x, u3.y);
                p2.x += e3[0] * h2 * d2, p2.y += e3[1] * h2 * d2, p2.z += e3[2] * h2 * d2;
              }
              const f2 = o2 ? u3 : Bp(p2.x, p2.y, p2.z, r2), m2 = o2 ? e2.tilespaceRays.map((e3) => Up(e3, d2)) : e2.queryGeometry.screenGeometry, _2 = uu.transformMat4([], [p2.x, p2.y, p2.z, 1], r2);
              if (!s2 && o2 ? l2 *= _2[3] / i2.cameraToCenterDistance : s2 && !o2 && (l2 *= i2.cameraToCenterDistance / _2[3]), o2) {
                const e3 = Hd((t3.y / sr + c2.y) / (1 << c2.z));
                l2 /= i2.projection.pixelsPerMeter(e3, 1) / Zd(1, e3);
              }
              if (fp(m2, f2, l2))
                return true;
            }
          return false;
        }
        function Bp(e2, t2, i2, r2) {
          const n2 = uu.transformMat4([], [e2, t2, i2, 1], r2);
          return new y(n2[0] / n2[3], n2[1] / n2[3]);
        }
        const Fp = Mu.fromValues(0, 0, 0), Np = Mu.fromValues(0, 0, 1);
        function Up(e2, t2) {
          const i2 = Mu.create();
          return Fp[2] = t2, e2.intersectsPlane(Fp, Np, i2), new y(i2[0], i2[1]);
        }
        class Vp extends dp {
        }
        function jp(e2, { width: t2, height: i2 }, r2, n2) {
          if (n2) {
            if (n2 instanceof Uint8ClampedArray)
              n2 = new Uint8Array(n2.buffer);
            else if (n2.length !== t2 * i2 * r2)
              throw new RangeError("mismatched image size");
          } else
            n2 = new Uint8Array(t2 * i2 * r2);
          return e2.width = t2, e2.height = i2, e2.data = n2, e2;
        }
        function Gp(e2, t2, i2) {
          const { width: r2, height: n2 } = t2;
          r2 === e2.width && n2 === e2.height || (qp(e2, t2, { x: 0, y: 0 }, { x: 0, y: 0 }, { width: Math.min(e2.width, r2), height: Math.min(e2.height, n2) }, i2), e2.width = r2, e2.height = n2, e2.data = t2.data);
        }
        function qp(e2, t2, i2, r2, n2, o2) {
          if (0 === n2.width || 0 === n2.height)
            return t2;
          if (n2.width > e2.width || n2.height > e2.height || i2.x > e2.width - n2.width || i2.y > e2.height - n2.height)
            throw new RangeError("out of range source coordinates for image copy");
          if (n2.width > t2.width || n2.height > t2.height || r2.x > t2.width - n2.width || r2.y > t2.height - n2.height)
            throw new RangeError("out of range destination coordinates for image copy");
          const s2 = e2.data, a2 = t2.data;
          for (let l2 = 0; l2 < n2.height; l2++) {
            const c2 = ((i2.y + l2) * e2.width + i2.x) * o2, h2 = ((r2.y + l2) * t2.width + r2.x) * o2;
            for (let e3 = 0; e3 < n2.width * o2; e3++)
              a2[h2 + e3] = s2[c2 + e3];
          }
          return t2;
        }
        Is(Vp, "HeatmapBucket", { omit: ["layers"] });
        class Zp {
          constructor(e2, t2) {
            jp(this, e2, 1, t2);
          }
          resize(e2) {
            Gp(this, new Zp(e2), 1);
          }
          clone() {
            return new Zp({ width: this.width, height: this.height }, new Uint8Array(this.data));
          }
          static copy(e2, t2, i2, r2, n2) {
            qp(e2, t2, i2, r2, n2, 1);
          }
        }
        class $p {
          constructor(e2, t2) {
            jp(this, e2, 4, t2);
          }
          resize(e2) {
            Gp(this, new $p(e2), 4);
          }
          replace(e2, t2) {
            t2 ? this.data.set(e2) : this.data = e2 instanceof Uint8ClampedArray ? new Uint8Array(e2.buffer) : e2;
          }
          clone() {
            return new $p({ width: this.width, height: this.height }, new Uint8Array(this.data));
          }
          static copy(e2, t2, i2, r2, n2) {
            qp(e2, t2, i2, r2, n2, 4);
          }
        }
        class Hp {
          constructor(e2, t2) {
            this.width = e2.width, this.height = e2.height, this.data = t2 instanceof Uint8Array ? new Float32Array(t2.buffer) : t2;
          }
        }
        Is(Zp, "AlphaImage"), Is($p, "RGBAImage");
        const Wp = new da({ visibility: new ca(Ct.layout_heatmap.visibility) });
        var Xp = { paint: new da({ "heatmap-radius": new ha(Ct.paint_heatmap["heatmap-radius"]), "heatmap-weight": new ha(Ct.paint_heatmap["heatmap-weight"]), "heatmap-intensity": new ca(Ct.paint_heatmap["heatmap-intensity"]), "heatmap-color": new ua(Ct.paint_heatmap["heatmap-color"]), "heatmap-opacity": new ca(Ct.paint_heatmap["heatmap-opacity"]) }), layout: Wp };
        function Yp(e2) {
          const t2 = {}, i2 = e2.resolution || 256, r2 = e2.clips ? e2.clips.length : 1, n2 = e2.image || new $p({ width: i2, height: r2 }), o2 = (i3, r3, o3) => {
            t2[e2.evaluationKey] = o3;
            const s2 = e2.expression.evaluate(t2);
            s2 && (n2.data[i3 + r3 + 0] = Math.floor(255 * s2.r / s2.a), n2.data[i3 + r3 + 1] = Math.floor(255 * s2.g / s2.a), n2.data[i3 + r3 + 2] = Math.floor(255 * s2.b / s2.a), n2.data[i3 + r3 + 3] = Math.floor(255 * s2.a));
          };
          if (e2.clips)
            for (let t3 = 0, n3 = 0; t3 < r2; ++t3, n3 += 4 * i2)
              for (let r3 = 0, s2 = 0; r3 < i2; r3++, s2 += 4) {
                const a2 = r3 / (i2 - 1), { start: l2, end: c2 } = e2.clips[t3];
                o2(n3, s2, l2 * (1 - a2) + c2 * a2);
              }
          else
            for (let e3 = 0, t3 = 0; e3 < i2; e3++, t3 += 4)
              o2(0, t3, e3 / (i2 - 1));
          return n2;
        }
        const Kp = new da({ visibility: new ca(Ct.layout_hillshade.visibility) });
        var Jp = { paint: new da({ "hillshade-illumination-direction": new ca(Ct.paint_hillshade["hillshade-illumination-direction"]), "hillshade-illumination-anchor": new ca(Ct.paint_hillshade["hillshade-illumination-anchor"]), "hillshade-exaggeration": new ca(Ct.paint_hillshade["hillshade-exaggeration"]), "hillshade-shadow-color": new ca(Ct.paint_hillshade["hillshade-shadow-color"]), "hillshade-highlight-color": new ca(Ct.paint_hillshade["hillshade-highlight-color"]), "hillshade-accent-color": new ca(Ct.paint_hillshade["hillshade-accent-color"]), "hillshade-emissive-strength": new ca(Ct.paint_hillshade["hillshade-emissive-strength"]) }), layout: Kp };
        const Qp = ba([{ name: "a_pos", components: 2, type: "Int16" }], 4), { members: ef } = Qp;
        var tf = { exports: {} };
        function rf(e2, t2, i2) {
          i2 = i2 || 2;
          var r2, n2, o2, s2, a2, l2, c2, h2 = t2 && t2.length, u2 = h2 ? t2[0] * i2 : e2.length, d2 = nf(e2, 0, u2, i2, true), p2 = [];
          if (!d2 || d2.next === d2.prev)
            return p2;
          if (h2 && (d2 = function(e3, t3, i3, r3) {
            var n3, o3, s3, a3 = [];
            for (n3 = 0, o3 = t3.length; n3 < o3; n3++)
              (s3 = nf(e3, t3[n3] * r3, n3 < o3 - 1 ? t3[n3 + 1] * r3 : e3.length, r3, false)) === s3.next && (s3.steiner = true), a3.push(mf(s3));
            for (a3.sort(uf), n3 = 0; n3 < a3.length; n3++)
              i3 = df(a3[n3], i3);
            return i3;
          }(e2, t2, d2, i2)), e2.length > 80 * i2) {
            r2 = o2 = e2[0], n2 = s2 = e2[1];
            for (var f2 = i2; f2 < u2; f2 += i2)
              (a2 = e2[f2]) < r2 && (r2 = a2), (l2 = e2[f2 + 1]) < n2 && (n2 = l2), a2 > o2 && (o2 = a2), l2 > s2 && (s2 = l2);
            c2 = 0 !== (c2 = Math.max(o2 - r2, s2 - n2)) ? 32767 / c2 : 0;
          }
          return sf(d2, p2, i2, r2, n2, c2, 0), p2;
        }
        function nf(e2, t2, i2, r2, n2) {
          var o2, s2;
          if (n2 === If(e2, t2, i2, r2) > 0)
            for (o2 = t2; o2 < i2; o2 += r2)
              s2 = Mf(o2, e2[o2], e2[o2 + 1], s2);
          else
            for (o2 = i2 - r2; o2 >= t2; o2 -= r2)
              s2 = Mf(o2, e2[o2], e2[o2 + 1], s2);
          return s2 && xf(s2, s2.next) && (Af(s2), s2 = s2.next), s2;
        }
        function of(e2, t2) {
          if (!e2)
            return e2;
          t2 || (t2 = e2);
          var i2, r2 = e2;
          do {
            if (i2 = false, r2.steiner || !xf(r2, r2.next) && 0 !== yf(r2.prev, r2, r2.next))
              r2 = r2.next;
            else {
              if (Af(r2), (r2 = t2 = r2.prev) === r2.next)
                break;
              i2 = true;
            }
          } while (i2 || r2 !== t2);
          return t2;
        }
        function sf(e2, t2, i2, r2, n2, o2, s2) {
          if (e2) {
            !s2 && o2 && function(e3, t3, i3, r3) {
              var n3 = e3;
              do {
                0 === n3.z && (n3.z = ff(n3.x, n3.y, t3, i3, r3)), n3.prevZ = n3.prev, n3.nextZ = n3.next, n3 = n3.next;
              } while (n3 !== e3);
              n3.prevZ.nextZ = null, n3.prevZ = null, function(e4) {
                var t4, i4, r4, n4, o3, s3, a3, l3, c3 = 1;
                do {
                  for (i4 = e4, e4 = null, o3 = null, s3 = 0; i4; ) {
                    for (s3++, r4 = i4, a3 = 0, t4 = 0; t4 < c3 && (a3++, r4 = r4.nextZ); t4++)
                      ;
                    for (l3 = c3; a3 > 0 || l3 > 0 && r4; )
                      0 !== a3 && (0 === l3 || !r4 || i4.z <= r4.z) ? (n4 = i4, i4 = i4.nextZ, a3--) : (n4 = r4, r4 = r4.nextZ, l3--), o3 ? o3.nextZ = n4 : e4 = n4, n4.prevZ = o3, o3 = n4;
                    i4 = r4;
                  }
                  o3.nextZ = null, c3 *= 2;
                } while (s3 > 1);
              }(n3);
            }(e2, r2, n2, o2);
            for (var a2, l2, c2 = e2; e2.prev !== e2.next; )
              if (a2 = e2.prev, l2 = e2.next, o2 ? lf(e2, r2, n2, o2) : af(e2))
                t2.push(a2.i / i2 | 0), t2.push(e2.i / i2 | 0), t2.push(l2.i / i2 | 0), Af(e2), e2 = l2.next, c2 = l2.next;
              else if ((e2 = l2) === c2) {
                s2 ? 1 === s2 ? sf(e2 = cf(of(e2), t2, i2), t2, i2, r2, n2, o2, 2) : 2 === s2 && hf(e2, t2, i2, r2, n2, o2) : sf(of(e2), t2, i2, r2, n2, o2, 1);
                break;
              }
          }
        }
        function af(e2) {
          var t2 = e2.prev, i2 = e2, r2 = e2.next;
          if (yf(t2, i2, r2) >= 0)
            return false;
          for (var n2 = t2.x, o2 = i2.x, s2 = r2.x, a2 = t2.y, l2 = i2.y, c2 = r2.y, h2 = n2 < o2 ? n2 < s2 ? n2 : s2 : o2 < s2 ? o2 : s2, u2 = a2 < l2 ? a2 < c2 ? a2 : c2 : l2 < c2 ? l2 : c2, d2 = n2 > o2 ? n2 > s2 ? n2 : s2 : o2 > s2 ? o2 : s2, p2 = a2 > l2 ? a2 > c2 ? a2 : c2 : l2 > c2 ? l2 : c2, f2 = r2.next; f2 !== t2; ) {
            if (f2.x >= h2 && f2.x <= d2 && f2.y >= u2 && f2.y <= p2 && _f(n2, a2, o2, l2, s2, c2, f2.x, f2.y) && yf(f2.prev, f2, f2.next) >= 0)
              return false;
            f2 = f2.next;
          }
          return true;
        }
        function lf(e2, t2, i2, r2) {
          var n2 = e2.prev, o2 = e2, s2 = e2.next;
          if (yf(n2, o2, s2) >= 0)
            return false;
          for (var a2 = n2.x, l2 = o2.x, c2 = s2.x, h2 = n2.y, u2 = o2.y, d2 = s2.y, p2 = a2 < l2 ? a2 < c2 ? a2 : c2 : l2 < c2 ? l2 : c2, f2 = h2 < u2 ? h2 < d2 ? h2 : d2 : u2 < d2 ? u2 : d2, m2 = a2 > l2 ? a2 > c2 ? a2 : c2 : l2 > c2 ? l2 : c2, _2 = h2 > u2 ? h2 > d2 ? h2 : d2 : u2 > d2 ? u2 : d2, g2 = ff(p2, f2, t2, i2, r2), y2 = ff(m2, _2, t2, i2, r2), x2 = e2.prevZ, v2 = e2.nextZ; x2 && x2.z >= g2 && v2 && v2.z <= y2; ) {
            if (x2.x >= p2 && x2.x <= m2 && x2.y >= f2 && x2.y <= _2 && x2 !== n2 && x2 !== s2 && _f(a2, h2, l2, u2, c2, d2, x2.x, x2.y) && yf(x2.prev, x2, x2.next) >= 0)
              return false;
            if (x2 = x2.prevZ, v2.x >= p2 && v2.x <= m2 && v2.y >= f2 && v2.y <= _2 && v2 !== n2 && v2 !== s2 && _f(a2, h2, l2, u2, c2, d2, v2.x, v2.y) && yf(v2.prev, v2, v2.next) >= 0)
              return false;
            v2 = v2.nextZ;
          }
          for (; x2 && x2.z >= g2; ) {
            if (x2.x >= p2 && x2.x <= m2 && x2.y >= f2 && x2.y <= _2 && x2 !== n2 && x2 !== s2 && _f(a2, h2, l2, u2, c2, d2, x2.x, x2.y) && yf(x2.prev, x2, x2.next) >= 0)
              return false;
            x2 = x2.prevZ;
          }
          for (; v2 && v2.z <= y2; ) {
            if (v2.x >= p2 && v2.x <= m2 && v2.y >= f2 && v2.y <= _2 && v2 !== n2 && v2 !== s2 && _f(a2, h2, l2, u2, c2, d2, v2.x, v2.y) && yf(v2.prev, v2, v2.next) >= 0)
              return false;
            v2 = v2.nextZ;
          }
          return true;
        }
        function cf(e2, t2, i2) {
          var r2 = e2;
          do {
            var n2 = r2.prev, o2 = r2.next.next;
            !xf(n2, o2) && vf(n2, r2, r2.next, o2) && Tf(n2, o2) && Tf(o2, n2) && (t2.push(n2.i / i2 | 0), t2.push(r2.i / i2 | 0), t2.push(o2.i / i2 | 0), Af(r2), Af(r2.next), r2 = e2 = o2), r2 = r2.next;
          } while (r2 !== e2);
          return of(r2);
        }
        function hf(e2, t2, i2, r2, n2, o2) {
          var s2 = e2;
          do {
            for (var a2 = s2.next.next; a2 !== s2.prev; ) {
              if (s2.i !== a2.i && gf(s2, a2)) {
                var l2 = Ef(s2, a2);
                return s2 = of(s2, s2.next), l2 = of(l2, l2.next), sf(s2, t2, i2, r2, n2, o2, 0), void sf(l2, t2, i2, r2, n2, o2, 0);
              }
              a2 = a2.next;
            }
            s2 = s2.next;
          } while (s2 !== e2);
        }
        function uf(e2, t2) {
          return e2.x - t2.x;
        }
        function df(e2, t2) {
          var i2 = function(e3, t3) {
            var i3, r3 = t3, n2 = e3.x, o2 = e3.y, s2 = -1 / 0;
            do {
              if (o2 <= r3.y && o2 >= r3.next.y && r3.next.y !== r3.y) {
                var a2 = r3.x + (o2 - r3.y) * (r3.next.x - r3.x) / (r3.next.y - r3.y);
                if (a2 <= n2 && a2 > s2 && (s2 = a2, i3 = r3.x < r3.next.x ? r3 : r3.next, a2 === n2))
                  return i3;
              }
              r3 = r3.next;
            } while (r3 !== t3);
            if (!i3)
              return null;
            var l2, c2 = i3, h2 = i3.x, u2 = i3.y, d2 = 1 / 0;
            r3 = i3;
            do {
              n2 >= r3.x && r3.x >= h2 && n2 !== r3.x && _f(o2 < u2 ? n2 : s2, o2, h2, u2, o2 < u2 ? s2 : n2, o2, r3.x, r3.y) && (l2 = Math.abs(o2 - r3.y) / (n2 - r3.x), Tf(r3, e3) && (l2 < d2 || l2 === d2 && (r3.x > i3.x || r3.x === i3.x && pf(i3, r3))) && (i3 = r3, d2 = l2)), r3 = r3.next;
            } while (r3 !== c2);
            return i3;
          }(e2, t2);
          if (!i2)
            return t2;
          var r2 = Ef(i2, e2);
          return of(r2, r2.next), of(i2, i2.next);
        }
        function pf(e2, t2) {
          return yf(e2.prev, e2, t2.prev) < 0 && yf(t2.next, e2, e2.next) < 0;
        }
        function ff(e2, t2, i2, r2, n2) {
          return (e2 = 1431655765 & ((e2 = 858993459 & ((e2 = 252645135 & ((e2 = 16711935 & ((e2 = (e2 - i2) * n2 | 0) | e2 << 8)) | e2 << 4)) | e2 << 2)) | e2 << 1)) | (t2 = 1431655765 & ((t2 = 858993459 & ((t2 = 252645135 & ((t2 = 16711935 & ((t2 = (t2 - r2) * n2 | 0) | t2 << 8)) | t2 << 4)) | t2 << 2)) | t2 << 1)) << 1;
        }
        function mf(e2) {
          var t2 = e2, i2 = e2;
          do {
            (t2.x < i2.x || t2.x === i2.x && t2.y < i2.y) && (i2 = t2), t2 = t2.next;
          } while (t2 !== e2);
          return i2;
        }
        function _f(e2, t2, i2, r2, n2, o2, s2, a2) {
          return (n2 - s2) * (t2 - a2) >= (e2 - s2) * (o2 - a2) && (e2 - s2) * (r2 - a2) >= (i2 - s2) * (t2 - a2) && (i2 - s2) * (o2 - a2) >= (n2 - s2) * (r2 - a2);
        }
        function gf(e2, t2) {
          return e2.next.i !== t2.i && e2.prev.i !== t2.i && !function(e3, t3) {
            var i2 = e3;
            do {
              if (i2.i !== e3.i && i2.next.i !== e3.i && i2.i !== t3.i && i2.next.i !== t3.i && vf(i2, i2.next, e3, t3))
                return true;
              i2 = i2.next;
            } while (i2 !== e3);
            return false;
          }(e2, t2) && (Tf(e2, t2) && Tf(t2, e2) && function(e3, t3) {
            var i2 = e3, r2 = false, n2 = (e3.x + t3.x) / 2, o2 = (e3.y + t3.y) / 2;
            do {
              i2.y > o2 != i2.next.y > o2 && i2.next.y !== i2.y && n2 < (i2.next.x - i2.x) * (o2 - i2.y) / (i2.next.y - i2.y) + i2.x && (r2 = !r2), i2 = i2.next;
            } while (i2 !== e3);
            return r2;
          }(e2, t2) && (yf(e2.prev, e2, t2.prev) || yf(e2, t2.prev, t2)) || xf(e2, t2) && yf(e2.prev, e2, e2.next) > 0 && yf(t2.prev, t2, t2.next) > 0);
        }
        function yf(e2, t2, i2) {
          return (t2.y - e2.y) * (i2.x - t2.x) - (t2.x - e2.x) * (i2.y - t2.y);
        }
        function xf(e2, t2) {
          return e2.x === t2.x && e2.y === t2.y;
        }
        function vf(e2, t2, i2, r2) {
          var n2 = wf(yf(e2, t2, i2)), o2 = wf(yf(e2, t2, r2)), s2 = wf(yf(i2, r2, e2)), a2 = wf(yf(i2, r2, t2));
          return n2 !== o2 && s2 !== a2 || !(0 !== n2 || !bf(e2, i2, t2)) || !(0 !== o2 || !bf(e2, r2, t2)) || !(0 !== s2 || !bf(i2, e2, r2)) || !(0 !== a2 || !bf(i2, t2, r2));
        }
        function bf(e2, t2, i2) {
          return t2.x <= Math.max(e2.x, i2.x) && t2.x >= Math.min(e2.x, i2.x) && t2.y <= Math.max(e2.y, i2.y) && t2.y >= Math.min(e2.y, i2.y);
        }
        function wf(e2) {
          return e2 > 0 ? 1 : e2 < 0 ? -1 : 0;
        }
        function Tf(e2, t2) {
          return yf(e2.prev, e2, e2.next) < 0 ? yf(e2, t2, e2.next) >= 0 && yf(e2, e2.prev, t2) >= 0 : yf(e2, t2, e2.prev) < 0 || yf(e2, e2.next, t2) < 0;
        }
        function Ef(e2, t2) {
          var i2 = new Sf(e2.i, e2.x, e2.y), r2 = new Sf(t2.i, t2.x, t2.y), n2 = e2.next, o2 = t2.prev;
          return e2.next = t2, t2.prev = e2, i2.next = n2, n2.prev = i2, r2.next = i2, i2.prev = r2, o2.next = r2, r2.prev = o2, r2;
        }
        function Mf(e2, t2, i2, r2) {
          var n2 = new Sf(e2, t2, i2);
          return r2 ? (n2.next = r2.next, n2.prev = r2, r2.next.prev = n2, r2.next = n2) : (n2.prev = n2, n2.next = n2), n2;
        }
        function Af(e2) {
          e2.next.prev = e2.prev, e2.prev.next = e2.next, e2.prevZ && (e2.prevZ.nextZ = e2.nextZ), e2.nextZ && (e2.nextZ.prevZ = e2.prevZ);
        }
        function Sf(e2, t2, i2) {
          this.i = e2, this.x = t2, this.y = i2, this.prev = null, this.next = null, this.z = 0, this.prevZ = null, this.nextZ = null, this.steiner = false;
        }
        function If(e2, t2, i2, r2) {
          for (var n2 = 0, o2 = t2, s2 = i2 - r2; o2 < i2; o2 += r2)
            n2 += (e2[s2] - e2[o2]) * (e2[o2 + 1] + e2[s2 + 1]), s2 = o2;
          return n2;
        }
        tf.exports = rf, tf.exports.default = rf, rf.deviation = function(e2, t2, i2, r2) {
          var n2 = t2 && t2.length, o2 = Math.abs(If(e2, 0, n2 ? t2[0] * i2 : e2.length, i2));
          if (n2)
            for (var s2 = 0, a2 = t2.length; s2 < a2; s2++)
              o2 -= Math.abs(If(e2, t2[s2] * i2, s2 < a2 - 1 ? t2[s2 + 1] * i2 : e2.length, i2));
          var l2 = 0;
          for (s2 = 0; s2 < r2.length; s2 += 3) {
            var c2 = r2[s2] * i2, h2 = r2[s2 + 1] * i2, u2 = r2[s2 + 2] * i2;
            l2 += Math.abs((e2[c2] - e2[u2]) * (e2[h2 + 1] - e2[c2 + 1]) - (e2[c2] - e2[h2]) * (e2[u2 + 1] - e2[c2 + 1]));
          }
          return 0 === o2 && 0 === l2 ? 0 : Math.abs((l2 - o2) / o2);
        }, rf.flatten = function(e2) {
          for (var t2 = e2[0][0].length, i2 = { vertices: [], holes: [], dimensions: t2 }, r2 = 0, n2 = 0; n2 < e2.length; n2++) {
            for (var o2 = 0; o2 < e2[n2].length; o2++)
              for (var s2 = 0; s2 < t2; s2++)
                i2.vertices.push(e2[n2][o2][s2]);
            n2 > 0 && i2.holes.push(r2 += e2[n2 - 1].length);
          }
          return i2;
        };
        var Cf = d(tf.exports);
        function zf(e2, t2) {
          const i2 = e2.length;
          if (i2 <= 1)
            return [e2];
          const r2 = [];
          let n2, o2;
          for (let t3 = 0; t3 < i2; t3++) {
            const i3 = Y(e2[t3]);
            0 !== i3 && (e2[t3].area = Math.abs(i3), void 0 === o2 && (o2 = i3 < 0), o2 === i3 < 0 ? (n2 && r2.push(n2), n2 = [e2[t3]]) : n2.push(e2[t3]));
          }
          if (n2 && r2.push(n2), t2 > 1)
            for (let e3 = 0; e3 < r2.length; e3++)
              r2[e3].length <= t2 || (ki(r2[e3], t2, 1, r2[e3].length - 1, Df), r2[e3] = r2[e3].slice(0, t2));
          return r2;
        }
        function Df(e2, t2) {
          return t2.area - e2.area;
        }
        function Pf(e2, t2, i2) {
          const r2 = i2.patternDependencies;
          let n2 = false;
          for (const i3 of t2) {
            const t3 = i3.paint.get(`${e2}-pattern`);
            t3.isConstant() || (n2 = true);
            const o2 = t3.constantOr(null);
            o2 && (n2 = true, r2[o2] = true);
          }
          return n2;
        }
        function Rf(e2, t2, i2, r2, n2) {
          const o2 = n2.patternDependencies;
          for (const s2 of t2) {
            const t3 = s2.paint.get(`${e2}-pattern`).value;
            if ("constant" !== t3.kind) {
              let e3 = t3.evaluate({ zoom: r2 }, i2, {}, n2.availableImages);
              e3 = e3 && e3.name ? e3.name : e3, o2[e3] = true, i2.patterns[s2.id] = e3;
            }
          }
          return i2;
        }
        class Lf {
          constructor(e2) {
            this.zoom = e2.zoom, this.overscaling = e2.overscaling, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.index = e2.index, this.hasPattern = false, this.patternFeatures = [], this.layoutVertexArray = new Ta(), this.indexArray = new Va(), this.indexArray2 = new ka(), this.programConfigurations = new Hl(e2.layers, e2.zoom), this.segments = new dl(), this.segments2 = new dl(), this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id), this.projection = e2.projection;
          }
          populate(e2, t2, i2, r2) {
            this.hasPattern = Pf("fill", this.layers, t2);
            const n2 = this.layers[0].layout.get("fill-sort-key"), o2 = [];
            for (const { feature: s2, id: a2, index: l2, sourceLayerIndex: c2 } of e2) {
              const e3 = this.layers[0]._featureFilter.needGeometry, h2 = cp(s2, e3);
              if (!this.layers[0]._featureFilter.filter(new ea(this.zoom), h2, i2))
                continue;
              const u2 = n2 ? n2.evaluate(h2, {}, i2, t2.availableImages) : void 0, d2 = { id: a2, properties: s2.properties, type: s2.type, sourceLayerIndex: c2, index: l2, geometry: e3 ? h2.geometry : lp(s2, i2, r2), patterns: {}, sortKey: u2 };
              o2.push(d2);
            }
            n2 && o2.sort((e3, t3) => e3.sortKey - t3.sortKey);
            for (const r3 of o2) {
              const { geometry: n3, index: o3, sourceLayerIndex: s2 } = r3;
              if (this.hasPattern) {
                const e3 = Rf("fill", this.layers, r3, this.zoom, t2);
                this.patternFeatures.push(e3);
              } else
                this.addFeature(r3, n3, o3, i2, {}, t2.availableImages, t2.brightness);
              t2.featureIndex.insert(e2[o3].feature, n3, o3, s2, this.index);
            }
          }
          update(e2, t2, i2, r2, n2) {
            const o2 = 0 !== Object.keys(e2).length;
            o2 && !this.stateDependentLayers.length || this.programConfigurations.updatePaintArrays(e2, t2, o2 ? this.stateDependentLayers : this.layers, i2, r2, n2);
          }
          addFeatures(e2, t2, i2, r2, n2, o2) {
            for (const e3 of this.patternFeatures)
              this.addFeature(e3, e3.geometry, e3.index, t2, i2, r2, o2);
          }
          isEmpty() {
            return 0 === this.layoutVertexArray.length;
          }
          uploadPending() {
            return !this.uploaded || this.programConfigurations.needsUpload;
          }
          upload(e2) {
            this.uploaded || (this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, ef), this.indexBuffer = e2.createIndexBuffer(this.indexArray), this.indexBuffer2 = e2.createIndexBuffer(this.indexArray2)), this.programConfigurations.upload(e2), this.uploaded = true;
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.indexBuffer2.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.segments2.destroy());
          }
          addFeature(e2, t2, i2, r2, n2, o2 = [], s2) {
            for (const e3 of zf(t2, 500)) {
              let t3 = 0;
              for (const i4 of e3)
                t3 += i4.length;
              const i3 = this.segments.prepareSegment(t3, this.layoutVertexArray, this.indexArray), r3 = i3.vertexLength, n3 = [], o3 = [];
              for (const t4 of e3) {
                if (0 === t4.length)
                  continue;
                t4 !== e3[0] && o3.push(n3.length / 2);
                const i4 = this.segments2.prepareSegment(t4.length, this.layoutVertexArray, this.indexArray2), r4 = i4.vertexLength;
                this.layoutVertexArray.emplaceBack(t4[0].x, t4[0].y), this.indexArray2.emplaceBack(r4 + t4.length - 1, r4), n3.push(t4[0].x), n3.push(t4[0].y);
                for (let e4 = 1; e4 < t4.length; e4++)
                  this.layoutVertexArray.emplaceBack(t4[e4].x, t4[e4].y), this.indexArray2.emplaceBack(r4 + e4 - 1, r4 + e4), n3.push(t4[e4].x), n3.push(t4[e4].y);
                i4.vertexLength += t4.length, i4.primitiveLength += t4.length;
              }
              const s3 = Cf(n3, o3);
              for (let e4 = 0; e4 < s3.length; e4 += 3)
                this.indexArray.emplaceBack(r3 + s3[e4], r3 + s3[e4 + 1], r3 + s3[e4 + 2]);
              i3.vertexLength += t3, i3.primitiveLength += s3.length / 3;
            }
            this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length, e2, i2, n2, o2, r2, s2);
          }
        }
        Is(Lf, "FillBucket", { omit: ["layers", "patternFeatures"] });
        const kf = new da({ "fill-sort-key": new ha(Ct.layout_fill["fill-sort-key"]), visibility: new ca(Ct.layout_fill.visibility) });
        var Of = { paint: new da({ "fill-antialias": new ca(Ct.paint_fill["fill-antialias"]), "fill-opacity": new ha(Ct.paint_fill["fill-opacity"]), "fill-color": new ha(Ct.paint_fill["fill-color"]), "fill-outline-color": new ha(Ct.paint_fill["fill-outline-color"]), "fill-translate": new ca(Ct.paint_fill["fill-translate"]), "fill-translate-anchor": new ca(Ct.paint_fill["fill-translate-anchor"]), "fill-pattern": new ha(Ct.paint_fill["fill-pattern"]), "fill-emissive-strength": new ca(Ct.paint_fill["fill-emissive-strength"]) }), layout: kf };
        const Bf = ba([{ name: "a_pos_normal_ed", components: 4, type: "Int16" }]), Ff = ba([{ name: "a_pos_end", components: 4, type: "Int16" }, { name: "a_angular_offset_factor", components: 1, type: "Int16" }]), Nf = ba([{ name: "a_centroid_pos", components: 2, type: "Uint16" }]), Uf = ba([{ name: "a_hidden_by_landmark", components: 1, type: "Uint8" }]), Vf = ba([{ name: "a_pos_3", components: 3, type: "Int16" }, { name: "a_pos_normal_3", components: 3, type: "Int16" }]), { members: jf } = Bf;
        var Gf = {}, qf = _, Zf = $f;
        function $f(e2, t2, i2, r2, n2) {
          this.properties = {}, this.extent = i2, this.type = 0, this._pbf = e2, this._geometry = -1, this._keys = r2, this._values = n2, e2.readFields(Hf, this, t2);
        }
        function Hf(e2, t2, i2) {
          1 == e2 ? t2.id = i2.readVarint() : 2 == e2 ? function(e3, t3) {
            for (var i3 = e3.readVarint() + e3.pos; e3.pos < i3; ) {
              var r2 = t3._keys[e3.readVarint()], n2 = t3._values[e3.readVarint()];
              t3.properties[r2] = n2;
            }
          }(i2, t2) : 3 == e2 ? t2.type = i2.readVarint() : 4 == e2 && (t2._geometry = i2.pos);
        }
        function Wf(e2) {
          for (var t2, i2, r2 = 0, n2 = 0, o2 = e2.length, s2 = o2 - 1; n2 < o2; s2 = n2++)
            r2 += ((i2 = e2[s2]).x - (t2 = e2[n2]).x) * (t2.y + i2.y);
          return r2;
        }
        $f.types = ["Unknown", "Point", "LineString", "Polygon"], $f.prototype.loadGeometry = function() {
          var e2 = this._pbf;
          e2.pos = this._geometry;
          for (var t2, i2 = e2.readVarint() + e2.pos, r2 = 1, n2 = 0, o2 = 0, s2 = 0, a2 = []; e2.pos < i2; ) {
            if (n2 <= 0) {
              var l2 = e2.readVarint();
              r2 = 7 & l2, n2 = l2 >> 3;
            }
            if (n2--, 1 === r2 || 2 === r2)
              o2 += e2.readSVarint(), s2 += e2.readSVarint(), 1 === r2 && (t2 && a2.push(t2), t2 = []), t2.push(new qf(o2, s2));
            else {
              if (7 !== r2)
                throw new Error("unknown command " + r2);
              t2 && t2.push(t2[0].clone());
            }
          }
          return t2 && a2.push(t2), a2;
        }, $f.prototype.bbox = function() {
          var e2 = this._pbf;
          e2.pos = this._geometry;
          for (var t2 = e2.readVarint() + e2.pos, i2 = 1, r2 = 0, n2 = 0, o2 = 0, s2 = 1 / 0, a2 = -1 / 0, l2 = 1 / 0, c2 = -1 / 0; e2.pos < t2; ) {
            if (r2 <= 0) {
              var h2 = e2.readVarint();
              i2 = 7 & h2, r2 = h2 >> 3;
            }
            if (r2--, 1 === i2 || 2 === i2)
              (n2 += e2.readSVarint()) < s2 && (s2 = n2), n2 > a2 && (a2 = n2), (o2 += e2.readSVarint()) < l2 && (l2 = o2), o2 > c2 && (c2 = o2);
            else if (7 !== i2)
              throw new Error("unknown command " + i2);
          }
          return [s2, l2, a2, c2];
        }, $f.prototype.toGeoJSON = function(e2, t2, i2) {
          var r2, n2, o2 = this.extent * Math.pow(2, i2), s2 = this.extent * e2, a2 = this.extent * t2, l2 = this.loadGeometry(), c2 = $f.types[this.type];
          function h2(e3) {
            for (var t3 = 0; t3 < e3.length; t3++) {
              var i3 = e3[t3];
              e3[t3] = [360 * (i3.x + s2) / o2 - 180, 360 / Math.PI * Math.atan(Math.exp((180 - 360 * (i3.y + a2) / o2) * Math.PI / 180)) - 90];
            }
          }
          switch (this.type) {
            case 1:
              var u2 = [];
              for (r2 = 0; r2 < l2.length; r2++)
                u2[r2] = l2[r2][0];
              h2(l2 = u2);
              break;
            case 2:
              for (r2 = 0; r2 < l2.length; r2++)
                h2(l2[r2]);
              break;
            case 3:
              for (l2 = function(e3) {
                var t3 = e3.length;
                if (t3 <= 1)
                  return [e3];
                for (var i3, r3, n3 = [], o3 = 0; o3 < t3; o3++) {
                  var s3 = Wf(e3[o3]);
                  0 !== s3 && (void 0 === r3 && (r3 = s3 < 0), r3 === s3 < 0 ? (i3 && n3.push(i3), i3 = [e3[o3]]) : i3.push(e3[o3]));
                }
                return i3 && n3.push(i3), n3;
              }(l2), r2 = 0; r2 < l2.length; r2++)
                for (n2 = 0; n2 < l2[r2].length; n2++)
                  h2(l2[r2][n2]);
          }
          1 === l2.length ? l2 = l2[0] : c2 = "Multi" + c2;
          var d2 = { type: "Feature", geometry: { type: c2, coordinates: l2 }, properties: this.properties };
          return "id" in this && (d2.id = this.id), d2;
        };
        var Xf = Zf, Yf = Kf;
        function Kf(e2, t2) {
          this.version = 1, this.name = null, this.extent = 4096, this.length = 0, this._pbf = e2, this._keys = [], this._values = [], this._features = [], e2.readFields(Jf, this, t2), this.length = this._features.length;
        }
        function Jf(e2, t2, i2) {
          15 === e2 ? t2.version = i2.readVarint() : 1 === e2 ? t2.name = i2.readString() : 5 === e2 ? t2.extent = i2.readVarint() : 2 === e2 ? t2._features.push(i2.pos) : 3 === e2 ? t2._keys.push(i2.readString()) : 4 === e2 && t2._values.push(function(e3) {
            for (var t3 = null, i3 = e3.readVarint() + e3.pos; e3.pos < i3; ) {
              var r2 = e3.readVarint() >> 3;
              t3 = 1 === r2 ? e3.readString() : 2 === r2 ? e3.readFloat() : 3 === r2 ? e3.readDouble() : 4 === r2 ? e3.readVarint64() : 5 === r2 ? e3.readVarint() : 6 === r2 ? e3.readSVarint() : 7 === r2 ? e3.readBoolean() : null;
            }
            return t3;
          }(i2));
        }
        Kf.prototype.feature = function(e2) {
          if (e2 < 0 || e2 >= this._features.length)
            throw new Error("feature index out of bounds");
          this._pbf.pos = this._features[e2];
          var t2 = this._pbf.readVarint() + this._pbf.pos;
          return new Xf(this._pbf, t2, this.extent, this._keys, this._values);
        };
        var Qf = Yf;
        function em(e2, t2, i2) {
          if (3 === e2) {
            var r2 = new Qf(i2, i2.readVarint() + i2.pos);
            r2.length && (t2[r2.name] = r2);
          }
        }
        var tm = Gf.VectorTile = function(e2, t2) {
          this.layers = e2.readFields(em, {}, t2);
        }, im = Gf.VectorTileFeature = Zf;
        function rm(e2, t2, i2, r2) {
          const n2 = [], o2 = 0 === r2 ? (e3, t3, i3, r3, n3, o3) => {
            e3.push(new y(o3, i3 + (o3 - t3) / (r3 - t3) * (n3 - i3)));
          } : (e3, t3, i3, r3, n3, o3) => {
            e3.push(new y(t3 + (o3 - i3) / (n3 - i3) * (r3 - t3), o3));
          };
          for (const s2 of e2) {
            const e3 = [];
            for (const n3 of s2) {
              if (n3.length <= 2)
                continue;
              const s3 = [];
              for (let e4 = 0; e4 < n3.length - 1; e4++) {
                const a3 = n3[e4].x, l3 = n3[e4].y, c2 = n3[e4 + 1].x, h2 = n3[e4 + 1].y, u2 = 0 === r2 ? a3 : l3, d2 = 0 === r2 ? c2 : h2;
                u2 < t2 ? d2 > t2 && o2(s3, a3, l3, c2, h2, t2) : u2 > i2 ? d2 < i2 && o2(s3, a3, l3, c2, h2, i2) : s3.push(n3[e4]), d2 < t2 && u2 >= t2 && o2(s3, a3, l3, c2, h2, t2), d2 > i2 && u2 <= i2 && o2(s3, a3, l3, c2, h2, i2);
              }
              let a2 = n3[n3.length - 1];
              const l2 = 0 === r2 ? a2.x : a2.y;
              l2 >= t2 && l2 <= i2 && s3.push(a2), s3.length && (a2 = s3[s3.length - 1], s3[0].x === a2.x && s3[0].y === a2.y || s3.push(s3[0]), e3.push(s3));
            }
            e3.length && n2.push(e3);
          }
          return n2;
        }
        Gf.VectorTileLayer = Yf;
        class nm {
          constructor(e2) {
            this._stringToNumber = {}, this._numberToString = [];
            for (let t2 = 0; t2 < e2.length; t2++) {
              const i2 = e2[t2];
              this._stringToNumber[i2] = t2, this._numberToString[t2] = i2;
            }
          }
          encode(e2) {
            return this._stringToNumber[e2];
          }
          decode(e2) {
            return this._numberToString[e2];
          }
        }
        var om = {
          /*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
          read: function(e2, t2, i2, r2, n2) {
            var o2, s2, a2 = 8 * n2 - r2 - 1, l2 = (1 << a2) - 1, c2 = l2 >> 1, h2 = -7, u2 = i2 ? n2 - 1 : 0, d2 = i2 ? -1 : 1, p2 = e2[t2 + u2];
            for (u2 += d2, o2 = p2 & (1 << -h2) - 1, p2 >>= -h2, h2 += a2; h2 > 0; o2 = 256 * o2 + e2[t2 + u2], u2 += d2, h2 -= 8)
              ;
            for (s2 = o2 & (1 << -h2) - 1, o2 >>= -h2, h2 += r2; h2 > 0; s2 = 256 * s2 + e2[t2 + u2], u2 += d2, h2 -= 8)
              ;
            if (0 === o2)
              o2 = 1 - c2;
            else {
              if (o2 === l2)
                return s2 ? NaN : 1 / 0 * (p2 ? -1 : 1);
              s2 += Math.pow(2, r2), o2 -= c2;
            }
            return (p2 ? -1 : 1) * s2 * Math.pow(2, o2 - r2);
          },
          write: function(e2, t2, i2, r2, n2, o2) {
            var s2, a2, l2, c2 = 8 * o2 - n2 - 1, h2 = (1 << c2) - 1, u2 = h2 >> 1, d2 = 23 === n2 ? Math.pow(2, -24) - Math.pow(2, -77) : 0, p2 = r2 ? 0 : o2 - 1, f2 = r2 ? 1 : -1, m2 = t2 < 0 || 0 === t2 && 1 / t2 < 0 ? 1 : 0;
            for (t2 = Math.abs(t2), isNaN(t2) || t2 === 1 / 0 ? (a2 = isNaN(t2) ? 1 : 0, s2 = h2) : (s2 = Math.floor(Math.log(t2) / Math.LN2), t2 * (l2 = Math.pow(2, -s2)) < 1 && (s2--, l2 *= 2), (t2 += s2 + u2 >= 1 ? d2 / l2 : d2 * Math.pow(2, 1 - u2)) * l2 >= 2 && (s2++, l2 /= 2), s2 + u2 >= h2 ? (a2 = 0, s2 = h2) : s2 + u2 >= 1 ? (a2 = (t2 * l2 - 1) * Math.pow(2, n2), s2 += u2) : (a2 = t2 * Math.pow(2, u2 - 1) * Math.pow(2, n2), s2 = 0)); n2 >= 8; e2[i2 + p2] = 255 & a2, p2 += f2, a2 /= 256, n2 -= 8)
              ;
            for (s2 = s2 << n2 | a2, c2 += n2; c2 > 0; e2[i2 + p2] = 255 & s2, p2 += f2, s2 /= 256, c2 -= 8)
              ;
            e2[i2 + p2 - f2] |= 128 * m2;
          }
        }, sm = lm, am = om;
        function lm(e2) {
          this.buf = ArrayBuffer.isView && ArrayBuffer.isView(e2) ? e2 : new Uint8Array(e2 || 0), this.pos = 0, this.type = 0, this.length = this.buf.length;
        }
        lm.Varint = 0, lm.Fixed64 = 1, lm.Bytes = 2, lm.Fixed32 = 5;
        var cm = 4294967296, hm = 1 / cm, um = "undefined" == typeof TextDecoder ? null : new TextDecoder("utf8");
        function dm(e2) {
          return e2.type === lm.Bytes ? e2.readVarint() + e2.pos : e2.pos + 1;
        }
        function pm(e2, t2, i2) {
          return i2 ? 4294967296 * t2 + (e2 >>> 0) : 4294967296 * (t2 >>> 0) + (e2 >>> 0);
        }
        function fm(e2, t2, i2) {
          var r2 = t2 <= 16383 ? 1 : t2 <= 2097151 ? 2 : t2 <= 268435455 ? 3 : Math.floor(Math.log(t2) / (7 * Math.LN2));
          i2.realloc(r2);
          for (var n2 = i2.pos - 1; n2 >= e2; n2--)
            i2.buf[n2 + r2] = i2.buf[n2];
        }
        function mm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeVarint(e2[i2]);
        }
        function _m(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeSVarint(e2[i2]);
        }
        function gm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeFloat(e2[i2]);
        }
        function ym(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeDouble(e2[i2]);
        }
        function xm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeBoolean(e2[i2]);
        }
        function vm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeFixed32(e2[i2]);
        }
        function bm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeSFixed32(e2[i2]);
        }
        function wm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeFixed64(e2[i2]);
        }
        function Tm(e2, t2) {
          for (var i2 = 0; i2 < e2.length; i2++)
            t2.writeSFixed64(e2[i2]);
        }
        function Em(e2, t2) {
          return (e2[t2] | e2[t2 + 1] << 8 | e2[t2 + 2] << 16) + 16777216 * e2[t2 + 3];
        }
        function Mm(e2, t2, i2) {
          e2[i2] = t2, e2[i2 + 1] = t2 >>> 8, e2[i2 + 2] = t2 >>> 16, e2[i2 + 3] = t2 >>> 24;
        }
        function Am(e2, t2) {
          return (e2[t2] | e2[t2 + 1] << 8 | e2[t2 + 2] << 16) + (e2[t2 + 3] << 24);
        }
        lm.prototype = { destroy: function() {
          this.buf = null;
        }, readFields: function(e2, t2, i2) {
          for (i2 = i2 || this.length; this.pos < i2; ) {
            var r2 = this.readVarint(), n2 = r2 >> 3, o2 = this.pos;
            this.type = 7 & r2, e2(n2, t2, this), this.pos === o2 && this.skip(r2);
          }
          return t2;
        }, readMessage: function(e2, t2) {
          return this.readFields(e2, t2, this.readVarint() + this.pos);
        }, readFixed32: function() {
          var e2 = Em(this.buf, this.pos);
          return this.pos += 4, e2;
        }, readSFixed32: function() {
          var e2 = Am(this.buf, this.pos);
          return this.pos += 4, e2;
        }, readFixed64: function() {
          var e2 = Em(this.buf, this.pos) + Em(this.buf, this.pos + 4) * cm;
          return this.pos += 8, e2;
        }, readSFixed64: function() {
          var e2 = Em(this.buf, this.pos) + Am(this.buf, this.pos + 4) * cm;
          return this.pos += 8, e2;
        }, readFloat: function() {
          var e2 = am.read(this.buf, this.pos, true, 23, 4);
          return this.pos += 4, e2;
        }, readDouble: function() {
          var e2 = am.read(this.buf, this.pos, true, 52, 8);
          return this.pos += 8, e2;
        }, readVarint: function(e2) {
          var t2, i2, r2 = this.buf;
          return t2 = 127 & (i2 = r2[this.pos++]), i2 < 128 ? t2 : (t2 |= (127 & (i2 = r2[this.pos++])) << 7, i2 < 128 ? t2 : (t2 |= (127 & (i2 = r2[this.pos++])) << 14, i2 < 128 ? t2 : (t2 |= (127 & (i2 = r2[this.pos++])) << 21, i2 < 128 ? t2 : function(e3, t3, i3) {
            var r3, n2, o2 = i3.buf;
            if (r3 = (112 & (n2 = o2[i3.pos++])) >> 4, n2 < 128)
              return pm(e3, r3, t3);
            if (r3 |= (127 & (n2 = o2[i3.pos++])) << 3, n2 < 128)
              return pm(e3, r3, t3);
            if (r3 |= (127 & (n2 = o2[i3.pos++])) << 10, n2 < 128)
              return pm(e3, r3, t3);
            if (r3 |= (127 & (n2 = o2[i3.pos++])) << 17, n2 < 128)
              return pm(e3, r3, t3);
            if (r3 |= (127 & (n2 = o2[i3.pos++])) << 24, n2 < 128)
              return pm(e3, r3, t3);
            if (r3 |= (1 & (n2 = o2[i3.pos++])) << 31, n2 < 128)
              return pm(e3, r3, t3);
            throw new Error("Expected varint not more than 10 bytes");
          }(t2 |= (15 & (i2 = r2[this.pos])) << 28, e2, this))));
        }, readVarint64: function() {
          return this.readVarint(true);
        }, readSVarint: function() {
          var e2 = this.readVarint();
          return e2 % 2 == 1 ? (e2 + 1) / -2 : e2 / 2;
        }, readBoolean: function() {
          return Boolean(this.readVarint());
        }, readString: function() {
          var e2 = this.readVarint() + this.pos, t2 = this.pos;
          return this.pos = e2, e2 - t2 >= 12 && um ? function(e3, t3, i2) {
            return um.decode(e3.subarray(t3, i2));
          }(this.buf, t2, e2) : function(e3, t3, i2) {
            for (var r2 = "", n2 = t3; n2 < i2; ) {
              var o2, s2, a2, l2 = e3[n2], c2 = null, h2 = l2 > 239 ? 4 : l2 > 223 ? 3 : l2 > 191 ? 2 : 1;
              if (n2 + h2 > i2)
                break;
              1 === h2 ? l2 < 128 && (c2 = l2) : 2 === h2 ? 128 == (192 & (o2 = e3[n2 + 1])) && (c2 = (31 & l2) << 6 | 63 & o2) <= 127 && (c2 = null) : 3 === h2 ? (s2 = e3[n2 + 2], 128 == (192 & (o2 = e3[n2 + 1])) && 128 == (192 & s2) && ((c2 = (15 & l2) << 12 | (63 & o2) << 6 | 63 & s2) <= 2047 || c2 >= 55296 && c2 <= 57343) && (c2 = null)) : 4 === h2 && (s2 = e3[n2 + 2], a2 = e3[n2 + 3], 128 == (192 & (o2 = e3[n2 + 1])) && 128 == (192 & s2) && 128 == (192 & a2) && ((c2 = (15 & l2) << 18 | (63 & o2) << 12 | (63 & s2) << 6 | 63 & a2) <= 65535 || c2 >= 1114112) && (c2 = null)), null === c2 ? (c2 = 65533, h2 = 1) : c2 > 65535 && (c2 -= 65536, r2 += String.fromCharCode(c2 >>> 10 & 1023 | 55296), c2 = 56320 | 1023 & c2), r2 += String.fromCharCode(c2), n2 += h2;
            }
            return r2;
          }(this.buf, t2, e2);
        }, readBytes: function() {
          var e2 = this.readVarint() + this.pos, t2 = this.buf.subarray(this.pos, e2);
          return this.pos = e2, t2;
        }, readPackedVarint: function(e2, t2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readVarint(t2));
          var i2 = dm(this);
          for (e2 = e2 || []; this.pos < i2; )
            e2.push(this.readVarint(t2));
          return e2;
        }, readPackedSVarint: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readSVarint());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readSVarint());
          return e2;
        }, readPackedBoolean: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readBoolean());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readBoolean());
          return e2;
        }, readPackedFloat: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readFloat());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readFloat());
          return e2;
        }, readPackedDouble: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readDouble());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readDouble());
          return e2;
        }, readPackedFixed32: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readFixed32());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readFixed32());
          return e2;
        }, readPackedSFixed32: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readSFixed32());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readSFixed32());
          return e2;
        }, readPackedFixed64: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readFixed64());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readFixed64());
          return e2;
        }, readPackedSFixed64: function(e2) {
          if (this.type !== lm.Bytes)
            return e2.push(this.readSFixed64());
          var t2 = dm(this);
          for (e2 = e2 || []; this.pos < t2; )
            e2.push(this.readSFixed64());
          return e2;
        }, skip: function(e2) {
          var t2 = 7 & e2;
          if (t2 === lm.Varint)
            for (; this.buf[this.pos++] > 127; )
              ;
          else if (t2 === lm.Bytes)
            this.pos = this.readVarint() + this.pos;
          else if (t2 === lm.Fixed32)
            this.pos += 4;
          else {
            if (t2 !== lm.Fixed64)
              throw new Error("Unimplemented type: " + t2);
            this.pos += 8;
          }
        }, writeTag: function(e2, t2) {
          this.writeVarint(e2 << 3 | t2);
        }, realloc: function(e2) {
          for (var t2 = this.length || 16; t2 < this.pos + e2; )
            t2 *= 2;
          if (t2 !== this.length) {
            var i2 = new Uint8Array(t2);
            i2.set(this.buf), this.buf = i2, this.length = t2;
          }
        }, finish: function() {
          return this.length = this.pos, this.pos = 0, this.buf.subarray(0, this.length);
        }, writeFixed32: function(e2) {
          this.realloc(4), Mm(this.buf, e2, this.pos), this.pos += 4;
        }, writeSFixed32: function(e2) {
          this.realloc(4), Mm(this.buf, e2, this.pos), this.pos += 4;
        }, writeFixed64: function(e2) {
          this.realloc(8), Mm(this.buf, -1 & e2, this.pos), Mm(this.buf, Math.floor(e2 * hm), this.pos + 4), this.pos += 8;
        }, writeSFixed64: function(e2) {
          this.realloc(8), Mm(this.buf, -1 & e2, this.pos), Mm(this.buf, Math.floor(e2 * hm), this.pos + 4), this.pos += 8;
        }, writeVarint: function(e2) {
          (e2 = +e2 || 0) > 268435455 || e2 < 0 ? function(e3, t2) {
            var i2, r2;
            if (e3 >= 0 ? (i2 = e3 % 4294967296 | 0, r2 = e3 / 4294967296 | 0) : (r2 = ~(-e3 / 4294967296), 4294967295 ^ (i2 = ~(-e3 % 4294967296)) ? i2 = i2 + 1 | 0 : (i2 = 0, r2 = r2 + 1 | 0)), e3 >= 18446744073709552e3 || e3 < -18446744073709552e3)
              throw new Error("Given varint doesn't fit into 10 bytes");
            t2.realloc(10), function(e4, t3, i3) {
              i3.buf[i3.pos++] = 127 & e4 | 128, e4 >>>= 7, i3.buf[i3.pos++] = 127 & e4 | 128, e4 >>>= 7, i3.buf[i3.pos++] = 127 & e4 | 128, e4 >>>= 7, i3.buf[i3.pos++] = 127 & e4 | 128, i3.buf[i3.pos] = 127 & (e4 >>>= 7);
            }(i2, 0, t2), function(e4, t3) {
              var i3 = (7 & e4) << 4;
              t3.buf[t3.pos++] |= i3 | ((e4 >>>= 3) ? 128 : 0), e4 && (t3.buf[t3.pos++] = 127 & e4 | ((e4 >>>= 7) ? 128 : 0), e4 && (t3.buf[t3.pos++] = 127 & e4 | ((e4 >>>= 7) ? 128 : 0), e4 && (t3.buf[t3.pos++] = 127 & e4 | ((e4 >>>= 7) ? 128 : 0), e4 && (t3.buf[t3.pos++] = 127 & e4 | ((e4 >>>= 7) ? 128 : 0), e4 && (t3.buf[t3.pos++] = 127 & e4)))));
            }(r2, t2);
          }(e2, this) : (this.realloc(4), this.buf[this.pos++] = 127 & e2 | (e2 > 127 ? 128 : 0), e2 <= 127 || (this.buf[this.pos++] = 127 & (e2 >>>= 7) | (e2 > 127 ? 128 : 0), e2 <= 127 || (this.buf[this.pos++] = 127 & (e2 >>>= 7) | (e2 > 127 ? 128 : 0), e2 <= 127 || (this.buf[this.pos++] = e2 >>> 7 & 127))));
        }, writeSVarint: function(e2) {
          this.writeVarint(e2 < 0 ? 2 * -e2 - 1 : 2 * e2);
        }, writeBoolean: function(e2) {
          this.writeVarint(Boolean(e2));
        }, writeString: function(e2) {
          e2 = String(e2), this.realloc(4 * e2.length), this.pos++;
          var t2 = this.pos;
          this.pos = function(e3, t3, i3) {
            for (var r2, n2, o2 = 0; o2 < t3.length; o2++) {
              if ((r2 = t3.charCodeAt(o2)) > 55295 && r2 < 57344) {
                if (!n2) {
                  r2 > 56319 || o2 + 1 === t3.length ? (e3[i3++] = 239, e3[i3++] = 191, e3[i3++] = 189) : n2 = r2;
                  continue;
                }
                if (r2 < 56320) {
                  e3[i3++] = 239, e3[i3++] = 191, e3[i3++] = 189, n2 = r2;
                  continue;
                }
                r2 = n2 - 55296 << 10 | r2 - 56320 | 65536, n2 = null;
              } else
                n2 && (e3[i3++] = 239, e3[i3++] = 191, e3[i3++] = 189, n2 = null);
              r2 < 128 ? e3[i3++] = r2 : (r2 < 2048 ? e3[i3++] = r2 >> 6 | 192 : (r2 < 65536 ? e3[i3++] = r2 >> 12 | 224 : (e3[i3++] = r2 >> 18 | 240, e3[i3++] = r2 >> 12 & 63 | 128), e3[i3++] = r2 >> 6 & 63 | 128), e3[i3++] = 63 & r2 | 128);
            }
            return i3;
          }(this.buf, e2, this.pos);
          var i2 = this.pos - t2;
          i2 >= 128 && fm(t2, i2, this), this.pos = t2 - 1, this.writeVarint(i2), this.pos += i2;
        }, writeFloat: function(e2) {
          this.realloc(4), am.write(this.buf, e2, this.pos, true, 23, 4), this.pos += 4;
        }, writeDouble: function(e2) {
          this.realloc(8), am.write(this.buf, e2, this.pos, true, 52, 8), this.pos += 8;
        }, writeBytes: function(e2) {
          var t2 = e2.length;
          this.writeVarint(t2), this.realloc(t2);
          for (var i2 = 0; i2 < t2; i2++)
            this.buf[this.pos++] = e2[i2];
        }, writeRawMessage: function(e2, t2) {
          this.pos++;
          var i2 = this.pos;
          e2(t2, this);
          var r2 = this.pos - i2;
          r2 >= 128 && fm(i2, r2, this), this.pos = i2 - 1, this.writeVarint(r2), this.pos += r2;
        }, writeMessage: function(e2, t2, i2) {
          this.writeTag(e2, lm.Bytes), this.writeRawMessage(t2, i2);
        }, writePackedVarint: function(e2, t2) {
          t2.length && this.writeMessage(e2, mm, t2);
        }, writePackedSVarint: function(e2, t2) {
          t2.length && this.writeMessage(e2, _m, t2);
        }, writePackedBoolean: function(e2, t2) {
          t2.length && this.writeMessage(e2, xm, t2);
        }, writePackedFloat: function(e2, t2) {
          t2.length && this.writeMessage(e2, gm, t2);
        }, writePackedDouble: function(e2, t2) {
          t2.length && this.writeMessage(e2, ym, t2);
        }, writePackedFixed32: function(e2, t2) {
          t2.length && this.writeMessage(e2, vm, t2);
        }, writePackedSFixed32: function(e2, t2) {
          t2.length && this.writeMessage(e2, bm, t2);
        }, writePackedFixed64: function(e2, t2) {
          t2.length && this.writeMessage(e2, wm, t2);
        }, writePackedSFixed64: function(e2, t2) {
          t2.length && this.writeMessage(e2, Tm, t2);
        }, writeBytesField: function(e2, t2) {
          this.writeTag(e2, lm.Bytes), this.writeBytes(t2);
        }, writeFixed32Field: function(e2, t2) {
          this.writeTag(e2, lm.Fixed32), this.writeFixed32(t2);
        }, writeSFixed32Field: function(e2, t2) {
          this.writeTag(e2, lm.Fixed32), this.writeSFixed32(t2);
        }, writeFixed64Field: function(e2, t2) {
          this.writeTag(e2, lm.Fixed64), this.writeFixed64(t2);
        }, writeSFixed64Field: function(e2, t2) {
          this.writeTag(e2, lm.Fixed64), this.writeSFixed64(t2);
        }, writeVarintField: function(e2, t2) {
          this.writeTag(e2, lm.Varint), this.writeVarint(t2);
        }, writeSVarintField: function(e2, t2) {
          this.writeTag(e2, lm.Varint), this.writeSVarint(t2);
        }, writeStringField: function(e2, t2) {
          this.writeTag(e2, lm.Bytes), this.writeString(t2);
        }, writeFloatField: function(e2, t2) {
          this.writeTag(e2, lm.Fixed32), this.writeFloat(t2);
        }, writeDoubleField: function(e2, t2) {
          this.writeTag(e2, lm.Fixed64), this.writeDouble(t2);
        }, writeBooleanField: function(e2, t2) {
          this.writeVarintField(e2, Boolean(t2));
        } };
        var Sm = d(sm);
        const Im = ["tile", "layer", "source", "sourceLayer", "state"];
        class Cm {
          constructor(e2, t2, i2, r2, n2) {
            this.type = "Feature", this._vectorTileFeature = e2, this._z = t2, this._x = i2, this._y = r2, this.properties = e2.properties, this.id = n2;
          }
          get geometry() {
            return void 0 === this._geometry && (this._geometry = this._vectorTileFeature.toGeoJSON(this._x, this._y, this._z).geometry), this._geometry;
          }
          set geometry(e2) {
            this._geometry = e2;
          }
          toJSON() {
            const e2 = { type: "Feature", state: void 0, geometry: this.geometry, properties: this.properties };
            void 0 !== this.id && (e2.id = this.id);
            for (const t2 of Im)
              void 0 !== this[t2] && (e2[t2] = this[t2]);
            return e2;
          }
        }
        class zm {
          constructor() {
            this.state = {}, this.stateChanges = {}, this.deletedStates = {};
          }
          updateState(e2, t2, i2) {
            const r2 = String(t2);
            if (this.stateChanges[e2] = this.stateChanges[e2] || {}, this.stateChanges[e2][r2] = this.stateChanges[e2][r2] || {}, k(this.stateChanges[e2][r2], i2), null === this.deletedStates[e2]) {
              this.deletedStates[e2] = {};
              for (const t3 in this.state[e2])
                t3 !== r2 && (this.deletedStates[e2][t3] = null);
            } else if (this.deletedStates[e2] && null === this.deletedStates[e2][r2]) {
              this.deletedStates[e2][r2] = {};
              for (const t3 in this.state[e2][r2])
                i2[t3] || (this.deletedStates[e2][r2][t3] = null);
            } else
              for (const t3 in i2)
                this.deletedStates[e2] && this.deletedStates[e2][r2] && null === this.deletedStates[e2][r2][t3] && delete this.deletedStates[e2][r2][t3];
          }
          removeFeatureState(e2, t2, i2) {
            if (null === this.deletedStates[e2])
              return;
            const r2 = String(t2);
            if (this.deletedStates[e2] = this.deletedStates[e2] || {}, i2 && void 0 !== t2)
              null !== this.deletedStates[e2][r2] && (this.deletedStates[e2][r2] = this.deletedStates[e2][r2] || {}, this.deletedStates[e2][r2][i2] = null);
            else if (void 0 !== t2)
              if (this.stateChanges[e2] && this.stateChanges[e2][r2])
                for (i2 in this.deletedStates[e2][r2] = {}, this.stateChanges[e2][r2])
                  this.deletedStates[e2][r2][i2] = null;
              else
                this.deletedStates[e2][r2] = null;
            else
              this.deletedStates[e2] = null;
          }
          getState(e2, t2) {
            const i2 = String(t2), r2 = k({}, (this.state[e2] || {})[i2], (this.stateChanges[e2] || {})[i2]);
            if (null === this.deletedStates[e2])
              return {};
            if (this.deletedStates[e2]) {
              const i3 = this.deletedStates[e2][t2];
              if (null === i3)
                return {};
              for (const e3 in i3)
                delete r2[e3];
            }
            return r2;
          }
          initializeTileState(e2, t2) {
            e2.setFeatureState(this.state, t2);
          }
          coalesceChanges(e2, t2) {
            const i2 = {};
            for (const e3 in this.stateChanges) {
              this.state[e3] = this.state[e3] || {};
              const t3 = {};
              for (const i3 in this.stateChanges[e3])
                this.state[e3][i3] || (this.state[e3][i3] = {}), k(this.state[e3][i3], this.stateChanges[e3][i3]), t3[i3] = this.state[e3][i3];
              i2[e3] = t3;
            }
            for (const e3 in this.deletedStates) {
              this.state[e3] = this.state[e3] || {};
              const t3 = {};
              if (null === this.deletedStates[e3])
                for (const i3 in this.state[e3])
                  t3[i3] = {}, this.state[e3][i3] = {};
              else
                for (const i3 in this.deletedStates[e3]) {
                  if (null === this.deletedStates[e3][i3])
                    this.state[e3][i3] = {};
                  else if (this.state[e3][i3])
                    for (const t4 of Object.keys(this.deletedStates[e3][i3]))
                      delete this.state[e3][i3][t4];
                  t3[i3] = this.state[e3][i3];
                }
              i2[e3] = i2[e3] || {}, k(i2[e3], t3);
            }
            if (this.stateChanges = {}, this.deletedStates = {}, 0 !== Object.keys(i2).length)
              for (const r2 in e2)
                e2[r2].setFeatureState(i2, t2);
          }
        }
        class Dm {
          constructor(e2) {
            this.size = e2, this.minimums = [], this.maximums = [], this.leaves = [];
          }
          getElevation(e2, t2) {
            const i2 = this.toIdx(e2, t2);
            return { min: this.minimums[i2], max: this.maximums[i2] };
          }
          isLeaf(e2, t2) {
            return this.leaves[this.toIdx(e2, t2)];
          }
          toIdx(e2, t2) {
            return t2 * this.size + e2;
          }
        }
        function Pm(e2, t2, i2, r2) {
          let n2 = 0, o2 = Number.MAX_VALUE;
          for (let s2 = 0; s2 < 3; s2++)
            if (Math.abs(r2[s2]) < 1e-15) {
              if (i2[s2] < e2[s2] || i2[s2] > t2[s2])
                return null;
            } else {
              const a2 = 1 / r2[s2];
              let l2 = (e2[s2] - i2[s2]) * a2, c2 = (t2[s2] - i2[s2]) * a2;
              if (l2 > c2) {
                const e3 = l2;
                l2 = c2, c2 = e3;
              }
              if (l2 > n2 && (n2 = l2), c2 < o2 && (o2 = c2), n2 > o2)
                return null;
            }
          return n2;
        }
        function Rm(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2) {
          const u2 = r2 - e2, d2 = n2 - t2, p2 = o2 - i2, f2 = s2 - e2, m2 = a2 - t2, _2 = l2 - i2, g2 = h2[1] * _2 - h2[2] * m2, y2 = h2[2] * f2 - h2[0] * _2, x2 = h2[0] * m2 - h2[1] * f2, v2 = u2 * g2 + d2 * y2 + p2 * x2;
          if (Math.abs(v2) < 1e-15)
            return null;
          const b2 = 1 / v2, w2 = c2[0] - e2, T2 = c2[1] - t2, E2 = c2[2] - i2, M2 = (w2 * g2 + T2 * y2 + E2 * x2) * b2;
          if (M2 < 0 || M2 > 1)
            return null;
          const A2 = T2 * p2 - E2 * d2, S2 = E2 * u2 - w2 * p2, I2 = w2 * d2 - T2 * u2, C2 = (h2[0] * A2 + h2[1] * S2 + h2[2] * I2) * b2;
          return C2 < 0 || M2 + C2 > 1 ? null : (f2 * A2 + m2 * S2 + _2 * I2) * b2;
        }
        function Lm(e2, t2, i2) {
          return (e2 - t2) / (i2 - t2);
        }
        function km(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          const c2 = 1 << i2, h2 = o2 - r2, u2 = s2 - n2, d2 = (e2 + 1) / c2 * h2 + r2, p2 = (t2 + 0) / c2 * u2 + n2, f2 = (t2 + 1) / c2 * u2 + n2;
          a2[0] = (e2 + 0) / c2 * h2 + r2, a2[1] = p2, l2[0] = d2, l2[1] = f2;
        }
        class Om {
          constructor(e2) {
            if (this.maximums = [], this.minimums = [], this.leaves = [], this.childOffsets = [], this.nodeCount = 0, this.dem = e2, this._siblingOffset = [[0, 0], [1, 0], [0, 1], [1, 1]], !this.dem)
              return;
            const t2 = function(e3) {
              const t3 = Math.ceil(Math.log2(e3.dim / 8)), i3 = [];
              let r3 = Math.ceil(Math.pow(2, t3));
              const n2 = 1 / r3, o2 = (e4, t4, i4, r4, n3) => {
                const o3 = r4 ? 1 : 0, s3 = (e4 + 1) * i4 - o3, a3 = t4 * i4, l2 = (t4 + 1) * i4 - o3;
                n3[0] = e4 * i4, n3[1] = a3, n3[2] = s3, n3[3] = l2;
              };
              let s2 = new Dm(r3);
              const a2 = [];
              for (let t4 = 0; t4 < r3 * r3; t4++) {
                o2(t4 % r3, Math.floor(t4 / r3), n2, false, a2);
                const i4 = Fm(a2[0], a2[1], e3), l2 = Fm(a2[2], a2[1], e3), c2 = Fm(a2[2], a2[3], e3), h2 = Fm(a2[0], a2[3], e3);
                s2.minimums.push(Math.min(i4, l2, c2, h2)), s2.maximums.push(Math.max(i4, l2, c2, h2)), s2.leaves.push(1);
              }
              for (i3.push(s2), r3 /= 2; r3 >= 1; r3 /= 2) {
                const e4 = i3[i3.length - 1];
                s2 = new Dm(r3);
                for (let t4 = 0; t4 < r3 * r3; t4++) {
                  o2(t4 % r3, Math.floor(t4 / r3), 2, true, a2);
                  const i4 = e4.getElevation(a2[0], a2[1]), n3 = e4.getElevation(a2[2], a2[1]), l2 = e4.getElevation(a2[2], a2[3]), c2 = e4.getElevation(a2[0], a2[3]), h2 = e4.isLeaf(a2[0], a2[1]), u2 = e4.isLeaf(a2[2], a2[1]), d2 = e4.isLeaf(a2[2], a2[3]), p2 = e4.isLeaf(a2[0], a2[3]), f2 = Math.min(i4.min, n3.min, l2.min, c2.min), m2 = Math.max(i4.max, n3.max, l2.max, c2.max), _2 = h2 && u2 && d2 && p2;
                  s2.maximums.push(m2), s2.minimums.push(f2), s2.leaves.push(m2 - f2 <= 5 && _2 ? 1 : 0);
                }
                i3.push(s2);
              }
              return i3;
            }(this.dem), i2 = t2.length - 1, r2 = t2[i2];
            this._addNode(r2.minimums[0], r2.maximums[0], r2.leaves[0]), this._construct(t2, 0, 0, i2, 0);
          }
          raycastRoot(e2, t2, i2, r2, n2, o2, s2 = 1) {
            return Pm([e2, t2, -100], [i2, r2, this.maximums[0] * s2], n2, o2);
          }
          raycast(e2, t2, i2, r2, n2, o2, s2 = 1) {
            if (!this.nodeCount)
              return null;
            const a2 = this.raycastRoot(e2, t2, i2, r2, n2, o2, s2);
            if (null == a2)
              return null;
            const l2 = [], c2 = [], h2 = [], u2 = [], d2 = [{ idx: 0, t: a2, nodex: 0, nodey: 0, depth: 0 }];
            for (; d2.length > 0; ) {
              const { idx: a3, t: p2, nodex: f2, nodey: m2, depth: _2 } = d2.pop();
              if (this.leaves[a3]) {
                km(f2, m2, _2, e2, t2, i2, r2, h2, u2);
                const a4 = 1 << _2, l3 = (f2 + 0) / a4, c3 = (f2 + 1) / a4, d3 = (m2 + 0) / a4, g3 = (m2 + 1) / a4, y2 = Fm(l3, d3, this.dem) * s2, x2 = Fm(c3, d3, this.dem) * s2, v2 = Fm(c3, g3, this.dem) * s2, b2 = Fm(l3, g3, this.dem) * s2, w2 = Rm(h2[0], h2[1], y2, u2[0], h2[1], x2, u2[0], u2[1], v2, n2, o2), T2 = Rm(u2[0], u2[1], v2, h2[0], u2[1], b2, h2[0], h2[1], y2, n2, o2), E2 = Math.min(null !== w2 ? w2 : Number.MAX_VALUE, null !== T2 ? T2 : Number.MAX_VALUE);
                if (E2 !== Number.MAX_VALUE)
                  return E2;
                {
                  const e3 = Mu.scaleAndAdd([], n2, o2, p2);
                  if (Bm(y2, x2, b2, v2, Lm(e3[0], h2[0], u2[0]), Lm(e3[1], h2[1], u2[1])) >= e3[2])
                    return p2;
                }
                continue;
              }
              let g2 = 0;
              for (let d3 = 0; d3 < this._siblingOffset.length; d3++) {
                km((f2 << 1) + this._siblingOffset[d3][0], (m2 << 1) + this._siblingOffset[d3][1], _2 + 1, e2, t2, i2, r2, h2, u2), h2[2] = -100, u2[2] = this.maximums[this.childOffsets[a3] + d3] * s2;
                const p3 = Pm(h2, u2, n2, o2);
                if (null != p3) {
                  const e3 = p3;
                  l2[d3] = e3;
                  let t3 = false;
                  for (let i3 = 0; i3 < g2 && !t3; i3++)
                    e3 >= l2[c2[i3]] && (c2.splice(i3, 0, d3), t3 = true);
                  t3 || (c2[g2] = d3), g2++;
                }
              }
              for (let e3 = 0; e3 < g2; e3++) {
                const t3 = c2[e3];
                d2.push({ idx: this.childOffsets[a3] + t3, t: l2[t3], nodex: (f2 << 1) + this._siblingOffset[t3][0], nodey: (m2 << 1) + this._siblingOffset[t3][1], depth: _2 + 1 });
              }
            }
            return null;
          }
          _addNode(e2, t2, i2) {
            return this.minimums.push(e2), this.maximums.push(t2), this.leaves.push(i2), this.childOffsets.push(0), this.nodeCount++;
          }
          _construct(e2, t2, i2, r2, n2) {
            if (1 === e2[r2].isLeaf(t2, i2))
              return;
            this.childOffsets[n2] || (this.childOffsets[n2] = this.nodeCount);
            const o2 = r2 - 1, s2 = e2[o2];
            let a2 = 0, l2 = 0;
            for (let e3 = 0; e3 < this._siblingOffset.length; e3++) {
              const r3 = 2 * t2 + this._siblingOffset[e3][0], n3 = 2 * i2 + this._siblingOffset[e3][1], o3 = s2.getElevation(r3, n3), c2 = s2.isLeaf(r3, n3), h2 = this._addNode(o3.min, o3.max, c2);
              c2 && (a2 |= 1 << e3), l2 || (l2 = h2);
            }
            for (let r3 = 0; r3 < this._siblingOffset.length; r3++)
              a2 & 1 << r3 || this._construct(e2, 2 * t2 + this._siblingOffset[r3][0], 2 * i2 + this._siblingOffset[r3][1], o2, l2 + r3);
          }
        }
        function Bm(e2, t2, i2, r2, n2, o2) {
          return Wr(Wr(e2, i2, o2), Wr(t2, r2, o2), n2);
        }
        function Fm(e2, t2, i2) {
          const r2 = i2.dim, n2 = z(e2 * r2 - 0.5, 0, r2 - 1), o2 = z(t2 * r2 - 0.5, 0, r2 - 1), s2 = Math.floor(n2), a2 = Math.floor(o2), l2 = Math.min(s2 + 1, r2 - 1), c2 = Math.min(a2 + 1, r2 - 1);
          return Bm(i2.get(s2, a2), i2.get(l2, a2), i2.get(s2, c2), i2.get(l2, c2), n2 - s2, o2 - a2);
        }
        const Nm = { mapbox: [6553.6, 25.6, 0.1, 1e4], terrarium: [256, 1, 1 / 256, 32768], float: [1, 1, 1, 1] };
        function Um(e2, t2, i2) {
          return (256 * e2 * 256 + 256 * t2 + i2) / 10 - 1e4;
        }
        function Vm(e2, t2, i2) {
          return 256 * e2 + t2 + i2 / 256 - 32768;
        }
        class jm {
          get tree() {
            return this._tree || this._buildQuadTree(), this._tree;
          }
          constructor(e2, t2, i2, r2, n2 = false) {
            if (this.uid = e2, t2.height !== t2.width)
              throw new RangeError("DEM tiles must be square");
            if (i2 && "mapbox" !== i2 && "terrarium" !== i2)
              return W(`"${i2}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);
            this.stride = t2.height;
            const o2 = this.dim = t2.height - 2, s2 = new Uint32Array(t2.data.buffer);
            if (this.pixels = new Uint8Array(t2.data.buffer), this.encoding = i2 || "mapbox", this.borderReady = n2, this._modifiedForSources = {}, !n2) {
              for (let e3 = 0; e3 < o2; e3++)
                s2[this._idx(-1, e3)] = s2[this._idx(0, e3)], s2[this._idx(o2, e3)] = s2[this._idx(o2 - 1, e3)], s2[this._idx(e3, -1)] = s2[this._idx(e3, 0)], s2[this._idx(e3, o2)] = s2[this._idx(e3, o2 - 1)];
              s2[this._idx(-1, -1)] = s2[this._idx(0, 0)], s2[this._idx(o2, -1)] = s2[this._idx(o2 - 1, 0)], s2[this._idx(-1, o2)] = s2[this._idx(0, o2 - 1)], s2[this._idx(o2, o2)] = s2[this._idx(o2 - 1, o2 - 1)];
            }
            if (r2) {
              const e3 = new Float32Array(t2.data.buffer), i3 = "terrarium" === this.encoding ? Vm : Um;
              for (let t3 = 0; t3 < s2.length; ++t3) {
                const r3 = 4 * t3;
                e3[t3] = i3(this.pixels[r3], this.pixels[r3 + 1], this.pixels[r3 + 2]);
              }
              this.encoding = "float";
            }
            this._timestamp = ht.now();
          }
          _buildQuadTree() {
            this._tree = new Om(this);
          }
          get(e2, t2, i2 = false) {
            i2 && (e2 = z(e2, -1, this.dim), t2 = z(t2, -1, this.dim));
            const r2 = this._idx(e2, t2);
            if ("float" === this.encoding)
              return this.floatView || (this.floatView = new Float32Array(this.pixels.buffer)), this.floatView[r2];
            const n2 = 4 * r2;
            return ("terrarium" === this.encoding ? Vm : Um)(this.pixels[n2], this.pixels[n2 + 1], this.pixels[n2 + 2]);
          }
          set(e2, t2, i2) {
            const r2 = this._idx(e2, t2);
            if ("float" === this.encoding) {
              this.floatView || (this.floatView = new Float32Array(this.pixels.buffer));
              const e3 = this.floatView[r2];
              return this.floatView[r2] = i2, i2 - e3;
            }
            const n2 = 4 * r2, o2 = ("terrarium" === this.encoding ? Vm : Um)(this.pixels[n2], this.pixels[n2 + 1], this.pixels[n2 + 2]), s2 = jm.pack(i2, "terrarium" === this.encoding ? "terrarium" : "mapbox");
            return this.pixels[n2] = s2[0], this.pixels[n2 + 1] = s2[1], this.pixels[n2 + 2] = s2[2], i2 - o2;
          }
          static getUnpackVector(e2) {
            return Nm[e2];
          }
          get unpackVector() {
            return Nm[this.encoding];
          }
          _idx(e2, t2) {
            if (e2 < -1 || e2 >= this.dim + 1 || t2 < -1 || t2 >= this.dim + 1)
              throw new RangeError("out of range source coordinates for DEM data");
            return (t2 + 1) * this.stride + (e2 + 1);
          }
          static pack(e2, t2) {
            const i2 = [0, 0, 0, 0], r2 = jm.getUnpackVector(t2);
            let n2 = Math.floor((e2 + r2[3]) / r2[2]);
            return i2[2] = n2 % 256, n2 = Math.floor(n2 / 256), i2[1] = n2 % 256, n2 = Math.floor(n2 / 256), i2[0] = n2, i2;
          }
          getPixels() {
            return "float" === this.encoding ? new Hp({ width: this.stride, height: this.stride }, this.pixels) : new $p({ width: this.stride, height: this.stride }, this.pixels);
          }
          backfillBorder(e2, t2, i2) {
            if (this.dim !== e2.dim)
              throw new Error("dem dimension mismatch");
            let r2 = t2 * this.dim, n2 = t2 * this.dim + this.dim, o2 = i2 * this.dim, s2 = i2 * this.dim + this.dim;
            switch (t2) {
              case -1:
                r2 = n2 - 1;
                break;
              case 1:
                n2 = r2 + 1;
            }
            switch (i2) {
              case -1:
                o2 = s2 - 1;
                break;
              case 1:
                s2 = o2 + 1;
            }
            const a2 = -t2 * this.dim, l2 = -i2 * this.dim;
            for (let t3 = o2; t3 < s2; t3++)
              for (let i3 = r2; i3 < n2; i3++) {
                const r3 = 4 * this._idx(i3, t3), n3 = 4 * this._idx(i3 + a2, t3 + l2);
                this.pixels[r3 + 0] = e2.pixels[n3 + 0], this.pixels[r3 + 1] = e2.pixels[n3 + 1], this.pixels[r3 + 2] = e2.pixels[n3 + 2], this.pixels[r3 + 3] = e2.pixels[n3 + 3];
              }
          }
          onDeserialize() {
            this._tree && (this._tree.dem = this);
          }
        }
        Is(jm, "DEMData"), Is(Om, "DemMinMaxQuadTree", { omit: ["dem"] });
        class Gm {
          isDataAvailableAtPoint(e2) {
            const t2 = this._source();
            if (this.isUsingMockSource() || !t2 || e2.y < 0 || e2.y > 1)
              return false;
            const i2 = t2.getSource().maxzoom, r2 = 1 << i2, n2 = Math.floor(e2.x), o2 = Math.floor((e2.x - n2) * r2), s2 = Math.floor(e2.y * r2), a2 = this.findDEMTileFor(new Bu(i2, n2, i2, o2, s2));
            return !(!a2 || !a2.dem);
          }
          getAtPointOrZero(e2, t2 = 0) {
            return this.getAtPoint(e2, t2) || 0;
          }
          getAtPoint(e2, t2, i2 = true) {
            if (this.isUsingMockSource())
              return null;
            null == t2 && (t2 = null);
            const r2 = this._source();
            if (!r2)
              return t2;
            if (e2.y < 0 || e2.y > 1)
              return t2;
            const n2 = r2.getSource().maxzoom, o2 = 1 << n2, s2 = Math.floor(e2.x), a2 = e2.x - s2, l2 = new Bu(n2, s2, n2, Math.floor(a2 * o2), Math.floor(e2.y * o2)), c2 = this.findDEMTileFor(l2);
            if (!c2 || !c2.dem)
              return t2;
            const h2 = c2.dem, u2 = 1 << c2.tileID.canonical.z, d2 = (a2 * u2 - c2.tileID.canonical.x) * h2.dim, p2 = (e2.y * u2 - c2.tileID.canonical.y) * h2.dim, f2 = Math.floor(d2), m2 = Math.floor(p2);
            return (i2 ? this.exaggeration() : 1) * Wr(Wr(h2.get(f2, m2), h2.get(f2, m2 + 1), p2 - m2), Wr(h2.get(f2 + 1, m2), h2.get(f2 + 1, m2 + 1), p2 - m2), d2 - f2);
          }
          getAtTileOffset(e2, t2, i2) {
            const r2 = 1 << e2.canonical.z;
            return this.getAtPointOrZero(new ep(e2.wrap + (e2.canonical.x + t2 / sr) / r2, (e2.canonical.y + i2 / sr) / r2));
          }
          getAtTileOffsetFunc(e2, t2, i2, r2) {
            return (n2) => {
              const o2 = this.getAtTileOffset(e2, n2.x, n2.y), s2 = r2.upVector(e2.canonical, n2.x, n2.y), a2 = r2.upVectorScale(e2.canonical, t2, i2).metersToTile;
              return Mu.scale(s2, s2, o2 * a2), s2;
            };
          }
          getForTilePoints(e2, t2, i2, r2) {
            if (this.isUsingMockSource())
              return false;
            const n2 = qm.create(this, e2, r2);
            return !!n2 && (t2.forEach((e3) => {
              e3[2] = this.exaggeration() * n2.getElevationAt(e3[0], e3[1], i2);
            }), true);
          }
          getMinMaxForTile(e2) {
            if (this.isUsingMockSource())
              return null;
            const t2 = this.findDEMTileFor(e2);
            if (!t2 || !t2.dem)
              return null;
            const i2 = t2.dem.tree, r2 = t2.tileID, n2 = 1 << e2.canonical.z - r2.canonical.z;
            let o2 = e2.canonical.x / n2 - r2.canonical.x, s2 = e2.canonical.y / n2 - r2.canonical.y, a2 = 0;
            for (let t3 = 0; t3 < e2.canonical.z - r2.canonical.z && !i2.leaves[a2]; t3++) {
              o2 *= 2, s2 *= 2;
              const e3 = 2 * Math.floor(s2) + Math.floor(o2);
              a2 = i2.childOffsets[a2] + e3, o2 %= 1, s2 %= 1;
            }
            return { min: this.exaggeration() * i2.minimums[a2], max: this.exaggeration() * i2.maximums[a2] };
          }
          getMinElevationBelowMSL() {
            throw new Error("Pure virtual method called.");
          }
          raycast(e2, t2, i2) {
            throw new Error("Pure virtual method called.");
          }
          pointCoordinate(e2) {
            throw new Error("Pure virtual method called.");
          }
          _source() {
            throw new Error("Pure virtual method called.");
          }
          isUsingMockSource() {
            throw new Error("Pure virtual method called.");
          }
          exaggeration() {
            throw new Error("Pure virtual method called.");
          }
          findDEMTileFor(e2) {
            throw new Error("Pure virtual method called.");
          }
          get visibleDemTiles() {
            throw new Error("Getter must be implemented in subclass.");
          }
        }
        class qm {
          constructor(e2, t2, i2) {
            this._demTile = e2, this._dem = this._demTile.dem, this._scale = t2, this._offset = i2;
          }
          static create(e2, t2, i2) {
            const r2 = i2 || e2.findDEMTileFor(t2);
            if (!r2 || !r2.dem)
              return;
            const n2 = r2.dem, o2 = r2.tileID, s2 = 1 << t2.canonical.z - o2.canonical.z;
            return new qm(r2, n2.dim / sr / s2, [(t2.canonical.x / s2 - o2.canonical.x) * n2.dim, (t2.canonical.y / s2 - o2.canonical.y) * n2.dim]);
          }
          tileCoordToPixel(e2, t2) {
            const i2 = t2 * this._scale + this._offset[1], r2 = Math.floor(e2 * this._scale + this._offset[0]), n2 = Math.floor(i2);
            return new y(r2, n2);
          }
          getElevationAt(e2, t2, i2, r2) {
            const n2 = e2 * this._scale + this._offset[0], o2 = t2 * this._scale + this._offset[1], s2 = Math.floor(n2), a2 = Math.floor(o2), l2 = this._dem;
            return r2 = !!r2, i2 ? Wr(Wr(l2.get(s2, a2, r2), l2.get(s2, a2 + 1, r2), o2 - a2), Wr(l2.get(s2 + 1, a2, r2), l2.get(s2 + 1, a2 + 1, r2), o2 - a2), n2 - s2) : l2.get(s2, a2, r2);
          }
          getElevationAtPixel(e2, t2, i2) {
            return this._dem.get(e2, t2, !!i2);
          }
          getMeterToDEM(e2) {
            return (1 << this._demTile.tileID.canonical.z) * Zd(1, e2) * this._dem.stride;
          }
        }
        class Zm {
          constructor(e2, t2) {
            this.tileID = e2, this.x = e2.canonical.x, this.y = e2.canonical.y, this.z = e2.canonical.z, this.grid = new As(sr, 16, 0), this.featureIndexArray = new ll(), this.promoteId = t2;
          }
          insert(e2, t2, i2, r2, n2, o2 = 0) {
            const s2 = this.featureIndexArray.length;
            this.featureIndexArray.emplaceBack(i2, r2, n2, o2);
            const a2 = this.grid;
            for (let e3 = 0; e3 < t2.length; e3++) {
              const i3 = t2[e3], r3 = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
              for (let e4 = 0; e4 < i3.length; e4++) {
                const t3 = i3[e4];
                r3[0] = Math.min(r3[0], t3.x), r3[1] = Math.min(r3[1], t3.y), r3[2] = Math.max(r3[2], t3.x), r3[3] = Math.max(r3[3], t3.y);
              }
              r3[0] < sr && r3[1] < sr && r3[2] >= 0 && r3[3] >= 0 && a2.insert(s2, r3[0], r3[1], r3[2], r3[3]);
            }
          }
          loadVTLayers() {
            if (!this.vtLayers) {
              this.vtLayers = new tm(new Sm(this.rawTileData)).layers, this.sourceLayerCoder = new nm(this.vtLayers ? Object.keys(this.vtLayers).sort() : ["_geojsonTileLayer"]), this.vtFeatures = {};
              for (const e2 in this.vtLayers)
                this.vtFeatures[e2] = [];
            }
            return this.vtLayers;
          }
          query(e2, t2, i2, r2) {
            this.loadVTLayers();
            const n2 = e2.params || {}, o2 = Ro(n2.filter), s2 = e2.tileResult, a2 = e2.transform, l2 = s2.bufferedTilespaceBounds, c2 = this.grid.query(l2.min.x, l2.min.y, l2.max.x, l2.max.y, (e3, t3, i3, r3) => Tp(s2.bufferedTilespaceGeometry, e3, t3, i3, r3));
            c2.sort(Hm);
            let h2 = null;
            a2.elevation && c2.length > 0 && (h2 = qm.create(a2.elevation, this.tileID));
            const u2 = {};
            let d2;
            for (let a3 = 0; a3 < c2.length; a3++) {
              const l3 = c2[a3];
              if (l3 === d2)
                continue;
              d2 = l3;
              const p2 = this.featureIndexArray.get(l3);
              let f2 = null;
              this.loadMatchingFeature(u2, p2, o2, n2.layers, n2.availableImages, t2, i2, r2, (t3, i3, r3, n3 = 0) => (f2 || (f2 = lp(t3, this.tileID.canonical, e2.tileTransform)), i3.queryIntersectsFeature(s2, t3, r3, f2, this.z, e2.transform, e2.pixelPosMatrix, h2, n3)));
            }
            return u2;
          }
          loadMatchingFeature(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
            const { featureIndex: c2, bucketIndex: h2, sourceLayerIndex: u2, layoutVertexArrayOffset: d2 } = t2, p2 = this.bucketLayerIDs[h2];
            if (r2 && !function(e3, t3) {
              for (let i3 = 0; i3 < e3.length; i3++)
                if (t3.indexOf(e3[i3]) >= 0)
                  return true;
              return false;
            }(r2, p2))
              return;
            const f2 = this.sourceLayerCoder.decode(u2), m2 = this.vtLayers[f2].feature(c2);
            if (i2.needGeometry) {
              const e3 = cp(m2, true);
              if (!i2.filter(new ea(this.tileID.overscaledZ), e3, this.tileID.canonical))
                return;
            } else if (!i2.filter(new ea(this.tileID.overscaledZ), m2))
              return;
            const _2 = this.getId(m2, f2);
            for (let t3 = 0; t3 < p2.length; t3++) {
              const i3 = p2[t3];
              if (r2 && r2.indexOf(i3) < 0)
                continue;
              const h3 = o2[i3];
              if (!h3)
                continue;
              let u3 = {};
              void 0 !== _2 && a2 && (u3 = a2.getState(h3.sourceLayer || "_geojsonTileLayer", _2));
              const f3 = k({}, s2[i3]);
              f3.paint = $m(f3.paint, h3.paint, m2, u3, n2), f3.layout = $m(f3.layout, h3.layout, m2, u3, n2);
              const g2 = !l2 || l2(m2, h3, u3, d2);
              if (!g2)
                continue;
              const y2 = new Cm(m2, this.z, this.x, this.y, _2);
              y2.layer = f3;
              let x2 = e2[i3];
              void 0 === x2 && (x2 = e2[i3] = []), x2.push({ featureIndex: c2, feature: y2, intersectionZ: g2 });
            }
          }
          lookupSymbolFeatures(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = {};
            this.loadVTLayers();
            const c2 = Ro(n2);
            for (const n3 of e2)
              this.loadMatchingFeature(l2, { bucketIndex: i2, sourceLayerIndex: r2, featureIndex: n3, layoutVertexArrayOffset: 0 }, c2, o2, s2, a2, t2);
            return l2;
          }
          loadFeature(e2) {
            const { featureIndex: t2, sourceLayerIndex: i2 } = e2;
            this.loadVTLayers();
            const r2 = this.sourceLayerCoder.decode(i2), n2 = this.vtFeatures[r2];
            if (n2[t2])
              return n2[t2];
            const o2 = this.vtLayers[r2].feature(t2);
            return n2[t2] = o2, o2;
          }
          hasLayer(e2) {
            for (const t2 of this.bucketLayerIDs)
              for (const i2 of t2)
                if (e2 === i2)
                  return true;
            return false;
          }
          getId(e2, t2) {
            let i2 = e2.id;
            if (this.promoteId) {
              const r2 = "string" == typeof this.promoteId ? this.promoteId : this.promoteId[t2];
              null != r2 && (i2 = e2.properties[r2]), "boolean" == typeof i2 && (i2 = Number(i2));
            }
            return i2;
          }
        }
        function $m(e2, t2, i2, r2, n2) {
          return q(e2, (e3, o2) => {
            const s2 = t2 instanceof la ? t2.get(o2) : null;
            return s2 && s2.evaluate ? s2.evaluate(i2, r2, n2) : s2;
          });
        }
        function Hm(e2, t2) {
          return t2 - e2;
        }
        Is(Zm, "FeatureIndex", { omit: ["rawTileData", "sourceLayerCoder"] });
        const Wm = ba([{ name: "a_pos_offset", components: 4, type: "Int16" }, { name: "a_tex_size", components: 4, type: "Uint16" }, { name: "a_pixeloffset", components: 4, type: "Int16" }], 4), Xm = ba([{ name: "a_globe_anchor", components: 3, type: "Int16" }, { name: "a_globe_normal", components: 3, type: "Float32" }], 4), Ym = ba([{ name: "a_projected_pos", components: 4, type: "Float32" }], 4);
        ba([{ name: "a_fade_opacity", components: 1, type: "Uint32" }], 4);
        const Km = ba([{ name: "a_z_offset", components: 1, type: "Float32" }], 4), Jm = ba([{ name: "a_texb", components: 2, type: "Uint16" }]), Qm = ba([{ name: "a_placed", components: 2, type: "Uint8" }, { name: "a_shift", components: 2, type: "Float32" }]), e_ = ba([{ name: "a_size_scale", components: 1, type: "Float32" }, { name: "a_padding", components: 2, type: "Float32" }]);
        ba([{ type: "Int16", name: "projectedAnchorX" }, { type: "Int16", name: "projectedAnchorY" }, { type: "Int16", name: "projectedAnchorZ" }, { type: "Int16", name: "tileAnchorX" }, { type: "Int16", name: "tileAnchorY" }, { type: "Float32", name: "x1" }, { type: "Float32", name: "y1" }, { type: "Float32", name: "x2" }, { type: "Float32", name: "y2" }, { type: "Int16", name: "padding" }, { type: "Uint32", name: "featureIndex" }, { type: "Uint16", name: "sourceLayerIndex" }, { type: "Uint16", name: "bucketIndex" }]);
        const t_ = ba([{ name: "a_pos", components: 3, type: "Int16" }, { name: "a_anchor_pos", components: 2, type: "Int16" }, { name: "a_extrude", components: 2, type: "Int16" }], 4), i_ = ba([{ name: "a_pos_2f", components: 2, type: "Float32" }, { name: "a_radius", components: 1, type: "Float32" }, { name: "a_flags", components: 2, type: "Int16" }], 4);
        ba([{ name: "triangle", components: 3, type: "Uint16" }]), ba([{ type: "Int16", name: "projectedAnchorX" }, { type: "Int16", name: "projectedAnchorY" }, { type: "Int16", name: "projectedAnchorZ" }, { type: "Float32", name: "tileAnchorX" }, { type: "Float32", name: "tileAnchorY" }, { type: "Uint16", name: "glyphStartIndex" }, { type: "Uint16", name: "numGlyphs" }, { type: "Uint32", name: "vertexStartIndex" }, { type: "Uint32", name: "lineStartIndex" }, { type: "Uint32", name: "lineLength" }, { type: "Uint16", name: "segment" }, { type: "Uint16", name: "lowerSize" }, { type: "Uint16", name: "upperSize" }, { type: "Float32", name: "lineOffsetX" }, { type: "Float32", name: "lineOffsetY" }, { type: "Uint8", name: "writingMode" }, { type: "Uint8", name: "placedOrientation" }, { type: "Uint8", name: "hidden" }, { type: "Uint32", name: "crossTileID" }, { type: "Int16", name: "associatedIconIndex" }, { type: "Uint8", name: "flipState" }]), ba([{ type: "Float32", name: "tileAnchorX" }, { type: "Float32", name: "tileAnchorY" }, { type: "Int16", name: "projectedAnchorX" }, { type: "Int16", name: "projectedAnchorY" }, { type: "Int16", name: "projectedAnchorZ" }, { type: "Int16", name: "rightJustifiedTextSymbolIndex" }, { type: "Int16", name: "centerJustifiedTextSymbolIndex" }, { type: "Int16", name: "leftJustifiedTextSymbolIndex" }, { type: "Int16", name: "verticalPlacedTextSymbolIndex" }, { type: "Int16", name: "placedIconSymbolIndex" }, { type: "Int16", name: "verticalPlacedIconSymbolIndex" }, { type: "Uint16", name: "key" }, { type: "Uint16", name: "textBoxStartIndex" }, { type: "Uint16", name: "textBoxEndIndex" }, { type: "Uint16", name: "verticalTextBoxStartIndex" }, { type: "Uint16", name: "verticalTextBoxEndIndex" }, { type: "Uint16", name: "iconBoxStartIndex" }, { type: "Uint16", name: "iconBoxEndIndex" }, { type: "Uint16", name: "verticalIconBoxStartIndex" }, { type: "Uint16", name: "verticalIconBoxEndIndex" }, { type: "Uint16", name: "featureIndex" }, { type: "Uint16", name: "numHorizontalGlyphVertices" }, { type: "Uint16", name: "numVerticalGlyphVertices" }, { type: "Uint16", name: "numIconVertices" }, { type: "Uint16", name: "numVerticalIconVertices" }, { type: "Uint16", name: "useRuntimeCollisionCircles" }, { type: "Uint32", name: "crossTileID" }, { type: "Float32", components: 2, name: "textOffset" }, { type: "Float32", name: "collisionCircleDiameter" }, { type: "Float32", name: "zOffset" }, { type: "Uint8", name: "hasIconTextFit" }]), ba([{ type: "Float32", name: "offsetX" }]), ba([{ type: "Int16", name: "x" }, { type: "Int16", name: "y" }]);
        var r_ = 24;
        const n_ = 128;
        function o_(e2, t2) {
          const { expression: i2 } = t2;
          if ("constant" === i2.kind)
            return { kind: "constant", layoutSize: i2.evaluate(new ea(e2 + 1)) };
          if ("source" === i2.kind)
            return { kind: "source" };
          {
            const { zoomStops: t3, interpolationType: r2 } = i2;
            let n2 = 0;
            for (; n2 < t3.length && t3[n2] <= e2; )
              n2++;
            n2 = Math.max(0, n2 - 1);
            let o2 = n2;
            for (; o2 < t3.length && t3[o2] < e2 + 1; )
              o2++;
            o2 = Math.min(t3.length - 1, o2);
            const s2 = t3[n2], a2 = t3[o2];
            return "composite" === i2.kind ? { kind: "composite", minZoom: s2, maxZoom: a2, interpolationType: r2 } : { kind: "camera", minZoom: s2, maxZoom: a2, minSize: i2.evaluate(new ea(s2)), maxSize: i2.evaluate(new ea(a2)), interpolationType: r2 };
          }
        }
        function s_(e2, { uSize: t2, uSizeT: i2 }, { lowerSize: r2, upperSize: n2 }) {
          return "source" === e2.kind ? r2 / n_ : "composite" === e2.kind ? Wr(r2 / n_, n2 / n_, i2) : t2;
        }
        function a_(e2, t2) {
          let i2 = 0, r2 = 0;
          if ("constant" === e2.kind)
            r2 = e2.layoutSize;
          else if ("source" !== e2.kind) {
            const { interpolationType: n2, minZoom: o2, maxZoom: s2 } = e2, a2 = n2 ? z(yn.interpolationFactor(n2, t2, o2, s2), 0, 1) : 0;
            "camera" === e2.kind ? r2 = Wr(e2.minSize, e2.maxSize, a2) : i2 = a2;
          }
          return { uSizeT: i2, uSize: r2 };
        }
        var l_ = Object.freeze({ __proto__: null, SIZE_PACK_FACTOR: n_, evaluateSizeForFeature: s_, evaluateSizeForZoom: a_, getSizeData: o_ });
        function c_(e2, t2, i2) {
          return e2.sections.forEach((e3) => {
            e3.text = function(e4, t3, i3) {
              const r2 = t3.layout.get("text-transform").evaluate(i3, {});
              return "uppercase" === r2 ? e4 = e4.toLocaleUpperCase() : "lowercase" === r2 && (e4 = e4.toLocaleLowerCase()), Qs.applyArabicShaping && (e4 = Qs.applyArabicShaping(e4)), e4;
            }(e3.text, t2, i2);
          }), e2;
        }
        const h_ = { "!": "︕", "#": "＃", $: "＄", "%": "％", "&": "＆", "(": "︵", ")": "︶", "*": "＊", "+": "＋", ",": "︐", "-": "︲", ".": "・", "/": "／", ":": "︓", ";": "︔", "<": "︿", "=": "＝", ">": "﹀", "?": "︖", "@": "＠", "[": "﹇", "\\": "＼", "]": "﹈", "^": "＾", _: "︳", "`": "｀", "{": "︷", "|": "―", "}": "︸", "~": "～", "¢": "￠", "£": "￡", "¥": "￥", "¦": "￤", "¬": "￢", "¯": "￣", "–": "︲", "—": "︱", "‘": "﹃", "’": "﹄", "“": "﹁", "”": "﹂", "…": "︙", "‧": "・", "₩": "￦", "、": "︑", "。": "︒", "〈": "︿", "〉": "﹀", "《": "︽", "》": "︾", "「": "﹁", "」": "﹂", "『": "﹃", "』": "﹄", "【": "︻", "】": "︼", "〔": "︹", "〕": "︺", "〖": "︗", "〗": "︘", "！": "︕", "（": "︵", "）": "︶", "，": "︐", "－": "︲", "．": "・", "：": "︓", "；": "︔", "＜": "︿", "＞": "﹀", "？": "︖", "［": "﹇", "］": "﹈", "＿": "︳", "｛": "︷", "｜": "―", "｝": "︸", "｟": "︵", "｠": "︶", "｡": "︒", "｢": "﹁", "｣": "﹂", "←": "↑", "→": "↓" };
        function u_(e2) {
          return "︶" === e2 || "﹈" === e2 || "︸" === e2 || "﹄" === e2 || "﹂" === e2 || "︾" === e2 || "︼" === e2 || "︺" === e2 || "︘" === e2 || "﹀" === e2 || "︐" === e2 || "︓" === e2 || "︔" === e2 || "｀" === e2 || "￣" === e2 || "︑" === e2 || "︒" === e2;
        }
        function d_(e2) {
          return "︵" === e2 || "﹇" === e2 || "︷" === e2 || "﹃" === e2 || "﹁" === e2 || "︽" === e2 || "︻" === e2 || "︹" === e2 || "︗" === e2 || "︿" === e2;
        }
        const p_ = 3;
        function f_(e2, t2, i2) {
          t2.glyphs = [], 1 === e2 && i2.readMessage(m_, t2);
        }
        function m_(e2, t2, i2) {
          if (3 === e2) {
            const { id: e3, bitmap: r2, width: n2, height: o2, left: s2, top: a2, advance: l2 } = i2.readMessage(__, {});
            t2.glyphs.push({ id: e3, bitmap: new Zp({ width: n2 + 2 * p_, height: o2 + 2 * p_ }, r2), metrics: { width: n2, height: o2, left: s2, top: a2, advance: l2 } });
          } else
            4 === e2 ? t2.ascender = i2.readSVarint() : 5 === e2 && (t2.descender = i2.readSVarint());
        }
        function __(e2, t2, i2) {
          1 === e2 ? t2.id = i2.readVarint() : 2 === e2 ? t2.bitmap = i2.readBytes() : 3 === e2 ? t2.width = i2.readVarint() : 4 === e2 ? t2.height = i2.readVarint() : 5 === e2 ? t2.left = i2.readSVarint() : 6 === e2 ? t2.top = i2.readSVarint() : 7 === e2 && (t2.advance = i2.readVarint());
        }
        const g_ = p_;
        function y_(e2) {
          let t2 = 0, i2 = 0;
          for (const r3 of e2)
            t2 += r3.w * r3.h, i2 = Math.max(i2, r3.w);
          e2.sort((e3, t3) => t3.h - e3.h);
          const r2 = [{ x: 0, y: 0, w: Math.max(Math.ceil(Math.sqrt(t2 / 0.95)), i2), h: 1 / 0 }];
          let n2 = 0, o2 = 0;
          for (const t3 of e2)
            for (let e3 = r2.length - 1; e3 >= 0; e3--) {
              const i3 = r2[e3];
              if (!(t3.w > i3.w || t3.h > i3.h)) {
                if (t3.x = i3.x, t3.y = i3.y, o2 = Math.max(o2, t3.y + t3.h), n2 = Math.max(n2, t3.x + t3.w), t3.w === i3.w && t3.h === i3.h) {
                  const t4 = r2.pop();
                  e3 < r2.length && (r2[e3] = t4);
                } else
                  t3.h === i3.h ? (i3.x += t3.w, i3.w -= t3.w) : t3.w === i3.w ? (i3.y += t3.h, i3.h -= t3.h) : (r2.push({ x: i3.x + t3.w, y: i3.y, w: i3.w - t3.w, h: t3.h }), i3.y += t3.h, i3.h -= t3.h);
                break;
              }
            }
          return { w: n2, h: o2, fill: t2 / (n2 * o2) || 0 };
        }
        const x_ = 1;
        class v_ {
          constructor(e2, { pixelRatio: t2, version: i2, stretchX: r2, stretchY: n2, content: o2 }) {
            this.paddedRect = e2, this.pixelRatio = t2, this.stretchX = r2, this.stretchY = n2, this.content = o2, this.version = i2;
          }
          get tl() {
            return [this.paddedRect.x + x_, this.paddedRect.y + x_];
          }
          get br() {
            return [this.paddedRect.x + this.paddedRect.w - x_, this.paddedRect.y + this.paddedRect.h - x_];
          }
          get displaySize() {
            return [(this.paddedRect.w - 2 * x_) / this.pixelRatio, (this.paddedRect.h - 2 * x_) / this.pixelRatio];
          }
        }
        class b_ {
          constructor(e2, t2) {
            const i2 = {}, r2 = {};
            this.haveRenderCallbacks = [];
            const n2 = [];
            this.addImages(e2, i2, n2), this.addImages(t2, r2, n2);
            const { w: o2, h: s2 } = y_(n2), a2 = new $p({ width: o2 || 1, height: s2 || 1 });
            for (const t3 in e2) {
              const r3 = e2[t3], n3 = i2[t3].paddedRect;
              $p.copy(r3.data, a2, { x: 0, y: 0 }, { x: n3.x + x_, y: n3.y + x_ }, r3.data);
            }
            for (const e3 in t2) {
              const i3 = t2[e3], n3 = r2[e3].paddedRect, o3 = n3.x + x_, s3 = n3.y + x_, l2 = i3.data.width, c2 = i3.data.height;
              $p.copy(i3.data, a2, { x: 0, y: 0 }, { x: o3, y: s3 }, i3.data), $p.copy(i3.data, a2, { x: 0, y: c2 - 1 }, { x: o3, y: s3 - 1 }, { width: l2, height: 1 }), $p.copy(i3.data, a2, { x: 0, y: 0 }, { x: o3, y: s3 + c2 }, { width: l2, height: 1 }), $p.copy(i3.data, a2, { x: l2 - 1, y: 0 }, { x: o3 - 1, y: s3 }, { width: 1, height: c2 }), $p.copy(i3.data, a2, { x: 0, y: 0 }, { x: o3 + l2, y: s3 }, { width: 1, height: c2 });
            }
            this.image = a2, this.iconPositions = i2, this.patternPositions = r2;
          }
          addImages(e2, t2, i2) {
            for (const r2 in e2) {
              const n2 = e2[r2], o2 = { x: 0, y: 0, w: n2.data.width + 2 * x_, h: n2.data.height + 2 * x_ };
              i2.push(o2), t2[r2] = new v_(o2, n2), n2.hasRenderCallback && this.haveRenderCallbacks.push(r2);
            }
          }
          patchUpdatedImages(e2, t2, i2) {
            this.haveRenderCallbacks = this.haveRenderCallbacks.filter((t3) => e2.hasImage(t3, i2)), e2.dispatchRenderCallbacks(this.haveRenderCallbacks, i2);
            for (const r2 in e2.getUpdatedImages(i2))
              this.patchUpdatedImage(this.iconPositions[r2], e2.getImage(r2, i2), t2), this.patchUpdatedImage(this.patternPositions[r2], e2.getImage(r2, i2), t2);
          }
          patchUpdatedImage(e2, t2, i2) {
            if (!e2 || !t2)
              return;
            if (e2.version === t2.version)
              return;
            e2.version = t2.version;
            const [r2, n2] = e2.tl;
            i2.update(t2.data, void 0, { x: r2, y: n2 });
          }
        }
        Is(v_, "ImagePosition"), Is(b_, "ImageAtlas");
        const w_ = { horizontal: 1, vertical: 2, horizontalOnly: 3 }, T_ = -17;
        class E_ {
          constructor() {
            this.scale = 1, this.fontStack = "", this.imageName = null;
          }
          static forText(e2, t2) {
            const i2 = new E_();
            return i2.scale = e2 || 1, i2.fontStack = t2, i2;
          }
          static forImage(e2) {
            const t2 = new E_();
            return t2.imageName = e2, t2;
          }
        }
        class M_ {
          constructor() {
            this.text = "", this.sectionIndex = [], this.sections = [], this.imageSectionID = null;
          }
          static fromFeature(e2, t2) {
            const i2 = new M_();
            for (let r2 = 0; r2 < e2.sections.length; r2++) {
              const n2 = e2.sections[r2];
              n2.image ? i2.addImageSection(n2) : i2.addTextSection(n2, t2);
            }
            return i2;
          }
          length() {
            return this.text.length;
          }
          getSection(e2) {
            return this.sections[this.sectionIndex[e2]];
          }
          getSections() {
            return this.sections;
          }
          getSectionIndex(e2) {
            return this.sectionIndex[e2];
          }
          getCodePoint(e2) {
            return this.text.codePointAt(e2);
          }
          verticalizePunctuation(e2) {
            this.text = function(e3, t2) {
              let i2 = "";
              for (let r2 = 0; r2 < e3.length; r2++) {
                const n2 = e3.charCodeAt(r2 + 1) || null, o2 = e3.charCodeAt(r2 - 1) || null;
                i2 += !t2 && (n2 && Fs(n2) && !h_[e3[r2 + 1]] || o2 && Fs(o2) && !h_[e3[r2 - 1]]) || !h_[e3[r2]] ? e3[r2] : h_[e3[r2]];
              }
              return i2;
            }(this.text, e2);
          }
          trim() {
            let e2 = 0;
            for (let t3 = 0; t3 < this.text.length && S_[this.text.charCodeAt(t3)]; t3++)
              e2++;
            let t2 = this.text.length;
            for (let i2 = this.text.length - 1; i2 >= 0 && i2 >= e2 && S_[this.text.charCodeAt(i2)]; i2--)
              t2--;
            this.text = this.text.substring(e2, t2), this.sectionIndex = this.sectionIndex.slice(e2, t2);
          }
          substring(e2, t2) {
            const i2 = new M_();
            return i2.text = this.text.substring(e2, t2), i2.sectionIndex = this.sectionIndex.slice(e2, t2), i2.sections = this.sections, i2;
          }
          toString() {
            return this.text;
          }
          getMaxScale() {
            return this.sectionIndex.reduce((e2, t2) => Math.max(e2, this.sections[t2].scale), 0);
          }
          addTextSection(e2, t2) {
            this.text += e2.text, this.sections.push(E_.forText(e2.scale, e2.fontStack || t2));
            const i2 = this.sections.length - 1;
            for (let t3 = 0; t3 < e2.text.length; ++t3)
              this.sectionIndex.push(i2);
          }
          addImageSection(e2) {
            const t2 = e2.image ? e2.image.namePrimary : "";
            if (0 === t2.length)
              return void W("Can't add FormattedSection with an empty image.");
            const i2 = this.getNextImageSectionCharCode();
            i2 ? (this.text += String.fromCodePoint(i2), this.sections.push(E_.forImage(t2)), this.sectionIndex.push(this.sections.length - 1)) : W("Reached maximum number of images 6401");
          }
          getNextImageSectionCharCode() {
            return this.imageSectionID ? this.imageSectionID >= 63743 ? null : ++this.imageSectionID : (this.imageSectionID = 57344, this.imageSectionID);
          }
        }
        function A_(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2) {
          const m2 = M_.fromFeature(e2, n2);
          u2 === w_.vertical && m2.verticalizePunctuation(d2);
          let _2 = [];
          const g2 = function(e3, t3, i3, r3, n3, o3) {
            if (!e3)
              return [];
            const s3 = [], a3 = function(e4, t4, i4, r4, n4, o4) {
              let s4 = 0;
              for (let i5 = 0; i5 < e4.length(); i5++) {
                const a4 = e4.getSection(i5);
                s4 += C_(e4.getCodePoint(i5), a4, r4, n4, t4, o4);
              }
              return s4 / Math.max(1, Math.ceil(s4 / i4));
            }(e3, t3, i3, r3, n3, o3), l3 = e3.text.indexOf("​") >= 0;
            let c3 = 0;
            for (let i4 = 0; i4 < e3.length(); i4++) {
              const u3 = e3.getSection(i4), d3 = e3.getCodePoint(i4);
              if (S_[d3] || (c3 += C_(d3, u3, r3, n3, t3, o3)), i4 < e3.length() - 1) {
                const t4 = !((h3 = d3) < 11904 || !(Rs["Bopomofo Extended"](h3) || Rs.Bopomofo(h3) || Rs["CJK Compatibility Forms"](h3) || Rs["CJK Compatibility Ideographs"](h3) || Rs["CJK Compatibility"](h3) || Rs["CJK Radicals Supplement"](h3) || Rs["CJK Strokes"](h3) || Rs["CJK Symbols and Punctuation"](h3) || Rs["CJK Unified Ideographs Extension A"](h3) || Rs["CJK Unified Ideographs"](h3) || Rs["Enclosed CJK Letters and Months"](h3) || Rs["Halfwidth and Fullwidth Forms"](h3) || Rs.Hiragana(h3) || Rs["Ideographic Description Characters"](h3) || Rs["Kangxi Radicals"](h3) || Rs["Katakana Phonetic Extensions"](h3) || Rs.Katakana(h3) || Rs["Vertical Forms"](h3) || Rs["Yi Radicals"](h3) || Rs["Yi Syllables"](h3)));
                (I_[d3] || t4 || u3.imageName) && s3.push(P_(i4 + 1, c3, a3, s3, D_(d3, e3.getCodePoint(i4 + 1), t4 && l3), false));
              }
            }
            var h3;
            return R_(P_(e3.length(), c3, a3, s3, 0, true));
          }(m2, c2, o2, t2, r2, p2), { processBidirectionalText: y2, processStyledBidirectionalText: x2 } = Qs;
          if (y2 && 1 === m2.sections.length) {
            const e3 = y2(m2.toString(), g2);
            for (const t3 of e3) {
              const e4 = new M_();
              e4.text = t3, e4.sections = m2.sections;
              for (let i3 = 0; i3 < t3.length; i3++)
                e4.sectionIndex.push(0);
              _2.push(e4);
            }
          } else if (x2) {
            const e3 = x2(m2.text, m2.sectionIndex, g2);
            for (const t3 of e3) {
              const e4 = new M_();
              e4.text = t3[0], e4.sectionIndex = t3[1], e4.sections = m2.sections, _2.push(e4);
            }
          } else
            _2 = function(e3, t3) {
              const i3 = [], r3 = e3.text;
              let n3 = 0;
              for (const r4 of t3)
                i3.push(e3.substring(n3, r4)), n3 = r4;
              return n3 < r3.length && i3.push(e3.substring(n3, r3.length)), i3;
            }(m2, g2);
          const v2 = [], b2 = { positionedLines: v2, text: m2.toString(), top: h2[1], bottom: h2[1], left: h2[0], right: h2[0], writingMode: u2, iconsInText: false, verticalizable: false, hasBaseline: false };
          return function(e3, t3, i3, r3, n3, o3, s3, a3, l3, c3, h3, u3) {
            let d3 = 0, p3 = 0, f3 = 0;
            const m3 = "right" === a3 ? 1 : "left" === a3 ? 0 : 0.5;
            let _3 = false;
            for (const e4 of n3) {
              const i4 = e4.getSections();
              for (const e5 of i4) {
                if (e5.imageName)
                  continue;
                const i5 = t3[e5.fontStack];
                if (i5 && (_3 = void 0 !== i5.ascender && void 0 !== i5.descender, !_3))
                  break;
              }
              if (!_3)
                break;
            }
            let g3 = 0;
            for (const s4 of n3) {
              s4.trim();
              const n4 = s4.getMaxScale(), a4 = (n4 - 1) * r_, x4 = { positionedGlyphs: [], lineOffset: 0 };
              e3.positionedLines[g3] = x4;
              const v4 = x4.positionedGlyphs;
              let b4 = 0;
              if (!s4.length()) {
                p3 += o3, ++g3;
                continue;
              }
              let w2 = 0, T2 = 0;
              for (let o4 = 0; o4 < s4.length(); o4++) {
                const a5 = s4.getSection(o4), f4 = s4.getSectionIndex(o4), m4 = s4.getCodePoint(o4);
                let g4 = a5.scale, x5 = null, E3 = null, M2 = null, A2 = r_, S2 = 0;
                const I2 = !(l3 === w_.horizontal || !h3 && !Bs(m4) || h3 && (S_[m4] || (y3 = m4, Rs.Arabic(y3) || Rs["Arabic Supplement"](y3) || Rs["Arabic Extended-A"](y3) || Rs["Arabic Presentation Forms-A"](y3) || Rs["Arabic Presentation Forms-B"](y3))));
                if (a5.imageName) {
                  const t4 = r3[a5.imageName];
                  if (!t4)
                    continue;
                  M2 = a5.imageName, e3.iconsInText = e3.iconsInText || true, E3 = t4.paddedRect;
                  const i4 = t4.displaySize;
                  g4 = g4 * r_ / u3, x5 = { width: i4[0], height: i4[1], left: x_, top: -g_, advance: I2 ? i4[1] : i4[0], localGlyph: false }, S2 = _3 ? -x5.height * g4 : T_ + n4 * r_ - i4[1] * g4, A2 = x5.advance;
                  const o5 = (I2 ? i4[0] : i4[1]) * g4 - r_ * n4;
                  o5 > 0 && o5 > b4 && (b4 = o5);
                } else {
                  const e4 = i3[a5.fontStack];
                  if (!e4)
                    continue;
                  e4[m4] && (E3 = e4[m4]);
                  const r4 = t3[a5.fontStack];
                  if (!r4)
                    continue;
                  const o5 = r4.glyphs[m4];
                  if (!o5)
                    continue;
                  if (x5 = o5.metrics, A2 = 8203 !== m4 ? r_ : 0, _3) {
                    const e5 = void 0 !== r4.ascender ? Math.abs(r4.ascender) : 0, t4 = void 0 !== r4.descender ? Math.abs(r4.descender) : 0, i4 = (e5 + t4) * g4;
                    w2 < i4 && (w2 = i4, T2 = (e5 - t4) / 2 * g4), S2 = -e5 * g4;
                  } else
                    S2 = T_ + (n4 - g4) * r_;
                }
                I2 ? (e3.verticalizable = true, v4.push({ glyph: m4, imageName: M2, x: d3, y: p3 + S2, vertical: I2, scale: g4, localGlyph: x5.localGlyph, fontStack: a5.fontStack, sectionIndex: f4, metrics: x5, rect: E3 }), d3 += A2 * g4 + c3) : (v4.push({ glyph: m4, imageName: M2, x: d3, y: p3 + S2, vertical: I2, scale: g4, localGlyph: x5.localGlyph, fontStack: a5.fontStack, sectionIndex: f4, metrics: x5, rect: E3 }), d3 += x5.advance * g4 + c3);
              }
              0 !== v4.length && (f3 = Math.max(d3 - c3, f3), _3 ? k_(v4, m3, b4, T2, o3 * n4 / 2) : k_(v4, m3, b4, 0, o3 / 2)), d3 = 0;
              const E2 = o3 * n4 + b4;
              x4.lineOffset = Math.max(b4, a4), p3 += E2, ++g3;
            }
            var y3;
            const x3 = p3, { horizontalAlign: v3, verticalAlign: b3 } = L_(s3);
            (function(e4, t4, i4, r4, n4, o4) {
              const s4 = (t4 - i4) * n4, a4 = -o4 * r4;
              for (const t5 of e4)
                for (const e5 of t5.positionedGlyphs)
                  e5.x += s4, e5.y += a4;
            })(e3.positionedLines, m3, v3, b3, f3, x3), e3.top += -b3 * x3, e3.bottom = e3.top + x3, e3.left += -v3 * f3, e3.right = e3.left + f3, e3.hasBaseline = _3;
          }(b2, t2, i2, r2, _2, s2, a2, l2, u2, c2, d2, f2), !function(e3) {
            for (const t3 of e3)
              if (0 !== t3.positionedGlyphs.length)
                return false;
            return true;
          }(v2) && b2;
        }
        const S_ = { 9: true, 10: true, 11: true, 12: true, 13: true, 32: true }, I_ = { 10: true, 32: true, 38: true, 40: true, 41: true, 43: true, 45: true, 47: true, 173: true, 183: true, 8203: true, 8208: true, 8211: true, 8231: true };
        function C_(e2, t2, i2, r2, n2, o2) {
          if (t2.imageName) {
            const e3 = r2[t2.imageName];
            return e3 ? e3.displaySize[0] * t2.scale * r_ / o2 + n2 : 0;
          }
          {
            const r3 = i2[t2.fontStack], o3 = r3 && r3.glyphs[e2];
            return o3 ? o3.metrics.advance * t2.scale + n2 : 0;
          }
        }
        function z_(e2, t2, i2, r2) {
          const n2 = Math.pow(e2 - t2, 2);
          return r2 ? e2 < t2 ? n2 / 2 : 2 * n2 : n2 + Math.abs(i2) * i2;
        }
        function D_(e2, t2, i2) {
          let r2 = 0;
          return 10 === e2 && (r2 -= 1e4), i2 && (r2 += 150), 40 !== e2 && 65288 !== e2 || (r2 += 50), 41 !== t2 && 65289 !== t2 || (r2 += 50), r2;
        }
        function P_(e2, t2, i2, r2, n2, o2) {
          let s2 = null, a2 = z_(t2, i2, n2, o2);
          for (const e3 of r2) {
            const r3 = z_(t2 - e3.x, i2, n2, o2) + e3.badness;
            r3 <= a2 && (s2 = e3, a2 = r3);
          }
          return { index: e2, x: t2, priorBreak: s2, badness: a2 };
        }
        function R_(e2) {
          return e2 ? R_(e2.priorBreak).concat(e2.index) : [];
        }
        function L_(e2) {
          let t2 = 0.5, i2 = 0.5;
          switch (e2) {
            case "right":
            case "top-right":
            case "bottom-right":
              t2 = 1;
              break;
            case "left":
            case "top-left":
            case "bottom-left":
              t2 = 0;
          }
          switch (e2) {
            case "bottom":
            case "bottom-right":
            case "bottom-left":
              i2 = 1;
              break;
            case "top":
            case "top-right":
            case "top-left":
              i2 = 0;
          }
          return { horizontalAlign: t2, verticalAlign: i2 };
        }
        function k_(e2, t2, i2, r2, n2) {
          if (!(t2 || i2 || r2 || n2))
            return;
          const o2 = e2.length - 1, s2 = e2[o2], a2 = (s2.x + s2.metrics.advance * s2.scale) * t2;
          for (let t3 = 0; t3 <= o2; t3++)
            e2[t3].x -= a2, e2[t3].y += i2 + r2 + n2;
        }
        function O_(e2, t2, i2, r2) {
          const { horizontalAlign: n2, verticalAlign: o2 } = L_(r2), s2 = i2[0] - e2.displaySize[0] * n2, a2 = i2[1] - e2.displaySize[1] * o2;
          return { imagePrimary: e2, imageSecondary: t2, top: a2, bottom: a2 + e2.displaySize[1], left: s2, right: s2 + e2.displaySize[0] };
        }
        function B_(e2, t2, i2, r2, n2, o2) {
          const s2 = e2.imagePrimary;
          let a2;
          if (s2.content) {
            const e3 = s2.content, t3 = s2.pixelRatio || 1;
            a2 = [e3[0] / t3, e3[1] / t3, s2.displaySize[0] - e3[2] / t3, s2.displaySize[1] - e3[3] / t3];
          }
          const l2 = t2.left * o2, c2 = t2.right * o2;
          let h2, u2, d2, p2;
          "width" === i2 || "both" === i2 ? (p2 = n2[0] + l2 - r2[3], u2 = n2[0] + c2 + r2[1]) : (p2 = n2[0] + (l2 + c2 - s2.displaySize[0]) / 2, u2 = p2 + s2.displaySize[0]);
          const f2 = t2.top * o2, m2 = t2.bottom * o2;
          return "height" === i2 || "both" === i2 ? (h2 = n2[1] + f2 - r2[0], d2 = n2[1] + m2 + r2[2]) : (h2 = n2[1] + (f2 + m2 - s2.displaySize[1]) / 2, d2 = h2 + s2.displaySize[1]), { imagePrimary: s2, imageSecondary: void 0, top: h2, right: u2, bottom: d2, left: p2, collisionPadding: a2 };
        }
        class F_ extends y {
          constructor(e2, t2, i2, r2, n2) {
            super(e2, t2), this.angle = r2, this.z = i2, void 0 !== n2 && (this.segment = n2);
          }
          clone() {
            return new F_(this.x, this.y, this.z, this.angle, this.segment);
          }
        }
        function N_(e2, t2, i2, r2, n2) {
          if (void 0 === t2.segment)
            return true;
          let o2 = t2, s2 = t2.segment + 1, a2 = 0;
          for (; a2 > -i2 / 2; ) {
            if (s2--, s2 < 0)
              return false;
            a2 -= e2[s2].dist(o2), o2 = e2[s2];
          }
          a2 += e2[s2].dist(e2[s2 + 1]), s2++;
          const l2 = [];
          let c2 = 0;
          for (; a2 < i2 / 2; ) {
            const t3 = e2[s2], i3 = e2[s2 + 1];
            if (!i3)
              return false;
            let o3 = e2[s2 - 1].angleTo(t3) - t3.angleTo(i3);
            for (o3 = Math.abs((o3 + 3 * Math.PI) % (2 * Math.PI) - Math.PI), l2.push({ distance: a2, angleDelta: o3 }), c2 += o3; a2 - l2[0].distance > r2; )
              c2 -= l2.shift().angleDelta;
            if (c2 > n2)
              return false;
            s2++, a2 += t3.dist(i3);
          }
          return true;
        }
        function U_(e2) {
          let t2 = 0;
          for (let i2 = 0; i2 < e2.length - 1; i2++)
            t2 += e2[i2].dist(e2[i2 + 1]);
          return t2;
        }
        function V_(e2, t2, i2) {
          return e2 ? 0.6 * t2 * i2 : 0;
        }
        function j_(e2, t2) {
          return Math.max(e2 ? e2.right - e2.left : 0, t2 ? t2.right - t2.left : 0);
        }
        function G_(e2, t2, i2, r2, n2, o2) {
          const s2 = V_(i2, n2, o2), a2 = j_(i2, r2) * o2;
          let l2 = 0;
          const c2 = U_(e2) / 2;
          for (let i3 = 0; i3 < e2.length - 1; i3++) {
            const r3 = e2[i3], n3 = e2[i3 + 1], o3 = r3.dist(n3);
            if (l2 + o3 > c2) {
              const h2 = (c2 - l2) / o3, u2 = Wr(r3.x, n3.x, h2), d2 = Wr(r3.y, n3.y, h2), p2 = new F_(u2, d2, 0, n3.angleTo(r3), i3);
              return !s2 || N_(e2, p2, a2, s2, t2) ? p2 : void 0;
            }
            l2 += o3;
          }
        }
        function q_(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          const c2 = V_(r2, o2, s2), h2 = j_(r2, n2), u2 = h2 * s2, d2 = 0 === e2[0].x || e2[0].x === l2 || 0 === e2[0].y || e2[0].y === l2;
          return t2 - u2 < t2 / 4 && (t2 = u2 + t2 / 4), Z_(e2, d2 ? t2 / 2 * a2 % t2 : (h2 / 2 + 2 * o2) * s2 * a2 % t2, t2, c2, i2, u2, d2, false, l2);
        }
        function Z_(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          const c2 = o2 / 2, h2 = U_(e2);
          let u2 = 0, d2 = t2 - i2, p2 = [];
          for (let t3 = 0; t3 < e2.length - 1; t3++) {
            const s3 = e2[t3], a3 = e2[t3 + 1], f2 = s3.dist(a3), m2 = a3.angleTo(s3);
            for (; d2 + i2 < u2 + f2; ) {
              d2 += i2;
              const _2 = (d2 - u2) / f2, g2 = Wr(s3.x, a3.x, _2), y2 = Wr(s3.y, a3.y, _2);
              if (g2 >= 0 && g2 < l2 && y2 >= 0 && y2 < l2 && d2 - c2 >= 0 && d2 + c2 <= h2) {
                const i3 = new F_(g2, y2, 0, m2, t3);
                r2 && !N_(e2, i3, o2, r2, n2) || p2.push(i3);
              }
            }
            u2 += f2;
          }
          return a2 || p2.length || s2 || (p2 = Z_(e2, u2 / 2, i2, r2, n2, o2, s2, true, l2)), p2;
        }
        function $_(e2, t2, i2, r2, n2) {
          const o2 = [];
          for (let s2 = 0; s2 < e2.length; s2++) {
            const a2 = e2[s2];
            let l2;
            for (let e3 = 0; e3 < a2.length - 1; e3++) {
              let s3 = a2[e3], c2 = a2[e3 + 1];
              s3.x < t2 && c2.x < t2 || (s3.x < t2 ? s3 = new y(t2, s3.y + (t2 - s3.x) / (c2.x - s3.x) * (c2.y - s3.y))._round() : c2.x < t2 && (c2 = new y(t2, s3.y + (t2 - s3.x) / (c2.x - s3.x) * (c2.y - s3.y))._round()), s3.y < i2 && c2.y < i2 || (s3.y < i2 ? s3 = new y(s3.x + (i2 - s3.y) / (c2.y - s3.y) * (c2.x - s3.x), i2)._round() : c2.y < i2 && (c2 = new y(s3.x + (i2 - s3.y) / (c2.y - s3.y) * (c2.x - s3.x), i2)._round()), s3.x >= r2 && c2.x >= r2 || (s3.x >= r2 ? s3 = new y(r2, s3.y + (r2 - s3.x) / (c2.x - s3.x) * (c2.y - s3.y))._round() : c2.x >= r2 && (c2 = new y(r2, s3.y + (r2 - s3.x) / (c2.x - s3.x) * (c2.y - s3.y))._round()), s3.y >= n2 && c2.y >= n2 || (s3.y >= n2 ? s3 = new y(s3.x + (n2 - s3.y) / (c2.y - s3.y) * (c2.x - s3.x), n2)._round() : c2.y >= n2 && (c2 = new y(s3.x + (n2 - s3.y) / (c2.y - s3.y) * (c2.x - s3.x), n2)._round()), l2 && s3.equals(l2[l2.length - 1]) || (l2 = [s3], o2.push(l2)), l2.push(c2)))));
            }
          }
          return o2;
        }
        Is(F_, "Anchor");
        const H_ = 1e20;
        function W_(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          for (let c2 = t2; c2 < t2 + r2; c2++)
            X_(e2, i2 * o2 + c2, o2, n2, s2, a2, l2);
          for (let c2 = i2; c2 < i2 + n2; c2++)
            X_(e2, c2 * o2 + t2, 1, r2, s2, a2, l2);
        }
        function X_(e2, t2, i2, r2, n2, o2, s2) {
          o2[0] = 0, s2[0] = -H_, s2[1] = H_, n2[0] = e2[t2];
          for (let a2 = 1, l2 = 0, c2 = 0; a2 < r2; a2++) {
            n2[a2] = e2[t2 + a2 * i2];
            const r3 = a2 * a2;
            do {
              const e3 = o2[l2];
              c2 = (n2[a2] - n2[e3] + r3 - e3 * e3) / (a2 - e3) / 2;
            } while (c2 <= s2[l2] && --l2 > -1);
            l2++, o2[l2] = a2, s2[l2] = c2, s2[l2 + 1] = H_;
          }
          for (let a2 = 0, l2 = 0; a2 < r2; a2++) {
            for (; s2[l2 + 1] < a2; )
              l2++;
            const r3 = o2[l2], c2 = a2 - r3;
            e2[t2 + a2 * i2] = n2[r3] + c2 * c2;
          }
        }
        const Y_ = 2;
        class K_ {
          constructor(e2, t2, i2) {
            this.requestManager = e2, this.localGlyphMode = t2, this.localFontFamily = i2, this.urls = {}, this.entries = {}, this.localGlyphs = { 200: {}, 400: {}, 500: {}, 900: {} };
          }
          setURL(e2, t2) {
            this.urls[t2] = e2;
          }
          getGlyphs(e2, t2, i2) {
            const r2 = [], o2 = this.urls[t2] || n.GLYPHS_URL;
            for (const t3 in e2)
              for (const i3 of e2[t3])
                r2.push({ stack: t3, id: i3 });
            R(r2, ({ stack: e3, id: t3 }, i3) => {
              let r3 = this.entries[e3];
              r3 || (r3 = this.entries[e3] = { glyphs: {}, requests: {}, ranges: {}, ascender: void 0, descender: void 0 });
              let n2 = r3.glyphs[t3];
              if (void 0 !== n2)
                return void i3(null, { stack: e3, id: t3, glyph: n2 });
              if (n2 = this._tinySDF(r3, e3, t3), n2)
                return r3.glyphs[t3] = n2, void i3(null, { stack: e3, id: t3, glyph: n2 });
              const s2 = Math.floor(t3 / 256);
              if (256 * s2 > 65535)
                return void i3(new Error("glyphs > 65535 not supported"));
              if (r3.ranges[s2])
                return void i3(null, { stack: e3, id: t3, glyph: n2 });
              let a2 = r3.requests[s2];
              a2 || (a2 = r3.requests[s2] = [], K_.loadGlyphRange(e3, s2, o2, this.requestManager, (e4, t4) => {
                if (t4) {
                  r3.ascender = t4.ascender, r3.descender = t4.descender;
                  for (const e5 in t4.glyphs)
                    this._doesCharSupportLocalGlyph(+e5) || (r3.glyphs[+e5] = t4.glyphs[+e5]);
                  r3.ranges[s2] = true;
                }
                for (const i4 of a2)
                  i4(e4, t4);
                delete r3.requests[s2];
              })), a2.push((r4, n3) => {
                r4 ? i3(r4) : n3 && i3(null, { stack: e3, id: t3, glyph: n3.glyphs[t3] || null });
              });
            }, (e3, t3) => {
              if (e3)
                i2(e3);
              else if (t3) {
                const e4 = {};
                for (const { stack: i3, id: r3, glyph: n2 } of t3)
                  void 0 === e4[i3] && (e4[i3] = {}), void 0 === e4[i3].glyphs && (e4[i3].glyphs = {}), e4[i3].glyphs[r3] = n2 && { id: n2.id, bitmap: n2.bitmap.clone(), metrics: n2.metrics }, e4[i3].ascender = this.entries[i3].ascender, e4[i3].descender = this.entries[i3].descender;
                i2(null, e4);
              }
            });
          }
          _doesCharSupportLocalGlyph(e2) {
            return 0 !== this.localGlyphMode && (2 === this.localGlyphMode ? !!this.localFontFamily : !!this.localFontFamily && (Rs["CJK Unified Ideographs"](e2) || Rs["Hangul Syllables"](e2) || Rs.Hiragana(e2) || Rs.Katakana(e2) || Rs["CJK Symbols and Punctuation"](e2) || Rs["CJK Unified Ideographs Extension A"](e2) || Rs["CJK Unified Ideographs Extension B"](e2)));
          }
          _tinySDF(e2, t2, i2) {
            const r2 = this.localFontFamily;
            if (!r2 || !this._doesCharSupportLocalGlyph(i2))
              return;
            let n2 = e2.tinySDF;
            if (!n2) {
              let i3 = "400";
              /bold/i.test(t2) ? i3 = "900" : /medium/i.test(t2) ? i3 = "500" : /light/i.test(t2) && (i3 = "200"), n2 = e2.tinySDF = new K_.TinySDF({ fontFamily: r2, fontWeight: i3, fontSize: 24 * Y_, buffer: 3 * Y_, radius: 8 * Y_ }), n2.fontWeight = i3;
            }
            if (this.localGlyphs[n2.fontWeight][i2])
              return this.localGlyphs[n2.fontWeight][i2];
            const o2 = String.fromCodePoint(i2), { data: s2, width: a2, height: l2, glyphWidth: c2, glyphHeight: h2, glyphLeft: u2, glyphTop: d2, glyphAdvance: p2 } = n2.draw(o2);
            return this.localGlyphs[n2.fontWeight][i2] = { id: i2, bitmap: new Zp({ width: a2, height: l2 }, s2), metrics: { width: c2 / Y_, height: h2 / Y_, left: u2 / Y_, top: d2 / Y_ - 27, advance: p2 / Y_, localGlyph: true } };
          }
        }
        K_.loadGlyphRange = function(e2, t2, i2, r2, n2) {
          const o2 = 256 * t2, s2 = o2 + 255, a2 = r2.transformRequest(r2.normalizeGlyphsURL(i2).replace("{fontstack}", e2).replace("{range}", `${o2}-${s2}`), ye.Glyphs);
          Te(a2, (e3, t3) => {
            if (e3)
              n2(e3);
            else if (t3) {
              const e4 = {}, i3 = function(e5) {
                return new Sm(e5).readFields(f_, {});
              }(t3);
              for (const t4 of i3.glyphs)
                e4[t4.id] = t4;
              n2(null, { glyphs: e4, ascender: i3.ascender, descender: i3.descender });
            }
          });
        }, K_.TinySDF = class {
          constructor({ fontSize: e2 = 24, buffer: t2 = 3, radius: i2 = 8, cutoff: r2 = 0.25, fontFamily: n2 = "sans-serif", fontWeight: o2 = "normal", fontStyle: s2 = "normal" } = {}) {
            this.buffer = t2, this.cutoff = r2, this.radius = i2;
            const a2 = this.size = e2 + 4 * t2, l2 = this._createCanvas(a2), c2 = this.ctx = l2.getContext("2d", { willReadFrequently: true });
            c2.font = `${s2} ${o2} ${e2}px ${n2}`, c2.textBaseline = "alphabetic", c2.textAlign = "left", c2.fillStyle = "black", this.gridOuter = new Float64Array(a2 * a2), this.gridInner = new Float64Array(a2 * a2), this.f = new Float64Array(a2), this.z = new Float64Array(a2 + 1), this.v = new Uint16Array(a2);
          }
          _createCanvas(e2) {
            const t2 = document.createElement("canvas");
            return t2.width = t2.height = e2, t2;
          }
          draw(e2) {
            const { width: t2, actualBoundingBoxAscent: i2, actualBoundingBoxDescent: r2, actualBoundingBoxLeft: n2, actualBoundingBoxRight: o2 } = this.ctx.measureText(e2), s2 = Math.ceil(i2), a2 = Math.max(0, Math.min(this.size - this.buffer, Math.ceil(o2 - n2))), l2 = Math.min(this.size - this.buffer, s2 + Math.ceil(r2)), c2 = a2 + 2 * this.buffer, h2 = l2 + 2 * this.buffer, u2 = Math.max(c2 * h2, 0), d2 = new Uint8ClampedArray(u2), p2 = { data: d2, width: c2, height: h2, glyphWidth: a2, glyphHeight: l2, glyphTop: s2, glyphLeft: 0, glyphAdvance: t2 };
            if (0 === a2 || 0 === l2)
              return p2;
            const { ctx: f2, buffer: m2, gridInner: _2, gridOuter: g2 } = this;
            f2.clearRect(m2, m2, a2, l2), f2.fillText(e2, m2, m2 + s2);
            const y2 = f2.getImageData(m2, m2, a2, l2);
            g2.fill(H_, 0, u2), _2.fill(0, 0, u2);
            for (let e3 = 0; e3 < l2; e3++)
              for (let t3 = 0; t3 < a2; t3++) {
                const i3 = y2.data[4 * (e3 * a2 + t3) + 3] / 255;
                if (0 === i3)
                  continue;
                const r3 = (e3 + m2) * c2 + t3 + m2;
                if (1 === i3)
                  g2[r3] = 0, _2[r3] = H_;
                else {
                  const e4 = 0.5 - i3;
                  g2[r3] = e4 > 0 ? e4 * e4 : 0, _2[r3] = e4 < 0 ? e4 * e4 : 0;
                }
              }
            W_(g2, 0, 0, c2, h2, c2, this.f, this.v, this.z), W_(_2, m2, m2, a2, l2, c2, this.f, this.v, this.z);
            for (let e3 = 0; e3 < u2; e3++) {
              const t3 = Math.sqrt(g2[e3]) - Math.sqrt(_2[e3]);
              d2[e3] = Math.round(255 - 255 * (t3 / this.radius + this.cutoff));
            }
            return p2;
          }
        };
        const J_ = x_;
        function Q_(e2, t2, i2, r2) {
          const n2 = [], o2 = e2.imagePrimary, s2 = o2.pixelRatio, a2 = o2.paddedRect.w - 2 * J_, l2 = o2.paddedRect.h - 2 * J_, c2 = e2.right - e2.left, h2 = e2.bottom - e2.top, u2 = o2.stretchX || [[0, a2]], d2 = o2.stretchY || [[0, l2]], p2 = (e3, t3) => e3 + t3[1] - t3[0], f2 = u2.reduce(p2, 0), m2 = d2.reduce(p2, 0), _2 = a2 - f2, g2 = l2 - m2;
          let x2 = 0, v2 = f2, b2 = 0, w2 = m2, T2 = 0, E2 = _2, M2 = 0, A2 = g2;
          if (o2.content && r2) {
            const e3 = o2.content;
            x2 = eg(u2, 0, e3[0]), b2 = eg(d2, 0, e3[1]), v2 = eg(u2, e3[0], e3[2]), w2 = eg(d2, e3[1], e3[3]), T2 = e3[0] - x2, M2 = e3[1] - b2, E2 = e3[2] - e3[0] - v2, A2 = e3[3] - e3[1] - w2;
          }
          const S2 = (r3, n3, a3, l3) => {
            const u3 = ig(r3.stretch - x2, v2, c2, e2.left), d3 = rg(r3.fixed - T2, E2, r3.stretch, f2), p3 = ig(n3.stretch - b2, w2, h2, e2.top), _3 = rg(n3.fixed - M2, A2, n3.stretch, m2), g3 = ig(a3.stretch - x2, v2, c2, e2.left), S3 = rg(a3.fixed - T2, E2, a3.stretch, f2), I2 = ig(l3.stretch - b2, w2, h2, e2.top), C2 = rg(l3.fixed - M2, A2, l3.stretch, m2), z2 = new y(u3, p3), D2 = new y(g3, p3), P2 = new y(g3, I2), R2 = new y(u3, I2), L2 = new y(d3 / s2, _3 / s2), k2 = new y(S3 / s2, C2 / s2), O2 = t2 * Math.PI / 180;
            if (O2) {
              const e3 = Math.sin(O2), t3 = Math.cos(O2), i3 = [t3, -e3, e3, t3];
              z2._matMult(i3), D2._matMult(i3), R2._matMult(i3), P2._matMult(i3);
            }
            const B2 = r3.stretch + r3.fixed, F2 = a3.stretch + a3.fixed, N2 = n3.stretch + n3.fixed, U2 = l3.stretch + l3.fixed, V2 = e2.imageSecondary;
            return { tl: z2, tr: D2, bl: R2, br: P2, texPrimary: { x: o2.paddedRect.x + J_ + B2, y: o2.paddedRect.y + J_ + N2, w: F2 - B2, h: U2 - N2 }, texSecondary: V2 ? { x: V2.paddedRect.x + J_ + B2, y: V2.paddedRect.y + J_ + N2, w: F2 - B2, h: U2 - N2 } : void 0, writingMode: void 0, glyphOffset: [0, 0], sectionIndex: 0, pixelOffsetTL: L2, pixelOffsetBR: k2, minFontScaleX: E2 / s2 / c2, minFontScaleY: A2 / s2 / h2, isSDF: i2 };
          };
          if (r2 && (o2.stretchX || o2.stretchY)) {
            const e3 = tg(u2, _2, f2), t3 = tg(d2, g2, m2);
            for (let i3 = 0; i3 < e3.length - 1; i3++) {
              const r3 = e3[i3], o3 = e3[i3 + 1];
              for (let e4 = 0; e4 < t3.length - 1; e4++)
                n2.push(S2(r3, t3[e4], o3, t3[e4 + 1]));
            }
          } else
            n2.push(S2({ fixed: 0, stretch: -1 }, { fixed: 0, stretch: -1 }, { fixed: 0, stretch: a2 + 1 }, { fixed: 0, stretch: l2 + 1 }));
          return n2;
        }
        function eg(e2, t2, i2) {
          let r2 = 0;
          for (const n2 of e2)
            r2 += Math.max(t2, Math.min(i2, n2[1])) - Math.max(t2, Math.min(i2, n2[0]));
          return r2;
        }
        function tg(e2, t2, i2) {
          const r2 = [{ fixed: -J_, stretch: 0 }];
          for (const [t3, i3] of e2) {
            const e3 = r2[r2.length - 1];
            r2.push({ fixed: t3 - e3.stretch, stretch: e3.stretch }), r2.push({ fixed: t3 - e3.stretch, stretch: e3.stretch + (i3 - t3) });
          }
          return r2.push({ fixed: t2 + J_, stretch: i2 }), r2;
        }
        function ig(e2, t2, i2, r2) {
          return e2 / t2 * i2 + r2;
        }
        function rg(e2, t2, i2, r2) {
          return e2 - t2 * i2 / r2;
        }
        function ng(e2, t2, i2, r2) {
          const n2 = t2 + e2.positionedLines[r2].lineOffset;
          return 0 === r2 ? i2 + n2 / 2 : i2 + (n2 + (t2 + e2.positionedLines[r2 - 1].lineOffset)) / 2;
        }
        function og(e2, t2 = 1, i2 = false) {
          let r2 = 1 / 0, n2 = 1 / 0, o2 = -1 / 0, s2 = -1 / 0;
          const a2 = e2[0];
          for (let e3 = 0; e3 < a2.length; e3++) {
            const t3 = a2[e3];
            (!e3 || t3.x < r2) && (r2 = t3.x), (!e3 || t3.y < n2) && (n2 = t3.y), (!e3 || t3.x > o2) && (o2 = t3.x), (!e3 || t3.y > s2) && (s2 = t3.y);
          }
          const l2 = Math.min(o2 - r2, s2 - n2);
          let c2 = l2 / 2;
          const h2 = new or([], sg);
          if (0 === l2)
            return new y(r2, n2);
          for (let t3 = r2; t3 < o2; t3 += l2)
            for (let i3 = n2; i3 < s2; i3 += l2)
              h2.push(new ag(t3 + c2, i3 + c2, c2, e2));
          let u2 = function(e3) {
            let t3 = 0, i3 = 0, r3 = 0;
            const n3 = e3[0];
            for (let e4 = 0, o3 = n3.length, s3 = o3 - 1; e4 < o3; s3 = e4++) {
              const o4 = n3[e4], a3 = n3[s3], l3 = o4.x * a3.y - a3.x * o4.y;
              i3 += (o4.x + a3.x) * l3, r3 += (o4.y + a3.y) * l3, t3 += 3 * l3;
            }
            return new ag(i3 / t3, r3 / t3, 0, e3);
          }(e2), d2 = h2.length;
          for (; h2.length; ) {
            const r3 = h2.pop();
            (r3.d > u2.d || !u2.d) && (u2 = r3, i2 && console.log("found best %d after %d probes", Math.round(1e4 * r3.d) / 1e4, d2)), r3.max - u2.d <= t2 || (c2 = r3.h / 2, h2.push(new ag(r3.p.x - c2, r3.p.y - c2, c2, e2)), h2.push(new ag(r3.p.x + c2, r3.p.y - c2, c2, e2)), h2.push(new ag(r3.p.x - c2, r3.p.y + c2, c2, e2)), h2.push(new ag(r3.p.x + c2, r3.p.y + c2, c2, e2)), d2 += 4);
          }
          return i2 && (console.log(`num probes: ${d2}`), console.log(`best distance: ${u2.d}`)), u2.p;
        }
        function sg(e2, t2) {
          return t2.max - e2.max;
        }
        class ag {
          constructor(e2, t2, i2, r2) {
            this.p = new y(e2, t2), this.h = i2, this.d = function(e3, t3) {
              let i3 = false, r3 = 1 / 0;
              for (let n2 = 0; n2 < t3.length; n2++) {
                const o2 = t3[n2];
                for (let t4 = 0, n3 = o2.length, s2 = n3 - 1; t4 < n3; s2 = t4++) {
                  const n4 = o2[t4], a2 = o2[s2];
                  n4.y > e3.y != a2.y > e3.y && e3.x < (a2.x - n4.x) * (e3.y - n4.y) / (a2.y - n4.y) + n4.x && (i3 = !i3), r3 = Math.min(r3, vp(e3, n4, a2));
                }
              }
              return (i3 ? 1 : -1) * Math.sqrt(r3);
            }(this.p, r2), this.max = this.d + this.h * Math.SQRT2;
          }
        }
        const lg = 7, cg = Number.POSITIVE_INFINITY, hg = Math.sqrt(2);
        function ug(e2, [t2, i2]) {
          let r2 = 0, n2 = 0;
          if (i2 === cg) {
            t2 < 0 && (t2 = 0);
            const i3 = t2 / hg;
            switch (e2) {
              case "top-right":
              case "top-left":
                n2 = i3 - lg;
                break;
              case "bottom-right":
              case "bottom-left":
                n2 = -i3 + lg;
                break;
              case "bottom":
                n2 = -t2 + lg;
                break;
              case "top":
                n2 = t2 - lg;
            }
            switch (e2) {
              case "top-right":
              case "bottom-right":
                r2 = -i3;
                break;
              case "top-left":
              case "bottom-left":
                r2 = i3;
                break;
              case "left":
                r2 = t2;
                break;
              case "right":
                r2 = -t2;
            }
          } else {
            switch (t2 = Math.abs(t2), i2 = Math.abs(i2), e2) {
              case "top-right":
              case "top-left":
              case "top":
                n2 = i2 - lg;
                break;
              case "bottom-right":
              case "bottom-left":
              case "bottom":
                n2 = -i2 + lg;
            }
            switch (e2) {
              case "top-right":
              case "bottom-right":
              case "right":
                r2 = -t2;
                break;
              case "top-left":
              case "bottom-left":
              case "left":
                r2 = t2;
            }
          }
          return [r2, n2];
        }
        function dg(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2) {
          e2.createArrays(), e2.tilePixelRatio = sr / (512 * e2.overscaling), e2.compareText = {}, e2.iconsNeedLinear = false;
          const u2 = e2.layers[0].layout, d2 = e2.layers[0]._unevaluatedLayout._values, p2 = {};
          if ("composite" === e2.textSizeData.kind) {
            const { minZoom: t3, maxZoom: i3 } = e2.textSizeData;
            p2.compositeTextSizes = [d2["text-size"].possiblyEvaluate(new ea(t3), a2), d2["text-size"].possiblyEvaluate(new ea(i3), a2)];
          }
          if ("composite" === e2.iconSizeData.kind) {
            const { minZoom: t3, maxZoom: i3 } = e2.iconSizeData;
            p2.compositeIconSizes = [d2["icon-size"].possiblyEvaluate(new ea(t3), a2), d2["icon-size"].possiblyEvaluate(new ea(i3), a2)];
          }
          p2.layoutTextSize = d2["text-size"].possiblyEvaluate(new ea(l2 + 1), a2), p2.layoutIconSize = d2["icon-size"].possiblyEvaluate(new ea(l2 + 1), a2), p2.textMaxSize = d2["text-size"].possiblyEvaluate(new ea(18), a2);
          const f2 = "map" === u2.get("text-rotation-alignment") && "point" !== u2.get("symbol-placement"), m2 = u2.get("text-size");
          let _2 = false;
          for (const t3 of e2.features)
            if (t3.icon && t3.icon.nameSecondary) {
              _2 = true;
              break;
            }
          for (const o3 of e2.features) {
            const l3 = u2.get("text-font").evaluate(o3, {}, a2).join(","), d3 = m2.evaluate(o3, {}, a2), g2 = p2.layoutTextSize.evaluate(o3, {}, a2), y2 = (p2.layoutIconSize.evaluate(o3, {}, a2), { horizontal: {}, vertical: void 0 }), x2 = o3.text;
            let v2, b2 = [0, 0];
            if (x2) {
              const r3 = x2.toString(), s3 = u2.get("text-letter-spacing").evaluate(o3, {}, a2) * r_, c3 = u2.get("text-line-height").evaluate(o3, {}, a2) * r_, h3 = ks(r3) ? s3 : 0, p3 = u2.get("text-anchor").evaluate(o3, {}, a2), m3 = u2.get("text-variable-anchor");
              if (!m3) {
                const e3 = u2.get("text-radial-offset").evaluate(o3, {}, a2);
                b2 = e3 ? ug(p3, [e3 * r_, cg]) : u2.get("text-offset").evaluate(o3, {}, a2).map((e4) => e4 * r_);
              }
              let _3 = f2 ? "center" : u2.get("text-justify").evaluate(o3, {}, a2);
              const v3 = "point" === u2.get("symbol-placement"), w3 = v3 ? u2.get("text-max-width").evaluate(o3, {}, a2) * r_ : 1 / 0, T3 = (o4) => {
                e2.allowVerticalPlacement && Ls(r3) && (y2.vertical = A_(x2, t2, i2, n2, l3, w3, c3, p3, o4, h3, b2, w_.vertical, true, g2, d3));
              };
              if (!f2 && m3) {
                const e3 = "auto" === _3 ? m3.map((e4) => pg(e4)) : [_3];
                let r4 = false;
                for (let o4 = 0; o4 < e3.length; o4++) {
                  const s4 = e3[o4];
                  if (!y2.horizontal[s4])
                    if (r4)
                      y2.horizontal[s4] = y2.horizontal[0];
                    else {
                      const e4 = A_(x2, t2, i2, n2, l3, w3, c3, "center", s4, h3, b2, w_.horizontal, false, g2, d3);
                      e4 && (y2.horizontal[s4] = e4, r4 = 1 === e4.positionedLines.length);
                    }
                }
                T3("left");
              } else {
                if ("auto" === _3 && (_3 = pg(p3)), v3 || u2.get("text-writing-mode").indexOf("horizontal") >= 0 || !Ls(r3)) {
                  const e3 = A_(x2, t2, i2, n2, l3, w3, c3, p3, _3, h3, b2, w_.horizontal, false, g2, d3);
                  e3 && (y2.horizontal[_3] = e3);
                }
                T3(v3 ? "left" : _3);
              }
            }
            let w2 = false;
            if (o3.icon && o3.icon.namePrimary) {
              const t3 = r2[o3.icon.namePrimary];
              t3 && (v2 = O_(n2[o3.icon.namePrimary], o3.icon.nameSecondary ? n2[o3.icon.nameSecondary] : void 0, u2.get("icon-offset").evaluate(o3, {}, a2), u2.get("icon-anchor").evaluate(o3, {}, a2)), w2 = t3.sdf, void 0 === e2.sdfIcons ? e2.sdfIcons = t3.sdf : e2.sdfIcons !== t3.sdf && W("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"), (t3.pixelRatio !== e2.pixelRatio || 0 !== u2.get("icon-rotate").constantOr(1)) && (e2.iconsNeedLinear = true));
            }
            const T2 = yg(y2.horizontal) || y2.vertical;
            e2.iconsInText || (e2.iconsInText = !!T2 && T2.iconsInText), (T2 || v2) && fg(e2, o3, y2, v2, r2, p2, g2, 0, b2, w2, s2, a2, c2, h2, _2);
          }
          o2 && e2.generateCollisionDebugBuffers(l2, e2.collisionBoxArray);
        }
        function pg(e2) {
          switch (e2) {
            case "right":
            case "top-right":
            case "bottom-right":
              return "right";
            case "left":
            case "top-left":
            case "bottom-left":
              return "left";
          }
          return "center";
        }
        function fg(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2) {
          let m2 = o2.textMaxSize.evaluate(t2, {}, u2);
          void 0 === m2 && (m2 = s2);
          const _2 = e2.layers[0].layout, g2 = _2.get("icon-offset").evaluate(t2, {}, u2), y2 = yg(i2.horizontal) || i2.vertical, x2 = "globe" === d2.name, v2 = r_, b2 = s2 / v2, T2 = e2.tilePixelRatio * m2 / v2, E2 = (P2 = e2.overscaling, e2.zoom > 18 && P2 > 2 && (P2 >>= 1), Math.max(sr / (512 * P2), 1) * _2.get("symbol-spacing")), M2 = _2.get("text-padding") * e2.tilePixelRatio, A2 = _2.get("icon-padding") * e2.tilePixelRatio, S2 = w(_2.get("text-max-angle")), I2 = "map" === _2.get("text-rotation-alignment") && "point" !== _2.get("symbol-placement"), C2 = "map" === _2.get("icon-rotation-alignment") && "point" !== _2.get("symbol-placement"), z2 = _2.get("symbol-placement"), D2 = E2 / 2;
          var P2;
          const R2 = _2.get("icon-text-fit").evaluate(t2, {}, u2), L2 = _2.get("icon-text-fit-padding").evaluate(t2, {}, u2), k2 = "none" !== R2;
          let O2;
          false === e2.hasAnyIconTextFit && k2 && (e2.hasAnyIconTextFit = true), r2 && k2 && (e2.allowVerticalPlacement && i2.vertical && (O2 = B_(r2, i2.vertical, R2, L2, g2, b2)), y2 && (r2 = B_(r2, y2, R2, L2, g2, b2)));
          const B2 = (s3, a3, m3) => {
            if (a3.x < 0 || a3.x >= sr || a3.y < 0 || a3.y >= sr)
              return;
            let _3 = null;
            if (x2) {
              const { x: e3, y: t3, z: i3 } = d2.projectTilePoint(a3.x, a3.y, m3);
              _3 = { anchor: new F_(e3, t3, i3, 0, void 0), up: d2.upVector(m3, a3.x, a3.y) };
            }
            !function(e3, t3, i3, r3, n3, o3, s4, a4, l3, c3, h3, u3, d3, p3, f3, m4, _4, g3, y3, x3, v3, b3, w2, T3, E3, M3, A3) {
              const S3 = e3.addToLineVertexArray(t3, r3);
              let I3, C3, z3, D3, P3, R3, L3, k3 = 0, O3 = 0, B3 = 0, F2 = 0, N2 = -1, U2 = -1;
              const V2 = {};
              let j2 = wl("");
              const G2 = i3 ? i3.anchor : t3, q2 = "none" !== l3.layout.get("icon-text-fit").evaluate(v3, {}, E3);
              let Z2 = 0, $2 = 0;
              if (void 0 === l3._unevaluatedLayout.getValue("text-radial-offset") ? [Z2, $2] = l3.layout.get("text-offset").evaluate(v3, {}, E3).map((e4) => e4 * r_) : (Z2 = l3.layout.get("text-radial-offset").evaluate(v3, {}, E3) * r_, $2 = cg), e3.allowVerticalPlacement && n3.vertical) {
                const e4 = n3.vertical;
                if (f3)
                  R3 = vg(e4), a4 && (L3 = vg(a4));
                else {
                  const i4 = l3.layout.get("text-rotate").evaluate(v3, {}, E3) + 90;
                  z3 = xg(c3, G2, t3, h3, u3, d3, e4, p3, i4, m4), a4 && (D3 = xg(c3, G2, t3, h3, u3, d3, a4, g3, i4));
                }
              }
              if (o3) {
                const r4 = l3.layout.get("icon-rotate").evaluate(v3, {}, E3), n4 = Q_(o3, r4, w2, q2), s5 = a4 ? Q_(a4, r4, w2, q2) : void 0;
                C3 = xg(c3, G2, t3, h3, u3, d3, o3, g3, r4), k3 = 4 * n4.length;
                const p4 = e3.iconSizeData;
                let f4 = null;
                "source" === p4.kind ? (f4 = [n_ * l3.layout.get("icon-size").evaluate(v3, {}, E3)], f4[0] > _g && W(`${e3.layerIds[0]}: Value for "icon-size" is >= ${mg}. Reduce your "icon-size".`)) : "composite" === p4.kind && (f4 = [n_ * b3.compositeIconSizes[0].evaluate(v3, {}, E3), n_ * b3.compositeIconSizes[1].evaluate(v3, {}, E3)], (f4[0] > _g || f4[1] > _g) && W(`${e3.layerIds[0]}: Value for "icon-size" is >= ${mg}. Reduce your "icon-size".`)), e3.addSymbols(e3.icon, n4, f4, x3, y3, v3, false, i3, t3, S3.lineStartIndex, S3.lineLength, -1, T3, E3, M3, A3), N2 = e3.icon.placedSymbolArray.length - 1, s5 && (O3 = 4 * s5.length, e3.addSymbols(e3.icon, s5, f4, x3, y3, v3, w_.vertical, i3, t3, S3.lineStartIndex, S3.lineLength, -1, T3, E3, M3, A3), U2 = e3.icon.placedSymbolArray.length - 1);
              }
              for (const r4 in n3.horizontal) {
                const o4 = n3.horizontal[r4];
                I3 || (j2 = wl(o4.text), f3 ? P3 = vg(o4) : I3 = xg(c3, G2, t3, h3, u3, d3, o4, p3, l3.layout.get("text-rotate").evaluate(v3, {}, E3), m4));
                const a5 = 1 === o4.positionedLines.length;
                if (B3 += gg(e3, i3, t3, o4, s4, l3, f3, v3, m4, S3, n3.vertical ? w_.horizontal : w_.horizontalOnly, a5 ? Object.keys(n3.horizontal) : [r4], V2, N2, b3, T3, E3, M3), a5)
                  break;
              }
              n3.vertical && (F2 += gg(e3, i3, t3, n3.vertical, s4, l3, f3, v3, m4, S3, w_.vertical, ["vertical"], V2, U2, b3, T3, E3, M3));
              let H2 = -1;
              const X2 = (e4, t4) => e4 ? Math.max(e4, t4) : t4;
              H2 = X2(P3, H2), H2 = X2(R3, H2), H2 = X2(L3, H2);
              const Y2 = H2 > -1 ? 1 : 0;
              e3.glyphOffsetArray.length >= cy.MAX_GLYPHS && W("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"), void 0 !== v3.sortKey && e3.addToSortKeyRanges(e3.symbolInstances.length, v3.sortKey), e3.symbolInstances.emplaceBack(t3.x, t3.y, G2.x, G2.y, G2.z, V2.right >= 0 ? V2.right : -1, V2.center >= 0 ? V2.center : -1, V2.left >= 0 ? V2.left : -1, V2.vertical >= 0 ? V2.vertical : -1, N2, U2, j2, void 0 !== I3 ? I3 : e3.collisionBoxArray.length, void 0 !== I3 ? I3 + 1 : e3.collisionBoxArray.length, void 0 !== z3 ? z3 : e3.collisionBoxArray.length, void 0 !== z3 ? z3 + 1 : e3.collisionBoxArray.length, void 0 !== C3 ? C3 : e3.collisionBoxArray.length, void 0 !== C3 ? C3 + 1 : e3.collisionBoxArray.length, D3 || e3.collisionBoxArray.length, D3 ? D3 + 1 : e3.collisionBoxArray.length, h3, B3, F2, k3, O3, Y2, 0, Z2, $2, H2, 0, q2 ? 1 : 0);
            }(e2, a3, _3, s3, i2, r2, n2, O2, e2.layers[0], e2.collisionBoxArray, t2.index, t2.sourceLayerIndex, e2.index, M2, I2, l2, 0, A2, C2, g2, t2, o2, c2, h2, u2, p2, f2);
          };
          if ("line" === z2)
            for (const n3 of $_(t2.geometry, 0, 0, sr, sr)) {
              const t3 = q_(n3, E2, S2, i2.vertical || y2, r2, v2, T2, e2.overscaling, sr);
              for (const i3 of t3)
                y2 && bg(e2, y2.text, D2, i3) || B2(n3, i3, u2);
            }
          else if ("line-center" === z2) {
            for (const e3 of t2.geometry)
              if (e3.length > 1) {
                const t3 = G_(e3, S2, i2.vertical || y2, r2, v2, T2);
                t3 && B2(e3, t3, u2);
              }
          } else if ("Polygon" === t2.type)
            for (const e3 of zf(t2.geometry, 0)) {
              const t3 = og(e3, 16);
              B2(e3[0], new F_(t3.x, t3.y, 0, 0, void 0), u2);
            }
          else if ("LineString" === t2.type)
            for (const e3 of t2.geometry)
              B2(e3, new F_(e3[0].x, e3[0].y, 0, 0, void 0), u2);
          else if ("Point" === t2.type)
            for (const e3 of t2.geometry)
              for (const t3 of e3)
                B2([t3], new F_(t3.x, t3.y, 0, 0, void 0), u2);
        }
        const mg = 255, _g = mg * n_;
        function gg(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2) {
          const x2 = function(e3, t3, i3, r3, n3, o3, s3, a3) {
            const l3 = [];
            if (0 === t3.positionedLines.length)
              return l3;
            const c3 = r3.layout.get("text-rotate").evaluate(o3, {}) * Math.PI / 180, h3 = function(e4) {
              const t4 = e4[0], i4 = e4[1], r4 = t4 * i4;
              return r4 > 0 ? [t4, -i4] : r4 < 0 ? [-t4, i4] : 0 === t4 ? [i4, t4] : [i4, -t4];
            }(i3);
            let u3 = Math.abs(t3.top - t3.bottom);
            for (const e4 of t3.positionedLines)
              u3 -= e4.lineOffset;
            const d3 = t3.positionedLines.length, p3 = u3 / d3;
            let f3 = t3.top - i3[1];
            for (let e4 = 0; e4 < d3; ++e4) {
              const r4 = t3.positionedLines[e4];
              f3 = ng(t3, p3, f3, e4);
              for (const e5 of r4.positionedGlyphs) {
                if (!e5.rect)
                  continue;
                const r5 = e5.rect || {};
                let o4 = g_ + 1, u4 = true, d4 = 1, p4 = 0;
                if (e5.imageName) {
                  const t4 = s3[e5.imageName];
                  if (!t4)
                    continue;
                  if (t4.sdf) {
                    W("SDF images are not supported in formatted text and will be ignored.");
                    continue;
                  }
                  u4 = false, d4 = t4.pixelRatio, o4 = x_ / d4;
                }
                const m3 = (n3 || a3) && e5.vertical, _3 = e5.metrics.advance * e5.scale / 2, g3 = e5.metrics, x3 = e5.rect;
                if (null === x3)
                  continue;
                a3 && t3.verticalizable && (p4 = e5.imageName ? _3 - e5.metrics.width * e5.scale / 2 : 0);
                const v3 = n3 ? [e5.x + _3, e5.y] : [0, 0];
                let b3 = [0, 0], w2 = [0, 0], T2 = false;
                n3 || (m3 ? (w2 = [e5.x + _3 + h3[0], e5.y + h3[1] - p4], T2 = true) : b3 = [e5.x + _3 + i3[0], e5.y + i3[1] - p4]);
                const E2 = x3.w * e5.scale / (d4 * (e5.localGlyph ? Y_ : 1)), M2 = x3.h * e5.scale / (d4 * (e5.localGlyph ? Y_ : 1));
                let A2, S2, I2, C2;
                if (m3) {
                  const t4 = e5.y - f3, i4 = new y(-_3, _3 - t4), r6 = -Math.PI / 2, n4 = new y(...w2);
                  A2 = new y(-_3 + b3[0], b3[1]), A2._rotateAround(r6, i4)._add(n4), A2.x += -t4 + _3, A2.y -= (g3.left - o4) * e5.scale;
                  const s4 = e5.imageName ? g3.advance * e5.scale : r_ * e5.scale, a4 = String.fromCodePoint(e5.glyph);
                  u_(a4) ? A2.x += (1 - o4) * e5.scale : d_(a4) ? A2.x += s4 - g3.height * e5.scale + (-o4 - 1) * e5.scale : A2.x += e5.imageName || g3.width + 2 * o4 === x3.w && g3.height + 2 * o4 === x3.h ? (s4 - M2) / 2 : (s4 - (g3.height + 2 * o4) * e5.scale) / 2, S2 = new y(A2.x, A2.y - E2), I2 = new y(A2.x + M2, A2.y), C2 = new y(A2.x + M2, A2.y - E2);
                } else {
                  const t4 = (g3.left - o4) * e5.scale - _3 + b3[0], i4 = (-g3.top - o4) * e5.scale + b3[1], r6 = t4 + E2, n4 = i4 + M2;
                  A2 = new y(t4, i4), S2 = new y(r6, i4), I2 = new y(t4, n4), C2 = new y(r6, n4);
                }
                if (c3) {
                  let e6;
                  e6 = n3 ? new y(0, 0) : T2 ? new y(h3[0], h3[1]) : new y(i3[0], i3[1]), A2._rotateAround(c3, e6), S2._rotateAround(c3, e6), I2._rotateAround(c3, e6), C2._rotateAround(c3, e6);
                }
                const z2 = new y(0, 0), D2 = new y(0, 0);
                l3.push({ tl: A2, tr: S2, bl: I2, br: C2, texPrimary: r5, texSecondary: void 0, writingMode: t3.writingMode, glyphOffset: v3, sectionIndex: e5.sectionIndex, isSDF: u4, pixelOffsetTL: z2, pixelOffsetBR: D2, minFontScaleX: 0, minFontScaleY: 0 });
              }
            }
            return l3;
          }(0, r2, l2, o2, s2, a2, n2, e2.allowVerticalPlacement), v2 = e2.textSizeData;
          let b2 = null;
          "source" === v2.kind ? (b2 = [n_ * o2.layout.get("text-size").evaluate(a2, {}, _2)], b2[0] > _g && W(`${e2.layerIds[0]}: Value for "text-size" is >= ${mg}. Reduce your "text-size".`)) : "composite" === v2.kind && (b2 = [n_ * f2.compositeTextSizes[0].evaluate(a2, {}, _2), n_ * f2.compositeTextSizes[1].evaluate(a2, {}, _2)], (b2[0] > _g || b2[1] > _g) && W(`${e2.layerIds[0]}: Value for "text-size" is >= ${mg}. Reduce your "text-size".`)), e2.addSymbols(e2.text, x2, b2, l2, s2, a2, h2, t2, i2, c2.lineStartIndex, c2.lineLength, p2, m2, _2, g2, false);
          for (const t3 of u2)
            d2[t3] = e2.text.placedSymbolArray.length - 1;
          return 4 * x2.length;
        }
        function yg(e2) {
          for (const t2 in e2)
            return e2[t2];
          return null;
        }
        function xg(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2) {
          let h2 = s2.top, u2 = s2.bottom, d2 = s2.left, p2 = s2.right;
          const f2 = s2.collisionPadding;
          if (f2 && (d2 -= f2[0], h2 -= f2[1], p2 += f2[2], u2 += f2[3]), l2) {
            const e3 = new y(d2, h2), t3 = new y(p2, h2), i3 = new y(d2, u2), r3 = new y(p2, u2), n3 = w(l2);
            let o3 = new y(0, 0);
            c2 && (o3 = new y(c2[0], c2[1])), e3._rotateAround(n3, o3), t3._rotateAround(n3, o3), i3._rotateAround(n3, o3), r3._rotateAround(n3, o3), d2 = Math.min(e3.x, t3.x, i3.x, r3.x), p2 = Math.max(e3.x, t3.x, i3.x, r3.x), h2 = Math.min(e3.y, t3.y, i3.y, r3.y), u2 = Math.max(e3.y, t3.y, i3.y, r3.y);
          }
          return e2.emplaceBack(t2.x, t2.y, t2.z, i2.x, i2.y, d2, h2, p2, u2, a2, r2, n2, o2), e2.length - 1;
        }
        function vg(e2) {
          e2.collisionPadding && (e2.top -= e2.collisionPadding[1], e2.bottom += e2.collisionPadding[3]);
          const t2 = e2.bottom - e2.top;
          return t2 > 0 ? Math.max(10, t2) : null;
        }
        function bg(e2, t2, i2, r2) {
          const n2 = e2.compareText;
          if (t2 in n2) {
            const e3 = n2[t2];
            for (let t3 = e3.length - 1; t3 >= 0; t3--)
              if (r2.dist(e3[t3]) < i2)
                return true;
          } else
            n2[t2] = [];
          return n2[t2].push(r2), false;
        }
        function wg(e2, t2) {
          const i2 = e2.fovAboveCenter, r2 = e2.elevation ? e2.elevation.getMinElevationBelowMSL() * t2 : 0, n2 = (e2._camera.position[2] * e2.worldSize - r2) / Math.cos(e2._pitch), o2 = Math.sin(i2) * n2 / Math.sin(Math.max(Math.PI / 2 - e2._pitch - i2, 0.01)), s2 = Math.sin(e2._pitch) * o2 + n2;
          return Math.min(1.01 * s2, n2 * (1 / e2._horizonShift));
        }
        function Tg(e2, t2) {
          if (!t2.isReprojectedInTileSpace)
            return { scale: 1 << e2.z, x: e2.x, y: e2.y, x2: e2.x + 1, y2: e2.y + 1, projection: t2 };
          const i2 = Math.pow(2, -e2.z), r2 = e2.x * i2, n2 = (e2.x + 1) * i2, o2 = e2.y * i2, s2 = (e2.y + 1) * i2, a2 = $d(r2), l2 = $d(n2), c2 = Hd(o2), h2 = Hd(s2), u2 = t2.project(a2, c2), d2 = t2.project(l2, c2), p2 = t2.project(l2, h2), f2 = t2.project(a2, h2);
          let m2 = Math.min(u2.x, d2.x, p2.x, f2.x), _2 = Math.min(u2.y, d2.y, p2.y, f2.y), g2 = Math.max(u2.x, d2.x, p2.x, f2.x), y2 = Math.max(u2.y, d2.y, p2.y, f2.y);
          const x2 = i2 / 16;
          function v2(e3, i3, r3, n3, o3, s3) {
            const a3 = (r3 + o3) / 2, l3 = (n3 + s3) / 2, c3 = t2.project($d(a3), Hd(l3)), h3 = Math.max(0, m2 - c3.x, _2 - c3.y, c3.x - g2, c3.y - y2);
            m2 = Math.min(m2, c3.x), g2 = Math.max(g2, c3.x), _2 = Math.min(_2, c3.y), y2 = Math.max(y2, c3.y), h3 > x2 && (v2(e3, c3, r3, n3, a3, l3), v2(c3, i3, a3, l3, o3, s3));
          }
          v2(u2, d2, r2, o2, n2, o2), v2(d2, p2, n2, o2, n2, s2), v2(p2, f2, n2, s2, r2, s2), v2(f2, u2, r2, s2, r2, o2), m2 -= x2, _2 -= x2, g2 += x2, y2 += x2;
          const b2 = 1 / Math.max(g2 - m2, y2 - _2);
          return { scale: b2, x: m2 * b2, y: _2 * b2, x2: g2 * b2, y2: y2 * b2, projection: t2 };
        }
        function Eg(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
          if ("globe" === l2.name)
            return ud(e2, t2, new ku(i2, r2, n2), false);
          const c2 = Tg({ z: i2, x: r2, y: n2 }, l2);
          return new Hu([(o2 + c2.x / c2.scale) * t2, t2 * (c2.y / c2.scale), s2], [(o2 + c2.x2 / c2.scale) * t2, t2 * (c2.y2 / c2.scale), a2]);
        }
        function Mg(e2, { x: t2, y: i2 }, r2 = 0) {
          return new y(((t2 - r2) * e2.scale - e2.x) * sr, (i2 * e2.scale - e2.y) * sr);
        }
        function Ag(e2, t2, i2 = 0) {
          return Mu.fromValues(((t2.x - i2) * e2.scale - e2.x) * sr, (t2.y * e2.scale - e2.y) * sr, Wd(t2.z, t2.y));
        }
        const Sg = xu.identity(new Float32Array(16));
        class Ig {
          constructor(e2) {
            this.spec = e2, this.name = e2.name, this.wrap = false, this.requiresDraping = false, this.supportsWorldCopies = false, this.supportsTerrain = false, this.supportsFog = false, this.supportsFreeCamera = false, this.zAxisUnit = "meters", this.isReprojectedInTileSpace = true, this.unsupportedLayers = ["custom"], this.center = [0, 0], this.range = [3.5, 7];
          }
          project(e2, t2) {
            return { x: 0, y: 0, z: 0 };
          }
          unproject(e2, t2) {
            return new Nd(0, 0);
          }
          projectTilePoint(e2, t2, i2) {
            return { x: e2, y: t2, z: 0 };
          }
          locationPoint(e2, t2, i2 = true) {
            return e2._coordinatePoint(e2.locationCoordinate(t2), i2);
          }
          pixelsPerMeter(e2, t2) {
            return Zd(1, e2) * t2;
          }
          pixelSpaceConversion(e2, t2, i2) {
            return 1;
          }
          farthestPixelDistance(e2) {
            return wg(e2, e2.pixelsPerMeter);
          }
          pointCoordinate(e2, t2, i2, r2) {
            const n2 = e2.horizonLineFromTop(false), o2 = new y(t2, Math.max(n2, i2));
            return e2.rayIntersectionCoordinate(e2.pointRayIntersection(o2, r2));
          }
          pointCoordinate3D(e2, t2, i2) {
            const r2 = new y(t2, i2);
            if (e2.elevation)
              return e2.elevation.pointCoordinate(r2);
            {
              const t3 = this.pointCoordinate(e2, r2.x, r2.y, 0);
              return [t3.x, t3.y, t3.z];
            }
          }
          isPointAboveHorizon(e2, t2) {
            if (e2.elevation)
              return !this.pointCoordinate3D(e2, t2.x, t2.y);
            const i2 = e2.horizonLineFromTop();
            return t2.y < i2;
          }
          createInversionMatrix(e2, t2) {
            return Sg;
          }
          createTileMatrix(e2, t2, i2) {
            let r2, n2, o2;
            const s2 = i2.canonical, a2 = xu.identity(new Float64Array(16));
            if (this.isReprojectedInTileSpace) {
              const l2 = Tg(s2, this);
              r2 = 1, n2 = l2.x + i2.wrap * l2.scale, o2 = l2.y, xu.scale(a2, a2, [r2 / l2.scale, r2 / l2.scale, e2.pixelsPerMeter / t2]);
            } else
              r2 = t2 / e2.zoomScale(s2.z), n2 = (s2.x + Math.pow(2, s2.z) * i2.wrap) * r2, o2 = s2.y * r2;
            return xu.translate(a2, a2, [n2, o2, 0]), xu.scale(a2, a2, [r2 / sr, r2 / sr, 1]), a2;
          }
          upVector(e2, t2, i2) {
            return [0, 0, 1];
          }
          upVectorScale(e2, t2, i2) {
            return { metersToTile: 1 };
          }
        }
        class Cg extends Ig {
          constructor(e2) {
            super(e2), this.range = [4, 7], this.center = e2.center || [-96, 37.5];
            const [t2, i2] = this.parallels = e2.parallels || [29.5, 45.5], r2 = Math.sin(w(t2));
            this.n = (r2 + Math.sin(w(i2))) / 2, this.c = 1 + r2 * (2 * this.n - r2), this.r0 = Math.sqrt(this.c) / this.n;
          }
          project(e2, t2) {
            const { n: i2, c: r2, r0: n2 } = this, o2 = w(e2 - this.center[0]), s2 = w(t2), a2 = Math.sqrt(r2 - 2 * i2 * Math.sin(s2)) / i2;
            return { x: a2 * Math.sin(o2 * i2), y: a2 * Math.cos(o2 * i2) - n2, z: 0 };
          }
          unproject(e2, t2) {
            const { n: i2, c: r2, r0: n2 } = this, o2 = n2 + t2;
            let s2 = Math.atan2(e2, Math.abs(o2)) * Math.sign(o2);
            o2 * i2 < 0 && (s2 -= Math.PI * Math.sign(e2) * Math.sign(o2));
            const a2 = w(this.center[0]) * i2;
            s2 = P(s2, -Math.PI - a2, Math.PI - a2);
            const l2 = z(T(s2 / i2) + this.center[0], -180, 180), c2 = Math.asin(z((r2 - (e2 * e2 + o2 * o2) * i2 * i2) / (2 * i2), -1, 1)), h2 = z(T(c2), -Xd, Xd);
            return new Nd(l2, h2);
          }
        }
        const zg = 1.340264, Dg = -0.081106, Pg = 893e-6, Rg = 3796e-6, Lg = Math.sqrt(3) / 2;
        class kg extends Ig {
          project(e2, t2) {
            t2 = t2 / 180 * Math.PI, e2 = e2 / 180 * Math.PI;
            const i2 = Math.asin(Lg * Math.sin(t2)), r2 = i2 * i2, n2 = r2 * r2 * r2;
            return { x: 0.5 * (e2 * Math.cos(i2) / (Lg * (zg + 3 * Dg * r2 + n2 * (7 * Pg + 9 * Rg * r2))) / Math.PI + 0.5), y: 1 - 0.5 * (i2 * (zg + Dg * r2 + n2 * (Pg + Rg * r2)) / Math.PI + 1), z: 0 };
          }
          unproject(e2, t2) {
            e2 = (2 * e2 - 0.5) * Math.PI;
            let i2 = t2 = (2 * (1 - t2) - 1) * Math.PI, r2 = i2 * i2, n2 = r2 * r2 * r2;
            for (let e3, o3, s3, a3 = 0; a3 < 12 && (o3 = i2 * (zg + Dg * r2 + n2 * (Pg + Rg * r2)) - t2, s3 = zg + 3 * Dg * r2 + n2 * (7 * Pg + 9 * Rg * r2), e3 = o3 / s3, i2 = z(i2 - e3, -Math.PI / 3, Math.PI / 3), r2 = i2 * i2, n2 = r2 * r2 * r2, !(Math.abs(e3) < 1e-12)); ++a3)
              ;
            const o2 = Lg * e2 * (zg + 3 * Dg * r2 + n2 * (7 * Pg + 9 * Rg * r2)) / Math.cos(i2), s2 = Math.asin(Math.sin(i2) / Lg), a2 = z(180 * o2 / Math.PI, -180, 180), l2 = z(180 * s2 / Math.PI, -Xd, Xd);
            return new Nd(a2, l2);
          }
        }
        class Og extends Ig {
          constructor(e2) {
            super(e2), this.wrap = true, this.supportsWorldCopies = true;
          }
          project(e2, t2) {
            return { x: 0.5 + e2 / 360, y: 0.5 - t2 / 360, z: 0 };
          }
          unproject(e2, t2) {
            const i2 = 360 * (e2 - 0.5), r2 = z(360 * (0.5 - t2), -Xd, Xd);
            return new Nd(i2, r2);
          }
        }
        const Bg = Math.PI / 2;
        function Fg(e2) {
          return Math.tan((Bg + e2) / 2);
        }
        class Ng extends Ig {
          constructor(e2) {
            super(e2), this.center = e2.center || [0, 30];
            const [t2, i2] = this.parallels = e2.parallels || [30, 30];
            let r2 = w(t2), n2 = w(i2);
            this.southernCenter = r2 + n2 < 0, this.southernCenter && (r2 = -r2, n2 = -n2);
            const o2 = Math.cos(r2), s2 = Fg(r2);
            this.n = r2 === n2 ? Math.sin(r2) : Math.log(o2 / Math.cos(n2)) / Math.log(Fg(n2) / s2), this.f = o2 * Math.pow(Fg(r2), this.n) / this.n;
          }
          project(e2, t2) {
            t2 = w(t2), this.southernCenter && (t2 = -t2), e2 = w(e2 - this.center[0]);
            const i2 = 1e-6, { n: r2, f: n2 } = this;
            n2 > 0 ? t2 < -Bg + i2 && (t2 = -Bg + i2) : t2 > Bg - i2 && (t2 = Bg - i2);
            const o2 = n2 / Math.pow(Fg(t2), r2);
            let s2 = o2 * Math.sin(r2 * e2), a2 = n2 - o2 * Math.cos(r2 * e2);
            return s2 = 0.5 * (s2 / Math.PI + 0.5), a2 = 0.5 * (a2 / Math.PI + 0.5), { x: s2, y: this.southernCenter ? a2 : 1 - a2, z: 0 };
          }
          unproject(e2, t2) {
            e2 = (2 * e2 - 0.5) * Math.PI, this.southernCenter && (t2 = 1 - t2), t2 = (2 * (1 - t2) - 0.5) * Math.PI;
            const { n: i2, f: r2 } = this, n2 = r2 - t2, o2 = Math.sign(n2), s2 = Math.sign(i2) * Math.sqrt(e2 * e2 + n2 * n2);
            let a2 = Math.atan2(e2, Math.abs(n2)) * o2;
            n2 * i2 < 0 && (a2 -= Math.PI * Math.sign(e2) * o2);
            const l2 = z(T(a2 / i2) + this.center[0], -180, 180), c2 = z(T(2 * Math.atan(Math.pow(r2 / s2, 1 / i2)) - Bg), -Xd, Xd);
            return new Nd(l2, this.southernCenter ? -c2 : c2);
          }
        }
        class Ug extends Ig {
          constructor(e2) {
            super(e2), this.wrap = true, this.supportsWorldCopies = true, this.supportsTerrain = true, this.supportsFog = true, this.supportsFreeCamera = true, this.isReprojectedInTileSpace = false, this.unsupportedLayers = [], this.range = null;
          }
          project(e2, t2) {
            return { x: Gd(e2), y: qd(t2), z: 0 };
          }
          unproject(e2, t2) {
            const i2 = $d(e2), r2 = Hd(t2);
            return new Nd(i2, r2);
          }
        }
        const Vg = w(Xd);
        class jg extends Ig {
          project(e2, t2) {
            const i2 = (t2 = w(t2)) * t2, r2 = i2 * i2;
            return { x: 0.5 * ((e2 = w(e2)) * (0.8707 - 0.131979 * i2 + r2 * (r2 * (3971e-6 * i2 - 1529e-6 * r2) - 0.013791)) / Math.PI + 0.5), y: 1 - 0.5 * (t2 * (1.007226 + i2 * (0.015085 + r2 * (0.028874 * i2 - 0.044475 - 5916e-6 * r2))) / Math.PI + 1), z: 0 };
          }
          unproject(e2, t2) {
            e2 = (2 * e2 - 0.5) * Math.PI;
            let i2 = t2 = (2 * (1 - t2) - 1) * Math.PI, r2 = 25, n2 = 0, o2 = i2 * i2;
            do {
              o2 = i2 * i2;
              const e3 = o2 * o2;
              n2 = (i2 * (1.007226 + o2 * (0.015085 + e3 * (0.028874 * o2 - 0.044475 - 5916e-6 * e3))) - t2) / (1.007226 + o2 * (0.045255 + e3 * (0.259866 * o2 - 0.311325 - 5916e-6 * 11 * e3))), i2 = z(i2 - n2, -Vg, Vg);
            } while (Math.abs(n2) > 1e-6 && --r2 > 0);
            o2 = i2 * i2;
            const s2 = z(T(e2 / (0.8707 + o2 * (o2 * (o2 * o2 * o2 * (3971e-6 - 1529e-6 * o2) - 0.013791) - 0.131979))), -180, 180), a2 = T(i2);
            return new Nd(s2, a2);
          }
        }
        const Gg = w(Xd);
        class qg extends Ig {
          project(e2, t2) {
            t2 = w(t2), e2 = w(e2);
            const i2 = Math.cos(t2), r2 = 2 / Math.PI, n2 = Math.acos(i2 * Math.cos(e2 / 2)), o2 = Math.sin(n2) / n2, s2 = 0.5 * (e2 * r2 + 2 * i2 * Math.sin(e2 / 2) / o2) || 0, a2 = 0.5 * (t2 + Math.sin(t2) / o2) || 0;
            return { x: 0.5 * (s2 / Math.PI + 0.5), y: 1 - 0.5 * (a2 / Math.PI + 1), z: 0 };
          }
          unproject(e2, t2) {
            let i2 = e2 = (2 * e2 - 0.5) * Math.PI, r2 = t2 = (2 * (1 - t2) - 1) * Math.PI, n2 = 25;
            const o2 = 1e-6;
            let s2 = 0, a2 = 0;
            do {
              const n3 = Math.cos(r2), o3 = Math.sin(r2), l2 = 2 * o3 * n3, c2 = o3 * o3, h2 = n3 * n3, u2 = Math.cos(i2 / 2), d2 = Math.sin(i2 / 2), p2 = 2 * u2 * d2, f2 = d2 * d2, m2 = 1 - h2 * u2 * u2, _2 = m2 ? 1 / m2 : 0, g2 = m2 ? Math.acos(n3 * u2) * Math.sqrt(1 / m2) : 0, y2 = 0.5 * (2 * g2 * n3 * d2 + 2 * i2 / Math.PI) - e2, x2 = 0.5 * (g2 * o3 + r2) - t2, v2 = 0.5 * _2 * (h2 * f2 + g2 * n3 * u2 * c2) + 1 / Math.PI, b2 = _2 * (p2 * l2 / 4 - g2 * o3 * d2), w2 = 0.125 * _2 * (l2 * d2 - g2 * o3 * h2 * p2), T2 = 0.5 * _2 * (c2 * u2 + g2 * f2 * n3) + 0.5, E2 = b2 * w2 - T2 * v2;
              s2 = (x2 * b2 - y2 * T2) / E2, a2 = (y2 * w2 - x2 * v2) / E2, i2 = z(i2 - s2, -Math.PI, Math.PI), r2 = z(r2 - a2, -Gg, Gg);
            } while ((Math.abs(s2) > o2 || Math.abs(a2) > o2) && --n2 > 0);
            return new Nd(T(i2), T(r2));
          }
        }
        class Zg extends Ig {
          constructor(e2) {
            super(e2), this.center = e2.center || [0, 0], this.parallels = e2.parallels || [0, 0], this.cosPhi = Math.max(0.01, Math.cos(w(this.parallels[0]))), this.scale = 1 / (2 * Math.max(Math.PI * this.cosPhi, 1 / this.cosPhi)), this.wrap = true, this.supportsWorldCopies = true;
          }
          project(e2, t2) {
            const { scale: i2, cosPhi: r2 } = this;
            return { x: w(e2) * r2 * i2 + 0.5, y: -Math.sin(w(t2)) / r2 * i2 + 0.5, z: 0 };
          }
          unproject(e2, t2) {
            const { scale: i2, cosPhi: r2 } = this, n2 = -(t2 - 0.5) / i2, o2 = z(T((e2 - 0.5) / i2) / r2, -180, 180), s2 = Math.asin(z(n2 * r2, -1, 1)), a2 = z(T(s2), -Xd, Xd);
            return new Nd(o2, a2);
          }
        }
        class $g extends Ug {
          constructor(e2) {
            super(e2), this.requiresDraping = true, this.supportsWorldCopies = false, this.supportsFog = true, this.zAxisUnit = "pixels", this.unsupportedLayers = ["debug"], this.range = [3, 5];
          }
          projectTilePoint(e2, t2, i2) {
            const r2 = _d(e2, t2, i2), n2 = xd(ad(i2));
            return Mu.transformMat4(r2, r2, n2), { x: r2[0], y: r2[1], z: r2[2] };
          }
          locationPoint(e2, t2) {
            const i2 = md(t2.lat, t2.lng), r2 = Mu.normalize([], i2), n2 = e2.elevation ? e2.elevation.getAtPointOrZero(e2.locationCoordinate(t2), e2._centerAltitude) : e2._centerAltitude, o2 = Zd(1, 0) * sr * n2;
            Mu.scaleAndAdd(i2, i2, r2, o2);
            const s2 = xu.identity(new Float64Array(16));
            return xu.multiply(s2, e2.pixelMatrix, e2.globeMatrix), Mu.transformMat4(i2, i2, s2), new y(i2[0], i2[1]);
          }
          pixelsPerMeter(e2, t2) {
            return Zd(1, 0) * t2;
          }
          pixelSpaceConversion(e2, t2, i2) {
            const r2 = Zd(1, e2) * t2, n2 = Wr(Zd(1, 45) * t2, r2, i2);
            return this.pixelsPerMeter(e2, t2) / n2;
          }
          createTileMatrix(e2, t2, i2) {
            const r2 = vd(ad(i2.canonical));
            return xu.multiply(new Float64Array(16), e2.globeMatrix, r2);
          }
          createInversionMatrix(e2, t2) {
            const { center: i2 } = e2, r2 = xd(ad(t2));
            return xu.rotateY(r2, r2, w(i2.lng)), xu.rotateX(r2, r2, w(i2.lat)), xu.scale(r2, r2, [e2._pixelsPerMercatorPixel, e2._pixelsPerMercatorPixel, 1]), Float32Array.from(r2);
          }
          pointCoordinate(e2, t2, i2, r2) {
            return nd(e2, t2, i2, true) || new ep(0, 0);
          }
          pointCoordinate3D(e2, t2, i2) {
            const r2 = this.pointCoordinate(e2, t2, i2, 0);
            return [r2.x, r2.y, r2.z];
          }
          isPointAboveHorizon(e2, t2) {
            return !nd(e2, t2.x, t2.y, false);
          }
          farthestPixelDistance(e2) {
            const t2 = function(e3, t3) {
              const i3 = e3.cameraToCenterDistance, r2 = e3._centerAltitude * t3, n2 = e3._camera, o2 = e3._camera.forward(), s2 = Mu.add([], Mu.scale([], o2, -i3), [0, 0, r2]), a2 = e3.worldSize / (2 * Math.PI), l2 = [0, 0, -a2], c2 = e3.width / e3.height, h2 = Math.tan(e3.fovAboveCenter), u2 = Mu.scale([], n2.up(), h2), d2 = Mu.scale([], n2.right(), h2 * c2), p2 = Mu.normalize([], Mu.add([], Mu.add([], o2, u2), d2)), f2 = [];
              let m2;
              if (new Uu(s2, p2).closestPointOnSphere(l2, a2, f2)) {
                const t4 = Mu.add([], f2, l2), i4 = Mu.sub([], t4, s2);
                m2 = Math.cos(e3.fovAboveCenter) * Mu.length(i4);
              } else {
                const e4 = Mu.sub([], s2, l2), t4 = Mu.sub([], l2, s2);
                Mu.normalize(t4, t4);
                const i4 = Mu.length(e4) - a2;
                m2 = Math.sqrt(i4 * (i4 + 2 * a2));
                const r3 = Math.acos(m2 / (a2 + i4)) - Math.acos(Mu.dot(o2, t4));
                m2 *= Math.cos(r3);
              }
              return 1.01 * m2;
            }(e2, this.pixelsPerMeter(e2.center.lat, e2.worldSize)), i2 = Ed(e2.zoom);
            if (i2 > 0) {
              const r2 = wg(e2, Zd(1, e2.center.lat) * e2.worldSize), n2 = e2.worldSize / (2 * Math.PI), o2 = Math.max(e2.width, e2.height) / e2.worldSize * Math.PI;
              return Wr(t2, r2 + n2 * (1 - Math.cos(o2)), Math.pow(i2, 10));
            }
            return t2;
          }
          upVector(e2, t2, i2) {
            return _d(t2, i2, e2, 1);
          }
          upVectorScale(e2) {
            return { metersToTile: rd(gd(ad(e2))) };
          }
        }
        function Hg(e2) {
          const t2 = e2.parallels, i2 = !!t2 && Math.abs(t2[0] + t2[1]) < 0.01;
          switch (e2.name) {
            case "mercator":
              return new Ug(e2);
            case "equirectangular":
              return new Og(e2);
            case "naturalEarth":
              return new jg(e2);
            case "equalEarth":
              return new kg(e2);
            case "winkelTripel":
              return new qg(e2);
            case "albers":
              return i2 ? new Zg(e2) : new Cg(e2);
            case "lambertConformalConic":
              return i2 ? new Zg(e2) : new Ng(e2);
            case "globe":
              return new $g(e2);
          }
          throw new Error(`Invalid projection name: ${e2.name}`);
        }
        const Wg = new da({ "symbol-placement": new ca(Ct.layout_symbol["symbol-placement"]), "symbol-spacing": new ca(Ct.layout_symbol["symbol-spacing"]), "symbol-avoid-edges": new ca(Ct.layout_symbol["symbol-avoid-edges"]), "symbol-sort-key": new ha(Ct.layout_symbol["symbol-sort-key"]), "symbol-z-order": new ca(Ct.layout_symbol["symbol-z-order"]), "symbol-z-elevate": new ca(Ct.layout_symbol["symbol-z-elevate"]), "icon-allow-overlap": new ca(Ct.layout_symbol["icon-allow-overlap"]), "icon-ignore-placement": new ca(Ct.layout_symbol["icon-ignore-placement"]), "icon-optional": new ca(Ct.layout_symbol["icon-optional"]), "icon-rotation-alignment": new ca(Ct.layout_symbol["icon-rotation-alignment"]), "icon-size": new ha(Ct.layout_symbol["icon-size"]), "icon-text-fit": new ha(Ct.layout_symbol["icon-text-fit"]), "icon-text-fit-padding": new ha(Ct.layout_symbol["icon-text-fit-padding"]), "icon-image": new ha(Ct.layout_symbol["icon-image"]), "icon-rotate": new ha(Ct.layout_symbol["icon-rotate"]), "icon-padding": new ca(Ct.layout_symbol["icon-padding"]), "icon-keep-upright": new ca(Ct.layout_symbol["icon-keep-upright"]), "icon-offset": new ha(Ct.layout_symbol["icon-offset"]), "icon-anchor": new ha(Ct.layout_symbol["icon-anchor"]), "icon-pitch-alignment": new ca(Ct.layout_symbol["icon-pitch-alignment"]), "text-pitch-alignment": new ca(Ct.layout_symbol["text-pitch-alignment"]), "text-rotation-alignment": new ca(Ct.layout_symbol["text-rotation-alignment"]), "text-field": new ha(Ct.layout_symbol["text-field"]), "text-font": new ha(Ct.layout_symbol["text-font"]), "text-size": new ha(Ct.layout_symbol["text-size"]), "text-max-width": new ha(Ct.layout_symbol["text-max-width"]), "text-line-height": new ha(Ct.layout_symbol["text-line-height"]), "text-letter-spacing": new ha(Ct.layout_symbol["text-letter-spacing"]), "text-justify": new ha(Ct.layout_symbol["text-justify"]), "text-radial-offset": new ha(Ct.layout_symbol["text-radial-offset"]), "text-variable-anchor": new ca(Ct.layout_symbol["text-variable-anchor"]), "text-anchor": new ha(Ct.layout_symbol["text-anchor"]), "text-max-angle": new ca(Ct.layout_symbol["text-max-angle"]), "text-writing-mode": new ca(Ct.layout_symbol["text-writing-mode"]), "text-rotate": new ha(Ct.layout_symbol["text-rotate"]), "text-padding": new ca(Ct.layout_symbol["text-padding"]), "text-keep-upright": new ca(Ct.layout_symbol["text-keep-upright"]), "text-transform": new ha(Ct.layout_symbol["text-transform"]), "text-offset": new ha(Ct.layout_symbol["text-offset"]), "text-allow-overlap": new ca(Ct.layout_symbol["text-allow-overlap"]), "text-ignore-placement": new ca(Ct.layout_symbol["text-ignore-placement"]), "text-optional": new ca(Ct.layout_symbol["text-optional"]), visibility: new ca(Ct.layout_symbol.visibility) });
        var Xg = { paint: new da({ "icon-opacity": new ha(Ct.paint_symbol["icon-opacity"]), "icon-emissive-strength": new ha(Ct.paint_symbol["icon-emissive-strength"]), "text-emissive-strength": new ha(Ct.paint_symbol["text-emissive-strength"]), "icon-color": new ha(Ct.paint_symbol["icon-color"]), "icon-halo-color": new ha(Ct.paint_symbol["icon-halo-color"]), "icon-halo-width": new ha(Ct.paint_symbol["icon-halo-width"]), "icon-halo-blur": new ha(Ct.paint_symbol["icon-halo-blur"]), "icon-translate": new ca(Ct.paint_symbol["icon-translate"]), "icon-translate-anchor": new ca(Ct.paint_symbol["icon-translate-anchor"]), "icon-image-cross-fade": new ha(Ct.paint_symbol["icon-image-cross-fade"]), "text-opacity": new ha(Ct.paint_symbol["text-opacity"]), "text-color": new ha(Ct.paint_symbol["text-color"], { runtimeType: Gt, getOverride: (e2) => e2.textColor, hasOverride: (e2) => !!e2.textColor }), "text-halo-color": new ha(Ct.paint_symbol["text-halo-color"]), "text-halo-width": new ha(Ct.paint_symbol["text-halo-width"]), "text-halo-blur": new ha(Ct.paint_symbol["text-halo-blur"]), "text-translate": new ca(Ct.paint_symbol["text-translate"]), "text-translate-anchor": new ca(Ct.paint_symbol["text-translate-anchor"]) }), layout: Wg };
        class Yg {
          constructor(e2) {
            this.type = e2.property.overrides ? e2.property.overrides.runtimeType : Nt, this.defaultValue = e2;
          }
          evaluate(e2) {
            if (e2.formattedSection) {
              const t2 = this.defaultValue.property.overrides;
              if (t2 && t2.hasOverride(e2.formattedSection))
                return t2.getOverride(e2.formattedSection);
            }
            return e2.feature && e2.featureState ? this.defaultValue.evaluate(e2.feature, e2.featureState) : this.defaultValue.property.specification.default;
          }
          eachChild(e2) {
            this.defaultValue.isConstant() || e2(this.defaultValue.value._styleExpression.expression);
          }
          outputDefined() {
            return false;
          }
          serialize() {
            return null;
          }
        }
        Is(Yg, "FormatSectionOverride", { omit: ["defaultValue"] });
        class Kg extends _a {
          constructor(e2, t2) {
            super(e2, Xg, t2);
          }
          recalculate(e2, t2) {
            super.recalculate(e2, t2), "auto" === this.layout.get("icon-rotation-alignment") && (this.layout._values["icon-rotation-alignment"] = "point" !== this.layout.get("symbol-placement") ? "map" : "viewport"), "auto" === this.layout.get("text-rotation-alignment") && (this.layout._values["text-rotation-alignment"] = "point" !== this.layout.get("symbol-placement") ? "map" : "viewport"), "auto" === this.layout.get("text-pitch-alignment") && (this.layout._values["text-pitch-alignment"] = this.layout.get("text-rotation-alignment")), "auto" === this.layout.get("icon-pitch-alignment") && (this.layout._values["icon-pitch-alignment"] = this.layout.get("icon-rotation-alignment"));
            const i2 = this.layout.get("text-writing-mode");
            if (i2) {
              const e3 = [];
              for (const t3 of i2)
                e3.indexOf(t3) < 0 && e3.push(t3);
              this.layout._values["text-writing-mode"] = e3;
            } else
              this.layout._values["text-writing-mode"] = "point" === this.layout.get("symbol-placement") ? ["horizontal"] : ["horizontal", "vertical"];
            this._setPaintOverrides();
          }
          getValueAndResolveTokens(e2, t2, i2, r2) {
            const n2 = this.layout.get(e2).evaluate(t2, {}, i2, r2), o2 = this._unevaluatedLayout._values[e2];
            return o2.isDataDriven() || yo(o2.value) || !n2 ? n2 : function(e3, t3) {
              return t3.replace(/{([^{}]+)}/g, (t4, i3) => i3 in e3 ? String(e3[i3]) : "");
            }(t2.properties, n2);
          }
          createBucket(e2) {
            return new cy(e2);
          }
          queryRadius() {
            return 0;
          }
          queryIntersectsFeature() {
            return false;
          }
          _setPaintOverrides() {
            for (const e2 of Xg.paint.overridableProperties) {
              if (!Kg.hasPaintOverride(this.layout, e2))
                continue;
              const t2 = this.paint.get(e2), i2 = new Yg(t2), r2 = new go(i2, t2.property.specification);
              let n2 = null;
              n2 = "constant" === t2.value.kind || "source" === t2.value.kind ? new vo("source", r2) : new bo("composite", r2, t2.value.zoomStops, t2.value._interpolationType), this.paint._values[e2] = new aa(t2.property, n2, t2.parameters);
            }
          }
          _handleOverridablePaintPropertyUpdate(e2, t2, i2) {
            return !(!this.layout || t2.isDataDriven() || i2.isDataDriven()) && Kg.hasPaintOverride(this.layout, e2);
          }
          static hasPaintOverride(e2, t2) {
            const i2 = e2.get("text-field"), r2 = Xg.paint.properties[t2];
            let n2 = false;
            const o2 = (e3) => {
              for (const t3 of e3)
                if (r2.overrides && r2.overrides.hasOverride(t3))
                  return void (n2 = true);
            };
            if ("constant" === i2.value.kind && i2.value.value instanceof ui)
              o2(i2.value.value.sections);
            else if ("source" === i2.value.kind) {
              const e3 = (t4) => {
                n2 || (t4 instanceof yi && mi(t4.value) === Ht ? o2(t4.value.sections) : t4 instanceof Ti ? o2(t4.sections) : t4.eachChild(e3));
              }, t3 = i2.value;
              t3._styleExpression && e3(t3._styleExpression.expression);
            }
            return n2;
          }
          getProgramIds() {
            const e2 = 0 !== this.paint.get("icon-opacity").constantOr(1), t2 = 0 !== this.paint.get("text-opacity").constantOr(1), i2 = [];
            return e2 && i2.push("symbolIcon"), t2 && i2.push("symbolSDF"), i2;
          }
          getDefaultProgramParams(e2, t2) {
            return { config: new $l(this, t2), overrideFog: false };
          }
        }
        const Jg = im.types, Qg = [{ name: "a_fade_opacity", components: 1, type: "Uint8", offset: 0 }];
        function ey(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2) {
          const p2 = a2 ? Math.min(_g, Math.round(a2[0])) : 0, f2 = a2 ? Math.min(_g, Math.round(a2[1])) : 0;
          e2.emplaceBack(t2, i2, Math.round(32 * r2), Math.round(32 * n2), o2, s2, (p2 << 1) + (l2 ? 1 : 0), f2, 16 * c2, 16 * h2, 256 * u2, 256 * d2);
        }
        function ty(e2, t2, i2) {
          e2.emplaceBack(t2, i2);
        }
        function iy(e2, t2, i2, r2, n2, o2, s2) {
          e2.emplaceBack(t2, i2, r2, n2, o2, s2);
        }
        function ry(e2, t2, i2, r2, n2) {
          const o2 = 5 * t2 + 2;
          e2.float32[o2 + 0] = i2, e2.float32[o2 + 1] = r2, e2.float32[o2 + 2] = n2;
        }
        function ny(e2, t2, i2, r2, n2) {
          e2.emplaceBack(t2, i2, r2, n2), e2.emplaceBack(t2, i2, r2, n2), e2.emplaceBack(t2, i2, r2, n2), e2.emplaceBack(t2, i2, r2, n2);
        }
        function oy(e2) {
          for (const t2 of e2.sections)
            if (Vs(t2.text))
              return true;
          return false;
        }
        class sy {
          constructor(e2) {
            this.layoutVertexArray = new Pa(), this.indexArray = new Va(), this.programConfigurations = e2, this.segments = new dl(), this.dynamicLayoutVertexArray = new Ia(), this.opacityVertexArray = new La(), this.placedSymbolArray = new il(), this.iconTransitioningVertexArray = new ka(), this.globeExtVertexArray = new Ra(), this.zOffsetVertexArray = new qa();
          }
          isEmpty() {
            return 0 === this.layoutVertexArray.length && 0 === this.indexArray.length && 0 === this.dynamicLayoutVertexArray.length && 0 === this.opacityVertexArray.length && 0 === this.iconTransitioningVertexArray.length;
          }
          upload(e2, t2, i2, r2, n2) {
            this.isEmpty() || (i2 && (this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, Wm.members), this.indexBuffer = e2.createIndexBuffer(this.indexArray, t2), this.dynamicLayoutVertexBuffer = e2.createVertexBuffer(this.dynamicLayoutVertexArray, Ym.members, true), this.opacityVertexBuffer = e2.createVertexBuffer(this.opacityVertexArray, Qg, true), this.iconTransitioningVertexArray.length > 0 && (this.iconTransitioningVertexBuffer = e2.createVertexBuffer(this.iconTransitioningVertexArray, Jm.members, true)), this.globeExtVertexArray.length > 0 && (this.globeExtVertexBuffer = e2.createVertexBuffer(this.globeExtVertexArray, Xm.members, true)), !this.zOffsetVertexBuffer && (this.zOffsetVertexArray.length > 0 || n2) && (this.zOffsetVertexBuffer = e2.createVertexBuffer(this.zOffsetVertexArray, Km.members, true)), this.opacityVertexBuffer.itemSize = 1), (i2 || r2) && this.programConfigurations.upload(e2));
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.dynamicLayoutVertexBuffer.destroy(), this.opacityVertexBuffer.destroy(), this.iconTransitioningVertexBuffer && this.iconTransitioningVertexBuffer.destroy(), this.globeExtVertexBuffer && this.globeExtVertexBuffer.destroy(), this.zOffsetVertexBuffer && this.zOffsetVertexBuffer.destroy());
          }
        }
        Is(sy, "SymbolBuffers");
        class ay {
          constructor(e2, t2, i2) {
            this.layoutVertexArray = new e2(), this.layoutAttributes = t2, this.indexArray = new i2(), this.segments = new dl(), this.collisionVertexArray = new Na(), this.collisionVertexArrayExt = new Ua();
          }
          upload(e2) {
            this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, this.layoutAttributes), this.indexBuffer = e2.createIndexBuffer(this.indexArray), this.collisionVertexBuffer = e2.createVertexBuffer(this.collisionVertexArray, Qm.members, true), this.collisionVertexBufferExt = e2.createVertexBuffer(this.collisionVertexArrayExt, e_.members, true);
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.segments.destroy(), this.collisionVertexBuffer.destroy(), this.collisionVertexBufferExt.destroy());
          }
        }
        Is(ay, "CollisionBuffers");
        class ly {
          constructor(e2) {
            this.collisionBoxArray = e2.collisionBoxArray, this.zoom = e2.zoom, this.overscaling = e2.overscaling, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.index = e2.index, this.pixelRatio = e2.pixelRatio, this.sourceLayerIndex = e2.sourceLayerIndex, this.hasPattern = false, this.hasRTLText = false, this.fullyClipped = false, this.hasAnyIconTextFit = false, this.sortKeyRanges = [], this.collisionCircleArray = [], this.placementInvProjMatrix = xu.identity([]), this.placementViewportMatrix = xu.identity([]);
            const t2 = this.layers[0]._unevaluatedLayout._values;
            this.textSizeData = o_(this.zoom, t2["text-size"]), this.iconSizeData = o_(this.zoom, t2["icon-size"]);
            const i2 = this.layers[0].layout, r2 = i2.get("symbol-sort-key"), n2 = i2.get("symbol-z-order");
            this.canOverlap = i2.get("text-allow-overlap") || i2.get("icon-allow-overlap") || i2.get("text-ignore-placement") || i2.get("icon-ignore-placement"), this.sortFeaturesByKey = "viewport-y" !== n2 && void 0 !== r2.constantOr(1), this.sortFeaturesByY = ("viewport-y" === n2 || "auto" === n2 && !this.sortFeaturesByKey) && this.canOverlap, this.writingModes = i2.get("text-writing-mode").map((e3) => w_[e3]), this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id), this.sourceID = e2.sourceID, this.projection = e2.projection, this.hasAnyZOffset = false, this.zOffsetSortDirty = false, this.zOffsetBuffersNeedUpload = i2.get("symbol-z-elevate");
          }
          createArrays() {
            this.text = new sy(new Hl(this.layers, this.zoom, (e2) => /^text/.test(e2))), this.icon = new sy(new Hl(this.layers, this.zoom, (e2) => /^icon/.test(e2))), this.glyphOffsetArray = new ol(), this.lineVertexArray = new sl(), this.symbolInstances = new nl();
          }
          calculateGlyphDependencies(e2, t2, i2, r2, n2) {
            for (let i3 = 0; i3 < e2.length; i3++) {
              const o2 = e2.codePointAt(i3);
              if (void 0 === o2)
                break;
              if (t2[o2] = true, r2 && n2 && o2 <= 65535) {
                const r3 = h_[e2.charAt(i3)];
                r3 && (t2[r3.charCodeAt(0)] = true);
              }
            }
          }
          populate(e2, t2, i2, r2) {
            const n2 = this.layers[0], o2 = n2.layout, s2 = "globe" === this.projection.name, a2 = o2.get("text-font"), l2 = o2.get("text-field"), c2 = o2.get("icon-image"), h2 = ("constant" !== l2.value.kind || l2.value.value instanceof ui && !l2.value.value.isEmpty() || l2.value.value.toString().length > 0) && ("constant" !== a2.value.kind || a2.value.value.length > 0), u2 = "constant" !== c2.value.kind || !!c2.value.value || Object.keys(c2.parameters).length > 0, d2 = o2.get("symbol-sort-key");
            if (this.features = [], !h2 && !u2)
              return;
            const p2 = t2.iconDependencies, f2 = t2.glyphDependencies, m2 = t2.availableImages, _2 = new ea(this.zoom);
            for (const { feature: t3, id: l3, index: c3, sourceLayerIndex: g2 } of e2) {
              const e3 = n2._featureFilter.needGeometry, y2 = cp(t3, e3);
              if (!n2._featureFilter.filter(_2, y2, i2))
                continue;
              if (e3 || (y2.geometry = lp(t3, i2, r2)), s2 && 1 !== t3.type && i2.z <= 5) {
                const e4 = y2.geometry, t4 = 0.98078528056, r3 = (e5, r4) => {
                  const n3 = _d(e5.x, e5.y, i2, 1), o3 = _d(r4.x, r4.y, i2, 1);
                  return Mu.dot(n3, o3) < t4;
                };
                for (let t5 = 0; t5 < e4.length; t5++)
                  e4[t5] = np(e4[t5], r3);
              }
              let x2, v2;
              if (h2) {
                const e4 = n2.getValueAndResolveTokens("text-field", y2, i2, m2), t4 = ui.factory(e4);
                oy(t4) && (this.hasRTLText = true), (!this.hasRTLText || "unavailable" === Ks() || this.hasRTLText && Qs.isParsed()) && (x2 = c_(t4, n2, y2));
              }
              if (u2) {
                const e4 = n2.getValueAndResolveTokens("icon-image", y2, i2, m2);
                v2 = e4 instanceof di ? e4 : di.fromString(e4);
              }
              if (!x2 && !v2)
                continue;
              const b2 = this.sortFeaturesByKey ? d2.evaluate(y2, {}, i2) : void 0;
              if (this.features.push({ id: l3, text: x2, icon: v2, index: c3, sourceLayerIndex: g2, geometry: y2.geometry, properties: t3.properties, type: Jg[t3.type], sortKey: b2 }), v2 && (p2[v2.namePrimary] = true, v2.nameSecondary && (p2[v2.nameSecondary] = true)), x2) {
                const e4 = a2.evaluate(y2, {}, i2).join(","), t4 = "map" === o2.get("text-rotation-alignment") && "point" !== o2.get("symbol-placement");
                this.allowVerticalPlacement = this.writingModes && this.writingModes.indexOf(w_.vertical) >= 0;
                for (const i3 of x2.sections)
                  if (i3.image)
                    p2[i3.image.namePrimary] = true;
                  else {
                    const r3 = Ls(x2.toString()), n3 = i3.fontStack || e4, o3 = f2[n3] = f2[n3] || {};
                    this.calculateGlyphDependencies(i3.text, o3, t4, this.allowVerticalPlacement, r3);
                  }
              }
            }
            "line" === o2.get("symbol-placement") && (this.features = function(e3) {
              const t3 = {}, i3 = {}, r3 = [];
              let n3 = 0;
              function o3(t4) {
                r3.push(e3[t4]), n3++;
              }
              function s3(e4, t4, n4) {
                const o4 = i3[e4];
                return delete i3[e4], i3[t4] = o4, r3[o4].geometry[0].pop(), r3[o4].geometry[0] = r3[o4].geometry[0].concat(n4[0]), o4;
              }
              function a3(e4, i4, n4) {
                const o4 = t3[i4];
                return delete t3[i4], t3[e4] = o4, r3[o4].geometry[0].shift(), r3[o4].geometry[0] = n4[0].concat(r3[o4].geometry[0]), o4;
              }
              function l3(e4, t4, i4) {
                const r4 = i4 ? t4[0][t4[0].length - 1] : t4[0][0];
                return `${e4}:${r4.x}:${r4.y}`;
              }
              for (let c3 = 0; c3 < e3.length; c3++) {
                const h3 = e3[c3], u3 = h3.geometry, d3 = h3.text ? h3.text.toString() : null;
                if (!d3) {
                  o3(c3);
                  continue;
                }
                const p3 = l3(d3, u3), f3 = l3(d3, u3, true);
                if (p3 in i3 && f3 in t3 && i3[p3] !== t3[f3]) {
                  const e4 = a3(p3, f3, u3), n4 = s3(p3, f3, r3[e4].geometry);
                  delete t3[p3], delete i3[f3], i3[l3(d3, r3[n4].geometry, true)] = n4, r3[e4].geometry = null;
                } else
                  p3 in i3 ? s3(p3, f3, u3) : f3 in t3 ? a3(p3, f3, u3) : (o3(c3), t3[p3] = n3 - 1, i3[f3] = n3 - 1);
              }
              return r3.filter((e4) => e4.geometry);
            }(this.features)), this.sortFeaturesByKey && this.features.sort((e3, t3) => e3.sortKey - t3.sortKey);
          }
          update(e2, t2, i2, r2, n2) {
            const o2 = 0 !== Object.keys(e2).length;
            if (o2 && !this.stateDependentLayers.length)
              return;
            const s2 = o2 ? this.stateDependentLayers : this.layers;
            this.text.programConfigurations.updatePaintArrays(e2, t2, s2, i2, r2, n2), this.icon.programConfigurations.updatePaintArrays(e2, t2, s2, i2, r2, n2);
          }
          updateZOffset() {
            const e2 = (e3, t3, r3) => {
              i2 += t3, i2 > e3.length && e3.resize(i2);
              for (let n2 = -t3; n2 < 0; n2++)
                e3.emplace(n2 + i2, r3);
            }, t2 = (e3, t3, i3) => {
              r2 += t3, r2 > e3.length && e3.resize(r2);
              for (let n2 = -t3; n2 < 0; n2++)
                e3.emplace(n2 + r2, i3);
            };
            if (!this.zOffsetBuffersNeedUpload)
              return;
            this.zOffsetBuffersNeedUpload = false;
            let i2 = 0, r2 = 0;
            for (let i3 = 0; i3 < this.symbolInstances.length; i3++) {
              const r3 = this.symbolInstances.get(i3), { numHorizontalGlyphVertices: n2, numVerticalGlyphVertices: o2, numIconVertices: s2 } = r3, a2 = r3.zOffset, l2 = s2 > 0;
              if ((n2 > 0 || o2 > 0) && (e2(this.text.zOffsetVertexArray, n2, a2), e2(this.text.zOffsetVertexArray, o2, a2)), l2) {
                const { placedIconSymbolIndex: e3, verticalPlacedIconSymbolIndex: i4 } = r3;
                e3 >= 0 && t2(this.icon.zOffsetVertexArray, s2, a2), i4 >= 0 && t2(this.icon.zOffsetVertexArray, r3.numVerticalIconVertices, a2);
              }
            }
            this.text.zOffsetVertexBuffer && this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray), this.icon.zOffsetVertexBuffer && this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);
          }
          isEmpty() {
            return 0 === this.symbolInstances.length && !this.hasRTLText;
          }
          uploadPending() {
            return !this.uploaded || this.text.programConfigurations.needsUpload || this.icon.programConfigurations.needsUpload;
          }
          upload(e2) {
            !this.uploaded && this.hasDebugData() && (this.textCollisionBox.upload(e2), this.iconCollisionBox.upload(e2)), this.text.upload(e2, this.sortFeaturesByY, !this.uploaded, this.text.programConfigurations.needsUpload, this.zOffsetBuffersNeedUpload), this.icon.upload(e2, this.sortFeaturesByY, !this.uploaded, this.icon.programConfigurations.needsUpload, this.zOffsetBuffersNeedUpload), this.uploaded = true;
          }
          destroyDebugData() {
            this.textCollisionBox.destroy(), this.iconCollisionBox.destroy();
          }
          getProjection() {
            return this.projectionInstance || (this.projectionInstance = Hg(this.projection)), this.projectionInstance;
          }
          destroy() {
            this.text.destroy(), this.icon.destroy(), this.hasDebugData() && this.destroyDebugData();
          }
          addToLineVertexArray(e2, t2) {
            const i2 = this.lineVertexArray.length;
            if (void 0 !== e2.segment)
              for (const { x: e3, y: i3 } of t2)
                this.lineVertexArray.emplaceBack(e3, i3);
            return { lineStartIndex: i2, lineLength: this.lineVertexArray.length - i2 };
          }
          addSymbols(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2) {
            const _2 = e2.indexArray, g2 = e2.layoutVertexArray, y2 = e2.globeExtVertexArray, x2 = e2.segments.prepareSegment(4 * t2.length, g2, _2, this.canOverlap ? o2.sortKey : void 0), v2 = this.glyphOffsetArray.length, b2 = x2.vertexLength, w2 = this.allowVerticalPlacement && s2 === w_.vertical ? Math.PI / 2 : 0, T2 = o2.text && o2.text.sections;
            for (let r3 = 0; r3 < t2.length; r3++) {
              const { tl: n3, tr: s3, bl: c3, br: h3, texPrimary: u3, texSecondary: v3, pixelOffsetTL: b3, pixelOffsetBR: E3, minFontScaleX: M2, minFontScaleY: A2, glyphOffset: S2, isSDF: I2, sectionIndex: C2 } = t2[r3], z2 = x2.vertexLength, D2 = S2[1];
              if (ey(g2, l2.x, l2.y, n3.x, D2 + n3.y, u3.x, u3.y, i2, I2, b3.x, b3.y, M2, A2), ey(g2, l2.x, l2.y, s3.x, D2 + s3.y, u3.x + u3.w, u3.y, i2, I2, E3.x, b3.y, M2, A2), ey(g2, l2.x, l2.y, c3.x, D2 + c3.y, u3.x, u3.y + u3.h, i2, I2, b3.x, E3.y, M2, A2), ey(g2, l2.x, l2.y, h3.x, D2 + h3.y, u3.x + u3.w, u3.y + u3.h, i2, I2, E3.x, E3.y, M2, A2), a2) {
                const { x: t3, y: i3, z: r4 } = a2.anchor, [n4, o3, s4] = a2.up;
                iy(y2, t3, i3, r4, n4, o3, s4), iy(y2, t3, i3, r4, n4, o3, s4), iy(y2, t3, i3, r4, n4, o3, s4), iy(y2, t3, i3, r4, n4, o3, s4), ny(e2.dynamicLayoutVertexArray, t3, i3, r4, w2);
              } else
                ny(e2.dynamicLayoutVertexArray, l2.x, l2.y, l2.z, w2);
              if (m2) {
                const t3 = v3 || u3;
                ty(e2.iconTransitioningVertexArray, t3.x, t3.y), ty(e2.iconTransitioningVertexArray, t3.x + t3.w, t3.y), ty(e2.iconTransitioningVertexArray, t3.x, t3.y + t3.h), ty(e2.iconTransitioningVertexArray, t3.x + t3.w, t3.y + t3.h);
              }
              _2.emplaceBack(z2, z2 + 1, z2 + 2), _2.emplaceBack(z2 + 1, z2 + 2, z2 + 3), x2.vertexLength += 4, x2.primitiveLength += 2, this.glyphOffsetArray.emplaceBack(S2[0]), r3 !== t2.length - 1 && C2 === t2[r3 + 1].sectionIndex || e2.programConfigurations.populatePaintArrays(g2.length, o2, o2.index, {}, d2, p2, f2, T2 && T2[C2]);
            }
            const E2 = a2 ? a2.anchor : l2;
            e2.placedSymbolArray.emplaceBack(E2.x, E2.y, E2.z, l2.x, l2.y, v2, this.glyphOffsetArray.length - v2, b2, c2, h2, l2.segment, i2 ? i2[0] : 0, i2 ? i2[1] : 0, r2[0], r2[1], s2, 0, false, 0, u2, 0);
          }
          _commitLayoutVertex(e2, t2, i2, r2, n2, o2, s2) {
            e2.emplaceBack(t2, i2, r2, n2, o2, Math.round(s2.x), Math.round(s2.y));
          }
          _addCollisionDebugVertices(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = i2.segments.prepareSegment(4, i2.layoutVertexArray, i2.indexArray), l2 = a2.vertexLength, c2 = s2.tileAnchorX, h2 = s2.tileAnchorY;
            for (let e3 = 0; e3 < 4; e3++)
              i2.collisionVertexArray.emplaceBack(0, 0, 0, 0);
            i2.collisionVertexArrayExt.emplaceBack(t2, -e2.padding, -e2.padding), i2.collisionVertexArrayExt.emplaceBack(t2, e2.padding, -e2.padding), i2.collisionVertexArrayExt.emplaceBack(t2, e2.padding, e2.padding), i2.collisionVertexArrayExt.emplaceBack(t2, -e2.padding, e2.padding), this._commitLayoutVertex(i2.layoutVertexArray, r2, n2, o2, c2, h2, new y(e2.x1, e2.y1)), this._commitLayoutVertex(i2.layoutVertexArray, r2, n2, o2, c2, h2, new y(e2.x2, e2.y1)), this._commitLayoutVertex(i2.layoutVertexArray, r2, n2, o2, c2, h2, new y(e2.x2, e2.y2)), this._commitLayoutVertex(i2.layoutVertexArray, r2, n2, o2, c2, h2, new y(e2.x1, e2.y2)), a2.vertexLength += 4;
            const u2 = i2.indexArray;
            u2.emplaceBack(l2, l2 + 1), u2.emplaceBack(l2 + 1, l2 + 2), u2.emplaceBack(l2 + 2, l2 + 3), u2.emplaceBack(l2 + 3, l2), a2.primitiveLength += 4;
          }
          _addTextDebugCollisionBoxes(e2, t2, i2, r2, n2, o2) {
            for (let s2 = r2; s2 < n2; s2++) {
              const r3 = i2.get(s2), n3 = this.getSymbolInstanceTextSize(e2, o2, t2, s2);
              this._addCollisionDebugVertices(r3, n3, this.textCollisionBox, r3.projectedAnchorX, r3.projectedAnchorY, r3.projectedAnchorZ, o2);
            }
          }
          _addIconDebugCollisionBoxes(e2, t2, i2, r2, n2, o2) {
            for (let s2 = r2; s2 < n2; s2++) {
              const r3 = i2.get(s2), n3 = this.getSymbolInstanceIconSize(e2, t2, o2.placedIconSymbolIndex);
              this._addCollisionDebugVertices(r3, n3, this.iconCollisionBox, r3.projectedAnchorX, r3.projectedAnchorY, r3.projectedAnchorZ, o2);
            }
          }
          generateCollisionDebugBuffers(e2, t2) {
            this.hasDebugData() && this.destroyDebugData(), this.textCollisionBox = new ay(Ba, t_.members, ka), this.iconCollisionBox = new ay(Ba, t_.members, ka);
            const i2 = a_(this.iconSizeData, e2), r2 = a_(this.textSizeData, e2);
            for (let n2 = 0; n2 < this.symbolInstances.length; n2++) {
              const o2 = this.symbolInstances.get(n2);
              this._addTextDebugCollisionBoxes(r2, e2, t2, o2.textBoxStartIndex, o2.textBoxEndIndex, o2), this._addTextDebugCollisionBoxes(r2, e2, t2, o2.verticalTextBoxStartIndex, o2.verticalTextBoxEndIndex, o2), this._addIconDebugCollisionBoxes(i2, e2, t2, o2.iconBoxStartIndex, o2.iconBoxEndIndex, o2), this._addIconDebugCollisionBoxes(i2, e2, t2, o2.verticalIconBoxStartIndex, o2.verticalIconBoxEndIndex, o2);
            }
          }
          getSymbolInstanceTextSize(e2, t2, i2, r2) {
            const n2 = this.text.placedSymbolArray.get(t2.rightJustifiedTextSymbolIndex >= 0 ? t2.rightJustifiedTextSymbolIndex : t2.centerJustifiedTextSymbolIndex >= 0 ? t2.centerJustifiedTextSymbolIndex : t2.leftJustifiedTextSymbolIndex >= 0 ? t2.leftJustifiedTextSymbolIndex : t2.verticalPlacedTextSymbolIndex >= 0 ? t2.verticalPlacedTextSymbolIndex : r2), o2 = s_(this.textSizeData, e2, n2) / r_;
            return this.tilePixelRatio * o2;
          }
          getSymbolInstanceIconSize(e2, t2, i2) {
            const r2 = this.icon.placedSymbolArray.get(i2), n2 = s_(this.iconSizeData, e2, r2);
            return this.tilePixelRatio * n2;
          }
          _commitDebugCollisionVertexUpdate(e2, t2, i2) {
            e2.emplaceBack(t2, -i2, -i2), e2.emplaceBack(t2, i2, -i2), e2.emplaceBack(t2, i2, i2), e2.emplaceBack(t2, -i2, i2);
          }
          _updateTextDebugCollisionBoxes(e2, t2, i2, r2, n2, o2) {
            for (let s2 = r2; s2 < n2; s2++) {
              const r3 = i2.get(s2), n3 = this.getSymbolInstanceTextSize(e2, o2, t2, s2);
              this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt, n3, r3.padding);
            }
          }
          _updateIconDebugCollisionBoxes(e2, t2, i2, r2, n2, o2) {
            for (let s2 = r2; s2 < n2; s2++) {
              const r3 = i2.get(s2), n3 = this.getSymbolInstanceIconSize(e2, t2, o2);
              this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt, n3, r3.padding);
            }
          }
          updateCollisionDebugBuffers(e2, t2) {
            if (!this.hasDebugData())
              return;
            this.hasTextCollisionBoxData() && this.textCollisionBox.collisionVertexArrayExt.clear(), this.hasIconCollisionBoxData() && this.iconCollisionBox.collisionVertexArrayExt.clear();
            const i2 = a_(this.iconSizeData, e2), r2 = a_(this.textSizeData, e2);
            for (let n2 = 0; n2 < this.symbolInstances.length; n2++) {
              const o2 = this.symbolInstances.get(n2);
              this._updateTextDebugCollisionBoxes(r2, e2, t2, o2.textBoxStartIndex, o2.textBoxEndIndex, o2), this._updateTextDebugCollisionBoxes(r2, e2, t2, o2.verticalTextBoxStartIndex, o2.verticalTextBoxEndIndex, o2), this._updateIconDebugCollisionBoxes(i2, e2, t2, o2.iconBoxStartIndex, o2.iconBoxEndIndex, o2.placedIconSymbolIndex), this._updateIconDebugCollisionBoxes(i2, e2, t2, o2.verticalIconBoxStartIndex, o2.verticalIconBoxEndIndex, o2.placedIconSymbolIndex);
            }
            this.hasTextCollisionBoxData() && this.textCollisionBox.collisionVertexBufferExt && this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt), this.hasIconCollisionBoxData() && this.iconCollisionBox.collisionVertexBufferExt && this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);
          }
          _deserializeCollisionBoxesForSymbol(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
            const c2 = {};
            if (t2 < i2) {
              const { x1: i3, y1: r3, x2: n3, y2: o3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2, featureIndex: p2 } = e2.get(t2);
              c2.textBox = { x1: i3, y1: r3, x2: n3, y2: o3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2 }, c2.textFeatureIndex = p2;
            }
            if (r2 < n2) {
              const { x1: t3, y1: i3, x2: n3, y2: o3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2, featureIndex: p2 } = e2.get(r2);
              c2.verticalTextBox = { x1: t3, y1: i3, x2: n3, y2: o3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2 }, c2.verticalTextFeatureIndex = p2;
            }
            if (o2 < s2) {
              const { x1: t3, y1: i3, x2: r3, y2: n3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2, featureIndex: p2 } = e2.get(o2);
              c2.iconBox = { x1: t3, y1: i3, x2: r3, y2: n3, padding: s3, projectedAnchorX: a3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2 }, c2.iconFeatureIndex = p2;
            }
            if (a2 < l2) {
              const { x1: t3, y1: i3, x2: r3, y2: n3, padding: o3, projectedAnchorX: s3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2, featureIndex: p2 } = e2.get(a2);
              c2.verticalIconBox = { x1: t3, y1: i3, x2: r3, y2: n3, padding: o3, projectedAnchorX: s3, projectedAnchorY: l3, projectedAnchorZ: h2, tileAnchorX: u2, tileAnchorY: d2 }, c2.verticalIconFeatureIndex = p2;
            }
            return c2;
          }
          deserializeCollisionBoxes(e2) {
            this.collisionArrays = [];
            for (let t2 = 0; t2 < this.symbolInstances.length; t2++) {
              const i2 = this.symbolInstances.get(t2);
              this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e2, i2.textBoxStartIndex, i2.textBoxEndIndex, i2.verticalTextBoxStartIndex, i2.verticalTextBoxEndIndex, i2.iconBoxStartIndex, i2.iconBoxEndIndex, i2.verticalIconBoxStartIndex, i2.verticalIconBoxEndIndex));
            }
          }
          hasTextData() {
            return this.text.segments.get().length > 0;
          }
          hasIconData() {
            return this.icon.segments.get().length > 0;
          }
          hasDebugData() {
            return this.textCollisionBox && this.iconCollisionBox;
          }
          hasTextCollisionBoxData() {
            return this.hasDebugData() && this.textCollisionBox.segments.get().length > 0;
          }
          hasIconCollisionBoxData() {
            return this.hasDebugData() && this.iconCollisionBox.segments.get().length > 0;
          }
          hasIconTextFit() {
            return this.hasAnyIconTextFit;
          }
          addIndicesForPlacedSymbol(e2, t2) {
            const i2 = e2.placedSymbolArray.get(t2), r2 = i2.vertexStartIndex + 4 * i2.numGlyphs;
            for (let t3 = i2.vertexStartIndex; t3 < r2; t3 += 4)
              e2.indexArray.emplaceBack(t3, t3 + 1, t3 + 2), e2.indexArray.emplaceBack(t3 + 1, t3 + 2, t3 + 3);
          }
          getSortedSymbolIndexes(e2) {
            if (this.sortedAngle === e2 && void 0 !== this.symbolInstanceIndexes)
              return this.symbolInstanceIndexes;
            const t2 = Math.sin(e2), i2 = Math.cos(e2), r2 = [], n2 = [], o2 = [];
            for (let e3 = 0; e3 < this.symbolInstances.length; ++e3) {
              o2.push(e3);
              const s2 = this.symbolInstances.get(e3);
              r2.push(0 | Math.round(t2 * s2.tileAnchorX + i2 * s2.tileAnchorY)), n2.push(s2.featureIndex);
            }
            return o2.sort((e3, t3) => r2[e3] - r2[t3] || n2[t3] - n2[e3]), o2;
          }
          getSortedIndexesByZOffset() {
            if (!this.zOffsetSortDirty)
              return this.symbolInstanceIndexesSortedZOffset;
            if (!this.symbolInstanceIndexesSortedZOffset) {
              this.symbolInstanceIndexesSortedZOffset = [];
              for (let e2 = 0; e2 < this.symbolInstances.length; ++e2)
                this.symbolInstanceIndexesSortedZOffset.push(e2);
            }
            return this.zOffsetSortDirty = false, this.symbolInstanceIndexesSortedZOffset.sort((e2, t2) => this.symbolInstances.get(t2).zOffset - this.symbolInstances.get(e2).zOffset);
          }
          addToSortKeyRanges(e2, t2) {
            const i2 = this.sortKeyRanges[this.sortKeyRanges.length - 1];
            i2 && i2.sortKey === t2 ? i2.symbolInstanceEnd = e2 + 1 : this.sortKeyRanges.push({ sortKey: t2, symbolInstanceStart: e2, symbolInstanceEnd: e2 + 1 });
          }
          sortFeatures(e2) {
            if (this.sortFeaturesByY && this.sortedAngle !== e2 && !(this.text.segments.get().length > 1 || this.icon.segments.get().length > 1)) {
              this.symbolInstanceIndexes = this.getSortedSymbolIndexes(e2), this.sortedAngle = e2, this.text.indexArray.clear(), this.icon.indexArray.clear(), this.featureSortOrder = [];
              for (const e3 of this.symbolInstanceIndexes) {
                const t2 = this.symbolInstances.get(e3);
                this.featureSortOrder.push(t2.featureIndex);
                const { rightJustifiedTextSymbolIndex: i2, centerJustifiedTextSymbolIndex: r2, leftJustifiedTextSymbolIndex: n2, verticalPlacedTextSymbolIndex: o2, placedIconSymbolIndex: s2, verticalPlacedIconSymbolIndex: a2 } = t2;
                i2 >= 0 && this.addIndicesForPlacedSymbol(this.text, i2), r2 >= 0 && r2 !== i2 && this.addIndicesForPlacedSymbol(this.text, r2), n2 >= 0 && n2 !== r2 && n2 !== i2 && this.addIndicesForPlacedSymbol(this.text, n2), o2 >= 0 && this.addIndicesForPlacedSymbol(this.text, o2), s2 >= 0 && this.addIndicesForPlacedSymbol(this.icon, s2), a2 >= 0 && this.addIndicesForPlacedSymbol(this.icon, a2);
              }
              this.text.indexBuffer && this.text.indexBuffer.updateData(this.text.indexArray), this.icon.indexBuffer && this.icon.indexBuffer.updateData(this.icon.indexArray);
            }
          }
        }
        Is(ly, "SymbolBucket", { omit: ["layers", "collisionBoxArray", "features", "compareText"] }), ly.MAX_GLYPHS = 65535, ly.addDynamicAttributes = ny;
        var cy = ly;
        const hy = ba([{ name: "a_pos_normal", components: 2, type: "Int16" }, { name: "a_data", components: 4, type: "Uint8" }, { name: "a_linesofar", components: 1, type: "Float32" }], 4), { members: uy } = hy, dy = ba([{ name: "a_packed", components: 4, type: "Float32" }]), { members: py } = dy, fy = im.types, my = Math.cos(Math.PI / 180 * 37.5);
        class _y {
          constructor(e2) {
            this.zoom = e2.zoom, this.overscaling = e2.overscaling, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.index = e2.index, this.projection = e2.projection, this.hasPattern = false, this.patternFeatures = [], this.lineClipsArray = [], this.gradients = {}, this.layers.forEach((e3) => {
              this.gradients[e3.id] = {};
            }), this.layoutVertexArray = new Sa(), this.layoutVertexArray2 = new Ia(), this.indexArray = new Va(), this.programConfigurations = new Hl(e2.layers, e2.zoom), this.segments = new dl(), this.maxLineLength = 0, this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id);
          }
          populate(e2, t2, i2, r2) {
            this.hasPattern = Pf("line", this.layers, t2);
            const n2 = this.layers[0].layout.get("line-sort-key"), o2 = [];
            for (const { feature: t3, id: s3, index: a3, sourceLayerIndex: l3 } of e2) {
              const e3 = this.layers[0]._featureFilter.needGeometry, c2 = cp(t3, e3);
              if (!this.layers[0]._featureFilter.filter(new ea(this.zoom), c2, i2))
                continue;
              const h2 = n2 ? n2.evaluate(c2, {}, i2) : void 0, u2 = { id: s3, properties: t3.properties, type: t3.type, sourceLayerIndex: l3, index: a3, geometry: e3 ? c2.geometry : lp(t3, i2, r2), patterns: {}, sortKey: h2 };
              o2.push(u2);
            }
            n2 && o2.sort((e3, t3) => e3.sortKey - t3.sortKey);
            const { lineAtlas: s2, featureIndex: a2 } = t2, l2 = this.addConstantDashes(s2);
            for (const r3 of o2) {
              const { geometry: n3, index: o3, sourceLayerIndex: c2 } = r3;
              if (l2 && this.addFeatureDashes(r3, s2), this.hasPattern) {
                const e3 = Rf("line", this.layers, r3, this.zoom, t2);
                this.patternFeatures.push(e3);
              } else
                this.addFeature(r3, n3, o3, i2, s2.positions, t2.availableImages, t2.brightness);
              a2.insert(e2[o3].feature, n3, o3, c2, this.index);
            }
          }
          addConstantDashes(e2) {
            let t2 = false;
            for (const i2 of this.layers) {
              const r2 = i2.paint.get("line-dasharray").value, n2 = i2.layout.get("line-cap").value;
              if ("constant" !== r2.kind || "constant" !== n2.kind)
                t2 = true;
              else {
                const t3 = n2.value, i3 = r2.value;
                if (!i3)
                  continue;
                e2.addDash(i3, t3);
              }
            }
            return t2;
          }
          addFeatureDashes(e2, t2) {
            const i2 = this.zoom;
            for (const r2 of this.layers) {
              const n2 = r2.paint.get("line-dasharray").value, o2 = r2.layout.get("line-cap").value;
              if ("constant" === n2.kind && "constant" === o2.kind)
                continue;
              let s2, a2;
              if ("constant" === n2.kind) {
                if (s2 = n2.value, !s2)
                  continue;
              } else
                s2 = n2.evaluate({ zoom: i2 }, e2);
              a2 = "constant" === o2.kind ? o2.value : o2.evaluate({ zoom: i2 }, e2), t2.addDash(s2, a2), e2.patterns[r2.id] = t2.getKey(s2, a2);
            }
          }
          update(e2, t2, i2, r2, n2) {
            const o2 = 0 !== Object.keys(e2).length;
            o2 && !this.stateDependentLayers.length || this.programConfigurations.updatePaintArrays(e2, t2, o2 ? this.stateDependentLayers : this.layers, i2, r2, n2);
          }
          addFeatures(e2, t2, i2, r2, n2, o2) {
            for (const e3 of this.patternFeatures)
              this.addFeature(e3, e3.geometry, e3.index, t2, i2, r2, o2);
          }
          isEmpty() {
            return 0 === this.layoutVertexArray.length;
          }
          uploadPending() {
            return !this.uploaded || this.programConfigurations.needsUpload;
          }
          upload(e2) {
            this.uploaded || (0 !== this.layoutVertexArray2.length && (this.layoutVertexBuffer2 = e2.createVertexBuffer(this.layoutVertexArray2, py)), this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, uy), this.indexBuffer = e2.createIndexBuffer(this.indexArray)), this.programConfigurations.upload(e2), this.uploaded = true;
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy());
          }
          lineFeatureClips(e2) {
            if (e2.properties && e2.properties.hasOwnProperty("mapbox_clip_start") && e2.properties.hasOwnProperty("mapbox_clip_end"))
              return { start: +e2.properties.mapbox_clip_start, end: +e2.properties.mapbox_clip_end };
          }
          addFeature(e2, t2, i2, r2, n2, o2, s2) {
            const a2 = this.layers[0].layout, l2 = a2.get("line-join").evaluate(e2, {}), c2 = a2.get("line-cap").evaluate(e2, {}), h2 = a2.get("line-miter-limit"), u2 = a2.get("line-round-limit");
            this.lineClips = this.lineFeatureClips(e2);
            for (const i3 of t2)
              this.addLine(i3, e2, l2, c2, h2, u2);
            this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length, e2, i2, n2, o2, r2, s2);
          }
          addLine(e2, t2, i2, r2, n2, o2) {
            if (this.distance = 0, this.scaledDistance = 0, this.totalDistance = 0, this.lineSoFar = 0, this.lineClips) {
              this.lineClipsArray.push(this.lineClips);
              for (let t3 = 0; t3 < e2.length - 1; t3++)
                this.totalDistance += e2[t3].dist(e2[t3 + 1]);
              this.updateScaledDistance(), this.maxLineLength = Math.max(this.maxLineLength, this.totalDistance);
            }
            const s2 = "Polygon" === fy[t2.type];
            let a2 = e2.length;
            for (; a2 >= 2 && e2[a2 - 1].equals(e2[a2 - 2]); )
              a2--;
            let l2 = 0;
            for (; l2 < a2 - 1 && e2[l2].equals(e2[l2 + 1]); )
              l2++;
            if (a2 < (s2 ? 3 : 2))
              return;
            "bevel" === i2 && (n2 = 1.05);
            const c2 = this.overscaling <= 16 ? 15 * sr / (512 * this.overscaling) : 0, h2 = this.segments.prepareSegment(10 * a2, this.layoutVertexArray, this.indexArray);
            let u2, d2, p2, f2, m2;
            this.e1 = this.e2 = -1, s2 && (u2 = e2[a2 - 2], m2 = e2[l2].sub(u2)._unit()._perp());
            for (let t3 = l2; t3 < a2; t3++) {
              if (p2 = t3 === a2 - 1 ? s2 ? e2[l2 + 1] : void 0 : e2[t3 + 1], p2 && e2[t3].equals(p2))
                continue;
              m2 && (f2 = m2), u2 && (d2 = u2), u2 = e2[t3], m2 = p2 ? p2.sub(u2)._unit()._perp() : f2, f2 = f2 || m2;
              let _2 = f2.add(m2);
              0 === _2.x && 0 === _2.y || _2._unit();
              const g2 = f2.x * m2.x + f2.y * m2.y, y2 = _2.x * m2.x + _2.y * m2.y, x2 = 0 !== y2 ? 1 / y2 : 1 / 0, v2 = 2 * Math.sqrt(2 - 2 * y2), b2 = y2 < my && d2 && p2, w2 = f2.x * m2.y - f2.y * m2.x > 0;
              if (b2 && t3 > l2) {
                const e3 = u2.dist(d2);
                if (e3 > 2 * c2) {
                  const t4 = u2.sub(u2.sub(d2)._mult(c2 / e3)._round());
                  this.updateDistance(d2, t4), this.addCurrentVertex(t4, f2, 0, 0, h2), d2 = t4;
                }
              }
              const T2 = d2 && p2;
              let E2 = T2 ? i2 : s2 ? "butt" : r2;
              if (T2 && "round" === E2 && (x2 < o2 ? E2 = "miter" : x2 <= 2 && (E2 = "fakeround")), "miter" === E2 && x2 > n2 && (E2 = "bevel"), "bevel" === E2 && (x2 > 2 && (E2 = "flipbevel"), x2 < n2 && (E2 = "miter")), d2 && this.updateDistance(d2, u2), "miter" === E2)
                _2._mult(x2), this.addCurrentVertex(u2, _2, 0, 0, h2);
              else if ("flipbevel" === E2) {
                if (x2 > 100)
                  _2 = m2.mult(-1);
                else {
                  const e3 = x2 * f2.add(m2).mag() / f2.sub(m2).mag();
                  _2._perp()._mult(e3 * (w2 ? -1 : 1));
                }
                this.addCurrentVertex(u2, _2, 0, 0, h2), this.addCurrentVertex(u2, _2.mult(-1), 0, 0, h2);
              } else if ("bevel" === E2 || "fakeround" === E2) {
                const e3 = -Math.sqrt(x2 * x2 - 1), t4 = w2 ? e3 : 0, i3 = w2 ? 0 : e3;
                if (d2 && this.addCurrentVertex(u2, f2, t4, i3, h2), "fakeround" === E2) {
                  const e4 = Math.round(180 * v2 / Math.PI / 20);
                  for (let t5 = 1; t5 < e4; t5++) {
                    let i4 = t5 / e4;
                    if (0.5 !== i4) {
                      const e5 = i4 - 0.5;
                      i4 += i4 * e5 * (i4 - 1) * ((1.0904 + g2 * (g2 * (3.55645 - 1.43519 * g2) - 3.2452)) * e5 * e5 + (0.848013 + g2 * (0.215638 * g2 - 1.06021)));
                    }
                    const r3 = m2.sub(f2)._mult(i4)._add(f2)._unit()._mult(w2 ? -1 : 1);
                    this.addHalfVertex(u2, r3.x, r3.y, false, w2, 0, h2);
                  }
                }
                p2 && this.addCurrentVertex(u2, m2, -t4, -i3, h2);
              } else if ("butt" === E2)
                this.addCurrentVertex(u2, _2, 0, 0, h2);
              else if ("square" === E2) {
                const e3 = d2 ? 1 : -1;
                d2 || this.addCurrentVertex(u2, _2, e3, e3, h2), this.addCurrentVertex(u2, _2, 0, 0, h2), d2 && this.addCurrentVertex(u2, _2, e3, e3, h2);
              } else
                "round" === E2 && (d2 && (this.addCurrentVertex(u2, f2, 0, 0, h2), this.addCurrentVertex(u2, f2, 1, 1, h2, true)), p2 && (this.addCurrentVertex(u2, m2, -1, -1, h2, true), this.addCurrentVertex(u2, m2, 0, 0, h2)));
              if (b2 && t3 < a2 - 1) {
                const e3 = u2.dist(p2);
                if (e3 > 2 * c2) {
                  const t4 = u2.add(p2.sub(u2)._mult(c2 / e3)._round());
                  this.updateDistance(u2, t4), this.addCurrentVertex(t4, m2, 0, 0, h2), u2 = t4;
                }
              }
            }
          }
          addCurrentVertex(e2, t2, i2, r2, n2, o2 = false) {
            const s2 = t2.y * r2 - t2.x, a2 = -t2.y - t2.x * r2;
            this.addHalfVertex(e2, t2.x + t2.y * i2, t2.y - t2.x * i2, o2, false, i2, n2), this.addHalfVertex(e2, s2, a2, o2, true, -r2, n2);
          }
          addHalfVertex({ x: e2, y: t2 }, i2, r2, n2, o2, s2, a2) {
            this.layoutVertexArray.emplaceBack((e2 << 1) + (n2 ? 1 : 0), (t2 << 1) + (o2 ? 1 : 0), Math.round(63 * i2) + 128, Math.round(63 * r2) + 128, 1 + (0 === s2 ? 0 : s2 < 0 ? -1 : 1), 0, this.lineSoFar), this.lineClips && this.layoutVertexArray2.emplaceBack(this.scaledDistance, this.lineClipsArray.length, this.lineClips.start, this.lineClips.end);
            const l2 = a2.vertexLength++;
            this.e1 >= 0 && this.e2 >= 0 && (this.indexArray.emplaceBack(this.e1, this.e2, l2), a2.primitiveLength++), o2 ? this.e2 = l2 : this.e1 = l2;
          }
          updateScaledDistance() {
            if (this.lineClips) {
              const e2 = this.totalDistance / (this.lineClips.end - this.lineClips.start);
              this.scaledDistance = this.distance / this.totalDistance, this.lineSoFar = e2 * this.lineClips.start + this.distance;
            } else
              this.lineSoFar = this.distance;
          }
          updateDistance(e2, t2) {
            this.distance += e2.dist(t2), this.updateScaledDistance();
          }
        }
        Is(_y, "LineBucket", { omit: ["layers", "patternFeatures"] });
        class gy {
          constructor(e2, t2, i2, r2) {
            this.context = e2, this.format = i2, this.texture = e2.gl.createTexture(), this.update(t2, r2);
          }
          update(e2, i2, r2) {
            const { width: n2, height: o2 } = e2, { context: s2 } = this, { gl: a2 } = s2, { HTMLImageElement: l2, HTMLCanvasElement: c2, HTMLVideoElement: h2, ImageData: u2, ImageBitmap: d2 } = t;
            if (a2.bindTexture(a2.TEXTURE_2D, this.texture), s2.pixelStoreUnpackFlipY.set(false), s2.pixelStoreUnpack.set(1), s2.pixelStoreUnpackPremultiplyAlpha.set(this.format === a2.RGBA && (!i2 || false !== i2.premultiply)), r2 || this.size && this.size[0] === n2 && this.size[1] === o2) {
              const { x: t2, y: i3 } = r2 || { x: 0, y: 0 };
              if (e2 instanceof l2 || e2 instanceof c2 || e2 instanceof h2 || e2 instanceof u2 || d2 && e2 instanceof d2)
                a2.texSubImage2D(a2.TEXTURE_2D, 0, t2, i3, a2.RGBA, a2.UNSIGNED_BYTE, e2);
              else {
                let r3 = this.format, s3 = a2.UNSIGNED_BYTE;
                this.format === a2.R32F && (r3 = a2.RED, s3 = a2.FLOAT), a2.texSubImage2D(a2.TEXTURE_2D, 0, t2, i3, n2, o2, r3, s3, e2.data);
              }
            } else if (this.size = [n2, o2], e2 instanceof l2 || e2 instanceof c2 || e2 instanceof h2 || e2 instanceof u2 || d2 && e2 instanceof d2) {
              let t2 = this.format;
              this.format === a2.R8 && (t2 = a2.RED), a2.texImage2D(a2.TEXTURE_2D, 0, this.format, t2, a2.UNSIGNED_BYTE, e2);
            } else {
              let t2 = this.format, i3 = this.format, r3 = a2.UNSIGNED_BYTE;
              this.format === a2.DEPTH_COMPONENT && (t2 = a2.DEPTH_COMPONENT16, r3 = a2.UNSIGNED_SHORT), this.format === a2.R32F && (r3 = a2.FLOAT, i3 = a2.RED), a2.texImage2D(a2.TEXTURE_2D, 0, t2, n2, o2, 0, i3, r3, e2.data);
            }
            this.useMipmap = Boolean(i2 && i2.useMipmap), this.useMipmap && a2.generateMipmap(a2.TEXTURE_2D);
          }
          bind(e2, t2) {
            const { context: i2 } = this, { gl: r2 } = i2;
            r2.bindTexture(r2.TEXTURE_2D, this.texture), e2 !== this.minFilter && (r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_MAG_FILTER, e2), r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_MIN_FILTER, this.useMipmap ? e2 === r2.NEAREST ? r2.NEAREST_MIPMAP_NEAREST : r2.LINEAR_MIPMAP_NEAREST : e2), this.minFilter = e2), t2 !== this.wrapS && (r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_WRAP_S, t2), r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_WRAP_T, t2), this.wrapS = t2);
          }
          bindExtraParam(e2, t2, i2, r2) {
            const { context: n2 } = this, { gl: o2 } = n2;
            o2.bindTexture(o2.TEXTURE_2D, this.texture), t2 !== this.magFilter && (o2.texParameteri(o2.TEXTURE_2D, o2.TEXTURE_MAG_FILTER, t2), this.magFilter = t2), e2 !== this.minFilter && (o2.texParameteri(o2.TEXTURE_2D, o2.TEXTURE_MIN_FILTER, this.useMipmap ? e2 === o2.NEAREST ? o2.NEAREST_MIPMAP_NEAREST : o2.LINEAR_MIPMAP_NEAREST : e2), this.minFilter = e2), i2 !== this.wrapS && (o2.texParameteri(o2.TEXTURE_2D, o2.TEXTURE_WRAP_S, i2), this.wrapS = i2), r2 !== this.wrapT && (o2.texParameteri(o2.TEXTURE_2D, o2.TEXTURE_WRAP_T, r2), this.wrapT = r2);
          }
          destroy() {
            const { gl: e2 } = this.context;
            e2.deleteTexture(this.texture), this.texture = null;
          }
        }
        class yy {
          constructor(e2, t2) {
            this.context = e2, this.texture = t2;
          }
          bind(e2, t2) {
            const { context: i2 } = this, { gl: r2 } = i2;
            r2.bindTexture(r2.TEXTURE_2D, this.texture), e2 !== this.minFilter && (r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_MAG_FILTER, e2), r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_MIN_FILTER, e2), this.minFilter = e2), t2 !== this.wrapS && (r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_WRAP_S, t2), r2.texParameteri(r2.TEXTURE_2D, r2.TEXTURE_WRAP_T, t2), this.wrapS = t2);
          }
        }
        const xy = 32, vy = 33, by = new Uint16Array(8184);
        for (let e2 = 0; e2 < 2046; e2++) {
          let t2 = e2 + 2, i2 = 0, r2 = 0, n2 = 0, o2 = 0, s2 = 0, a2 = 0;
          for (1 & t2 ? n2 = o2 = s2 = xy : i2 = r2 = a2 = xy; (t2 >>= 1) > 1; ) {
            const e3 = i2 + n2 >> 1, l3 = r2 + o2 >> 1;
            1 & t2 ? (n2 = i2, o2 = r2, i2 = s2, r2 = a2) : (i2 = n2, r2 = o2, n2 = s2, o2 = a2), s2 = e3, a2 = l3;
          }
          const l2 = 4 * e2;
          by[l2 + 0] = i2, by[l2 + 1] = r2, by[l2 + 2] = n2, by[l2 + 3] = o2;
        }
        const wy = new Uint16Array(2178), Ty = new Uint8Array(1089), Ey = new Uint16Array(1089);
        function My(e2) {
          return 0 === e2 ? -0.03125 : 32 === e2 ? 0.03125 : 0;
        }
        var Ay = ba([{ name: "a_pos", type: "Int16", components: 2 }, { name: "a_texture_pos", type: "Int16", components: 2 }]);
        const Sy = { type: 2, extent: sr, loadGeometry: () => [[new y(0, 0), new y(sr + 1, 0), new y(sr + 1, sr + 1), new y(0, sr + 1), new y(0, 0)]] };
        class Iy {
          constructor(e2, t2, i2, r2, n2) {
            this.tileID = e2, this.uid = F(), this.uses = 0, this.tileSize = t2, this.tileZoom = i2, this.buckets = {}, this.expirationTime = null, this.queryPadding = 0, this.hasSymbolBuckets = false, this.hasRTLText = false, this.dependencies = {}, this.isRaster = n2, r2 && r2.style && (this._lastUpdatedBrightness = r2.style.getBrightness()), this.expiredRequestCount = 0, this.state = "loading", r2 && r2.transform && (this.projection = r2.transform.projection);
          }
          registerFadeDuration(e2) {
            const t2 = e2 + this.timeAdded;
            t2 < ht.now() || this.fadeEndTime && t2 < this.fadeEndTime || (this.fadeEndTime = t2);
          }
          wasRequested() {
            return "errored" === this.state || "loaded" === this.state || "reloading" === this.state;
          }
          get tileTransform() {
            return this._tileTransform || (this._tileTransform = Tg(this.tileID.canonical, this.projection)), this._tileTransform;
          }
          loadVectorData(e2, t2, i2) {
            if (this.unloadVectorData(), this.state = "loaded", e2) {
              e2.featureIndex && (this.latestFeatureIndex = e2.featureIndex, e2.rawTileData ? (this.latestRawTileData = e2.rawTileData, this.latestFeatureIndex.rawTileData = e2.rawTileData) : this.latestRawTileData && (this.latestFeatureIndex.rawTileData = this.latestRawTileData)), this.collisionBoxArray = e2.collisionBoxArray, this.buckets = function(e3, t3) {
                const i3 = {};
                if (!t3)
                  return i3;
                for (const r2 of e3) {
                  const e4 = r2.layerIds.map((e5) => t3.getLayer(e5)).filter(Boolean);
                  if (0 !== e4.length) {
                    r2.layers = e4, r2.stateDependentLayerIds && (r2.stateDependentLayers = r2.stateDependentLayerIds.map((t4) => e4.filter((e5) => e5.id === t4)[0]));
                    for (const t4 of e4)
                      i3[t4.fqid] = r2;
                  }
                }
                return i3;
              }(e2.buckets, t2.style), this.hasSymbolBuckets = false;
              for (const e3 in this.buckets) {
                const t3 = this.buckets[e3];
                if (t3 instanceof cy) {
                  if (this.hasSymbolBuckets = true, !i2)
                    break;
                  t3.justReloaded = true;
                }
              }
              if (this.hasRTLText = false, this.hasSymbolBuckets)
                for (const e3 in this.buckets) {
                  const t3 = this.buckets[e3];
                  if (t3 instanceof cy && t3.hasRTLText) {
                    this.hasRTLText = true, Qs.isLoading() || Qs.isLoaded() || "deferred" !== Ks() || Js();
                    break;
                  }
                }
              this.queryPadding = 0;
              for (const e3 in this.buckets) {
                const i3 = this.buckets[e3], r2 = t2.style.getOwnLayer(e3);
                if (!r2)
                  continue;
                const n2 = r2.queryRadius(i3);
                this.queryPadding = Math.max(this.queryPadding, n2);
              }
              e2.imageAtlas && (this.imageAtlas = e2.imageAtlas), e2.glyphAtlasImage && (this.glyphAtlasImage = e2.glyphAtlasImage), e2.lineAtlas && (this.lineAtlas = e2.lineAtlas), this._lastUpdatedBrightness = e2.brightness;
            } else
              this.collisionBoxArray = new el();
          }
          unloadVectorData() {
            if (this.hasData()) {
              for (const e2 in this.buckets)
                this.buckets[e2].destroy();
              this.buckets = {}, this.imageAtlas && (this.imageAtlas = null), this.lineAtlas && (this.lineAtlas = null), this.imageAtlasTexture && this.imageAtlasTexture.destroy(), this.glyphAtlasTexture && this.glyphAtlasTexture.destroy(), this.lineAtlasTexture && this.lineAtlasTexture.destroy(), this._tileBoundsBuffer && (this._tileBoundsBuffer.destroy(), this._tileBoundsIndexBuffer.destroy(), this._tileBoundsSegments.destroy(), this._tileBoundsBuffer = null), this._tileDebugBuffer && (this._tileDebugBuffer.destroy(), this._tileDebugSegments.destroy(), this._tileDebugBuffer = null), this._tileDebugIndexBuffer && (this._tileDebugIndexBuffer.destroy(), this._tileDebugIndexBuffer = null), this._globeTileDebugBorderBuffer && (this._globeTileDebugBorderBuffer.destroy(), this._globeTileDebugBorderBuffer = null), this._tileDebugTextBuffer && (this._tileDebugTextBuffer.destroy(), this._tileDebugTextSegments.destroy(), this._tileDebugTextIndexBuffer.destroy(), this._tileDebugTextBuffer = null), this._globeTileDebugTextBuffer && (this._globeTileDebugTextBuffer.destroy(), this._globeTileDebugTextBuffer = null), this.latestFeatureIndex = null, this.state = "unloaded";
            }
          }
          getBucket(e2) {
            return this.buckets[e2.fqid];
          }
          upload(e2) {
            for (const t3 in this.buckets) {
              const i2 = this.buckets[t3];
              i2.uploadPending() && i2.upload(e2);
            }
            const t2 = e2.gl;
            this.imageAtlas && !this.imageAtlas.uploaded && (this.imageAtlasTexture = new gy(e2, this.imageAtlas.image, t2.RGBA), this.imageAtlas.uploaded = true), this.glyphAtlasImage && (this.glyphAtlasTexture = new gy(e2, this.glyphAtlasImage, t2.ALPHA), this.glyphAtlasImage = null), this.lineAtlas && !this.lineAtlas.uploaded && (this.lineAtlasTexture = new gy(e2, this.lineAtlas.image, t2.ALPHA), this.lineAtlas.uploaded = true);
          }
          prepare(e2, t2, i2) {
            if (this.imageAtlas && this.imageAtlas.patchUpdatedImages(e2, this.imageAtlasTexture, i2), !t2 || !this.latestFeatureIndex || !this.latestFeatureIndex.rawTileData)
              return;
            const r2 = t2.style.getBrightness();
            (this._lastUpdatedBrightness || r2) && (this._lastUpdatedBrightness && r2 && Math.abs(this._lastUpdatedBrightness - r2) < 1e-3 || (this._lastUpdatedBrightness = r2, this.updateBuckets(void 0, t2)));
          }
          queryRenderedFeatures(e2, t2, i2, r2, n2, o2, s2, a2) {
            return this.latestFeatureIndex && this.latestFeatureIndex.rawTileData ? this.latestFeatureIndex.query({ tileResult: r2, pixelPosMatrix: s2, transform: o2, params: n2, tileTransform: this.tileTransform }, e2, t2, i2) : {};
          }
          querySourceFeatures(e2, t2) {
            const i2 = this.latestFeatureIndex;
            if (!i2 || !i2.rawTileData)
              return;
            const r2 = i2.loadVTLayers(), n2 = t2 ? t2.sourceLayer : "", o2 = r2._geojsonTileLayer || r2[n2];
            if (!o2)
              return;
            const s2 = Ro(t2 && t2.filter), { z: a2, x: l2, y: c2 } = this.tileID.canonical, h2 = { z: a2, x: l2, y: c2 };
            for (let t3 = 0; t3 < o2.length; t3++) {
              const r3 = o2.feature(t3);
              if (s2.needGeometry) {
                const e3 = cp(r3, true);
                if (!s2.filter(new ea(this.tileID.overscaledZ), e3, this.tileID.canonical))
                  continue;
              } else if (!s2.filter(new ea(this.tileID.overscaledZ), r3))
                continue;
              const u2 = i2.getId(r3, n2), d2 = new Cm(r3, a2, l2, c2, u2);
              d2.tile = h2, e2.push(d2);
            }
          }
          hasData() {
            return "loaded" === this.state || "reloading" === this.state || "expired" === this.state;
          }
          bucketsLoaded() {
            for (const e2 in this.buckets)
              if (this.buckets[e2].uploadPending())
                return false;
            return true;
          }
          patternsLoaded() {
            return !!this.imageAtlas && !!Object.keys(this.imageAtlas.patternPositions).length;
          }
          setExpiryData(e2) {
            const t2 = this.expirationTime;
            if (e2.cacheControl) {
              const t3 = ee(e2.cacheControl);
              t3["max-age"] && (this.expirationTime = Date.now() + 1e3 * t3["max-age"]);
            } else
              e2.expires && (this.expirationTime = new Date(e2.expires).getTime());
            if (this.expirationTime) {
              const e3 = Date.now();
              let i2 = false;
              if (this.expirationTime > e3)
                i2 = false;
              else if (t2)
                if (this.expirationTime < t2)
                  i2 = true;
                else {
                  const r2 = this.expirationTime - t2;
                  r2 ? this.expirationTime = e3 + Math.max(r2, 3e4) : i2 = true;
                }
              else
                i2 = true;
              i2 ? (this.expiredRequestCount++, this.state = "expired") : this.expiredRequestCount = 0;
            }
          }
          getExpiryTimeout() {
            if (this.expirationTime)
              return this.expiredRequestCount ? 1e3 * (1 << Math.min(this.expiredRequestCount - 1, 31)) : Math.min(this.expirationTime - (/* @__PURE__ */ new Date()).getTime(), Math.pow(2, 31) - 1);
          }
          setFeatureState(e2, t2) {
            this.latestFeatureIndex && this.latestFeatureIndex.rawTileData && 0 !== Object.keys(e2).length && t2 && this.updateBuckets(e2, t2);
          }
          updateBuckets(e2, t2) {
            if (!this.latestFeatureIndex)
              return;
            const i2 = this.latestFeatureIndex.loadVTLayers(), r2 = t2.style.listImages(), n2 = t2.style.getBrightness();
            for (const o2 in this.buckets) {
              if (!t2.style.hasLayer(o2))
                continue;
              const s2 = this.buckets[o2], a2 = s2.layers[0].sourceLayer || "_geojsonTileLayer", l2 = i2[a2];
              let c2 = {};
              if (e2 && (c2 = e2[a2], !l2 || !c2 || 0 === Object.keys(c2).length))
                continue;
              if (s2.update(c2, l2, r2, this.imageAtlas && this.imageAtlas.patternPositions || {}, n2), s2 instanceof _y || s2 instanceof Lf) {
                const e3 = t2.style.getOwnSourceCache(s2.layers[0].source);
                t2._terrain && t2._terrain.enabled && e3 && s2.programConfigurations.needsUpload && t2._terrain._clearRenderCacheForTile(e3.id, this.tileID);
              }
              const h2 = t2 && t2.style && t2.style.getOwnLayer(o2);
              h2 && (this.queryPadding = Math.max(this.queryPadding, h2.queryRadius(s2)));
            }
          }
          holdingForFade() {
            return void 0 !== this.symbolFadeHoldUntil;
          }
          symbolFadeFinished() {
            return !this.symbolFadeHoldUntil || this.symbolFadeHoldUntil < ht.now();
          }
          clearFadeHold() {
            this.symbolFadeHoldUntil = void 0;
          }
          setHoldDuration(e2) {
            this.symbolFadeHoldUntil = ht.now() + e2;
          }
          setTexture(e2, t2) {
            const i2 = t2.context, r2 = i2.gl;
            this.texture = this.texture || t2.getTileTexture(e2.width), this.texture ? this.texture.update(e2, { useMipmap: true }) : (this.texture = new gy(i2, e2, r2.RGBA, { useMipmap: true }), this.texture.bind(r2.LINEAR, r2.CLAMP_TO_EDGE));
          }
          setDependencies(e2, t2) {
            const i2 = {};
            for (const e3 of t2)
              i2[e3] = true;
            this.dependencies[e2] = i2;
          }
          hasDependency(e2, t2) {
            for (const i2 of e2) {
              const e3 = this.dependencies[i2];
              if (e3) {
                for (const i3 of t2)
                  if (e3[i3])
                    return true;
              }
            }
            return false;
          }
          clearQueryDebugViz() {
          }
          _makeDebugTileBoundsBuffers(e2, t2) {
            if (!t2 || "mercator" === t2.name || this._tileDebugBuffer)
              return;
            const i2 = lp(Sy, this.tileID.canonical, this.tileTransform)[0], r2 = new Ta(), n2 = new Wa();
            for (let e3 = 0; e3 < i2.length; e3++) {
              const { x: t3, y: o2 } = i2[e3];
              r2.emplaceBack(t3, o2), n2.emplaceBack(e3);
            }
            n2.emplaceBack(0), this._tileDebugIndexBuffer = e2.createIndexBuffer(n2), this._tileDebugBuffer = e2.createVertexBuffer(r2, Pu.members), this._tileDebugSegments = dl.simpleSegment(0, 0, r2.length, n2.length);
          }
          _makeTileBoundsBuffers(e2, t2) {
            if (this._tileBoundsBuffer || !t2 || "mercator" === t2.name)
              return;
            const i2 = lp(Sy, this.tileID.canonical, this.tileTransform)[0];
            let r2, n2;
            if (this.isRaster) {
              const e3 = function(e4, t3) {
                const i3 = Tg(e4, t3), r3 = Math.pow(2, e4.z);
                for (let n4 = 0; n4 < vy; n4++)
                  for (let o3 = 0; o3 < vy; o3++) {
                    const s3 = $d((e4.x + (o3 + My(o3)) / xy) / r3), a3 = Hd((e4.y + (n4 + My(n4)) / xy) / r3), l3 = t3.project(s3, a3), c2 = n4 * vy + o3;
                    wy[2 * c2 + 0] = Math.round((l3.x * i3.scale - i3.x) * sr), wy[2 * c2 + 1] = Math.round((l3.y * i3.scale - i3.y) * sr);
                  }
                Ty.fill(0), Ey.fill(0);
                for (let e5 = 2045; e5 >= 0; e5--) {
                  const t4 = 4 * e5, i4 = by[t4 + 0], r4 = by[t4 + 1], n4 = by[t4 + 2], o3 = by[t4 + 3], s3 = i4 + n4 >> 1, a3 = r4 + o3 >> 1, l3 = s3 + a3 - r4, c2 = a3 + i4 - s3, h2 = r4 * vy + i4, u2 = o3 * vy + n4, d2 = a3 * vy + s3, p2 = Math.hypot((wy[2 * h2 + 0] + wy[2 * u2 + 0]) / 2 - wy[2 * d2 + 0], (wy[2 * h2 + 1] + wy[2 * u2 + 1]) / 2 - wy[2 * d2 + 1]) >= 16;
                  Ty[d2] = Ty[d2] || (p2 ? 1 : 0), e5 < 1022 && (Ty[d2] = Ty[d2] || Ty[(r4 + c2 >> 1) * vy + (i4 + l3 >> 1)] || Ty[(o3 + c2 >> 1) * vy + (n4 + l3 >> 1)]);
                }
                const n3 = new Ma(), o2 = new Va();
                let s2 = 0;
                function a2(e5, t4) {
                  const i4 = t4 * vy + e5;
                  return 0 === Ey[i4] && (n3.emplaceBack(wy[2 * i4 + 0], wy[2 * i4 + 1], e5 * sr / xy, t4 * sr / xy), Ey[i4] = ++s2), Ey[i4] - 1;
                }
                function l2(e5, t4, i4, r4, n4, s3) {
                  const c2 = e5 + i4 >> 1, h2 = t4 + r4 >> 1;
                  if (Math.abs(e5 - n4) + Math.abs(t4 - s3) > 1 && Ty[h2 * vy + c2])
                    l2(n4, s3, e5, t4, c2, h2), l2(i4, r4, n4, s3, c2, h2);
                  else {
                    const l3 = a2(e5, t4), c3 = a2(i4, r4), h3 = a2(n4, s3);
                    o2.emplaceBack(l3, c3, h3);
                  }
                }
                return l2(0, 0, xy, xy, xy, 0), l2(xy, xy, 0, 0, 0, xy), { vertices: n3, indices: o2 };
              }(this.tileID.canonical, t2);
              r2 = e3.vertices, n2 = e3.indices;
            } else {
              r2 = new Ma(), n2 = new Va();
              for (const { x: e4, y: t3 } of i2)
                r2.emplaceBack(e4, t3, 0, 0);
              const e3 = Cf(r2.int16, void 0, 4);
              for (let t3 = 0; t3 < e3.length; t3 += 3)
                n2.emplaceBack(e3[t3], e3[t3 + 1], e3[t3 + 2]);
            }
            this._tileBoundsBuffer = e2.createVertexBuffer(r2, Ay.members), this._tileBoundsIndexBuffer = e2.createIndexBuffer(n2), this._tileBoundsSegments = dl.simpleSegment(0, 0, r2.length, n2.length);
          }
          _makeGlobeTileDebugBuffers(e2, t2) {
            const i2 = t2.projection;
            if (!i2 || "globe" !== i2.name || t2.freezeTileCoverage)
              return;
            const r2 = this.tileID.canonical, n2 = xd(cd(r2, t2)), o2 = Ed(t2.zoom);
            let s2;
            o2 > 0 && (s2 = xu.invert(new Float64Array(16), t2.globeMatrix)), this._makeGlobeTileDebugBorderBuffer(e2, r2, t2, n2, s2, o2), this._makeGlobeTileDebugTextBuffer(e2, r2, t2, n2, s2, o2);
          }
          _globePoint(e2, t2, i2, r2, n2, o2, s2) {
            let a2 = _d(e2, t2, i2);
            if (o2) {
              const n3 = 1 << i2.z, l2 = Gd(r2.center.lng), c2 = qd(r2.center.lat), h2 = (i2.x + 0.5) / n3 - l2;
              let u2 = 0;
              h2 > 0.5 ? u2 = -1 : h2 < -0.5 && (u2 = 1);
              let d2 = (e2 / sr + i2.x) / n3 + u2, p2 = (t2 / sr + i2.y) / n3;
              d2 = (d2 - l2) * r2._pixelsPerMercatorPixel + l2, p2 = (p2 - c2) * r2._pixelsPerMercatorPixel + c2;
              const f2 = [d2 * r2.worldSize, p2 * r2.worldSize, 0];
              Mu.transformMat4(f2, f2, o2), a2 = ld(a2, f2, s2);
            }
            return Mu.transformMat4(a2, a2, n2);
          }
          _makeGlobeTileDebugBorderBuffer(e2, t2, i2, r2, n2, o2) {
            const s2 = new Ta(), a2 = new Wa(), l2 = new Ea(), c2 = (e3, c3, h3, u2, d2) => {
              const p2 = (h3 - e3) / (d2 - 1), f2 = (u2 - c3) / (d2 - 1), m2 = s2.length;
              for (let h4 = 0; h4 < d2; h4++) {
                const u3 = e3 + h4 * p2, d3 = c3 + h4 * f2;
                s2.emplaceBack(u3, d3);
                const _2 = this._globePoint(u3, d3, t2, i2, r2, n2, o2);
                l2.emplaceBack(_2[0], _2[1], _2[2]), a2.emplaceBack(m2 + h4);
              }
            }, h2 = sr;
            c2(0, 0, h2, 0, 16), c2(h2, 0, h2, h2, 16), c2(h2, h2, 0, h2, 16), c2(0, h2, 0, 0, 16), this._tileDebugIndexBuffer = e2.createIndexBuffer(a2), this._tileDebugBuffer = e2.createVertexBuffer(s2, Pu.members), this._globeTileDebugBorderBuffer = e2.createVertexBuffer(l2, Du.members), this._tileDebugSegments = dl.simpleSegment(0, 0, s2.length, a2.length);
          }
          _makeGlobeTileDebugTextBuffer(e2, t2, i2, r2, n2, o2) {
            const s2 = sr / 4, a2 = new Ta(), l2 = new Va(), c2 = new Ea(), h2 = 25;
            l2.reserve(32), a2.reserve(h2), c2.reserve(h2);
            const u2 = (e3, t3) => h2 * e3 + t3;
            for (let e3 = 0; e3 < h2; e3++) {
              const l3 = e3 * s2;
              for (let e4 = 0; e4 < h2; e4++) {
                const h3 = e4 * s2;
                a2.emplaceBack(h3, l3);
                const u3 = this._globePoint(h3, l3, t2, i2, r2, n2, o2);
                c2.emplaceBack(u3[0], u3[1], u3[2]);
              }
            }
            for (let e3 = 0; e3 < 4; e3++)
              for (let t3 = 0; t3 < 4; t3++) {
                const i3 = u2(e3, t3), r3 = u2(e3, t3 + 1), n3 = u2(e3 + 1, t3), o3 = u2(e3 + 1, t3 + 1);
                l2.emplaceBack(i3, r3, n3), l2.emplaceBack(n3, r3, o3);
              }
            this._tileDebugTextIndexBuffer = e2.createIndexBuffer(l2), this._tileDebugTextBuffer = e2.createVertexBuffer(a2, Pu.members), this._globeTileDebugTextBuffer = e2.createVertexBuffer(c2, Du.members), this._tileDebugTextSegments = dl.simpleSegment(0, 0, h2, 32);
          }
        }
        class Cy {
          constructor(e2, t2) {
            this.max = e2, this.onRemove = t2, this.reset();
          }
          reset() {
            for (const e2 in this.data)
              for (const t2 of this.data[e2])
                t2.timeout && clearTimeout(t2.timeout), this.onRemove(t2.value);
            return this.data = {}, this.order = [], this;
          }
          add(e2, t2, i2) {
            const r2 = e2.wrapped().key;
            void 0 === this.data[r2] && (this.data[r2] = []);
            const n2 = { value: t2, timeout: void 0 };
            if (void 0 !== i2 && (n2.timeout = setTimeout(() => {
              this.remove(e2, n2);
            }, i2)), this.data[r2].push(n2), this.order.push(r2), this.order.length > this.max) {
              const e3 = this._getAndRemoveByKey(this.order[0]);
              e3 && this.onRemove(e3);
            }
            return this;
          }
          has(e2) {
            return e2.wrapped().key in this.data;
          }
          getAndRemove(e2) {
            return this.has(e2) ? this._getAndRemoveByKey(e2.wrapped().key) : null;
          }
          _getAndRemoveByKey(e2) {
            const t2 = this.data[e2].shift();
            return t2.timeout && clearTimeout(t2.timeout), 0 === this.data[e2].length && delete this.data[e2], this.order.splice(this.order.indexOf(e2), 1), t2.value;
          }
          getByKey(e2) {
            const t2 = this.data[e2];
            return t2 ? t2[0].value : null;
          }
          get(e2) {
            return this.has(e2) ? this.data[e2.wrapped().key][0].value : null;
          }
          remove(e2, t2) {
            if (!this.has(e2))
              return this;
            const i2 = e2.wrapped().key, r2 = void 0 === t2 ? 0 : this.data[i2].indexOf(t2), n2 = this.data[i2][r2];
            return this.data[i2].splice(r2, 1), n2.timeout && clearTimeout(n2.timeout), 0 === this.data[i2].length && delete this.data[i2], this.onRemove(n2.value), this.order.splice(this.order.indexOf(i2), 1), this;
          }
          setMaxSize(e2) {
            for (this.max = e2; this.order.length > this.max; ) {
              const e3 = this._getAndRemoveByKey(this.order[0]);
              e3 && this.onRemove(e3);
            }
            return this;
          }
          filter(e2) {
            const t2 = [];
            for (const i2 in this.data)
              for (const r2 of this.data[i2])
                e2(r2.value) || t2.push(r2);
            for (const e3 of t2)
              this.remove(e3.value.tileID, e3);
          }
        }
        class zy {
          constructor(e2, t2, i2, r2) {
            this.id = zy.uniqueIdxCounter, zy.uniqueIdxCounter++, this.context = e2;
            const n2 = e2.gl;
            this.buffer = n2.createBuffer(), this.dynamicDraw = Boolean(i2), this.context.unbindVAO(), e2.bindElementBuffer.set(this.buffer), n2.bufferData(n2.ELEMENT_ARRAY_BUFFER, t2.arrayBuffer, this.dynamicDraw ? n2.DYNAMIC_DRAW : n2.STATIC_DRAW), this.dynamicDraw || r2 || t2.destroy();
          }
          bind() {
            this.context.bindElementBuffer.set(this.buffer);
          }
          updateData(e2) {
            this.id = zy.uniqueIdxCounter, zy.uniqueIdxCounter++;
            const t2 = this.context.gl;
            this.context.unbindVAO(), this.bind(), t2.bufferSubData(t2.ELEMENT_ARRAY_BUFFER, 0, e2.arrayBuffer);
          }
          destroy() {
            this.buffer && (this.context.gl.deleteBuffer(this.buffer), delete this.buffer);
          }
        }
        zy.uniqueIdxCounter = 0;
        const Dy = { Int8: "BYTE", Uint8: "UNSIGNED_BYTE", Int16: "SHORT", Uint16: "UNSIGNED_SHORT", Int32: "INT", Uint32: "UNSIGNED_INT", Float32: "FLOAT" };
        class Py {
          constructor(e2, t2, i2, r2, n2, o2) {
            this.length = t2.length, this.attributes = i2, this.itemSize = t2.bytesPerElement, this.dynamicDraw = r2, this.instanceCount = o2, this.context = e2;
            const s2 = e2.gl;
            this.buffer = s2.createBuffer(), e2.bindVertexBuffer.set(this.buffer), s2.bufferData(s2.ARRAY_BUFFER, t2.arrayBuffer, this.dynamicDraw ? s2.DYNAMIC_DRAW : s2.STATIC_DRAW), this.dynamicDraw || n2 || t2.destroy();
          }
          bind() {
            this.context.bindVertexBuffer.set(this.buffer);
          }
          updateData(e2) {
            const t2 = this.context.gl;
            this.bind(), t2.bufferSubData(t2.ARRAY_BUFFER, 0, e2.arrayBuffer);
          }
          enableAttributes(e2, t2) {
            for (let i2 = 0; i2 < this.attributes.length; i2++) {
              const r2 = t2.attributes[this.attributes[i2].name];
              void 0 !== r2 && e2.enableVertexAttribArray(r2);
            }
          }
          setVertexAttribPointers(e2, t2, i2) {
            for (let r2 = 0; r2 < this.attributes.length; r2++) {
              const n2 = this.attributes[r2], o2 = t2.attributes[n2.name];
              void 0 !== o2 && e2.vertexAttribPointer(o2, n2.components, e2[Dy[n2.type]], false, this.itemSize, n2.offset + this.itemSize * (i2 || 0));
            }
          }
          setVertexAttribDivisor(e2, t2, i2) {
            for (let r2 = 0; r2 < this.attributes.length; r2++) {
              const n2 = t2.attributes[this.attributes[r2].name];
              void 0 !== n2 && this.instanceCount && this.instanceCount > 0 && e2.vertexAttribDivisor(n2, i2);
            }
          }
          destroy() {
            this.buffer && (this.context.gl.deleteBuffer(this.buffer), delete this.buffer);
          }
        }
        class Ry {
          constructor(e2) {
            this.gl = e2.gl, this.default = this.getDefault(), this.current = this.default, this.dirty = false;
          }
          get() {
            return this.current;
          }
          set(e2) {
          }
          getDefault() {
            return this.default;
          }
          setDefault() {
            this.set(this.default);
          }
        }
        class Ly extends Ry {
          getDefault() {
            return li.transparent;
          }
          set(e2) {
            const t2 = this.current;
            (e2.r !== t2.r || e2.g !== t2.g || e2.b !== t2.b || e2.a !== t2.a || this.dirty) && (this.gl.clearColor(e2.r, e2.g, e2.b, e2.a), this.current = e2, this.dirty = false);
          }
        }
        class ky extends Ry {
          getDefault() {
            return 1;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.clearDepth(e2), this.current = e2, this.dirty = false);
          }
        }
        class Oy extends Ry {
          getDefault() {
            return 0;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.clearStencil(e2), this.current = e2, this.dirty = false);
          }
        }
        class By extends Ry {
          getDefault() {
            return [true, true, true, true];
          }
          set(e2) {
            const t2 = this.current;
            (e2[0] !== t2[0] || e2[1] !== t2[1] || e2[2] !== t2[2] || e2[3] !== t2[3] || this.dirty) && (this.gl.colorMask(e2[0], e2[1], e2[2], e2[3]), this.current = e2, this.dirty = false);
          }
        }
        class Fy extends Ry {
          getDefault() {
            return true;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.depthMask(e2), this.current = e2, this.dirty = false);
          }
        }
        class Ny extends Ry {
          getDefault() {
            return 255;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.stencilMask(e2), this.current = e2, this.dirty = false);
          }
        }
        class Uy extends Ry {
          getDefault() {
            return { func: this.gl.ALWAYS, ref: 0, mask: 255 };
          }
          set(e2) {
            const t2 = this.current;
            (e2.func !== t2.func || e2.ref !== t2.ref || e2.mask !== t2.mask || this.dirty) && (this.gl.stencilFunc(e2.func, e2.ref, e2.mask), this.current = e2, this.dirty = false);
          }
        }
        class Vy extends Ry {
          getDefault() {
            const e2 = this.gl;
            return [e2.KEEP, e2.KEEP, e2.KEEP];
          }
          set(e2) {
            const t2 = this.current;
            (e2[0] !== t2[0] || e2[1] !== t2[1] || e2[2] !== t2[2] || this.dirty) && (this.gl.stencilOp(e2[0], e2[1], e2[2]), this.current = e2, this.dirty = false);
          }
        }
        class jy extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            e2 ? t2.enable(t2.STENCIL_TEST) : t2.disable(t2.STENCIL_TEST), this.current = e2, this.dirty = false;
          }
        }
        class Gy extends Ry {
          getDefault() {
            return [0, 1];
          }
          set(e2) {
            const t2 = this.current;
            (e2[0] !== t2[0] || e2[1] !== t2[1] || this.dirty) && (this.gl.depthRange(e2[0], e2[1]), this.current = e2, this.dirty = false);
          }
        }
        class qy extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            e2 ? t2.enable(t2.DEPTH_TEST) : t2.disable(t2.DEPTH_TEST), this.current = e2, this.dirty = false;
          }
        }
        class Zy extends Ry {
          getDefault() {
            return this.gl.LESS;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.depthFunc(e2), this.current = e2, this.dirty = false);
          }
        }
        class $y extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            e2 ? t2.enable(t2.BLEND) : t2.disable(t2.BLEND), this.current = e2, this.dirty = false;
          }
        }
        class Hy extends Ry {
          getDefault() {
            const e2 = this.gl;
            return [e2.ONE, e2.ZERO, e2.ONE, e2.ZERO];
          }
          set(e2) {
            const t2 = this.current;
            (e2[0] !== t2[0] || e2[1] !== t2[1] || e2[2] !== t2[2] || e2[3] !== t2[3] || this.dirty) && (this.gl.blendFuncSeparate(e2[0], e2[1], e2[2], e2[3]), this.current = e2, this.dirty = false);
          }
        }
        class Wy extends Ry {
          getDefault() {
            return li.transparent;
          }
          set(e2) {
            const t2 = this.current;
            (e2.r !== t2.r || e2.g !== t2.g || e2.b !== t2.b || e2.a !== t2.a || this.dirty) && (this.gl.blendColor(e2.r, e2.g, e2.b, e2.a), this.current = e2, this.dirty = false);
          }
        }
        class Xy extends Ry {
          getDefault() {
            return this.gl.FUNC_ADD;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.blendEquationSeparate(e2, e2), this.current = e2, this.dirty = false);
          }
        }
        class Yy extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            e2 ? t2.enable(t2.CULL_FACE) : t2.disable(t2.CULL_FACE), this.current = e2, this.dirty = false;
          }
        }
        class Ky extends Ry {
          getDefault() {
            return this.gl.BACK;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.cullFace(e2), this.current = e2, this.dirty = false);
          }
        }
        class Jy extends Ry {
          getDefault() {
            return this.gl.CCW;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.frontFace(e2), this.current = e2, this.dirty = false);
          }
        }
        let Qy = class extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.useProgram(e2), this.current = e2, this.dirty = false);
          }
        };
        class ex extends Ry {
          getDefault() {
            return this.gl.TEXTURE0;
          }
          set(e2) {
            (e2 !== this.current || this.dirty) && (this.gl.activeTexture(e2), this.current = e2, this.dirty = false);
          }
        }
        class tx extends Ry {
          getDefault() {
            const e2 = this.gl;
            return [0, 0, e2.drawingBufferWidth, e2.drawingBufferHeight];
          }
          set(e2) {
            const t2 = this.current;
            (e2[0] !== t2[0] || e2[1] !== t2[1] || e2[2] !== t2[2] || e2[3] !== t2[3] || this.dirty) && (this.gl.viewport(e2[0], e2[1], e2[2], e2[3]), this.current = e2, this.dirty = false);
          }
        }
        class ix extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.bindFramebuffer(t2.FRAMEBUFFER, e2), this.current = e2, this.dirty = false;
          }
        }
        class rx extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.bindRenderbuffer(t2.RENDERBUFFER, e2), this.current = e2, this.dirty = false;
          }
        }
        class nx extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.bindTexture(t2.TEXTURE_2D, e2), this.current = e2, this.dirty = false;
          }
        }
        class ox extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.bindBuffer(t2.ARRAY_BUFFER, e2), this.current = e2, this.dirty = false;
          }
        }
        class sx extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            const t2 = this.gl;
            t2.bindBuffer(t2.ELEMENT_ARRAY_BUFFER, e2), this.current = e2, this.dirty = false;
          }
        }
        class ax extends Ry {
          getDefault() {
            return null;
          }
          set(e2) {
            this.gl && (e2 !== this.current || this.dirty) && (this.gl.bindVertexArray(e2), this.current = e2, this.dirty = false);
          }
        }
        class lx extends Ry {
          getDefault() {
            return 4;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.pixelStorei(t2.UNPACK_ALIGNMENT, e2), this.current = e2, this.dirty = false;
          }
        }
        class cx extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.pixelStorei(t2.UNPACK_PREMULTIPLY_ALPHA_WEBGL, e2), this.current = e2, this.dirty = false;
          }
        }
        class hx extends Ry {
          getDefault() {
            return false;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            const t2 = this.gl;
            t2.pixelStorei(t2.UNPACK_FLIP_Y_WEBGL, e2), this.current = e2, this.dirty = false;
          }
        }
        class ux extends Ry {
          constructor(e2, t2) {
            super(e2), this.context = e2, this.parent = t2;
          }
          getDefault() {
            return null;
          }
        }
        class dx extends ux {
          setDirty() {
            this.dirty = true;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            this.context.bindFramebuffer.set(this.parent);
            const t2 = this.gl;
            t2.framebufferTexture2D(t2.FRAMEBUFFER, t2.COLOR_ATTACHMENT0, t2.TEXTURE_2D, e2, 0), this.current = e2, this.dirty = false;
          }
        }
        class px extends ux {
          attachment() {
            return this.gl.DEPTH_ATTACHMENT;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            this.context.bindFramebuffer.set(this.parent);
            const t2 = this.gl;
            t2.framebufferRenderbuffer(t2.FRAMEBUFFER, this.attachment(), t2.RENDERBUFFER, e2), this.current = e2, this.dirty = false;
          }
        }
        class fx extends ux {
          attachment() {
            return this.gl.DEPTH_ATTACHMENT;
          }
          set(e2) {
            if (e2 === this.current && !this.dirty)
              return;
            this.context.bindFramebuffer.set(this.parent);
            const t2 = this.gl;
            t2.framebufferTexture2D(t2.FRAMEBUFFER, this.attachment(), t2.TEXTURE_2D, e2, 0), this.current = e2, this.dirty = false;
          }
        }
        class mx extends px {
          attachment() {
            return this.gl.DEPTH_STENCIL_ATTACHMENT;
          }
        }
        class _x {
          constructor(e2, t2, i2, r2, n2) {
            this.context = e2, this.width = t2, this.height = i2;
            const o2 = this.framebuffer = e2.gl.createFramebuffer();
            r2 && (this.colorAttachment = new dx(e2, o2)), n2 && (this.depthAttachmentType = n2, this.depthAttachment = "renderbuffer" === n2 ? new px(e2, o2) : new fx(e2, o2));
          }
          destroy() {
            const e2 = this.context.gl;
            if (this.colorAttachment) {
              const t2 = this.colorAttachment.get();
              t2 && e2.deleteTexture(t2);
            }
            if (this.depthAttachment && this.depthAttachmentType)
              if ("renderbuffer" === this.depthAttachmentType) {
                const t2 = this.depthAttachment.get();
                t2 && e2.deleteRenderbuffer(t2);
              } else {
                const t2 = this.depthAttachment.get();
                t2 && e2.deleteTexture(t2);
              }
            e2.deleteFramebuffer(this.framebuffer);
          }
        }
        class gx {
          constructor(e2, t2, i2) {
            this.func = e2, this.mask = t2, this.range = i2;
          }
        }
        gx.ReadOnly = false, gx.ReadWrite = true, gx.disabled = new gx(519, gx.ReadOnly, [0, 1]);
        const yx = 7680;
        class xx {
          constructor(e2, t2, i2, r2, n2, o2) {
            this.test = e2, this.ref = t2, this.mask = i2, this.fail = r2, this.depthFail = n2, this.pass = o2;
          }
        }
        xx.disabled = new xx({ func: 519, mask: 0 }, 0, 0, yx, yx, yx);
        const vx = 771;
        class bx {
          constructor(e2, t2, i2, r2) {
            this.blendFunction = e2, this.blendColor = t2, this.mask = i2, this.blendEquation = r2;
          }
        }
        bx.Replace = [1, 0, 1, 0], bx.disabled = new bx(bx.Replace, li.transparent, [false, false, false, false]), bx.unblended = new bx(bx.Replace, li.transparent, [true, true, true, true]), bx.alphaBlended = new bx([1, vx, 1, vx], li.transparent, [true, true, true, true]), bx.multiply = new bx([774, 0, 774, 0], li.transparent, [true, true, true, true]);
        const wx = 1029, Tx = 2305;
        class Ex {
          constructor(e2, t2, i2) {
            this.enable = e2, this.mode = t2, this.frontFace = i2;
          }
        }
        Ex.disabled = new Ex(false, wx, Tx), Ex.backCCW = new Ex(true, wx, Tx), Ex.backCW = new Ex(true, wx, 2304), Ex.frontCW = new Ex(true, 1028, 2304), Ex.frontCCW = new Ex(true, 1028, Tx);
        class Mx {
          constructor(e2) {
            this.gl = e2, this.clearColor = new Ly(this), this.clearDepth = new ky(this), this.clearStencil = new Oy(this), this.colorMask = new By(this), this.depthMask = new Fy(this), this.stencilMask = new Ny(this), this.stencilFunc = new Uy(this), this.stencilOp = new Vy(this), this.stencilTest = new jy(this), this.depthRange = new Gy(this), this.depthTest = new qy(this), this.depthFunc = new Zy(this), this.blend = new $y(this), this.blendFunc = new Hy(this), this.blendColor = new Wy(this), this.blendEquation = new Xy(this), this.cullFace = new Yy(this), this.cullFaceSide = new Ky(this), this.frontFace = new Jy(this), this.program = new Qy(this), this.activeTexture = new ex(this), this.viewport = new tx(this), this.bindFramebuffer = new ix(this), this.bindRenderbuffer = new rx(this), this.bindTexture = new nx(this), this.bindVertexBuffer = new ox(this), this.bindElementBuffer = new sx(this), this.bindVertexArrayOES = new ax(this), this.pixelStoreUnpack = new lx(this), this.pixelStoreUnpackPremultiplyAlpha = new cx(this), this.pixelStoreUnpackFlipY = new hx(this), this.extTextureFilterAnisotropic = e2.getExtension("EXT_texture_filter_anisotropic") || e2.getExtension("MOZ_EXT_texture_filter_anisotropic") || e2.getExtension("WEBKIT_EXT_texture_filter_anisotropic"), this.extTextureFilterAnisotropic && (this.extTextureFilterAnisotropicMax = e2.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)), this.extTextureFilterAnisotropicForceOff = false, this.extStandardDerivativesForceOff = false, this.extDebugRendererInfo = e2.getExtension("WEBGL_debug_renderer_info"), this.extDebugRendererInfo && (this.renderer = e2.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL), this.vendor = e2.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)), this.extTextureFloatLinear = e2.getExtension("OES_texture_float_linear"), this.extRenderToTextureHalfFloat = e2.getExtension("EXT_color_buffer_half_float"), this.extTimerQuery = e2.getExtension("EXT_disjoint_timer_query_webgl2"), this.maxTextureSize = e2.getParameter(e2.MAX_TEXTURE_SIZE);
          }
          setDefault() {
            this.unbindVAO(), this.clearColor.setDefault(), this.clearDepth.setDefault(), this.clearStencil.setDefault(), this.colorMask.setDefault(), this.depthMask.setDefault(), this.stencilMask.setDefault(), this.stencilFunc.setDefault(), this.stencilOp.setDefault(), this.stencilTest.setDefault(), this.depthRange.setDefault(), this.depthTest.setDefault(), this.depthFunc.setDefault(), this.blend.setDefault(), this.blendFunc.setDefault(), this.blendColor.setDefault(), this.blendEquation.setDefault(), this.cullFace.setDefault(), this.cullFaceSide.setDefault(), this.frontFace.setDefault(), this.program.setDefault(), this.activeTexture.setDefault(), this.bindFramebuffer.setDefault(), this.pixelStoreUnpack.setDefault(), this.pixelStoreUnpackPremultiplyAlpha.setDefault(), this.pixelStoreUnpackFlipY.setDefault();
          }
          setDirty() {
            this.clearColor.dirty = true, this.clearDepth.dirty = true, this.clearStencil.dirty = true, this.colorMask.dirty = true, this.depthMask.dirty = true, this.stencilMask.dirty = true, this.stencilFunc.dirty = true, this.stencilOp.dirty = true, this.stencilTest.dirty = true, this.depthRange.dirty = true, this.depthTest.dirty = true, this.depthFunc.dirty = true, this.blend.dirty = true, this.blendFunc.dirty = true, this.blendColor.dirty = true, this.blendEquation.dirty = true, this.cullFace.dirty = true, this.cullFaceSide.dirty = true, this.frontFace.dirty = true, this.program.dirty = true, this.activeTexture.dirty = true, this.viewport.dirty = true, this.bindFramebuffer.dirty = true, this.bindRenderbuffer.dirty = true, this.bindTexture.dirty = true, this.bindVertexBuffer.dirty = true, this.bindElementBuffer.dirty = true, this.bindVertexArrayOES.dirty = true, this.pixelStoreUnpack.dirty = true, this.pixelStoreUnpackPremultiplyAlpha.dirty = true, this.pixelStoreUnpackFlipY.dirty = true;
          }
          createIndexBuffer(e2, t2, i2) {
            return new zy(this, e2, t2, i2);
          }
          createVertexBuffer(e2, t2, i2, r2, n2) {
            return new Py(this, e2, t2, i2, r2, n2);
          }
          createRenderbuffer(e2, t2, i2) {
            const r2 = this.gl, n2 = r2.createRenderbuffer();
            return this.bindRenderbuffer.set(n2), r2.renderbufferStorage(r2.RENDERBUFFER, e2, t2, i2), this.bindRenderbuffer.set(null), n2;
          }
          createFramebuffer(e2, t2, i2, r2) {
            return new _x(this, e2, t2, i2, r2);
          }
          clear({ color: e2, depth: t2, stencil: i2, colorMask: r2 }) {
            const n2 = this.gl;
            let o2 = 0;
            e2 && (o2 |= n2.COLOR_BUFFER_BIT, this.clearColor.set(e2), this.colorMask.set(r2 || [true, true, true, true])), void 0 !== t2 && (o2 |= n2.DEPTH_BUFFER_BIT, this.depthRange.set([0, 1]), this.clearDepth.set(t2), this.depthMask.set(true)), void 0 !== i2 && (o2 |= n2.STENCIL_BUFFER_BIT, this.clearStencil.set(i2), this.stencilMask.set(255)), n2.clear(o2);
          }
          setCullFace(e2) {
            false === e2.enable ? this.cullFace.set(false) : (this.cullFace.set(true), this.cullFaceSide.set(e2.mode), this.frontFace.set(e2.frontFace));
          }
          setDepthMode(e2) {
            e2.func !== this.gl.ALWAYS || e2.mask ? (this.depthTest.set(true), this.depthFunc.set(e2.func), this.depthMask.set(e2.mask), this.depthRange.set(e2.range)) : this.depthTest.set(false);
          }
          setStencilMode(e2) {
            e2.test.func !== this.gl.ALWAYS || e2.mask ? (this.stencilTest.set(true), this.stencilMask.set(e2.mask), this.stencilOp.set([e2.fail, e2.depthFail, e2.pass]), this.stencilFunc.set({ func: e2.test.func, ref: e2.ref, mask: e2.test.mask })) : this.stencilTest.set(false);
          }
          setColorMode(e2) {
            x(e2.blendFunction, bx.Replace) ? this.blend.set(false) : (this.blend.set(true), this.blendFunc.set(e2.blendFunction), this.blendColor.set(e2.blendColor), e2.blendEquation ? this.blendEquation.set(e2.blendEquation) : this.blendEquation.setDefault()), this.colorMask.set(e2.mask);
          }
          unbindVAO() {
            this.bindVertexArrayOES.set(null);
          }
        }
        class Ax extends It {
          constructor(e2, t2, i2) {
            super(), this.id = e2, this._onlySymbols = i2, t2.on("data", (e3) => {
              "source" === e3.dataType && "metadata" === e3.sourceDataType && (this._sourceLoaded = true), this._sourceLoaded && !this._paused && "source" === e3.dataType && "content" === e3.sourceDataType && (this.reload(), this.transform && this.update(this.transform));
            }), t2.on("error", () => {
              this._sourceErrored = true;
            }), this._source = t2, this._tiles = {}, this._cache = new Cy(0, this._unloadTile.bind(this)), this._timers = {}, this._cacheTimers = {}, this._minTileCacheSize = t2.minTileCacheSize, this._maxTileCacheSize = t2.maxTileCacheSize, this._loadedParentTiles = {}, this.castsShadows = false, this._coveredTiles = {}, this._shadowCasterTiles = {}, this._state = new zm(), this._isRaster = "raster" === this._source.type || "raster-dem" === this._source.type || "custom" === this._source.type && "raster" === this._source._dataType;
          }
          onAdd(e2) {
            this.map = e2, this._minTileCacheSize = void 0 === this._minTileCacheSize && e2 ? e2._minTileCacheSize : this._minTileCacheSize, this._maxTileCacheSize = void 0 === this._maxTileCacheSize && e2 ? e2._maxTileCacheSize : this._maxTileCacheSize;
          }
          loaded() {
            if (this._sourceErrored)
              return true;
            if (!this._sourceLoaded)
              return false;
            if (!this._source.loaded())
              return false;
            for (const e2 in this._tiles) {
              const t2 = this._tiles[e2];
              if ("errored" !== t2.state && ("loaded" !== t2.state || !t2.bucketsLoaded()))
                return false;
            }
            return true;
          }
          getSource() {
            return this._source;
          }
          pause() {
            this._paused = true;
          }
          resume() {
            if (!this._paused)
              return;
            const e2 = this._shouldReloadOnResume;
            this._paused = false, this._shouldReloadOnResume = false, e2 && this.reload(), this.transform && this.update(this.transform);
          }
          _loadTile(e2, t2) {
            return e2.isSymbolTile = this._onlySymbols, e2.isExtraShadowCaster = this._shadowCasterTiles[e2.tileID.key], this._source.loadTile(e2, t2);
          }
          _unloadTile(e2) {
            if (this._source.unloadTile)
              return this._source.unloadTile(e2, () => {
              });
          }
          _abortTile(e2) {
            if (this._source.abortTile)
              return this._source.abortTile(e2, () => {
              });
          }
          serialize() {
            return this._source.serialize();
          }
          prepare(e2) {
            this._source.prepare && this._source.prepare(), this._state.coalesceChanges(this._tiles, this.map ? this.map.painter : null);
            for (const t2 in this._tiles) {
              const i2 = this._tiles[t2];
              i2.upload(e2), i2.prepare(this.map.style.imageManager, this.map ? this.map.painter : null, this._source.scope);
            }
          }
          getIds() {
            return L(this._tiles).map((e2) => e2.tileID).sort(Sx).map((e2) => e2.key);
          }
          getRenderableIds(e2, t2) {
            const i2 = [];
            for (const r2 in this._tiles)
              this._isIdRenderable(+r2, e2, t2) && i2.push(this._tiles[r2]);
            return e2 ? i2.sort((e3, t3) => {
              const i3 = e3.tileID, r2 = t3.tileID, n2 = new y(i3.canonical.x, i3.canonical.y)._rotate(this.transform.angle), o2 = new y(r2.canonical.x, r2.canonical.y)._rotate(this.transform.angle);
              return i3.overscaledZ - r2.overscaledZ || o2.y - n2.y || o2.x - n2.x;
            }).map((e3) => e3.tileID.key) : i2.map((e3) => e3.tileID).sort(Sx).map((e3) => e3.key);
          }
          hasRenderableParent(e2) {
            const t2 = this.findLoadedParent(e2, 0);
            return !!t2 && this._isIdRenderable(t2.tileID.key);
          }
          _isIdRenderable(e2, t2, i2) {
            return this._tiles[e2] && this._tiles[e2].hasData() && !this._coveredTiles[e2] && (t2 || !this._tiles[e2].holdingForFade()) && (i2 || !this._shadowCasterTiles[e2]);
          }
          reload() {
            if (this._paused)
              this._shouldReloadOnResume = true;
            else {
              this._cache.reset();
              for (const e2 in this._tiles)
                "errored" !== this._tiles[e2].state && this._reloadTile(+e2, "reloading");
            }
          }
          _reloadTile(e2, t2) {
            const i2 = this._tiles[e2];
            i2 && ("loading" !== i2.state && (i2.state = t2), this._loadTile(i2, this._tileLoaded.bind(this, i2, e2, t2)));
          }
          _tileLoaded(e2, t2, i2, r2) {
            if (r2)
              if (e2.state = "errored", 404 !== r2.status)
                this._source.fire(new St(r2, { tile: e2 }));
              else if ("raster-dem" === this._source.type && this.usedForTerrain && this.map.painter.terrain) {
                const e3 = this.map.painter.terrain;
                this.update(this.transform, e3.getScaledDemTileSize(), true), e3.resetTileLookupCache(this.id);
              } else
                this.update(this.transform);
            else
              e2.timeAdded = ht.now(), "expired" === i2 && (e2.refreshedUponExpiration = true), this._setTileReloadTimer(t2, e2), "raster-dem" === this._source.type && e2.dem && this._backfillDEM(e2), this._state.initializeTileState(e2, this.map ? this.map.painter : null), this._source.fire(new At("data", { dataType: "source", tile: e2, coord: e2.tileID, sourceCacheId: this.id }));
          }
          _backfillDEM(e2) {
            const t2 = this.getRenderableIds();
            for (let r2 = 0; r2 < t2.length; r2++) {
              const n2 = t2[r2];
              if (e2.neighboringTiles && e2.neighboringTiles[n2]) {
                const t3 = this.getTileByID(n2);
                i2(e2, t3), i2(t3, e2);
              }
            }
            function i2(e3, t3) {
              if (!e3.dem || e3.dem.borderReady)
                return;
              e3.needsHillshadePrepare = true, e3.needsDEMTextureUpload = true;
              let i3 = t3.tileID.canonical.x - e3.tileID.canonical.x;
              const r2 = t3.tileID.canonical.y - e3.tileID.canonical.y, n2 = Math.pow(2, e3.tileID.canonical.z), o2 = t3.tileID.key;
              0 === i3 && 0 === r2 || Math.abs(r2) > 1 || (Math.abs(i3) > 1 && (1 === Math.abs(i3 + n2) ? i3 += n2 : 1 === Math.abs(i3 - n2) && (i3 -= n2)), t3.dem && e3.dem && (e3.dem.backfillBorder(t3.dem, i3, r2), e3.neighboringTiles && e3.neighboringTiles[o2] && (e3.neighboringTiles[o2].backfilled = true)));
            }
          }
          getTile(e2) {
            return this.getTileByID(e2.key);
          }
          getTileByID(e2) {
            return this._tiles[e2];
          }
          _retainLoadedChildren(e2, t2, i2, r2) {
            for (const n2 in this._tiles) {
              let o2 = this._tiles[n2];
              if (r2[n2] || !o2.hasData() || o2.tileID.overscaledZ <= t2 || o2.tileID.overscaledZ > i2)
                continue;
              let s2 = o2.tileID;
              for (; o2 && o2.tileID.overscaledZ > t2 + 1; ) {
                const e3 = o2.tileID.scaledTo(o2.tileID.overscaledZ - 1);
                o2 = this._tiles[e3.key], o2 && o2.hasData() && (s2 = e3);
              }
              let a2 = s2;
              for (; a2.overscaledZ > t2; )
                if (a2 = a2.scaledTo(a2.overscaledZ - 1), e2[a2.key]) {
                  r2[s2.key] = s2;
                  break;
                }
            }
          }
          findLoadedParent(e2, t2) {
            if (e2.key in this._loadedParentTiles) {
              const i2 = this._loadedParentTiles[e2.key];
              return i2 && i2.tileID.overscaledZ >= t2 ? i2 : null;
            }
            for (let i2 = e2.overscaledZ - 1; i2 >= t2; i2--) {
              const t3 = e2.scaledTo(i2), r2 = this._getLoadedTile(t3);
              if (r2)
                return r2;
            }
          }
          _getLoadedTile(e2) {
            const t2 = this._tiles[e2.key];
            return t2 && t2.hasData() ? t2 : this._cache.getByKey(this._source.reparseOverscaled ? e2.wrapped().key : e2.canonical.key);
          }
          updateCacheSize(e2, t2) {
            t2 = t2 || this._source.tileSize;
            const i2 = Math.ceil(e2.width / t2) + 1, r2 = Math.ceil(e2.height / t2) + 1, n2 = Math.floor(i2 * r2 * 5), o2 = "number" == typeof this._minTileCacheSize ? Math.max(this._minTileCacheSize, n2) : n2, s2 = "number" == typeof this._maxTileCacheSize ? Math.min(this._maxTileCacheSize, o2) : o2;
            this._cache.setMaxSize(s2);
          }
          handleWrapJump(e2) {
            const t2 = Math.round((e2 - (void 0 === this._prevLng ? e2 : this._prevLng)) / 360);
            if (this._prevLng = e2, t2) {
              const e3 = {};
              for (const i2 in this._tiles) {
                const r2 = this._tiles[i2];
                r2.tileID = r2.tileID.unwrapTo(r2.tileID.wrap + t2), e3[r2.tileID.key] = r2;
              }
              this._tiles = e3;
              for (const e4 in this._timers)
                clearTimeout(this._timers[e4]), delete this._timers[e4];
              for (const e4 in this._tiles)
                this._setTileReloadTimer(+e4, this._tiles[e4]);
            }
          }
          update(e2, t2, i2, r2) {
            if (this.transform = e2, !this._sourceLoaded || this._paused || this.transform.freezeTileCoverage)
              return;
            if (this.usedForTerrain && !i2)
              return;
            let n2;
            if (this.updateCacheSize(e2, t2), "globe" !== this.transform.projection.name && this.handleWrapJump(this.transform.center.lng), this._shadowCasterTiles = {}, this._coveredTiles = {}, this.used || this.usedForTerrain ? this._source.tileID ? n2 = e2.getVisibleUnwrappedCoordinates(this._source.tileID).map((e3) => new Bu(e3.canonical.z, e3.wrap, e3.canonical.z, e3.canonical.x, e3.canonical.y)) : (n2 = e2.coveringTiles({ tileSize: t2 || this._source.tileSize, minzoom: this._source.minzoom, maxzoom: this._source.maxzoom, roundZoom: this._source.roundZoom && !i2, reparseOverscaled: this._source.reparseOverscaled, isTerrainDEM: this.usedForTerrain }), this._source.hasTile && (n2 = n2.filter((e3) => this._source.hasTile(e3)))) : n2 = [], n2.length > 0 && this.castsShadows && r2 && "globe" !== this.transform.projection.name && !this.usedForTerrain && !Ix(this._source.type)) {
              const o3 = e2.coveringZoomLevel({ tileSize: t2 || this._source.tileSize, roundZoom: this._source.roundZoom && !i2 }), s3 = Math.min(o3, this._source.maxzoom), a2 = e2.extendTileCoverForShadows(n2, r2, s3);
              for (const e3 of a2)
                this._shadowCasterTiles[e3.key] = true, n2.push(e3);
            }
            const o2 = this._updateRetainedTiles(n2);
            if (Ix(this._source.type) && 0 !== n2.length) {
              const e3 = {}, t3 = {}, i3 = Object.keys(o2);
              for (const r4 of i3) {
                const i4 = o2[r4], n3 = this._tiles[r4];
                if (!n3 || n3.fadeEndTime && n3.fadeEndTime <= ht.now())
                  continue;
                const s3 = this.findLoadedParent(i4, Math.max(i4.overscaledZ - Ax.maxOverzooming, this._source.minzoom));
                s3 && (this._addTile(s3.tileID), e3[s3.tileID.key] = s3.tileID), t3[r4] = i4;
              }
              const r3 = n2[n2.length - 1].overscaledZ;
              for (const e4 in this._tiles) {
                const i4 = this._tiles[e4];
                if (o2[e4] || !i4.hasData())
                  continue;
                let n3 = i4.tileID;
                for (; n3.overscaledZ > r3; ) {
                  n3 = n3.scaledTo(n3.overscaledZ - 1);
                  const r4 = this._tiles[n3.key];
                  if (r4 && r4.hasData() && t3[n3.key]) {
                    o2[e4] = i4.tileID;
                    break;
                  }
                }
              }
              for (const t4 in e3)
                o2[t4] || (this._coveredTiles[t4] = true, o2[t4] = e3[t4]);
            }
            for (const e3 in o2)
              this._tiles[e3].clearFadeHold();
            const s2 = function(e3, t3) {
              const i3 = [];
              for (const r3 in e3)
                r3 in t3 || i3.push(r3);
              return i3;
            }(this._tiles, o2);
            for (const e3 of s2) {
              const t3 = this._tiles[e3];
              t3.hasSymbolBuckets && !t3.holdingForFade() ? t3.setHoldDuration(this.map._fadeDuration) : t3.hasSymbolBuckets && !t3.symbolFadeFinished() || this._removeTile(+e3);
            }
            this._updateLoadedParentTileCache(), this._onlySymbols && this._source.afterUpdate && this._source.afterUpdate();
          }
          releaseSymbolFadeTiles() {
            for (const e2 in this._tiles)
              this._tiles[e2].holdingForFade() && this._removeTile(+e2);
          }
          _updateRetainedTiles(e2) {
            const t2 = {};
            if (0 === e2.length)
              return t2;
            const i2 = {}, r2 = e2.reduce((e3, t3) => Math.min(e3, t3.overscaledZ), 1 / 0), n2 = e2[0].overscaledZ, o2 = Math.max(n2 - Ax.maxOverzooming, this._source.minzoom), s2 = Math.max(n2 + Ax.maxUnderzooming, this._source.minzoom), a2 = {};
            for (const i3 of e2) {
              const e3 = this._addTile(i3);
              t2[i3.key] = i3, e3.hasData() || r2 < this._source.maxzoom && (a2[i3.key] = i3);
            }
            this._retainLoadedChildren(a2, r2, s2, t2);
            for (const r3 of e2) {
              let e3 = this._tiles[r3.key];
              if (e3.hasData())
                continue;
              if (r3.canonical.z >= this._source.maxzoom) {
                const e4 = r3.children(this._source.maxzoom)[0], i3 = this.getTile(e4);
                if (i3 && i3.hasData()) {
                  t2[e4.key] = e4;
                  continue;
                }
              } else {
                const e4 = r3.children(this._source.maxzoom);
                if (t2[e4[0].key] && t2[e4[1].key] && t2[e4[2].key] && t2[e4[3].key])
                  continue;
              }
              let n3 = e3.wasRequested();
              for (let s3 = r3.overscaledZ - 1; s3 >= o2; --s3) {
                const o3 = r3.scaledTo(s3);
                if (i2[o3.key])
                  break;
                if (i2[o3.key] = true, e3 = this.getTile(o3), !e3 && n3 && (e3 = this._addTile(o3)), e3 && (t2[o3.key] = o3, n3 = e3.wasRequested(), e3.hasData()))
                  break;
              }
            }
            return t2;
          }
          _updateLoadedParentTileCache() {
            this._loadedParentTiles = {};
            for (const e2 in this._tiles) {
              const t2 = [];
              let i2, r2 = this._tiles[e2].tileID;
              for (; r2.overscaledZ > 0; ) {
                if (r2.key in this._loadedParentTiles) {
                  i2 = this._loadedParentTiles[r2.key];
                  break;
                }
                t2.push(r2.key);
                const e3 = r2.scaledTo(r2.overscaledZ - 1);
                if (i2 = this._getLoadedTile(e3), i2)
                  break;
                r2 = e3;
              }
              for (const e3 of t2)
                this._loadedParentTiles[e3] = i2;
            }
          }
          _addTile(e2) {
            let t2 = this._tiles[e2.key];
            if (t2)
              return true !== t2.isExtraShadowCaster || !!this._shadowCasterTiles[e2.key] || this._reloadTile(e2.key, "reloading"), t2;
            t2 = this._cache.getAndRemove(e2), t2 && (this._setTileReloadTimer(e2.key, t2), t2.tileID = e2, this._state.initializeTileState(t2, this.map ? this.map.painter : null), this._cacheTimers[e2.key] && (clearTimeout(this._cacheTimers[e2.key]), delete this._cacheTimers[e2.key], this._setTileReloadTimer(e2.key, t2)));
            const i2 = Boolean(t2);
            if (!i2) {
              const i3 = this.map ? this.map.painter : null;
              t2 = new Iy(e2, this._source.tileSize * e2.overscaleFactor(), this.transform.tileZoom, i3, this._isRaster), this._loadTile(t2, this._tileLoaded.bind(this, t2, e2.key, t2.state));
            }
            return t2 ? (t2.uses++, this._tiles[e2.key] = t2, i2 || this._source.fire(new At("dataloading", { tile: t2, coord: t2.tileID, dataType: "source" })), t2) : null;
          }
          _setTileReloadTimer(e2, t2) {
            e2 in this._timers && (clearTimeout(this._timers[e2]), delete this._timers[e2]);
            const i2 = t2.getExpiryTimeout();
            i2 && (this._timers[e2] = setTimeout(() => {
              this._reloadTile(e2, "expired"), delete this._timers[e2];
            }, i2));
          }
          _removeTile(e2) {
            const t2 = this._tiles[e2];
            t2 && (t2.uses--, delete this._tiles[e2], this._timers[e2] && (clearTimeout(this._timers[e2]), delete this._timers[e2]), t2.uses > 0 || (t2.hasData() && "reloading" !== t2.state ? this._cache.add(t2.tileID, t2, t2.getExpiryTimeout()) : (t2.aborted = true, this._abortTile(t2), this._unloadTile(t2))));
          }
          clearTiles() {
            this._shouldReloadOnResume = false, this._paused = false;
            for (const e2 in this._tiles)
              this._removeTile(+e2);
            this._source._clear && this._source._clear(), this._cache.reset(), this.map && this.usedForTerrain && this.map.painter.terrain && this.map.painter.terrain.resetTileLookupCache(this.id);
          }
          tilesIn(e2, t2, i2) {
            const r2 = [], n2 = this.transform;
            if (!n2)
              return r2;
            const o2 = "globe" === n2.projection.name, s2 = Gd(n2.center.lng);
            for (const a2 in this._tiles) {
              const l2 = this._tiles[a2];
              if (i2 && l2.clearQueryDebugViz(), l2.holdingForFade())
                continue;
              let c2;
              if (o2) {
                const e3 = l2.tileID.canonical;
                if (0 === e3.z) {
                  const t3 = [Math.abs(z(s2, ...Cx(e3, -1)) - s2), Math.abs(z(s2, ...Cx(e3, 1)) - s2)];
                  c2 = [0, 2 * t3.indexOf(Math.min(...t3)) - 1];
                } else {
                  const t3 = [Math.abs(z(s2, ...Cx(e3, -1)) - s2), Math.abs(z(s2, ...Cx(e3, 0)) - s2), Math.abs(z(s2, ...Cx(e3, 1)) - s2)];
                  c2 = [t3.indexOf(Math.min(...t3)) - 1];
                }
              } else
                c2 = [0];
              for (const i3 of c2) {
                const o3 = e2.containsTile(l2, n2, t2, i3);
                o3 && r2.push(o3);
              }
            }
            return r2;
          }
          getShadowCasterCoordinates() {
            return this._getRenderableCoordinates(false, true);
          }
          getVisibleCoordinates(e2) {
            return this._getRenderableCoordinates(e2);
          }
          _getRenderableCoordinates(e2, t2) {
            const i2 = this.getRenderableIds(e2, t2).map((e3) => this._tiles[e3].tileID);
            for (const e3 of i2)
              e3.projMatrix = this.transform.calculateProjMatrix(e3.toUnwrapped());
            return i2;
          }
          sortCoordinatesByDistance(e2) {
            const t2 = e2.slice(), i2 = this.transform._camera.position, r2 = this.transform._camera.forward(), n2 = {};
            for (const e3 of t2) {
              const t3 = 1 / (1 << e3.canonical.z);
              n2[e3.key] = ((e3.canonical.x + 0.5) * t3 + e3.wrap - i2[0]) * r2[0] + ((e3.canonical.y + 0.5) * t3 - i2[1]) * r2[1] - i2[2] * r2[2];
            }
            return t2.sort((e3, t3) => n2[e3.key] - n2[t3.key]), t2;
          }
          hasTransition() {
            if (this._source.hasTransition())
              return true;
            if (Ix(this._source.type))
              for (const e2 in this._tiles) {
                const t2 = this._tiles[e2];
                if (void 0 !== t2.fadeEndTime && t2.fadeEndTime >= ht.now())
                  return true;
              }
            return false;
          }
          setFeatureState(e2, t2, i2) {
            this._state.updateState(e2 = e2 || "_geojsonTileLayer", t2, i2);
          }
          removeFeatureState(e2, t2, i2) {
            this._state.removeFeatureState(e2 = e2 || "_geojsonTileLayer", t2, i2);
          }
          getFeatureState(e2, t2) {
            return this._state.getState(e2 = e2 || "_geojsonTileLayer", t2);
          }
          setDependencies(e2, t2, i2) {
            const r2 = this._tiles[e2];
            r2 && r2.setDependencies(t2, i2);
          }
          reloadTilesForDependencies(e2, t2) {
            for (const i2 in this._tiles)
              this._tiles[i2].hasDependency(e2, t2) && this._reloadTile(+i2, "reloading");
            this._cache.filter((i2) => !i2.hasDependency(e2, t2));
          }
          _preloadTiles(e2, t2) {
            if (!this._sourceLoaded) {
              const i3 = () => {
                this._sourceLoaded && (this._source.off("data", i3), this._preloadTiles(e2, t2));
              };
              return void this._source.on("data", i3);
            }
            const i2 = /* @__PURE__ */ new Map(), r2 = Array.isArray(e2) ? e2 : [e2], n2 = this.map.painter.terrain, o2 = this.usedForTerrain && n2 ? n2.getScaledDemTileSize() : this._source.tileSize;
            for (const e3 of r2) {
              const t3 = e3.coveringTiles({ tileSize: o2, minzoom: this._source.minzoom, maxzoom: this._source.maxzoom, roundZoom: this._source.roundZoom && !this.usedForTerrain, reparseOverscaled: this._source.reparseOverscaled, isTerrainDEM: this.usedForTerrain });
              for (const e4 of t3)
                i2.set(e4.key, e4);
              this.usedForTerrain && e3.updateElevation(false);
            }
            R(Array.from(i2.values()), (e3, t3) => {
              const i3 = new Iy(e3, this._source.tileSize * e3.overscaleFactor(), this.transform.tileZoom, this.map.painter, this._isRaster);
              this._loadTile(i3, (e4) => {
                "raster-dem" === this._source.type && i3.dem && this._backfillDEM(i3), t3(e4, i3);
              });
            }, t2);
          }
        }
        function Sx(e2, t2) {
          const i2 = Math.abs(2 * e2.wrap) - +(e2.wrap < 0), r2 = Math.abs(2 * t2.wrap) - +(t2.wrap < 0);
          return e2.overscaledZ - t2.overscaledZ || r2 - i2 || t2.canonical.y - e2.canonical.y || t2.canonical.x - e2.canonical.x;
        }
        function Ix(e2) {
          return "raster" === e2 || "image" === e2 || "video" === e2 || "custom" === e2;
        }
        function Cx(e2, t2) {
          const i2 = 1 << e2.z;
          return [e2.x / i2 + t2, (e2.x + 1) / i2 + t2];
        }
        Ax.maxOverzooming = 10, Ax.maxUnderzooming = 3;
        const zx = ba([{ name: "a_pos_3f", components: 3, type: "Float32" }]), Dx = ba([{ name: "a_color_3f", components: 3, type: "Float32" }]), Px = ba([{ name: "a_color_4f", components: 4, type: "Float32" }]), Rx = ba([{ name: "a_uv_2f", components: 2, type: "Float32" }]), Lx = ba([{ name: "a_normal_3f", components: 3, type: "Float32" }]), kx = ba([{ name: "a_normal_matrix0", components: 4, type: "Float32" }, { name: "a_normal_matrix1", components: 4, type: "Float32" }, { name: "a_normal_matrix2", components: 4, type: "Float32" }, { name: "a_normal_matrix3", components: 4, type: "Float32" }]), Ox = ba([{ name: "a_pbr", components: 4, type: "Uint16" }, { name: "a_heightBasedEmissiveStrength", components: 3, type: "Float32" }]);
        class Bx {
          constructor(e2 = 0, t2 = 0, i2 = 0, r2 = 0) {
            if (isNaN(e2) || e2 < 0 || isNaN(t2) || t2 < 0 || isNaN(i2) || i2 < 0 || isNaN(r2) || r2 < 0)
              throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");
            this.top = e2, this.bottom = t2, this.left = i2, this.right = r2;
          }
          interpolate(e2, t2, i2) {
            return null != t2.top && null != e2.top && (this.top = Wr(e2.top, t2.top, i2)), null != t2.bottom && null != e2.bottom && (this.bottom = Wr(e2.bottom, t2.bottom, i2)), null != t2.left && null != e2.left && (this.left = Wr(e2.left, t2.left, i2)), null != t2.right && null != e2.right && (this.right = Wr(e2.right, t2.right, i2)), this;
          }
          getCenter(e2, t2) {
            const i2 = z((this.left + e2 - this.right) / 2, 0, e2), r2 = z((this.top + t2 - this.bottom) / 2, 0, t2);
            return new y(i2, r2);
          }
          equals(e2) {
            return this.top === e2.top && this.bottom === e2.bottom && this.left === e2.left && this.right === e2.right;
          }
          clone() {
            return new Bx(this.top, this.bottom, this.left, this.right);
          }
          toJSON() {
            return { top: this.top, bottom: this.bottom, left: this.left, right: this.right };
          }
        }
        function Fx(e2, t2) {
          const i2 = ne(e2, 3);
          xu.fromQuat(e2, t2), oe(e2, 3, i2);
        }
        function Nx(e2, t2) {
          const i2 = bu.identity([]);
          return bu.rotateZ(i2, i2, -t2), bu.rotateX(i2, i2, -e2), i2;
        }
        function Ux(e2, t2) {
          const i2 = [e2[0], e2[1], 0], r2 = [t2[0], t2[1], 0];
          if (Mu.length(i2) >= 1e-15) {
            const e3 = Mu.normalize([], i2);
            Mu.scale(r2, e3, Mu.dot(r2, e3)), t2[0] = r2[0], t2[1] = r2[1];
          }
          const n2 = Mu.cross([], t2, e2);
          if (Mu.len(n2) < 1e-15)
            return null;
          const o2 = Math.atan2(-n2[1], n2[0]);
          return Nx(Math.atan2(Math.sqrt(e2[0] * e2[0] + e2[1] * e2[1]), -e2[2]), o2);
        }
        class Vx {
          constructor(e2, t2) {
            this.position = e2, this.orientation = t2;
          }
          get position() {
            return this._position;
          }
          set position(e2) {
            if (e2) {
              const t2 = e2 instanceof ep ? e2 : new ep(e2[0], e2[1], e2[2]);
              this._renderWorldCopies && (t2.x = P(t2.x, 0, 1)), this._position = t2;
            } else
              this._position = null;
          }
          lookAtPoint(e2, t2) {
            if (this.orientation = null, !this.position)
              return;
            const i2 = this.position, r2 = this._elevation ? this._elevation.getAtPointOrZero(ep.fromLngLat(e2)) : 0, n2 = ep.fromLngLat(e2, r2), o2 = [n2.x - i2.x, n2.y - i2.y, n2.z - i2.z];
            t2 || (t2 = [0, 0, 1]), t2[2] = Math.abs(t2[2]), this.orientation = Ux(o2, t2);
          }
          setPitchBearing(e2, t2) {
            this.orientation = Nx(w(e2), w(-t2));
          }
        }
        class jx {
          constructor(e2, t2) {
            this._transform = xu.identity([]), this.orientation = t2, this.position = e2;
          }
          get mercatorPosition() {
            const e2 = this.position;
            return new ep(e2[0], e2[1], e2[2]);
          }
          get position() {
            const e2 = ne(this._transform, 3);
            return [e2[0], e2[1], e2[2]];
          }
          set position(e2) {
            var t2;
            e2 && oe(this._transform, 3, [(t2 = e2)[0], t2[1], t2[2], 1]);
          }
          get orientation() {
            return this._orientation;
          }
          set orientation(e2) {
            this._orientation = e2 || bu.identity([]), e2 && Fx(this._transform, this._orientation);
          }
          getPitchBearing() {
            const e2 = this.forward(), t2 = this.right();
            return { bearing: Math.atan2(-t2[1], t2[0]), pitch: Math.atan2(Math.sqrt(e2[0] * e2[0] + e2[1] * e2[1]), -e2[2]) };
          }
          setPitchBearing(e2, t2) {
            this._orientation = Nx(e2, t2), Fx(this._transform, this._orientation);
          }
          forward() {
            const e2 = ne(this._transform, 2);
            return [-e2[0], -e2[1], -e2[2]];
          }
          up() {
            const e2 = ne(this._transform, 1);
            return [-e2[0], -e2[1], -e2[2]];
          }
          right() {
            const e2 = ne(this._transform, 0);
            return [e2[0], e2[1], e2[2]];
          }
          getCameraToWorld(e2, t2) {
            const i2 = new Float64Array(16);
            return xu.invert(i2, this.getWorldToCamera(e2, t2)), i2;
          }
          getCameraToWorldMercator() {
            return this._transform;
          }
          getWorldToCameraPosition(e2, t2, i2) {
            const r2 = this.position;
            Mu.scale(r2, r2, -e2);
            const n2 = new Float64Array(16);
            return xu.fromScaling(n2, [i2, i2, i2]), xu.translate(n2, n2, r2), n2[10] *= t2, n2;
          }
          getWorldToCamera(e2, t2) {
            const i2 = new Float64Array(16), r2 = new Float64Array(4), n2 = this.position;
            return bu.conjugate(r2, this._orientation), Mu.scale(n2, n2, -e2), xu.fromQuat(i2, r2), xu.translate(i2, i2, n2), i2[1] *= -1, i2[5] *= -1, i2[9] *= -1, i2[13] *= -1, i2[8] *= t2, i2[9] *= t2, i2[10] *= t2, i2[11] *= t2, i2;
          }
          getCameraToClipPerspective(e2, t2, i2, r2) {
            const n2 = new Float64Array(16);
            return xu.perspective(n2, e2, t2, i2, r2), n2;
          }
          getCameraToClipOrthographic(e2, t2, i2, r2, n2, o2) {
            const s2 = new Float64Array(16);
            return xu.ortho(s2, e2, t2, i2, r2, n2, o2), s2;
          }
          getDistanceToElevation(e2, t2 = false) {
            const i2 = 0 === e2 ? 0 : Zd(e2, t2 ? Hd(this.position[1]) : this.position[1]), r2 = this.forward();
            return (i2 - this.position[2]) / r2[2];
          }
          clone() {
            return new jx([...this.position], [...this.orientation]);
          }
        }
        function Gx(e2, t2) {
          const i2 = Zx(e2.projection, e2.zoom, e2.width, e2.height), r2 = function(e3, t3, i3, r3, n3) {
            const o2 = new Nd(i3.lng - 180 * $x, i3.lat), s2 = new Nd(i3.lng + 180 * $x, i3.lat), a2 = e3.project(o2.lng, o2.lat), l2 = e3.project(s2.lng, s2.lat), c2 = -Math.atan2(l2.y - a2.y, l2.x - a2.x), h2 = ep.fromLngLat(i3);
            h2.y = z(h2.y, -1 + $x, 1 - $x);
            const u2 = h2.toLngLat(), d2 = e3.project(u2.lng, u2.lat), p2 = ep.fromLngLat(u2);
            p2.x += $x;
            const f2 = p2.toLngLat(), m2 = e3.project(f2.lng, f2.lat), _2 = Wx(m2.x - d2.x, m2.y - d2.y, c2), g2 = ep.fromLngLat(u2);
            g2.y += $x;
            const y2 = g2.toLngLat(), x2 = e3.project(y2.lng, y2.lat), v2 = Wx(x2.x - d2.x, x2.y - d2.y, c2), b2 = Math.abs(_2.x) / Math.abs(v2.y), w2 = xu.identity([]);
            xu.rotateZ(w2, w2, -c2 * (1 - (n3 ? 0 : r3)));
            const T2 = xu.identity([]);
            return xu.scale(T2, T2, [1, 1 - (1 - b2) * r3, 1]), T2[4] = -v2.x / v2.y * r3, xu.rotateZ(T2, T2, c2), xu.multiply(T2, w2, T2), T2;
          }(e2.projection, 0, e2.center, i2, t2), n2 = qx(e2);
          return xu.scale(r2, r2, [n2, n2, 1]), r2;
        }
        function qx(e2) {
          const t2 = e2.projection, i2 = Zx(e2.projection, e2.zoom, e2.width, e2.height), r2 = Hx(t2, e2.center), n2 = Hx(t2, Nd.convert(t2.center));
          return Math.pow(2, r2 * i2 + (1 - i2) * n2);
        }
        function Zx(e2, t2, i2, r2, n2 = 1 / 0) {
          const o2 = e2.range;
          if (!o2)
            return 0;
          const s2 = Math.min(n2, Math.max(i2, r2)), a2 = Math.log(s2 / 1024) / Math.LN2;
          return D(o2[0] + a2, o2[1] + a2, t2);
        }
        const $x = 1 / 4e4;
        function Hx(e2, t2) {
          const i2 = z(t2.lat, -Xd, Xd), r2 = new Nd(t2.lng - 180 * $x, i2), n2 = new Nd(t2.lng + 180 * $x, i2), o2 = e2.project(r2.lng, i2), s2 = e2.project(n2.lng, i2), a2 = ep.fromLngLat(r2), l2 = ep.fromLngLat(n2), c2 = s2.x - o2.x, h2 = s2.y - o2.y, u2 = l2.x - a2.x, d2 = l2.y - a2.y, p2 = Math.sqrt((u2 * u2 + d2 * d2) / (c2 * c2 + h2 * h2));
          return Math.log(p2) / Math.LN2;
        }
        function Wx(e2, t2, i2) {
          const r2 = Math.cos(i2), n2 = Math.sin(i2);
          return { x: e2 * r2 - t2 * n2, y: e2 * n2 + t2 * r2 };
        }
        function Xx(e2, t2, i2) {
          return t2 * (sr / (e2.tileSize * Math.pow(2, i2 - e2.tileID.overscaledZ)));
        }
        const Yx = { unknown: 0, flipRequired: 1, flipNotRequired: 2 }, Kx = Math.tan(85 * Math.PI / 180);
        function Jx(e2, t2, i2, r2, n2, o2, s2) {
          const a2 = xu.create();
          if (i2)
            if ("globe" === o2.name) {
              const e3 = function(e4, t3) {
                const { x: i3, y: r3 } = e4.point, n3 = Td(i3, r3, e4.worldSize / e4._pixelsPerMercatorPixel, 0, 0);
                return xu.multiply(n3, n3, vd(ad(t3)));
              }(n2, t2);
              xu.multiply(a2, a2, e3);
            } else {
              const e3 = fu.invert([], s2);
              a2[0] = e3[0], a2[1] = e3[1], a2[4] = e3[2], a2[5] = e3[3], r2 || xu.rotateZ(a2, a2, n2.angle);
            }
          else
            xu.multiply(a2, n2.labelPlaneMatrix, e2);
          return a2;
        }
        function Qx(e2, t2, i2, r2, n2, o2, s2) {
          const a2 = Jx(e2, t2, i2, r2, n2, o2, s2);
          return "globe" === o2.name && i2 || (a2[2] = a2[6] = a2[10] = a2[14] = 0), a2;
        }
        function ev(e2, t2, i2, r2, n2, o2, s2) {
          if (i2) {
            if ("globe" === o2.name) {
              const a2 = Jx(e2, t2, i2, r2, n2, o2, s2);
              return xu.invert(a2, a2), xu.multiply(a2, e2, a2), a2;
            }
            {
              const t3 = xu.clone(e2), i3 = xu.identity([]);
              return i3[0] = s2[0], i3[1] = s2[1], i3[4] = s2[2], i3[5] = s2[3], xu.multiply(t3, t3, i3), r2 || xu.rotateZ(t3, t3, -n2.angle), t3;
            }
          }
          return n2.glCoordMatrix;
        }
        function tv(e2, t2, i2, r2) {
          const n2 = [e2, t2, i2, 1];
          i2 ? uu.transformMat4(n2, n2, r2) : dv(n2, n2, r2);
          const o2 = n2[3];
          return n2[0] /= o2, n2[1] /= o2, n2[2] /= o2, n2;
        }
        function iv(e2, t2) {
          return Math.min(0.5 + e2 / t2 * 0.5, 1.5);
        }
        function rv(e2, t2) {
          const i2 = e2[0] / e2[3], r2 = e2[1] / e2[3];
          return i2 >= -t2[0] && i2 <= t2[0] && r2 >= -t2[1] && r2 <= t2[1];
        }
        function nv(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2) {
          const h2 = i2.transform, u2 = r2 ? e2.textSizeData : e2.iconSizeData, d2 = a_(u2, i2.transform.zoom), p2 = "globe" === h2.projection.name, f2 = [256 / i2.width * 2 + 1, 256 / i2.height * 2 + 1], m2 = r2 ? e2.text.dynamicLayoutVertexArray : e2.icon.dynamicLayoutVertexArray;
          m2.clear();
          let _2 = null;
          p2 && (_2 = r2 ? e2.text.globeExtVertexArray : e2.icon.globeExtVertexArray);
          const g2 = e2.lineVertexArray, x2 = r2 ? e2.text.placedSymbolArray : e2.icon.placedSymbolArray, v2 = i2.transform.width / i2.transform.height;
          let b2, w2 = false;
          for (let r3 = 0; r3 < x2.length; r3++) {
            const p3 = x2.get(r3), { numGlyphs: T2, writingMode: E2 } = p3;
            if (E2 !== w_.vertical || w2 || b2 === w_.horizontal || (w2 = true), b2 = E2, (p3.hidden || E2 === w_.vertical) && !w2) {
              uv(T2, m2);
              continue;
            }
            w2 = false;
            const M2 = new y(p3.tileAnchorX, p3.tileAnchorY);
            let { x: A2, y: S2, z: I2 } = h2.projection.projectTilePoint(M2.x, M2.y, c2.canonical);
            if (l2) {
              const [e3, t3, i3] = l2(M2);
              A2 += e3, S2 += t3, I2 += i3;
            }
            const C2 = [A2, S2, I2, 1];
            if (uu.transformMat4(C2, C2, t2), !rv(C2, f2)) {
              uv(T2, m2);
              continue;
            }
            const z2 = C2[3], D2 = iv(i2.transform.getCameraToCenterDistance(h2.projection), z2), P2 = s_(u2, d2, p3), R2 = s2 ? P2 / D2 : P2 * D2, L2 = tv(A2, S2, I2, n2);
            if (L2[3] <= 0) {
              uv(T2, m2);
              continue;
            }
            let k2 = {};
            const O2 = s2 ? null : l2, B2 = av(p3, R2, false, a2, t2, n2, o2, e2.glyphOffsetArray, g2, m2, _2, L2, M2, k2, v2, O2, h2.projection, c2, s2);
            w2 = B2.useVertical, O2 && B2.needsFlipping && (k2 = {}), (B2.notEnoughRoom || w2 || B2.needsFlipping && av(p3, R2, true, a2, t2, n2, o2, e2.glyphOffsetArray, g2, m2, _2, L2, M2, k2, v2, O2, h2.projection, c2, s2).notEnoughRoom) && uv(T2, m2);
          }
          r2 ? (e2.text.dynamicLayoutVertexBuffer.updateData(m2), _2 && e2.text.globeExtVertexBuffer && e2.text.globeExtVertexBuffer.updateData(_2)) : (e2.icon.dynamicLayoutVertexBuffer.updateData(m2), _2 && e2.icon.globeExtVertexBuffer && e2.icon.globeExtVertexBuffer.updateData(_2));
        }
        function ov(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2) {
          const { lineStartIndex: _2, glyphStartIndex: g2, segment: y2 } = a2, x2 = g2 + a2.numGlyphs, v2 = _2 + a2.lineLength, b2 = t2.getoffsetX(g2), w2 = t2.getoffsetX(x2 - 1), T2 = hv(e2 * b2, i2, r2, n2, o2, s2, y2, _2, v2, l2, c2, h2, u2, d2, true, p2, f2, m2);
          if (!T2)
            return null;
          const E2 = hv(e2 * w2, i2, r2, n2, o2, s2, y2, _2, v2, l2, c2, h2, u2, d2, true, p2, f2, m2);
          return E2 ? { first: T2, last: E2 } : null;
        }
        function sv(e2, t2, i2, r2) {
          return e2 === w_.horizontal && Math.abs(r2) > Math.abs(i2) ? { useVertical: true } : e2 === w_.vertical ? r2 > 0 ? { needsFlipping: true } : null : t2 !== Yx.unknown && function(e3, t3) {
            return 0 === e3 || Math.abs(t3 / e3) > Kx;
          }(i2, r2) ? t2 === Yx.flipRequired ? { needsFlipping: true } : null : i2 < 0 ? { needsFlipping: true } : null;
        }
        function av(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2, x2) {
          const v2 = t2 / 24, b2 = e2.lineOffsetX * v2, w2 = e2.lineOffsetY * v2, { lineStartIndex: T2, glyphStartIndex: E2, numGlyphs: M2, segment: A2, writingMode: S2, flipState: I2 } = e2, C2 = T2 + e2.lineLength, z2 = (e3) => {
            if (h2) {
              const [t4, i4, r4] = e3.up, n3 = c2.length;
              ry(h2, n3 + 0, t4, i4, r4), ry(h2, n3 + 1, t4, i4, r4), ry(h2, n3 + 2, t4, i4, r4), ry(h2, n3 + 3, t4, i4, r4);
            }
            const [t3, i3, r3] = e3.point;
            ny(c2, t3, i3, r3, e3.angle);
          };
          if (M2 > 1) {
            const t3 = ov(v2, a2, b2, w2, i2, u2, d2, e2, l2, o2, p2, m2, false, _2, g2, x2);
            if (!t3)
              return { notEnoughRoom: true };
            if (r2 && !i2) {
              let [i3, r3, n3] = t3.first.point, [o3, a3, l3] = t3.last.point;
              [i3, r3] = tv(i3, r3, n3, s2), [o3, a3] = tv(o3, a3, l3, s2);
              const c3 = sv(S2, I2, (o3 - i3) * f2, a3 - r3);
              if (e2.flipState = c3 && c3.needsFlipping ? Yx.flipRequired : Yx.flipNotRequired, c3)
                return c3;
            }
            z2(t3.first);
            for (let e3 = E2 + 1; e3 < E2 + M2 - 1; e3++) {
              const t4 = hv(v2 * a2.getoffsetX(e3), b2, w2, i2, u2, d2, A2, T2, C2, l2, o2, p2, m2, false, false, _2, g2, x2);
              if (!t4)
                return c2.length -= 4 * (e3 - E2), { notEnoughRoom: true };
              z2(t4);
            }
            z2(t3.last);
          } else {
            if (r2 && !i2) {
              const t4 = tv(d2.x, d2.y, 0, n2), i3 = T2 + A2 + 1, r3 = new y(l2.getx(i3), l2.gety(i3)), o3 = tv(r3.x, r3.y, 0, n2), s3 = o3[3] > 0 ? o3 : cv(d2, r3, t4, 1, n2, void 0, _2, g2.canonical), a3 = sv(S2, I2, (s3[0] - t4[0]) * f2, s3[1] - t4[1]);
              if (e2.flipState = a3 && a3.needsFlipping ? Yx.flipRequired : Yx.flipNotRequired, a3)
                return a3;
            }
            const t3 = hv(v2 * a2.getoffsetX(E2), b2, w2, i2, u2, d2, A2, T2, C2, l2, o2, p2, m2, false, false, _2, g2, x2);
            if (!t3)
              return { notEnoughRoom: true };
            z2(t3);
          }
          return {};
        }
        function lv(e2, t2, i2, r2, n2) {
          const { x: o2, y: s2, z: a2 } = r2.projectTilePoint(e2.x, e2.y, t2);
          if (!n2)
            return tv(o2, s2, a2, i2);
          const [l2, c2, h2] = n2(e2);
          return tv(o2 + l2, s2 + c2, a2 + h2, i2);
        }
        function cv(e2, t2, i2, r2, n2, o2, s2, a2) {
          const l2 = lv(e2.sub(t2)._unit()._add(e2), a2, n2, s2, o2);
          return Mu.sub(l2, i2, l2), Mu.normalize(l2, l2), Mu.scaleAndAdd(l2, i2, l2, r2);
        }
        function hv(e2, t2, i2, r2, n2, o2, s2, a2, l2, c2, h2, u2, d2, p2, f2, m2, _2, g2) {
          const x2 = r2 ? e2 - t2 : e2 + t2;
          let v2 = x2 > 0 ? 1 : -1, b2 = 0;
          r2 && (v2 *= -1, b2 = Math.PI), v2 < 0 && (b2 += Math.PI);
          let w2 = a2 + s2 + (v2 > 0 ? 0 : 1) | 0, T2 = n2, E2 = n2, M2 = 0, A2 = 0;
          const S2 = Math.abs(x2), I2 = [], C2 = [];
          let z2 = o2, D2 = z2;
          const P2 = () => cv(D2, z2, E2, S2 - M2 + 1, h2, d2, m2, _2.canonical);
          for (; M2 + A2 <= S2; ) {
            if (w2 += v2, w2 < a2 || w2 >= l2)
              return null;
            if (E2 = T2, D2 = z2, I2.push(E2), p2 && C2.push(D2), z2 = new y(c2.getx(w2), c2.gety(w2)), T2 = u2[w2], !T2) {
              const e3 = lv(z2, _2.canonical, h2, m2, d2);
              T2 = e3[3] > 0 ? u2[w2] = e3 : P2();
            }
            M2 += A2, A2 = Mu.distance(E2, T2);
          }
          f2 && d2 && (u2[w2] && (T2 = P2(), A2 = Mu.distance(E2, T2)), u2[w2] = T2);
          const R2 = (S2 - M2) / A2, L2 = z2.sub(D2)._mult(R2)._add(D2), k2 = Mu.sub([], T2, E2), O2 = Mu.scaleAndAdd([], E2, k2, R2);
          let B2 = [0, 0, 1], F2 = k2[0], N2 = k2[1];
          if (g2 && (B2 = m2.upVector(_2.canonical, L2.x, L2.y), 0 !== B2[0] || 0 !== B2[1] || 1 !== B2[2])) {
            const e3 = [B2[2], 0, -B2[0]], t3 = Mu.cross([], B2, e3);
            Mu.normalize(e3, e3), Mu.normalize(t3, t3), F2 = Mu.dot(k2, e3), N2 = Mu.dot(k2, t3);
          }
          if (i2) {
            const e3 = Mu.cross([], B2, k2);
            Mu.normalize(e3, e3), Mu.scaleAndAdd(O2, O2, e3, i2 * v2);
          }
          const U2 = b2 + Math.atan2(N2, F2);
          return I2.push(O2), p2 && C2.push(L2), { point: O2, angle: U2, path: I2, tilePath: C2, up: B2 };
        }
        function uv(e2, t2) {
          const i2 = t2.length, r2 = i2 + 4 * e2;
          t2.resize(r2), t2.float32.fill(-1 / 0, 4 * i2, 4 * r2);
        }
        function dv(e2, t2, i2) {
          const r2 = t2[0], n2 = t2[1];
          return e2[0] = i2[0] * r2 + i2[4] * n2 + i2[12], e2[1] = i2[1] * r2 + i2[5] * n2 + i2[13], e2[3] = i2[3] * r2 + i2[7] * n2 + i2[15], e2;
        }
        const pv = (e2, t2, i2) => (1 - i2) * e2 + i2 * t2, fv = (e2) => e2 * e2 * e2 * e2 * e2;
        class mv {
          constructor(e2, t2, i2, r2, n2, o2, s2) {
            this.tileSize = 512, this._renderWorldCopies = void 0 === n2 || n2, this._minZoom = e2 || 0, this._maxZoom = t2 || 22, this._minPitch = null == i2 ? 0 : i2, this._maxPitch = null == r2 ? 60 : r2, this.setProjection(o2), this.setMaxBounds(s2), this.width = 0, this.height = 0, this._center = new Nd(0, 0), this.zoom = 0, this.angle = 0, this._fov = 0.6435011087932844, this._pitch = 0, this._nearZ = 0, this._farZ = 0, this._unmodified = true, this._edgeInsets = new Bx(), this._projMatrixCache = {}, this._alignedProjMatrixCache = {}, this._fogTileMatrixCache = {}, this._distanceTileDataCache = {}, this._camera = new jx(), this._centerAltitude = 0, this._averageElevation = 0, this.cameraElevationReference = "ground", this._pixelsPerMercatorPixel = 1, this.globeRadius = 0, this.globeCenterInViewSpace = [0, 0, 0], this._horizonShift = 0.1, this._orthographicProjectionAtLowPitch = false;
          }
          clone() {
            const e2 = new mv(this._minZoom, this._maxZoom, this._minPitch, this.maxPitch, this._renderWorldCopies, this.getProjection());
            return e2._elevation = this._elevation, e2._centerAltitude = this._centerAltitude, e2._centerAltitudeValidForExaggeration = this._centerAltitudeValidForExaggeration, e2.tileSize = this.tileSize, e2.mercatorFromTransition = this.mercatorFromTransition, e2.width = this.width, e2.height = this.height, e2.cameraElevationReference = this.cameraElevationReference, e2._center = this._center, e2._setZoom(this.zoom), e2._seaLevelZoom = this._seaLevelZoom, e2.angle = this.angle, e2._fov = this._fov, e2._pitch = this._pitch, e2._nearZ = this._nearZ, e2._farZ = this._farZ, e2._averageElevation = this._averageElevation, e2._unmodified = this._unmodified, e2._edgeInsets = this._edgeInsets.clone(), e2._camera = this._camera.clone(), e2._calcMatrices(), e2.freezeTileCoverage = this.freezeTileCoverage, e2.frustumCorners = this.frustumCorners, e2;
          }
          get isOrthographic() {
            return "globe" !== this.projection.name && this._orthographicProjectionAtLowPitch && this.pitch < 15;
          }
          get elevation() {
            return this._elevation;
          }
          set elevation(e2) {
            this._elevation !== e2 && (this._elevation = e2, this._updateCameraOnTerrain(), this._calcMatrices());
          }
          get depthOcclusionForSymbolsAndCircles() {
            return "globe" !== this.projection.name && !this.isOrthographic;
          }
          updateElevation(e2, t2 = false) {
            const i2 = this._elevation && this._elevation.exaggeration() !== this._centerAltitudeValidForExaggeration;
            (null == this._seaLevelZoom || i2) && this._updateCameraOnTerrain(), (e2 || i2) && this._constrainCamera(t2), this._calcMatrices();
          }
          getProjection() {
            return O(this.projection, ["name", "center", "parallels"]);
          }
          setProjection(e2) {
            this.projectionOptions = e2 || { name: "mercator" };
            const t2 = this.projection ? this.getProjection() : void 0;
            this.projection = Hg(this.projectionOptions);
            const i2 = !x(t2, this.getProjection());
            return i2 && this._calcMatrices(), this.mercatorFromTransition = false, i2;
          }
          setOrthographicProjectionAtLowPitch(e2) {
            return this._orthographicProjectionAtLowPitch !== e2 && (this._orthographicProjectionAtLowPitch = e2, this._calcMatrices(), true);
          }
          setMercatorFromTransition() {
            const e2 = this.projection.name;
            this.mercatorFromTransition = true, this.projectionOptions = { name: "mercator" }, this.projection = Hg({ name: "mercator" });
            const t2 = e2 !== this.projection.name;
            return t2 && this._calcMatrices(), t2;
          }
          get minZoom() {
            return this._minZoom;
          }
          set minZoom(e2) {
            this._minZoom !== e2 && (this._minZoom = e2, this.zoom = Math.max(this.zoom, e2));
          }
          get maxZoom() {
            return this._maxZoom;
          }
          set maxZoom(e2) {
            this._maxZoom !== e2 && (this._maxZoom = e2, this.zoom = Math.min(this.zoom, e2));
          }
          get minPitch() {
            return this._minPitch;
          }
          set minPitch(e2) {
            this._minPitch !== e2 && (this._minPitch = e2, this.pitch = Math.max(this.pitch, e2));
          }
          get maxPitch() {
            return this._maxPitch;
          }
          set maxPitch(e2) {
            this._maxPitch !== e2 && (this._maxPitch = e2, this.pitch = Math.min(this.pitch, e2));
          }
          get renderWorldCopies() {
            return this._renderWorldCopies && true === this.projection.supportsWorldCopies;
          }
          set renderWorldCopies(e2) {
            void 0 === e2 ? e2 = true : null === e2 && (e2 = false), this._renderWorldCopies = e2;
          }
          get worldSize() {
            return this.tileSize * this.scale;
          }
          get cameraWorldSizeForFog() {
            const e2 = Math.max(this._camera.getDistanceToElevation(this._averageElevation), Number.EPSILON);
            return this._worldSizeFromZoom(this._zoomFromMercatorZ(e2));
          }
          get cameraWorldSize() {
            const e2 = Math.max(this._camera.getDistanceToElevation(this._averageElevation, true), Number.EPSILON);
            return this._worldSizeFromZoom(this._zoomFromMercatorZ(e2));
          }
          get pixelsPerMeter() {
            return this.projection.pixelsPerMeter(this.center.lat, this.worldSize);
          }
          get cameraPixelsPerMeter() {
            return Zd(1, this.center.lat) * this.cameraWorldSizeForFog;
          }
          get centerOffset() {
            return this.centerPoint._sub(this.size._div(2));
          }
          get size() {
            return new y(this.width, this.height);
          }
          get bearing() {
            return P(this.rotation, -180, 180);
          }
          set bearing(e2) {
            this.rotation = e2;
          }
          get rotation() {
            return -this.angle / Math.PI * 180;
          }
          set rotation(e2) {
            const t2 = -e2 * Math.PI / 180;
            this.angle !== t2 && (this._unmodified = false, this.angle = t2, this._calcMatrices(), this.rotationMatrix = fu.create(), fu.rotate(this.rotationMatrix, this.rotationMatrix, this.angle));
          }
          get pitch() {
            return this._pitch / Math.PI * 180;
          }
          set pitch(e2) {
            const t2 = z(e2, this.minPitch, this.maxPitch) / 180 * Math.PI;
            this._pitch !== t2 && (this._unmodified = false, this._pitch = t2, this._calcMatrices());
          }
          get aspect() {
            return this.width / this.height;
          }
          get fov() {
            return this._fov / Math.PI * 180;
          }
          get fovX() {
            return this._fov;
          }
          get fovY() {
            const e2 = 1 / Math.tan(0.5 * this.fovX);
            return 2 * Math.atan(1 / this.aspect / e2);
          }
          set fov(e2) {
            e2 = Math.max(0.01, Math.min(60, e2)), this._fov !== e2 && (this._unmodified = false, this._fov = w(e2), this._calcMatrices());
          }
          get averageElevation() {
            return this._averageElevation;
          }
          set averageElevation(e2) {
            this._averageElevation = e2, this._calcFogMatrices(), this._distanceTileDataCache = {};
          }
          get zoom() {
            return this._zoom;
          }
          set zoom(e2) {
            const t2 = Math.min(Math.max(e2, this.minZoom), this.maxZoom);
            this._zoom !== t2 && (this._unmodified = false, this._setZoom(t2), this._updateSeaLevelZoom(), this._constrain(), this._calcMatrices());
          }
          _setZoom(e2) {
            this._zoom = e2, this.scale = this.zoomScale(e2), this.tileZoom = Math.floor(e2), this.zoomFraction = e2 - this.tileZoom;
          }
          _updateCameraOnTerrain() {
            const e2 = this.elevation ? this.elevation.getAtPoint(this.locationCoordinate(this.center), Number.NEGATIVE_INFINITY) : Number.NEGATIVE_INFINITY, t2 = this.elevation && e2 === Number.NEGATIVE_INFINITY && this.elevation.visibleDemTiles.length > 0 && this.elevation.exaggeration() > 0 && this._centerAltitudeValidForExaggeration;
            if (!this._elevation || e2 === Number.NEGATIVE_INFINITY && (!t2 || !this._centerAltitude))
              return this._centerAltitude = 0, this._seaLevelZoom = null, void (this._centerAltitudeValidForExaggeration = void 0);
            const i2 = this._elevation;
            t2 || this._centerAltitude && this._centerAltitudeValidForExaggeration && i2.exaggeration() && this._centerAltitudeValidForExaggeration !== i2.exaggeration() ? (this._centerAltitude = this._centerAltitude / this._centerAltitudeValidForExaggeration * i2.exaggeration(), this._centerAltitudeValidForExaggeration = i2.exaggeration()) : (this._centerAltitude = e2 || 0, this._centerAltitudeValidForExaggeration = i2.exaggeration()), this._updateSeaLevelZoom();
          }
          _updateSeaLevelZoom() {
            void 0 !== this._centerAltitudeValidForExaggeration && (this._seaLevelZoom = this._zoomFromMercatorZ((this.pixelsPerMeter * this._centerAltitude + this.cameraToCenterDistance) / this.worldSize));
          }
          sampleAverageElevation() {
            if (!this._elevation)
              return 0;
            const e2 = this._elevation, t2 = [[0.5, 0.2], [0.3, 0.5], [0.5, 0.5], [0.7, 0.5], [0.5, 0.8]], i2 = this.horizonLineFromTop();
            let r2 = 0, n2 = 0;
            for (let o2 = 0; o2 < t2.length; o2++) {
              const s2 = new y(t2[o2][0] * this.width, i2 + t2[o2][1] * (this.height - i2)), a2 = e2.pointCoordinate(s2);
              if (!a2)
                continue;
              const l2 = 1 / Math.hypot(a2[0] - this._camera.position[0], a2[1] - this._camera.position[1]);
              r2 += a2[3] * l2, n2 += l2;
            }
            return 0 === n2 ? NaN : r2 / n2;
          }
          get center() {
            return this._center;
          }
          set center(e2) {
            e2.lat === this._center.lat && e2.lng === this._center.lng || (this._unmodified = false, this._center = e2, this._terrainEnabled() && ("ground" === this.cameraElevationReference ? this._updateCameraOnTerrain() : this._updateZoomFromElevation()), this._constrain(), this._calcMatrices());
          }
          _updateZoomFromElevation() {
            if (null == this._seaLevelZoom || !this._elevation)
              return;
            const e2 = this._seaLevelZoom, t2 = this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)), i2 = this.pixelsPerMeter / this.worldSize * t2, r2 = this._mercatorZfromZoom(e2), n2 = this._mercatorZfromZoom(this._maxZoom), o2 = Math.max(r2 - i2, n2);
            this._setZoom(this._zoomFromMercatorZ(o2));
          }
          get padding() {
            return this._edgeInsets.toJSON();
          }
          set padding(e2) {
            this._edgeInsets.equals(e2) || (this._unmodified = false, this._edgeInsets.interpolate(this._edgeInsets, e2, 1), this._calcMatrices());
          }
          computeZoomRelativeTo(e2) {
            const t2 = this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint, e2.toAltitude()));
            let i2;
            i2 = e2.z < this._camera.position[2] ? [t2.x, t2.y, t2.z] : [e2.x, e2.y, e2.z];
            const r2 = Mu.length(Mu.sub([], this._camera.position, i2));
            return z(this._zoomFromMercatorZ(r2), this._minZoom, this._maxZoom);
          }
          setFreeCameraOptions(e2) {
            if (!this.height)
              return;
            if (!e2.position && !e2.orientation)
              return;
            this._updateCameraState();
            let t2 = false;
            if (e2.orientation && !bu.exactEquals(e2.orientation, this._camera.orientation) && (t2 = this._setCameraOrientation(e2.orientation)), e2.position) {
              const i2 = [e2.position.x, e2.position.y, e2.position.z];
              Mu.exactEquals(i2, this._camera.position) || (this._setCameraPosition(i2), t2 = true);
            }
            t2 && (this._updateStateFromCamera(), this.recenterOnTerrain());
          }
          getFreeCameraOptions() {
            this._updateCameraState();
            const e2 = this._camera.position, t2 = new Vx();
            return t2.position = new ep(e2[0], e2[1], e2[2]), t2.orientation = this._camera.orientation, t2._elevation = this.elevation, t2._renderWorldCopies = this.renderWorldCopies, t2;
          }
          _setCameraOrientation(e2) {
            if (!bu.length(e2))
              return false;
            bu.normalize(e2, e2);
            const t2 = Mu.transformQuat([], [0, 0, -1], e2), i2 = Mu.transformQuat([], [0, -1, 0], e2);
            if (i2[2] < 0)
              return false;
            const r2 = Ux(t2, i2);
            return !!r2 && (this._camera.orientation = r2, true);
          }
          _setCameraPosition(e2) {
            const t2 = this.zoomScale(this.minZoom) * this.tileSize, i2 = this.zoomScale(this.maxZoom) * this.tileSize, r2 = this.cameraToCenterDistance;
            e2[2] = z(e2[2], r2 / i2, r2 / t2), this._camera.position = e2;
          }
          get centerPoint() {
            return this._edgeInsets.getCenter(this.width, this.height);
          }
          get fovAboveCenter() {
            return this._fov * (0.5 + this.centerOffset.y / this.height);
          }
          isPaddingEqual(e2) {
            return this._edgeInsets.equals(e2);
          }
          interpolatePadding(e2, t2, i2) {
            this._unmodified = false, this._edgeInsets.interpolate(e2, t2, i2), this._constrain(), this._calcMatrices();
          }
          coveringZoomLevel(e2) {
            const t2 = (e2.roundZoom ? Math.round : Math.floor)(this.zoom + this.scaleZoom(this.tileSize / e2.tileSize));
            return Math.max(0, t2);
          }
          getVisibleUnwrappedCoordinates(e2) {
            const t2 = [new Ou(0, e2)];
            if (this.renderWorldCopies) {
              const i2 = this.pointCoordinate(new y(0, 0)), r2 = this.pointCoordinate(new y(this.width, 0)), n2 = this.pointCoordinate(new y(this.width, this.height)), o2 = this.pointCoordinate(new y(0, this.height)), s2 = Math.floor(Math.min(i2.x, r2.x, n2.x, o2.x)), a2 = Math.floor(Math.max(i2.x, r2.x, n2.x, o2.x)), l2 = 1;
              for (let i3 = s2 - l2; i3 <= a2 + l2; i3++)
                0 !== i3 && t2.push(new Ou(i3, e2));
            }
            return t2;
          }
          isLODDisabled(e2) {
            return (!e2 || this.pitch <= 60) && this._edgeInsets.top <= this._edgeInsets.bottom && !this._elevation && !this.projection.isReprojectedInTileSpace;
          }
          extendTileCoverForShadows(e2, t2, i2) {
            let r2 = [];
            if (0 === t2[0] && 0 === t2[1])
              return r2;
            for (const i3 of e2) {
              const e3 = i3.canonical, n3 = i3.overscaledZ, o2 = i3.wrap, s2 = 1 << e3.z, a2 = e3.x + 1 < s2, l2 = e3.x > 0, c2 = e3.y + 1 < s2, h2 = e3.y > 0, u2 = i3.wrap - (l2 ? 0 : 1), d2 = i3.wrap + (a2 ? 0 : 1), p2 = l2 ? e3.x - 1 : s2 - 1, f2 = a2 ? e3.x + 1 : 0;
              t2[0] < 0 ? (r2.push(new Bu(n3, d2, e3.z, f2, e3.y)), t2[1] < 0 && c2 && (r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y + 1)), r2.push(new Bu(n3, d2, e3.z, f2, e3.y + 1))), t2[1] > 0 && h2 && (r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y - 1)), r2.push(new Bu(n3, d2, e3.z, f2, e3.y - 1)))) : t2[0] > 0 ? (r2.push(new Bu(n3, u2, e3.z, p2, e3.y)), t2[1] < 0 && c2 && (r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y + 1)), r2.push(new Bu(n3, u2, e3.z, p2, e3.y + 1))), t2[1] > 0 && h2 && (r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y - 1)), r2.push(new Bu(n3, u2, e3.z, p2, e3.y - 1)))) : t2[1] < 0 && c2 ? r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y + 1)) : h2 && r2.push(new Bu(n3, o2, e3.z, e3.x, e3.y - 1));
            }
            if (r2.length > 1) {
              r2.sort((e4, t4) => e4.overscaledZ - t4.overscaledZ || e4.wrap - t4.wrap || e4.canonical.z - t4.canonical.z || e4.canonical.x - t4.canonical.x || e4.canonical.y - t4.canonical.y);
              let e3 = 0, t3 = 0;
              for (; t3 < r2.length; )
                r2[t3].equals(r2[e3]) ? ++t3 : r2[++e3] = r2[t3++];
              r2.length = e3 + 1;
            }
            const n2 = [];
            for (const e3 of r2)
              r2.some((t3) => e3.isChildOf(t3)) || n2.push(e3);
            return r2 = n2.filter((t3) => !e2.some((e3) => !!(t3.overscaledZ < i2 && e3.isChildOf(t3)) || t3.equals(e3) || t3.isChildOf(e3))), r2;
          }
          coveringTiles(e2) {
            let t2 = this.coveringZoomLevel(e2);
            const i2 = t2, r2 = this.elevation && this.elevation.exaggeration(), n2 = r2 && !e2.isTerrainDEM, o2 = "mercator" === this.projection.name;
            if (void 0 !== e2.minzoom && t2 < e2.minzoom)
              return [];
            void 0 !== e2.maxzoom && t2 > e2.maxzoom && (t2 = e2.maxzoom);
            const s2 = this.locationCoordinate(this.center), a2 = this.center.lat, l2 = 1 << t2, c2 = [l2 * s2.x, l2 * s2.y, 0], h2 = "globe" === this.projection.name, u2 = !h2, d2 = $u.fromInvProjectionMatrix(this.invProjMatrix, this.worldSize, t2, u2), p2 = h2 ? this._camera.mercatorPosition : this.pointCoordinate(this.getCameraPoint()), f2 = l2 * Zd(1, this.center.lat), m2 = this._camera.position[2] / Zd(1, this.center.lat), _2 = [l2 * p2.x, l2 * p2.y, m2 * (u2 ? 1 : f2)], g2 = h2 || r2, y2 = this.cameraToCenterDistance / e2.tileSize * (e2.roundZoom ? 1 : 0.502), x2 = this.isLODDisabled(true) ? t2 : 0, v2 = e2.isTerrainDEM && this._elevation ? 1e4 * this._elevation.exaggeration() : this._centerAltitude, b2 = e2.isTerrainDEM ? -v2 : this._elevation ? this._elevation.getMinElevationBelowMSL() : 0, w2 = this.projection.isReprojectedInTileSpace ? qx(this) : 1, T2 = (e3) => {
              const t3 = 1 / 4e4, i3 = new ep(e3.x + t3, e3.y, e3.z), r3 = new ep(e3.x, e3.y + t3, e3.z), n3 = e3.toLngLat(), o3 = i3.toLngLat(), s3 = r3.toLngLat(), a3 = this.locationCoordinate(n3), l3 = this.locationCoordinate(o3), c3 = this.locationCoordinate(s3), h3 = Math.hypot(l3.x - a3.x, l3.y - a3.y), u3 = Math.hypot(c3.x - a3.x, c3.y - a3.y);
              return Math.sqrt(h3 * u3) * w2 / t3;
            }, M2 = (e3) => {
              const t3 = v2, i3 = b2;
              return { aabb: Eg(this, l2, 0, 0, 0, e3, i3, t3, this.projection), zoom: 0, x: 0, y: 0, minZ: i3, maxZ: t3, wrap: e3, fullyVisible: false };
            }, A2 = [];
            let S2 = [];
            const I2 = t2, C2 = e2.reparseOverscaled ? i2 : t2, z2 = (e3) => e3 * e3, D2 = z2((m2 - this._centerAltitude) * f2), P2 = (e3) => {
              if (!this._elevation || !e3.tileID || !o2)
                return;
              const t3 = this._elevation.getMinMaxForTile(e3.tileID), i3 = e3.aabb;
              t3 ? (i3.min[2] = t3.min, i3.max[2] = t3.max, i3.center[2] = (i3.min[2] + i3.max[2]) / 2) : (e3.shouldSplit = R2(e3), e3.shouldSplit || (i3.min[2] = i3.max[2] = i3.center[2] = this._centerAltitude));
            }, R2 = (e3) => {
              if (e3.zoom < x2)
                return true;
              if (e3.zoom === I2)
                return false;
              if (null != e3.shouldSplit)
                return e3.shouldSplit;
              const t3 = e3.aabb.distanceX(_2), r3 = e3.aabb.distanceY(_2);
              let o3 = D2, s3 = 1;
              if (h2) {
                o3 = z2(e3.aabb.distanceZ(_2));
                const t4 = Math.pow(2, e3.zoom), i3 = Hd((e3.y + 1) / t4), r4 = Hd(e3.y / t4), n3 = Math.min(Math.max(a2, i3), r4), l4 = jd(n3) / jd(a2);
                if (s3 = n3 === a2 ? 1 / Math.max(1, this._mercatorScaleRatio - 0.3) : Math.min(1, l4 / this._mercatorScaleRatio), this.zoom <= Wu && e3.zoom === I2 - 1 && l4 >= 0.9)
                  return true;
              } else if (n2 && (o3 = z2(e3.aabb.distanceZ(_2) * f2)), this.projection.isReprojectedInTileSpace && i2 <= 5) {
                const t4 = Math.pow(2, e3.zoom), i3 = T2(new ep((e3.x + 0.5) / t4, (e3.y + 0.5) / t4));
                s3 = i3 > 0.85 ? 1 : i3;
              }
              const l3 = t3 * t3 + r3 * r3 + o3, c3 = z2((1 << I2 - e3.zoom) * y2 * s3 * ((e4, t4) => {
                if (t4 * z2(0.707) < e4)
                  return 1;
                const i3 = Math.sqrt(t4 / e4);
                return i3 / (1.4144271570014144 + (Math.pow(1.1, i3 - 1.4144271570014144 + 1) - 1) / (1.1 - 1) - 1);
              })(Math.max(o3, D2), l3));
              return l3 < c3;
            };
            if (this.renderWorldCopies)
              for (let e3 = 1; e3 <= 3; e3++)
                A2.push(M2(-e3)), A2.push(M2(e3));
            for (A2.push(M2(0)); A2.length > 0; ) {
              const i3 = A2.pop(), r3 = i3.x, s3 = i3.y;
              let a3 = i3.fullyVisible;
              const u3 = () => "globe" === this.projection.name && (0 === i3.y || i3.y === (1 << i3.zoom) - 1);
              if (!a3) {
                let e3 = g2 ? i3.aabb.intersects(d2) : i3.aabb.intersectsFlat(d2);
                if (0 === e3 && u3()) {
                  const t3 = new ku(i3.zoom, r3, s3);
                  e3 = ud(this, l2, t3, true).intersects(d2);
                }
                if (0 === e3)
                  continue;
                a3 = 2 === e3;
              }
              if (i3.zoom !== I2 && R2(i3))
                for (let e3 = 0; e3 < 4; e3++) {
                  const t3 = (r3 << 1) + e3 % 2, c3 = (s3 << 1) + (e3 >> 1), u4 = { aabb: o2 ? i3.aabb.quadrant(e3) : Eg(this, l2, i3.zoom + 1, t3, c3, i3.wrap, i3.minZ, i3.maxZ, this.projection), zoom: i3.zoom + 1, x: t3, y: c3, wrap: i3.wrap, fullyVisible: a3, tileID: void 0, shouldSplit: void 0, minZ: i3.minZ, maxZ: i3.maxZ };
                  n2 && !h2 && (u4.tileID = new Bu(i3.zoom + 1 === I2 ? C2 : i3.zoom + 1, i3.wrap, i3.zoom + 1, t3, c3), P2(u4)), A2.push(u4);
                }
              else {
                const n3 = i3.zoom === I2 ? C2 : i3.zoom;
                if (e2.minzoom && e2.minzoom > n3)
                  continue;
                if (!a3) {
                  let e3 = g2 ? i3.aabb.intersectsPrecise(d2) : i3.aabb.intersectsPreciseFlat(d2);
                  if (0 === e3 && u3()) {
                    const t3 = new ku(i3.zoom, r3, s3);
                    e3 = ud(this, l2, t3, true).intersectsPrecise(d2);
                  }
                  if (0 === e3)
                    continue;
                }
                const o3 = c2[0] - (0.5 + r3 + (i3.wrap << i3.zoom)) * (1 << t2 - i3.zoom), h3 = c2[1] - 0.5 - s3, p3 = i3.tileID ? i3.tileID : new Bu(n3, i3.wrap, i3.zoom, r3, s3);
                S2.push({ tileID: p3, distanceSq: o3 * o3 + h3 * h3 });
              }
            }
            if (this.fogCullDistSq) {
              const t3 = this.fogCullDistSq, i3 = this.horizonLineFromTop();
              S2 = S2.filter((r3) => {
                const n3 = [0, 0, 0, 1], o3 = [sr, sr, 0, 1], s3 = this.calculateFogTileMatrix(r3.tileID.toUnwrapped());
                uu.transformMat4(n3, n3, s3), uu.transformMat4(o3, o3, s3);
                const a3 = function(e3, t4, i4) {
                  let r4 = 0;
                  for (let i5 = 0; i5 < 2; ++i5) {
                    const n4 = 0;
                    e3[i5] > n4 && (r4 += (e3[i5] - n4) * (e3[i5] - n4)), t4[i5] < n4 && (r4 += (n4 - t4[i5]) * (n4 - t4[i5]));
                  }
                  return r4;
                }(uu.min([], n3, o3), uu.max([], n3, o3));
                if (0 === a3)
                  return true;
                let l3 = false;
                const c3 = this._elevation;
                if (c3 && a3 > t3 && 0 !== i3) {
                  const t4 = this.calculateProjMatrix(r3.tileID.toUnwrapped());
                  let n4;
                  e2.isTerrainDEM || (n4 = c3.getMinMaxForTile(r3.tileID)), n4 || (n4 = { min: b2, max: v2 });
                  const o4 = function(e3) {
                    const t5 = Math.round((e3 + 45 + 360) % 360 / 90) % 4;
                    return E[t5];
                  }(this.rotation), s4 = [o4[0] * sr, o4[1] * sr, n4.max];
                  Mu.transformMat4(s4, s4, t4), l3 = (1 - s4[1]) * this.height * 0.5 < i3;
                }
                return a3 < t3 || l3;
              });
            }
            return S2.sort((e3, t3) => e3.distanceSq - t3.distanceSq).map((e3) => e3.tileID);
          }
          resize(e2, t2) {
            this.width = e2, this.height = t2, this.pixelsToGLUnits = [2 / e2, -2 / t2], this._constrain(), this._calcMatrices();
          }
          get unmodified() {
            return this._unmodified;
          }
          zoomScale(e2) {
            return Math.pow(2, e2);
          }
          scaleZoom(e2) {
            return Math.log(e2) / Math.LN2;
          }
          project(e2) {
            const t2 = z(e2.lat, -Xd, Xd), i2 = this.projection.project(e2.lng, t2);
            return new y(i2.x * this.worldSize, i2.y * this.worldSize);
          }
          unproject(e2) {
            return this.projection.unproject(e2.x / this.worldSize, e2.y / this.worldSize);
          }
          get point() {
            return this.project(this.center);
          }
          get pointMerc() {
            return this.point._div(this.worldSize);
          }
          get pixelsPerMeterRatio() {
            return this.pixelsPerMeter / Zd(1, this.center.lat) / this.worldSize;
          }
          setLocationAtPoint(e2, t2) {
            let i2, r2;
            const n2 = this.centerPoint;
            if ("globe" === this.projection.name) {
              const e3 = this.worldSize;
              i2 = (t2.x - n2.x) / e3, r2 = (t2.y - n2.y) / e3;
            } else {
              const e3 = this.pointCoordinate(t2), o3 = this.pointCoordinate(n2);
              i2 = e3.x - o3.x, r2 = e3.y - o3.y;
            }
            const o2 = this.locationCoordinate(e2);
            this.setLocation(new ep(o2.x - i2, o2.y - r2));
          }
          setLocation(e2) {
            this.center = this.coordinateLocation(e2), this.projection.wrap && (this.center = this.center.wrap());
          }
          locationPoint(e2) {
            return this.projection.locationPoint(this, e2);
          }
          locationPoint3D(e2) {
            return this.projection.locationPoint(this, e2, true);
          }
          pointLocation(e2) {
            return this.coordinateLocation(this.pointCoordinate(e2));
          }
          pointLocation3D(e2) {
            return this.coordinateLocation(this.pointCoordinate3D(e2));
          }
          locationCoordinate(e2, t2) {
            const i2 = t2 ? Zd(t2, e2.lat) : void 0, r2 = this.projection.project(e2.lng, e2.lat);
            return new ep(r2.x, r2.y, i2);
          }
          coordinateLocation(e2) {
            return this.projection.unproject(e2.x, e2.y);
          }
          pointRayIntersection(e2, t2) {
            const i2 = null != t2 ? t2 : this._centerAltitude, r2 = [e2.x, e2.y, 0, 1], n2 = [e2.x, e2.y, 1, 1];
            uu.transformMat4(r2, r2, this.pixelMatrixInverse), uu.transformMat4(n2, n2, this.pixelMatrixInverse);
            const o2 = n2[3];
            uu.scale(r2, r2, 1 / r2[3]), uu.scale(n2, n2, 1 / o2);
            const s2 = r2[2], a2 = n2[2];
            return { p0: r2, p1: n2, t: s2 === a2 ? 0 : (i2 - s2) / (a2 - s2) };
          }
          screenPointToMercatorRay(e2) {
            const t2 = [e2.x, e2.y, 0, 1], i2 = [e2.x, e2.y, 1, 1];
            return uu.transformMat4(t2, t2, this.pixelMatrixInverse), uu.transformMat4(i2, i2, this.pixelMatrixInverse), uu.scale(t2, t2, 1 / t2[3]), uu.scale(i2, i2, 1 / i2[3]), t2[2] = Zd(t2[2], this._center.lat) * this.worldSize, i2[2] = Zd(i2[2], this._center.lat) * this.worldSize, uu.scale(t2, t2, 1 / this.worldSize), uu.scale(i2, i2, 1 / this.worldSize), new Uu([t2[0], t2[1], t2[2]], Mu.normalize([], Mu.sub([], i2, t2)));
          }
          rayIntersectionCoordinate(e2) {
            const { p0: t2, p1: i2, t: r2 } = e2, n2 = Zd(t2[2], this._center.lat), o2 = Zd(i2[2], this._center.lat);
            return new ep(Wr(t2[0], i2[0], r2) / this.worldSize, Wr(t2[1], i2[1], r2) / this.worldSize, Wr(n2, o2, r2));
          }
          pointCoordinate(e2, t2 = this._centerAltitude) {
            return this.projection.pointCoordinate(this, e2.x, e2.y, t2);
          }
          pointCoordinate3D(e2) {
            if (!this.elevation)
              return this.pointCoordinate(e2);
            let t2 = this.projection.pointCoordinate3D(this, e2.x, e2.y);
            if (t2)
              return new ep(t2[0], t2[1], t2[2]);
            let i2 = 0, r2 = this.horizonLineFromTop();
            if (e2.y > r2)
              return this.pointCoordinate(e2);
            const n2 = 0.02 * r2, o2 = e2.clone();
            for (let e3 = 0; e3 < 10 && r2 - i2 > n2; e3++) {
              o2.y = Wr(i2, r2, 0.66);
              const e4 = this.projection.pointCoordinate3D(this, o2.x, o2.y);
              e4 ? (r2 = o2.y, t2 = e4) : i2 = o2.y;
            }
            return t2 ? new ep(t2[0], t2[1], t2[2]) : this.pointCoordinate(e2);
          }
          isPointAboveHorizon(e2) {
            return this.projection.isPointAboveHorizon(this, e2);
          }
          isPointOnSurface(e2) {
            if (e2.y < 0 || e2.y > this.height || e2.x < 0 || e2.x > this.width)
              return false;
            if (this.elevation || this.zoom >= Xu)
              return !this.isPointAboveHorizon(e2);
            const t2 = this.pointCoordinate(e2);
            return t2.y >= 0 && t2.y <= 1;
          }
          _coordinatePoint(e2, t2) {
            const i2 = t2 && this.elevation ? this.elevation.getAtPointOrZero(e2, this._centerAltitude) : this._centerAltitude, r2 = [e2.x * this.worldSize, e2.y * this.worldSize, i2 + e2.toAltitude(), 1];
            return uu.transformMat4(r2, r2, this.pixelMatrix), r2[3] > 0 ? new y(r2[0] / r2[3], r2[1] / r2[3]) : new y(Number.MAX_VALUE, Number.MAX_VALUE);
          }
          _getBoundsNonRectangular() {
            const { top: e2, left: t2 } = this._edgeInsets, i2 = this.height - this._edgeInsets.bottom, r2 = this.width - this._edgeInsets.right, n2 = this.pointLocation3D(new y(t2, e2)), o2 = this.pointLocation3D(new y(r2, e2)), s2 = this.pointLocation3D(new y(r2, i2)), a2 = this.pointLocation3D(new y(t2, i2));
            let l2 = Math.min(n2.lng, o2.lng, s2.lng, a2.lng), c2 = Math.max(n2.lng, o2.lng, s2.lng, a2.lng), h2 = Math.min(n2.lat, o2.lat, s2.lat, a2.lat), u2 = Math.max(n2.lat, o2.lat, s2.lat, a2.lat);
            const d2 = Math.pow(2, -this.zoom) / 16 * 270, p2 = "globe" === this.projection.name ? 1 : 4, f2 = (e3, t3, i3, r3, n3) => {
              const o3 = (e3 + i3) / 2, s3 = (t3 + r3) / 2, a3 = new y(o3, s3), { lng: m2, lat: _2 } = this.pointLocation3D(a3), g2 = Math.max(0, l2 - m2, h2 - _2, m2 - c2, _2 - u2);
              l2 = Math.min(l2, m2), c2 = Math.max(c2, m2), h2 = Math.min(h2, _2), u2 = Math.max(u2, _2), (n3 < p2 || g2 > d2) && (f2(e3, t3, o3, s3, n3 + 1), f2(o3, s3, i3, r3, n3 + 1));
            };
            if (f2(t2, e2, r2, e2, 1), f2(r2, e2, r2, i2, 1), f2(r2, i2, t2, i2, 1), f2(t2, i2, t2, e2, 1), "globe" === this.projection.name) {
              const [e3, t3] = function(e4) {
                const t4 = xu.identity(new Float64Array(16));
                xu.multiply(t4, e4.pixelMatrix, e4.globeMatrix);
                const i3 = [0, ed, 0], r3 = [0, td, 0];
                return Mu.transformMat4(i3, i3, t4), Mu.transformMat4(r3, r3, t4), [i3[0] > 0 && i3[0] <= e4.width && i3[1] > 0 && i3[1] <= e4.height && !Dd(e4, new Nd(e4.center.lat, 90)), r3[0] > 0 && r3[0] <= e4.width && r3[1] > 0 && r3[1] <= e4.height && !Dd(e4, new Nd(e4.center.lat, -90))];
              }(this);
              e3 ? (u2 = 90, c2 = 180, l2 = -180) : t3 && (h2 = -90, c2 = 180, l2 = -180);
            }
            return new Ql(new Nd(l2, h2), new Nd(c2, u2));
          }
          _getBoundsRectangular(e2, t2) {
            const { top: i2, left: r2 } = this._edgeInsets, n2 = this.height - this._edgeInsets.bottom, o2 = this.width - this._edgeInsets.right, s2 = new y(r2, i2), a2 = new y(o2, i2), l2 = new y(o2, n2), c2 = new y(r2, n2);
            let h2 = this.pointCoordinate(s2, e2), u2 = this.pointCoordinate(a2, e2);
            const d2 = this.pointCoordinate(l2, t2), p2 = this.pointCoordinate(c2, t2), f2 = (e3, t3) => (t3.y - e3.y) / (t3.x - e3.x);
            return h2.y > 1 && u2.y >= 0 ? h2 = new ep((1 - p2.y) / f2(p2, h2) + p2.x, 1) : h2.y < 0 && u2.y <= 1 && (h2 = new ep(-p2.y / f2(p2, h2) + p2.x, 0)), u2.y > 1 && h2.y >= 0 ? u2 = new ep((1 - d2.y) / f2(d2, u2) + d2.x, 1) : u2.y < 0 && h2.y <= 1 && (u2 = new ep(-d2.y / f2(d2, u2) + d2.x, 0)), new Ql().extend(this.coordinateLocation(h2)).extend(this.coordinateLocation(u2)).extend(this.coordinateLocation(p2)).extend(this.coordinateLocation(d2));
          }
          _getBoundsRectangularTerrain() {
            const e2 = this.elevation;
            if (!e2.visibleDemTiles.length || e2.isUsingMockSource())
              return this._getBoundsRectangular(0, 0);
            const t2 = e2.visibleDemTiles.reduce((e3, t3) => {
              if (t3.dem) {
                const i2 = t3.dem.tree;
                e3.min = Math.min(e3.min, i2.minimums[0]), e3.max = Math.max(e3.max, i2.maximums[0]);
              }
              return e3;
            }, { min: Number.MAX_VALUE, max: 0 });
            return this._getBoundsRectangular(t2.min * e2.exaggeration(), t2.max * e2.exaggeration());
          }
          getBounds() {
            return "mercator" === this.projection.name || "equirectangular" === this.projection.name ? this._terrainEnabled() ? this._getBoundsRectangularTerrain() : this._getBoundsRectangular(0, 0) : this._getBoundsNonRectangular();
          }
          horizonLineFromTop(e2 = true) {
            const t2 = this.height / 2 / Math.tan(this._fov / 2) / Math.tan(Math.max(this._pitch, 0.1)) - this.centerOffset.y, i2 = this.height / 2 - t2 * (1 - this._horizonShift);
            return e2 ? Math.max(0, i2) : i2;
          }
          getMaxBounds() {
            return this.maxBounds;
          }
          setMaxBounds(e2) {
            this.maxBounds = e2, this.minLat = -Xd, this.maxLat = Xd, this.minLng = -180, this.maxLng = 180, e2 && (this.minLat = e2.getSouth(), this.maxLat = e2.getNorth(), this.minLng = e2.getWest(), this.maxLng = e2.getEast(), this.maxLng < this.minLng && (this.maxLng += 360)), this.worldMinX = Gd(this.minLng) * this.tileSize, this.worldMaxX = Gd(this.maxLng) * this.tileSize, this.worldMinY = qd(this.maxLat) * this.tileSize, this.worldMaxY = qd(this.minLat) * this.tileSize, this._constrain();
          }
          calculatePosMatrix(e2, t2) {
            return this.projection.createTileMatrix(this, t2, e2);
          }
          calculateDistanceTileData(e2) {
            const t2 = e2.key, i2 = this._distanceTileDataCache;
            if (i2[t2])
              return i2[t2];
            const r2 = e2.canonical, n2 = 1 / this.height, o2 = this.cameraWorldSize, s2 = o2 / this.zoomScale(r2.z), a2 = (r2.x + Math.pow(2, r2.z) * e2.wrap) * s2, l2 = r2.y * s2, c2 = this.point;
            c2.x *= o2 / this.worldSize, c2.y *= o2 / this.worldSize;
            const h2 = this.angle, u2 = Math.sin(-h2), d2 = -Math.cos(-h2);
            return i2[t2] = { bearing: [u2, d2], center: [(c2.x - a2) * n2, (c2.y - l2) * n2], scale: s2 / sr * n2 }, i2[t2];
          }
          calculateFogTileMatrix(e2) {
            const t2 = e2.key, i2 = this._fogTileMatrixCache;
            if (i2[t2])
              return i2[t2];
            const r2 = this.projection.createTileMatrix(this, this.cameraWorldSizeForFog, e2);
            return xu.multiply(r2, this.worldToFogMatrix, r2), i2[t2] = new Float32Array(r2), i2[t2];
          }
          calculateProjMatrix(e2, t2 = false) {
            const i2 = e2.key, r2 = t2 ? this._alignedProjMatrixCache : this._projMatrixCache;
            if (r2[i2])
              return r2[i2];
            const n2 = this.calculatePosMatrix(e2, this.worldSize);
            return xu.multiply(n2, this.projection.isReprojectedInTileSpace ? this.mercatorMatrix : t2 ? this.alignedProjMatrix : this.projMatrix, n2), r2[i2] = new Float32Array(n2), r2[i2];
          }
          calculatePixelsToTileUnitsMatrix(e2) {
            const t2 = e2.tileID.key, i2 = this._pixelsToTileUnitsCache;
            if (i2[t2])
              return i2[t2];
            const r2 = function(e3, t3) {
              const { scale: i3 } = e3.tileTransform, r3 = i3 * sr / (e3.tileSize * Math.pow(2, t3.zoom - e3.tileID.overscaledZ + e3.tileID.canonical.z));
              return fu.scale(new Float32Array(4), t3.inverseAdjustmentMatrix, [r3, r3]);
            }(e2, this);
            return i2[t2] = r2, i2[t2];
          }
          customLayerMatrix() {
            return this.mercatorMatrix.slice();
          }
          globeToMercatorMatrix() {
            if ("globe" === this.projection.name) {
              const e2 = 1 / this.worldSize, t2 = xu.fromScaling([], [e2, e2, e2]);
              return xu.multiply(t2, t2, this.globeMatrix), t2;
            }
          }
          recenterOnTerrain() {
            if (!this._elevation || "globe" === this.projection.name)
              return;
            const e2 = this._elevation;
            this._updateCameraState();
            const t2 = Zd(1, this._center.lat) * this.worldSize, i2 = this._computeCameraPosition(t2), r2 = this._camera.forward(), n2 = Zd(1, this._center.lat);
            i2[2] /= n2, r2[2] /= n2, Mu.normalize(r2, r2);
            const o2 = e2.raycast(i2, r2, e2.exaggeration());
            if (o2) {
              const e3 = Mu.scaleAndAdd([], i2, r2, o2), t3 = new ep(e3[0], e3[1], Zd(e3[2], Hd(e3[1]))), s2 = (t3.z + Mu.length([t3.x - i2[0], t3.y - i2[1], t3.z - i2[2] * n2])) * this._pixelsPerMercatorPixel;
              this._seaLevelZoom = this._zoomFromMercatorZ(s2), this._centerAltitude = t3.toAltitude(), this._center = this.coordinateLocation(t3), this._updateZoomFromElevation(), this._constrain(), this._calcMatrices();
            }
          }
          _constrainCamera(e2 = false) {
            if (!this._elevation)
              return;
            const t2 = this._elevation, i2 = Zd(1, this._center.lat) * this.worldSize, r2 = this._computeCameraPosition(i2), n2 = t2.getAtPointOrZero(new ep(...r2)), o2 = this.pixelsPerMeter / this.worldSize * n2, s2 = this._minimumHeightOverTerrain(), a2 = r2[2] - o2;
            if (a2 <= s2)
              if (a2 < 0 || e2) {
                const e3 = this.locationCoordinate(this._center, this._centerAltitude), t3 = [r2[0], r2[1], e3.z - r2[2]], i3 = Mu.length(t3);
                t3[2] -= (s2 - a2) / this._pixelsPerMercatorPixel;
                const n3 = Mu.length(t3);
                if (0 === n3)
                  return;
                Mu.scale(t3, t3, i3 / n3 * this._pixelsPerMercatorPixel), this._camera.position = [r2[0], r2[1], e3.z * this._pixelsPerMercatorPixel - t3[2]], this._updateStateFromCamera();
              } else
                this._isCameraConstrained = true;
          }
          _constrain() {
            if (!this.center || !this.width || !this.height || this._constraining)
              return;
            this._constraining = true;
            const e2 = "globe" === this.projection.name || this.mercatorFromTransition;
            if (this.projection.isReprojectedInTileSpace || e2) {
              const t3 = this.center;
              return t3.lat = z(t3.lat, this.minLat, this.maxLat), (this.maxBounds || !this.renderWorldCopies && !e2) && (t3.lng = z(t3.lng, this.minLng, this.maxLng)), this.center = t3, void (this._constraining = false);
            }
            const t2 = this._unmodified, { x: i2, y: r2 } = this.point;
            let n2 = 0, o2 = i2, s2 = r2;
            const a2 = this.width / 2, l2 = this.height / 2, c2 = this.worldMinY * this.scale, h2 = this.worldMaxY * this.scale;
            if (r2 - l2 < c2 && (s2 = c2 + l2), r2 + l2 > h2 && (s2 = h2 - l2), h2 - c2 < this.height && (n2 = Math.max(n2, this.height / (h2 - c2)), s2 = (h2 + c2) / 2), this.maxBounds || !this._renderWorldCopies || !this.projection.wrap) {
              const e3 = this.worldMinX * this.scale, t3 = this.worldMaxX * this.scale, r3 = this.worldSize / 2 - (e3 + t3) / 2;
              o2 = (i2 + r3 + this.worldSize) % this.worldSize - r3, o2 - a2 < e3 && (o2 = e3 + a2), o2 + a2 > t3 && (o2 = t3 - a2), t3 - e3 < this.width && (n2 = Math.max(n2, this.width / (t3 - e3)), o2 = (t3 + e3) / 2);
            }
            o2 === i2 && s2 === r2 || (this.center = this.unproject(new y(o2, s2))), n2 && (this.zoom += this.scaleZoom(n2)), this._constrainCamera(), this._unmodified = t2, this._constraining = false;
          }
          _minZoomForBounds() {
            let e2 = Math.max(0, this.scaleZoom(this.height / (this.worldMaxY - this.worldMinY)));
            return this.maxBounds && (e2 = Math.max(e2, this.scaleZoom(this.width / (this.worldMaxX - this.worldMinX)))), e2;
          }
          _maxCameraBoundsDistance() {
            return this._mercatorZfromZoom(this._minZoomForBounds());
          }
          _calcMatrices() {
            if (!this.height)
              return;
            const e2 = this.centerOffset, t2 = "globe" === this.projection.name, i2 = this.pixelsPerMeter;
            "globe" === this.projection.name && (this._mercatorScaleRatio = Zd(1, this.center.lat) / Zd(1, 45));
            const r2 = Zx(this.projection, this.zoom, this.width, this.height, 1024);
            this._pixelsPerMercatorPixel = this.projection.pixelSpaceConversion(this.center.lat, this.worldSize, r2), this.cameraToCenterDistance = 0.5 / Math.tan(0.5 * this._fov) * this.height * this._pixelsPerMercatorPixel, this._updateCameraState(), this._farZ = this.projection.farthestPixelDistance(this), this._nearZ = this.height / 50;
            const n2 = "meters" === this.projection.zAxisUnit ? i2 : 1, o2 = this._camera.getWorldToCamera(this.worldSize, n2);
            let s2;
            const a2 = this._camera.getCameraToClipPerspective(this._fov, this.width / this.height, this._nearZ, this._farZ);
            if (a2[8] = 2 * -e2.x / this.width, a2[9] = 2 * e2.y / this.height, this.isOrthographic) {
              let t3 = 0.5 * this.height / Math.tan(this._fov / 2) * 1 * Math.tan(0.5 * this._fov), i3 = t3 * this.aspect, r3 = -i3, n3 = -t3;
              i3 -= e2.x, r3 -= e2.x, t3 += e2.y, n3 += e2.y, s2 = this._camera.getCameraToClipOrthographic(r3, i3, n3, t3, this._nearZ, this._farZ), ((e3, t4, i4, r4) => {
                for (let n4 = 0; n4 < 16; n4++)
                  e3[n4] = pv(t4[n4], i4[n4], r4);
              })(s2, s2, a2, fv(this.pitch >= 15 ? 1 : this.pitch / 15));
            } else
              s2 = a2;
            const l2 = xu.mul([], a2, o2);
            let c2 = xu.mul([], s2, o2);
            if (this.projection.isReprojectedInTileSpace) {
              const e3 = this.locationCoordinate(this.center), t3 = xu.identity([]);
              xu.translate(t3, t3, [e3.x * this.worldSize, e3.y * this.worldSize, 0]), xu.multiply(t3, t3, Gx(this)), xu.translate(t3, t3, [-e3.x * this.worldSize, -e3.y * this.worldSize, 0]), xu.multiply(c2, c2, t3), xu.multiply(l2, l2, t3), this.inverseAdjustmentMatrix = function(e4) {
                const t4 = Gx(e4, true);
                return fu.invert([], [t4[0], t4[1], t4[4], t4[5]]);
              }(this);
            } else
              this.inverseAdjustmentMatrix = [1, 0, 0, 1];
            this.mercatorMatrix = xu.scale([], c2, [this.worldSize, this.worldSize, this.worldSize / n2, 1]), this.projMatrix = c2, this.invProjMatrix = xu.invert(new Float64Array(16), this.projMatrix);
            const h2 = xu.invert([], s2);
            this.frustumCorners = Vu.fromInvProjectionMatrix(h2, this.horizonLineFromTop(), this.height), this.cameraFrustum = $u.fromInvProjectionMatrix(this.invProjMatrix, this.worldSize, 0, !t2);
            const u2 = new Float32Array(16);
            xu.identity(u2), xu.scale(u2, u2, [1, -1, 1]), xu.rotateX(u2, u2, this._pitch), xu.rotateZ(u2, u2, this.angle);
            const d2 = xu.perspective(new Float32Array(16), this._fov, this.width / this.height, this._nearZ, this._farZ);
            this.starsProjMatrix = xu.clone(d2);
            const p2 = (Math.PI / 2 - this._pitch) * (this.height / this._fov) * this._horizonShift;
            d2[8] = 2 * -e2.x / this.width, d2[9] = 2 * (e2.y + p2) / this.height, this.skyboxMatrix = xu.multiply(u2, d2, u2);
            const f2 = this.point, m2 = f2.x, _2 = f2.y, g2 = this.width % 2 / 2, y2 = this.height % 2 / 2, x2 = Math.cos(this.angle), v2 = Math.sin(this.angle), b2 = m2 - Math.round(m2) + x2 * g2 + v2 * y2, w2 = _2 - Math.round(_2) + x2 * y2 + v2 * g2, T2 = new Float64Array(c2);
            if (xu.translate(T2, T2, [b2 > 0.5 ? b2 - 1 : b2, w2 > 0.5 ? w2 - 1 : w2, 0]), this.alignedProjMatrix = T2, c2 = xu.create(), xu.scale(c2, c2, [this.width / 2, -this.height / 2, 1]), xu.translate(c2, c2, [1, -1, 0]), this.labelPlaneMatrix = c2, c2 = xu.create(), xu.scale(c2, c2, [1, -1, 1]), xu.translate(c2, c2, [-1, -1, 0]), xu.scale(c2, c2, [2 / this.width, 2 / this.height, 1]), this.glCoordMatrix = c2, this.pixelMatrix = xu.multiply(new Float64Array(16), this.labelPlaneMatrix, l2), this._calcFogMatrices(), this._distanceTileDataCache = {}, c2 = xu.invert(new Float64Array(16), this.pixelMatrix), !c2)
              throw new Error("failed to invert matrix");
            if (this.pixelMatrixInverse = c2, "globe" === this.projection.name || this.mercatorFromTransition) {
              this.globeMatrix = function(e4) {
                const { x: t3, y: i3 } = e4.point, { lng: r3, lat: n3 } = e4._center;
                return Td(t3, i3, e4.worldSize, r3, n3);
              }(this);
              const e3 = [this.globeMatrix[12], this.globeMatrix[13], this.globeMatrix[14]];
              this.globeCenterInViewSpace = Mu.transformMat4(e3, e3, o2), this.globeRadius = this.worldSize / 2 / Math.PI - 1;
            } else
              this.globeMatrix = c2;
            this._projMatrixCache = {}, this._alignedProjMatrixCache = {}, this._pixelsToTileUnitsCache = {};
          }
          _calcFogMatrices() {
            this._fogTileMatrixCache = {};
            const e2 = this.cameraWorldSizeForFog, t2 = this.cameraPixelsPerMeter, i2 = this._camera.position, r2 = 1 / this.height / this._pixelsPerMercatorPixel, n2 = [e2, e2, t2];
            Mu.scale(n2, n2, r2), Mu.scale(i2, i2, -1), Mu.multiply(i2, i2, n2);
            const o2 = xu.create();
            xu.translate(o2, o2, i2), xu.scale(o2, o2, n2), this.mercatorFogMatrix = o2, this.worldToFogMatrix = this._camera.getWorldToCameraPosition(e2, t2, r2);
          }
          _computeCameraPosition(e2) {
            const t2 = (e2 = e2 || this.pixelsPerMeter) / this.pixelsPerMeter, i2 = this._camera.forward(), r2 = this.point, n2 = this._mercatorZfromZoom(this._seaLevelZoom ? this._seaLevelZoom : this._zoom) * t2 - e2 / this.worldSize * this._centerAltitude;
            return [r2.x / this.worldSize - i2[0] * n2, r2.y / this.worldSize - i2[1] * n2, e2 / this.worldSize * this._centerAltitude - i2[2] * n2];
          }
          _updateCameraState() {
            this.height && (this._camera.setPitchBearing(this._pitch, this.angle), this._camera.position = this._computeCameraPosition());
          }
          _translateCameraConstrained(e2) {
            const t2 = this._maxCameraBoundsDistance() * Math.cos(this._pitch), i2 = this._camera.position[2], r2 = e2[2];
            let n2 = 1;
            this.projection.wrap && (this.center = this.center.wrap()), r2 > 0 && (n2 = Math.min((t2 - i2) / r2, 1)), this._camera.position = Mu.scaleAndAdd([], this._camera.position, e2, n2), this._updateStateFromCamera();
          }
          _updateStateFromCamera() {
            const e2 = this._camera.position, t2 = this._camera.forward(), { pitch: i2, bearing: r2 } = this._camera.getPitchBearing(), n2 = Zd(this._centerAltitude, this.center.lat) * this._pixelsPerMercatorPixel, o2 = this._mercatorZfromZoom(this._maxZoom) * Math.cos(w(this._maxPitch)), s2 = Math.max((e2[2] - n2) / Math.cos(i2), o2), a2 = this._zoomFromMercatorZ(s2);
            Mu.scaleAndAdd(e2, e2, t2, s2), this._pitch = z(i2, w(this.minPitch), w(this.maxPitch)), this.angle = P(r2, -Math.PI, Math.PI), this._setZoom(z(a2, this._minZoom, this._maxZoom)), this._updateSeaLevelZoom(), this._center = this.coordinateLocation(new ep(e2[0], e2[1], e2[2])), this._unmodified = false, this._constrain(), this._calcMatrices();
          }
          _worldSizeFromZoom(e2) {
            return Math.pow(2, e2) * this.tileSize;
          }
          _mercatorZfromZoom(e2) {
            return this.cameraToCenterDistance / this._worldSizeFromZoom(e2);
          }
          _minimumHeightOverTerrain() {
            const e2 = Math.min((null != this._seaLevelZoom ? this._seaLevelZoom : this._zoom) + 4, this._maxZoom);
            return this._mercatorZfromZoom(e2);
          }
          _zoomFromMercatorZ(e2) {
            return this.scaleZoom(this.cameraToCenterDistance / (e2 * this.tileSize));
          }
          zoomFromMercatorZAdjusted(e2) {
            let t2 = 0, i2 = Xu, r2 = 0, n2 = 1 / 0;
            for (; i2 - t2 > 1e-6 && i2 > t2; ) {
              const o2 = t2 + 0.5 * (i2 - t2), s2 = this.tileSize * Math.pow(2, o2), a2 = this.getCameraToCenterDistance(this.projection, o2, s2), l2 = this.scaleZoom(a2 / (e2 * this.tileSize)), c2 = Math.abs(o2 - l2);
              c2 < n2 && (n2 = c2, r2 = o2), o2 < l2 ? t2 = o2 : i2 = o2;
            }
            return r2;
          }
          _terrainEnabled() {
            return !(!this._elevation || !this.projection.supportsTerrain && (W("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."), 1));
          }
          anyCornerOffEdge(e2, t2) {
            const i2 = Math.min(e2.x, t2.x), r2 = Math.max(e2.x, t2.x), n2 = Math.min(e2.y, t2.y), o2 = Math.max(e2.y, t2.y);
            if (n2 < this.horizonLineFromTop(false))
              return true;
            if ("mercator" !== this.projection.name)
              return false;
            const s2 = [new y(i2, n2), new y(r2, o2), new y(i2, o2), new y(r2, n2)], a2 = this.renderWorldCopies ? -3 : 0, l2 = this.renderWorldCopies ? 4 : 1;
            for (const e3 of s2) {
              const t3 = this.pointRayIntersection(e3);
              if (t3.t < 0)
                return true;
              const i3 = this.rayIntersectionCoordinate(t3);
              if (i3.x < a2 || i3.y < 0 || i3.x > l2 || i3.y > 1)
                return true;
            }
            return false;
          }
          isHorizonVisible() {
            return this.pitch + T(this.fovAboveCenter) > 88 || this.anyCornerOffEdge(new y(0, 0), new y(this.width, this.height));
          }
          zoomDeltaToMovement(e2, t2) {
            const i2 = Mu.length(Mu.sub([], this._camera.position, e2)), r2 = this._zoomFromMercatorZ(i2) + t2;
            return i2 - this._mercatorZfromZoom(r2);
          }
          getCameraPoint() {
            if ("globe" === this.projection.name) {
              const e2 = function([e3, t2, i2], r2) {
                const n2 = [e3, t2, i2, 1];
                uu.transformMat4(n2, n2, r2);
                const o2 = n2[3] = Math.max(n2[3], 1e-6);
                return n2[0] /= o2, n2[1] /= o2, n2[2] /= o2, n2;
              }([this.globeMatrix[12], this.globeMatrix[13], this.globeMatrix[14]], this.pixelMatrix);
              return new y(e2[0], e2[1]);
            }
            {
              const e2 = Math.tan(this._pitch) * (this.cameraToCenterDistance || 1);
              return this.centerPoint.add(new y(0, e2));
            }
          }
          getCameraToCenterDistance(e2, t2 = this.zoom, i2 = this.worldSize) {
            const r2 = Zx(e2, t2, this.width, this.height, 1024), n2 = e2.pixelSpaceConversion(this.center.lat, i2, r2);
            let o2 = 0.5 / Math.tan(0.5 * this._fov) * this.height * n2;
            return this.isOrthographic && (o2 = pv(1, o2, fv(this.pitch >= 15 ? 1 : this.pitch / 15))), o2;
          }
          getWorldToCameraMatrix() {
            const e2 = this._camera.getWorldToCamera(this.worldSize, "meters" === this.projection.zAxisUnit ? this.pixelsPerMeter : 1);
            return "globe" === this.projection.name && xu.multiply(e2, e2, this.globeMatrix), e2;
          }
          getFrustum(e2) {
            return $u.fromInvProjectionMatrix(this.invProjMatrix, this.worldSize, e2, "meters" === this.projection.zAxisUnit);
          }
        }
        function _v(e2, t2, i2) {
          xu.identity(e2), xu.rotateZ(e2, e2, w(t2[2])), xu.rotateX(e2, e2, w(t2[0])), xu.rotateY(e2, e2, w(t2[1])), xu.scale(e2, e2, i2), xu.multiply(e2, e2, [1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1]);
        }
        function gv(e2, t2, i2, r2, n2, o2, s2, a2) {
          const l2 = [i2[0] - t2[0], i2[1] - t2[1], 0], c2 = [r2[0] - t2[0], r2[1] - t2[1], 0];
          if (Mu.length(l2) < 1e-12 || Mu.length(c2) < 1e-12)
            return bu.identity(e2);
          const h2 = Mu.cross([], l2, c2);
          Mu.normalize(h2, h2), Mu.subtract(c2, r2, t2), l2[2] = (o2 - n2) * a2, c2[2] = (s2 - n2) * a2;
          const u2 = l2;
          return Mu.cross(u2, l2, c2), Mu.normalize(u2, u2), bu.rotationTo(e2, h2, u2);
        }
        function yv(e2, t2, i2 = false) {
          const r2 = Ed(t2.zoom), n2 = function(e3, t3, i3) {
            const r3 = t3.worldSize, n3 = [e3[12], e3[13], e3[14]], o2 = Hd(n3[1] / r3), s2 = $d(n3[0] / r3), a2 = xu.identity([]), l2 = Zd(1, o2) * r3, c2 = Zd(1, 0) * r3 * Kd(o2, t3.zoom), h2 = 1 / bd(r3);
            let u2 = c2 * h2;
            if (i3) {
              const e4 = Zx(t3.projection, t3.zoom, t3.width, t3.height, 1024);
              u2 = h2 * t3.projection.pixelSpaceConversion(t3.center.lat, r3, e4);
            }
            const d2 = md(o2, s2);
            Mu.add(d2, d2, Mu.scale([], Mu.normalize([], d2), l2 * u2 * n3[2]));
            const p2 = function(e4) {
              const t4 = [e4[0], e4[1], e4[2]];
              let i4 = [0, 1, 0];
              const r4 = Mu.cross([], i4, t4);
              return Mu.cross(i4, t4, r4), 0 === Mu.squaredLength(i4) && (i4 = [0, 1, 0], Mu.cross(r4, t4, i4)), Mu.normalize(r4, r4), Mu.normalize(i4, i4), Mu.normalize(t4, t4), [r4[0], r4[1], r4[2], 0, i4[0], i4[1], i4[2], 0, t4[0], t4[1], t4[2], 0, e4[0], e4[1], e4[2], 1];
            }(d2);
            xu.scale(a2, a2, [u2, u2, u2 * l2]), xu.translate(a2, a2, [-n3[0], -n3[1], -n3[2]]);
            const f2 = xu.multiply([], t3.globeMatrix, p2);
            return xu.multiply(f2, f2, a2), xu.multiply(f2, f2, e3), f2;
          }(e2, t2, i2);
          if (r2 > 0) {
            const i3 = function(e3, t3) {
              const i4 = t3.worldSize, r3 = Zd(1, 0) * i4 * Kd(t3.center.lat, t3.zoom) / bd(i4), n3 = Zd(1, t3.center.lat) * i4, o2 = xu.identity([]);
              return xu.rotateY(o2, o2, w(t3.center.lng)), xu.rotateX(o2, o2, w(t3.center.lat)), xu.translate(o2, o2, [0, 0, Yu]), xu.scale(o2, o2, [r3, r3, r3 * n3]), xu.translate(o2, o2, [t3.point.x - 0.5 * i4, t3.point.y - 0.5 * i4, 0]), xu.multiply(o2, o2, e3), xu.multiply(o2, t3.globeMatrix, o2);
            }(e2, t2);
            return function(e3, t3, i4) {
              const r3 = (e4, t4, i5) => {
                const r4 = Mu.length(e4), n4 = Mu.length(t4), o3 = ld(e4, t4, i5);
                return Mu.scale(o3, o3, 1 / Mu.length(o3) * Wr(r4, n4, i5));
              }, n3 = r3([e3[0], e3[1], e3[2]], [t3[0], t3[1], t3[2]], i4), o2 = r3([e3[4], e3[5], e3[6]], [t3[4], t3[5], t3[6]], i4), s2 = r3([e3[8], e3[9], e3[10]], [t3[8], t3[9], t3[10]], i4), a2 = ld([e3[12], e3[13], e3[14]], [t3[12], t3[13], t3[14]], i4);
              return [n3[0], n3[1], n3[2], 0, o2[0], o2[1], o2[2], 0, s2[0], s2[1], s2[2], 0, a2[0], a2[1], a2[2], 1];
            }(n2, i3, r2);
          }
          return n2;
        }
        const xv = 64, vv = [1, 1, 1];
        class bv {
          constructor(e2, t2, i2, r2) {
            this.id = e2, this.position = null != t2 ? new Nd(t2[0], t2[1]) : new Nd(0, 0), this.orientation = null != i2 ? i2 : [0, 0, 0], this.nodes = r2, this.uploaded = false, this.aabb = new Hu([1 / 0, 1 / 0, 1 / 0], [-1 / 0, -1 / 0, -1 / 0]), this.matrix = [];
          }
          _applyTransformations(e2, t2) {
            if (xu.multiply(e2.matrix, t2, e2.matrix), e2.meshes)
              for (const t3 of e2.meshes) {
                const i2 = Hu.applyTransform(t3.aabb, e2.matrix);
                this.aabb.encapsulate(i2);
              }
            if (e2.children)
              for (const t3 of e2.children)
                this._applyTransformations(t3, e2.matrix);
          }
          computeBoundsAndApplyParent() {
            const e2 = xu.identity([]);
            for (const t2 of this.nodes)
              this._applyTransformations(t2, e2);
          }
          _positionModelOnTerrain(e2, t2) {
            const i2 = e2.elevation;
            if (!i2)
              return 0;
            const r2 = Hu.projectAabbCorners(this.aabb, this.matrix), n2 = Zd(1, this.position.lat) * e2.worldSize, o2 = function(e3, t3) {
              const i3 = [0, 0, 1], r3 = [{ corners: [0, 1, 3, 2], dotProductWithUp: 0 }, { corners: [1, 5, 2, 6], dotProductWithUp: 0 }, { corners: [0, 4, 1, 5], dotProductWithUp: 0 }, { corners: [2, 6, 3, 7], dotProductWithUp: 0 }, { corners: [4, 7, 5, 6], dotProductWithUp: 0 }, { corners: [0, 3, 4, 7], dotProductWithUp: 0 }];
              for (const n3 of r3) {
                const r4 = e3[n3.corners[0]], o3 = e3[n3.corners[1]], s3 = e3[n3.corners[2]], a3 = [o3[0] - r4[0], o3[1] - r4[1], t3 * (o3[2] - r4[2])], l3 = Mu.cross(a3, a3, [s3[0] - r4[0], s3[1] - r4[1], t3 * (s3[2] - r4[2])]);
                Mu.normalize(l3, l3), n3.dotProductWithUp = Mu.dot(l3, i3);
              }
              return r3.sort((e4, t4) => e4.dotProductWithUp - t4.dotProductWithUp), r3[0].corners;
            }(r2, n2), s2 = r2[o2[0]], a2 = r2[o2[1]], l2 = r2[o2[2]], c2 = r2[o2[3]], h2 = i2.getAtPointOrZero(new ep(s2[0] / e2.worldSize, s2[1] / e2.worldSize), 0), u2 = i2.getAtPointOrZero(new ep(a2[0] / e2.worldSize, a2[1] / e2.worldSize), 0), d2 = i2.getAtPointOrZero(new ep(l2[0] / e2.worldSize, l2[1] / e2.worldSize), 0), p2 = i2.getAtPointOrZero(new ep(c2[0] / e2.worldSize, c2[1] / e2.worldSize), 0), f2 = (h2 + p2) / 2, m2 = (u2 + d2) / 2;
            return f2 > m2 ? u2 < d2 ? gv(t2, a2, c2, s2, u2, p2, h2, n2) : gv(t2, l2, s2, c2, d2, h2, p2, n2) : h2 < p2 ? gv(t2, s2, a2, l2, h2, u2, d2, n2) : gv(t2, c2, l2, a2, p2, d2, u2, n2), Math.max(f2, m2);
          }
          computeModelMatrix(e2, t2, i2, r2, n2, o2, s2 = false) {
            const a2 = e2.transform, l2 = a2.zoom, c2 = a2.project(this.position), h2 = Kd(this.position.lat, l2), u2 = 1 / h2;
            xu.identity(this.matrix), xu.translate(this.matrix, this.matrix, [c2.x + r2[0] * u2, c2.y + r2[1] * u2, r2[2]]);
            let d2 = 1, p2 = 1;
            const f2 = a2.worldSize;
            if (s2) {
              if ("mercator" === a2.projection.name) {
                let e3 = 0;
                a2.elevation && (e3 = a2.elevation.getAtPointOrZero(new ep(c2.x / f2, c2.y / f2), 0));
                const t3 = uu.transformMat4([], [c2.x, c2.y, e3, 1], a2.projMatrix)[3] / a2.cameraToCenterDistance;
                d2 = t3, p2 = t3 * Kd(a2.center.lat, l2);
              } else if ("globe" === a2.projection.name) {
                const e3 = yv(this.matrix, a2), t3 = xu.multiply([], a2.projMatrix, e3), i3 = [0, 0, 0, 1];
                uu.transformMat4(i3, i3, t3);
                const r3 = i3[3] / a2.cameraToCenterDistance, n3 = Ed(l2), o3 = a2.projection.pixelsPerMeter(this.position.lat, f2) * Kd(this.position.lat, l2), s3 = a2.projection.pixelsPerMeter(a2.center.lat, f2) * Kd(a2.center.lat, l2);
                d2 = r3 / Wr(o3, Yd(a2.center.lat), n3), p2 = r3 * h2 / o3, d2 *= s3, p2 *= s3;
              }
            } else
              d2 = u2;
            xu.scale(this.matrix, this.matrix, [d2, d2, p2]);
            const m2 = [...this.matrix], _2 = this.orientation, g2 = [];
            if (_v(g2, [_2[0] + t2[0], _2[1] + t2[1], _2[2] + t2[2]], i2), xu.multiply(this.matrix, m2, g2), n2 && a2.elevation) {
              let e3 = 0;
              const t3 = [];
              if (o2 && a2.elevation) {
                e3 = this._positionModelOnTerrain(a2, t3);
                const i3 = xu.fromQuat([], t3), r3 = xu.multiply([], i3, g2);
                xu.multiply(this.matrix, m2, r3);
              } else
                e3 = a2.elevation.getAtPointOrZero(new ep(c2.x / f2, c2.y / f2), 0);
              0 !== e3 && (this.matrix[14] += e3);
            }
          }
          upload(e2) {
            if (!this.uploaded) {
              for (const t2 of this.nodes)
                Ev(t2, e2);
              for (const e3 of this.nodes)
                Mv(e3);
              this.uploaded = true;
            }
          }
          destroy() {
            for (const e2 of this.nodes)
              Av(e2);
          }
        }
        function wv(e2, t2, i2 = false) {
          e2.uploaded || (e2.gfxTexture = new gy(t2, e2.image, i2 ? t2.gl.R8 : t2.gl.RGBA, { useMipmap: e2.sampler.minFilter >= t2.gl.NEAREST_MIPMAP_NEAREST }), e2.uploaded = true, e2.image = null);
        }
        function Tv(e2, t2, i2) {
          e2.indexBuffer = t2.createIndexBuffer(e2.indexArray, false, true), e2.vertexBuffer = t2.createVertexBuffer(e2.vertexArray, zx.members, false, true), e2.normalArray && (e2.normalBuffer = t2.createVertexBuffer(e2.normalArray, Lx.members, false, true)), e2.texcoordArray && (e2.texcoordBuffer = t2.createVertexBuffer(e2.texcoordArray, Rx.members, false, true)), e2.colorArray && (e2.colorBuffer = t2.createVertexBuffer(e2.colorArray, (12 === e2.colorArray.bytesPerElement ? Dx : Px).members, false, true)), e2.featureArray && (e2.pbrBuffer = t2.createVertexBuffer(e2.featureArray, Ox.members, true)), e2.segments = dl.simpleSegment(0, 0, e2.vertexArray.length, e2.indexArray.length);
          const r2 = e2.material;
          r2.pbrMetallicRoughness.baseColorTexture && wv(r2.pbrMetallicRoughness.baseColorTexture, t2), r2.pbrMetallicRoughness.metallicRoughnessTexture && wv(r2.pbrMetallicRoughness.metallicRoughnessTexture, t2), r2.normalTexture && wv(r2.normalTexture, t2), r2.occlusionTexture && wv(r2.occlusionTexture, t2, i2), r2.emissionTexture && wv(r2.emissionTexture, t2);
        }
        function Ev(e2, t2, i2) {
          if (e2.meshes)
            for (const r2 of e2.meshes)
              Tv(r2, t2, i2);
          if (e2.children)
            for (const r2 of e2.children)
              Ev(r2, t2, i2);
        }
        function Mv(e2) {
          if (e2.meshes)
            for (const t2 of e2.meshes)
              t2.indexArray.destroy(), t2.vertexArray.destroy(), t2.colorArray && t2.colorArray.destroy(), t2.normalArray && t2.normalArray.destroy(), t2.texcoordArray && t2.texcoordArray.destroy(), t2.featureArray && t2.featureArray.destroy();
          if (e2.children)
            for (const t2 of e2.children)
              Mv(t2);
        }
        function Av(e2) {
          if (e2.meshes)
            for (const i2 of e2.meshes)
              i2.vertexBuffer && (i2.vertexBuffer.destroy(), i2.indexBuffer.destroy(), i2.normalBuffer && i2.normalBuffer.destroy(), i2.texcoordBuffer && i2.texcoordBuffer.destroy(), i2.colorBuffer && i2.colorBuffer.destroy(), i2.pbrBuffer && i2.pbrBuffer.destroy(), i2.segments.destroy(), i2.material && ((t2 = i2.material).pbrMetallicRoughness.baseColorTexture && t2.pbrMetallicRoughness.baseColorTexture.gfxTexture && t2.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(), t2.pbrMetallicRoughness.metallicRoughnessTexture && t2.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture && t2.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(), t2.normalTexture && t2.normalTexture.gfxTexture && t2.normalTexture.gfxTexture.destroy(), t2.emissionTexture && t2.emissionTexture.gfxTexture && t2.emissionTexture.gfxTexture.destroy(), t2.occlusionTexture && t2.occlusionTexture.gfxTexture && t2.occlusionTexture.gfxTexture.destroy()));
          var t2;
          if (e2.children)
            for (const t3 of e2.children)
              Av(t3);
        }
        class Sv {
          constructor(e2, t2) {
            this.feature = e2, this.instancedDataOffset = t2, this.instancedDataCount = 0, this.rotation = [0, 0, 0], this.scale = [1, 1, 1], this.translation = [0, 0, 0];
          }
        }
        class Iv {
          constructor() {
            this.instancedDataArray = new Ya(), this.instancesEvaluatedElevation = [], this.features = [], this.idToFeaturesIndex = {};
          }
        }
        class Cv {
          constructor(e2) {
            this.zoom = e2.zoom, this.canonical = e2.canonical, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.projection = e2.projection, this.index = e2.index, this.hasZoomDependentProperties = this.layers[0].isZoomDependent(), this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id), this.hasPattern = false, this.instancesPerModel = {}, this.validForExaggeration = 0, this.maxVerticalOffset = 0, this.maxScale = 0, this.maxHeight = 0, this.lookupDim = this.zoom > this.canonical.z ? 256 : this.zoom > 15 ? 75 : 100, this.instanceCount = 0, this.terrainElevationMin = 0, this.terrainElevationMax = 0, this.validForDEMTile = { id: null, timestamp: 0 };
          }
          populate(e2, t2, i2, r2) {
            this.tileToMeter = Qd(i2);
            const n2 = this.layers[0]._featureFilter.needGeometry;
            this.lookup = new Uint8Array(this.lookupDim * this.lookupDim);
            for (const { feature: o2, id: s2, index: a2, sourceLayerIndex: l2 } of e2) {
              const e3 = cp(o2, n2);
              if (!this.layers[0]._featureFilter.filter(new ea(this.zoom), e3, i2))
                continue;
              const c2 = { id: s2, sourceLayerIndex: l2, index: a2, geometry: n2 ? e3.geometry : lp(o2, i2, r2), properties: o2.properties, type: o2.type, patterns: {} }, h2 = this.addFeature(c2, c2.geometry, e3);
              h2 && t2.featureIndex.insert(o2, c2.geometry, a2, l2, this.index, this.instancesPerModel[h2].instancedDataArray.length);
            }
            this.lookup = null;
          }
          update(e2, t2, i2, r2) {
            for (const t3 in this.instancesPerModel) {
              const i3 = this.instancesPerModel[t3];
              for (const t4 in e2)
                i3.idToFeaturesIndex.hasOwnProperty(t4) && this.evaluate(i3.features[i3.idToFeaturesIndex[t4]], e2[t4], i3, true);
            }
            this.maxHeight = 0;
          }
          updateZoomBasedPaintProperties() {
            if (!this.hasZoomDependentProperties)
              return false;
            let e2 = false;
            for (const t2 in this.instancesPerModel) {
              const i2 = this.instancesPerModel[t2];
              for (const t3 of i2.features) {
                const r2 = this.layers[0], n2 = t3.feature, o2 = this.canonical, s2 = r2.paint.get("model-rotation").evaluate(n2, {}, o2), a2 = r2.paint.get("model-scale").evaluate(n2, {}, o2), l2 = r2.paint.get("model-translation").evaluate(n2, {}, o2);
                Mu.exactEquals(t3.rotation, s2) && Mu.exactEquals(t3.scale, a2) && Mu.exactEquals(t3.translation, l2) || (this.evaluate(t3, t3.featureStates, i2, true), e2 = true);
              }
            }
            return e2;
          }
          isEmpty() {
            for (const e2 in this.instancesPerModel)
              if (0 !== this.instancesPerModel[e2].instancedDataArray.length)
                return false;
            return true;
          }
          uploadPending() {
            return !this.uploaded;
          }
          upload(e2) {
            if (!this.uploaded)
              for (const t2 in this.instancesPerModel) {
                const i2 = this.instancesPerModel[t2];
                i2.instancedDataArray.length < 0 || 0 === i2.instancedDataArray.length || (i2.instancedDataBuffer ? i2.instancedDataBuffer.updateData(i2.instancedDataArray) : i2.instancedDataBuffer = e2.createVertexBuffer(i2.instancedDataArray, kx.members, true, void 0, this.instanceCount));
              }
            this.uploaded = true;
          }
          destroy() {
            for (const e2 in this.instancesPerModel) {
              const t2 = this.instancesPerModel[e2];
              0 !== t2.instancedDataArray.length && t2.instancedDataBuffer && t2.instancedDataBuffer.destroy();
            }
          }
          addFeature(e2, t2, i2) {
            const r2 = this.layers[0], n2 = r2.layout.get("model-id").evaluate(i2, {}, this.canonical);
            if (!n2)
              return W(`modelId is not evaluated for layer ${r2.id} and it is not going to get rendered.`), n2;
            this.instancesPerModel[n2] || (this.instancesPerModel[n2] = new Iv());
            const o2 = this.instancesPerModel[n2], s2 = o2.instancedDataArray, a2 = new Sv(i2, s2.length);
            for (const e3 of t2)
              for (const t3 of e3) {
                if (t3.x < 0 || t3.x >= sr || t3.y < 0 || t3.y >= sr)
                  continue;
                const e4 = (this.lookupDim - 1) / sr, i3 = this.lookupDim * (t3.y * e4 | 0) + t3.x * e4 | 0;
                if (this.lookup) {
                  if (0 !== this.lookup[i3])
                    continue;
                  this.lookup[i3] = 1;
                }
                this.instanceCount++;
                const r3 = s2.length;
                s2.resize(r3 + 1), o2.instancesEvaluatedElevation.push(0), s2.float32[16 * r3] = t3.x, s2.float32[16 * r3 + 1] = t3.y;
              }
            return a2.instancedDataCount = o2.instancedDataArray.length - a2.instancedDataOffset, a2.instancedDataCount > 0 && (e2.id && (o2.idToFeaturesIndex[e2.id] = o2.features.length), o2.features.push(a2), this.evaluate(a2, {}, o2, false)), n2;
          }
          evaluate(e2, t2, i2, r2) {
            const n2 = this.layers[0], o2 = e2.feature, s2 = this.canonical, a2 = e2.rotation = n2.paint.get("model-rotation").evaluate(o2, t2, s2), l2 = e2.scale = n2.paint.get("model-scale").evaluate(o2, t2, s2), c2 = e2.translation = n2.paint.get("model-translation").evaluate(o2, t2, s2), h2 = n2.paint.get("model-color").evaluate(o2, t2, s2);
            h2.a = n2.paint.get("model-color-mix-intensity").evaluate(o2, t2, s2);
            const u2 = [];
            this.maxVerticalOffset < c2[2] && (this.maxVerticalOffset = c2[2]), this.maxScale = Math.max(Math.max(this.maxScale, l2[0]), Math.max(l2[1], l2[2])), _v(u2, a2, l2);
            const d2 = Math.round(100 * h2.a) + h2.b / 1.05;
            for (let t3 = 0; t3 < e2.instancedDataCount; ++t3) {
              const n3 = e2.instancedDataOffset + t3, o3 = 16 * n3, a3 = i2.instancedDataArray.float32;
              let l3 = 0;
              r2 && (l3 = a3[o3 + 6] - i2.instancesEvaluatedElevation[n3]);
              const p2 = 0 | a3[o3 + 1];
              a3[o3] = (0 | a3[o3]) + h2.r / 1.05, a3[o3 + 1] = p2 + h2.g / 1.05, a3[o3 + 2] = d2, a3[o3 + 3] = 1 / (s2.z > 10 ? this.tileToMeter : Qd(s2, p2)), a3[o3 + 4] = c2[0], a3[o3 + 5] = c2[1], a3[o3 + 6] = c2[2] + l3, a3[o3 + 7] = u2[0], a3[o3 + 8] = u2[1], a3[o3 + 9] = u2[2], a3[o3 + 10] = u2[4], a3[o3 + 11] = u2[5], a3[o3 + 12] = u2[6], a3[o3 + 13] = u2[8], a3[o3 + 14] = u2[9], a3[o3 + 15] = u2[10], i2.instancesEvaluatedElevation[n3] = c2[2];
            }
          }
        }
        Is(Cv, "ModelBucket", { omit: ["layers"] }), Is(Iv, "PerModelAttributes"), Is(Sv, "ModelFeature");
        const zv = new da({ visibility: new ca(Ct.layout_model.visibility), "model-id": new ha(Ct.layout_model["model-id"]) });
        var Dv = { paint: new da({ "model-opacity": new ca(Ct.paint_model["model-opacity"]), "model-rotation": new ha(Ct.paint_model["model-rotation"]), "model-scale": new ha(Ct.paint_model["model-scale"]), "model-translation": new ha(Ct.paint_model["model-translation"]), "model-color": new ha(Ct.paint_model["model-color"]), "model-color-mix-intensity": new ha(Ct.paint_model["model-color-mix-intensity"]), "model-type": new ca(Ct.paint_model["model-type"]), "model-cast-shadows": new ca(Ct.paint_model["model-cast-shadows"]), "model-receive-shadows": new ca(Ct.paint_model["model-receive-shadows"]), "model-ambient-occlusion-intensity": new ca(Ct.paint_model["model-ambient-occlusion-intensity"]), "model-emissive-strength": new ha(Ct.paint_model["model-emissive-strength"]), "model-roughness": new ha(Ct.paint_model["model-roughness"]), "model-height-based-emissive-strength-multiplier": new ha(Ct.paint_model["model-height-based-emissive-strength-multiplier"]), "model-cutoff-fade-range": new ca(Ct.paint_model["model-cutoff-fade-range"]) }), layout: zv };
        const Pv = new Float32Array(262144), Rv = new Uint8Array(262144);
        function Lv(e2) {
          let t2 = 0;
          if (e2.meshes)
            for (const i2 of e2.meshes)
              t2 = Math.max(t2, i2.aabb.max[2]);
          if (e2.children)
            for (const i2 of e2.children)
              t2 = Math.max(t2, Lv(i2));
          return t2;
        }
        const kv = ["", "wall", "door", "roof", "window", "lamp", "logo"];
        class Ov {
          constructor(e2) {
            this.node = e2, this.evaluatedRMEA = [[1, 0, 0, 1], [1, 0, 0, 1], [1, 0, 0, 1], [1, 0, 0, 1], [0.4, 1, 0, 1], [1, 0, 0, 1], [1, 0, 0, 1]], this.hiddenByReplacement = false, this.evaluatedScale = [1, 1, 1], this.evaluatedColor = [], this.emissionHeightBasedParams = [], this.feature = { type: "Point", id: e2.id, geometry: [], properties: { height: Lv(e2) } };
          }
        }
        class Bv {
          constructor(e2, t2, i2, r2) {
            this.nodes = e2, this.id = t2, this.modelTraits |= 1, this.uploaded = false, this.hasPattern = false, i2 && (this.modelTraits |= 4), this.zoom = -1, this.terrainExaggeration = 1, this.projection = { name: "mercator" }, this.replacementUpdateTime = 0, this.elevationReadFromZ = 255, this.brightness = r2, this.dirty = true, this.needsUpload = false;
          }
          update() {
            console.log("Update 3D model bucket");
          }
          populate() {
            console.log("populate 3D model bucket");
          }
          uploadPending() {
            return !this.uploaded || this.needsUpload;
          }
          upload(e2) {
            if (!this.needsUpload)
              return;
            const t2 = this.getNodesInfo();
            for (const i2 of t2) {
              const t3 = i2.node;
              this.uploaded ? this.updatePbrBuffer(t3) : Ev(t3, e2, true);
            }
            for (const e3 of t2)
              Mv(e3.node);
            this.uploaded = true, this.needsUpload = false;
          }
          updatePbrBuffer(e2) {
            let t2 = false;
            if (!e2.meshes)
              return t2;
            for (const i2 of e2.meshes)
              i2.pbrBuffer && (i2.pbrBuffer.updateData(i2.featureArray), t2 = true);
            return t2;
          }
          needsReEvaluation(e2, t2, i2) {
            const r2 = e2.transform.projectionOptions, n2 = e2.style.getBrightness(), o2 = this.brightness !== n2;
            return !!(!this.uploaded || this.dirty || r2.name !== this.projection.name || Fv(i2.paint.get("model-color").value, o2) || Fv(i2.paint.get("model-color-mix-intensity").value, o2) || Fv(i2.paint.get("model-roughness").value, o2) || Fv(i2.paint.get("model-emissive-strength").value, o2) || Fv(i2.paint.get("model-height-based-emissive-strength-multiplier").value, o2)) && (this.projection = r2, this.brightness = n2, true);
          }
          evaluateScale(e2, t2) {
            if (e2.transform.zoom === this.zoom)
              return;
            this.zoom = e2.transform.zoom;
            const i2 = this.getNodesInfo(), r2 = this.id.canonical;
            for (const e3 of i2) {
              const i3 = e3.feature;
              e3.evaluatedScale = t2.paint.get("model-scale").evaluate(i3, {}, r2);
            }
          }
          evaluate(e2) {
            const t2 = this.getNodesInfo();
            for (const i2 of t2) {
              if (!i2.node.meshes)
                continue;
              const t3 = i2.feature, r2 = i2.node.meshes && i2.node.meshes[0].featureData, n2 = i2.evaluatedColor[2], o2 = i2.evaluatedRMEA[2], s2 = this.id.canonical;
              if (i2.hasTranslucentParts = false, r2) {
                for (let r3 = 0; r3 < kv.length; r3++) {
                  const n3 = kv[r3];
                  n3.length && (t3.properties.part = n3);
                  const o3 = e2.paint.get("model-color").evaluate(t3, {}, s2), a2 = e2.paint.get("model-color-mix-intensity").evaluate(t3, {}, s2);
                  i2.evaluatedColor[r3] = [o3.r, o3.g, o3.b, a2], i2.evaluatedRMEA[r3][0] = e2.paint.get("model-roughness").evaluate(t3, {}, s2), i2.evaluatedRMEA[r3][2] = e2.paint.get("model-emissive-strength").evaluate(t3, {}, s2), i2.evaluatedRMEA[r3][3] = o3.a, i2.emissionHeightBasedParams[r3] = e2.paint.get("model-height-based-emissive-strength-multiplier").evaluate(t3, {}, s2), !i2.hasTranslucentParts && o3.a < 1 && (i2.hasTranslucentParts = true);
                }
                delete t3.properties.part, Uv(i2, n2 !== i2.evaluatedColor[2] || o2 !== i2.evaluatedRMEA[2]);
              }
              i2.evaluatedScale = e2.paint.get("model-scale").evaluate(t3, {}, s2), this.updatePbrBuffer(i2.node) || (this.needsUpload = true);
            }
            this.dirty = false;
          }
          elevationUpdate(e2, t2, i2, r2) {
            const n2 = e2.findDEMTileFor(i2);
            if (n2 && (n2.tileID.canonical !== this.terrainTile || t2 !== this.terrainExaggeration)) {
              if (n2.dem && n2.tileID.overscaledZ !== this.elevationReadFromZ) {
                this.elevationReadFromZ = n2.tileID.overscaledZ;
                const t3 = qm.create(e2, i2, n2);
                if (!t3)
                  return;
                4 & this.modelTraits && this.updateDEM(e2, t3, i2, r2);
                for (const e3 of this.getNodesInfo()) {
                  const i3 = e3.node;
                  if (!i3.footprint || !i3.footprint.vertices || !i3.footprint.vertices.length)
                    continue;
                  const r3 = i3.footprint.vertices;
                  let n3 = t3.getElevationAt(r3[0].x, r3[0].y, true, true);
                  for (let e4 = 1; e4 < r3.length; e4++)
                    n3 = Math.min(n3, t3.getElevationAt(r3[e4].x, r3[e4].y, true, true));
                  i3.elevation = n3;
                }
              }
              this.terrainTile = n2.tileID.canonical, this.terrainExaggeration = t2;
            }
          }
          updateDEM(e2, t2, i2, r2) {
            let n2 = t2._dem._modifiedForSources[r2];
            if (void 0 === n2 && (t2._dem._modifiedForSources[r2] = [], n2 = t2._dem._modifiedForSources[r2]), n2.includes(i2.canonical))
              return;
            const o2 = t2._dem.dim;
            n2.push(i2.canonical);
            let s2 = false;
            for (const e3 of this.getNodesInfo()) {
              const i3 = e3.node;
              if (!i3.footprint || !i3.footprint.grid)
                continue;
              const r3 = i3.footprint.grid, n3 = t2.tileCoordToPixel(r3.min.x, r3.min.y), a2 = t2.tileCoordToPixel(r3.max.x, r3.max.y), l2 = Math.min(Math.min(o2 - a2.y, n3.x), Math.min(n3.y, o2 - a2.x));
              if (l2 < 0)
                continue;
              const c2 = z(l2, 2, 5);
              let h2 = Math.max(0, n3.x - c2), u2 = Math.max(0, n3.y - c2), d2 = Math.min(a2.x + c2, o2 - 1), p2 = Math.min(a2.y + c2, o2 - 1);
              for (let e4 = u2; e4 <= p2; ++e4)
                for (let t3 = h2; t3 <= d2; ++t3)
                  Rv[e4 * o2 + t3] = 255;
              let f2 = 0, m2 = 0;
              for (let e4 = 0; e4 < r3.cellsY; ++e4)
                for (let i4 = 0; i4 < r3.cellsX; ++i4) {
                  if (!r3.cells[e4 * r3.cellsX + i4])
                    continue;
                  const n4 = t2.tileCoordToPixel(r3.min.x + i4 / r3.xScale, r3.min.y + e4 / r3.yScale), s3 = t2.tileCoordToPixel(r3.min.x + (i4 + 1) / r3.xScale, r3.min.y + (e4 + 1) / r3.yScale);
                  for (let e5 = n4.y; e5 <= Math.min(s3.y + 1, o2 - 1); ++e5)
                    for (let i5 = n4.x; i5 <= Math.min(s3.x + 1, o2 - 1); ++i5)
                      255 === Rv[e5 * o2 + i5] && (Rv[e5 * o2 + i5] = 0, f2 += t2.getElevationAtPixel(i5, e5), m2++);
                }
              const _2 = f2 / m2;
              h2 = Math.max(1, n3.x - c2), u2 = Math.max(1, n3.y - c2), d2 = Math.min(a2.x + c2, o2 - 2), p2 = Math.min(a2.y + c2, o2 - 2), s2 = true;
              for (let e4 = u2; e4 <= p2; ++e4)
                for (let i4 = h2; i4 <= d2; ++i4)
                  0 === Rv[e4 * o2 + i4] && (Pv[e4 * o2 + i4] = t2._dem.set(i4, e4, _2));
              for (let e4 = 1; e4 < c2; ++e4) {
                h2 = Math.max(1, n3.x - e4), u2 = Math.max(1, n3.y - e4), d2 = Math.min(a2.x + e4, o2 - 2), p2 = Math.min(a2.y + e4, o2 - 2);
                for (let i4 = u2; i4 <= p2; ++i4)
                  for (let r4 = h2; r4 <= d2; ++r4) {
                    const n4 = i4 * o2 + r4;
                    if (255 === Rv[n4]) {
                      let s3 = 0, a3 = 0, l3 = -1, h3 = -1;
                      for (let t3 = -1; t3 <= 1; ++t3)
                        for (let n5 = -1; n5 <= 1; ++n5) {
                          const c3 = (i4 + t3) * o2 + r4 + n5;
                          if (Rv[c3] >= e4)
                            continue;
                          const u3 = Pv[c3], d3 = Math.abs(u3);
                          d3 > a3 && (s3 = u3, a3 = d3, l3 = n5, h3 = t3);
                        }
                      if (a3 > 0.1) {
                        const o3 = 1 - (e4 + 0.5 * Math.abs(l3 * h3)) / c2;
                        let a4 = t2._dem.get(r4, i4) + s3 * o3;
                        const u3 = t2._dem.get(r4 + l3, i4 + h3), d3 = t2._dem.get(r4 - l3, i4 - h3, true);
                        (a4 - u3) * (a4 - d3) > 0 && (a4 = (u3 + d3) / 2), Pv[n4] = t2._dem.set(r4, i4, a4), Rv[n4] = e4;
                      }
                    }
                  }
              }
            }
            s2 && (t2._demTile.needsDEMTextureUpload = true, t2._dem._timestamp = ht.now());
          }
          getNodesInfo() {
            if (!this.nodesInfo) {
              this.nodesInfo = [];
              for (const e2 of this.nodes)
                this.nodesInfo.push(new Ov(e2));
              this.freeNodes();
            }
            return this.nodesInfo;
          }
          freeNodes() {
            if (this.nodes) {
              for (const e2 of this.nodes)
                Av(e2);
              this.nodes.splice(0, this.nodes.length);
            }
          }
          destroy() {
            this.freeNodes();
            const e2 = this.getNodesInfo();
            for (const t2 of e2)
              Mv(t2.node), Av(t2.node);
          }
          isEmpty() {
            return !this.nodes.length;
          }
          updateReplacement(e2, t2) {
            if (t2.updateTime === this.replacementUpdateTime)
              return;
            this.replacementUpdateTime = t2.updateTime;
            const i2 = t2.getReplacementRegionsForTile(e2.toUnwrapped()), r2 = this.getNodesInfo();
            for (let e3 = 0; e3 < this.nodesInfo.length; e3++) {
              const t3 = r2[e3].node;
              r2[e3].hiddenByReplacement = !!t3.footprint && !i2.find((e4) => e4.footprint === t3.footprint);
            }
          }
          getHeightAtTileCoord(e2, t2) {
            const i2 = this.getNodesInfo(), r2 = [];
            for (let n2 = 0; n2 < this.nodesInfo.length; n2++) {
              const o2 = i2[n2], s2 = o2.node.meshes[0];
              if (e2 < s2.aabb.min[0] || t2 < s2.aabb.min[1] || e2 > s2.aabb.max[0] || t2 > s2.aabb.max[1])
                continue;
              const a2 = (e2 - s2.aabb.min[0]) / (s2.aabb.max[0] - s2.aabb.min[0]) * xv | 0, l2 = Math.min(63, (t2 - s2.aabb.min[1]) / (s2.aabb.max[1] - s2.aabb.min[1]) * xv | 0) * xv + Math.min(63, a2);
              if (!(s2.heightmap[l2] < 0 && o2.node.footprint)) {
                if (o2.hiddenByReplacement)
                  return;
                return { height: s2.heightmap[l2], maxHeight: o2.feature.properties.height, hidden: false, verticalScale: o2.evaluatedScale[2] };
              }
              if (o2.node.footprint.grid.query(new y(e2, t2), new y(e2, t2), r2), r2.length > 0)
                return { height: void 0, maxHeight: o2.feature.properties.height, hidden: o2.hiddenByReplacement, verticalScale: o2.evaluatedScale[2] };
            }
          }
        }
        function Fv(e2, t2) {
          return !e2.isLightConstant && t2;
        }
        function Nv(e2, t2, i2, r2, n2, o2, s2, a2) {
          let l2 = (61440 & t2 | (61440 & t2) >> 4) >> 8, c2 = (3840 & t2 | (3840 & t2) >> 4) >> 4, h2 = 240 & t2 | (240 & t2) >> 4;
          i2[3] > 0 && (l2 = Wr(l2, 255 * i2[0], i2[3]), c2 = Wr(c2, 255 * i2[1], i2[3]), h2 = Wr(h2, 255 * i2[2], i2[3]));
          const u2 = l2 << 8 | c2, d2 = h2 << 8 | Math.floor(255 * r2[3]), p2 = function(e3) {
            const t3 = z(e3, 0, 2);
            return Math.min(Math.round(0.5 * t3 * 255), 255);
          }(r2[2]) << 8 | 15 * r2[0] << 4 | 15 * r2[1], f2 = z(n2[0], 0, 1), m2 = z(n2[1], 0, 1), _2 = z(n2[2], 0, 1), g2 = z(n2[3], 0, 1);
          let y2, x2, v2, b2;
          if (f2 !== m2 && s2 !== o2 && m2 !== f2) {
            const e3 = s2 - o2;
            x2 = 1 / (e3 * (m2 - f2)), v2 = -(o2 + e3 * f2) / (e3 * (m2 - f2));
            const t3 = z(n2[4], -1, 1);
            b2 = Math.pow(10, t3), y2 = 255 * _2 << 8 | 255 * g2;
          } else
            y2 = 65535, x2 = 0, v2 = 1, b2 = 1;
          if (e2.emplaceBack(u2, d2, p2, y2, x2, v2, b2), a2) {
            const e3 = a2.length;
            a2.clear();
            for (let t3 = 0; t3 < e3; t3++)
              a2.emplaceBack(u2, d2, p2, y2, x2, v2, b2);
          }
        }
        function Uv(e2, t2) {
          const i2 = e2.node;
          let r2 = 0;
          for (const n2 of i2.meshes) {
            if (i2.lights && i2.lightMeshIndex === r2)
              continue;
            if (!n2.featureData)
              continue;
            n2.featureArray = new Ka(), n2.featureArray.reserve(n2.featureData.length);
            let o2 = t2;
            for (const t3 of n2.featureData) {
              let r3;
              const s2 = 65535 & t3, a2 = (15 & s2) < 8 ? 15 & s2 : 0, l2 = t3 >> 16 & 65535, c2 = e2.evaluatedRMEA[a2], h2 = e2.evaluatedColor[a2], u2 = e2.emissionHeightBasedParams[a2];
              if (o2 && 2 === a2 && i2.lights && (r3 = new Ka(), r3.resize(10 * i2.lights.length)), Nv(n2.featureArray, l2, h2, c2, u2, n2.aabb.min[2], n2.aabb.max[2], r3), r3 && o2) {
                o2 = false;
                const e3 = i2.meshes[i2.lightMeshIndex];
                e3.featureArray = r3, e3.featureArray._trim();
              }
            }
            n2.featureArray._trim(), r2++;
          }
        }
        Is(Bv, "Tiled3dModelBucket", { omit: ["layers"] }), Is(Ov, "Tiled3dModelFeature");
        class Vv {
          constructor() {
            this._updateTime = 0, this._sourceIds = [], this._activeRegions = [], this._prevRegions = [];
          }
          clear() {
            this._activeRegions.length > 0 && ++this._updateTime, this._activeRegions = [], this._prevRegions = [];
          }
          get updateTime() {
            return this._updateTime;
          }
          getReplacementRegionsForTile(e2) {
            const t2 = Zv(new y(0, 0), new y(sr, sr), e2), i2 = [];
            for (const r2 of this._activeRegions) {
              if (r2.hiddenByOverlap)
                continue;
              if (!qv(t2, r2))
                continue;
              const n2 = $v(r2.min, r2.max, e2);
              i2.push({ min: n2.min, max: n2.max, sourceId: this._sourceIds[r2.priority], footprint: r2.footprint, footprintTileId: r2.tileId });
            }
            return i2;
          }
          setSources(e2) {
            this._setSources(e2.map((e3) => ({ getSourceId: () => e3.cache.id, getFootprints: () => {
              const t2 = [];
              for (const i2 of e3.cache.getVisibleCoordinates()) {
                const r2 = e3.cache.getTile(i2).buckets[e3.layer];
                if (r2)
                  for (const e4 of r2.getNodesInfo()) {
                    const r3 = e4.node;
                    r3.footprint && t2.push({ footprint: r3.footprint, id: i2.toUnwrapped() });
                  }
              }
              return t2;
            } })));
          }
          _addSource(e2) {
            const t2 = e2.getFootprints();
            if (0 !== t2.length) {
              for (const e3 of t2) {
                if (!e3.footprint)
                  continue;
                const t3 = Zv(e3.footprint.min, e3.footprint.max, e3.id);
                this._activeRegions.push({ min: t3.min, max: t3.max, hiddenByOverlap: false, priority: this._sourceIds.length, tileId: e3.id, footprint: e3.footprint });
              }
              this._sourceIds.push(e2.getSourceId());
            }
          }
          _computeReplacement() {
            this._activeRegions.sort((e3, t2) => e3.priority - t2.priority || jv(e3.min, t2.min) || jv(e3.max, t2.max));
            let e2 = this._activeRegions.length !== this._prevRegions.length;
            if (!e2) {
              let t2 = 0, i2 = 0;
              for (; !e2 && t2 !== this._activeRegions.length; ) {
                const r2 = this._activeRegions[t2], n2 = this._prevRegions[i2];
                e2 = r2.priority !== n2.priority || !Gv(r2, n2), ++t2, ++i2;
              }
            }
            if (e2) {
              ++this._updateTime;
              const e3 = (e4) => {
                const t2 = this._activeRegions;
                if (e4 >= t2.length)
                  return e4;
                const i2 = t2[e4].priority;
                for (; e4 < t2.length && t2[e4].priority === i2; )
                  ++e4;
                return e4;
              };
              if (this._sourceIds.length > 1) {
                let t2 = 0, i2 = e3(t2);
                for (; t2 !== i2; ) {
                  let r2 = t2;
                  const n2 = t2;
                  for (; r2 !== i2; ) {
                    const e4 = this._activeRegions[r2];
                    e4.hiddenByOverlap = false;
                    for (let t3 = 0; t3 < n2; t3++) {
                      const i3 = this._activeRegions[t3];
                      if (!i3.hiddenByOverlap && qv(e4, i3) && (e4.hiddenByOverlap = Wv(e4.footprint, e4.tileId, i3.footprint, i3.tileId), e4.hiddenByOverlap))
                        break;
                    }
                    ++r2;
                  }
                  t2 = i2, i2 = e3(t2);
                }
              }
            }
          }
          _setSources(e2) {
            [this._prevRegions, this._activeRegions] = [this._activeRegions, []], this._sourceIds = [];
            for (let t2 = e2.length - 1; t2 >= 0; t2--)
              this._addSource(e2[t2]);
            this._computeReplacement();
          }
        }
        function jv(e2, t2) {
          return e2.x - t2.x || e2.y - t2.y;
        }
        function Gv(e2, t2) {
          return 0 === jv(e2.min, t2.min) && 0 === jv(e2.max, t2.max);
        }
        function qv(e2, t2) {
          return !(e2.min.x > t2.max.x || e2.max.x < t2.min.x || e2.min.y > t2.max.y || e2.max.y < t2.min.y);
        }
        function Zv(e2, t2, i2) {
          const r2 = 1 / sr, n2 = 1 / (1 << i2.canonical.z), o2 = (t2.x * r2 + i2.canonical.x) * n2 + i2.wrap, s2 = (t2.y * r2 + i2.canonical.y) * n2;
          return { min: new y((e2.x * r2 + i2.canonical.x) * n2 + i2.wrap, (e2.y * r2 + i2.canonical.y) * n2), max: new y(o2, s2) };
        }
        function $v(e2, t2, i2) {
          const r2 = 1 << i2.canonical.z, n2 = ((t2.x - i2.wrap) * r2 - i2.canonical.x) * sr, o2 = (t2.y * r2 - i2.canonical.y) * sr;
          return { min: new y(((e2.x - i2.wrap) * r2 - i2.canonical.x) * sr, (e2.y * r2 - i2.canonical.y) * sr), max: new y(n2, o2) };
        }
        function Hv(e2, t2, i2, r2, n2, o2, s2) {
          const a2 = e2.indices, l2 = e2.vertices, c2 = [];
          for (let h2 = r2; h2 < r2 + n2; h2 += 3) {
            const r3 = t2[i2[h2 + 0] + o2], n3 = t2[i2[h2 + 1] + o2], u2 = t2[i2[h2 + 2] + o2], d2 = Math.min(r3.x, n3.x, u2.x), p2 = Math.max(r3.x, n3.x, u2.x), f2 = Math.min(r3.y, n3.y, u2.y), m2 = Math.max(r3.y, n3.y, u2.y);
            c2.length = 0, e2.grid.query(new y(d2, f2), new y(p2, m2), c2);
            for (let e3 = 0; e3 < c2.length; e3++) {
              const t3 = c2[e3];
              if (Ap(l2[a2[3 * t3 + 0]], l2[a2[3 * t3 + 1]], l2[a2[3 * t3 + 2]], r3, n3, u2, s2))
                return true;
            }
          }
          return false;
        }
        function Wv(e2, t2, i2, r2) {
          if (!e2 || !i2)
            return false;
          let n2 = e2.vertices;
          if (!t2.canonical.equals(r2.canonical) || t2.wrap !== r2.wrap) {
            if (i2.vertices.length < e2.vertices.length)
              return Wv(i2, r2, e2, t2);
            const o2 = t2.canonical, s2 = r2.canonical, a2 = Math.pow(2, s2.z - o2.z);
            n2 = e2.vertices.map((e3) => new y(e3.x * o2.x * sr * a2 - s2.x * sr, e3.y * o2.y * sr * a2 - s2.y * sr));
          }
          return Hv(i2, n2, e2.indices, 0, e2.indices.length, 0, 0);
        }
        const Xv = im.types, Yv = ["fill-extrusion-base", "fill-extrusion-height", "fill-extrusion-color", "fill-extrusion-pattern", "fill-extrusion-flood-light-wall-radius"], Kv = ["fill-extrusion-flood-light-ground-radius"], Jv = Math.pow(2, 13), Qv = Math.pow(2, 15) - 1, eb = new y(0, 1), tb = 2147483648;
        function ib(e2, t2, i2, r2, n2, o2, s2, a2) {
          e2.emplaceBack((t2 << 1) + s2, (i2 << 1) + o2, (Math.floor(r2 * Jv) << 1) + n2, Math.round(a2));
        }
        function rb(e2, t2, i2, r2, n2, o2) {
          e2.emplaceBack(t2.x, t2.y, (i2.x << 1) + r2, (i2.y << 1) + n2, o2);
        }
        function nb(e2, t2, i2) {
          const r2 = 16384;
          e2.emplaceBack(t2.x, t2.y, t2.z, i2[0] * r2, i2[1] * r2, i2[2] * r2);
        }
        class ob {
          constructor() {
            this.vertexOffset = 0, this.vertexCount = 0, this.indexOffset = 0, this.indexCount = 0;
          }
        }
        class sb {
          constructor() {
            this.centroidXY = new y(0, 0), this.vertexArrayOffset = 0, this.vertexCount = 0, this.groundVertexArrayOffset = 0, this.groundVertexCount = 0, this.flags = 0, this.footprintSegIdx = -1, this.footprintSegLen = 0, this.min = new y(Number.MAX_VALUE, Number.MAX_VALUE), this.max = new y(-Number.MAX_VALUE, -Number.MAX_VALUE), this.height = 0;
          }
          span() {
            return new y(this.max.x - this.min.x, this.max.y - this.min.y);
          }
        }
        class ab {
          constructor() {
            this.acc = new y(0, 0), this.accCount = 0, this.centroidDataIndex = 0;
          }
          startRing(e2, t2) {
            e2.min.x === Number.MAX_VALUE && (e2.min.x = e2.max.x = t2.x, e2.min.y = e2.max.y = t2.y);
          }
          appendEdge(e2, t2, i2) {
            this.accCount++, this.acc._add(t2);
            let r2 = !!this.borders;
            t2.x < e2.min.x ? (e2.min.x = t2.x, r2 = true) : t2.x > e2.max.x && (e2.max.x = t2.x, r2 = true), t2.y < e2.min.y ? (e2.min.y = t2.y, r2 = true) : t2.y > e2.max.y && (e2.max.y = t2.y, r2 = true), ((0 === t2.x || t2.x === sr) && t2.x === i2.x) != ((0 === t2.y || t2.y === sr) && t2.y === i2.y) && this.processBorderOverlap(t2, i2), r2 && this.checkBorderIntersection(t2, i2);
          }
          checkBorderIntersection(e2, t2) {
            t2.x < 0 != e2.x < 0 && this.addBorderIntersection(0, Wr(t2.y, e2.y, (0 - t2.x) / (e2.x - t2.x))), t2.x > sr != e2.x > sr && this.addBorderIntersection(1, Wr(t2.y, e2.y, (sr - t2.x) / (e2.x - t2.x))), t2.y < 0 != e2.y < 0 && this.addBorderIntersection(2, Wr(t2.x, e2.x, (0 - t2.y) / (e2.y - t2.y))), t2.y > sr != e2.y > sr && this.addBorderIntersection(3, Wr(t2.x, e2.x, (sr - t2.y) / (e2.y - t2.y)));
          }
          addBorderIntersection(e2, t2) {
            this.borders || (this.borders = [[Number.MAX_VALUE, -Number.MAX_VALUE], [Number.MAX_VALUE, -Number.MAX_VALUE], [Number.MAX_VALUE, -Number.MAX_VALUE], [Number.MAX_VALUE, -Number.MAX_VALUE]]);
            const i2 = this.borders[e2];
            t2 < i2[0] && (i2[0] = t2), t2 > i2[1] && (i2[1] = t2);
          }
          processBorderOverlap(e2, t2) {
            if (e2.x === t2.x) {
              if (e2.y === t2.y)
                return;
              const i2 = 0 === e2.x ? 0 : 1;
              this.addBorderIntersection(i2, t2.y), this.addBorderIntersection(i2, e2.y);
            } else {
              const i2 = 0 === e2.y ? 2 : 3;
              this.addBorderIntersection(i2, t2.x), this.addBorderIntersection(i2, e2.x);
            }
          }
          centroid() {
            return 0 === this.accCount ? new y(0, 0) : new y(Math.floor(Math.max(0, this.acc.x) / this.accCount), Math.floor(Math.max(0, this.acc.y) / this.accCount));
          }
          intersectsCount() {
            return this.borders ? this.borders.reduce((e2, t2) => e2 + +(t2[0] !== Number.MAX_VALUE), 0) : 0;
          }
        }
        function lb(e2, t2) {
          const i2 = e2.add(t2)._unit(), r2 = z(e2.x * i2.x + e2.y * i2.y, -1, 1);
          var n2, o2, s2;
          return n2 = Math.acos(r2), Math.min(4, Math.max(-4, Math.tan(n2))) / 4 * Qv * ((o2 = e2).x * (s2 = t2).y - o2.y * s2.x < 0 ? -1 : 1);
        }
        const cb = [(e2) => e2.x < 0, (e2) => e2.x > sr, (e2) => e2.y < 0, (e2) => e2.y > sr];
        function hb(e2, t2, i2, r2) {
          const n2 = [4];
          if (0 === r2)
            return n2;
          i2._mult(r2);
          const o2 = e2.sub(i2), s2 = t2.sub(i2), a2 = [e2, t2, o2, s2];
          for (let e3 = 0; e3 < 4; e3++)
            for (const t3 of a2)
              if (cb[e3](t3)) {
                n2.push(e3);
                break;
              }
          return n2;
        }
        class ub {
          constructor(e2) {
            this.vertexArray = new Aa(), this.indexArray = new Va(), this.programConfigurations = new Hl(e2.layers, e2.zoom, (e3) => Kv.includes(e3)), this._segments = new dl(), this.hiddenByLandmarkVertexArray = new Ja(), this._segmentToGroundQuads = {}, this._segmentToGroundQuads[0] = [], this._segmentToRegionTriCounts = {}, this._segmentToRegionTriCounts[0] = [0, 0, 0, 0, 0], this.regionSegments = {}, this.regionSegments[4] = new dl();
          }
          getDefaultSegment() {
            return this.regionSegments[4];
          }
          hasData() {
            return 0 !== this.vertexArray.length;
          }
          addData(e2, t2, i2, r2 = false) {
            const n2 = e2.length;
            if (n2 > 2) {
              let o2 = Math.max(0, this._segments.get().length - 1);
              const s2 = this._segments._prepareSegment(4 * n2, this.vertexArray.length, 2 * this._segmentToGroundQuads[o2].length);
              let a2;
              o2 !== this._segments.get().length - 1 && (o2++, this._segmentToGroundQuads[o2] = [], this._segmentToRegionTriCounts[o2] = [0, 0, 0, 0, 0]);
              {
                const t3 = e2[0], i3 = e2[1];
                a2 = lb(t3.sub(e2[n2 - 1])._perp()._unit(), i3.sub(t3)._perp()._unit());
              }
              for (let l2 = 0; l2 < n2; l2++) {
                const c2 = l2 === n2 - 1 ? 0 : l2 + 1, h2 = e2[l2], u2 = e2[c2], d2 = e2[c2 === n2 - 1 ? 0 : c2 + 1], p2 = u2.sub(h2)._perp()._unit(), f2 = lb(p2, d2.sub(u2)._perp()._unit()), m2 = a2, _2 = f2;
                if (_b(h2, u2, t2) || r2 && gb(h2, t2) && gb(u2, t2)) {
                  a2 = f2;
                  continue;
                }
                const g2 = s2.vertexLength;
                rb(this.vertexArray, h2, u2, 1, 1, m2), rb(this.vertexArray, h2, u2, 1, 0, m2), rb(this.vertexArray, h2, u2, 0, 1, _2), rb(this.vertexArray, h2, u2, 0, 0, _2), s2.vertexLength += 4;
                const y2 = hb(h2, u2, p2, i2);
                for (const e3 of y2)
                  this._segmentToGroundQuads[o2].push({ id: g2, region: e3 }), this._segmentToRegionTriCounts[o2][e3] += 2, s2.primitiveLength += 2;
                a2 = f2;
              }
            }
          }
          prepareBorderSegments() {
            if (!this.hasData())
              return;
            const e2 = this._segments.get(), t2 = e2.length;
            for (let e3 = 0; e3 < t2; e3++)
              this._segmentToGroundQuads[e3].sort((e4, t3) => e4.region - t3.region);
            for (let i2 = 0; i2 < t2; i2++) {
              const t3 = this._segmentToGroundQuads[i2], r2 = e2[i2], n2 = this._segmentToRegionTriCounts[i2];
              n2.reduce((e3, t4) => e3 + t4, 0);
              let o2 = 0;
              for (let e3 = 0; e3 <= 4; e3++) {
                const t4 = n2[e3];
                if (0 !== t4) {
                  let i3 = this.regionSegments[e3];
                  i3 || (i3 = this.regionSegments[e3] = new dl());
                  const n3 = { vertexOffset: r2.vertexOffset, primitiveOffset: r2.primitiveOffset + o2, vertexLength: r2.vertexLength, primitiveLength: t4 };
                  i3.get().push(n3);
                }
                o2 += t4;
              }
              for (let e3 = 0; e3 < t3.length; e3++) {
                const i3 = t3[e3].id;
                this.indexArray.emplaceBack(i3, i3 + 1, i3 + 3), this.indexArray.emplaceBack(i3, i3 + 3, i3 + 2);
              }
            }
            this._segmentToGroundQuads = null, this._segmentToRegionTriCounts = null, this._segments.destroy(), this._segments = null;
          }
          addPaintPropertiesData(e2, t2, i2, r2, n2, o2) {
            this.hasData() && this.programConfigurations.populatePaintArrays(this.vertexArray.length, e2, t2, i2, r2, n2, o2);
          }
          upload(e2) {
            this.hasData() && (this.vertexBuffer = e2.createVertexBuffer(this.vertexArray, Ff.members), this.indexBuffer = e2.createIndexBuffer(this.indexArray));
          }
          uploadPaintProperties(e2) {
            this.hasData() && this.programConfigurations.upload(e2);
          }
          update(e2, t2, i2, r2, n2, o2) {
            this.hasData() && this.programConfigurations.updatePaintArrays(e2, t2, i2, r2, n2, o2);
          }
          updateHiddenByLandmark(e2) {
            if (!this.hasData())
              return;
            const t2 = e2.groundVertexCount + e2.groundVertexArrayOffset;
            if (0 === e2.groundVertexCount)
              return;
            const i2 = e2.flags & tb ? 1 : 0;
            for (let r2 = e2.groundVertexArrayOffset; r2 < t2; ++r2)
              this.hiddenByLandmarkVertexArray.emplace(r2, i2);
            this._needsHiddenByLandmarkUpdate = true;
          }
          uploadHiddenByLandmark(e2) {
            this.hasData() && this._needsHiddenByLandmarkUpdate && (!this.hiddenByLandmarkVertexBuffer && this.hiddenByLandmarkVertexArray.length > 0 ? this.hiddenByLandmarkVertexBuffer = e2.createVertexBuffer(this.hiddenByLandmarkVertexArray, Uf.members, true) : this.hiddenByLandmarkVertexBuffer && this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray), this._needsHiddenByLandmarkUpdate = false);
          }
          destroy() {
            if (this.vertexBuffer) {
              this.vertexBuffer.destroy(), this.indexBuffer.destroy(), this.hiddenByLandmarkVertexBuffer && this.hiddenByLandmarkVertexBuffer.destroy(), this._segments && this._segments.destroy(), this.programConfigurations.destroy();
              for (let e2 = 0; e2 <= 4; e2++) {
                const t2 = this.regionSegments[e2];
                t2 && t2.destroy();
              }
            }
          }
        }
        class db {
          constructor(e2) {
            this.zoom = e2.zoom, this.canonical = e2.canonical, this.overscaling = e2.overscaling, this.layers = e2.layers, this.layerIds = this.layers.map((e3) => e3.fqid), this.index = e2.index, this.hasPattern = false, this.edgeRadius = 0, this.projection = e2.projection, this.activeReplacements = [], this.replacementUpdateTime = 0, this.centroidData = [], this.footprintIndices = new Va(), this.footprintVertices = new Ta(), this.footprintSegments = [], this.layoutVertexArray = new Ma(), this.centroidVertexArray = new cl(), this.indexArray = new Va(), this.programConfigurations = new Hl(e2.layers, e2.zoom, (e3) => Yv.includes(e3)), this.segments = new dl(), this.stateDependentLayerIds = this.layers.filter((e3) => e3.isStateDependent()).map((e3) => e3.id), this.groundEffect = new ub(e2), this.maxHeight = 0, this.partLookup = {};
          }
          populate(e2, t2, i2, r2) {
            this.features = [], this.hasPattern = Pf("fill-extrusion", this.layers, t2), this.featuresOnBorder = [], this.borderFeatureIndices = [[], [], [], []], this.borderDoneWithNeighborZ = [-1, -1, -1, -1], this.tileToMeter = Qd(i2), this.edgeRadius = this.layers[0].layout.get("fill-extrusion-edge-radius") / this.tileToMeter;
            for (const { feature: n2, id: o2, index: s2, sourceLayerIndex: a2 } of e2) {
              const e3 = this.layers[0]._featureFilter.needGeometry, l2 = cp(n2, e3);
              if (!this.layers[0]._featureFilter.filter(new ea(this.zoom), l2, i2))
                continue;
              const c2 = { id: o2, sourceLayerIndex: a2, index: s2, geometry: e3 ? l2.geometry : lp(n2, i2, r2), properties: n2.properties, type: n2.type, patterns: {} }, h2 = this.layoutVertexArray.length;
              this.hasPattern ? this.features.push(Rf("fill-extrusion", this.layers, c2, this.zoom, t2)) : this.addFeature(c2, c2.geometry, s2, i2, {}, t2.availableImages, r2, t2.brightness), t2.featureIndex.insert(n2, c2.geometry, s2, a2, this.index, h2);
            }
            this.sortBorders(), this.groundEffect.prepareBorderSegments();
          }
          addFeatures(e2, t2, i2, r2, n2, o2) {
            for (const e3 of this.features) {
              const { geometry: s2 } = e3;
              this.addFeature(e3, s2, e3.index, t2, i2, r2, n2, o2);
            }
            this.sortBorders();
          }
          update(e2, t2, i2, r2, n2) {
            const o2 = 0 !== Object.keys(e2).length;
            if (o2 && !this.stateDependentLayers.length)
              return;
            const s2 = o2 ? this.stateDependentLayers : this.layers;
            this.programConfigurations.updatePaintArrays(e2, t2, s2, i2, r2, n2), this.groundEffect.update(e2, t2, s2, i2, r2, n2);
          }
          isEmpty() {
            return 0 === this.layoutVertexArray.length;
          }
          uploadPending() {
            return !this.uploaded || this.programConfigurations.needsUpload || this.groundEffect.programConfigurations.needsUpload;
          }
          upload(e2) {
            this.uploaded || (this.layoutVertexBuffer = e2.createVertexBuffer(this.layoutVertexArray, jf), this.indexBuffer = e2.createIndexBuffer(this.indexArray), this.layoutVertexExtArray && (this.layoutVertexExtBuffer = e2.createVertexBuffer(this.layoutVertexExtArray, Vf.members, true)), this.groundEffect.upload(e2)), this.groundEffect.uploadPaintProperties(e2), this.programConfigurations.upload(e2), this.uploaded = true;
          }
          uploadCentroid(e2) {
            this.groundEffect.uploadHiddenByLandmark(e2), this.needsCentroidUpdate && (!this.centroidVertexBuffer && this.centroidVertexArray.length > 0 ? this.centroidVertexBuffer = e2.createVertexBuffer(this.centroidVertexArray, Nf.members, true) : this.centroidVertexBuffer && this.centroidVertexBuffer.updateData(this.centroidVertexArray), this.needsCentroidUpdate = false);
          }
          destroy() {
            this.layoutVertexBuffer && (this.layoutVertexBuffer.destroy(), this.centroidVertexBuffer && this.centroidVertexBuffer.destroy(), this.layoutVertexExtBuffer && this.layoutVertexExtBuffer.destroy(), this.groundEffect.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy());
          }
          addFeature(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(e2, {}) / this.tileToMeter, c2 = [new y(0, 0), new y(sr, sr)], h2 = s2.projection, u2 = "globe" === h2.name, d2 = "Polygon" === Xv[e2.type], p2 = new ab();
            p2.centroidDataIndex = this.centroidData.length;
            const f2 = new sb(), m2 = this.layers[0].paint.get("fill-extrusion-base").evaluate(e2, {}, r2) <= 0, _2 = this.layers[0].paint.get("fill-extrusion-height").evaluate(e2, {}, r2);
            f2.height = _2, f2.vertexArrayOffset = this.layoutVertexArray.length, f2.groundVertexArrayOffset = this.groundEffect.vertexArray.length, u2 && !this.layoutVertexExtArray && (this.layoutVertexExtArray = new Da());
            const g2 = zf(t2, 500);
            for (let e3 = g2.length - 1; e3 >= 0; e3--) {
              const t3 = g2[e3];
              (0 === t3.length || (x2 = t3[0]).every((e4) => e4.x <= 0) || x2.every((e4) => e4.x >= sr) || x2.every((e4) => e4.y <= 0) || x2.every((e4) => e4.y >= sr)) && g2.splice(e3, 1);
            }
            var x2;
            let v2;
            if (u2)
              v2 = bb(g2, c2, r2);
            else {
              v2 = [];
              for (const e3 of g2)
                v2.push({ polygon: e3, bounds: c2 });
            }
            const b2 = d2 ? this.edgeRadius : 0, w2 = b2 > 0 && this.zoom < 17, T2 = (e3, t3) => {
              if (0 === e3.length)
                return false;
              const i3 = e3[e3.length - 1];
              return t3.x === i3.x && t3.y === i3.y;
            };
            for (const { polygon: e3, bounds: t3 } of v2) {
              let i3 = 0, n3 = 0;
              for (const t4 of e3)
                d2 && !t4[0].equals(t4[t4.length - 1]) && t4.push(t4[0]), n3 += d2 ? t4.length - 1 : t4.length;
              const o3 = this.segments.prepareSegment((d2 ? 5 : 4) * n3, this.layoutVertexArray, this.indexArray);
              f2.footprintSegIdx < 0 && (f2.footprintSegIdx = this.footprintSegments.length);
              const s3 = new ob();
              if (s3.vertexOffset = this.footprintVertices.length, s3.indexOffset = 3 * this.footprintIndices.length, s3.ringIndices = [], d2) {
                const n4 = [], a3 = [];
                i3 = o3.vertexLength;
                for (let i4 = 0; i4 < e3.length; i4++) {
                  const c4 = e3[i4];
                  c4.length && 0 !== i4 && a3.push(n4.length / 2);
                  const d3 = [];
                  let p3, f3;
                  p3 = c4[1].sub(c4[0])._perp()._unit(), s3.ringIndices.push(c4.length - 1);
                  for (let e4 = 1; e4 < c4.length; e4++) {
                    const t4 = c4[e4], i5 = c4[e4 === c4.length - 1 ? 1 : e4 + 1], s4 = t4.clone();
                    if (b2) {
                      f3 = i5.sub(t4)._perp()._unit();
                      const e5 = p3.add(f3)._unit(), r3 = b2 * Math.min(4, 1 / (p3.x * e5.x + p3.y * e5.y));
                      s4.x += r3 * e5.x, s4.y += r3 * e5.y, s4.x = Math.round(s4.x), s4.y = Math.round(s4.y), p3 = f3;
                    }
                    !m2 || 0 !== b2 && !w2 || T2(d3, s4) || d3.push(s4), ib(this.layoutVertexArray, s4.x, s4.y, 0, 0, 1, 1, 0), o3.vertexLength++, this.footprintVertices.emplaceBack(t4.x, t4.y), n4.push(t4.x, t4.y), u2 && nb(this.layoutVertexExtArray, h2.projectTilePoint(s4.x, s4.y, r2), h2.upVector(r2, s4.x, s4.y));
                  }
                  m2 && (0 === b2 || w2) && (0 !== d3.length && T2(d3, d3[0]) && d3.pop(), this.groundEffect.addData(d3, t3, l2));
                }
                const c3 = Cf(n4, a3);
                for (let e4 = 0; e4 < c3.length; e4 += 3)
                  this.footprintIndices.emplaceBack(s3.vertexOffset + c3[e4 + 0], s3.vertexOffset + c3[e4 + 1], s3.vertexOffset + c3[e4 + 2]), this.indexArray.emplaceBack(i3 + c3[e4], i3 + c3[e4 + 2], i3 + c3[e4 + 1]), o3.primitiveLength++;
                s3.indexCount += c3.length, s3.vertexCount += this.footprintVertices.length - s3.vertexOffset;
              }
              for (let n4 = 0; n4 < e3.length; n4++) {
                const s4 = e3[n4];
                p2.startRing(f2, s4[0]);
                let a3 = s4.length > 4 && yb(s4[s4.length - 2], s4[0], s4[1]), c3 = b2 ? fb(s4[s4.length - 2], s4[0], s4[1], b2) : 0;
                const _3 = [];
                let g3, y2, x3;
                y2 = s4[1].sub(s4[0])._perp()._unit();
                let v3 = true;
                for (let e4 = 1, n5 = 0; e4 < s4.length; e4++) {
                  let l3 = s4[e4 - 1], d3 = s4[e4];
                  const w3 = s4[e4 === s4.length - 1 ? 1 : e4 + 1];
                  if (p2.appendEdge(f2, d3, l3), _b(d3, l3, t3)) {
                    b2 && (y2 = w3.sub(d3)._perp()._unit(), v3 = !v3);
                    continue;
                  }
                  const E2 = d3.sub(l3)._perp(), M2 = E2.x / (Math.abs(E2.x) + Math.abs(E2.y)), A2 = E2.y > 0 ? 1 : 0, S2 = l3.dist(d3);
                  if (n5 + S2 > 32768 && (n5 = 0), b2) {
                    x3 = w3.sub(d3)._perp()._unit();
                    let e5 = mb(l3, d3, w3, pb(y2, x3), b2);
                    isNaN(e5) && (e5 = 0);
                    const t4 = d3.sub(l3)._unit();
                    l3 = l3.add(t4.mult(c3))._round(), d3 = d3.add(t4.mult(-e5))._round(), c3 = e5, y2 = x3, m2 && this.zoom >= 17 && (T2(_3, l3) || _3.push(l3), T2(_3, d3) || _3.push(d3));
                  }
                  const I2 = o3.vertexLength, C2 = s4.length > 4 && yb(l3, d3, w3);
                  let z2 = xb(n5, a3, v3);
                  if (ib(this.layoutVertexArray, l3.x, l3.y, M2, A2, 0, 0, z2), ib(this.layoutVertexArray, l3.x, l3.y, M2, A2, 0, 1, z2), n5 += S2, z2 = xb(n5, C2, !v3), a3 = C2, ib(this.layoutVertexArray, d3.x, d3.y, M2, A2, 0, 0, z2), ib(this.layoutVertexArray, d3.x, d3.y, M2, A2, 0, 1, z2), o3.vertexLength += 4, this.indexArray.emplaceBack(I2 + 0, I2 + 1, I2 + 2), this.indexArray.emplaceBack(I2 + 1, I2 + 3, I2 + 2), o3.primitiveLength += 2, b2) {
                    const r3 = i3 + (1 === e4 ? s4.length - 2 : e4 - 2), n6 = 1 === e4 ? i3 : r3 + 1;
                    if (this.indexArray.emplaceBack(I2 + 1, r3, I2 + 3), this.indexArray.emplaceBack(r3, n6, I2 + 3), o3.primitiveLength += 2, void 0 === g3 && (g3 = I2), !_b(w3, s4[e4], t3)) {
                      const t4 = e4 === s4.length - 1 ? g3 : o3.vertexLength;
                      this.indexArray.emplaceBack(I2 + 2, I2 + 3, t4), this.indexArray.emplaceBack(I2 + 3, t4 + 1, t4), this.indexArray.emplaceBack(I2 + 3, n6, t4 + 1), o3.primitiveLength += 3;
                    }
                    v3 = !v3;
                  }
                  if (u2) {
                    const e5 = this.layoutVertexExtArray, t4 = h2.projectTilePoint(l3.x, l3.y, r2), i4 = h2.projectTilePoint(d3.x, d3.y, r2), n6 = h2.upVector(r2, l3.x, l3.y), o4 = h2.upVector(r2, d3.x, d3.y);
                    nb(e5, t4, n6), nb(e5, t4, n6), nb(e5, i4, o4), nb(e5, i4, o4);
                  }
                }
                d2 && (i3 += s4.length - 1), m2 && b2 && this.zoom >= 17 && (0 !== _3.length && T2(_3, _3[0]) && _3.pop(), this.groundEffect.addData(_3, t3, l2, b2 > 0));
              }
              this.footprintSegments.push(s3), ++f2.footprintSegLen;
            }
            if (f2.vertexCount = this.layoutVertexArray.length - f2.vertexArrayOffset, f2.groundVertexCount = this.groundEffect.vertexArray.length - f2.groundVertexArrayOffset, 0 !== f2.vertexCount) {
              if (f2.centroidXY = p2.borders ? eb : this.encodeCentroid(p2, f2), this.centroidData.push(f2), p2.borders) {
                this.featuresOnBorder.push(p2);
                const e3 = this.featuresOnBorder.length - 1;
                for (let t3 = 0; t3 < p2.borders.length; t3++)
                  p2.borders[t3][0] !== Number.MAX_VALUE && this.borderFeatureIndices[t3].push(e3);
              }
              this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length, e2, i2, n2, o2, r2, a2), this.groundEffect.addPaintPropertiesData(e2, i2, n2, o2, r2, a2), this.maxHeight = Math.max(this.maxHeight, _2);
            }
          }
          sortBorders() {
            for (let e2 = 0; e2 < this.borderFeatureIndices.length; e2++)
              this.borderFeatureIndices[e2].sort((t2, i2) => this.featuresOnBorder[t2].borders[e2][0] - this.featuresOnBorder[i2].borders[e2][0]);
          }
          encodeCentroid(e2, t2) {
            const i2 = e2.centroid(), r2 = t2.span(), n2 = Math.min(7, Math.round(r2.x * this.tileToMeter / 10)), o2 = Math.min(7, Math.round(r2.y * this.tileToMeter / 10));
            return new y(z(i2.x, 1, sr - 1) << 3 | n2, z(i2.y, 1, sr - 1) << 3 | o2);
          }
          showCentroid(e2) {
            const t2 = this.centroidData[e2.centroidDataIndex];
            t2.flags &= tb, t2.centroidXY.x = 0, t2.centroidXY.y = 0, this.writeCentroidToBuffer(t2);
          }
          writeCentroidToBuffer(e2) {
            this.groundEffect.updateHiddenByLandmark(e2);
            const t2 = e2.vertexArrayOffset, i2 = e2.vertexCount + e2.vertexArrayOffset, r2 = e2.flags & tb ? eb : e2.centroidXY, n2 = this.centroidVertexArray.geta_centroid_pos0(t2);
            if (this.centroidVertexArray.geta_centroid_pos1(t2) !== r2.y || n2 !== r2.x) {
              for (let e3 = t2; e3 < i2; ++e3)
                this.centroidVertexArray.emplace(e3, r2.x, r2.y);
              this.needsCentroidUpdate = true;
            }
          }
          createCentroidsBuffer() {
            this.centroidVertexArray.resize(this.layoutVertexArray.length), this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);
            for (const e2 of this.centroidData)
              this.writeCentroidToBuffer(e2);
          }
          updateReplacement(e2, t2) {
            if (t2.updateTime === this.replacementUpdateTime)
              return;
            this.replacementUpdateTime = t2.updateTime;
            const i2 = t2.getReplacementRegionsForTile(e2.toUnwrapped());
            if (function(e3, t3) {
              if (e3.length !== t3.length)
                return false;
              for (let i3 = 0; i3 < e3.length; i3++)
                if (e3[i3].sourceId !== t3[i3].sourceId || !Gv(e3[i3], t3[i3]))
                  return false;
              return true;
            }(this.activeReplacements, i2))
              return;
            if (this.activeReplacements = i2, 0 === this.centroidVertexArray.length)
              this.createCentroidsBuffer();
            else
              for (const e3 of this.centroidData)
                e3.flags &= 2147483647;
            const r2 = [];
            for (const t3 of this.activeReplacements) {
              const i3 = Math.pow(2, t3.footprintTileId.canonical.z - e2.canonical.z);
              for (const n2 of this.centroidData)
                if (!(n2.flags & tb || t3.min.x > n2.max.x || n2.min.x > t3.max.x || t3.min.y > n2.max.y || n2.min.y > t3.max.y))
                  for (let o2 = 0; o2 < n2.footprintSegLen; o2++) {
                    const s2 = this.footprintSegments[n2.footprintSegIdx + o2];
                    if (r2.length = 0, wb(this.footprintVertices, s2.vertexOffset, s2.vertexCount, t3.footprintTileId.canonical, e2.canonical, r2), Hv(t3.footprint, r2, this.footprintIndices.uint16, s2.indexOffset, s2.indexCount, -s2.vertexOffset, -i3)) {
                      n2.flags |= tb;
                      break;
                    }
                  }
            }
            for (const e3 of this.centroidData)
              this.writeCentroidToBuffer(e3);
            this.borderDoneWithNeighborZ = [-1, -1, -1, -1];
          }
          footprintContainsPoint(e2, t2, i2) {
            let r2 = false;
            for (let n2 = 0; n2 < i2.footprintSegLen; n2++) {
              const o2 = this.footprintSegments[i2.footprintSegIdx + n2];
              let s2 = 0;
              for (const i3 of o2.ringIndices) {
                for (let n3 = s2, a2 = i3 + s2 - 1; n3 < i3 + s2; a2 = n3++) {
                  const i4 = this.footprintVertices.int16[2 * (n3 + o2.vertexOffset) + 0], s3 = this.footprintVertices.int16[2 * (n3 + o2.vertexOffset) + 1], l2 = this.footprintVertices.int16[2 * (a2 + o2.vertexOffset) + 1];
                  s3 > t2 != l2 > t2 && e2 < (this.footprintVertices.int16[2 * (a2 + o2.vertexOffset) + 0] - i4) * (t2 - s3) / (l2 - s3) + i4 && (r2 = !r2);
                }
                s2 = i3;
              }
            }
            return r2;
          }
          getHeightAtTileCoord(e2, t2) {
            let i2 = Number.NEGATIVE_INFINITY, r2 = true;
            const n2 = 4 * (e2 + sr) * sr + (t2 + sr);
            if (this.partLookup.hasOwnProperty(n2)) {
              const e3 = this.partLookup[n2];
              return e3 ? { height: e3.height, hidden: !!(e3.flags & tb) } : void 0;
            }
            for (const o2 of this.centroidData)
              e2 > o2.max.x || o2.min.x > e2 || t2 > o2.max.y || o2.min.y > t2 || this.footprintContainsPoint(e2, t2, o2) && o2 && o2.height > i2 && (i2 = o2.height, this.partLookup[n2] = o2, r2 = !!(o2.flags & tb));
            if (i2 !== Number.NEGATIVE_INFINITY)
              return { height: i2, hidden: r2 };
            this.partLookup[n2] = void 0;
          }
        }
        function pb(e2, t2) {
          const i2 = e2.add(t2)._unit();
          return e2.x * i2.x + e2.y * i2.y;
        }
        function fb(e2, t2, i2, r2) {
          const n2 = t2.sub(e2)._perp()._unit(), o2 = i2.sub(t2)._perp()._unit();
          return mb(e2, t2, i2, pb(n2, o2), r2);
        }
        function mb(e2, t2, i2, r2, n2) {
          const o2 = Math.sqrt(1 - r2 * r2);
          return Math.min(e2.dist(t2) / 3, t2.dist(i2) / 3, n2 * o2 / r2);
        }
        function _b(e2, t2, i2) {
          return e2.x < i2[0].x && t2.x < i2[0].x || e2.x > i2[1].x && t2.x > i2[1].x || e2.y < i2[0].y && t2.y < i2[0].y || e2.y > i2[1].y && t2.y > i2[1].y;
        }
        function gb(e2, t2) {
          return e2.x < t2[0].x || e2.x > t2[1].x || e2.y < t2[0].y || e2.y > t2[1].y;
        }
        function yb(e2, t2, i2) {
          if (e2.x < 0 || e2.x >= sr || t2.x < 0 || t2.x >= sr || i2.x < 0 || i2.x >= sr)
            return false;
          const r2 = i2.sub(t2), n2 = r2.perp(), o2 = e2.sub(t2);
          return (r2.x * o2.x + r2.y * o2.y) / Math.sqrt((r2.x * r2.x + r2.y * r2.y) * (o2.x * o2.x + o2.y * o2.y)) > -0.866 && n2.x * o2.x + n2.y * o2.y < 0;
        }
        function xb(e2, t2, i2) {
          const r2 = t2 ? 2 | e2 : -3 & e2;
          return i2 ? 1 | r2 : -2 & r2;
        }
        function vb() {
          const e2 = Math.PI / 32, t2 = Math.tan(e2), i2 = Od;
          return i2 * Math.sqrt(1 + 2 * t2 * t2) - i2;
        }
        function bb(e2, t2, i2) {
          const r2 = 1 << i2.z, n2 = $d(i2.x / r2), o2 = $d((i2.x + 1) / r2), s2 = Hd(i2.y / r2), a2 = Hd((i2.y + 1) / r2);
          return function(e3, t3, i3, r3, n3 = 0, o3) {
            const s3 = [];
            if (!e3.length || !i3 || !r3)
              return s3;
            const a3 = (e4, t4) => {
              for (const i4 of e4)
                s3.push({ polygon: i4, bounds: t4 });
            }, l2 = Math.ceil(Math.log2(i3)), c2 = Math.ceil(Math.log2(r3)), h2 = l2 - c2, u2 = [];
            for (let e4 = 0; e4 < Math.abs(h2); e4++)
              u2.push(h2 > 0 ? 0 : 1);
            for (let e4 = 0; e4 < Math.min(l2, c2); e4++)
              u2.push(0), u2.push(1);
            let d2 = e3;
            if (d2 = rm(d2, t3[0].y - n3, t3[1].y + n3, 1), d2 = rm(d2, t3[0].x - n3, t3[1].x + n3, 0), !d2.length)
              return s3;
            const p2 = [];
            for (u2.length ? p2.push({ polygons: d2, bounds: t3, depth: 0 }) : a3(d2, t3); p2.length; ) {
              const e4 = p2.pop(), t4 = e4.depth, i4 = u2[t4], r4 = e4.bounds[0], s4 = e4.bounds[1], l3 = 0 === i4 ? r4.x : r4.y, c3 = 0 === i4 ? s4.x : s4.y, h3 = o3 ? o3(i4, l3, c3) : 0.5 * (l3 + c3), d3 = rm(e4.polygons, l3 - n3, h3 + n3, i4), f2 = rm(e4.polygons, h3 - n3, c3 + n3, i4);
              if (d3.length) {
                const e5 = [r4, new y(0 === i4 ? h3 : s4.x, 1 === i4 ? h3 : s4.y)];
                u2.length > t4 + 1 ? p2.push({ polygons: d3, bounds: e5, depth: t4 + 1 }) : a3(d3, e5);
              }
              if (f2.length) {
                const e5 = [new y(0 === i4 ? h3 : r4.x, 1 === i4 ? h3 : r4.y), s4];
                u2.length > t4 + 1 ? p2.push({ polygons: f2, bounds: e5, depth: t4 + 1 }) : a3(f2, e5);
              }
            }
            return s3;
          }(e2, t2, Math.ceil((o2 - n2) / 11.25), Math.ceil((s2 - a2) / 11.25), 1, (e3, t3, n3) => {
            if (0 === e3)
              return 0.5 * (t3 + n3);
            {
              const e4 = Hd((i2.y + t3 / sr) / r2);
              return (qd(0.5 * (Hd((i2.y + n3 / sr) / r2) + e4)) * r2 - i2.y) * sr;
            }
          });
        }
        function wb(e2, t2, i2, r2, n2, o2) {
          const s2 = Math.pow(2, r2.z - n2.z);
          for (let a2 = 0; a2 < i2; a2++) {
            let i3 = e2.int16[2 * (a2 + t2) + 0], l2 = e2.int16[2 * (a2 + t2) + 1];
            i3 = (i3 + n2.x * sr) * s2 - r2.x * sr, l2 = (l2 + n2.y * sr) * s2 - r2.y * sr, o2.push(new y(i3, l2));
          }
        }
        Is(db, "FillExtrusionBucket", { omit: ["layers", "features"] }), Is(sb, "PartData"), Is(ob, "FootprintSegment"), Is(ab, "BorderCentroidData"), Is(ub, "GroundEffect");
        const Tb = new da({ visibility: new ca(Ct["layout_fill-extrusion"].visibility), "fill-extrusion-edge-radius": new ca(Ct["layout_fill-extrusion"]["fill-extrusion-edge-radius"]) });
        var Eb = { paint: new da({ "fill-extrusion-opacity": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-opacity"]), "fill-extrusion-color": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-color"]), "fill-extrusion-translate": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-translate"]), "fill-extrusion-translate-anchor": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]), "fill-extrusion-pattern": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-pattern"]), "fill-extrusion-height": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-height"]), "fill-extrusion-base": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-base"]), "fill-extrusion-vertical-gradient": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]), "fill-extrusion-ambient-occlusion-intensity": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]), "fill-extrusion-ambient-occlusion-radius": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]), "fill-extrusion-ambient-occlusion-wall-radius": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]), "fill-extrusion-ambient-occlusion-ground-radius": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]), "fill-extrusion-ambient-occlusion-ground-attenuation": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]), "fill-extrusion-flood-light-color": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]), "fill-extrusion-flood-light-intensity": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]), "fill-extrusion-flood-light-wall-radius": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]), "fill-extrusion-flood-light-ground-radius": new ha(Ct["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]), "fill-extrusion-flood-light-ground-attenuation": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]), "fill-extrusion-vertical-scale": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]), "fill-extrusion-rounded-roof": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]), "fill-extrusion-cutoff-fade-range": new ca(Ct["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]) }), layout: Tb };
        class Mb extends y {
          constructor(e2, t2, i2) {
            super(e2, t2), this.z = i2;
          }
        }
        function Ab(e2, t2) {
          return e2.x * t2.x + e2.y * t2.y;
        }
        function Sb(e2, t2) {
          if (1 === e2.length) {
            let i2 = 0;
            const r2 = t2[i2++];
            let n2;
            for (; !n2 || r2.equals(n2); )
              if (n2 = t2[i2++], !n2)
                return 1 / 0;
            for (; i2 < t2.length; i2++) {
              const o2 = t2[i2], s2 = e2[0], a2 = n2.sub(r2), l2 = o2.sub(r2), c2 = s2.sub(r2), h2 = Ab(a2, a2), u2 = Ab(a2, l2), d2 = Ab(l2, l2), p2 = Ab(c2, a2), f2 = Ab(c2, l2), m2 = h2 * d2 - u2 * u2, _2 = (d2 * p2 - u2 * f2) / m2, g2 = (h2 * f2 - u2 * p2) / m2, y2 = r2.z * (1 - _2 - g2) + n2.z * _2 + o2.z * g2;
              if (isFinite(y2))
                return y2;
            }
            return 1 / 0;
          }
          {
            let e3 = 1 / 0;
            for (const i2 of t2)
              e3 = Math.min(e3, i2.z);
            return e3;
          }
        }
        function Ib(e2, t2, i2, r2, n2, o2, s2, a2) {
          const l2 = s2 * n2.getElevationAt(e2, t2, true, true), c2 = 0 !== o2[0], h2 = c2 ? 0 === o2[1] ? s2 * (o2[0] / 7 - 450) : s2 * function(e3, t3, i3) {
            const r3 = Math.floor(t3[0] / 8), n3 = Math.floor(t3[1] / 8), o3 = 10 * (t3[0] - 8 * r3), s3 = 10 * (t3[1] - 8 * n3), a3 = e3.getElevationAt(r3, n3, true, true), l3 = e3.getMeterToDEM(i3), c3 = Math.floor(0.5 * (o3 * l3 - 1)), h3 = Math.floor(0.5 * (s3 * l3 - 1)), u2 = e3.tileCoordToPixel(r3, n3), d2 = 2 * c3 + 1, p2 = 2 * h3 + 1, f2 = function(e4, t4, i4, r4, n4) {
              return [e4.getElevationAtPixel(t4, i4, true), e4.getElevationAtPixel(t4 + n4, i4, true), e4.getElevationAtPixel(t4, i4 + n4, true), e4.getElevationAtPixel(t4 + r4, i4 + n4, true)];
            }(e3, u2.x - c3, u2.y - h3, d2, p2), m2 = Math.abs(f2[0] - f2[1]), _2 = Math.abs(f2[2] - f2[3]), g2 = Math.abs(f2[0] - f2[2]) + Math.abs(f2[1] - f2[3]), y2 = Math.min(0.25, 0.5 * l3 * (m2 + _2) / d2), x2 = Math.min(0.25, 0.5 * l3 * g2 / p2);
            return a3 + Math.max(y2 * o3, x2 * s3);
          }(n2, o2, a2) : l2;
          return { base: l2 + (0 === i2) ? -1 : i2, top: c2 ? Math.max(h2 + r2, l2 + i2 + 2) : l2 + r2 };
        }
        const Cb = new da({ "line-cap": new ha(Ct.layout_line["line-cap"]), "line-join": new ha(Ct.layout_line["line-join"]), "line-miter-limit": new ca(Ct.layout_line["line-miter-limit"]), "line-round-limit": new ca(Ct.layout_line["line-round-limit"]), "line-sort-key": new ha(Ct.layout_line["line-sort-key"]), visibility: new ca(Ct.layout_line.visibility) });
        var zb = { paint: new da({ "line-opacity": new ha(Ct.paint_line["line-opacity"]), "line-color": new ha(Ct.paint_line["line-color"]), "line-translate": new ca(Ct.paint_line["line-translate"]), "line-translate-anchor": new ca(Ct.paint_line["line-translate-anchor"]), "line-width": new ha(Ct.paint_line["line-width"]), "line-gap-width": new ha(Ct.paint_line["line-gap-width"]), "line-offset": new ha(Ct.paint_line["line-offset"]), "line-blur": new ha(Ct.paint_line["line-blur"]), "line-dasharray": new ha(Ct.paint_line["line-dasharray"]), "line-pattern": new ha(Ct.paint_line["line-pattern"]), "line-gradient": new ua(Ct.paint_line["line-gradient"]), "line-trim-offset": new ca(Ct.paint_line["line-trim-offset"]), "line-emissive-strength": new ca(Ct.paint_line["line-emissive-strength"]), "line-border-width": new ha(Ct.paint_line["line-border-width"]), "line-border-color": new ha(Ct.paint_line["line-border-color"]) }), layout: Cb };
        const Db = (e2, t2, i2, r2, n2, o2, s2) => {
          const a2 = e2.transform, l2 = a2.calculatePixelsToTileUnitsMatrix(t2);
          return { u_matrix: Lb(e2, t2, i2, r2), u_pixels_to_tile_units: l2, u_device_pixel_ratio: o2, u_units_to_pixels: [1 / a2.pixelsToGLUnits[0], 1 / a2.pixelsToGLUnits[1]], u_dash_image: 0, u_gradient_image: 1, u_image_height: n2, u_texsize: Ob(i2) ? t2.lineAtlasTexture.size : [0, 0], u_tile_units_to_pixels: Rb(t2, e2.transform), u_alpha_discard_threshold: 0, u_trim_offset: s2, u_emissive_strength: i2.paint.get("line-emissive-strength") };
        }, Pb = (e2, t2, i2, r2, n2) => {
          const o2 = e2.transform;
          return { u_matrix: Lb(e2, t2, i2, r2), u_texsize: t2.imageAtlasTexture.size, u_pixels_to_tile_units: o2.calculatePixelsToTileUnitsMatrix(t2), u_device_pixel_ratio: n2, u_image: 0, u_tile_units_to_pixels: Rb(t2, o2), u_units_to_pixels: [1 / o2.pixelsToGLUnits[0], 1 / o2.pixelsToGLUnits[1]], u_alpha_discard_threshold: 0 };
        };
        function Rb(e2, t2) {
          return 1 / Xx(e2, 1, t2.tileZoom);
        }
        function Lb(e2, t2, i2, r2) {
          return e2.translatePosMatrix(r2 || t2.tileID.projMatrix, t2, i2.paint.get("line-translate"), i2.paint.get("line-translate-anchor"));
        }
        const kb = (e2) => {
          const t2 = [];
          Ob(e2) && t2.push("RENDER_LINE_DASH"), e2.paint.get("line-gradient") && t2.push("RENDER_LINE_GRADIENT");
          const i2 = e2.paint.get("line-trim-offset");
          return 0 === i2[0] && 0 === i2[1] || t2.push("RENDER_LINE_TRIM_OFFSET"), 0 !== e2.paint.get("line-border-width").constantOr(1) && t2.push("RENDER_LINE_BORDER"), t2;
        };
        function Ob(e2) {
          const t2 = e2.paint.get("line-dasharray").value;
          return t2.value || "constant" !== t2.kind;
        }
        const Bb = new class extends ha {
          possiblyEvaluate(e2, t2) {
            return t2 = new ea(Math.floor(t2.zoom), { now: t2.now, fadeDuration: t2.fadeDuration, transition: t2.transition }), super.possiblyEvaluate(e2, t2);
          }
          evaluate(e2, t2, i2, r2) {
            return t2 = k({}, t2, { zoom: Math.floor(t2.zoom) }), super.evaluate(e2, t2, i2, r2);
          }
        }(zb.paint.properties["line-width"].specification);
        function Fb(e2, t2) {
          return t2 > 0 ? t2 + 2 * e2 : e2;
        }
        Bb.useIntegerZoom = true;
        const Nb = new da({ visibility: new ca(Ct.layout_background.visibility) });
        var Ub = { paint: new da({ "background-color": new ca(Ct.paint_background["background-color"]), "background-pattern": new ca(Ct.paint_background["background-pattern"]), "background-opacity": new ca(Ct.paint_background["background-opacity"]), "background-emissive-strength": new ca(Ct.paint_background["background-emissive-strength"]) }), layout: Nb };
        const Vb = new da({ visibility: new ca(Ct.layout_raster.visibility) });
        var jb = { paint: new da({ "raster-opacity": new ca(Ct.paint_raster["raster-opacity"]), "raster-color": new ua(Ct.paint_raster["raster-color"]), "raster-color-mix": new ca(Ct.paint_raster["raster-color-mix"]), "raster-color-range": new ca(Ct.paint_raster["raster-color-range"]), "raster-hue-rotate": new ca(Ct.paint_raster["raster-hue-rotate"]), "raster-brightness-min": new ca(Ct.paint_raster["raster-brightness-min"]), "raster-brightness-max": new ca(Ct.paint_raster["raster-brightness-max"]), "raster-saturation": new ca(Ct.paint_raster["raster-saturation"]), "raster-contrast": new ca(Ct.paint_raster["raster-contrast"]), "raster-resampling": new ca(Ct.paint_raster["raster-resampling"]), "raster-fade-duration": new ca(Ct.paint_raster["raster-fade-duration"]) }), layout: Vb };
        function Gb(e2, t2, i2, r2, n2, o2, s2, a2) {
          const l2 = [e2, i2, n2, t2, r2, o2, 1, 1, 1], c2 = [s2, a2, 1], h2 = gu.adjoint([], l2), [u2, d2, p2] = Mu.transformMat3(c2, c2, gu.transpose(h2, h2));
          return gu.multiply(l2, [u2, 0, 0, 0, d2, 0, 0, 0, p2], l2);
        }
        class qb extends It {
          constructor(e2, t2, i2, r2) {
            super(), this.id = e2, this.dispatcher = i2, this.coordinates = t2.coordinates, this.type = "image", this.minzoom = 0, this.maxzoom = 22, this.tileSize = 512, this.tiles = {}, this._loaded = false, this.onNorthPole = false, this.onSouthPole = false, this.setEventedParent(r2), this.options = t2, this._dirty = false;
          }
          load(e2, i2) {
            if (this._loaded = i2 || false, this.fire(new At("dataloading", { dataType: "source" })), this.url = this.options.url, !this.url)
              return e2 && (this.coordinates = e2), this._loaded = true, void this._finishLoading();
            this._imageRequest = Ie(this.map._requestManager.transformRequest(this.url, ye.Image), (i3, r2) => {
              if (this._imageRequest = null, this._loaded = true, i3)
                this.fire(new St(i3));
              else if (r2) {
                const { HTMLImageElement: i4 } = t;
                this.image = r2 instanceof i4 ? ht.getImageData(r2) : r2, this._dirty = true, this.width = this.image.width, this.height = this.image.height, e2 && (this.coordinates = e2), this._finishLoading();
              }
            });
          }
          loaded() {
            return this._loaded;
          }
          updateImage(e2) {
            return this.image && e2.url ? (this._imageRequest && e2.url !== this.options.url && (this._imageRequest.cancel(), this._imageRequest = null), this.options.url = e2.url, this.load(e2.coordinates, this._loaded), this) : this;
          }
          setTexture(e2) {
            if (!(e2.handle instanceof WebGLTexture))
              throw new Error("The provided handle is not a WebGLTexture instance");
            return this.texture = new yy(this.map.painter.context, e2.handle), this.width = e2.dimensions[0], this.height = e2.dimensions[1], this._dirty = false, this._loaded = true, this._finishLoading(), this;
          }
          _finishLoading() {
            this.map && (this.setCoordinates(this.coordinates), this.fire(new At("data", { dataType: "source", sourceDataType: "metadata" })));
          }
          onAdd(e2) {
            this.map = e2, this.load();
          }
          onRemove() {
            this._imageRequest && (this._imageRequest.cancel(), this._imageRequest = null), !this.texture || this.texture instanceof yy || this.texture.destroy();
          }
          setCoordinates(e2) {
            if (this.coordinates = e2, this._boundsArray = void 0, !e2.length)
              return this;
            this.onNorthPole = false, this.onSouthPole = false;
            let t2 = e2[0][1], i2 = e2[0][1];
            for (const r3 of e2)
              r3[1] > i2 && (i2 = r3[1]), r3[1] < t2 && (t2 = r3[1]);
            const r2 = (i2 + t2) / 2;
            if (r2 > Xd ? this.onNorthPole = true : r2 < -Xd && (this.onSouthPole = true), !this.onNorthPole && !this.onSouthPole) {
              const t3 = e2.map(ep.fromLngLat);
              this.tileID = function(e3) {
                let t4 = 1 / 0, i3 = 1 / 0, r3 = -1 / 0, n2 = -1 / 0;
                for (const o3 of e3)
                  t4 = Math.min(t4, o3.x), i3 = Math.min(i3, o3.y), r3 = Math.max(r3, o3.x), n2 = Math.max(n2, o3.y);
                const o2 = Math.max(r3 - t4, n2 - i3), s2 = Math.max(0, Math.floor(-Math.log(o2) / Math.LN2)), a2 = Math.pow(2, s2);
                return new ku(s2, Math.floor((t4 + r3) / 2 * a2), Math.floor((i3 + n2) / 2 * a2));
              }(t3), this.minzoom = this.maxzoom = this.tileID.z;
            }
            return this.fire(new At("data", { dataType: "source", sourceDataType: "content" })), this;
          }
          _clear() {
            this._boundsArray = void 0;
          }
          _prepareData(e2) {
            for (const e3 in this.tiles) {
              const t3 = this.tiles[e3];
              "loaded" !== t3.state && (t3.state = "loaded", t3.texture = this.texture);
            }
            if (this._boundsArray)
              return;
            const t2 = Tg(this.tileID, this.map.transform.projection), [i2, r2, n2, o2] = this.coordinates.map((e3) => {
              const i3 = t2.projection.project(e3[0], e3[1]);
              return Mg(t2, i3)._round();
            });
            this.perspectiveTransform = function(e3, t3, i3, r3, n3, o3, s3, a2, l2, c2) {
              const h2 = Gb(0, 0, e3, 0, 0, t3, e3, t3), u2 = Gb(i3, r3, n3, o3, s3, a2, l2, c2);
              return gu.multiply(u2, gu.adjoint(h2, h2), u2), [u2[6] / u2[8] * e3 / sr, u2[7] / u2[8] * t3 / sr];
            }(this.width, this.height, i2.x, i2.y, r2.x, r2.y, o2.x, o2.y, n2.x, n2.y);
            const s2 = this._boundsArray = new Ma();
            s2.emplaceBack(i2.x, i2.y, 0, 0), s2.emplaceBack(r2.x, r2.y, sr, 0), s2.emplaceBack(o2.x, o2.y, 0, sr), s2.emplaceBack(n2.x, n2.y, sr, sr), this.boundsBuffer && this.boundsBuffer.destroy(), this.boundsBuffer = e2.createVertexBuffer(s2, Ay.members), this.boundsSegments = dl.simpleSegment(0, 0, 4, 2);
          }
          prepare() {
            const e2 = 0 !== Object.keys(this.tiles).length;
            if (this.tileID && !e2)
              return;
            const t2 = this.map.painter.context, i2 = t2.gl;
            !this._dirty || this.texture instanceof yy || (this.texture ? this.texture.update(this.image) : (this.texture = new gy(t2, this.image, i2.RGBA), this.texture.bind(i2.LINEAR, i2.CLAMP_TO_EDGE)), this._dirty = false), e2 && this._prepareData(t2);
          }
          loadTile(e2, t2) {
            this.tileID && this.tileID.equals(e2.tileID.canonical) ? (this.tiles[String(e2.tileID.wrap)] = e2, e2.buckets = {}, t2(null)) : (e2.state = "errored", t2(null));
          }
          serialize() {
            return { type: "image", url: this.options.url, coordinates: this.coordinates };
          }
          hasTransition() {
            return false;
          }
        }
        class Zb extends _a {
          constructor(e2) {
            super(e2, {}), this.implementation = e2, e2.slot && (this.slot = e2.slot);
          }
          is3D() {
            return "3d" === this.implementation.renderingMode;
          }
          hasOffscreenPass() {
            return void 0 !== this.implementation.prerender;
          }
          isLayerDraped(e2) {
            return void 0 !== this.implementation.renderToTile;
          }
          shouldRedrape() {
            return !!this.implementation.shouldRerenderTiles && this.implementation.shouldRerenderTiles();
          }
          recalculate() {
          }
          updateTransitions() {
          }
          hasTransition() {
            return false;
          }
          serialize() {
          }
          onAdd(e2) {
            this.implementation.onAdd && this.implementation.onAdd(e2, e2.painter.context.gl);
          }
          onRemove(e2) {
            this.implementation.onRemove && this.implementation.onRemove(e2, e2.painter.context.gl);
          }
        }
        const $b = new da({ visibility: new ca(Ct.layout_sky.visibility) });
        var Hb = { paint: new da({ "sky-type": new ca(Ct.paint_sky["sky-type"]), "sky-atmosphere-sun": new ca(Ct.paint_sky["sky-atmosphere-sun"]), "sky-atmosphere-sun-intensity": new ca(Ct.paint_sky["sky-atmosphere-sun-intensity"]), "sky-gradient-center": new ca(Ct.paint_sky["sky-gradient-center"]), "sky-gradient-radius": new ca(Ct.paint_sky["sky-gradient-radius"]), "sky-gradient": new ua(Ct.paint_sky["sky-gradient"]), "sky-atmosphere-halo-color": new ca(Ct.paint_sky["sky-atmosphere-halo-color"]), "sky-atmosphere-color": new ca(Ct.paint_sky["sky-atmosphere-color"]), "sky-opacity": new ca(Ct.paint_sky["sky-opacity"]) }), layout: $b };
        function Wb(e2, t2, i2) {
          const r2 = [0, 0, 1], n2 = bu.identity([]);
          return bu.rotateY(n2, n2, i2 ? -w(e2) + Math.PI : w(e2)), bu.rotateX(n2, n2, -w(t2)), Mu.transformQuat(r2, r2, n2), Mu.normalize(r2, r2);
        }
        var Xb = { paint: new da({}) };
        const Yb = { circle: class extends _a {
          constructor(e2, t2) {
            super(e2, Pp, t2);
          }
          createBucket(e2) {
            return new dp(e2);
          }
          queryRadius(e2) {
            const t2 = e2;
            return Sp("circle-radius", this, t2) + Sp("circle-stroke-width", this, t2) + Ip(this.paint.get("circle-translate"));
          }
          queryIntersectsFeature(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = zp(this.paint.get("circle-translate"), this.paint.get("circle-translate-anchor"), o2.angle, e2.pixelToTileUnitsFactor), c2 = this.paint.get("circle-radius").evaluate(t2, i2) + this.paint.get("circle-stroke-width").evaluate(t2, i2);
            return Op(e2, r2, o2, s2, a2, "map" === this.paint.get("circle-pitch-alignment"), "map" === this.paint.get("circle-pitch-scale"), l2, c2);
          }
          getProgramIds() {
            return ["circle"];
          }
          getDefaultProgramParams(e2, t2) {
            const i2 = kp(this);
            return { config: new $l(this, t2), defines: i2, overrideFog: false };
          }
        }, heatmap: class extends _a {
          createBucket(e2) {
            return new Vp(e2);
          }
          constructor(e2, t2) {
            super(e2, Xp, t2), this._updateColorRamp();
          }
          _handleSpecialPaintPropertyUpdate(e2) {
            "heatmap-color" === e2 && this._updateColorRamp();
          }
          _updateColorRamp() {
            this.colorRamp = Yp({ expression: this._transitionablePaint._values["heatmap-color"].value.expression, evaluationKey: "heatmapDensity", image: this.colorRamp }), this.colorRampTexture = null;
          }
          resize() {
            this.heatmapFbo && (this.heatmapFbo.destroy(), this.heatmapFbo = null);
          }
          queryRadius(e2) {
            return Sp("heatmap-radius", this, e2);
          }
          queryIntersectsFeature(e2, t2, i2, r2, n2, o2, s2, a2) {
            const l2 = this.paint.get("heatmap-radius").evaluate(t2, i2);
            return Op(e2, r2, o2, s2, a2, true, true, new y(0, 0), l2);
          }
          hasOffscreenPass() {
            return 0 !== this.paint.get("heatmap-opacity") && "none" !== this.visibility;
          }
          getProgramIds() {
            return ["heatmap", "heatmapTexture"];
          }
          getDefaultProgramParams(e2, t2) {
            return "heatmap" === e2 ? { config: new $l(this, t2), overrideFog: false } : {};
          }
        }, hillshade: class extends _a {
          constructor(e2, t2) {
            super(e2, Jp, t2);
          }
          hasOffscreenPass() {
            return 0 !== this.paint.get("hillshade-exaggeration") && "none" !== this.visibility;
          }
          getProgramIds() {
            return ["hillshade", "hillshadePrepare"];
          }
          getDefaultProgramParams(e2, t2) {
            return { overrideFog: false };
          }
        }, fill: class extends _a {
          constructor(e2, t2) {
            super(e2, Of, t2);
          }
          getProgramIds() {
            const e2 = this.paint.get("fill-pattern"), t2 = e2 && e2.constantOr(1), i2 = [t2 ? "fillPattern" : "fill"];
            return this.paint.get("fill-antialias") && i2.push(t2 && !this.getPaintProperty("fill-outline-color") ? "fillOutlinePattern" : "fillOutline"), i2;
          }
          getDefaultProgramParams(e2, t2) {
            return { config: new $l(this, t2), overrideFog: false };
          }
          recalculate(e2, t2) {
            super.recalculate(e2, t2);
            const i2 = this.paint._values["fill-outline-color"];
            "constant" === i2.value.kind && void 0 === i2.value.value && (this.paint._values["fill-outline-color"] = this.paint._values["fill-color"]);
          }
          createBucket(e2) {
            return new Lf(e2);
          }
          queryRadius() {
            return Ip(this.paint.get("fill-translate"));
          }
          queryIntersectsFeature(e2, t2, i2, r2, n2, o2) {
            return !e2.queryGeometry.isAboveHorizon && mp(Cp(e2.tilespaceGeometry, this.paint.get("fill-translate"), this.paint.get("fill-translate-anchor"), o2.angle, e2.pixelToTileUnitsFactor), r2);
          }
          isTileClipped() {
            return true;
          }
        }, "fill-extrusion": class extends _a {
          constructor(e2, t2) {
            super(e2, Eb, t2);
          }
          createBucket(e2) {
            return new db(e2);
          }
          queryRadius() {
            return Ip(this.paint.get("fill-extrusion-translate"));
          }
          is3D() {
            return true;
          }
          hasShadowPass() {
            return true;
          }
          cutoffRange() {
            return this.paint.get("fill-extrusion-cutoff-fade-range");
          }
          canCastShadows() {
            return true;
          }
          getProgramIds() {
            return [this.paint.get("fill-extrusion-pattern").constantOr(1) ? "fillExtrusionPattern" : "fillExtrusion"];
          }
          queryIntersectsFeature(e2, t2, i2, r2, n2, o2, s2, a2, l2) {
            const c2 = zp(this.paint.get("fill-extrusion-translate"), this.paint.get("fill-extrusion-translate-anchor"), o2.angle, e2.pixelToTileUnitsFactor), h2 = this.paint.get("fill-extrusion-height").evaluate(t2, i2), u2 = this.paint.get("fill-extrusion-base").evaluate(t2, i2), d2 = [0, 0], p2 = a2 && o2.elevation, f2 = o2.elevation ? o2.elevation.exaggeration() : 1, m2 = e2.tile.getBucket(this);
            if (p2 && m2 instanceof db) {
              const e3 = m2.centroidVertexArray, t3 = l2 + 1;
              t3 < e3.length && (d2[0] = e3.geta_centroid_pos0(t3), d2[1] = e3.geta_centroid_pos1(t3));
            }
            if (0 === d2[0] && 1 === d2[1])
              return false;
            "globe" === o2.projection.name && (r2 = bb([r2], [new y(0, 0), new y(sr, sr)], e2.tileID.canonical).map((e3) => e3.polygon).flat());
            const _2 = p2 ? a2 : null, [g2, x2] = function(e3, t3, i3, r3, n3, o3, s3, a3, l3, c3, h3) {
              return "globe" === e3.projection.name ? function(e4, t4, i4, r4, n4, o4, s4, a4, l4, c4, h4) {
                const u3 = [], d3 = [], p3 = e4.projection.upVectorScale(h4, e4.center.lat, e4.worldSize).metersToTile, f3 = [0, 0, 0, 1], m3 = [0, 0, 0, 1], _3 = (e5, t5, i5, r5) => {
                  e5[0] = t5, e5[1] = i5, e5[2] = r5, e5[3] = 1;
                }, g3 = vb();
                i4 > 0 && (i4 += g3), r4 += g3;
                for (const g4 of t4) {
                  const t5 = [], y2 = [];
                  for (const u4 of g4) {
                    const d4 = u4.x + n4.x, g5 = u4.y + n4.y, x3 = e4.projection.projectTilePoint(d4, g5, h4), v3 = e4.projection.upVector(h4, u4.x, u4.y);
                    let b2 = i4, w2 = r4;
                    if (s4) {
                      const e5 = Ib(d4, g5, i4, r4, s4, a4, l4, c4);
                      b2 += e5.base, w2 += e5.top;
                    }
                    0 !== i4 ? _3(f3, x3.x + v3[0] * p3 * b2, x3.y + v3[1] * p3 * b2, x3.z + v3[2] * p3 * b2) : _3(f3, x3.x, x3.y, x3.z), _3(m3, x3.x + v3[0] * p3 * w2, x3.y + v3[1] * p3 * w2, x3.z + v3[2] * p3 * w2), Mu.transformMat4(f3, f3, o4), Mu.transformMat4(m3, m3, o4), t5.push(new Mb(f3[0], f3[1], f3[2])), y2.push(new Mb(m3[0], m3[1], m3[2]));
                  }
                  u3.push(t5), d3.push(y2);
                }
                return [u3, d3];
              }(e3, t3, i3, r3, n3, o3, s3, a3, l3, c3, h3) : s3 ? function(e4, t4, i4, r4, n4, o4, s4, a4, l4) {
                const c4 = [], h4 = [], u3 = [0, 0, 0, 1];
                for (const d3 of e4) {
                  const e5 = [], p3 = [];
                  for (const c5 of d3) {
                    const h5 = c5.x + r4.x, d4 = c5.y + r4.y, f3 = Ib(h5, d4, t4, i4, o4, s4, a4, l4);
                    u3[0] = h5, u3[1] = d4, u3[2] = f3.base, u3[3] = 1, uu.transformMat4(u3, u3, n4), u3[3] = Math.max(u3[3], 1e-5);
                    const m3 = new Mb(u3[0] / u3[3], u3[1] / u3[3], u3[2] / u3[3]);
                    u3[0] = h5, u3[1] = d4, u3[2] = f3.top, u3[3] = 1, uu.transformMat4(u3, u3, n4), u3[3] = Math.max(u3[3], 1e-5);
                    const _3 = new Mb(u3[0] / u3[3], u3[1] / u3[3], u3[2] / u3[3]);
                    e5.push(m3), p3.push(_3);
                  }
                  c4.push(e5), h4.push(p3);
                }
                return [c4, h4];
              }(t3, i3, r3, n3, o3, s3, a3, l3, c3) : function(e4, t4, i4, r4, n4) {
                const o4 = [], s4 = [], a4 = n4[8] * t4, l4 = n4[9] * t4, c4 = n4[10] * t4, h4 = n4[11] * t4, u3 = n4[8] * i4, d3 = n4[9] * i4, p3 = n4[10] * i4, f3 = n4[11] * i4;
                for (const t5 of e4) {
                  const e5 = [], i5 = [];
                  for (const o5 of t5) {
                    const t6 = o5.x + r4.x, s5 = o5.y + r4.y, m3 = n4[0] * t6 + n4[4] * s5 + n4[12], _3 = n4[1] * t6 + n4[5] * s5 + n4[13], g3 = n4[2] * t6 + n4[6] * s5 + n4[14], y2 = n4[3] * t6 + n4[7] * s5 + n4[15], x3 = m3 + a4, v3 = _3 + l4, b2 = g3 + c4, w2 = Math.max(y2 + h4, 1e-5), T2 = m3 + u3, E2 = _3 + d3, M2 = g3 + p3, A2 = Math.max(y2 + f3, 1e-5);
                    e5.push(new Mb(x3 / w2, v3 / w2, b2 / w2)), i5.push(new Mb(T2 / A2, E2 / A2, M2 / A2));
                  }
                  o4.push(e5), s4.push(i5);
                }
                return [o4, s4];
              }(t3, i3, r3, n3, o3);
            }(o2, r2, u2, h2, c2, s2, _2, d2, f2, o2.center.lat, e2.tileID.canonical), v2 = e2.queryGeometry;
            return function(e3, t3, i3) {
              let r3 = 1 / 0;
              mp(i3, t3) && (r3 = Sb(i3, t3[0]));
              for (let n3 = 0; n3 < t3.length; n3++) {
                const o3 = t3[n3], s3 = e3[n3];
                for (let e4 = 0; e4 < o3.length - 1; e4++) {
                  const t4 = o3[e4], n4 = [t4, o3[e4 + 1], s3[e4 + 1], s3[e4], t4];
                  pp(i3, n4) && (r3 = Math.min(r3, Sb(i3, n4)));
                }
              }
              return r3 !== 1 / 0 && r3;
            }(g2, x2, v2.isPointQuery() ? v2.screenBounds : v2.screenGeometry);
          }
        }, line: class extends _a {
          constructor(e2, t2) {
            super(e2, zb, t2), this.gradientVersion = 0;
          }
          _handleSpecialPaintPropertyUpdate(e2) {
            if ("line-gradient" === e2) {
              const e3 = this._transitionablePaint._values["line-gradient"].value.expression;
              this.stepInterpolant = e3._styleExpression && e3._styleExpression.expression instanceof Hr, this.gradientVersion = (this.gradientVersion + 1) % Number.MAX_SAFE_INTEGER;
            }
          }
          gradientExpression() {
            return this._transitionablePaint._values["line-gradient"].value.expression;
          }
          widthExpression() {
            return this._transitionablePaint._values["line-width"].value.expression;
          }
          recalculate(e2, t2) {
            super.recalculate(e2, t2), this.paint._values["line-floorwidth"] = Bb.possiblyEvaluate(this._transitioningPaint._values["line-width"].value, e2);
          }
          createBucket(e2) {
            return new _y(e2);
          }
          getProgramIds() {
            return [this.paint.get("line-pattern").constantOr(1) ? "linePattern" : "line"];
          }
          getDefaultProgramParams(e2, t2) {
            const i2 = kb(this);
            return { config: new $l(this, t2), defines: i2, overrideFog: false };
          }
          queryRadius(e2) {
            const t2 = e2, i2 = Fb(Sp("line-width", this, t2), Sp("line-gap-width", this, t2)), r2 = Sp("line-offset", this, t2);
            return i2 / 2 + Math.abs(r2) + Ip(this.paint.get("line-translate"));
          }
          queryIntersectsFeature(e2, t2, i2, r2, n2, o2) {
            if (e2.queryGeometry.isAboveHorizon)
              return false;
            const s2 = Cp(e2.tilespaceGeometry, this.paint.get("line-translate"), this.paint.get("line-translate-anchor"), o2.angle, e2.pixelToTileUnitsFactor), a2 = e2.pixelToTileUnitsFactor / 2 * Fb(this.paint.get("line-width").evaluate(t2, i2), this.paint.get("line-gap-width").evaluate(t2, i2)), l2 = this.paint.get("line-offset").evaluate(t2, i2);
            return l2 && (r2 = function(e3, t3) {
              const i3 = [], r3 = new y(0, 0);
              for (let n3 = 0; n3 < e3.length; n3++) {
                const o3 = e3[n3], s3 = [];
                for (let e4 = 0; e4 < o3.length; e4++) {
                  const i4 = o3[e4], n4 = o3[e4 + 1], a3 = 0 === e4 ? r3 : i4.sub(o3[e4 - 1])._unit()._perp(), l3 = e4 === o3.length - 1 ? r3 : n4.sub(i4)._unit()._perp(), c2 = a3._add(l3)._unit();
                  c2._mult(1 / (c2.x * l3.x + c2.y * l3.y)), s3.push(c2._mult(t3)._add(i4));
                }
                i3.push(s3);
              }
              return i3;
            }(r2, l2 * e2.pixelToTileUnitsFactor)), function(e3, t3, i3) {
              for (let r3 = 0; r3 < t3.length; r3++) {
                const n3 = t3[r3];
                if (e3.length >= 3) {
                  for (let t4 = 0; t4 < n3.length; t4++)
                    if (wp(e3, n3[t4]))
                      return true;
                }
                if (_p(e3, n3, i3))
                  return true;
              }
              return false;
            }(s2, r2, a2);
          }
          isTileClipped() {
            return true;
          }
        }, symbol: Kg, background: class extends _a {
          constructor(e2, t2) {
            super(e2, Ub, t2);
          }
          getProgramIds() {
            return [this.paint.get("background-pattern") ? "backgroundPattern" : "background"];
          }
          getDefaultProgramParams(e2, t2) {
            return { overrideFog: false };
          }
        }, raster: class extends _a {
          constructor(e2, t2) {
            super(e2, jb, t2), this._updateColorRamp();
          }
          getProgramIds() {
            return ["raster"];
          }
          hasColorMap() {
            return !!this._transitionablePaint._values["raster-color"].value.value;
          }
          isLayerDraped(e2) {
            return !(e2 && e2._source instanceof qb && (e2._source.onNorthPole || e2._source.onSouthPole));
          }
          _handleSpecialPaintPropertyUpdate(e2) {
            "raster-color" !== e2 && "raster-color-range" !== e2 || this._updateColorRamp();
          }
          _updateColorRamp() {
            if (!this.hasColorMap())
              return;
            const e2 = this._transitionablePaint._values["raster-color"].value.expression, [t2, i2] = this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({ zoom: 0 });
            this.colorRamp = Yp({ expression: e2, evaluationKey: "rasterValue", image: this.colorRamp, clips: [{ start: t2, end: i2 }], resolution: 256 }), this.colorRampTexture = null;
          }
        }, sky: class extends _a {
          constructor(e2, t2) {
            super(e2, Hb, t2), this._updateColorRamp();
          }
          _handleSpecialPaintPropertyUpdate(e2) {
            "sky-gradient" === e2 ? this._updateColorRamp() : "sky-atmosphere-sun" !== e2 && "sky-atmosphere-halo-color" !== e2 && "sky-atmosphere-color" !== e2 && "sky-atmosphere-sun-intensity" !== e2 || (this._skyboxInvalidated = true);
          }
          _updateColorRamp() {
            this.colorRamp = Yp({ expression: this._transitionablePaint._values["sky-gradient"].value.expression, evaluationKey: "skyRadialProgress" }), this.colorRampTexture && (this.colorRampTexture.destroy(), this.colorRampTexture = null);
          }
          needsSkyboxCapture(e2) {
            if (this._skyboxInvalidated || !this.skyboxTexture || !this.skyboxGeometry)
              return true;
            if (!this.paint.get("sky-atmosphere-sun")) {
              const t2 = e2.style.light.properties.get("position");
              return this._lightPosition.azimuthal !== t2.azimuthal || this._lightPosition.polar !== t2.polar;
            }
            return false;
          }
          getCenter(e2, t2) {
            if ("atmosphere" === this.paint.get("sky-type")) {
              const i3 = this.paint.get("sky-atmosphere-sun"), r2 = !i3, n2 = e2.style.light, o2 = n2.properties.get("position");
              return r2 && "viewport" === n2.properties.get("anchor") && W("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."), r2 ? Wb(o2.azimuthal, 90 - o2.polar, t2) : Wb(i3[0], 90 - i3[1], t2);
            }
            const i2 = this.paint.get("sky-gradient-center");
            return Wb(i2[0], 90 - i2[1], t2);
          }
          isSky() {
            return true;
          }
          markSkyboxValid(e2) {
            this._skyboxInvalidated = false, this._lightPosition = e2.style.light.properties.get("position");
          }
          hasOffscreenPass() {
            return true;
          }
          getProgramIds() {
            const e2 = this.paint.get("sky-type");
            return "atmosphere" === e2 ? ["skyboxCapture", "skybox"] : "gradient" === e2 ? ["skyboxGradient"] : null;
          }
        }, slot: class extends _a {
          constructor(e2, t2) {
            super(e2, Xb);
          }
        }, model: class extends _a {
          constructor(e2, t2) {
            super(e2, Dv, t2);
          }
          createBucket(e2) {
            return new Cv(e2);
          }
          getProgramIds() {
            return ["model"];
          }
          is3D() {
            return true;
          }
          hasShadowPass() {
            return true;
          }
          canCastShadows() {
            return true;
          }
          hasLightBeamPass() {
            return true;
          }
          cutoffRange() {
            return this.paint.get("model-cutoff-fade-range");
          }
          queryRadius() {
            return 0;
          }
          queryIntersectsFeature() {
            return false;
          }
          _handleOverridablePaintPropertyUpdate(e2, t2, i2) {
            return !(!this.layout || t2.isDataDriven() || i2.isDataDriven() || "model-color" !== e2 && "model-color-mix-intensity" !== e2 && "model-rotation" !== e2 && "model-scale" !== e2 && "model-translation" !== e2 && "model-emissive-strength" !== e2);
          }
          _isPropertyZoomDependent(e2) {
            const t2 = this._transitionablePaint._values[e2];
            return null != t2 && null != t2.value && null != t2.value.expression && t2.value.expression instanceof bo;
          }
          isZoomDependent() {
            return this._isPropertyZoomDependent("model-scale") || this._isPropertyZoomDependent("model-rotation") || this._isPropertyZoomDependent("model-translation");
          }
        } };
        function Kb(e2, t2) {
          return "custom" === e2.type ? new Zb(e2) : new Yb[e2.type](e2, t2);
        }
        function Jb(e2) {
          const { userImage: t2 } = e2;
          return !!(t2 && t2.render && t2.render()) && (e2.data.replace(new Uint8Array(t2.data.buffer)), true);
        }
        class Qb extends It {
          constructor() {
            super(), this.images = {}, this.updatedImages = {}, this.callbackDispatchedThisFrame = {}, this.loaded = {}, this.requestors = [], this.patterns = {}, this.atlasImage = {}, this.atlasTexture = {}, this.dirty = true;
          }
          createScope(e2) {
            this.images[e2] = {}, this.loaded[e2] = false, this.updatedImages[e2] = {}, this.patterns[e2] = {}, this.callbackDispatchedThisFrame[e2] = {}, this.atlasImage[e2] = new $p({ width: 1, height: 1 });
          }
          isLoaded() {
            for (const e2 in this.loaded)
              if (!this.loaded[e2])
                return false;
            return true;
          }
          setLoaded(e2, t2) {
            if (this.loaded[t2] !== e2 && (this.loaded[t2] = e2, e2)) {
              for (const { ids: e3, callback: i2 } of this.requestors)
                this._notify(e3, t2, i2);
              this.requestors = [];
            }
          }
          hasImage(e2, t2) {
            return !!this.getImage(e2, t2);
          }
          getImage(e2, t2) {
            return this.images[t2][e2];
          }
          addImage(e2, t2, i2) {
            this._validate(e2, i2) && (this.images[t2][e2] = i2);
          }
          _validate(e2, t2) {
            let i2 = true;
            return this._validateStretch(t2.stretchX, t2.data && t2.data.width) || (this.fire(new St(new Error(`Image "${e2}" has invalid "stretchX" value`))), i2 = false), this._validateStretch(t2.stretchY, t2.data && t2.data.height) || (this.fire(new St(new Error(`Image "${e2}" has invalid "stretchY" value`))), i2 = false), this._validateContent(t2.content, t2) || (this.fire(new St(new Error(`Image "${e2}" has invalid "content" value`))), i2 = false), i2;
          }
          _validateStretch(e2, t2) {
            if (!e2)
              return true;
            let i2 = 0;
            for (const r2 of e2) {
              if (r2[0] < i2 || r2[1] < r2[0] || t2 < r2[1])
                return false;
              i2 = r2[1];
            }