@php
$customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Register Basic - Pages')

@section('vendor-style')
@vite([
'resources/assets/vendor/libs/@form-validation/form-validation.scss'
])
@endsection

@section('page-style')
@vite([
'resources/assets/vendor/scss/pages/page-auth.scss'
])
@endsection

@section('vendor-script')
@vite([
'resources/assets/vendor/libs/@form-validation/popular.js',
'resources/assets/vendor/libs/@form-validation/bootstrap5.js',
'resources/assets/vendor/libs/@form-validation/auto-focus.js'
])
@endsection

@section('page-script')
@vite([
'resources/assets/js/pages-auth.js'
])
@endsection

@section('content')
<div class="container-xxl">
  <div class="authentication-wrapper authentication-basic container-p-y">
    <div class="authentication-inner py-6">

      <!-- Register Card -->
      <div class="card">
        <div class="card-body">
          <!-- Logo -->
          <div class="app-brand justify-content-center mb-6">
            <a href="{{url('/')}}" class="app-brand-link">
              <span class="app-brand-logo demo">@include('_partials.macros',['height'=>20,'withbg' => "fill: #fff;"])</span>
            </a>
          </div>
          <!-- /Logo -->
          <p class="mb-6">سجل الان لفتح تذكرة</p>
          @if ($errors->any())
          <div class="alert alert-danger">
            <ul>
              @foreach ($errors->all() as $error)
              <li class="text-danger">{{ $error }}</li>
              @endforeach
            </ul>
          </div>
          @endif

          @if (session('success'))
          <div class="alert alert-success">
            {{ session('success') }}
          </div>
          @endif

          <form id="formAuthentication" class="mb-6" action="{{url('/auth/register')}}" method="post">
            @csrf
            <div class="mb-6">
              <label for="name" class="form-label">الاسم كامل</label>
              <input type="text" class="form-control" id="name" name="name" placeholder="ادخل اسمك" autofocus>
            </div>
            <div class="mb-6">
              <label for="email" class="form-label">البريد الالكتروني</label>
              <input type="email" class="form-control" id="email" name="email" placeholder="ادخل بريدك الالكتروني">
            </div>
            <div class="mb-6">
              <label for="phone" class="form-label">رقم الهاتف</label>
              <input type="text" class="form-control" id="phone" name="phone_number" placeholder="رقم الهاتف">
            </div>
            <div class="mb-6">
              <label for="department" class="form-label">القسم</label>
              <select id="department" class="select2 form-select" name="department">
                <option value="Customer Service">خدمة العملاء</option>
                <option value="Operations">العمليات</option>
                <option value="Sales and Marketing">المبيعات والتسويق</option>
                <option value="IT">تكنولوجيا المعلومات</option>
                <option value="Finance and Accounting">المالية والمحاسبة</option>
                <option value="HR">الموارد البشرية</option>
              </select>
            </div>
            <div class="mb-6 form-password-toggle">
              <label class="form-label" for="password">كلمة المرور</label>
              <div class="input-group input-group-merge">
                <input type="password" id="password" class="form-control" name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
              </div>
            </div>
            <div class="mb-6 form-password-toggle">
              <label class="form-label" for="password">تأكيد كلمة المرور</label>
              <div class="input-group input-group-merge">
                <input type="password" id="confirm-password" class="form-control" name="password_confirmation" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
              </div>
            </div>

            <button class="btn btn-primary d-grid w-100">
              التسجيل
            </button>
          </form>

          <p class="text-center">
            <span>لديك حساب؟</span>
            <a href="{{url('auth/login')}}">
              <span>سجل الدخول</span>
            </a>
          </p>

        </div>
      </div>
      <!-- Register Card -->
    </div>
  </div>
</div>
@endsection