@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Home')

@section('content')

<div class="container">
    <h1 class="mb-4 text-center text-primary">لوحة التحكم</h1>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>إجمالي التذاكر</h5>
                    <h2 class="text-primary">{{ $totalTickets }}</h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>التذاكر المفتوحة</h5>
                    <h2 class="text-warning">{{ $openTickets }}</h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>التذاكر المغلقة</h5>
                    <h2 class="text-success">{{ $closedTickets }}</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-lg">
        <div class="card-header bg-secondary text-white">
            <h5 class="text-white">التذاكر المفتوحة</h5>
        </div>
        <div class="card-body mt-4">
            @if ($openTicketsList->isEmpty())
                <p class="text-muted">لا توجد تذاكر مفتوحة.</p>
            @else
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>المعرف</th>
                            <th>العنوان</th>
                            <th>الحالة</th>
                            <th>الأولوية</th>
                            <th>رقم الموظف</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($openTicketsList as $ticket)
                            <tr>
                                <td>{{ $ticket->id }}</td>
                                <td>{{ $ticket->title }}</td>
                                <td>{{ ucfirst($ticket->status) }}</td>
                                <td>{{ ucfirst($ticket->priority) }}</td>
                                <td>{{ $ticket->employee_id }}</td>
                                <td>
                                    <a href="{{ route('tickets.show', $ticket->id) }}" class="btn btn-info btn-sm">عرض</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>
@endsection