<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4 text-center">تفاصيل التذكرة</h1>

    <div class="card shadow-lg mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="text-white">التفاصيل</h5>
        </div>
        <div class="card-body mt-3">
            <p><strong>العنوان:</strong> <?php echo e($ticket->title); ?></p>
            <p><strong>الوصف:</strong> <?php echo e($ticket->description); ?></p>
            <p><strong>الحالة:</strong> <?php echo e(ucfirst($ticket->status)); ?></p>
            <p><strong>الأولوية:</strong> <?php echo e(ucfirst($ticket->priority)); ?></p>
            <p><strong>رقم الموظف:</strong> <?php echo e($ticket->employee->name); ?></p>
            <p><strong>المنتج:</strong> <?php echo e($ticket->product->name); ?></p>
            <?php if($ticket->file_path): ?>
            <p><strong>الملف:</strong> <a href="<?php echo e(asset('storage/' . $ticket->file_path)); ?>" target="_blank">تحميل</a></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="card shadow-lg mb-4">
        <div class="card-header bg-secondary ">
            <h5 class="text-white">تحديث الحالة</h5>
        </div>
        <div class="card-body mt-4">
            <form action="<?php echo e(route('tickets.status.update', $ticket->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="mb-3">
                    <label for="status" class="form-label">الحالة</label>
                    <select name="status" id="status" class="form-select">
                        <option value="open" <?php echo e($ticket->status == 'open' ? 'selected' : ''); ?>>مفتوح</option>
                        <option value="in progress" <?php echo e($ticket->status == 'in progress' ? 'selected' : ''); ?>>قيد التنفيذ</option>
                        <option value="closed" <?php echo e($ticket->status == 'closed' ? 'selected' : ''); ?>>مغلق</option>
                        <option value="escalated" <?php echo e($ticket->status == 'escalated' ? 'selected' : ''); ?>>تم التصعيد</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">تحديث الحالة</button>
            </form>
        </div>
    </div>

    <div class="card shadow-lg">
        <div class="card-header bg-success text-white">
            <h5 class="text-white">التعليقات</h5>
        </div>
        <div class="card-body mt-4">
            <form action="<?php echo e(route('tickets.comments.add', $ticket->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label for="comment" class="form-label">إضافة تعليق</label>
                    <textarea name="comment" id="comment" class="form-control" rows="3" required></textarea>
                </div>
                <button type="submit" class="btn btn-success">إضافة تعليق</button>
            </form>

            <hr>

            <?php if($ticket->comments->isEmpty()): ?>
            <p>لا توجد تعليقات حتى الآن.</p>
            <?php else: ?>
            <ul class="list-group">
                <?php $__currentLoopData = $ticket->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item">
                    <p><strong><?php echo e($comment->user->name); ?></strong> (<?php echo e($comment->created_at->format('Y-m-d H:i')); ?>)</p>
                    <p><?php echo e($comment->comment); ?></p>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/munaalboashi/Desktop/Apps/vnx-it-support/resources/views/content/pages/tickets/show.blade.php ENDPATH**/ ?>