<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <h1 class="mb-4 text-center text-primary">لوحة التحكم</h1>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>إجمالي التذاكر</h5>
                    <h2 class="text-primary"><?php echo e($totalTickets); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>التذاكر المفتوحة</h5>
                    <h2 class="text-warning"><?php echo e($openTickets); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h5>التذاكر المغلقة</h5>
                    <h2 class="text-success"><?php echo e($closedTickets); ?></h2>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-lg">
        <div class="card-header bg-secondary text-white">
            <h5 class="text-white">التذاكر المفتوحة</h5>
        </div>
        <div class="card-body mt-4">
            <?php if($openTicketsList->isEmpty()): ?>
                <p class="text-muted">لا توجد تذاكر مفتوحة.</p>
            <?php else: ?>
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>المعرف</th>
                            <th>العنوان</th>
                            <th>الحالة</th>
                            <th>الأولوية</th>
                            <th>رقم الموظف</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $openTicketsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($ticket->id); ?></td>
                                <td><?php echo e($ticket->title); ?></td>
                                <td><?php echo e(ucfirst($ticket->status)); ?></td>
                                <td><?php echo e(ucfirst($ticket->priority)); ?></td>
                                <td><?php echo e($ticket->employee_id); ?></td>
                                <td>
                                    <a href="<?php echo e(route('tickets.show', $ticket->id)); ?>" class="btn btn-info btn-sm">عرض</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/munaalboashi/Desktop/Apps/vnx-it-support/resources/views/content/pages/pages-home.blade.php ENDPATH**/ ?>