<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Tickets</h1>

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('tickets')); ?>" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <select name="exact[status]" class="form-control">
                            <option value="">اختر الحالة</option>
                            <option value="open">مفتوح</option>
                            <option value="in progress">قيد التنفيذ</option>
                            <option value="closed">مغلق</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="exact[priority]" class="form-control">
                            <option value="">اختر الأولوية</option>
                            <option value="low">منخفضة</option>
                            <option value="medium">متوسطة</option>
                            <option value="high">عالية</option>
                            <option value="critical">حرجة</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="number" name="exact[employee.phone]" class="form-control" placeholder="رقم هاتف الموظف">
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-primary">Filter</button>
                    </div>
                </div>

            </form>

        </div>
    </div>




    <div class="card">

        <div class="card-body">
            <div class="d-flex justify-content-end mb-3">
                <a href="<?php echo e(route('tickets.create')); ?>" class="btn btn-success">+ إضافة تذكرة</a>
            </div>
            <?php if($tickets->isEmpty()): ?>
            <div class="alert alert-info text-center" role="alert">
                لا يوجد تذاكر
            </div>
            <?php else: ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Employee ID</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($ticket->id); ?></td>
                        <td><?php echo e($ticket->title); ?></td>
                        <td><?php echo e($ticket->status); ?></td>
                        <td><?php echo e($ticket->priority); ?></td>
                        <td><?php echo e($ticket->employee_id); ?></td>
                        <td><?php echo e($ticket->created_at); ?></td>
                        <td>
                            <a href="<?php echo e(route('tickets.show', $ticket->id)); ?>" class="btn btn-info btn-sm">عرض</a>
                            <a href="<?php echo e(route('tickets.edit', $ticket->id)); ?>" class="btn btn-warning btn-sm">تعديل</a>
                            <form action="<?php echo e(route('tickets.destroy', $ticket->id)); ?>" method="POST" style="display: inline-block;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد أنك تريد حذف هذه التذكرة؟')">مسح</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/munaalboashi/Desktop/Apps/vnx-it-support/resources/views/content/pages/tickets/index.blade.php ENDPATH**/ ?>